      SUBROUTINE COPYBF(LUNIN,LUNOT)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    COPYBF
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS SUBROUTINE COPIES AN ENTIRE BUFR FILE FROM LOGICAL
C   UNIT LUNIN TO LOGICAL UNIT LUNOT.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
C                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
C                           ROUTINE "BORT"
C 2000-09-19  J. WOOLLEN -- MAXIMUM MESSAGE LENGTH INCREASED FROM
C                           10,000 TO 20,000 BYTES
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
C                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
C                           TERMINATES ABNORMALLY
C 2004-08-09  J. ATOR    -- MAXIMUM MESSAGE LENGTH INCREASED FROM
C                           20,000 TO 50,000 BYTES
C 2005-11-29  J. ATOR    -- USE RDMSGW AND NMWRD
C
C USAGE:    CALL COPYBF (LUNIN, LUNOT)
C   INPUT ARGUMENT LIST:
C     LUNIN    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR INPUT BUFR
C                FILE
C     LUNOT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR OUTPUT BUFR
C                FILE
C
C   INPUT FILES:
C     UNIT "LUNIN" - BUFR FILE
C
C   OUTPUT FILES:
C     UNIT "LUNOT" - BUFR FILE
C
C REMARKS:
C    THIS ROUTINE CALLS:        BORT     NMWRD    RDMSGW   STATUS
C                               WRDLEN
C    THIS ROUTINE IS CALLED BY: None
C                               Normally called only by application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      INCLUDE 'bufrlib.prm'

      DIMENSION   MBAY(MXMSGLD4)

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C  CALL SUBROUTINE WRDLEN TO INITIALIZE SOME IMPORTANT INFORMATION
C  ABOUT THE LOCAL MACHINE (IN CASE IT HAS NOT YET BEEN CALLED)
C  ---------------------------------------------------------------

      CALL WRDLEN

C  CHECK BUFR FILE STATUSES
C  ------------------------

      CALL STATUS(LUNIN,LUN,IL,IM)
      IF(IL.NE.0) GOTO 900
      CALL STATUS(LUNOT,LUN,IL,IM)
      IF(IL.NE.0) GOTO 901

      REWIND(LUNIN)
      REWIND(LUNOT)

C  READ AND COPY A BUFR FILE ON UNIT LUNIN TO UNIT LUNOT
C  -----------------------------------------------------

1     CALL RDMSGW(LUNIN,MBAY,IER)
      IF(IER.EQ.-1) GOTO 2
      IF(IER.EQ.-2) GOTO 902
      WRITE(LUNOT,ERR=903) (MBAY(I),I=1,NMWRD(MBAY))
      GOTO 1

2     CLOSE(LUNIN)
      CLOSE(LUNOT)

C  EXITS
C  -----

      RETURN
900   CALL BORT
     . ('BUFRLIB: COPYBF - INPUT BUFR FILE IS OPEN, IT MUST BE CLOSED')
901   CALL BORT
     . ('BUFRLIB: COPYBF - OUTPUT BUFR FILE IS OPEN, IT MUST BE CLOSED')
902   CALL BORT('BUFRLIB: COPYBF - ERROR READING BUFR FILE')
903   CALL BORT('BUFRLIB: COPYBF - ERROR WRITING BUFR FILE')
      END
