MODULE module_mm5

!------------------------------------------------------------------------------!
! MM5 parameters and reference height/pressure calculation functions
!------------------------------------------------------------------------------!
       INTEGER                   :: maxnes
       INTEGER                   :: idd
       INTEGER                   :: iproj
       INTEGER                   :: ixc,   jxc

       REAL                      :: ptop, ps0, ts0, tlp
       REAL                      :: htop

       REAL                      :: phic, xlonc, truelat1, truelat2
       REAL                      :: xn, pole, psi1,  c2, xcntr, ycntr

       INTEGER, DIMENSION (10)   :: nestix, nestjx, nesti, nestj, numc
       REAL,    DIMENSION (10)   :: dis, xim11, xjm11

!------------------------------------------------------------------------------!

   logical :: domain_check_h = .TRUE.
   logical :: user_defined_area
   real    :: x_left,   x_right, &
              y_bottom, y_top

!------------------------------------------------------------------------------!
CONTAINS

FUNCTION ref_height (pres) RESULT (height)

!------------------------------------------------------------------------------!
!  PURPOSE: To calculate the height from the reference pressure
!
!  METHOD:  MM5 tutorial notes
!
!  HISTORY: 05/11/00                                    Yong-Run Guo
!
!  PARENT_MODULE: DA_Gpspw
!------------------------------------------------------------------------------

   IMPLICIT NONE

   INCLUDE 'constants.inc'

   REAL, PARAMETER  :: RGAS = gasr, &
                       GRAV = g

   REAL, INTENT(IN) :: pres
   REAL             :: height

   REAL             :: aa, bb, cc, dd
!------------------------------------------------------------------------------!

   cc = alog(pres/ps0)
   bb = RGAS * ts0 / GRAV
   aa = RGAS * tlp / (2.*GRAV)

   height = -( bb * cc + aa * cc * cc)

END FUNCTION Ref_height

FUNCTION ref_pres (height) Result (pres)
!------------------------------------------------------------------------------!
!  PURPOSE: To calculate the reference pressure from the height.
!
!  METHOD:  MM5 tutorial notes
!
!  HISTORY: 05/11/00                                    Yong-Run Guo
!
!  PARENT_MODULE: DA_Gpspw
!------------------------------------------------------------------------------!

   IMPLICIT NONE

   INCLUDE 'constants.inc'

   REAL, PARAMETER :: RGAS = gasr, &
                      GRAV = g

   REAL, INTENT(IN) :: height
   REAL             :: pres

   REAL             :: aa, bb, dd, hh
!------------------------------------------------------------------------------!


   bb = RGAS * ts0 / GRAV
   aa = RGAS * tlp / (2.*GRAV)

   IF (htop .GT. 0.) THEN
       hh = min (htop, height)
   ELSE
       hh = height
   ENDIF

   dd = (-bb + sqrt(bb * bb - 4.0 * aa * hh))/(2.0*aa)

   pres = ps0 * exp( dd )

END FUNCTION ref_pres
!==============================================================================!
END MODULE module_mm5
