//#define ENABLE_OPCOUNT
//#define BOUNDS_CHECK
//#define REORDER_EXEC

// NSPEC - Number of chemical species
#define NSPEC  61
// NVAR - Number of Variable species
#define NVAR  59
// NVARACT - Number of Active species
#define NVARACT  55
// NFIX - Number of Fixed species
#define NFIX  2
// NREACT - Number of reactions
#define NREACT  156
// NVARST - Starting of variables in conc. vect.
#define NVARST  1
// NFIXST - Starting of fixed in conc. vect.
#define NFIXST  60
// NONZERO - Number of nonzero entries in Jacobian
#define NONZERO  572
// LU_NONZERO - Number of nonzero entries in LU factoriz. of Jacobian
#define LU_NONZERO  659
// CNVAR - (NVAR+1) Number of elements in compressed row format
#define CNVAR  60
// NLOOKAT - Number of species to look at
#define NLOOKAT  0
// NMONITOR - Number of species to monitor
#define NMONITOR  0
// NMASS - Number of atoms to check mass balance

#define Max_no_steps 100000

#define ROS_S 3
#define SCRATCH_SIZE 560

#define INTBITS (sizeof(int)*8)

#define NMASS  1

// PI - Value of pi
#define PI 3.14159265358979.e0

#define NJV 28

#define  Pj_o31d  0
#define  Pj_o33p  1
#define  Pj_no2  2
#define  Pj_no3o2  3
#define  Pj_no3o  4
#define  Pj_hno2  5
#define  Pj_hno3  6
#define  Pj_hno4  7
#define  Pj_h2o2  8
#define  Pj_ch2or  9
#define  Pj_ch2om  10
#define  Pj_ch3cho  11
#define  Pj_ch3coch3  12
#define  Pj_ch3coc2h5  13
#define  Pj_hcocho  14
#define  Pj_ch3cocho  15
#define  Pj_hcochest  16
#define  Pj_ch3o2h  17
#define  Pj_ch3coo2h  18
#define  Pj_ch3ono2  19
#define  Pj_hcochob  20
#define  Pj_macr  21
#define  Pj_n2o5  22
#define  Pj_o2  23
#define  Pj_pan  24
#define  Pj_acet  25
#define  Pj_mglo  26
#define  Pj_hno4_2  27


#define ind_SULF  (1-1)
#define ind_ORA1  (2-1)
#define ind_ORA2  (3-1)
#define ind_CO2  (4-1)
#define ind_SO2  (5-1)
#define ind_ETH  (6-1)
#define ind_O1D  (7-1)
#define ind_HC5  (8-1)
#define ind_HC8  (9-1)
#define ind_TOL  (10-1)
#define ind_XYL  (11-1)
#define ind_TPAN  (12-1)
#define ind_HONO  (13-1)
#define ind_H2O2  (14-1)
#define ind_N2O5  (15-1)
#define ind_HC3  (16-1)
#define ind_CH4  (17-1)
#define ind_PAA  (18-1)
#define ind_O3P  (19-1)
#define ind_HNO4  (20-1)
#define ind_OP1  (21-1)
#define ind_CSL  (22-1)
#define ind_PAN  (23-1)
#define ind_OL2  (24-1)
#define ind_HNO3  (25-1)
#define ind_CO  (26-1)
#define ind_ISO  (27-1)
#define ind_OLT  (28-1)
#define ind_OLI  (29-1)
#define ind_DCB  (30-1)
#define ind_GLY  (31-1)
#define ind_XNO2  (32-1)
#define ind_KET  (33-1)
#define ind_MGLY  (34-1)
#define ind_TOLP  (35-1)
#define ind_XYLP  (36-1)
#define ind_OLTP  (37-1)
#define ind_OLN  (38-1)
#define ind_XO2  (39-1)
#define ind_OL2P  (40-1)
#define ind_HC5P  (41-1)
#define ind_OP2  (42-1)
#define ind_HCHO  (43-1)
#define ind_HC8P  (44-1)
#define ind_TCO3  (45-1)
#define ind_O3  (46-1)
#define ind_ONIT  (47-1)
#define ind_ALD  (48-1)
#define ind_OLIP  (49-1)
#define ind_KETP  (50-1)
#define ind_HO2  (51-1)
#define ind_MO2  (52-1)
#define ind_OH  (53-1)
#define ind_NO3  (54-1)
#define ind_ACO3  (55-1)
#define ind_HC3P  (56-1)
#define ind_ETHP  (57-1)
#define ind_NO  (58-1)
#define ind_NO2  (59-1)

// Convert i indices into global mem address depending on layout
#ifndef OLD_LAYOUT
# define MY_I(I) ((I)*chunk_sz)
#else
# define MY_I(I) (I)
#endif

// Index declaration for fixed species in C
//   C(ind_spc)

#define ind_H2O  (60-1)
#define ind_M  (61-1)

// Index declaration for fixed species in FIX
//    FIX(indf_spc] = C(ind_spc) = C(NVAR+indf_spc)

#define indf_H2O  (1-1)
#define indf_M  (2-1)

//#define TINY(X) 2.225073858507201e-308
#if ( CHEM_FP_TYPE == double )
# define TINY(X) 2.225073858507201e-307
# define ZERO 0.0e0
# define HALF 0.5e0
# define ONE  1.0e0
# define DeltaMin 1.0e-5
#else
# define TINY(X) 2.225073858507201e-307
# define ZERO 0.0
# define HALF 0.5
# define ONE  1.0
# define DeltaMin 1.0e-5
#endif

int My_Ti , My_Tj , My_Bi , My_Bj, My_Bx, My_By, My_Nb ;

#ifdef ENABLE_OPCOUNT
// option to turn on instruation that will report on a number of
// operation and load/store stats at run time
EXTERN_RF unsigned int MUL_=0; 
EXTERN_RF unsigned int ADD_=0; 
EXTERN_RF unsigned int DIV_=0;
EXTERN_RF unsigned int SQT_=0;
EXTERN_RF unsigned int EXP_=0;
EXTERN_RF unsigned int POW_=0;
EXTERN_RF unsigned int LD_=0;
EXTERN_RF unsigned int ST_=0;

# define COUNT_OPS(A,B,C,D,E,F,G,H){MUL_+=(A);ADD_+=(B);DIV_+=(C);SQT_+=(D);EXP_+=(E);POW_+=(F);LD_+=(G);ST_+=(H);}
#else
// otherwise a noop
# define COUNT_OPS(A,B,C,D,E,F,G,H)
#endif


#ifdef NEW_APPROACH

#define WCOPY(N,X,Y) if ( ti < N ) { Y[ti] = X[ti] ; }
#define WCOPY2(N,X,XOFF,Y,YOFF) if ( ti < N ) { Y[(YOFF)+ti] = X[(XOFF)+ti] ; }
#define WCOPY_T0(N,X,Y) {int i ; for ( i = 0 ; i < N ; i++ ) { Y[i] = X[i] ; }}

#define WAXPY(N,Alpha,X,XOFF,Y,YOFF) if ( ti < N ) { Y[(YOFF)+ti] += (Alpha)*X[(XOFF)+ti] ;}
#define WAXPY_T0(N,Alpha,X,Y) {int i ; for ( i = 0 ; i < N ; i++ ) { Y[i] += (Alpha)*X[i] ;}}

#define WSCAL(N,Alpha,X) if ( ti < N ) { \
                    if      (Alpha==(-ONE)) { X[ti]=-X[ti]       ; \
                  } else if (Alpha == ZERO) { X[ti]= ZERO        ; \
                  } else                    { X[ti]= Alpha*X[ti] ; \
                  } \
                  }

#define WSCAL_T0(N,Alpha,X) { int i ; if (Alpha==(-ONE)) { for(i=0;i<N;i++){X[i]=-X[i] ;} \
                  } else if (Alpha == ZERO) { for(i=0;i<N;i++){X[i]= ZERO ;}       \
                  } else                    { for(i=0;i<N;i++){X[i]= Alpha*X[i] ;}  \
                  }}

#else


#define WCOPY(N,X,Y) {int i ; for ( i = 0 ; i < N ; i++ ) { Y[MY_I(i)] = X[MY_I(i)] ; } \
COUNT_OPS(0,0,0,0,0,0,N,N) ; \
}
//#define WCOPY(N,X,Y) {int i ; for ( i = 0 ; i+3 < N ; i+=4 ) { Y[i]=X[i];Y[i+1]=X[i+1];Y[i+2]=X[i+2];Y[i+3]=X[i+3];} \
//                              for (       ; i   < N ; i++ )  { Y[i]=X[i];}                                           \
//COUNT_OPS(0,0,0,0,0,0,N,N) ; \
//}

#define WAXPY(N,Alpha,X,Y) {int i ; for ( i = 0 ; i < N ; i++ ) { Y[MY_I(i)] += Alpha*X[MY_I(i)] ;} \
COUNT_OPS(N,N,0,0,0,0,N,N) ; \
}
//#define WAXPY(N,Alpha,X,Y) {int i ; for ( i = 0 ; i+3 < N ; i+=4 ) { Y[i  ]+=Alpha*X[i  ]; \
//                                                                     Y[i+1]+=Alpha*X[i+1]; \
//                                                                     Y[i+2]+=Alpha*X[i+2]; \
//                                                                     Y[i+3]+=Alpha*X[i+3]; \
//                                                                   } \
//                                    for (       ; i   < N ; i++  ) { Y[i  ]+=Alpha*X[i  ]; } \
//COUNT_OPS(N,N,0,0,0,0,N,N) ; \
//}

#define WSCAL(N,Alpha,X) {int i;  \
                 if (Alpha==(-ONE)) {{ for(i=0;i<N;i++){X[MY_I(i)]=-X[MY_I(i)] ;}  \
COUNT_OPS(0,0,0,0,0,0,N,N) ; \
}  \
               } else if ( Alpha == ZERO ) {{ for(i=0;i<N;i++){X[MY_I(i)]= ZERO ;}  \
COUNT_OPS(0,0,0,0,0,0,0,N) ; \
} ;         \
               } else {                      {for(i=0;i<N;i++){X[MY_I(i)]= Alpha*X[MY_I(i)] ;}  \
COUNT_OPS(1,0,0,0,0,0,N,N) ; \
}}}

//#define WSCAL(N,Alpha,X) {int i;  \
//  if (Alpha==(-ONE)) {{ for(i=0;i+3<N;i+=4){X[i]=-X[i];X[i+1]=-X[i+1];X[i+2]=-X[i+2];X[i+3]=-X[i+3];}  \
//                        for(   ;i  <N;i++ ){X[i]=-X[i];} \
//COUNT_OPS(0,0,0,0,0,0,N,N) ; \
//}  \
//  } else if ( Alpha == ZERO ) {{ for(i=0;i+3<N;i+=4){X[i]=ZERO;X[i+1]=ZERO;X[i+2]=ZERO;X[i+3]=ZERO;}  \
//                                 for(   ;i  <N;i++ ){X[i]=ZERO;} \
//COUNT_OPS(0,0,0,0,0,0,0,N) ; \
//} ;         \
//  } else {                      {for(i=0;i+3<N;i+=4){X[i  ]=Alpha*X[i  ]; \
//                                                     X[i+1]=Alpha*X[i+1]; \
//                                                     X[i+2]=Alpha*X[i+2]; \
//                                                     X[i+3]=Alpha*X[i+3]; }  \
//                                 for(   ;i  <N;i++ ){X[i]=Alpha*X[i];} \
//COUNT_OPS(1,0,0,0,0,0,N,N) ; \
//}}}
#endif

#define DEFBOUNDS(V) CHEM_FP_TYPE * V##_lb, * V##_ub  ;
DEFBOUNDS(jvvar_d) ;
DEFBOUNDS(RCONST0) ;
DEFBOUNDS(fix) ;
DEFBOUNDS(AbsTol) ;
DEFBOUNDS(RelTol) ;
DEFBOUNDS(B0_scratch) ;
DEFBOUNDS(Ynew) ;
DEFBOUNDS(Fcn0) ;
DEFBOUNDS(Fcn) ;
DEFBOUNDS(K) ;
DEFBOUNDS(dFdT) ;
DEFBOUNDS(Jac0) ;
DEFBOUNDS(Ghimj) ;
DEFBOUNDS(Yerr) ;
#ifdef DEVICEEMU
#define CHKBOUNDS(A,V) if ( ((A) < V##_lb) || ((A) >= V##_ub )) {fprintf(stderr,"BAD address %08u < %08u < %08u in %s %d\n",V##_lb,(A),V##_ub,__FILE__,__LINE__);}
#else
#define CHKBOUNDS(A,V)
#endif
