!WRF:MODEL_LAYER:DYNAMICS
!

  SUBROUTINE test_driver ( ids,ide,jds,jde,kds,kde &
                          ,ims,ime,jms,jme,kms,kme &
                          ,ips,ipe,jps,jpe,kps,kpe &
                          ,num_chem, num_moist, ldrog &
                          ,chunk_sz , xxx )

#ifndef RUN_ON_GPU_CHEM
    USE module_kpp_radm2sorg_interf
#endif
    IMPLICIT NONE
    INTEGER thisstep
    COMMON /test_block/ thisstep
    INTEGER ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,ips,ipe,jps,jpe,kps,kpe
    INTEGER num_chem, num_moist, ldrog
    INTEGER chunk_sz, xxx
    INTEGER s, e, iter
    INTEGER, EXTERNAL :: rsl_internal_microclock
    INTEGER :: id
    REAL :: dtstepc, rc_n2o5

!
! state
!
    REAL, DIMENSION( ims:ime, kms:kme, jms:jme, num_chem )  :: chem


    REAL, DIMENSION( ims:ime, kms:kme, jms:jme, num_moist ) :: moist


    REAL,  DIMENSION( ims:ime , kms:kme , jms:jme )      ::       &
                                                         p_phy,    &
                                                         t_phy,    &
                                                         rho_phy

!
! radicals
!
      REAL, DIMENSION( ims:ime, kms:kme, jms:jme ) ::  &
               addt, addx, addc, etep, oltp, &
               olip, cslp, limp, hc5p, hc8p, &
               tolp, xylp, apip, isop, hc3p, &
               ethp, o3p, tco3, mo2, o1d, &
               olnn, olnd, rpho, xo2, ketp, &
               xno2, ol2p, oln, macp

!
! photolysis rates
!
      REAL, DIMENSION( ims:ime, kms:kme, jms:jme ) ::  &
               ph_o31d, ph_o33p, ph_no2, ph_no3o2, ph_no3o, &
               ph_hno2, ph_hno3, ph_hno4, ph_h2o2, ph_ch2or, &
               ph_ch2om, ph_ch3cho, ph_ch3coch3, ph_ch3coc2h5, ph_hcocho, &
               ph_ch3cocho, ph_hcochest, ph_ch3o2h, ph_ch3coo2h, ph_ch3ono2, &
               ph_hcochob, ph_macr, ph_n2o5, ph_o2, ph_pan, &
               ph_acet, ph_mglo, ph_hno4_2

! needed for aerosols
    REAL                   ::  vdrog3(ims:ime,kms:kme-0,jms:jme,ldrog)
    CHARACTER*80 fname

#ifdef RUN_ON_GPU_CHEM
! indices into chem array
    INTEGER P_o3 , P_h2o2 , P_no , P_no2 , P_no3 , P_n2o5 , P_hono
    INTEGER P_hno3 , P_hno4 , P_so2 , P_sulf , P_co , P_eth , P_hc3
    INTEGER P_hc5 , P_hc8 , P_ol2 , P_olt , P_oli , P_iso , P_tol
    INTEGER P_xyl , P_csl , P_hcho , P_ald , P_ket , P_gly , P_mgly
    INTEGER P_dcb , P_onit , P_pan , P_tpan , P_op1 , P_op2 , P_paa
    INTEGER P_ora1 , P_ora2 , P_HO , P_ho2 , P_aco3 , P_ch4 , P_co2
#endif

! misc
    INTEGER i,j,k,im

    write(fname,'("radm2sorg_in_",i3.3)')thisstep
    print*,'opening ',trim(fname),' for second time'
    open(45,file=fname,form='UNFORMATTED')
    read(45) ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,ips,ipe,jps,jpe,kps,kpe
    read(45) num_chem, num_moist, ldrog
    read(45) id,dtstepc
#ifdef RUN_ON_GPU_CHEM
    read(45) P_o3 , P_h2o2 , P_no , P_no2 , P_no3 , P_n2o5 , P_hono
    read(45) P_hno3 , P_hno4 , P_so2 , P_sulf , P_co , P_eth , P_hc3
    read(45) P_hc5 , P_hc8 , P_ol2 , P_olt , P_oli , P_iso , P_tol
    read(45) P_xyl , P_csl , P_hcho , P_ald , P_ket , P_gly , P_mgly
    read(45) P_dcb , P_onit , P_pan , P_tpan , P_op1 , P_op2 , P_paa
    read(45) P_ora1 , P_ora2 , P_HO , P_ho2 , P_aco3 , P_ch4 , P_co2
#else
    read(45)
    read(45)
    read(45)
    read(45)
    read(45)
    read(45)
#endif


#if 0
! write P_defines.h
write(*,*)'#define P_o3 	',P_o3 
write(*,*)'#define P_h2o2 	',P_h2o2 
write(*,*)'#define P_no 	',P_no 
write(*,*)'#define P_no2 	',P_no2 
write(*,*)'#define P_no3 	',P_no3 
write(*,*)'#define P_n2o5 	',P_n2o5 
write(*,*)'#define P_hono	',P_hono
write(*,*)'#define P_hno3 	',P_hno3 
write(*,*)'#define P_hno4 	',P_hno4 
write(*,*)'#define P_so2 	',P_so2 
write(*,*)'#define P_sulf 	',P_sulf 
write(*,*)'#define P_co 	',P_co 
write(*,*)'#define P_eth 	',P_eth 
write(*,*)'#define P_hc3	',P_hc3
write(*,*)'#define P_hc5 	',P_hc5 
write(*,*)'#define P_hc8 	',P_hc8 
write(*,*)'#define P_ol2 	',P_ol2 
write(*,*)'#define P_olt 	',P_olt 
write(*,*)'#define P_oli 	',P_oli 
write(*,*)'#define P_iso 	',P_iso 
write(*,*)'#define P_tol	',P_tol
write(*,*)'#define P_xyl 	',P_xyl 
write(*,*)'#define P_csl 	',P_csl 
write(*,*)'#define P_hcho 	',P_hcho 
write(*,*)'#define P_ald 	',P_ald 
write(*,*)'#define P_ket 	',P_ket 
write(*,*)'#define P_gly 	',P_gly 
write(*,*)'#define P_mgly	',P_mgly
write(*,*)'#define P_dcb 	',P_dcb 
write(*,*)'#define P_onit 	',P_onit 
write(*,*)'#define P_pan 	',P_pan 
write(*,*)'#define P_tpan 	',P_tpan 
write(*,*)'#define P_op1 	',P_op1 
write(*,*)'#define P_op2 	',P_op2 
write(*,*)'#define P_paa	',P_paa
write(*,*)'#define P_ora1 	',P_ora1 
write(*,*)'#define P_ora2 	',P_ora2 
write(*,*)'#define P_HO 	',P_HO 
write(*,*)'#define P_ho2 	',P_ho2 
write(*,*)'#define P_aco3 	',P_aco3 
write(*,*)'#define P_ch4 	',P_ch4 
write(*,*)'#define P_co2	',P_co2
#endif

    read(45) chem
    read(45) moist
    read(45) p_phy,t_phy,rho_phy
    read(45) vdrog3
    read(45) addt, addx, addc, etep, oltp
    read(45) olip, cslp, limp, hc5p, hc8p
    read(45) tolp, xylp, apip, isop, hc3p
    read(45) ethp, o3p, tco3, mo2, o1d
    read(45) olnn, olnd, rpho, xo2, ketp
    read(45) xno2, ol2p, oln, macp
    read(45) ph_o31d, ph_o33p, ph_no2, ph_no3o2, ph_no3o
    read(45) ph_hno2, ph_hno3, ph_hno4, ph_h2o2, ph_ch2or
    read(45) ph_ch2om, ph_ch3cho, ph_ch3coch3, ph_ch3coc2h5, ph_hcocho
    read(45) ph_ch3cocho, ph_hcochest, ph_ch3o2h, ph_ch3coo2h, ph_ch3ono2
    read(45) ph_hcochob, ph_macr, ph_n2o5, ph_o2, ph_pan
    read(45) ph_acet, ph_mglo, ph_hno4_2
    close(45)

    print*,' num_chem ', num_chem
    print*,' num_moist ', num_moist
    print*,' P_sulf ',P_sulf

    !do im = 1,num_chem
    write(60,*)ime-ims+1,jme-jms+1,'o3 before'
    do j = jms,jme
    k = 1
    do i = ims,ime
    write(60,*)chem(i,k,j,P_o3)
    enddo
    enddo
    !enddo
    close(60)
    !do im = 1,num_chem
write(*,*)'bef ',chem(ips,kps,jps,P_o3)
    do k = kps,kpe
    write(50,*)ipe-ips-1,jpe-jps-1,k,'o3 before'
    do j = jps+1,jpe-1
    do i = ips+1,ipe-1
    write(50,*)chem(i,k,j,P_o3)
    enddo
    enddo
    enddo
    close(50)
    !enddo

#if 0
i = 1 ; j = 1 ; k = 1
write(0,*)'chem(i,k,j,P_o3)',chem(i,k,j,P_o3)
write(0,*)'chem(i,k,j,P_h2o2)',chem(i,k,j,P_h2o2)
write(0,*)'chem(i,k,j,P_no)',chem(i,k,j,P_no)
write(0,*)'chem(i,k,j,P_no2)',chem(i,k,j,P_no2)
write(0,*)'chem(i,k,j,P_no3)',chem(i,k,j,P_no3)
write(0,*)'chem(i,k,j,P_n2o5)',chem(i,k,j,P_n2o5)
write(0,*)'chem(i,k,j,P_hono)',chem(i,k,j,P_hono)
write(0,*)'chem(i,k,j,P_hno3)',chem(i,k,j,P_hno3)
write(0,*)'chem(i,k,j,P_hno4)',chem(i,k,j,P_hno4)
write(0,*)'chem(i,k,j,P_so2)',chem(i,k,j,P_so2)
write(0,*)'chem(i,k,j,P_sulf)',chem(i,k,j,P_sulf)
write(0,*)'chem(i,k,j,P_co)',chem(i,k,j,P_co)
write(0,*)'chem(i,k,j,P_eth)',chem(i,k,j,P_eth)
write(0,*)'chem(i,k,j,P_hc3)',chem(i,k,j,P_hc3)
write(0,*)'chem(i,k,j,P_hc5)',chem(i,k,j,P_hc5)
write(0,*)'chem(i,k,j,P_hc8)',chem(i,k,j,P_hc8)
write(0,*)'chem(i,k,j,P_ol2)',chem(i,k,j,P_ol2)
write(0,*)'chem(i,k,j,P_olt)',chem(i,k,j,P_olt)
write(0,*)'chem(i,k,j,P_oli)',chem(i,k,j,P_oli)
write(0,*)'chem(i,k,j,P_iso)',chem(i,k,j,P_iso)
write(0,*)'chem(i,k,j,P_tol)',chem(i,k,j,P_tol)
write(0,*)'chem(i,k,j,P_xyl)',chem(i,k,j,P_xyl)
write(0,*)'chem(i,k,j,P_csl)',chem(i,k,j,P_csl)
write(0,*)'chem(i,k,j,P_hcho)',chem(i,k,j,P_hcho)
write(0,*)'chem(i,k,j,P_ald)',chem(i,k,j,P_ald)
write(0,*)'ethp(i,k,j)',ethp(i,k,j)
write(0,*)'chem(i,k,j,P_ket)',chem(i,k,j,P_ket)
write(0,*)'chem(i,k,j,P_gly)',chem(i,k,j,P_gly)
write(0,*)'chem(i,k,j,P_mgly)',chem(i,k,j,P_mgly)
write(0,*)'mo2(i,k,j)',mo2(i,k,j)
write(0,*)'chem(i,k,j,P_dcb)',chem(i,k,j,P_dcb)
write(0,*)'chem(i,k,j,P_onit)',chem(i,k,j,P_onit)
write(0,*)'chem(i,k,j,P_pan)',chem(i,k,j,P_pan)
write(0,*)'chem(i,k,j,P_tpan)',chem(i,k,j,P_tpan)
write(0,*)'chem(i,k,j,P_op1)',chem(i,k,j,P_op1)
write(0,*)'chem(i,k,j,P_op2)',chem(i,k,j,P_op2)
write(0,*)'chem(i,k,j,P_paa)',chem(i,k,j,P_paa)
write(0,*)'chem(i,k,j,P_ora1)',chem(i,k,j,P_ora1)
write(0,*)'chem(i,k,j,P_ora2)',chem(i,k,j,P_ora2)
write(0,*)'chem(i,k,j,P_HO)',chem(i,k,j,P_HO)
write(0,*)'chem(i,k,j,P_ho2)',chem(i,k,j,P_ho2)
write(0,*)'o3p(i,k,j)',o3p(i,k,j)
write(0,*)'o1d(i,k,j)',o1d(i,k,j)
write(0,*)'hc3p(i,k,j)',hc3p(i,k,j)
write(0,*)'hc5p(i,k,j)',hc5p(i,k,j)
write(0,*)'hc8p(i,k,j)',hc8p(i,k,j)
write(0,*)'oltp(i,k,j)',oltp(i,k,j)
write(0,*)'olip(i,k,j)',olip(i,k,j)
write(0,*)'tolp(i,k,j)',tolp(i,k,j)
write(0,*)'xylp(i,k,j)',xylp(i,k,j)
write(0,*)'chem(i,k,j,P_aco3)',chem(i,k,j,P_aco3)
write(0,*)'tco3(i,k,j)',tco3(i,k,j)
write(0,*)'ketp(i,k,j)',ketp(i,k,j)
write(0,*)'oln(i,k,j)',oln(i,k,j)
write(0,*)'xo2(i,k,j)',xo2(i,k,j)
write(0,*)'xno2(i,k,j)',xno2(i,k,j)
write(0,*)'chem(i,k,j,P_ch4)',chem(i,k,j,P_ch4)
write(0,*)'chem(i,k,j,P_co2)',chem(i,k,j,P_co2)
write(0,*)'ol2p(i,k,j)',ol2p(i,k,j)
#endif
     
s = rsl_internal_microclock()
#ifdef RUN_ON_GPU_CHEM
    CALL chem_driver_on_host (   &
  chem, rc_n2o5, dtstepc  &
, rho_phy, moist(ims,kms,jms,2), t_phy, p_phy  &
, addt, addx, addc, etep, oltp  &
, olip, cslp, limp, hc5p, hc8p  &
, tolp, xylp, apip, isop, hc3p  &
, ethp, o3p, tco3, mo2, o1d  &
, olnn, olnd, rpho, xo2, ketp  &
, xno2, ol2p, oln, macp  &
, ph_o31d, ph_o33p, ph_no2, ph_no3o2, ph_no3o  &
, ph_hno2, ph_hno3, ph_hno4, ph_h2o2, ph_ch2or  &
, ph_ch2om, ph_ch3cho, ph_ch3coch3, ph_ch3coc2h5, ph_hcocho  &
, ph_ch3cocho, ph_hcochest, ph_ch3o2h, ph_ch3coo2h, ph_ch3ono2  &
, ph_hcochob, ph_macr, ph_n2o5, ph_o2, ph_pan  &
, ph_acet, ph_mglo, ph_hno4_2  &
, ids, ide, jds, jde, kds, kde  &
, ims, ime, jms, jme, kms, kme  &
!, ips+1, ipe-1, jps+1, jpe-1, kps, kpe  &
, ips, ipe, jps, jpe, kps, kpe  &
, chunk_sz , xxx &
                        )

e = rsl_internal_microclock()
write(0,*)'Call to chem (all inclusive): ',e-s
#else

        CALL radm2sorg_interface(     &
!!
!#include <fixed_args_kpp_interf.inc>
!!
    chem, id, dtstepc, & ! ,config_flags, &
    p_phy,t_phy,rho_phy,moist,     &
    vdrog3, ldrog,                 &
             addt, addx, addc, etep, oltp, &
             olip, cslp, limp, hc5p, hc8p, &
             tolp, xylp, apip, isop, hc3p, &
             ethp, o3p, tco3, mo2, o1d, &
             olnn, olnd, rpho, xo2, ketp, &
             xno2, ol2p, oln, macp,  &
             ph_o31d, ph_o33p, ph_no2, ph_no3o2, ph_no3o, &
             ph_hno2, ph_hno3, ph_hno4, ph_h2o2, ph_ch2or, &
             ph_ch2om, ph_ch3cho, ph_ch3coch3, ph_ch3coc2h5, ph_hcocho, &
             ph_ch3cocho, ph_hcochest, ph_ch3o2h, ph_ch3coo2h, ph_ch3ono2, &
             ph_hcochob, ph_macr, ph_n2o5, ph_o2, ph_pan, &
             ph_acet, ph_mglo, ph_hno4_2,  &
              ids,ide, jds,jde, kds,kde,         &
              ims,ime, jms,jme, kms,kme,         &
              ips,ipe, jps,jpe, kps,kpe         &
,num_moist   &
,num_chem    &
,iter &
             )

e = rsl_internal_microclock()
write(0,*)'Call to chem (all inclusive): ',e-s,'  cells ',iter
#endif


    !do im = 1,num_chem
    write(61,*)ime-ims+1,jme-jms+1,'o3 after'
    do j = jms,jme
    k = 1
    do i = ims,ime
    write(61,*)chem(i,k,j,P_o3)
    enddo
    enddo
    close(61)
    !enddo
    !do im = 1,num_chem

write(*,*)'aft ',chem(ips,kps,jps,P_o3)
    do k = kps,kpe
    write(51,*)ipe-ips-1,jpe-jps-1,k,'o3 after',P_o3
    do j = jps+1,jpe-1
    do i = ips+1,ipe-1
    write(51,*)chem(i,k,j,P_o3)
    enddo
    enddo
    enddo
    close(51)
    !enddo
     
     


!!!!!!!

  END SUBROUTINE test_driver

  PROGRAM kpp_driver
    IMPLICIT NONE

    INTEGER thisstep
    COMMON /test_block/ thisstep
    CHARACTER*80 fname
    INTEGER ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,ips,ipe,jps,jpe,kps,kpe
    INTEGER num_chem, num_moist, ldrog
    INTEGER chunk_sz, xxx
    INTEGER :: id
    REAL :: dtstepc


    print *,'Step number? '
    read(*,*) thisstep
#ifdef RUN_ON_GPU_CHEM
    print *,'Chunk size? '
    read(*,*) chunk_sz
    print *,'Block size? '
    read(*,*) xxx
#endif

    write(fname,'("radm2sorg_in_",i3.3)')thisstep
    print*,'opening ',trim(fname),' first time '
    open(45,file=fname,form='UNFORMATTED')
    read(45) ids,ide,jds,jde,kds,kde,ims,ime,jms,jme,kms,kme,ips,ipe,jps,jpe,kps,kpe
    read(45) num_chem, num_moist, ldrog
    close(45)

    write(0,*)'READ IN VALUES'
    write(0,*)' ids,ide,jds,jde,kds,kde ',ids,ide,jds,jde,kds,kde
    write(0,*)' ims,ime,jms,jme,kms,kme ',ims,ime,jms,jme,kms,kme
    write(0,*)' ips,ipe,jps,jpe,kps,kpe ',ips,ipe,jps,jpe,kps,kpe
    write(0,*)' num_chem, num_moist ',num_chem, num_moist

#ifdef RUN_ON_GPU_CHEM
    CALL gpu_init
#endif

    CALL test_driver( ids,ide,jds,jde,kds,kde &
                     ,ims,ime,jms,jme,kms,kme &
                     ,ips,ipe,jps,jpe,kps,kpe &
                     ,num_chem, num_moist, ldrog &
                     ,chunk_sz, xxx )

    stop
  END PROGRAM kpp_driver

