! 
! THIS FILE WAS AUTOMATICALLY GENERATED BY 
!
!      tools/gen_kpp_interface.c   
!
! IT IS NOW THE VANILLA PART OF THE driver_chem MICRO BENCHMARK
! 
! 
MODULE module_kpp_radm2sorg_interf 


!  USE module_state_description
!  USE module_configure

  USE radm2sorg_Parameters
  USE radm2sorg_Precision
  USE radm2sorg_UpdateRconstWRF
  USE radm2sorg_Integrator

!#include <kpp_mechd_u_radm2sorg.inc> 
  USE module_data_sorgam, ONLY : PXYL, PTOL, PCSL1, PCSL2, PHC8, POLI1, POLI2, POLI3, &
                                 POLT1, POLT2, POLT3, PAPI1, PAPI2, PAPI3, PLIM1, PLIM2, PLIM3

!  USE module_wkppc_constants

! A few constants

     REAL, PARAMETER  ::  navgdro = 6.022e23   ! molecules/mol

     REAL, PARAMETER  ::   &   !molecular weights
           mwh = 1.0079,  mwo = 15.9994,  mwair = 28.97


     REAL, PARAMETER :: mwh2o = 2*mwh + mwo


!dens2con air
      REAL, PARAMETER ::          dens2con_a = 1.e-3     &! kg/m3 -> g/cm3
                                   * (1./mwair)          &! -> mole/cm3
                                   * navgdro              ! -> molec/cm3



!dens2con water
      REAL, PARAMETER ::          dens2con_w = 1.e-3     &! kg/m3 -> g/cm3
                                    * (1./mwh2o)         &! -> mole/cm3
                                    * navgdro             ! -> molec/cm3







! constants for KPP
! should be moved to namelist input in the future
! additional settings in ./inc/kpp_ctrl_default.inc


     REAL, PARAMETER ::  rtols=1.E-3 ! 1e-2 means two digits
     REAL, PARAMETER ::  atols=1.



! locally define pointers to photolysis rates

     INTEGER, PARAMETER, PRIVATE :: Pj_o31d = 1 
     INTEGER, PARAMETER, PRIVATE :: Pj_o33p = 2 
     INTEGER, PARAMETER, PRIVATE :: Pj_no2 = 3 
     INTEGER, PARAMETER, PRIVATE :: Pj_no3o2 = 4 
     INTEGER, PARAMETER, PRIVATE :: Pj_no3o = 5 
     INTEGER, PARAMETER, PRIVATE :: Pj_hno2 = 6 
     INTEGER, PARAMETER, PRIVATE :: Pj_hno3 = 7 
     INTEGER, PARAMETER, PRIVATE :: Pj_hno4 = 8 
     INTEGER, PARAMETER, PRIVATE :: Pj_h2o2 = 9 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch2or = 10 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch2om = 11 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch3cho = 12 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch3coch3 = 13 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch3coc2h5 = 14 
     INTEGER, PARAMETER, PRIVATE :: Pj_hcocho = 15 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch3cocho = 16 
     INTEGER, PARAMETER, PRIVATE :: Pj_hcochest = 17 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch3o2h = 18 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch3coo2h = 19 
     INTEGER, PARAMETER, PRIVATE :: Pj_ch3ono2 = 20 
     INTEGER, PARAMETER, PRIVATE :: Pj_hcochob = 21 
     INTEGER, PARAMETER, PRIVATE :: Pj_macr = 22 
     INTEGER, PARAMETER, PRIVATE :: Pj_n2o5 = 23 
     INTEGER, PARAMETER, PRIVATE :: Pj_o2 = 24 
     INTEGER, PARAMETER, PRIVATE :: Pj_pan = 25 
     INTEGER, PARAMETER, PRIVATE :: Pj_acet = 26 
     INTEGER, PARAMETER, PRIVATE :: Pj_mglo = 27 
     INTEGER, PARAMETER, PRIVATE :: Pj_hno4_2 = 28 

#if 0
     INTEGER, PARAMETER  :: ind_SULF   = (1)
     INTEGER, PARAMETER  :: ind_ORA1   = (2)
     INTEGER, PARAMETER  :: ind_ORA2   = (3)
     INTEGER, PARAMETER  :: ind_CO2   = (4)
     INTEGER, PARAMETER  :: ind_SO2   = (5)
     INTEGER, PARAMETER  :: ind_ETH   = (6)
     INTEGER, PARAMETER  :: ind_O1D   = (7)
     INTEGER, PARAMETER  :: ind_HC5   = (8)
     INTEGER, PARAMETER  :: ind_HC8   = (9)
     INTEGER, PARAMETER  :: ind_TOL   = (10)
     INTEGER, PARAMETER  :: ind_XYL   = (11)
     INTEGER, PARAMETER  :: ind_TPAN   = (12)
     INTEGER, PARAMETER  :: ind_HONO   = (13)
     INTEGER, PARAMETER  :: ind_H2O2   = (14)
     INTEGER, PARAMETER  :: ind_N2O5   = (15)
     INTEGER, PARAMETER  :: ind_HC3   = (16)
     INTEGER, PARAMETER  :: ind_CH4   = (17)
     INTEGER, PARAMETER  :: ind_PAA   = (18)
     INTEGER, PARAMETER  :: ind_O3P   = (19)
     INTEGER, PARAMETER  :: ind_HNO4   = (20)
     INTEGER, PARAMETER  :: ind_OP1   = (21)
     INTEGER, PARAMETER  :: ind_CSL   = (22)
     INTEGER, PARAMETER  :: ind_PAN   = (23)
     INTEGER, PARAMETER  :: ind_OL2   = (24)
     INTEGER, PARAMETER  :: ind_HNO3   = (25)
     INTEGER, PARAMETER  :: ind_CO   = (26)
     INTEGER, PARAMETER  :: ind_ISO   = (27)
     INTEGER, PARAMETER  :: ind_OLT   = (28)
     INTEGER, PARAMETER  :: ind_OLI   = (29)
     INTEGER, PARAMETER  :: ind_DCB   = (30)
     INTEGER, PARAMETER  :: ind_GLY   = (31)
     INTEGER, PARAMETER  :: ind_XNO2   = (32)
     INTEGER, PARAMETER  :: ind_KET   = (33)
     INTEGER, PARAMETER  :: ind_MGLY   = (34)
     INTEGER, PARAMETER  :: ind_TOLP   = (35)
     INTEGER, PARAMETER  :: ind_XYLP   = (36)
     INTEGER, PARAMETER  :: ind_OLTP   = (37)
     INTEGER, PARAMETER  :: ind_OLN   = (38)
     INTEGER, PARAMETER  :: ind_XO2   = (39)
     INTEGER, PARAMETER  :: ind_OL2P   = (40)
     INTEGER, PARAMETER  :: ind_HC5P   = (41)
     INTEGER, PARAMETER  :: ind_OP2   = (42)
     INTEGER, PARAMETER  :: ind_HCHO   = (43)
     INTEGER, PARAMETER  :: ind_HC8P   = (44)
     INTEGER, PARAMETER  :: ind_TCO3   = (45)
     INTEGER, PARAMETER  :: ind_O3   = (46)
     INTEGER, PARAMETER  :: ind_ONIT   = (47)
     INTEGER, PARAMETER  :: ind_ALD   = (48)
     INTEGER, PARAMETER  :: ind_OLIP   = (49)
     INTEGER, PARAMETER  :: ind_KETP   = (50)
     INTEGER, PARAMETER  :: ind_HO2   = (51)
     INTEGER, PARAMETER  :: ind_MO2   = (52)
     INTEGER, PARAMETER  :: ind_OH   = (53)
     INTEGER, PARAMETER  :: ind_NO3   = (54)
     INTEGER, PARAMETER  :: ind_ACO3   = (55)
     INTEGER, PARAMETER  :: ind_HC3P   = (56)
     INTEGER, PARAMETER  :: ind_ETHP   = (57)
     INTEGER, PARAMETER  :: ind_NO   = (58)
     INTEGER, PARAMETER  :: ind_NO2   = (59)
#endif

     INTEGER, PARAMETER :: P_o3         = (6)
     INTEGER, PARAMETER :: P_h2o2       = (8)
     INTEGER, PARAMETER :: P_no         = (5)
     INTEGER, PARAMETER :: P_no2        = (4)
     INTEGER, PARAMETER :: P_no3        = (18)
     INTEGER, PARAMETER :: P_n2o5       = (17)
     INTEGER, PARAMETER :: P_hono       = (32)
     INTEGER, PARAMETER :: P_hno3       = (7)
     INTEGER, PARAMETER :: P_hno4       = (33)
     INTEGER, PARAMETER :: P_so2        = (2)
     INTEGER, PARAMETER :: P_sulf       = (3)
     INTEGER, PARAMETER :: P_co         = (24)
     INTEGER, PARAMETER :: P_eth        = (23)
     INTEGER, PARAMETER :: P_hc3        = (20)
     INTEGER, PARAMETER :: P_hc5        = (21)
     INTEGER, PARAMETER :: P_hc8        = (22)
     INTEGER, PARAMETER :: P_ol2        = (25)
     INTEGER, PARAMETER :: P_olt        = (26)
     INTEGER, PARAMETER :: P_oli        = (27)
     INTEGER, PARAMETER :: P_iso        = (40)
     INTEGER, PARAMETER :: P_tol        = (28)
     INTEGER, PARAMETER :: P_xyl        = (29)
     INTEGER, PARAMETER :: P_csl        = (39)
     INTEGER, PARAMETER :: P_hcho       = (10)
     INTEGER, PARAMETER :: P_ald        = (9)
     INTEGER, PARAMETER :: P_ket        = (34)
     INTEGER, PARAMETER :: P_gly        = (35)
     INTEGER, PARAMETER :: P_mgly       = (36)
     INTEGER, PARAMETER :: P_dcb        = (37)
     INTEGER, PARAMETER :: P_onit       = (38)
     INTEGER, PARAMETER :: P_pan        = (19)
     INTEGER, PARAMETER :: P_tpan       = (31)
     INTEGER, PARAMETER :: P_op1        = (11)
     INTEGER, PARAMETER :: P_op2        = (12)
     INTEGER, PARAMETER :: P_paa        = (13)
     INTEGER, PARAMETER :: P_ora1       = (14)
     INTEGER, PARAMETER :: P_ora2       = (15)
     INTEGER, PARAMETER :: P_HO         = (43)
     INTEGER, PARAMETER :: P_ho2        = (44)
     INTEGER, PARAMETER :: P_aco3       = (30)
     INTEGER, PARAMETER :: P_ch4        = (42)
     INTEGER, PARAMETER :: P_co2        = (41)

CONTAINS 

SUBROUTINE  radm2sorg_interface( &
!!
!#include <fixed_args_kpp_interf.inc>
!!
    chem, id, dtstepc, & ! ,config_flags, &
    p_phy,t_phy,rho_phy,moist,     &
    vdrog3, ldrog,                 &
             addt, addx, addc, etep, oltp, & 
             olip, cslp, limp, hc5p, hc8p, & 
             tolp, xylp, apip, isop, hc3p, & 
             ethp, o3p, tco3, mo2, o1d, & 
             olnn, olnd, rpho, xo2, ketp, & 
             xno2, ol2p, oln, macp,  & 
             ph_o31d, ph_o33p, ph_no2, ph_no3o2, ph_no3o, & 
             ph_hno2, ph_hno3, ph_hno4, ph_h2o2, ph_ch2or, & 
             ph_ch2om, ph_ch3cho, ph_ch3coch3, ph_ch3coc2h5, ph_hcocho, & 
             ph_ch3cocho, ph_hcochest, ph_ch3o2h, ph_ch3coo2h, ph_ch3ono2, & 
             ph_hcochob, ph_macr, ph_n2o5, ph_o2, ph_pan, & 
             ph_acet, ph_mglo, ph_hno4_2,  & 
              ids,ide, jds,jde, kds,kde,         &
              ims,ime, jms,jme, kms,kme,         &
              its,ite, jts,jte, kts,kte    &
,num_moist    &
,num_chem    &
,iter &
         )


    IMPLICIT NONE


    INTEGER,      INTENT(IN   ) ::    &
                      ids,ide, jds,jde, kds,kde,      & 
                      ims,ime, jms,jme, kms,kme,      & 
                      its,ite, jts,jte, kts,kte 

    integer, intent(in) :: num_moist, num_chem
    integer, intent(out) ::  iter



!!!#include <fixed_decl_kpp_interf.inc>

    INTEGER,      INTENT(IN   ) :: id

    REAL,      INTENT(IN   ) :: dtstepc

!    TYPE(grid_config_rec_type),  INTENT(IN   )    :: config_flags


    REAL, DIMENSION( ims:ime, kms:kme, jms:jme, num_chem ),            &
                INTENT(INOUT ) ::                               chem


    REAL, DIMENSION( ims:ime, kms:kme, jms:jme, num_moist ),            &
                INTENT(IN ) ::                               moist



     REAL,  DIMENSION( ims:ime , kms:kme , jms:jme ),              &
             INTENT(IN   ) ::                                      &
                                                         p_phy,    &
                                                         t_phy,    &
                                                         rho_phy


! needed for aerosols

    INTEGER, INTENT ( IN ) :: ldrog

    REAL,      INTENT(INOUT) ::                                     &
                      vdrog3(ims:ime,kms:kme-0,jms:jme,ldrog)
!!!



! 
! radicals 
! 
      REAL, DIMENSION( ims:ime, kms:kme, jms:jme ),   & 
         INTENT(INOUT ) ::  & 
               addt, addx, addc, etep, oltp, & 
               olip, cslp, limp, hc5p, hc8p, & 
               tolp, xylp, apip, isop, hc3p, & 
               ethp, o3p, tco3, mo2, o1d, & 
               olnn, olnd, rpho, xo2, ketp, & 
               xno2, ol2p, oln, macp

! 
! photolysis rates 
! 
      REAL, DIMENSION( ims:ime, kms:kme, jms:jme ),   & 
         INTENT(INOUT ) ::  & 
               ph_o31d, ph_o33p, ph_no2, ph_no3o2, ph_no3o, & 
               ph_hno2, ph_hno3, ph_hno4, ph_h2o2, ph_ch2or, & 
               ph_ch2om, ph_ch3cho, ph_ch3coch3, ph_ch3coc2h5, ph_hcocho, & 
               ph_ch3cocho, ph_hcochest, ph_ch3o2h, ph_ch3coo2h, ph_ch3ono2, & 
               ph_hcochob, ph_macr, ph_n2o5, ph_o2, ph_pan, & 
               ph_acet, ph_mglo, ph_hno4_2 


!local variables 

    INTEGER, PARAMETER :: njv=28
    REAL(KIND=dp), DIMENSION(njv) :: jv


    REAL(KIND=dp):: TIME_START
    REAL(KIND=dp):: TIME_END

    INTEGER, DIMENSION(20) :: ICNTRL 
    REAL(KIND=dp), DIMENSION(20) :: RCNTRL
    INTEGER, DIMENSION(20) :: ISTATUS 
    REAL(KIND=dp), DIMENSION(20) :: RSTATUS
    INTEGER :: IERR_U

    REAL(KIND=dp), DIMENSION(NREACT):: RCONST 

    REAL(KIND=dp), DIMENSION(NVAR) :: var
    REAL(KIND=dp), DIMENSION(NFIX) :: fix

     !temperature (K)
    REAL(KIND=dp)   :: TEMP 

    REAL(KIND=dp), DIMENSION(NSPEC) :: ATOL, RTOL

    REAL(KIND=dp) :: conv, oconv 
    REAL(KIND=dp) :: C_M 

    INTEGER :: i,j,k,n 
 

integer iii


!!!#include <kpp_mechd_l_radm2sorg.inc> 

      REAL(KIND=dp)  :: rxylho,rtolho,rcslho,rcslno3,rhc8ho,roliho,rolino3,      &
                        rolio3,roltho,roltno3,rolto3,rapiho,rapino3,rapio3,      &
                        rlimho,rlimno3,rlimo3

      REAL(KIND=dp) , DIMENSION(ldrog)  :: PRDROG

    INTEGER, PARAMETER :: P_QV = 2


! for nrc_2o5
  REAL :: es, qvs, rh
  REAL( KIND = dp ) :: rc_n2o5
!!!

!initialization, individual parameters set below 
      DO n=1, 20
         ICNTRL(n) = 0
         RCNTRL(n) = 0._dp
      END DO

! CURRENTLY FROM in chem/KPP/module_wkppc_constants.F 
      DO n=1, NSPEC
         ATOL(n) = REAL(atols, KIND=dp)
         RTOL(n) = REAL(rtols, KIND=dp)
      END DO


      TIME_START = 0.0_dp 
      TIME_END =  REAL(dtstepc, KIND=dp) 

! SETTINGS FOR ICNTRL, RCNTRL IN in chem/KPP/inc/kpp_ctrl_default.inc 
!!!#include <kpp_ctrl_default.inc> 



! choose AUTONOMOUS option
   ICNTRL(1) = 1

! choose ros3
   ICNTRL(3) = 2

! set HSTART value:
   RCNTRL(3) = 0.01_dp * TIME_END
!!!


! empty file
!!!#include <kpp_mechd_b_radm2sorg.inc> 

iter = 0

!    DO j=jts, jte
!    DO k=kts, kte
!    DO i=its, ite
    DO j=jts, jts
    DO k=kts, kts
    DO i=its, its

      ! 3rd body concentration (molec/cm^3)
    FIX(indf_M)  = REAL(dens2con_a * rho_phy(i,k,j), KIND=dp)
    C_M = FIX(indf_M)

      ! water concentration (molec/cm^3)
    FIX(indf_H2O) = REAL(dens2con_w * moist(i,k,j,P_QV) * rho_phy(i,k,j), KIND=dp)


      ! temperature (K)
    TEMP = REAL(t_phy(i,k,j), KIND=dp)

      ! convesion from ppmV to molecules/cm3 and back
     conv=1.E-6_dp*dens2con_a*rho_phy(i,k,j)
     oconv = 1.E0_dp/conv


    jv(Pj_o31d) = REAL(ph_o31d(i,k,j)/60., KIND=dp) 
    jv(Pj_o33p) = REAL(ph_o33p(i,k,j)/60., KIND=dp) 
    jv(Pj_no2) = REAL(ph_no2(i,k,j)/60., KIND=dp) 
!write(0,'("ph_no2 ",e20.12)')ph_no2(i,k,j)
    jv(Pj_no3o2) = REAL(ph_no3o2(i,k,j)/60., KIND=dp) 
    jv(Pj_no3o) = REAL(ph_no3o(i,k,j)/60., KIND=dp) 
    jv(Pj_hno2) = REAL(ph_hno2(i,k,j)/60., KIND=dp) 
    jv(Pj_hno3) = REAL(ph_hno3(i,k,j)/60., KIND=dp) 
    jv(Pj_hno4) = REAL(ph_hno4(i,k,j)/60., KIND=dp) 
    jv(Pj_h2o2) = REAL(ph_h2o2(i,k,j)/60., KIND=dp) 
    jv(Pj_ch2or) = REAL(ph_ch2or(i,k,j)/60., KIND=dp) 
    jv(Pj_ch2om) = REAL(ph_ch2om(i,k,j)/60., KIND=dp) 
    jv(Pj_ch3cho) = REAL(ph_ch3cho(i,k,j)/60., KIND=dp) 
    jv(Pj_ch3coch3) = REAL(ph_ch3coch3(i,k,j)/60., KIND=dp) 
    jv(Pj_ch3coc2h5) = REAL(ph_ch3coc2h5(i,k,j)/60., KIND=dp) 
    jv(Pj_hcocho) = REAL(ph_hcocho(i,k,j)/60., KIND=dp) 
    jv(Pj_ch3cocho) = REAL(ph_ch3cocho(i,k,j)/60., KIND=dp) 
    jv(Pj_hcochest) = REAL(ph_hcochest(i,k,j)/60., KIND=dp) 
    jv(Pj_ch3o2h) = REAL(ph_ch3o2h(i,k,j)/60., KIND=dp) 
    jv(Pj_ch3coo2h) = REAL(ph_ch3coo2h(i,k,j)/60., KIND=dp) 
    jv(Pj_ch3ono2) = REAL(ph_ch3ono2(i,k,j)/60., KIND=dp) 
    jv(Pj_hcochob) = REAL(ph_hcochob(i,k,j)/60., KIND=dp) 
    jv(Pj_macr) = REAL(ph_macr(i,k,j)/60., KIND=dp) 
    jv(Pj_n2o5) = REAL(ph_n2o5(i,k,j)/60., KIND=dp) 
    jv(Pj_o2) = REAL(ph_o2(i,k,j)/60., KIND=dp) 
    jv(Pj_pan) = REAL(ph_pan(i,k,j)/60., KIND=dp) 
    jv(Pj_acet) = REAL(ph_acet(i,k,j)/60., KIND=dp) 
    jv(Pj_mglo) = REAL(ph_mglo(i,k,j)/60., KIND=dp) 
    jv(Pj_hno4_2) = REAL(ph_hno4_2(i,k,j)/60., KIND=dp) 

#if 0
write(0,*)'chem(i,k,j,P_o3)',chem(i,k,j,P_o3)
write(0,*)'chem(i,k,j,P_h2o2)',chem(i,k,j,P_h2o2)
write(0,*)'chem(i,k,j,P_no)',chem(i,k,j,P_no)
write(0,*)'chem(i,k,j,P_no2)',chem(i,k,j,P_no2)
write(0,*)'chem(i,k,j,P_no3)',chem(i,k,j,P_no3)
write(0,*)'chem(i,k,j,P_n2o5)',chem(i,k,j,P_n2o5)
write(0,*)'chem(i,k,j,P_hono)',chem(i,k,j,P_hono)
write(0,*)'chem(i,k,j,P_hno3)',chem(i,k,j,P_hno3)
write(0,*)'chem(i,k,j,P_hno4)',chem(i,k,j,P_hno4)
write(0,*)'chem(i,k,j,P_so2)',chem(i,k,j,P_so2)
write(0,*)'chem(i,k,j,P_sulf)',chem(i,k,j,P_sulf)
write(0,*)'chem(i,k,j,P_co)',chem(i,k,j,P_co)
write(0,*)'chem(i,k,j,P_eth)',chem(i,k,j,P_eth)
write(0,*)'chem(i,k,j,P_hc3)',chem(i,k,j,P_hc3)
write(0,*)'chem(i,k,j,P_hc5)',chem(i,k,j,P_hc5)
write(0,*)'chem(i,k,j,P_hc8)',chem(i,k,j,P_hc8)
write(0,*)'chem(i,k,j,P_ol2)',chem(i,k,j,P_ol2)
write(0,*)'chem(i,k,j,P_olt)',chem(i,k,j,P_olt)
write(0,*)'chem(i,k,j,P_oli)',chem(i,k,j,P_oli)
write(0,*)'chem(i,k,j,P_iso)',chem(i,k,j,P_iso)
write(0,*)'chem(i,k,j,P_tol)',chem(i,k,j,P_tol)
write(0,*)'chem(i,k,j,P_xyl)',chem(i,k,j,P_xyl)
write(0,*)'chem(i,k,j,P_csl)',chem(i,k,j,P_csl)
write(0,*)'chem(i,k,j,P_hcho)',chem(i,k,j,P_hcho)
write(0,*)'chem(i,k,j,P_ald)',chem(i,k,j,P_ald)
write(0,*)'ethp(i,k,j)',ethp(i,k,j)
write(0,*)'chem(i,k,j,P_ket)',chem(i,k,j,P_ket)
write(0,*)'chem(i,k,j,P_gly)',chem(i,k,j,P_gly)
write(0,*)'chem(i,k,j,P_mgly)',chem(i,k,j,P_mgly)
write(0,*)'mo2(i,k,j)',mo2(i,k,j)
write(0,*)'chem(i,k,j,P_dcb)',chem(i,k,j,P_dcb)
write(0,*)'chem(i,k,j,P_onit)',chem(i,k,j,P_onit)
write(0,*)'chem(i,k,j,P_pan)',chem(i,k,j,P_pan)
write(0,*)'chem(i,k,j,P_tpan)',chem(i,k,j,P_tpan)
write(0,*)'chem(i,k,j,P_op1)',chem(i,k,j,P_op1)
write(0,*)'chem(i,k,j,P_op2)',chem(i,k,j,P_op2)
write(0,*)'chem(i,k,j,P_paa)',chem(i,k,j,P_paa)
write(0,*)'chem(i,k,j,P_ora1)',chem(i,k,j,P_ora1)
write(0,*)'chem(i,k,j,P_ora2)',chem(i,k,j,P_ora2)
write(0,*)'chem(i,k,j,P_HO)',chem(i,k,j,P_HO)
write(0,*)'chem(i,k,j,P_ho2)',chem(i,k,j,P_ho2)
write(0,*)'o3p(i,k,j)',o3p(i,k,j)
write(0,*)'o1d(i,k,j)',o1d(i,k,j)
write(0,*)'hc3p(i,k,j)',hc3p(i,k,j)
write(0,*)'hc5p(i,k,j)',hc5p(i,k,j)
write(0,*)'hc8p(i,k,j)',hc8p(i,k,j)
write(0,*)'oltp(i,k,j)',oltp(i,k,j)
write(0,*)'olip(i,k,j)',olip(i,k,j)
write(0,*)'tolp(i,k,j)',tolp(i,k,j)
write(0,*)'xylp(i,k,j)',xylp(i,k,j)
write(0,*)'chem(i,k,j,P_aco3)',chem(i,k,j,P_aco3)
write(0,*)'tco3(i,k,j)',tco3(i,k,j)
write(0,*)'ketp(i,k,j)',ketp(i,k,j)
write(0,*)'oln(i,k,j)',oln(i,k,j)
write(0,*)'xo2(i,k,j)',xo2(i,k,j)
write(0,*)'xno2(i,k,j)',xno2(i,k,j)
write(0,*)'chem(i,k,j,P_ch4)',chem(i,k,j,P_ch4)
write(0,*)'chem(i,k,j,P_co2)',chem(i,k,j,P_co2)
write(0,*)'ol2p(i,k,j)',ol2p(i,k,j)

var(ind_O3) =  chem(i,k,j,P_o3)
var(ind_H2O2) =  chem(i,k,j,P_h2o2)
var(ind_NO) =  chem(i,k,j,P_no)
var(ind_NO2) =  chem(i,k,j,P_no2)
var(ind_NO3) =  chem(i,k,j,P_no3)
var(ind_N2O5) =  chem(i,k,j,P_n2o5)
var(ind_HONO) =  chem(i,k,j,P_hono)
var(ind_HNO3) =  chem(i,k,j,P_hno3)
var(ind_HNO4) =  chem(i,k,j,P_hno4)
var(ind_SO2) =  chem(i,k,j,P_so2)
var(ind_SULF) =  chem(i,k,j,P_sulf)
var(ind_CO) =  chem(i,k,j,P_co)
var(ind_ETH) =  chem(i,k,j,P_eth)
var(ind_HC3) =  chem(i,k,j,P_hc3)
var(ind_HC5) =  chem(i,k,j,P_hc5)
var(ind_HC8) =  chem(i,k,j,P_hc8)
var(ind_OL2) =  chem(i,k,j,P_ol2)
var(ind_OLT) =  chem(i,k,j,P_olt)
var(ind_OLI) =  chem(i,k,j,P_oli)
var(ind_ISO) =  chem(i,k,j,P_iso)
var(ind_TOL) =  chem(i,k,j,P_tol)
var(ind_XYL) =  chem(i,k,j,P_xyl)
var(ind_CSL) =  chem(i,k,j,P_csl)
var(ind_HCHO) =  chem(i,k,j,P_hcho)
var(ind_ALD) =  chem(i,k,j,P_ald)
var(ind_ETHP) =   ethp(i,k,j)
var(ind_KET) =  chem(i,k,j,P_ket)
var(ind_GLY) =  chem(i,k,j,P_gly)
var(ind_MGLY) =  chem(i,k,j,P_mgly)
var(ind_MO2) =   mo2(i,k,j)
var(ind_DCB) =  chem(i,k,j,P_dcb)
var(ind_ONIT) =  chem(i,k,j,P_onit)
var(ind_PAN) =  chem(i,k,j,P_pan)
var(ind_TPAN) =  chem(i,k,j,P_tpan)
var(ind_OP1) =  chem(i,k,j,P_op1)
var(ind_OP2) =  chem(i,k,j,P_op2)
var(ind_PAA) =  chem(i,k,j,P_paa)
var(ind_ORA1) =  chem(i,k,j,P_ora1)
var(ind_ORA2) =  chem(i,k,j,P_ora2)
var(ind_OH) =  chem(i,k,j,P_HO)
var(ind_HO2) =  chem(i,k,j,P_ho2)
var(ind_O3P) =   o3p(i,k,j)
var(ind_O1D) =   o1d(i,k,j)
var(ind_HC3P) =   hc3p(i,k,j)
var(ind_HC5P) =   hc5p(i,k,j)
var(ind_HC8P) =   hc8p(i,k,j)
var(ind_OLTP) =   oltp(i,k,j)
var(ind_OLIP) =   olip(i,k,j)
var(ind_TOLP) =   tolp(i,k,j)
var(ind_XYLP) =   xylp(i,k,j)
var(ind_ACO3) =  chem(i,k,j,P_aco3)
var(ind_TCO3) =   tco3(i,k,j)
var(ind_KETP) =   ketp(i,k,j)
var(ind_OLN) =   oln(i,k,j)
var(ind_XO2) =   xo2(i,k,j)
var(ind_XNO2) =   xno2(i,k,j)
var(ind_CH4) =  chem(i,k,j,P_ch4)
var(ind_CO2) =  chem(i,k,j,P_co2)
var(ind_OL2P) =   ol2p(i,k,j)

do iii=1,NVAR
write(0,'("F1 ",i3,e25.12)')iii,var(iii)
enddo
#endif

    var(ind_O3) = conv  * REAL( MAX(chem(i,k,j,P_o3),0.), KIND=dp)  
    var(ind_H2O2) = conv  * REAL( MAX(chem(i,k,j,P_h2o2),0.), KIND=dp)  
    var(ind_NO) = conv  * REAL( MAX(chem(i,k,j,P_no),0.), KIND=dp)  
    var(ind_NO2) = conv  * REAL( MAX(chem(i,k,j,P_no2),0.), KIND=dp)  
    var(ind_NO3) = conv  * REAL( MAX(chem(i,k,j,P_no3),0.), KIND=dp)  
    var(ind_N2O5) = conv  * REAL( MAX(chem(i,k,j,P_n2o5),0.), KIND=dp)  
    var(ind_HONO) = conv  * REAL( MAX(chem(i,k,j,P_hono),0.), KIND=dp)  
    var(ind_HNO3) = conv  * REAL( MAX(chem(i,k,j,P_hno3),0.), KIND=dp)  
    var(ind_HNO4) = conv  * REAL( MAX(chem(i,k,j,P_hno4),0.), KIND=dp)  
    var(ind_SO2) = conv  * REAL( MAX(chem(i,k,j,P_so2),0.), KIND=dp)  
    var(ind_SULF) = conv  * REAL( MAX(chem(i,k,j,P_sulf),0.), KIND=dp)  
    var(ind_CO) = conv  * REAL( MAX(chem(i,k,j,P_co),0.), KIND=dp)  
    var(ind_ETH) = conv  * REAL( MAX(chem(i,k,j,P_eth),0.), KIND=dp)  
    var(ind_HC3) = conv  * REAL( MAX(chem(i,k,j,P_hc3),0.), KIND=dp)  
    var(ind_HC5) = conv  * REAL( MAX(chem(i,k,j,P_hc5),0.), KIND=dp)  
    var(ind_HC8) = conv  * REAL( MAX(chem(i,k,j,P_hc8),0.), KIND=dp)  
    var(ind_OL2) = conv  * REAL( MAX(chem(i,k,j,P_ol2),0.), KIND=dp)  
    var(ind_OLT) = conv  * REAL( MAX(chem(i,k,j,P_olt),0.), KIND=dp)  
    var(ind_OLI) = conv  * REAL( MAX(chem(i,k,j,P_oli),0.), KIND=dp)  
    var(ind_ISO) = conv  * REAL( MAX(chem(i,k,j,P_iso),0.), KIND=dp)  
    var(ind_TOL) = conv  * REAL( MAX(chem(i,k,j,P_tol),0.), KIND=dp)  
    var(ind_XYL) = conv  * REAL( MAX(chem(i,k,j,P_xyl),0.), KIND=dp)  
    var(ind_CSL) = conv  * REAL( MAX(chem(i,k,j,P_csl),0.), KIND=dp)  
    var(ind_HCHO) = conv  * REAL( MAX(chem(i,k,j,P_hcho),0.), KIND=dp)  
    var(ind_ALD) = conv  * REAL( MAX(chem(i,k,j,P_ald),0.), KIND=dp)  
    var(ind_ETHP) =  conv * REAL( MAX(ethp(i,k,j),0.), KIND=dp)  
    var(ind_KET) = conv  * REAL( MAX(chem(i,k,j,P_ket),0.), KIND=dp)  
    var(ind_GLY) = conv  * REAL( MAX(chem(i,k,j,P_gly),0.), KIND=dp)  
    var(ind_MGLY) = conv  * REAL( MAX(chem(i,k,j,P_mgly),0.), KIND=dp)  
    var(ind_MO2) =  conv * REAL( MAX(mo2(i,k,j),0.), KIND=dp)  
    var(ind_DCB) = conv  * REAL( MAX(chem(i,k,j,P_dcb),0.), KIND=dp)  
    var(ind_ONIT) = conv  * REAL( MAX(chem(i,k,j,P_onit),0.), KIND=dp)  
    var(ind_PAN) = conv  * REAL( MAX(chem(i,k,j,P_pan),0.), KIND=dp)  
    var(ind_TPAN) = conv  * REAL( MAX(chem(i,k,j,P_tpan),0.), KIND=dp)  
    var(ind_OP1) = conv  * REAL( MAX(chem(i,k,j,P_op1),0.), KIND=dp)  
    var(ind_OP2) = conv  * REAL( MAX(chem(i,k,j,P_op2),0.), KIND=dp)  
    var(ind_PAA) = conv  * REAL( MAX(chem(i,k,j,P_paa),0.), KIND=dp)  
    var(ind_ORA1) = conv  * REAL( MAX(chem(i,k,j,P_ora1),0.), KIND=dp)  
    var(ind_ORA2) = conv  * REAL( MAX(chem(i,k,j,P_ora2),0.), KIND=dp)  
    var(ind_OH) = conv  * REAL( MAX(chem(i,k,j,P_HO),0.), KIND=dp)  
    var(ind_HO2) = conv  * REAL( MAX(chem(i,k,j,P_ho2),0.), KIND=dp)  
    var(ind_O3P) =  conv * REAL( MAX(o3p(i,k,j),0.), KIND=dp)  
    var(ind_O1D) =  conv * REAL( MAX(o1d(i,k,j),0.), KIND=dp)  
    var(ind_HC3P) =  conv * REAL( MAX(hc3p(i,k,j),0.), KIND=dp)  
    var(ind_HC5P) =  conv * REAL( MAX(hc5p(i,k,j),0.), KIND=dp)  
    var(ind_HC8P) =  conv * REAL( MAX(hc8p(i,k,j),0.), KIND=dp)  
    var(ind_OLTP) =  conv * REAL( MAX(oltp(i,k,j),0.), KIND=dp)  
    var(ind_OLIP) =  conv * REAL( MAX(olip(i,k,j),0.), KIND=dp)  
    var(ind_TOLP) =  conv * REAL( MAX(tolp(i,k,j),0.), KIND=dp)  
    var(ind_XYLP) =  conv * REAL( MAX(xylp(i,k,j),0.), KIND=dp)  
    var(ind_ACO3) = conv  * REAL( MAX(chem(i,k,j,P_aco3),0.), KIND=dp)  
    var(ind_TCO3) =  conv * REAL( MAX(tco3(i,k,j),0.), KIND=dp)  
    var(ind_KETP) =  conv * REAL( MAX(ketp(i,k,j),0.), KIND=dp)  
    var(ind_OLN) =  conv * REAL( MAX(oln(i,k,j),0.), KIND=dp)  
    var(ind_XO2) =  conv * REAL( MAX(xo2(i,k,j),0.), KIND=dp)  
    var(ind_XNO2) =  conv * REAL( MAX(xno2(i,k,j),0.), KIND=dp)  
    var(ind_CH4) = conv  * REAL( MAX(chem(i,k,j,P_ch4),0.), KIND=dp)  
    var(ind_CO2) = conv  * REAL( MAX(chem(i,k,j,P_co2),0.), KIND=dp)  
    var(ind_OL2P) =  conv * REAL( MAX(ol2p(i,k,j),0.), KIND=dp)  

#if 0
write(0,'("navgdro ",e25.12)')navgdro
write(0,'("mwair ",e25.12)')mwair
write(0,'("dens2con_a ",e25.12)')dens2con_a
write(0,'("rho_phy ",e25.12)')rho_phy(i,k,j)
write(0,'("conv ",e25.12)')conv
do iii=1,NVAR
write(0,'("F2 ",i3,e25.12)')iii,var(iii)
enddo
#endif

!!#include <kpp_mechd_ibu_radm2sorg.inc> 
!
! calculate rate constant for n2o5 + water in RADM2

  es  = 1000.*0.6112*exp(17.67*(t_phy(i,k,j)-273.15)/(t_phy(i,k,j)- 29.65))
  qvs = es / ( p_phy(i,k,j) - es )


  rh =  moist(i,k,j,P_QV) / qvs
  rh = MIN ( MAX ( rh, 0.), 1.)


  rc_n2o5 =  REAL(1.0 / ( 3.6E4 * EXP( -( rh / 0.28 ) ** 2.8 ) + 300.0 ), KIND=dp)
!!!



   CALL radm2sorg_Update_Rconst(  &
!
!#include <extra_args_to_update_rconst_radm2sorg.inc>
!
rc_n2o5, &
!
!
!#include <args_to_update_rconst.inc>
             jv, njv, &
             RCONST, &
             Pj_o31d, Pj_o33p, Pj_no2, Pj_no3o2, Pj_no3o, &
             Pj_hno2, Pj_hno3, Pj_hno4, Pj_h2o2, Pj_ch2or, &
             Pj_ch2om, Pj_ch3cho, Pj_ch3coch3, Pj_ch3coc2h5, Pj_hcocho, &
             Pj_ch3cocho, Pj_hcochest, Pj_ch3o2h, Pj_ch3coo2h, Pj_ch3ono2, &
             Pj_hcochob, Pj_macr, Pj_n2o5, Pj_o2, Pj_pan, &
             Pj_acet, Pj_mglo, Pj_hno4_2,  &
             C_M, FIX(indf_H2O), TEMP &
!
)

! empty file
!#include <kpp_mechd_ib_radm2sorg.inc> 




iter = iter + 1 
  CALL radm2sorg_INTEGRATE(TIME_START, TIME_END, &  
          FIX, VAR,  RCONST, ATOL, RTOL, & 
          ICNTRL_U=icntrl, RCNTRL_U=rcntrl  )





#if 0
!!!#include <kpp_mechd_ia_radm2sorg.inc> 

!
!
! CHECK, LUMPING
!



        if(p_nu0.gt.1)then

 !Note: the indices in the equation fiel are currently shifted by one starting
 ! from eq. 24 or so (check this)

            rxylho =   RCONST(59)     !ARR2(1.89D-11, -116.0_dp, TEMP);
            rtolho =   RCONST(58)     !ARR2(2.1D-12, -322.0_dp, TEMP);
            rcslho =   RCONST(60)     !4.0D-11 ;
            rcslno3 =  RCONST(96)     !2.2D-11 ;
            rhc8ho =   RCONST(54)     !ARR2(3.64D-11, 380.0_dp, TEMP);
            roliho =   RCONST(57)     !ARR2(1.07D-11, -549.0_dp, TEMP);
            rolino3 =  RCONST(99)    !ARR2(3.23D-11, 975.0_dp, TEMP);
            rolio3 =   RCONST(103)    !ARR2(7.29D-15, 1136.0_dp, TEMP);
            roltho =   RCONST(56)     !ARR2(5.32D-12, -504.0_dp, TEMP);
            roltno3 =  RCONST(98)     !ARR2(1.0D-11, 1895.0_dp, TEMP);
            rolto3 =   RCONST(102)    !ARR2(1.32D-14, 2105.0_dp, TEMP);

rapiho = 0._dp
rapino3 = 0._dp
rapio3 = 0._dp
rlimho = 0._dp
rlimno3 =  0._dp
rlimo3 = 0._dp


!!            rapiho =   RCONST(71)     !ARR(1.21e-11,-444.0,t_phy(i,k,j))))
!!            rapino3 =  RCONST(103)    !ARR(1.19e-12,-490.0,t_phy(i,k,j))))
!!            rapio3 =   RCONST(111)    !ARR(1.01e-15,736.0,t_phy(i,k,j)))) !! 732!!
!!            rlimho =   RCONST(72)     !ARR(1.71e-10,0.0,t_phy(i,k,j))))
!!            rlimno3 =  RCONST(104)    !ARR(1.22e-11,0.0,t_phy(i,k,j))))
!!            rlimo3 =   RCONST(112)    !ARR(2.00e-16,0.0,t_phy(i,k,j))))

            PRDROG(PXYL)  = rxylho * var(ind_xyl)*var(ind_oh)
            PRDROG(PTOL)  = rtolho * var(ind_tol)*var(ind_oh)
            PRDROG(PCSL1) = rcslho * var(ind_csl)*var(ind_oh)
            PRDROG(PCSL2) = 0.50_dp * rcslno3* var(ind_csl)*var(ind_no3)
            PRDROG(PHC8)  = rhc8ho * var(ind_hc8)*var(ind_oh)
            PRDROG(POLI1) = roliho * var(ind_oli)*var(ind_oh)
            PRDROG(POLI2) = rolino3 * var(ind_oli)*var(ind_no3)
            PRDROG(POLI3) = rolio3 * var(ind_oli)*var(ind_o3)
            PRDROG(POLT1) = roltho * var(ind_olt)*var(ind_oh)
            PRDROG(POLT2) = roltno3 * var(ind_olt)*var(ind_no3)
            PRDROG(POLT3) = rolto3 * var(ind_olt)*var(ind_o3)
!!            PRDROG(PAPI1) = rapiho * var(ind_api)*var(ind_oh)
!!            PRDROG(PAPI2) = rapino3 * var(ind_api)*var(ind_no3)
!!            PRDROG(PAPI3) = rapio3 * var(ind_api)*var(ind_o3)
!!            PRDROG(PLIM1) = rlimho * var(ind_lim)*var(ind_oh)
!!            PRDROG(PLIM2) = rlimno3 * var(ind_lim)*var(ind_no3)
!!            PRDROG(PLIM3) = rlimo3 * var(ind_lim)*var(ind_o3)

PRDROG(PAPI1) = 0._dp
PRDROG(PAPI2) = 0._dp
PRDROG(PAPI3) = 0._dp
PRDROG(PLIM1) = 0._dp
PRDROG(PLIM2) = 0._dp
PRDROG(PLIM3) = 0._dp

            DO n = 1, LDROG
               VDROG3( i,k,j, n ) =  oconv * PRDROG( n ) * DTSTEPC
               VDROG3( i,k,j,n  ) = MAX( 0., VDROG3( i,k,j, n ) )
            ENDDO
        endif
!!!
#endif

    chem(i,k,j,P_o3) = MAX ( REAL (oconv * var(ind_O3), KIND=sp), 0.)  
    chem(i,k,j,P_h2o2) = MAX ( REAL (oconv * var(ind_H2O2), KIND=sp), 0.)  
    chem(i,k,j,P_no) = MAX ( REAL (oconv * var(ind_NO), KIND=sp), 0.)  
    chem(i,k,j,P_no2) = MAX ( REAL (oconv * var(ind_NO2), KIND=sp), 0.)  
    chem(i,k,j,P_no3) = MAX ( REAL (oconv * var(ind_NO3), KIND=sp), 0.)  
    chem(i,k,j,P_n2o5) = MAX ( REAL (oconv * var(ind_N2O5), KIND=sp), 0.)  
    chem(i,k,j,P_hono) = MAX ( REAL (oconv * var(ind_HONO), KIND=sp), 0.)  
    chem(i,k,j,P_hno3) = MAX ( REAL (oconv * var(ind_HNO3), KIND=sp), 0.)  
    chem(i,k,j,P_hno4) = MAX ( REAL (oconv * var(ind_HNO4), KIND=sp), 0.)  
    chem(i,k,j,P_so2) = MAX ( REAL (oconv * var(ind_SO2), KIND=sp), 0.)  
    chem(i,k,j,P_sulf) = MAX ( REAL (oconv * var(ind_SULF), KIND=sp), 0.)  
    chem(i,k,j,P_co) = MAX ( REAL (oconv * var(ind_CO), KIND=sp), 0.)  
    chem(i,k,j,P_eth) = MAX ( REAL (oconv * var(ind_ETH), KIND=sp), 0.)  
    chem(i,k,j,P_hc3) = MAX ( REAL (oconv * var(ind_HC3), KIND=sp), 0.)  
    chem(i,k,j,P_hc5) = MAX ( REAL (oconv * var(ind_HC5), KIND=sp), 0.)  
    chem(i,k,j,P_hc8) = MAX ( REAL (oconv * var(ind_HC8), KIND=sp), 0.)  
    chem(i,k,j,P_ol2) = MAX ( REAL (oconv * var(ind_OL2), KIND=sp), 0.)  
    chem(i,k,j,P_olt) = MAX ( REAL (oconv * var(ind_OLT), KIND=sp), 0.)  
    chem(i,k,j,P_oli) = MAX ( REAL (oconv * var(ind_OLI), KIND=sp), 0.)  
    chem(i,k,j,P_iso) = MAX ( REAL (oconv * var(ind_ISO), KIND=sp), 0.)  
    chem(i,k,j,P_tol) = MAX ( REAL (oconv * var(ind_TOL), KIND=sp), 0.)  
    chem(i,k,j,P_xyl) = MAX ( REAL (oconv * var(ind_XYL), KIND=sp), 0.)  
    chem(i,k,j,P_csl) = MAX ( REAL (oconv * var(ind_CSL), KIND=sp), 0.)  
    chem(i,k,j,P_hcho) = MAX ( REAL (oconv * var(ind_HCHO), KIND=sp), 0.)  
    chem(i,k,j,P_ald) = MAX ( REAL (oconv * var(ind_ALD), KIND=sp), 0.)  
   ethp(i,k,j) = MAX (REAL (oconv * var(ind_ETHP) , KIND=sp),0.) 
    chem(i,k,j,P_ket) = MAX ( REAL (oconv * var(ind_KET), KIND=sp), 0.)  
    chem(i,k,j,P_gly) = MAX ( REAL (oconv * var(ind_GLY), KIND=sp), 0.)  
    chem(i,k,j,P_mgly) = MAX ( REAL (oconv * var(ind_MGLY), KIND=sp), 0.)  
   mo2(i,k,j) = MAX (REAL (oconv * var(ind_MO2) , KIND=sp),0.) 
    chem(i,k,j,P_dcb) = MAX ( REAL (oconv * var(ind_DCB), KIND=sp), 0.)  
    chem(i,k,j,P_onit) = MAX ( REAL (oconv * var(ind_ONIT), KIND=sp), 0.)  
    chem(i,k,j,P_pan) = MAX ( REAL (oconv * var(ind_PAN), KIND=sp), 0.)  
    chem(i,k,j,P_tpan) = MAX ( REAL (oconv * var(ind_TPAN), KIND=sp), 0.)  
    chem(i,k,j,P_op1) = MAX ( REAL (oconv * var(ind_OP1), KIND=sp), 0.)  
    chem(i,k,j,P_op2) = MAX ( REAL (oconv * var(ind_OP2), KIND=sp), 0.)  
    chem(i,k,j,P_paa) = MAX ( REAL (oconv * var(ind_PAA), KIND=sp), 0.)  
    chem(i,k,j,P_ora1) = MAX ( REAL (oconv * var(ind_ORA1), KIND=sp), 0.)  
    chem(i,k,j,P_ora2) = MAX ( REAL (oconv * var(ind_ORA2), KIND=sp), 0.)  
    chem(i,k,j,P_HO) = MAX ( REAL (oconv * var(ind_OH), KIND=sp), 0.)  
    chem(i,k,j,P_ho2) = MAX ( REAL (oconv * var(ind_HO2), KIND=sp), 0.)  
   o3p(i,k,j) = MAX (REAL (oconv * var(ind_O3P) , KIND=sp),0.) 
   o1d(i,k,j) = MAX (REAL (oconv * var(ind_O1D) , KIND=sp),0.) 
   hc3p(i,k,j) = MAX (REAL (oconv * var(ind_HC3P) , KIND=sp),0.) 
   hc5p(i,k,j) = MAX (REAL (oconv * var(ind_HC5P) , KIND=sp),0.) 
   hc8p(i,k,j) = MAX (REAL (oconv * var(ind_HC8P) , KIND=sp),0.) 
   oltp(i,k,j) = MAX (REAL (oconv * var(ind_OLTP) , KIND=sp),0.) 
   olip(i,k,j) = MAX (REAL (oconv * var(ind_OLIP) , KIND=sp),0.) 
   tolp(i,k,j) = MAX (REAL (oconv * var(ind_TOLP) , KIND=sp),0.) 
   xylp(i,k,j) = MAX (REAL (oconv * var(ind_XYLP) , KIND=sp),0.) 
    chem(i,k,j,P_aco3) = MAX ( REAL (oconv * var(ind_ACO3), KIND=sp), 0.)  
   tco3(i,k,j) = MAX (REAL (oconv * var(ind_TCO3) , KIND=sp),0.) 
   ketp(i,k,j) = MAX (REAL (oconv * var(ind_KETP) , KIND=sp),0.) 
   oln(i,k,j) = MAX (REAL (oconv * var(ind_OLN) , KIND=sp),0.) 
   xo2(i,k,j) = MAX (REAL (oconv * var(ind_XO2) , KIND=sp),0.) 
   xno2(i,k,j) = MAX (REAL (oconv * var(ind_XNO2) , KIND=sp),0.) 
    chem(i,k,j,P_ch4) = MAX ( REAL (oconv * var(ind_CH4), KIND=sp), 0.)  
    chem(i,k,j,P_co2) = MAX ( REAL (oconv * var(ind_CO2), KIND=sp), 0.)  
   ol2p(i,k,j) = MAX (REAL (oconv * var(ind_OL2P) , KIND=sp),0.) 



    END DO
    END DO
    END DO




!empty file
!#include <kpp_mechd_a_radm2sorg.inc> 




END SUBROUTINE  radm2sorg_interface


END MODULE module_kpp_radm2sorg_interf 

!empty file
!#include <kpp_mechd_e_radm2sorg.inc> 


