#!/bin/csh

#	Run the WRF restart with 2 domains.

#	This shell assumes that you have already built the WRF code for nesting
#	and that the real.exe and wrf.exe files exist.  It assumes that the input
#	data for the Jan00 case is in a "normal" location.  This code is executed
#	from the ./WRFV2/test/em_real directory.

#	Steps in the shell:
#	1. make fine grid ic, only a single time period
#	2. make coarse+fine grid forecast - 2 CG timesteps
#	3. restart coarse+fine grid forecast - 1 CG timestep
#	4. diff orig vs restart final fcst time

##################################################################################

#	1.
#	Make the fine grid namelist for a 1-time run for real

echo 1.1
sed -e '/^ end_day/s/25/24/' \
    -e '/^ sf_surface_physics/s/1/2/' \
    -e '/^ num_soil_layers/s/5/4/' \
    -e '/^ e_we/s/74,//' \
    -e '/^ e_sn/s/61,//' \
    -e '/^ dx/s/30000/10000/' \
    -e '/^ dy/s/30000/10000/' \
    namelist.input.jan00 >! namelist.input

#	Get the fine grid input data from the SI

echo 1.2
rm -rf wrf_real*d0* >& /dev/null
rm -rf wrfi* wrfb* >& /dev/null
rm -rf wrfout* >& /dev/null
rm -rf wrfr* >& /dev/null
rm -rf 1 >& /dev/null
rm -rf 2 >& /dev/null
if      ( ( `uname` == AIX ) && ( `hostname | cut -c 1-2` == bs ) ) then
	rm rsl*
	ln -sf /mmm/users/gill/WRF-data-EM/jan00/wrf_real*d02*24_12:00:00 wrf_real_input_em.d01.2000-01-24_12:00:00
else if ( ( `uname` == OSF1 ) && ( `hostname | cut -c 1-6` == joshua ) ) then
	ln -sf /users/gill/WRF-data-EM/jan00/wrf_real*d02*24_12:00:00 wrf_real_input_em.d01.2000-01-24_12:00:00
else if ( ( `uname` == Linux ) && ( `hostname` == bay-mmm ) ) then
	ln -sf /users/gill/WRF-data-EM/jan00/wrf_real*d02*24_12:00:00 wrf_real_input_em.d01.2000-01-24_12:00:00
endif

#	Run fine grid real

echo 1.3
if      ( ( `uname` == AIX ) && ( `hostname | cut -c 1-2` == bs ) ) then
	setenv MP_PROCS 1
	setenv MP_RMPOOL 1
	real.exe
else if ( ( `uname` == OSF1 ) && ( `hostname | cut -c 1-6` == joshua ) ) then
	real.exe
else if ( ( `uname` == Linux ) && ( `hostname` == bay-mmm ) ) then
	mpirun -np 1 -machinefile ./machfile real.exe
endif

#	Well, did the fine grid ic (remember, 1-time, no bc) work?

echo 1.4
set ic_size = `ls -ls wrfinput_d01 | awk ' { print $6 } '`
if ( $ic_size > 10000 ) then
	rm rsl*
	mv wrfinput_d01 wrfinput_d02
else
	echo fine grid ic 1 time wrong size
	exit ( 12 ) 
endif

##################################################################################

#	2.
#	Make the coarse grid namelist: 6 min forecast, output every 3 min, 
#	dump restart at 3 min intervals

echo 2.1
sed -e '/^ run_hours/s/12/0/' \
    -e '/^ run_minutes/s/0/6/' \
    -e '/^ frames_per_outfile/s/1000, 1000,/1, 1,/' \
    -e '/^ history_interval/s/180,  60,/3, 3,/' \
    -e '/^ restart_interval/s/5000/3/' \
    -e '/^ sf_surface_physics/s/1/2/g' \
    -e '/^ num_soil_layers/s/5/4/' \
    -e '/^ max_dom/s/1/2/' \
    -e '/^ input_from_file/s/false/true/' \
    namelist.input.jan00 >! namelist.input

#	Get the coarse grid input data from the SI

if      ( ( `uname` == AIX ) && ( `hostname | cut -c 1-2` == bs ) ) then
	ln -sf /mmm/users/gill/WRF-data-EM/jan00/wrf_real*d01* .
else if ( ( `uname` == OSF1 ) && ( `hostname | cut -c 1-6` == joshua ) ) then
	ln -sf /users/gill/WRF-data-EM/jan00/wrf_real*d01* .
else if ( ( `uname` == Linux ) && ( `hostname` == bay-mmm ) ) then
	ln -sf /users/gill/WRF-data-EM/jan00/wrf_real*d01* .
endif

#	Run coarse grid real

echo 2.2
if      ( ( `uname` == AIX ) && ( `hostname | cut -c 1-2` == bs ) ) then
	setenv MP_PROCS 1
	setenv MP_RMPOOL 1
	real.exe
else if ( ( `uname` == OSF1 ) && ( `hostname | cut -c 1-6` == joshua ) ) then
	real.exe
else if ( ( `uname` == Linux ) && ( `hostname` == bay-mmm ) ) then
	cat >! machfile << EOF
`hostname`
`hostname`
`hostname`
`hostname`
EOF
	mpirun -np 1 -machinefile ./machfile real.exe
endif

#	Well, did the coarse grid ic/bc work?

echo 2.3
set ic_size = `ls -ls wrfinput_d01 | awk ' { print $6 } '`
set bc_times = `ncdump -h wrfbdy_d01 | grep "Time = UNLIMITED" | cut -d"(" -f2 | cut -dc -f1`
if ( ( $ic_size > 10000 ) && ( $bc_times == 4 ) ) then
	rm rsl*
else
	echo coarse grid ic bc wrong size
	exit ( 2 ) 
endif

#	Run coarse+fine grid wrf

echo 2.4
if      ( ( `uname` == AIX ) && ( `hostname | cut -c 1-2` == bs ) ) then
	setenv MP_PROCS 1
	wrf.exe
else if ( ( `uname` == OSF1 ) && ( `hostname | cut -c 1-6` == joshua ) ) then
	wrf.exe
else if ( ( `uname` == Linux ) && ( `hostname` == bay-mmm ) ) then
	mpirun -np 2 -machinefile ./machfile wrf.exe
endif

#	Well, did the coarse+fine grid wrf work?

echo 2.5
set num_files = `ls -ls wrfout* | wc -l`
if ( $num_files == 6 ) then
	echo first wrf run worked, generated restart file
	rm rsl*
	if ( ! -d 1 ) mkdir 1
	mv wrfo* 1
else
	echo coarse grid wrf output wrong size
	exit ( 3 ) 
endif

##################################################################################

#	3.
#	Make the CG/FG forecast, starting at the first restart time.

echo 3.1
sed -e '/^ run_hours/s/12/0/' \
    -e '/^ run_minutes/s/0/3/' \
    -e '/^ start_minute/s/00,   00,/3, 3, /' \
    -e '/^ frames_per_outfile/s/1000, 1000,/1, 1,/' \
    -e '/^ history_interval/s/180,  60,/3, 3,/' \
    -e '/^ restart/s/.false.,/.true.,/' \
    -e '/^ sf_surface_physics/s/1/2/g' \
    -e '/^ num_soil_layers/s/5/4/' \
    -e '/^ max_dom/s/1/2/' \
    -e '/^ input_from_file/s/false/true/' \
    namelist.input.jan00 >! namelist.input

#	Run coarse+fine grid wrf

echo 3.2
if      ( ( `uname` == AIX ) && ( `hostname | cut -c 1-2` == bs ) ) then
	setenv MP_PROCS 1
	wrf.exe
else if ( ( `uname` == OSF1 ) && ( `hostname | cut -c 1-6` == joshua ) ) then
	wrf.exe
else if ( ( `uname` == Linux ) && ( `hostname` == bay-mmm ) ) then
	mpirun -np 2 -machinefile ./machfile wrf.exe
endif

#	Well, did the coarse+fine grid wrf work?

echo 3.5
set num_files = `ls -ls wrfout* | wc -l`
if ( $num_files == 4 ) then
	echo second wrf run worked, used restart file
	rm rsl*
	if ( ! -d 2 ) mkdir 2
	mv wrfo* 2
else
	echo coarse grid wrf output wrong size
	exit ( 3 ) 
endif

#	Diff the output from the first fcst and the second.

echo 4.1
echo CG: orig fcst vs restart fcst
if ( -e fort.88 ) rm fort.88
if ( -e fort.98 ) rm fort.98
../../external/io_netcdf/diffwrf 1/wrfout_d01_2000-01-24_12:06:00 2/wrfout_d01_2000-01-24_12:06:00 >& /dev/null
if ( ( -e fort.88 ) || ( -e fort.98 ) ) then
	echo FAIL restart bit for bit test for CG
else
	echo PASS restart bit for bit test for CG
endif

echo FG: orig fcst vs restart fcst 
if ( -e fort.88 ) rm fort.88
if ( -e fort.98 ) rm fort.98
../../external/io_netcdf/diffwrf 1/wrfout_d02_2000-01-24_12:06:00 2/wrfout_d02_2000-01-24_12:06:00 >& /dev/null
if ( ( -e fort.88 ) || ( -e fort.98 ) ) then
	echo FAIL restart bit for bit test for FG
else
	echo PASS restart bit for bit test for FG
endif
