	SUBROUTINE GETLENS(MBAY,LL,LEN0,LEN1,LEN2,LEN3,LEN4,LEN5)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    GETLENS
!   PRGMMR: ATOR             ORG: NP12       DATE: 2005-11-29
!
! ABSTRACT: THIS SUBROUTINE UNPACKS AND RETURNS ALL OF THE INDIVIDUAL
!   SECTION LENGTHS OF THE BUFR MESSAGE STORED IN ARRAY MBAY, UP TO A
!   SPECIFIED POINT.  IT WILL WORK ON ANY MESSAGE ENCODED USING BUFR
!   EDITION 2, 3 OR 4.  THE START OF THE BUFR MESSAGE (I.E. THE STRING
!   "BUFR") MUST BE ALIGNED ON THE FIRST FOUR BYTES OF MBAY.
!
! PROGRAM HISTORY LOG:
! 2005-11-29  J. ATOR    -- ORIGINAL AUTHOR
!
! USAGE:    CALL GETLENS (MBAY, LL, LEN0, LEN1, LEN2, LEN3, LEN4, LEN5)
!   INPUT ARGUMENT LIST:
!     MBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING
!                BUFR MESSAGE
!     LL       - INTEGER: NUMBER OF LAST SECTION FOR WHICH THE LENGTH
!                IS TO BE UNPACKED.  IN OTHER WORDS, SETTING LL = N
!                MEANS TO UNPACK THE LENGTHS OF SECTIONS 0 THROUGH N
!                (I.E. LEN0, LEN1,...,LEN(N)).  ANY SECTION LENGTHS
!                THAT ARE NOT UNPACKED ARE RETURNED WITH A DEFAULT
!                VALUE OF -1.
!
!   OUTPUT ARGUMENT LIST:
!     LEN0     - LENGTH OF SECTION 0 (= -1 IF NOT UNPACKED)
!     LEN1     - LENGTH OF SECTION 1 (= -1 IF NOT UNPACKED)
!     LEN2     - LENGTH OF SECTION 2 (= -1 IF NOT UNPACKED)
!     LEN3     - LENGTH OF SECTION 3 (= -1 IF NOT UNPACKED)
!     LEN4     - LENGTH OF SECTION 4 (= -1 IF NOT UNPACKED)
!     LEN5     - LENGTH OF SECTION 5 (= -1 IF NOT UNPACKED)
!
! REMARKS:
!    THIS ROUTINE CALLS:        IUPB     IUPBS01
!    THIS ROUTINE IS CALLED BY: CKTABA   CNVED4   DUMPBF   MESGBC
!                               MSGWRT   RDBFDX   UPDS3    WRITLC
!                               Normally not called by application
!                               programs but it could be.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

	DIMENSION   MBAY(*)

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

	LEN0 = -1
	LEN1 = -1
	LEN2 = -1
	LEN3 = -1
	LEN4 = -1
	LEN5 = -1

	IF(LL.LT.0) RETURN
	LEN0 = IUPBS01(MBAY,'LEN0') 

	IF(LL.LT.1) RETURN
	LEN1 = IUPBS01(MBAY,'LEN1') 

	IF(LL.LT.2) RETURN
	IAD2 = LEN0 + LEN1
	LEN2 = IUPB(MBAY,IAD2+1,24) * IUPBS01(MBAY,'ISC2')

	IF(LL.LT.3) RETURN
	IAD3 = IAD2 + LEN2
	LEN3 = IUPB(MBAY,IAD3+1,24)

	IF(LL.LT.4) RETURN
	IAD4 = IAD3 + LEN3
	LEN4 = IUPB(MBAY,IAD4+1,24)

	IF(LL.LT.5) RETURN
	LEN5 = 4

	RETURN
	END SUBROUTINE GETLENS
