	FUNCTION ICHKSTR(STR,CHR,N)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    ICHKSTR
!   PRGMMR: ATOR             ORG: NP12       DATE: 2005-11-29
!
! ABSTRACT: THIS FUNCTION COMPARES A SPECIFIED NUMBER OF CHARACTERS
!   FROM AN INPUT CHARACTER ARRAY AGAINST THE SAME NUMBER OF CHARACTERS
!   FROM AN INPUT CHARACTER STRING AND DETERMINES WHETHER THE TWO ARE
!   EQUIVALENT.  THE CHARACTER ARRAY IS ASSUMED TO BE IN ASCII, WHEREAS
!   THE CHARACTER STRING IS ASSUMED TO BE IN THE NATIVE CHARACTER SET
!   (I.E. ASCII OR EBCDIC) OF THE LOCAL MACHINE.
!
! PROGRAM HISTORY LOG:
! 2005-11-29  J. ATOR    -- ORIGINAL AUTHOR
!
! USAGE:    ICHKSTR (STR, CHR, N)
!   INPUT ARGUMENT LIST:
!     STR      - CHARACTER*(*): N-CHARACTER STRING IN ASCII OR EBCDIC,
!                DEPENDING ON THE NATIVE MACHINE
!     CHR      - CHARACTER*1: ARRAY OF N CHARACTERS IN ASCII
!     N        - INTEGER: NUMBER OF CHARACTERS TO BE COMPARED
!
!   OUTPUT ARGUMENT LIST:
!     ICHKSTR  - INTEGER: RETURN VALUE:
!                  0 = STR(1:N) AND (CHR(I),I=1,N) ARE EQUIVALENT
!                  1 = STR(1:N) AND (CHR(I),I=1,N) ARE NOT EQUIVALENT
!
! REMARKS:
!    THIS ROUTINE CALLS:        CHRTRNA
!    THIS ROUTINE IS CALLED BY: CRBMG    OPENBF   RDMSGB   RDMSGW
!                               READERME
!                               Normally not called by any application
!                               programs. 
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

	CHARACTER*(*) STR

	CHARACTER*80  CSTR
	CHARACTER*1   CHR(N)

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

!	Copy CHR into CSTR and, if necessary, convert the latter
!	to EBCDIC (i.e. if the local machine uses EBCDIC) so that
!	the subsequent comparison will always be valid.

	CALL CHRTRNA(CSTR,CHR,N)

!	Compare CSTR to STR.

	IF(CSTR(1:N).EQ.STR(1:N)) THEN
	    ICHKSTR = 0
	ELSE
	    ICHKSTR = 1
	ENDIF	

	RETURN
	END FUNCTION ICHKSTR
