      FUNCTION IUPM(CBAY,NBITS)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    IUPM
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS FUNCTION UNPACKS AND RETURNS A BINARY INTEGER WORD
!   CONTAINED WITHIN NBITS BITS OF A CHARACTER STRING CBAY, STARTING
!   WITH THE FIRST BIT OF THE FIRST BYTE OF CBAY.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
! 2003-11-04  J. WOOLLEN -- BIG-ENDIAN/LITTLE-ENDIAN INDEPENDENT (WAS
!                           IN DECODER VERSION)
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
!                           DOCUMENTATION; OUTPUTS MORE COMPLETE
!                           DIAGNOSTIC INFO WHEN ROUTINE TERMINATES
!                           ABNORMALLY
!
! USAGE:    IUPM (CBAY, NBITS)
!   INPUT ARGUMENT LIST:
!     CBAY     - CHARACTER*8: CHARACTER STRING CONTAINING PACKED
!                INTEGER
!     NBITS    - INTEGER: NUMBER OF BITS WITHIN CBAY TO BE UNPACKED
!
!   OUTPUT ARGUMENT LIST:
!     IUPM     - INTEGER: UNPACKED INTEGER WORD
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT     IREV
!    THIS ROUTINE IS CALLED BY: CHRTRNA  CRBMG    DXMINI   PKC
!                               PKTDD    RDBFDX   UPC      UPTDD
!                               WRDLEN   WRITDX
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      COMMON /HRDWRD/ NBYTW,NBITW,NREV,IORD(8)

      CHARACTER*128 BORT_STR
      CHARACTER*1   CBAY(8)
      CHARACTER*1   CINT(8)
      DIMENSION     INT(2)
      EQUIVALENCE   (CINT,INT)

!----------------------------------------------------------------------
!----------------------------------------------------------------------

      IF(NBITS.GT.NBITW) GOTO 900
      CINT = CBAY
      INT(1) = IREV(INT(1))
      IUPM = ISHFT(INT(1),NBITS-NBITW)

!  EXITS
!  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: IUPM - NUMBER OF BITS BEING UNPACKED'// &
       ', NBITS (",I4,"), IS > THE INTEGER WORD LENGTH ON THIS '// &
       'MACHINE, NBITW (",I3,")")') NBITS,NBITW
      CALL BORT(BORT_STR)
      END FUNCTION IUPM
