      SUBROUTINE NEMTBA(LUN,NEMO,MTYP,MSBT,INOD)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    NEMTBA
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE SEARCHES FOR MNEMONIC NEMO WITHIN THE
!  INTERNAL TABLE A ARRAYS HOLDING THE DICTIONARY TABLE (ARRAYS IN
!  COMMON BLOCK /TABABD/) AND, IF FOUND, RETURNS INFORMATION ABOUT THAT
!  MNEMONIC FROM WITHIN THESE ARRAYS.  IT IS IDENTICAL TO BUFR ARCHIVE
!  LIBRARY SUBROUTINE NEMTBAX EXCEPT IF NEMO IS NOT FOUND, THIS
!  SUBROUTINE MAKES AN APPROPRIATE CALL TO BUFR ARCHIVE LIBRARY
!  SUBROUTINE BORT.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1995-06-28  J. WOOLLEN -- INCREASED THE SIZE OF INTERNAL BUFR TABLE
!                           ARRAYS IN ORDER TO HANDLE BIGGER FILES
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"
! 1999-11-18  J. WOOLLEN -- THE NUMBER OF BUFR FILES WHICH CAN BE
!                           OPENED AT ONE TIME INCREASED FROM 10 TO 32
!                           (NECESSARY IN ORDER TO PROCESS MULTIPLE
!                           BUFR FILES UNDER THE MPI)
! 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
!                           DOCUMENTATION; OUTPUTS MORE COMPLETE
!                           DIAGNOSTIC INFO WHEN ROUTINE TERMINATES
!                           ABNORMALLY
!
! USAGE:    CALL NEMTBA (LUN, NEMO, MTYP, MSBT, INOD)
!   INPUT ARGUMENT LIST:
!     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
!     NEMO     - CHARACTER*(*): TABLE A MNEMONIC TO SEARCH FOR
!
!   OUTPUT ARGUMENT LIST:
!     MTYP     - INTEGER: MESSAGE TYPE CORRESPONDING TO NEMO
!     MSBT     - INTEGER: MESSAGE SUBTYPE CORRESPONDING TO NEMO
!     INOD     - INTEGER: POSITIONAL INDEX OF NEMO WITHIN INTERNAL
!                JUMP/LINK TABLE
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT
!    THIS ROUTINE IS CALLED BY: CMSGINI  COPYMG   CPYMEM   MSGINI
!                               OPENMB   OPENMG 
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      INCLUDE 'bufrlib.prm'

      COMMON /TABABD/ NTBA(0:NFILES),NTBB(0:NFILES),NTBD(0:NFILES), &
                      MTAB(MAXTBA,NFILES),IDNA(MAXTBA,NFILES,2), &
                      IDNB(MAXTBB,NFILES),IDND(MAXTBD,NFILES), &
                      TABA(MAXTBA,NFILES),TABB(MAXTBB,NFILES), &
                      TABD(MAXTBD,NFILES)

      CHARACTER*(*) NEMO
      CHARACTER*600 TABD
      CHARACTER*128 BORT_STR
      CHARACTER*128 TABB
      CHARACTER*128 TABA

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

!  LOOK FOR NEMO IN TABLE A
!  ------------------------

      DO I=1,NTBA(LUN)
      IF(TABA(I,LUN)(4:11).EQ.NEMO) THEN
         MTYP = IDNA(I,LUN,1)
         MSBT = IDNA(I,LUN,2)
         INOD = MTAB(I,LUN)
         IF(MTYP.LT.0 .OR. MTYP.GT.255) GOTO 901
         IF(MSBT.LT.0 .OR. MSBT.GT.255) GOTO 902
         GOTO 100
      ENDIF
      ENDDO
      GOTO 900

!  EXITS
!  -----

100   RETURN
900   WRITE(BORT_STR,'("BUFRLIB: NEMTBA - CAN''T FIND MNEMONIC ",A)') &
       NEMO
      CALL BORT(BORT_STR)
901   WRITE(BORT_STR,'("BUFRLIB: NEMTBA - INVALID MESSAGE TYPE (",I4,'// &
       '") RETURNED FOR MENMONIC ",A)') MTYP,NEMO
      CALL BORT(BORT_STR)
902   WRITE(BORT_STR,'("BUFRLIB: NEMTBA - INVALID MESSAGE SUBTYPE (",'// &
       'I4,") RETURNED FOR MENMONIC ",A)') MSBT,NEMO
      CALL BORT(BORT_STR)
      END SUBROUTINE NEMTBA
