	FUNCTION NMWRD(MBAY)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    NMWRD
!   PRGMMR: ATOR             ORG: NP20       DATE: 2005-11-29
!
! ABSTRACT: GIVEN AN INTEGER ARRAY CONTAINING SECTION ZERO FROM A
!   BUFR MESSAGE, THIS FUNCTION DETERMINES A COUNT OF MACHINE WORDS
!   (I.E. INTEGER ARRAY MEMBERS) THAT WILL HOLD THE ENTIRE MESSAGE.
!   NOTE THAT THIS COUNT MAY BE GREATER THAN THE MINIMUM NUMBER
!   OF WORDS REQUIRED TO HOLD THE MESSAGE.
!
! PROGRAM HISTORY LOG:
! 2005-11-29  J. ATOR    -- ORIGINAL AUTHOR
!
! USAGE:    NMWRD (MBAY)
!   INPUT ARGUMENT LIST:
!     MBAY     - INTEGER: *-WORD ARRAY CONTAINING SECTION ZERO
!                FROM A BUFR MESSAGE
!
!   OUTPUT ARGUMENT LIST:
!     NMWRD    - INTEGER: BUFR MESSAGE LENGTH (IN MACHINE WORDS)
!
! REMARKS:
!    THIS ROUTINE CALLS:        IUPBS01
!    THIS ROUTINE IS CALLED BY: COPYBF   LMSG   MSGWRT   PADMSG
!                               UFBMEM
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$
	
	COMMON /HRDWRD/ NBYTW,NBITW,NREV,IORD(8)

	DIMENSION MBAY(*)

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

	LENM = IUPBS01(MBAY,'LENM')
	IF(LENM.EQ.0) THEN
	    NMWRD = 0
	ELSE
	    NMWRD = ((LENM/8)+1)*(8/NBYTW)
	ENDIF

	RETURN
	END FUNCTION NMWRD
