      SUBROUTINE PARSTR(STR,TAGS,MTAG,NTAG,SEP,LIMIT80)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    PARSTR
!   PRGMMR: J. ATOR          ORG: NP12       DATE: 2007-01-19
!
! ABSTRACT: THIS SUBROUTINE PARSES A STRING CONTAINING ONE OR MORE
!   SUBSTRINGS INTO AN ARRAY OF SUBSTRINGS.  THE SEPARATOR FOR THE
!   SUBSTRINGS IS SPECIFIED DURING INPUT, AND MULTIPLE ADJACENT
!   OCCURRENCES OF THIS CHARACTER WILL BE TREATED AS A SINGLE
!   OCCURRENCE WHEN THE STRING IS ACTUALLY PARSED.
!
! PROGRAM HISTORY LOG:
! 2007-01-19  J. ATOR    -- BASED UPON SUBROUTINE PARSEQ
!
! USAGE:    CALL PARSTR (STR, TAGS, MTAG, NTAG, SEP, LIMIT80)
!   INPUT ARGUMENT LIST:
!     STR      - CHARACTER*(*): STRING
!     MTAG     - INTEGER: MAXIMUM NUMBER OF SUBSTRINGS TO BE PARSED
!                FROM STRING
!     SEP      - CHARACTER*1: SEPARATOR CHARACTER FOR SUBSTRINGS
!     LIMIT80  - LOGICAL: .TRUE. IF AN ABORT SHOULD OCCUR WHEN STR IS
!                LONGER THAN 80 CHARACTERS; INCLUDED FOR HISTORICAL
!                CONSISTENCY WITH OLD SUBROUTINE PARSEQ
!
!   OUTPUT ARGUMENT LIST:
!     TAGS     - CHARACTER*(*): MTAG-WORD ARRAY OF SUBSTRINGS (FIRST
!                NTAG WORDS FILLED)
!     NTAG     - INTEGER: NUMBER OF SUBSTRINGS RETURNED
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT2
!    THIS ROUTINE IS CALLED BY: GETNTBE  GETTBH   PARUSR   READLC
!                               SEQSDX   SNTBBE   UFBSEQ   UFBTAB
!                               UFBTAM   WRITLC
!                               Normally not called by any application
!                               programs but it could be.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      CHARACTER*(*) STR,TAGS(MTAG)
      CHARACTER*128 BORT_STR1,BORT_STR2
      CHARACTER*1   SEP
      LOGICAL       SUBSTR,LIMIT80

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

      LSTR = LEN(STR)
      LTAG = LEN(TAGS(1))
      IF( LIMIT80 .AND. (LSTR.GT.80) ) GOTO 900
      NTAG = 0
      NCHR = 0
      SUBSTR = .FALSE.

      DO I=1,LSTR

      IF( .NOT.SUBSTR .AND. (STR(I:I).NE.SEP) ) THEN
         NTAG = NTAG+1
         IF(NTAG.GT.MTAG) GOTO 901
         TAGS(NTAG) = ' '
      ENDIF

      IF( SUBSTR .AND. (STR(I:I).EQ.SEP) ) NCHR = 0
      SUBSTR = STR(I:I).NE.SEP

      IF(SUBSTR) THEN
         NCHR = NCHR+1
         IF(NCHR.GT.LTAG) GOTO 902
         TAGS(NTAG)(NCHR:NCHR) = STR(I:I)
      ENDIF

      ENDDO

!  EXITS
!  -----

      RETURN
900   WRITE(BORT_STR1,'("BUFRLIB: PARSTR - INPUT STRING (",A,") HAS ")') &
       STR
      WRITE(BORT_STR2,'(18X,"LENGTH (",I4,"), > LIMIT OF 80 CHAR.")') &
       LSTR
      CALL BORT2(BORT_STR1,BORT_STR2)
901   WRITE(BORT_STR1,'("BUFRLIB: PARSTR - INPUT STRING (",A,") '// &
       'CONTAINS",I4)') STR,NTAG
      WRITE(BORT_STR2,'(18X,"SUBSTRINGS, EXCEEDING THE LIMIT {",I4,'// &
       '" - THIRD (INPUT) ARGUMENT}")') MTAG
      CALL BORT2(BORT_STR1,BORT_STR2)
902   WRITE(BORT_STR1,'("BUFRLIB: PARSTR - INPUT STRING (",A,") ")') STR
      WRITE(BORT_STR2,'(18X,"CONTAINS A PARSED SUBSTRING WITH LENGTH '// &
       'EXCEEDING THE MAXIMUM OF",I4," CHARACTERS")') LTAG
      CALL BORT2(BORT_STR1,BORT_STR2)
      END SUBROUTINE PARSTR
