      SUBROUTINE UPB(NVAL,NBITS,IBAY,IBIT)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    UPB
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE UNPACKS AND RETURNS A BINARY INTEGER
!   CONTAINED WITHIN NBITS BITS OF IBAY, STARTING WITH BIT (IBIT+1).
!   ON OUTPUT, IBIT IS UPDATED TO POINT TO THE LAST BIT THAT WAS
!   UNPACKED.  THIS IS SIMILAR TO BUFR ARCHIVE LIBRARY SUBROUTINE UPBB,
!   EXCEPT IN UPBB IBIT IS NOT UPDATED UPON OUTPUT (AND THE ORDER OF
!   ARGUMENTS IS DIFFERENT).
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 2003-05-19  J. ATOR    -- ADDED CHECK FOR NBITS EQUAL TO ZERO
! 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
! 2003-11-04  J. WOOLLEN -- BIG-ENDIAN/LITTLE-ENDIAN INDEPENDENT (WAS
!                           IN DECODER VERSION)
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
!                           DOCUMENTATION
!
! USAGE:    CALL UPB (NVAL, NBITS, IBAY, IBIT)
!   INPUT ARGUMENT LIST:
!     NBITS    - INTEGER: NUMBER OF BITS OF IBAY WITHIN WHICH TO UNPACK
!                NVAL
!     IBAY     - INTEGER: *-WORD PACKED BINARY ARRAY CONTAINING PACKED
!                NVAL
!     IBIT     - INTEGER: BIT POINTER WITHIN IBAY INDICATING BIT AFTER
!                WHICH TO START UNPACKING
!
!   OUTPUT ARGUMENT LIST:
!     NVAL     - INTEGER: UNPACKED INTEGER
!     IBIT     - INTEGER: BIT POINTER WITHIN IBAY INDICATING LAST BIT
!                THAT WAS UNPACKED
!
! REMARKS:
!    THIS SUBROUTINE IS THE INVERSE OF BUFR ARCHIVE LIBRARY ROUTINE
!    PKB.
!
!    THIS ROUTINE CALLS:        IREV
!    THIS ROUTINE IS CALLED BY: COPYSB   IUPB     MVB      RDCMPS
!                               RDMGSB   READSB   STNDRD   UFBINX
!                               UFBPOS   UFBTAB   UFBTAM   UPC
!                               WRCMPS   WRITLC
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      COMMON /HRDWRD/ NBYTW,NBITW,NREV,IORD(8)

      DIMENSION IBAY(*)

!----------------------------------------------------------------------
!----------------------------------------------------------------------

!  IF NBITS=0, THEN JUST SET NVAL=0 AND RETURN
!  -------------------------------------------

      IF(NBITS.EQ.0)THEN
        NVAL=0
        GOTO 100
      ENDIF

      NWD = IBIT/NBITW + 1
      NBT = MOD(IBIT,NBITW)
      INT = ISHFT(IREV(IBAY(NWD)),NBT)
      INT = ISHFT(INT,NBITS-NBITW)
      LBT = NBT+NBITS
      IF(LBT.GT.NBITW) THEN
         JNT = IREV(IBAY(NWD+1))
         INT = IOR(INT,ISHFT(JNT,LBT-2*NBITW))
      ENDIF
      IBIT = IBIT+NBITS
      NVAL = INT

!  EXIT
!  ----

100   RETURN
      END SUBROUTINE UPB
