;+
; NAME:
;   CONTOURBAR
;
; PURPOSE:
;       The purpose of this routine is to add a color bar to the current
;       graphics window.
;
; AUTHOR:
;
;   David Ahijevych



pro contourbar, levels, colors, TITLE=title, FORMAT=format, POSITION=position, CHARSIZE=charsize

; extra input parameters I found:  orientation, spacing, linestyle, thick, 
; countour bar


; levels: 1-D array with contour interval markers to use
; colors: 1-D array with contour fill colors
; title: title for colorbar
; format: string format for labeling e.g. '(I3)'
; position: position for colorbar e.g.  [0.88,0.1,0.95,0.9]
; CHARSIZE: The character size of the color bar annotations. Default is 1.0.

ncolors = n_elements(colors)
nlevels = n_elements(levels)

col=1
if !p.multi[1] ne 0 then col=!p.multi[1]
if N_ELEMENTS(title) EQ 0 THEN title = ''
if ~KEYWORD_SET(position) THEN position = [0.2,0.04,0.8,0.06]
IF N_ELEMENTS(charsize) EQ 0 THEN charsize = 1.0
delta = (position[2]-position[0])/nlevels

; ytickformat='(A1)' supresses the yaxis labelling of the colorbar.
maxlength=max(strlen(strtrim(string(levels),1)))
; add 1 to maxlength to account for decimal point
fmt=strtrim(string(maxlength+1),1)
fmt='(f'+fmt+'.1)'

; Using scientific notation for color bar allows all numbers
; to be displayed no matter how small or large.
;  fmt='(e8.1)'
if n_elements(format) ne 0 then fmt = format


;======== Create boxes of color for color bar =========

FOR i = 0, nlevels-1 DO BEGIN
   x1 = position[0] + i*delta
   x2 = position[0] + (i+1)*delta
   polyfill, [x1,x1,x2,x2],[position[1],position[3],position[3],position[1]]*col,color=colors[i],/normal;, orientation=orientation[i], spacing=spacing[i], linestyle=linestyle[i], thick=thick[i]
ENDFOR

;======= Define colorbar labels. =========
; Stringify levels and append a blank element to the end.
labels = strarr(nlevels+1)
labels[0:nlevels-1] = string(levels,format=fmt)
labels[nlevels] = ' '

;======= Draw the colorbar outlines and labels. =========
; xtickname=labels takes the numbers used to define the 
; contour intervals and labels the colorbar with them.
plot, [levels[0],levels[nlevels-1]],[0,1],/nodata,xticks=(ncolors), $
  yticks=1, xstyle=1, ystyle=1, xticklen=1,$
  position=[position[0],position[1]*col,position[2],position[3]*col], $
  xrange=[levels[0],levels[nlevels-1]], $
  xtickname=labels, CHARSIZE=charsize, $
  ytickformat='(A1)', title=title, /noerase

END
