/************************************************************************
*                    
* MDV_MACROS.H : Meteorological Data Volume Format macro definitions
*                   
*************************************************************************/
#ifndef    MDV_MACROS_H
#define    MDV_MACROS_H

/* General defines used by the MDV library. */

#define MDV_SUCCESS 0
#define MDV_FAILURE -1

#define MDV_ENCODE_KEY 255

/* How the data were generated -- Collection Type*/
#define     MDV_DATA_MEASURED         0     /* from some instrument */
#define     MDV_DATA_EXTRAPOLATED     1     /* based on measured data */
#define     MDV_DATA_FORECAST         2     /* Numerically modeled */
#define     MDV_DATA_SYNTHESIS        3     /* A synthesis of modeled, 
                                               measured data */
#define     MDV_DATA_MIXED            4     /* Different types of data 
                                               in dataset */

/* How the array is positioned on the earth. 
   Note: ORIENT_SN_WE is always supported */
#define     MDV_ORIENT_OTHER          0     /* Not a typical grid 
                                               spherical coords, etc */
#define     MDV_ORIENT_SN_WE          1     /* This is the standard ordering */
#define     MDV_ORIENT_NS_WE          2
#define     MDV_ORIENT_SN_EW          3
#define     MDV_ORIENT_NS_EW          4

/* Projection type */
#define     MDV_PROJ_NATIVE           -1
#define     MDV_PROJ_LATLON           0   /* x,y in degrees. 
                                             z defined by vert proj type */
#define     MDV_PROJ_ARTCC            1   /* x,y in km */
#define     MDV_PROJ_STEREOGRAPHIC    2   /* x,y in km */
#define     MDV_PROJ_LAMBERT_CONF     3   /* x,y in km */
#define     MDV_PROJ_MERCATOR         4   /* x,y in km */
#define     MDV_PROJ_POLAR_STEREO     5   /* x,y in km */
#define     MDV_PROJ_POLAR_ST_ELLIP   6   /* x,y in km */
#define     MDV_PROJ_CYL_EQUIDIST     7   /* x,y in km */
#define     MDV_PROJ_FLAT             8   /* Cartesian, x,y in km. 
                                             z defined by vert proj type*/
#define     MDV_PROJ_POLAR_RADAR      9   /* Radial range, Azimuth angle,
                                           * x is gate spacing in km .
                                           * y is azimuth in degrees. from
					   * true north + is clockwise
					   * z is elevation angle in degrees. 
                                           */
#define     MDV_PROJ_RADIAL          10   /* x = Radias, Meters,
					   * y = azmith in degrees
					   * z = Defined by MDV_VERT_TYPE...
					   */
#define     MDV_PROJ_UNKNOWN         99

/* Describes the order of the data in the arrays 
   Note: ORDER_XYZ must be supported */
#define     MDV_ORDER_XYZ             0
#define     MDV_ORDER_YXZ             1
#define     MDV_ORDER_XZY             2
#define     MDV_ORDER_YZX             3
#define     MDV_ORDER_ZXY             4
#define     MDV_ORDER_ZYX             5

/* Vertical Type */
#define     MDV_VERT_TYPE_SURFACE     1  
#define     MDV_VERT_TYPE_SIGMA_P     2
#define     MDV_VERT_TYPE_PRESSURE    3    /* Units = mb  */
#define     MDV_VERT_TYPE_Z           4    /* Constant altitude; 
                                              units = Km MSL */
#define     MDV_VERT_TYPE_SIGMA_Z     5
#define     MDV_VERT_TYPE_ETA         6
#define     MDV_VERT_TYPE_THETA       7    /* Isentropic surface, 
                                              units = Kelvin */
#define     MDV_VERT_TYPE_MIXED       8    /* Any hybrid grid */
#define     MDV_VERT_TYPE_ELEV        9    /* Elevation angles */
#define     MDV_VERT_TYPE_COMPOSITE  10    /* A Composite of a set of planes */
#define     MDV_VERT_TYPE_CROSS_SEC  11    /* Cross sectional view of a 
                                              set of planes */
#define     MDV_VERT_SATELLITE_IMAGE 12    /* Satelite Image */

/* Binary encoding of the data in the arrays. */
#define MDV_NATIVE                    0    /* Whatever units the data 
                                              is already in */
#define MDV_INT8                      1    /* Uncompressed 8 bit 
                                              unsigned integers */
#define MDV_INT16                     2    /* Uncompressed 16 bit 
                                              unsigned integers */
#define MDV_INT32                     3    /* Uncompressed 32 bit 
                                              unsigned integers */
#define MDV_INT64                     4    /* Uncompressed 64 bit 
                                              unsigned integers */
#define MDV_FLOAT32                   5    /* Uncompressed 32 bit 
                                              signed IEEE Floats */
#define MDV_FLOAT64                   6    /* Uncompressed 64 bit 
                                              signed IEEE Floats */

/* The following compression schemes use the "MDV compression" format to 
 * encode/decode plane or rows with the RLE8 compression scheme.  Please see 
 * <mdv/mdv_file.h> for a description of the compression schemes used by
 * MDV.
 */

#define MDV_PLANE_RLE8               10    /* Each plane encoded/decoded 
                                              using run-length encoding on
					      the bytes in the data. */
#define MDV_ROW_RLE8                 11    /* Each row encoded/decoded 
					      using run-length encoding on
					      the bytes in the data. */


/* Chunk ids */

#define MDV_CHUNK_DOBSON_VOL_PARAMS        0
#define MDV_CHUNK_DOBSON_ELEVATIONS        1
#define MDV_CHUNK_NOWCAST_DATA_TIMES       2

#endif /*    MDV_MACROS_H */

