      PROGRAM readWSImdv

      IMPLICIT NONE


      REAL data
c WSI NOWrad data array is 3661 by 1837.
c If you change this, make sure you change it in the MDV_READ subroutine also.
      DIMENSION DATA(3661,1837)

      CHARACTER*256 FNAME


      INTEGER i,j,nhigh
      INTEGER itime, nx,ny,idate,iargc
      REAL    x1,x2,y1,y2,xd,yd,bad


c Read file name - full or relative path.
      IF (iargc() .LT. 1) THEN
         WRITE(*,*) 'Usage: sample_read filename'
         STOP
      ENDIF
      CALL GETARG(1,fname)
      WRITE(*,*) 'filename ='//fname

c Call the MDV read routine. 
c
c
c FNAME : mdv file name
c 
c Populate the following variables with information from the MDV file
c
c ITIME : 10000*ihr+100*imin+isec
c DATA  : Data Array 
c x1    : west boundary (deg_E)
c x2    : east boundary (deg_E)
c y1    : south boundary (deg_N) 
c y2    : north boundary (deg_N)
c xd    : delta x (deg_E)                   
c yd    : delta y (deg_N)
c nx,ny : number of columns, rows
c bad   : bad data value
c idate : 10000*iyr+100*imon+iday
c z1,z2,zd,nz : not needed, since MDV file has no z-dimension.
c

         CALL GET_MDV(FNAME,ITIME,DATA,
     +   X1,X2,Y1,Y2,XD,YD,NX,NY,BAD,IDATE)

      PRINT 101,IDATE,ITIME
 101  FORMAT(1X,'DATE,TIME= ',I8,1X,I8)
      PRINT 102,X1,X2,XD,NX
      PRINT 103,Y1,Y2,YD,NY
      WRITE(*,*) 'BAD=',BAD
 102  FORMAT(1X,'X1,X2,XD,NX= ',2F10.3,F10.6,I5)
 103  FORMAT(1X,'Y1,Y2,YD,NY= ',2F10.3,F10.6,I5)
 

c Linux f77 compiler did not initialize variables (such as nhigh) to zero.
      nhigh = 0 
      do i = 1,3661
         do j=1,1837
            if(DATA(i,j).gt.50.)nhigh=nhigh+1
         enddo
      enddo
      WRITE(*,*)nhigh,' pixels above 50 dBZ'

c output data array to unformatted binary file fort.90
      OPEN(UNIT=90,STATUS='UNKNOWN',FORM='UNFORMATTED')
      WRITE(*,*)'writing data array to unformatted binary file fort.90'
      WRITE(90) data
      CLOSE(90)

      END





















      SUBROUTINE GET_MDV(FNAME,ITIME,DATA,
     +   X1,X2,Y1,Y2,XD,YD,NX,NY,BAD,IDATE)

      real data
      DIMENSION DATA(3661,1837)
      character*1024 fname
c
c  Written by:  Nancy Rehak
c               5 June 1997
c  Simplifed by: David Ahijevych
c                Sep 2006


      include "mf_mdv.inc"

      integer MAX_DATA_SIZE
      parameter (MAX_DATA_SIZE = 10000000)



c     Master header information
      integer*4 master_hdr_ints(MDV_NUM_MASTER_HEADER_SI32)
      real*4    master_hdr_reals(MDV_NUM_MASTER_HEADER_FL32)
      character*(MDV_INFO_LEN) dataset_info
      character*(MDV_NAME_LEN) dataset_name
      character*(MDV_NAME_LEN) dataset_source

c     Field header information
      integer*4 field_hdr_ints(MDV_NUM_FIELD_HEADER_SI32)
      real*4    field_hdr_reals(MDV_NUM_FIELD_HEADER_FL32)
      character*(MDV_LONG_FIELD_LEN) field_name_long
      character*(MDV_SHORT_FIELD_LEN) field_name_short
      character*(MDV_UNITS_LEN) field_units
      character*(MDV_TRANSFORM_LEN) field_transform
      character*(MDV_UNITS_LEN) field_unused_char

c     Field data
      byte field_data_array(MAX_DATA_SIZE)
      integer return_data_size
      integer data_offset_value
      real data_value

c     Vlevel header information
      integer*4 vlevel_hdr_ints(MDV_NUM_VLEVEL_HEADER_SI32)
      real*4    vlevel_hdr_reals(MDV_NUM_VLEVEL_HEADER_FL32)

c     Chunk header information
      integer*4 chunk_hdr_ints(MDV_NUM_CHUNK_HEADER_SI32)
      character*(MDV_CHUNK_INFO_LEN) chunk_info
      character*8 dum1
      integer return_status

      integer i, j
      integer field_num
c
c     Read in the master header
c

      call readmasterhdr(fname,
     &                         master_hdr_ints, master_hdr_reals,
     &                         dataset_info, dataset_name,
     &                         dataset_source, return_status)


      if (return_status .ne. MDV_READ_SUCCESSFUL) then
         print *, "Error ", return_status, " reading master header"
         stop
      end if

      call printmasterhdr(master_hdr_ints, master_hdr_reals,
     &                         dataset_info, dataset_name,
     &                         dataset_source)


      call unixtime(master_hdr_ints(MDV_MH_TIME_CENTROID_INDEX),
     +   iyr,imon,iday,ihr,imin,isec)

       
      itime=10000*ihr+100*imin+isec
      idate=10000*iyr+100*imon+iday
      isec=3600*ihr+60*imin+isec
      write(*,*)'master lat=',master_hdr_reals(MDV_MH_SENSOR_LAT_INDEX)
      write(*,*)'master lon=',master_hdr_reals(MDV_MH_SENSOR_LON_INDEX)
c
c     Read and process field in file
c
      field_num = 0

c
c     Read and process the field header
c

      call readfieldhdr(fname, field_num,
     &                         field_hdr_ints, field_hdr_reals,
     &                         field_name_long, field_name_short,
     &                         field_units, field_transform,
     &                         field_unused_char, dum1,
     &                         return_status)

      nx=field_hdr_ints(MDV_FH_NX_INDEX)
      ny=field_hdr_ints(MDV_FH_NY_INDEX)
      nz=field_hdr_ints(MDV_FH_NZ_INDEX)
      x1=field_hdr_reals(MDV_FH_GRID_MINX_INDEX)
      y1=field_hdr_reals(MDV_FH_GRID_MINY_INDEX)
      z1=field_hdr_reals(MDV_FH_GRID_MINZ_INDEX)
      xd=field_hdr_reals(MDV_FH_GRID_DX_INDEX)
      yd=field_hdr_reals(MDV_FH_GRID_DY_INDEX)
      zd=field_hdr_reals(MDV_FH_GRID_DZ_INDEX)
      bad = field_hdr_reals(MDV_FH_BAD_DATA_VALUE_INDEX)
      write(*,*)'field header lat= ',
     +    field_hdr_reals(MDV_FH_PROJ_ORIGIN_LAT_INDEX)
      write(*,*)'field header lon= ',
     +    field_hdr_reals(MDV_FH_PROJ_ORIGIN_LON_INDEX)
      x2=x1+(nx-1)*xd
      y2=y1+(ny-1)*yd
      z2=z1+(nz-1)*zd
      IF(PXMAX.LE.PXMIN)THEN
         PXMIN=X1
         PXMAX=X2
         PYMIN=Y1
         PYMAX=Y2
      END IF
      write(*,*)'nx,ny,nz= ',nx,ny,nz


c     Sanity check. There should be only one vertical level.
      IF (nz .ne. 1) STOP
c     There should be only one field.
      IF (master_hdr_ints(MDV_MH_N_FIELDS_INDEX) .ne. 1) STOP


      if (return_status .ne. MDV_READ_SUCCESSFUL) then
         print *, "Error ", return_status, " reading field ",
     &        field_num, " header"
         stop
      end if

      call printfieldhdr(field_hdr_ints, field_hdr_reals,
     &                         field_name_long, field_name_short,
     &                         field_units, field_transform,
     &                         field_unused_char)


c
c     Read and process vlevel header, if there is one
c
      if (master_hdr_ints(MDV_MH_VLEVEL_INCLUDED_INDEX) .ne. 0) then
         call readvlevelhdr(fname, field_num,
     &                         vlevel_hdr_ints, vlevel_hdr_reals,
     &                         return_status)

         if (return_status .ne. MDV_READ_SUCCESSFUL) then
            print *, "Error ", return_status, " reading field ",
     &             field_num, " vlevel header"
            stop
         end if


         call printvlevelhdr(vlevel_hdr_ints,
     &                         vlevel_hdr_reals,
     &                         field_hdr_ints(MDV_FH_NZ_INDEX),
     &                         field_name_long)
      end if

c
c        Read and print field data.  Make sure we were successful
c        in reading the data before we try to print it.  It could be
c        that our data array was too small.
c

      call readfielddata(fname, field_num,
     &                          field_data_array, MAX_DATA_SIZE,
     &                          MDV_INT8, return_data_size,
     &                          return_status)

      write(*,*)'getmdv-return-data-size= ',return_data_size
      if (return_status .eq. MDV_READ_SUCCESSFUL) then
         print *, " "
         print *, "Successfully read data for field ", field_num
         print *, " "

         j=1
         do jj=1,ny
            do ii=1,nx
             if (field_data_array(j) .lt. 0) then
               data_offset_value = field_data_array(j) + 256
             else
               data_offset_value = field_data_array(j)
             end if



             if (data_offset_value .eq.
     &               field_hdr_reals(MDV_FH_BAD_DATA_VALUE_INDEX) .or.
     &           data_offset_value .eq.
     &               field_hdr_reals(MDV_FH_MISSING_DATA_VALUE_INDEX))
     &       then                                   
                data(ii,jj)=bad
             else

                data(ii,jj) = (data_offset_value *
     &              field_hdr_reals(MDV_FH_SCALE_INDEX)) +
     &                 field_hdr_reals(MDV_FH_BIAS_INDEX)
c               print *, "data value at ", j, " is ", data_value
             end if

             j=j+1

            enddo
         enddo

      else if (return_status .eq. MDV_READ_DATA_ARRAY_TOO_SMALL) then
         print *, " "
         print *, "Data array too small for field ", field_num
         print *, "   Array is ", MAX_DATA_SIZE, " bytes long"
         print *, "   Data is ", return_data_size, " bytes long"
         print *, " "
      else
         print *, "Error ", return_status, " reading field ",
     &           field_num, " data"
         stop
      end if

      return
      end
c
c----------------------------------------------------------------------X
c
      subroutine unixtime(it,iyr,imon,iday,ihr,imin,isec)
c
c     Leap years: 1976, 1980, 1984, 1988, 1992, 1996, 2000, 2004, ...
c        31-day month has 2678400 seconds
c        30-day month has 2592000 seconds
c        28-day month has 2419200 seconds
c
      dimension daymon(12),isecmon(12)
c     data months/Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec/
      data daymon/31.,28.,31.,30.,31.,30.,31.,31.,30.,31.,30.,31./
      data isecmon/2678400,2419200,2678400,2592000,2678400,
     X    2592000,2678400,2678400,2592000,2678400,2592000,
     X    2678400/
      data nmon/12/


      itime=it
      print5,it,itime
 5    format(1x,'it,itime= ',i10,1x,i10)
      icuryr=70.
      ileap=0
      isec=0
 10   idtsec=31536000
      if(mod(icuryr,4).eq.0)idtsec=31622400
      if((isec+idtsec).lt.itime)then
         icuryr=icuryr+1
         isec=isec+idtsec
         go to 10
      end if
      iyr=icuryr
      if(mod(iyr,4).eq.0)ileap=1
      if(iyr.ge.100)iyr=iyr-100
      itime=itime-isec

      isec=0.
      do 20 i=1,nmon
         idtsec=isecmon(i)
         imon=i
         if(i.eq.2.and.ileap.eq.1)idtsec=idtsec+86400
         if((isec+idtsec).le.itime)then
            isec=isec+idtsec
         else
            go to 50
         end if
 20   continue
 50   continue
      itime=itime-isec
      iday=(itime/86400)+1

      itime=itime-(iday-1)*86400
      ihr=itime/3600
      itime=itime-ihr*3600
      imin=itime/60
      isec=itime-imin*60
      write(*,51)it,iyr,imon,iday,ihr,imin,isec,ileap
 51   format (' File time=',i10,' Unix Date=',3i2.2,' Time=',3i2.2,
     +     ' Ileap=',i1)
      return
      end
c


