pro read_data

;---------------------------------------------------
; reads the unformatted output of sample_read.f
;Image Dimensions: Height(rows): 1837 Width(cols): 3661

;Image Navigation (radians)
;  Projection: Cylindrical Equidistant
;  Center Longitude: -1.658063e+00
;  Top Latitude: 9.250243e-01
;  Difference Longitude: -6.108653e-01
;  Radians/Line: 3.135320e-04
;  Radians/Element: 3.337150e-04

;Navigation Transformation information:
;   lat = north_lat - row * lin_res
;   lon = ctr_lon + lon_diff + column * ele_res
;   row = (north_lat - lat) / lin_res
;   column = (lon - ctr_lon - lon_diff) / ele_res

if !D.NAME eq 'PS' THEN device, /color

filename='fort.90'
LOADCT,41,file='colors1.tbl'

; What type of machine produced the binary file? Was it big or little endian?  You can specify this in the read_binary procedure below.  If you are running this IDL program on the same computer you created fort.90 with, then you shouldn't have to do this.  Otherwise, change Native to Little or Big.  

dz=read_binary(filename,DATA_DIMS=[3661,1837],DATA_START=4,DATA_TYPE=4,ENDIAN='Native')

; Sanity check--make sure you have realistic values.
print, 'max dz = ',max(dz,/nan)
print, 'min dz = ',min(dz,/nan)

latmin=20. & lonmin=-130. & latmax=53. & lonmax=-60.
limits = [latmin,lonmin,latmax,lonmax]

pos=[0.05,0.20,0.95,0.95]

levels = 5*(1+findgen(13))
contour,dz,xstyle=5,ystyle=5,c_colors=mycolors(levels), levels=levels,/cell_fill,position=pos

MAP_SET, limit=limits,/usa,/continents,/noerase,position=pos,/noborder

MAP_GRID,latlab=limits[1]+1,lonlab=limits[0],/box_axes

contourbar, levels, mycolors(levels),position=[0.2,0.05,0.8,0.08],charsize=0.5,format='(I2)',title='dBZ'


if !D.NAME eq 'PS' THEN device, /close

;---------------------------------------------------

end
