/*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
 ** Copyright (c) 1992, UCAR
 ** University Corporation for Atmospheric Research(UCAR)
 ** National Center for Atmospheric Research(NCAR)
 ** Research Applications Program(RAP)
 ** P.O.Box 3000, Boulder, Colorado, 80307-3000, USA
 ** All rights reserved. Licenced use only.
 ** Do not copy or distribute without authorization
 ** 1993/3/2 13:59:23
 *=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*/

/*********
 * umisc.h
 *********/

#ifndef umisc_h
#define umisc_h

#ifdef __cplusplus
extern "C" {
#endif

/*
 * includes
 */

#include "./port_types.h"
  /*#include rapmisc/date_time.h>*/
#include "./port.h"
#include "./mem.h"
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/types.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include <math.h>
#include <signal.h>
#include <sys/types.h>

/*
 * defines
 */

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define N_BYTE_DATA_VALS 256
#define NBYTES_WORD 4
#define RL7_NBYTES_EXTRA (3 * NBYTES_WORD)
#define RL8_NBYTES_EXTRA (5 * NBYTES_WORD)

#define ASSERT (test) if (test) {fprintf(stderr, \
                                 "ASSERT failed, line %d, file %s\n", \
                                 __LINE__, __FILE__); \
                                 kill(getpid(), SIGSEGV);}


typedef struct {
  int day;
  int month;
  int year;
  int hour;
  int min;
  int sec;
} date_time_t;



/*
 * path parts structure type - used for path elements
 */

typedef struct {
  char *dir;
  char *name;
  char *base;
  char *ext;
} path_parts_t;

/*
 * function prototypes
 */

/***************************************************************
 * ucompress
 */

/* uRLCheck()
 * Checks for compression type, and number of bytes in compressed
 * array.
 *
 * Returns 0 on success, -1 on error
 */

extern int uRLCheck(ui08 *coded_data,
		    ui32 nbytes_passed,
		    int *eight_bit,
		    ui32 *nbytes_compressed);

/* uRLDecode()
 * performs run-length decoding on byte data which was compressed 
 * using uRLEncode
 *
 * Returns the full data array. The size of the array is passed back via
 * nbytes_full.
 */

extern ui08 *uRLDecode(ui08 *coded_data,
		       ui32 *nbytes_full);

/* uRLDecode8()
 * performs run-length decoding on byte data which was compressed 
 * using uRLEncode8
 *
 * Returns the full data array. The size of the array is passed back via
 * nbytes_full.
 */

  /*extern ui08 *uRLDecode8(ui08 *coded_data,
    ui32 *nbytes_full);*/

/* uRLEncode()
 * performs run-length encoding on byte data which uses only the
 * lower 7 bits
 *
 * In the coded data, the first 12 bytes are as follows:
 *
 * (si32) nbytes_array, (si32) nbytes_full, (si32) nbytes_coded.
 *
 * The coded data follows these 12 bytes. The coded data is padded out
 * to end on a 4-byte boundary.
 *
 * The memory for the encoded array is allocated by this routine.
 *
 * Returns pointer to the encoded array. The number of bytes in the
 * encodeded data array is returned via nbytes_array.
 */

extern ui08 *uRLEncode(ui08 *full_data,
		       ui32 nbytes_full,
		       ui32 *nbytes_array);

/* uRLEncode8()
 * performs run-length encoding on byte data which uses all 8 bits
 *
 * In the coded data, the first 20 bytes are as follows:
 *
 * (si32) Magic cookie - RL8_FLAG
 * (si32) key
 * (si32) nbytes_array
 * (si32) nbytes_full
 * (si32) nbytes_coded
 *
 * The coded data follows these 20 bytes. The coded data is padded out
 * to end on a 4-byte boundary.
 *
 * The memory for the encoded array is allocated by this routine.
 *
 * Returns pointer to the encoded array. The number of bytes in the
 * encodeded data array is returned via nbytes_array.
 */

extern ui08 *uRLEncode8(ui08 *full_data,
			ui32 nbytes_full,
			ui32 key,
			ui32 *nbytes_array);

/***************************************************************
 * ucopyright.c
 */

/* ucopyright()
 * Prints the RAP copyright message.
 */

extern void ucopyright(char *prog_name);

/***************************************************************
 * udaemonize.c
 */

/* udaemonize()
 * Transform calling process into a daemon by disassociating it
 * from the controlling terminal.
 */

extern void udaemonize(void);

/***************************************************************
 * ufread.c
 */

/* ufread()
 * wrapper for fread - takes care of interrupted read
 */

extern int ufread(void *ptr, int size, int nitems, FILE *stream);

/***************************************************************
 * ufree_parsed_path.c
 */

/* ufree_parsed_path()
 * frees file path elements
 */

extern void ufree_parsed_path(path_parts_t *parts);

/***************************************************************
 * ufwrite.c
 */

/* ufwrite()
 * wrapper for fwrite - takes care of interrupted write
 */

extern int ufwrite(void *ptr, int size, int nitems, FILE *stream);

/***************************************************************
 * uparams_etc.c
 */

/* uparams_read()
 * reads param file into parameter data base
 *
 * The parameters file has the same format as a simple Xdefaults
 * file. A typical entry would be:
 *
 * rview.plot_forecast: true
 *
 * where rview is the program name
 *       plot_forecast is the resource name
 *       true is the resource value
 *
 * returns param_file_path, NULL is no relevant file
 */

extern char *uparams_read(char **argv, int argc, char *prog_name);

/* uGetParamDouble()
 * returns the value of a double parameter, or a default
 * if this is unsuccessful
 */

extern double uGetParamDouble(char *name, char *param_string, double hard_def);

/* uGetParamLong()
 * returns the value of a long parameter, or a default
 * if this is unsuccessful
 */

extern long uGetParamLong(char *name, char *param_string, long hard_def);

/* uGetParamString()
 * returns the value of a string parameter, or a default
 * if this is unsuccessful
 */

extern char *uGetParamString(char *name, char *param_string, char *hard_def);

/* uset_true_false_param()
 * sets a parameter option with true/false choice, checking for validity
 *
 * returns 0 on success, -1 on failure
 */

extern int uset_true_false_param(char *prog_name, char *routine_name,
				 char *params_path_name, char *option_str,
				 int *option, char *error_str);

/* uset_double_param()
 * sets a parameter option with 2 choices, checking for validity
 *
 * returns 0 on success, -1 on failure
 */

extern int uset_double_param(char *prog_name, char *routine_name,
			     char *params_path_name, char *option_str,
			     int *option,
			     char *option_str_1, int option_val_1,
			     char *option_str_2, int option_val_2,
			     char *error_str);

/* uset_triple_param()
 * sets a parameter option with 3 choices, checking for validity
 *
 * returns 0 on success, -1 on failure
 */

extern int uset_triple_param(char *prog_name, char *routine_name,
			     char *params_path_name, char *option_str,
			     int *option,
			     char *option_str_1, int option_val_1,
			     char *option_str_2, int option_val_2,
			     char *option_str_3, int option_val_3,
			     char *error_str);

/* uset_quad_param()
 * sets a parameter option with 4 choices, checking for validity
 *
 * returns 0 on success, -1 on failure
 */

extern int uset_quad_param(char *prog_name, char *routine_name,
			   char *params_path_name, char *option_str,
			   int *option,
			   char *option_str_1, int option_val_1,
			   char *option_str_2, int option_val_2,
			   char *option_str_3, int option_val_3,
			   char *option_str_4, int option_val_4,
			   char *error_str);

/* uset_quin_param()
 *
 * sets a parameter option with 5 choices, checking for validity
 *
 * returns 0 on success, -1 on failure
 */

extern int uset_quin_param(char *prog_name, char *routine_name,
			   char *params_path_name, char *option_str,
			   int *option,
			   char *option_str_1, int option_val_1,
			   char *option_str_2, int option_val_2,
			   char *option_str_3, int option_val_3,
			   char *option_str_4, int option_val_4,
			   char *option_str_5, int option_val_5,
			   char *error_str);

/* usubstitute_env()
 * Substitute environment variables into the line. The env variables
 * must be in the $(ENV_VAR) format
 */

extern int usubstitute_env(char *line, int max_len);

/***************************************************************
 * uparse_path.c
 */

/*
 * parses file path, returns the basic elements
 */

extern void uparse_path(char *path, path_parts_t *parts);

/***************************************************************
 * ushmem.c
 */

/* umsg_create()
 * create msg queue
 */

extern int umsg_create(key_t key, int permissions);

/* umsg_get()
 * get msg queue - blocks until one is available, or until it times out
 */

extern int umsg_get(key_t key);

/* umsg_recv()
 * reads next message from queue.
 * If block is TRUE, waits for data. Otherwise returns immediately if
 * no data available.
 *
 * Memory is allocated for the data - it is reused on next call.
 *
 * Returns pointer to data on success, NULL on failure
 */

extern void *umsg_recv(int msqid, size_t nbytes, int block);

/* umsg_remove()
 * remove msg queue
 */

extern int umsg_remove(key_t key);

/* umsg_snd()
 * send message to queue
 * If block is TRUE, blocks. Otherwise returns ERROR if immediate service
 * not available.
 * Returns 0 on success, -1 on failure
 */

extern int umsg_snd(int msqid, size_t nbytes, void *data, int block);

/* usem_check()
 * check semaphore for value of 0 - returns 0 if sem value is 0,
 * 1 otherwise
 */

extern int usem_check(int sem_id, int n);

/* usem_clear()
 * clear semaphore to 0
 */

extern int usem_clear(int sem_id, int n);

/* usem_create()
 * create semaphore 
 */

extern int usem_create(key_t key, int n, int permissions);

/* usem_get()
 * get semaphore - blocks until one is available, or until it times out
 */

extern int usem_get(key_t key, int n);

/* usem_remove()
 * remove semaphore
 */

extern int usem_remove(key_t key);

/* usem_set()
 * set semaphore to 1
 */

extern int usem_set(int sem_id, int n);

/* usem_test()
 * test semaphore for value of 0 - blocks until value
 * becomes 0
 */

extern int usem_test(int sem_id, int n);

/* ushm_create()
 * creates and attaches shared memory
 */

extern void *ushm_create(key_t key, int size, int permissions);

/* Returns TRUE if the segment currently exists, FALSE otherwise */
extern int ushm_exists(key_t key);

/* ushm_get()
 * gets and attaches shared memory - blocks until the segment is
 * available, or until it times out
 */

extern void *ushm_get(key_t key, int size);

/* ushm_nattach()
 * get the number of processes currently attached to a shared memory segment
 */

int ushm_nattach(key_t key);
				 
/* ushm_detach()
 *
 * detach from the shared memory segment
 *
 * returns 0 on success, -1 on failure
 */

int ushm_detach(void *shm_ptr);

/* ushm_remove()
 * remove shared memory segment
 */

extern int ushm_remove(key_t key);


/***************************************************************
 * ustring.c
 */

/* uinsert_crs()
 * inserts carriage returns into a string at the
 * blank space immediately preceding the end of line. Formatting for
 * output.
 */

extern char *uinsert_crs(char *string, int line_length);

/* urem_wspace()
 * removes extra tabs and spaces from a string.
 * leaving only one space as a delimiter.
 *
 * returns pointer to the string if successful, NULL if only spaces and
 * tabs in the string.
 */

extern char *urem_wspace(char *string);

/* ustrdelim()
 *  returns a pointer to a string delimited by the delimiting
 *  constant
 *
 * (char *) strdelim( char *nptr, char **endptr, int delim);
 *
 * strdelim searches the string pointed to by nptr for the first
 * occurrence of the delimiter. It returns a pointer to the character
 * after the delimiter.
 * The second occurrence of the delimiter is overwritten by a NULL.
 * A pointer to the first character after the string is assigned to
 * endptr
 *
 * Returns NULL if delimited string is not found
 */

extern char *ustrdelim(char *nptr, char **endptr, int delim);

/* ustrstr()
 * this is an implementation of the ANSI standard strstr
 * function which is missing from the Unix package
 *
 * char *strstr(char *s1, char *s2)
 *
 * strstr locates the first occurrence of s2 (not including the terminating
 * null character) in the string s1. It returns a pointer to the string
 * located in s1, or a null pointer if no match is found.
 */

extern char *ustrstr(char *s1, char *s2);

/* ustr_token()
 * Returns pointer to the original string where the token was found,
 * and NULL if no token was found.
 * str_ptr is updated past the token, or set to NULL
 * when theres nothing more to scan.
 *
 * char  **str_ptr;     current point in the string to parse
 * char  *token;        put the found token here
 * int   max_toksiz;    maximum size of token (include zero byte)
 * char  *delim;        delimiter for tokens
 */

extern char *ustr_token(char **str_ptr,
			char *token,
			int max_toksiz,
			char *delim);

/* ustr_concat()
 * Concats two strings to a given max length
 */

extern char *ustr_concat(char *s1,
			 const char *s2,
			 int maxs1);

/* ustr_clear_to_end()
 * Clears chars after the first null char, to given limit.
 * Forces a null termination
 */

extern void ustr_clear_to_end(char *str, int maxlen);

/* ustrtola()
 * takes
 *  lngstr, which is assumed to be a string consisting of digits
 *  separated by whitespace (newlines, spaces, etc.), and
 *  converts it into an array of long ints (whose size is
 *  given by "size") with a starting address at lngarr.
 *
 *  strtola returns size if it executes without errors, -1 otherwise.
 *
 *  Preconditions: "lngstr" has already been initialized.
 *    "size" is equal to the number of integers to be
 *    contained in the array, or 0 if that number is
 *    unknown.
 *
 *  Postconditions: "lngarr" points to the first element of the si32
 *    array.
 */

extern int ustrtola (char *lngstr, long **lngarr_P, int size);

/* ustrncpy()
 * copies string to max length, and ensures NULL termination
 */

extern char *ustrncpy(char *s1, const char *s2, int maxs1);

/* uGetLong()
 * Decodes the next long off a string, advancing the pointer
 * to the next token
 *
 * Returns 0 on success, -1 on failure
 */

extern long uGetLong(char **ptr, long *lval);

/* uGetDouble()
 * Decodes the next double off a string, advancing the pointer
 * to the next token
 *
 * Returns 0 on success, -1 on failure
 */

extern int uGetDouble(char **ptr, double *dval);

/***************************************************************
 * usystem_call.c
 *
 * The usystem_call group of functions perform the equivalent of the
 * 'system' function, without the overhead of duplicating the entire
 * program memory.
 */

/* usystem_call_init()
 * sets up a child process for the execution of the system function
 *
 * returns 0 on success, -1 on failure
 */

extern int usystem_call_init(void);

/* usystem_call()
 * sends the system call to the child process, waits for the
 * done message to come back
 */

extern void usystem_call(char *call_str);

/* usystem_call_clean()
 * kills the child
 */

extern void usystem_call_clean(void);

/***************************************************************
 * utime.c
 */

/* uunix_time()
 * return the unix time from date_time_t struct
 * Side-effect: sets the unix_time field in date_time.
 */

extern time_t uunix_time(date_time_t *date_time);

/* udate_time()
 * return pointer to date_time struct corresponding to unix time.
 * The pointer refers to a static held by this routine.
 */

extern date_time_t *udate_time(time_t unix_time);

/* uconvert_to_utime()
 * return the unix time from date_time_t struct.  Also sets the unix_time
 * field in the date_time_t structure.
 */

extern time_t uconvert_to_utime(date_time_t *date_time);

/* uconvert_from_utime()
 * sets the other fields in the date_time_t structure based on the value
 * of the unix_time field in that structure
 */

extern void uconvert_from_utime(date_time_t *date_time);

/* utime_compute()
 *
 * return the unix time from components.
 */

time_t utime_compute(int year, int month, int day,
		     int hour, int min, int sec);

/* ujulian_date()
 * calculate the Julian calendar day number
 */

extern long ujulian_date(int day, int month, int year);

/* ucalendar_date()
 * calculate the calendar day from the Julian date
 */

extern void ucalendar_date(long jdate, int *day,
			   int *month, int *year);

/* ulocaltime()
 * puts the local time into a date_time_t struct
 */

extern void ulocaltime(date_time_t *date_time);

/* ugmtime()
 * puts the gm time into a date_time_t struct
 */

extern void ugmtime(date_time_t *date_time);

/* utimestr()
 * returns a string composed from the time struct. This routine has a
 * number of static storage areas, and loops through these areas. Every
 * 10 times you make the call you will overwrite a previous result.
 */

extern char *utimestr(date_time_t *date_time);

/* utimstr()
 * returns a string composed from the time value. This routine calls
 * utimestr and, thus, uses the same static storage areas.
 */

extern char *utimstr(time_t time);

/* utime_str()
 * Same as utimestr(), except puts an underscore between the date and
 * time.
 */

extern char *utime_str(date_time_t *date_time);

/* utim_str()
 * same as utimstr(), except calls utime_str().
 */

extern char *utim_str(time_t time);

/***************************************************************
 * uusleep.c
 */

/* umsleep()
 * sleeps in microseconds
 *
 * local implementation of the usleep function, since the DEC does not
 * seem to support usleep
 */

extern void umsleep(ui32 msecs);
extern void uusleep(ui32 usecs);

/***************************************************************
 * uvalid_datetime.c
 */

/* uvalid_datetime()
 * returns 1 if a valid date and time is passed, 0 otherwise.
 */

extern int uvalid_datetime(date_time_t *datetime);

/**********************************************************************
 * SAFE_SYS. Safely execute a command, susch that it will be killed if it
 * doesn't exit with the timeout_seconds
 
 * Returns 0 on Success, -1 : on command error,
 *                       -2 : Child Timed out
 *                       -3 : Couldn't kill the child
 */
 
int safe_system(const char * command, int timeout_seconds);


#ifdef __cplusplus
}
#endif

#endif
