/********************************************************************
 * MDV_FIELD_CODES.h : A Static array for Looking up Field Information
 *
 * Based on  grib codes as of 3/96
 * Rachel Ames 3/96 NCAR/RAP
 * 
 * NOTE: This array is included into mdv_utils.cc  and its members can
 * be accessed safely through routines in that file. See mdv_utils.h
 * for function prototypes. Please don't include this file directly in
 * application code.  - F. Hage 5/96
 */


typedef struct {
 int code;
 char *name;
 char *units;
 char *abbrev;
} mdv_field_code_t;

mdv_field_code_t mdv_field_code_info[] = {
{ 0, "Reserved", "UNDEFINED", "UNDEFINED"},
{ 1, "Pressure ","Pa", "PRES"},
{ 2, "Pressure reduced to MSL ","Pa", "PRMSL"},
{ 3, "Pressure tendency ","Pa/s", "PTEND"},
{ 4, "Surface Pressure **** ","Pa ","PSFC"},
{ 5, "Terrain Elevation **** ","m ","TOPO"},
{ 6, "Geopotential ","m2/s2 ","GP"},
{ 7, "Geopotential height ","gpm ","HGT"},
{ 8, "Geometric height ","m" ,"DIST"},
{ 9, "Standard deviation of height ","m ","HSTDV"},
{ 10, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{ 11, "Temperature ","K ","TMP"},
{ 12, "Virtual temperature ","K ","VTMP"},
{ 13, "Potential temperature ","K ","POT"},
{ 14, "Pseudo-adiabatic (equivalent) potential temp ","K ","EPOT "},
{ 15, "Maximum temperature ","K ","T MAX"},
{ 16, "Minimum temperature ","K ","T MIN"},
{ 17, "Dew point temperature ","K ","DPT"},
{ 18, "Dew point depression /or deficit/ ","K ","DEPR"},
{ 19, "Lapse rate ","K/m ","LAPR"},
{ 20, "Visibility ","m ","VIS"},
{ 21, "Radar Spectra /1/ ","UNDEFINED ","RDSP1"},
{ 22, "Radar Spectra /2/ ","UNDEFINED ","RDSP2"},
{ 23, "Radar Spectra /3/ ","UNDEFINED ","RDSP3"},
{ 24, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{ 25, "Temperature anomaly ","K ","TMP A"},
{ 26, "Pressure anomaly ","Pa ","PRESA"},
{ 27, "Geopotential height anomaly ","gpm ","GP A"},
{ 28, "Wave Spectra /1/ ","UNDEFINED ","WVSP1"},
{ 29, "Wave Spectra /2/ ","UNDEFINED ","WVSP2"},
{ 30, "Wave Spectra /3/ ","UNDEFINED ","WVSP3"},
{ 31, "Wind direction /from which blowing/ ","deg true ","WDIR"},
{ 32, "Wind speed ","m/s ","WIND"},
{ 33, "u-component of wind ","m/s ","U GRD"},
{ 34, "v-component of wind ","m/s ","V GRD"},
{ 35, "Stream function ","m2/s ","STRM"},
{ 36, "Velocity potential ","m2/s ","V POT"},
{ 37, "Montgomery stream function ","m2/s2 ","MNTSF"},
{ 38, "Sigma coord. vertical velocity ","/s ","SGCVV"},
{ 39, "Pressure Vertical velocity ","Pa/s ","V VEL"},
{ 40, "Geometric Vertical velocity ","m/s ","DZDT"},
{ 41, "Absolute vorticity ","/s ","ABS V"},
{ 42, "Absolute divergence ","/s ","ABS D"},
{ 43, "Relative vorticity ","/s ","REL V"},
{ 44, "Relative divergence ","/s ","REL D"},
{ 45, "Vertical u-component shear ","/s ","VUCSH"},
{ 46, "Vertical v-component shear ","/s ","VVCSH"},
{ 47, "Direction of current ","deg true ","DIR C"},
{ 48, "Speed of current ","m/s ","SP C"},
{ 49, "u-component of current ","m/s ","UOGRD"},
{ 50, "v-component of current ","m/s ","VOGRD"},
{ 51, "Specific humidity ","kg/kg ","SPF H"},
{ 52, "Relative humidity ","% ","R H"},
{ 53, "Humidity mixing ratio ","kg/kg ","MIXR"},
{ 54, "Precipitable water ","kg/m2 ","P WAT"},
{ 55, "Vapor pressure ","Pa ","VAPP"},
{ 56, "Saturation deficit ","Pa ","SAT D"},
{ 57, "Evaporation ","kg/m2 ","EVP"},
{ 58, "Cloud Ice ","kg/m2 ","C ICE"},
{ 59, "Precipitation rate ","kg/m2/s ","PRATE"},
{ 60, "Thunderstorm probability ","% ","TSTM"},
{ 61, "Total precipitation ","kg/m2 ","A PCP"},
{ 62, "Large scale precipitation /non-conv./ ","kg/m2 ","NCPCP"},
{ 63, "Convective precipitation ","kg/m2 ","ACPCP"},
{ 64, "Snowfall rate water equivalent ","kg/m2/s ","SRWEQ"},
{ 65, "Water equiv. of accum. snow depth ","kg/m2 ","WEASD"},
{ 66, "Snow depth ","m ","SNO D"},
{ 67, "Mixed layer depth ","m ","MIXHT"},
{ 68, "Transient thermocline depth ","m ","TTHDP"},
{ 69, "Main thermocline depth ","m ","MTHD"},
{ 70, "Main thermocline anomaly ","m ","MTH A"},
{ 71, "Total cloud cover ","% ","T CDC"},
{ 72, "Convective cloud cover ","% ","CDCON"},
{ 73, "Low cloud cover ","% ","L CDC"},
{ 74, "Medium cloud cover ","% ","M CDC"},
{ 75, "High cloud cover ","% ","H CDC"},
{ 76, "Cloud water ","kg/m2 ","C WAT"},
{ 77, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{ 78, "Convective snow ","kg/m2 ","SNO C"},
{ 79, "Large scale snow ","kg/m2 ","SNO L"},
{ 80, "Water Temperature ","K ","WTMP"},
{ 81, "Land-sea mask /land=1;sea=0/ ","fraction ","LAND"},
{ 82, "Deviation of sea level from mean ","m ","DSL M"},
{ 83, "Surface roughness ","m ","SFC R"},
{ 84, "Albedo ","% ","ALBDO"},
{ 85, "Soil temperature ","K ","TSOIL"},
{ 86, "Soil moisture content ","kg/m2 ","SOIL M"},
{ 87, "Vegetation ","% ","VEG"},
{ 88, "Salinity ","kg/kg ","SALTY"},
{ 89, "Density ","kg/m3 ","DEN"},
{ 90, "Water runoff ","kg/m2 ","WATR"},
{ 91, "Ice concentration /ice=1;no ice=0/ ","fraction ","ICE C"},
{ 92, "Ice thickness ","m ","ICETK"},
{ 93, "Direction of ice drift ","deg. true ","DICED"},
{ 94, "Speed of ice drift ","m/s ","SICED"},
{ 95, "u-component of ice drift ","m/s ","U ICE"},
{ 96, "v-component of ice drift ","m/s ","V ICE"},
{ 97, "Ice growth rate ","m/s ","ICE G"},
{ 98, "Ice divergence ","/s ","ICE D"},
{ 99, "Snow melt ","kg/m2 ","SNO M"},
{100, "Sigfcant ht of combined wind waves and swell ","m ","HTSGW"},
{101, "Direction of wind waves /from which/ ","deg true ","WVDIR"},
{102, "Significant height of wind waves ","m ","WVHGT"},
{103, "Mean period of wind waves ","s ","WVPER"},
{104, "Direction of swell waves ","deg true ","SWDIR"},
{105, "Significant height of swell waves ","m ","SWELL"},
{106, "Mean period of swell waves ","s ","SWPER"},
{107, "Primary wave direction ","deg true ","DIRPW"},
{108, "Primary wave mean period ","s ","PERPW"},
{109, "Secondary wave direction ","deg true ","DIRSW"},
{110, "Secondary wave mean period ","s ","PERSW"},
{111, "Net short-wave radiation /surface/ ","W/m2 ","NSWRS"},
{112, "Net long wave radiation /surface/ ","W/m2 ","NLWRS"},
{113, "Net short-wave radiation /top of atmos./ ","W/m2 ","NSWRT"},
{114, "Net long wave radiation /top of atmos./ ","W/m2 ","NLWRT"},
{115, "Long wave radiation ","W/m2 ","LWAVR"},
{116, "Short wave radiation ","W/m2 ","SWAVR"},
{117, "Global radiation ","W/m2 ","G RAD"},
{118, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{119, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{120, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{121, "Latent heat net flux ","W/m2 ","LHTFL"},
{122, "Sensible heat net flux ","W/m2 ","SHTFL"},
{123, "Boundary layer dissipation ","W/m2 ","BLYDP"},
{124, "Momentum flux, u component ","N/m2 ","U FLX"},
{125, "Momentum flux, v component ","N/m2 ","V FLX"},
{126, "Wind mixing energy ","J ","WMIXE"},
{127, "Image data ","UNDEFINED ","IMG D"},
{128, "Mean Sea Level Pres /Std Atmos Reduction/ ","Pa ","MSLSA"},
{129, "Mean Sea Level Pres /MAPS System Reduction/ ","Pa ","MSLMA"},
{130, "Mean Sea Level Pres /ETA Model Reduction/ ","Pa ","MSLET"},
{131, "Surface lifted index ","K ","LFT X"},
{132, "Best /4 layer/ lifted index ","K ","4LFTX"},
{133, "K index ","K ","K X"},
{134, "Sweat index ","K ","S X"},
{135, "Horizontal moisture divergence ","kg/kg/s ","MCONV"},
{136, "Vertical speed shear ","/s ","VW SH"},
{137, "3-hr pressure tendency /Std Atmos Reduction/ ","Pa/s ","TSLSA"},
{138, "Brunt-Vaisala frequency /squared/ ","/s2 ","BVF 2"},
{139, "Potential vorticity /density weighted/ ","/s/m ","PV MW"},
{140, "Categorical rain /yes=1; no=0/ ","non-dim ","CRAIN"},
{141, "Categorical freezing rain /yes=1; no=0/ ","non-dim ","CFRZRN"},
{142, "Categorical ice pellets /yes=1; no=0/ ","non-dim ","CICEPL"},
{143, "Categorical snow /yes=1; no=0/ ","non-dim ","CSNOW"},
{144, "Cloud water specific humidity **** ","kg/kg ","CLWSH"},
{145, "Rain water specific humidity **** ","kg/kg ","RNWSH"},
{146, "Snow specific humidity **** ","kg/kg ","SNWSH"},
{147, "Ice specific humidity **** ","kg/kg ","ICWSH"},
{148, "Graupel specific humidity **** ","kg/kg ","GRWSH"},
{149, "Hail specific humidity **** ","kg/kg ","HAWSH"},
{150, "Wind Covariance [uv]-[u][v] ([]=mean/span) ","m2/s2 ","COVMZ"},
{151, "Uwind-Temp Covariance [uT]-[u][T] ","K*m/s ","COVTZ"},
{152, "Vwind-Temp Covariance [vT]-[v][T] ","K*m/s ","COVTM"},
{153, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{154, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{155, "Ground Heat Flux ","W/m2 ","GFLUX"},
{156, "Convective inhibition ","J/kg ","CIN"},
{157, "Convective Available Potential Energy ","J/kg ","CAPE"},
{158, "Turbulent Kinetic Energy ","J/kg ","TKE"},
{159, "Condensation pressure of parcel ","Pa ","CONDP"},
{160, "Clear Sky Upward Solar Flux ","W/m2 ","CSUSF"},
{161, "Clear Sky Downward Solar Flux ","W/m2 ","CSDSF"},
{162, "Clear Sky upward long wave flux ","W/m2 ","CSULF"},
{163, "Clear Sky downward long wave flux ","W/m2 ","CSDLF"},
{164, "Cloud forcing net solar flux ","W/m2 ","CFNSF"},
{165, "Cloud forcing net long wave flux ","W/m2 ","CFNLF"},
{166, "Visible beam downward solar flux ","W/m2 ","VBDSF"},
{167, "Visible diffuse downward solar flux ","W/m2 ","VDDSF"},
{168, "Near IR beam downward solar flux ","W/m2 ","NBDSF"},
{169, "Near IR diffuse downward solar flux ","W/m2 ","NDDSF"},
{170, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{171, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{172, "Momentum flux ","N/m2 ","M FLX"},
{173, "Mass point model surface ","non-dim ","LMH"},
{174, "Velocity point model surface ","non-dim ","LMV"},
{175, "Model layer number /from bottom up/ ","non-dim ","MLYNO"},
{176, "latitude /-90 to +90/ ","deg ","NLAT"},
{177, "east longitude /0-360/ ","deg ","ELON"},
{178, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{179, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{180, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{181, "x-gradient of log pressure ","/m ","LPS X"},
{182, "y-gradient of log pressure ","/m ","LPS Y"},
{183, "x-gradient of height ","m/m ","HGT X"},
{184, "y-gradient of height ","m/m ","HGT Y"},
{185, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{186, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{187, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{188, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{189, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{190, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{191, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{192, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{193, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{194, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{195, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{196, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{197, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{198, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{199, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{200, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{201, "Ice-free water surface ","% ","ICWAT"},
{202, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{203, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{204, "downward short wave rad. flux ","W/m2 ","DSWRF"},
{205, "downward long wave rad. flux ","W/m2 ","DLWRF"},
{206, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{207, "Moisture availability ","% ","MSTAV"},
{208, "Exchange coefficient ","(kg/m3)(m/s) ","SFEXC"},
{209, "No. of mixed layers next to surface ","integer ","MIXLY"},
{210, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{211, "upward short wave rad. flux ","W/m2 ","USWRF"},
{212, "upward long wave rad. flux ","W/m2 ","ULWRF"},
{213, "Amount of non-convective cloud ","% ","CDLYR"},
{214, "Convective Precipitation rate ","kg/m2/s ","CPRAT"},
{215, "Temperature tendency by all physics ","K/s ","TTDIA"},
{216, "Temperature tendency by all radiation ","K/s ","TTRAD"},
{217, "Temperature tendency by non-radiation physics ","K/s ","TTPHY"},
{218, "precip.index /0.0-1.00/ /see note/ ","fraction ","PREIX"},
{219, "Std. dev. of IR T over 1x1 deg area ","K ","TSD1D"},
{220, "Natural log of surface pressure ","ln/kPa/ ","NLGSP"},
{221, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{222, "5-wave geopotential height ","gpm ","5WAVH"},
{223, "Plant canopy surface water ","kg/m2 ","C WAT"},
{224, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{225, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{226, "Blackadar's mixing length scale ","m ","BMIXL"},
{227, "Asymptotic mixing length scale ","m ","AMIXL"},
{228, "Potential evaporation ","kg/m2 ","PEVAP"},
{229, "Snow phase-change heat flux ","W/m2 ","SNOHF"},
{230, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{231, "Convective cloud mas flux ","Pa/s ","MFLUX"},
{232, "Downward total radiation flux ","W/m2 ","DTRF"},
{233, "Upward total radiation flux ","W/m2 ","UTRF"},
{234, "Baseflow-groundwater runoff ","kg/m2 ","BGRUN"},
{235, "Storm surface runoff ","kg/m2 ","SSRUN"},
{236, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{237, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{238, "Snow cover ","percent ","SNO C"},
{239, "Snow temperature ","K ","SNO T"},
{240, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{241, "Large scale condensat. heat rate ","K/s ","LRGHR"},
{242, "Deep convective heating rate ","K/s ","CNVHR"},
{243, "Deep convective moistening rate ","kg/kg/s ","CNVMR"},
{244, "Shallow convective heating rate ","K/s ","SHAHR"},
{245, "Shallow convective moistening rate ","kg/kg/s ","SHAMR"},
{246, "Vertical diffusion heating rate ","K/s ","VDFHR"},
{247, "Vertical diffusion zonal acceleration ","m/s2 ","VDFUA"},
{248, "Vertical diffusion meridional accel ","m/s2 ","VDFVA"},
{249, "Vertical diffusion moistening rate ","kg/kg/s ","VDFMR"},
{250, "Solar radiative heating rate ","K/s ","SWHR"},
{251, "long wave radiative heating rate ","K/s ","LWHR"},
{252, "Drag coefficient ","non-dim ","CD"},
{253, "Friction velocity ","m/s ","FRICV"},
{254, "Richardson number ","non-dim ","RI"},
{255, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{256, "Radar Reflectivity ","dBZ ","DBZ"},
{257, "Radar Composite Reflectivity ","dBZ ","C DBZ"},
{258, "Radar Layer Composite Reflectivity ","dBZ ","LC DBZ"},
{259, "Radar Radial Velocity ","m/s ","R VEL"},
{260, "Radar Spectral Width ","Hz ","S WIDTH"},
{261, "Radar Signal/Noise ","dB ","S/N"},
{262, "Radar Echo Tops","m","E TOPS"},
{263, "Vertical Integrated Liquid ","kg/m^2 ","VIL"},
{264, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{265, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{266, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{267, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{268, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{269, "UNDEFINED ","UNDEFINED ","UNDEFINED"},
{270, "Storm Precip Accumulation ","mm ","ST ACCUM"},
{271, "1Hr Precip Accumulation ","mm ","1H ACCUM"},
{272, "3Hr Precip Accumulation ","mm ","3H ACCUM"},
};
/* Don't forget to update MDV_MAX_FIELD_CODE if you add field definitions */

#define MDV_MAX_FIELD_CODE  272
