module adp_module
  integer, parameter :: nwsz = 32
  integer, parameter :: idim = 1640
  integer, dimension(idim) :: NB
  integer , dimension(60) :: IC
  character(len=8), parameter :: EOREP = 'END REPO'
  character(len=8), parameter :: EOREC = 'END RECO'
  character(len=8), parameter :: WASH  = 'WASHINGT'
  character(len=8), parameter :: BLANK = '        '
  character(len=8), parameter :: EOFIL = 'ENDOF FI'
  integer, parameter :: ncsz = 8
  integer, parameter :: ntbts = ncsz*10
  integer :: lth = 0
  integer :: NPT = 9

  integer :: iuarr(255) = 0

  real    :: YLAT,YLON,ELEV
  integer :: IRTYP,INSTYP,IYR,IMO,IDY,IHR
  real    :: TIME
  integer :: IREC
  integer :: ISTATN,NLV,MLV
  real    :: RTIME
  character(LEN=8) :: SSTA

contains

  LOGICAL FUNCTION LOGCMP(B,I,C)
    implicit none
    integer, intent(in), dimension(*) :: B
    integer, intent(in) :: i
    character(len=8), intent(in) :: C

    character(len=8) :: A
    integer, dimension(2) :: IH 

    CALL GBYTES(B,IH,(NTBTS*(I-1)),NWSZ,0,2)
    CALL SBYTES(A,IH,0,NWSZ,0,2)
    LOGCMP = (A .EQ. C)
  END FUNCTION LOGCMP

  INTEGER FUNCTION NTENS(KC,KN)
    implicit none
!-----------------------------------------------------------------------
    integer, intent(in) :: kn
    integer, intent(in) , dimension(kn) :: KC

    integer , parameter :: ispace = ichar(' ')
    integer , parameter :: iminus = ichar('-')
    integer , parameter :: izero  = ichar('0')

    integer :: i, isgn, ka

    NTENS=0
    ISGN=1
    KLOOP : DO I=1,KN
       IF(KC(I) .EQ. ispace) CYCLE KLOOP
       IF(KC(I) .EQ. iminus) THEN
          ISGN=-1
          CYCLE KLOOP
       ENDIF
       KA=KC(I)-IZERO
       IF(KA .GE. 10 .OR. KA .LT. 0) THEN
          KA=0
          write(*,'("NTENS ERROR", I8, I8, ":", 30I4)') I, KN, KC
          call abort
       ENDIF
       NTENS=10*NTENS+KA
    ENDDO KLOOP
    NTENS=ISIGN(NTENS,ISGN)
  END FUNCTION NTENS

  SUBROUTINE RDADP(IUN,IST)
    implicit none
    integer, intent(in) :: IUN
    integer, intent(out) :: IST
!-----------------------------------------------------------------------
!
!        PURPOSE: RDADP READS A STATION REPORT, THAT IS, A RECORD,
!                 FROM A PACKED DATA TAPE, CALLS UNPACKING ROUTINES,
!                 AND ISOLATES THE REPORT IDENTIFICATION WORDS.
!
!        REPORT IDENTIFIERS:
!                 SSTA = STATION ID. NO., 6 CHARACTERS, LEFT JUSTI-
!                        FIED, BLANK FILL.
!                 YLAT = LATITUDE IN DEGREES (TO HUNDREDTHS)
!                 YLON = LONGITUDE IN DEGREES(TO HUNDREDTHS)
!                 TIME = TIME OF OBSERVATION IN HRS (TO HUNDREDTHS)
!                 IRTYP = TYPE OF REPORT CODE
!                 INSTYP = INSTRUMENT TYPE CODE
!                 ELEV = STATION ELEVATION IN METERS
!                 LTH =  NO. OF 10-CHARACTER WORDS IN THE REPORT,
!                        INCLUDING 1ST 5 WORDS OF RECORD IDENTIFIERS.
!                        OBSERVATION BEGINS WITH 6TH WORD.  LAST WORD
!                        IS 'END REPORT'.
!                 IYR =  YEAR
!                 IMO =  MONTH
!                 IDY =  DAY
!                 IHR =  HOUR
!                 IREC = SEQUENTIAL NO. OF THE CURRENT RECORD
    integer :: IWDS = 0
    integer :: KPT, IFILL, IOFF
    NPT=NPT+LTH
    KPT=NPT-1
    IF(NPT.LE.IWDS) THEN
       IF(.not.LOGCMP(NB,KPT,EOREP)) THEN
          write(*,'("RDADP LOST ITS WAY IN RECORD", I6)') IREC
       ENDIF
       IF(.not. LOGCMP(NB,NPT,EOREC)) THEN
          IF (NPT .LT. IWDS) GO TO 20
       ENDIF
    ENDIF
5   CONTINUE
    CALL readtape(IUN, IST, IWDS)
!        IST SHOULD EQUAL 1 IF END OF FILE MARK IS DETECTED
    IF (IST .EQ. 1) RETURN
    IREC=IREC+1
    IF (IST .NE. 0) THEN
       WRITE(*,'("READ ERROR IN RDADP  ", 2I10)') IREC,IST
    ENDIF
    IF(LOGCMP(NB,1,EOREC)) GO TO 5
    IF(LOGCMP(NB,1,EOFIL)) GO TO 5
    IF(LOGCMP(NB,3,WASH)) THEN
! UNPACK HEADER RECORD
       CALL GBYTES(NB,IC,0,NCSZ,0,10)
       IYR=NTENS(IC(5),2)
       if(iyr.ge.60) then
          iyr=iyr+1900
       else
          iyr=iyr+2000
       endif
       IMO=NTENS(IC(7),2)
       IDY=NTENS(IC(9),2)
       IHR=NTENS(IC(1),2)
       write(*,'(I4,"-",I2.2,"-",I2.2,"+",I2.2)') iyr, imo, idy, ihr
       NPT=9999
       GO TO 5
    ENDIF
    IF(IWDS.LT.9)GO TO 5
    NPT=1
20  CONTINUE
! UNPACK REPORT IDENTIFICATIONS
    IOFF=NTBTS*(NPT-1)
    CALL GBYTES(NB,IC,IOFF,NCSZ,0,40)
    IFILL=NWSZ-NCSZ
    CALL SBYTES(SSTA,BLANK,NCSZ,IFILL,0,1)
    CALL SBYTES(SSTA,IC(11),0,NCSZ,0,5)
    YLAT=NTENS(IC(1),5)*.01
    YLON=NTENS(IC(6),5)*.01
! CONVERT LONGITUDE TO DEGREES EAST
    IF(YLON .LE. 180.0)YLON = -YLON
    IF(YLON .GT. 180.0 .AND. YLON .LT. 360.0) YLON = 360. - YLON
    TIME=NTENS(IC(17),4)*.01
!KWM    RTIME=NTENS(IC(21),4)*.01
    IRTYP=NTENS(IC(28),3)
    INSTYP=NTENS(IC(36),2)
    ELEV=NTENS(IC(31),5)
    LTH=NTENS(IC(38),3)
    IF(LTH.EQ.0) GO TO 5
  END SUBROUTINE RDADP

  subroutine readtape(IUNIT, IST, IWDS)
    implicit none
    integer, intent(in) :: iunit
    integer, intent(out) :: IST
    integer, intent(out) :: IWDS
    integer :: isz

    if (iuarr(iunit).eq.0) then
       print*, 'Unit ', iunit, ' not opened.'
       call abort()
    endif

    call bnread(iuarr(iunit), NB, 6440, isz, ist, 1)
    if (ist.eq.0) then
       IWDS = ISZ * NCSZ / NWSZ
    elseif (ist.eq.1) then
       iwds = 0
    elseif (ist.eq.2) then
       print*, 'bad read.', iunit, iuarr(iunit), ist, isz
    endif

  end subroutine readtape

end module adp_module

!KWM Emacs Local Variables: ***
!KWM Emacs mode: f90        ***
!KWM Emacs End:             ***
