PROGRAM main_sfcadp
  use adp_module
!-----------------------------------------------------------------------
  CHARACTER flnm * 80, flnm3 * 3
  INTEGER, dimension(10000) :: ista=0
  character(len=19), dimension(10000) :: olddate
  LOGICAL Ldate_open
  INTEGER:: ifile=1, ino=1, icount=1
  namelist/latlon/ xlone, xlonw, xlats, xlatn
  namelist/date/ istartyr, istartmo, istartdy, istarthr, &
                 iendyr, iendmo, ienddy, iendhr
  character(len=19) startdate, enddate, currentdate

  DATA NVOLS6 / 10 /

  INTEGER nrows, ncols
  PARAMETER (nrows = 30, ncols = 2)
  CHARACTER(6) hhh (ncols, nrows)

  CHARACTER(255) fmtstr, fmtstr2
  CHARACTER(LEN=28) :: file_date
  LOGICAL,DIMENSION(10000) :: already_opened = .FALSE.

  CHARACTER(LEN=19) :: ds
  INTEGER :: di


  CALL parse_table (hhh, ncols, nrows)

  CALL make_fmts (hhh, nrows, ncols, fmtstr, fmtstr2)

! WRITE (4, FMT = FMTSTR) (hhh (1, n), n = 1, nrows)
! WRITE (4, '(A255)') FMTSTR2

  Ldate_open = .FALSE.
  olddate(1) = '9999-99-99_99:99:99'
  istatn = 0

  open(95,file='namelist.input')
  read(95,latlon)
  read(95,date)
  close (95)

  write(startdate,'(i4.4,A,i2.2,a,i2.2,a,i2.2,a)' ) &
  istartyr,"-",istartmo,"-",istartdy,"_",istarthr,":00:00"
  write(enddate,'(i4.4,A,i2.2,a,i2.2,a,i2.2,a)' ) &
  iendyr,"-",iendmo,"-",ienddy,"_",iendhr,":00:00"

  iunit = 10

  numarg = iargc ()

  print *,'numarg=',numarg
  DO 25 ifile = 1, numarg

     IF (iuarr (iunit) .ne.0) then
        CALL cclose (iuarr (iunit), istat, ierr)
        PRINT * , 'istat, ierr = ', istat, ierr
        iuarr (iunit) = 0
     ENDIF
     CALL getarg (ifile, flnm)
     ifnd = index (flnm, ' ') - 1
     PRINT * , 'flnm = ', flnm (1:ifnd)

     CALL COPEN (iunit, ifd, flnm, 1, ierr, 1)
     iuarr (iunit) = ifd
     PRINT * , 'IERR = ', IERR

10   CONTINUE

     CALL rdadp (IUNIT, IST)
     IF (ist.ne.0) goto 25

!    ... compute the valid date/time of the observation, not really
!        so simple as you would hope
  
     if(time.gt.23.5) time = 0

!    same time or
     if ( ( nint(time) .eq. ihr ) .or. &
!    same day, previous or
        ( ( nint(time) .lt. ihr ) .and. ( ihr - nint(time) .le. 3 ) ) .or. &
!    same day, subsequent or
        ( ( nint(time) .gt. ihr ) .and. ( nint(time) - ihr .le. 3 ) ) ) then
        iyr1=iyr
        imo1=imo
        idy1=idy
        ihr1=nint(time)
        write(currentdate,'(i4.4,A,i2.2,a,i2.2,a,i2.2,a)' ) &
        iyr1,"-",imo1,"-",idy1,"_",ihr1,":00:00"

!    next day, basically plus a few hours
     else if ( ( nint(time) .lt. ihr ) .and. ( ihr - nint(time) .ge. 21 ) ) then
        write(ds,'(i4.4,A,i2.2,a,i2.2,a,i2.2,a)' )iyr,"-",imo,"-",idy,"_",ihr,":00:00"
        di= 86400 - (ihr - nint(time)) * 3600
        CALL geth_newdate (currentdate,ds,di)
        read(currentdate( 1: 4),'(i4)') iyr1
        read(currentdate( 6: 7),'(i2)') imo1
        read(currentdate( 9:10),'(i2)') idy1
        read(currentdate(12:13),'(i2)') ihr1

!    previous day, basically minus a few hours
     else if ( ( nint(time) .gt. ihr ) .and. ( nint(time) - ihr .ge. 21 ) ) then
        write(ds,'(i4.4,A,i2.2,a,i2.2,a,i2.2,a)' )iyr,"-",imo,"-",idy,"_",ihr,":00:00"
        di= -86400 + (nint(time)-ihr) * 3600
        CALL geth_newdate (currentdate,ds,di)
        read(currentdate( 1: 4),'(i4)') iyr1
        read(currentdate( 6: 7),'(i2)') imo1
        read(currentdate( 9:10),'(i2)') idy1
        read(currentdate(12:13),'(i2)') ihr1
     end if
     
     if ( (currentdate .lt. startdate ) .or. ( currentdate .gt. enddate ) ) goto 10
     if (olddate(1) .eq. '9999-99-99_99:99:99' ) then
        olddate(1)=currentdate
        icount=1
     endif
    check : do i=1,icount
        if ( currentdate.eq.olddate(i) ) then
           ino=i
           if(.not. already_opened(i)) then
              write(file_date,'(a,i4.4,A,i2.2,a,i2.2,a,i2.2)' ) &
              "surface_obs_r:",iyr1,"-",imo1,"-",idy1,"_",ihr1
              INQUIRE(FILE=file_date,OPENED=already_opened(i))
              IF (.NOT. already_opened(i)) THEN
                 OPEN(UNIT=20+ino,&
                      FILE=file_date,&
                      ACCESS="SEQUENTIAL",&
                      FORM="FORMATTED",&
                      STATUS="UNKNOWN")
                 already_opened(i) = .TRUE.
              END IF
           end if
           exit check
        else if ( i.eq.icount) then
           icount=icount+1
           ino=icount
           ista(ino)=0
           olddate(ino)=currentdate
           write(file_date,'(a,i4.4,A,i2.2,a,i2.2,a,i2.2)' ) &
           "surface_obs_r:",iyr1,"-",imo1,"-",idy1,"_",ihr1
           INQUIRE(FILE=file_date,OPENED=already_opened(ino))
           IF (.NOT. already_opened(ino)) THEN
              OPEN(UNIT=20+ino,&
                   FILE=file_date,&
                   ACCESS="SEQUENTIAL",&
                   FORM="FORMATTED",&
                   STATUS="UNKNOWN")
              already_opened(ino) = .TRUE.
           END IF
        endif
     enddo check

     IF (irtyp.ge.511) then
        IF ( ( (ylat.le.xlatn) .and. (ylat.ge.xlats) ) .and. ( (    &
             ylon.ge.xlonw) .and. (ylon.le.xlone) ) ) then
           ista(ino)=ista(ino)+1
           istatn=ista(ino)
           CALL writsfc (FMTSTR2,ino,currentdate)
        ENDIF
     ELSE
        PRINT * , 'Unknown irtyp: ', irtyp
        CALL abort ()
     ENDIF

     GOTO 10

25 END DO

  STOP 99999
END PROGRAM main_sfcadp

Subroutine WRITSFC (FMTSTR,ino,currentdate)
  use adp_module
  logical :: bogus=.false.
  character(len=40) station_info
  character(len=19) currentdate
  CHARACTER(255) FMTSTR
  CHARACTER(19) hdate, ndate
  integer::ino
  real :: xslp, xsfcp

!-----------------------------------------------------------------------
!
  CALL UNPKSFC (INN, SFCDD, SFCFF, IVV, IWW, IW, SLP, SFCP, SFCT,   &
       IN, IC1, IH, IC2, IC3, SFCTD, IPCHAR, ABDPDT, R6, R24, SNODEP,    &
       TSEA, Q, TMAX, TMIN, KLV, LLV)

  mdate = mod(iyr,100) * 1000000 + imo * 10000 + idy * 100 + ihr
  CALL build_hdate (hdate, iyr, imo, idy, ihr, 00, 00)
  itimehr = nint (time)
  itimemn = 0 !KWM      itimemn = nint((time-float(itimehr))*60.)
  mdate2 = 99999999
  IF (ihr.eq.0) then
     IF (itimehr.gt.12) then
        idts = - 86400
        CALL geth_newdate (ndate, hdate, idts)
        idts = (itimehr * 3600) + (itimemn * 60)
        CALL geth_newdate (hdate, ndate, idts)
     ELSE
        idts = (itimehr * 3600) + (itimemn * 60)
        CALL geth_newdate (ndate, hdate, idts)
        hdate = ndate
     ENDIF
  ELSEIF ( (ihr.eq.6) .or. (ihr.eq.12) .or. (ihr.eq.18) ) then
     idts = - ihr * 3600
     CALL geth_newdate (ndate, hdate, idts)
     idts = (itimehr * 3600) + (itimemn * 60)
     CALL geth_newdate (hdate, ndate, idts)
  ELSEIF ( (ihr.eq.3) .or. (ihr.eq.9) .or. (ihr.eq.15) .or. (       &
          ihr.eq.21) ) then
     idts = - ihr * 3600
     CALL geth_newdate (ndate, hdate, idts)
     idts = (itimehr * 3600) + (itimemn * 60)
     CALL geth_newdate (hdate, ndate, idts)
  ELSE
     CALL abort ()
  ENDIF
  READ (hdate (3:4) , '(I2)') iyy
  READ (hdate (6:7) , '(I2)') imm
  READ (hdate (9:10) , '(I2)') idd
  READ (hdate (12:13) , '(I2)') ihh
  mdate2 = iyy * 1000000 + imm * 10000 + idd * 100 + ihh

  IF (R6.gt.999998.) then
     R6w = - 9999.
  ELSE
     R6w = R6
  ENDIF
  IF (R24.gt.999998.) then
     R24w = - 9999.
  ELSE
     R24w = R24
  ENDIF

  DO ik = 1, 8
     IF (SSTA (ik:ik) .eq.char (0) ) ssta (ik:ik) = ' '
  enddo
  station_info=ssta//'                                '
! WRITE (4, FMT = FMTSTR) SSTA, mdate, time, mdate2, YLAT, YLON,   &
!      ELEV, SLP, SFCP, SFCT, SFCTD, SFCDD, SFCFF, IWW, IVV, IW, INN, IN,&
!      IC1, IH, IC2, IC3, IPCHAR, ABDPDT, TMAX, TMIN, R6, R24, SNODEP,   &
!      TSEA

  IF (sfcp.gt.2000) THEN
     xsfcp=-888888
  ELSE
     xsfcp=sfcp*100
  END IF
  IF (slp.gt.2000) THEN
     xslp=-888888
  ELSE
     xslp=slp*100
  ENDIF
  IF (sfcdd.gt.998) sfcdd = 99999.
  IF (sfcff.gt.998) sfcff = 99999.
  IF (sfct.gt.998) then
     sfct = 99999.
     plust=0
  ELSE
     plust=273.15
  END IF
  IF ((sfctd.gt.98).or.(sfct.gt.998)) THEN
     sfctd = -888888
     plustd=0
  ELSE
     plustd=273.15
  END IF

      CALL write_obs (xsfcp,elev,sfct+plust,sfctd+plustd,sfcff,sfcdd, &
                      xslp, elev, ylat, ylon, currentdate, 1, &
                      station_info ,  &
                      'SFC OBS from NCAR ADP DS464.0           ', &
                      'FM-12 TEMP                              ', & 
                      '                                        ', &
                      bogus , istatn , 20+ino )

END Subroutine WRITSFC

SUBROUTINE UNPKSFC (INN, SFCDD, SFCFF, IVV, IWW, IW, SLP, SFCP,   &
     SFCT, IN, IC1, IH, IC2, IC3, SFCTD, IPCHAR, ABDPDT, R6, R24,      &
     SNODEP, TSEA, Q, TMAX, TMIN, KLV, LLV)
  use adp_module
  implicit none

  CHARACTER HQ * 5
  character(LEN=4) :: Q
  CHARACTER(1) QSLP, QSFP, QW, QT, QD
  integer :: igpass
  real :: tmax, tmin, slp, sfcdd, sfcff, sfct, sfctd, sfcp, r6, r24, snodep, tsea
  real :: abdpdt
  integer :: ivv, iww, iw, inn, in, ic1, ic2, ic3, ipchar, ih
  integer :: klv, llv, kpt, ioff, ncat, nskp, nch

!  INN
!  SFCDD
!  SFCFF
!  IVV
!  IWW
!  IW
!  SLP
!  SFCP
!  SFCT
!  IN
!  IC1
!  IH
!  IC2
!  IC3
!  SFCTD
!  IPCHAR
!  ABDPDT
!  R6
!  R24
!  SNODEP
!  TSEA
!  Q
!  KLV
!  LLV


  IGPASS = 0
  TMAX = 999.9
  TMIN = 999.9
  IVV = - 999
  SLP = 9999999.
  SFCDD = 9999999.
  SFCFF = 9999999.
  SFCT = 999999.
  SFCTD = 999999.
  SFCP = 999999.
  R6 = - 999.
  R24 = - 999.
  SNODEP = - 999.
  TSEA = - 999.
  KLV = 0
  LLV = 0
  KPT = NPT + 4
5 IOFF = NTBTS * (KPT - 1)
  CALL GBYTES (NB, IC, IOFF, NCSZ, 0, 10)
  NCAT = NTENS (IC (1), 2)
! if (ncat.ne.51) print*, 'ncat = ', ncat
  NSKP = NTENS (IC (3), 3)
  NLV = NTENS (IC (6), 2)
  NCH = NTENS (IC (8), 3)
  IGPASS = IGPASS + 1
  IF (IGPASS.GE.6) RETURN
  IF (NCAT.EQ.51) THEN
     KLV = NTENS (IC (6), 2)
     IF (KLV.GE.2) THEN
        WRITE ( * , '('' SFCADP HAS KLV= '',I5,''LEVELS'')') KLV
        KLV = 1
     ENDIF
     KPT = KPT + 1
     IOFF = NTBTS * (KPT - 1)
     CALL GBYTES (NB, IC, IOFF, NCSZ, 0, 60)

     SLP = NTENS (IC (1), 5) * 0.1                   !  Sea-level Pressure
     SFCP = NTENS (IC (6), 5) * 0.1                  !  Station pressure
     SFCDD = NTENS (IC (11), 3)                      !  Wind direction
     SFCFF = NTENS (IC (14), 3)                      !  Wind speed (knots, converted in the next line)
     IF (SFCFF.lt.998) sfcff = sfcff * (463. / 900.) ! Convert from knot to m/s
     SFCT = NTENS (IC (17), 4) * 0.1                 !  Temperature (C)
     IF (SFCT.lt.998) THEN
        SFCTD = NTENS (IC (21), 3) * 0.1                !  Dewpoint Depression (C)
        IF(SFCTD.lt.98) THEN
           SFCTD=SFCT-SFCTD                             !  We want dew point, not depression (C)
        ELSE
           SFCTD=999999
        ENDIF
     ELSE
        SFCTD = NTENS (IC (21), 3) * 0.1                !  Dewpoint Depression (C)
     ENDIF
     TMAX = NTENS (IC (24), 4) * 0.1                 !  Maximum T (C)
     TMIN = NTENS (IC (28), 4) * 0.1                 !  Minimum T (C)
     IVV = NTENS (IC (37), 3)                        !  Horizontal Visibility
!    if (ivv.ne.0) PRINT * , 'ivv = ', ivv
     IWW = NTENS (IC (40), 3)                        !  Present Weather
     IW = NTENS (IC (43), 2)                         !  Past weather
     INN = NTENS (IC (45), 2)                        !  Fraction of celestial dome covered by cloud.
     IN = NTENS (IC (47), 2)                         !  Fraction covered by Cl (or Cm)
     IC1 = NTENS (IC (49), 2)                        !  Clouds of genera Sc, St, Cu, Cb (Cl)
     IH = NTENS (IC (51), 2)                         !  Height above ground for cloud base.
     IC2 = NTENS (IC (53), 2)                        !  Clouds of genera Ac, As, Ns (Cm)
     IC3 = NTENS (IC (55), 2)                        !  Clouds of genera Ci, Cc, Cs (Ch)
     IPCHAR = NTENS (IC (57), 1)                     !  Characteristic of pressure tendency.
     ABDPDT = NTENS (IC (58), 3) * 0.1               !  Magnitude of pressure tendency.

!KWM      Q = BLANK
!KWM      IOFF = NWSZ - NCSZ*5
!KWM      CALL SBYTES(Q,IC(32),IOFF,NCSZ,0,5)
!KWM      write(HQ,'(A5)') Q
!KWM      read(HQ,'(A1,A1,A1,A1,A1)') Qslp, Qsfp, Qw, Qt, Qd

     ELSEIF (NCAT.EQ.52) THEN
     LLV = NTENS (IC (6), 2)
     IF (LLV.GE.2) THEN
        WRITE ( * , '(''SFCSHP HAS LLV= '',I5,'' LEVELS'')') LLV
        LLV = 1
     ENDIF
     KPT = KPT + 1
     IOFF = NTBTS * (KPT - 1)
     CALL GBYTES (NB, IC, IOFF, NCSZ, 0, 40)

     R6 = NTENS (IC (1), 4) * 0.01      !  6-hour rainfall
     SNODEP = NTENS (IC (5), 3)         !  Snow Depth
     R24 = NTENS (IC (8), 4) * 0.01     !  24-hour rainfall
     TSEA = NTENS (IC (23), 4) * 0.1    !  Sea-surface T

     IF (R6.GT.80.0) R6 = - 999.
     IF (R24.GT.80.0) R24 = - 999.
     IF (SNODEP.GT.900.0) SNODEP = - 999.
     IF (TSEA.GT.100.0) TSEA = - 999.
     RETURN

  ENDIF

  IF (NSKP.GE.LTH) RETURN
  KPT = NSKP + NPT - 1
  IF (LOGCMP (NB, KPT, EOREP)) RETURN
  IF (IGPASS.GT.2) PRINT 15, IGPASS, NCAT, NSKP, NLV, NCH
  GOTO 5

15 FORMAT('IGPASS=',I3,2X,'NCAT=',I3,2X,'NSKP=',I3,2X,'NLV=',        &
       &     I3,2X,'NCH=',I3,2X,'IN SFCADP')

END SUBROUTINE UNPKSFC

SUBROUTINE make_fmts (hhh, nrows, ncols, fmtstr, fmtstr2)
  CHARACTER(6) hhh (ncols, nrows)
  CHARACTER(255) fmtstr, fmtstr2

  fmtstr = ' '
  fmtstr2 = ' '

  FMTSTR (1:1) = '('
  ilen = 1
  DO n = 1, nrows
     FMTSTR (ilen + 1:ilen + 3) = 'A'//hhh (2, n) (2:2) //','
     ilen = ilen + 3
  enddo
  FMTSTR (ilen:ilen + 1)  = ')      '
!KWM      print*, 'FMTSTR = ', FMTSTR
  WRITE (FMTSTR2, FMT = FMTSTR) '('//hhh (2, 1)  (1:index (hhh (2, 1&
       &) , ' ')  - 1) //',     ',  (hhh (2, n)  (1:index (hhh (2, n) , ' &
       &')  - 1) //',        ', n = 2, nrows - 1) , hhh (2, nrows)  (1:ind&
       &ex (hhh (2, nrows) , ' ')  - 1) //')'

END SUBROUTINE make_fmts

subroutine parse_table(hhh, ncols, nrows)
  character*6 hhh(ncols,nrows)
  integer hlen
  character*60 string

  logical lexist

  inquire(file='FMTTBL', exist=lexist)
  if (.not. lexist) then
     call get_unit_number(iunit)

     open(iunit, file='FMTTBL', status='new', form='formatted')
     write(iunit, '("| HEADING | FORMAT |")')
     write(iunit, '("+---------+--------+")')
     write(iunit, '("| STN     | A6     |")')
     write(iunit, '("| DATE    | I8     |")')
     write(iunit, '("| TIME    | F6.2   |")')
     write(iunit, '("| MDATE2  | I9     |")')
     write(iunit, '("| LAT     | F6.2   |")')
     write(iunit, '("| LON     | F7.2   |")')
     write(iunit, '("| ELEV    | F7.1   |")')
     write(iunit, '("| SLP     | F7.1   |")')
     write(iunit, '("| PSFC    | F7.1   |")')
     write(iunit, '("| T       | F5.1   |")')
     write(iunit, '("| DWPT    | F5.1   |")')
     write(iunit, '("| WDIR    | F5.0   |")')
     write(iunit, '("| WSPD    | F6.1   |")')
     write(iunit, '("| IWW     | I4     |")')
     write(iunit, '("| IVV     | I4     |")')
     write(iunit, '("| IW      | I3     |")')
     write(iunit, '("| INN     | I4     |")')
     write(iunit, '("| IN      | I3     |")')
     write(iunit, '("| IC1     | I4     |")')
     write(iunit, '("| IH      | I3     |")')
     write(iunit, '("| IC2     | I4     |")')
     write(iunit, '("| IC3     | I4     |")')
     write(iunit, '("| PCHR    | I5     |")')
     write(iunit, '("| ABDPD   | F6.1   |")')
     write(iunit, '("| TMAX    | F6.1   |")')
     write(iunit, '("| TMIN    | F6.1   |")')
     write(iunit, '("| R6      | F8.2   |")')
     write(iunit, '("| R24     | F8.2   |")')
     write(iunit, '("| SNOD    | F7.1   |")')
     write(iunit, '("| TSEA    | F7.1   |")')
     write(iunit, '("+---------+--------+")')

     close(iunit)
     
  endif

  hlen = len(hhh(1,1))

! Initialize character table to char(0).

  do i = 1, ncols
     do j = 1, nrows
        do k = 1, hlen
           hhh(i,j)(k:k) = char(0)
        enddo
     enddo
  enddo

! Get an unused unit number.

  call get_unit_number(iunit)

! Open the table file.
      
  print*, 'Opening FMTTBL as unit ', iunit
  open(iunit, file='FMTTBL', status='old', form='formatted')

! Read past the preliminaries, until we hit a line that begins with "+"

  string(1:1)=' '
  do while ( string(1:1).ne.'+' )
     read(iunit, '(A60)', iostat=ierr) string
     if (ierr.ne.0) then
        print*, 'IERR = ', IERR
        call abort()
     endif
  enddo

! Read the important stuff in the table, until we hit a "+" in the first column
  string(1:1) = char(0)
  irow = 0
  do while ( string(1:1).ne.'+' )
     read(iunit, '(A60)', iostat=ierr) string
     if (ierr.ne.0) then
        print*, '2: IERR = ', IERR
        call abort
     endif
     if (string(1:1).ne.'+') then
        irow = irow + 1
        istart = 2
        do n = 1, ncols
           ibar = index(string(istart:60),'|')+istart-1
           ist = 0
           do while ( string(istart+ist:istart+ist).eq.' ')
              ist = ist + 1
           enddo
           read(string(istart+ist:ibar-1),'(A6)', iostat=ierr) hhh(n,irow)
           if (ierr.ne.0) then
              print*, '3:  IERR = ', IERR
              call abort()
           endif
           istart = ibar + 1
        enddo
     endif
  enddo

! Close the table file.
  close(iunit)
end subroutine parse_table

subroutine get_unit_number(iunit)
  implicit none
  integer :: iunit
  integer :: i
  logical lopen
  do i = 10, 150
     inquire(unit=i, opened=lopen)
     if (.not. lopen) then
        iunit = i
        return
     endif
  enddo
  write(*,'("*** Unused Unit number not found")')
  write(*,'("*** ABORT in GET_UNIT_NUMBER")')
  call abort

end subroutine get_unit_number

!KWM Emacs Local Variables: ***
!KWM Emacs mode: f90        ***
!KWM Emacs End:             ***
!---------------------------------------------------------------------------
SUBROUTINE write_obs ( p , z , t , td , spd , dir , &
                      slp , ter , xlat , xlon , currentdate , kx ,  &
                      string1 , string2 , string3 , string4 , &
                      bogus , iseq_num , iunit )

   IMPLICIT NONE

   !  Input data.

   INTEGER              :: kx , iseq_num , iunit
   REAL                 :: p , z , t , td , spd , dir
   REAL                 :: slp , ter , xlat , xlon 
   CHARACTER (len=19)   :: currentdate
   CHARACTER(LEN=40)    :: string1, string2 , string3 , string4
   LOGICAL              :: bogus
   
   !  Local data.

   INTEGER              :: k
   CHARACTER(LEN=20)    :: date_char
   CHARACTER(LEN=84)    :: rpt_format   = ' ( 2F20.5 , 2A40 , ' &
                                          // ' 2A40 , 1F20.5 , 5I10 , 3L10 , ' &
                                          // ' 2I10 , A20 ,  13( f13.5 , I7 ) ) '
   CHARACTER(LEN=22)    :: meas_format  = ' ( 10( F13.5 , I7 ) ) '
   CHARACTER(LEN=14)    :: end_format   = ' ( 3 ( I7 ) ) '

   date_char( 1: 6) = '      '
   date_char( 7:10) = currentdate( 1: 4)
   date_char(11:12) = currentdate( 6: 7)
   date_char(13:14) = currentdate( 9:10)
   date_char(15:16) = currentdate(12:13)
   date_char(17:20) = '0000'
   
   !  There are three distinct WRITES for the little_r format.  The
   !  first is this one-time header that has information concerning
   !  the location and elevation of the station, the station ID and
   !  name.  Also included is the sea level pressure.  Note that all 
   !  of the measured data have a qc flag associated with them.

   WRITE ( UNIT = iunit , FMT = rpt_format ) &
           xlat,xlon, string1 , string2 , & 
           string3 , string4 , ter, kx*6, 0,0,iseq_num,0, & 
           .TRUE.,bogus,.FALSE., &
           -888888, -888888, date_char , slp,0, &
           -888888.,0, -888888.,0, -888888.,0, -888888.,0, -888888.,0,  &
           -888888.,0, -888888.,0, -888888.,0, -888888.,0, -888888.,0,  &
           -888888.,0, -888888.,0
      
   !  Here is the second type of data for the little_r format.  This is
   !  the vertical list of the various data values.  

      WRITE ( UNIT = iunit , FMT = meas_format ) &
              p, 0, z,0, t,0, td,0, &
              spd,0, dir,0, &
              -888888.,0, -888888.,0,-888888.,0, -888888.,0

   !  In the same format as the second data type we write a flag
   !  value so that the program knows we have hit the end of real
   !  data.

   WRITE ( UNIT = iunit , FMT = meas_format ) &
           -777777.,0, -777777.,0,float(kx),0, &
           -888888.,0, -888888.,0, -888888.,0,  &
           -888888.,0, -888888.,0, -888888.,0,  &
           -888888.,0

   !  Finally, the last type of data in the little_r format is the
   !  flag that says this this report is finished.  It says how many
   !  vertical levels were found and some error information, but the
   !  error info is simply turned off.

   WRITE ( UNIT = iunit , FMT = end_format )  kx, 0, 0
!  close (iunit)

END SUBROUTINE write_obs
