
!-------------------------------------------------------------------------------

SUBROUTINE conv_adp_r (levels,p,z,t,td,spd,dir,&
                     slp,ter,xlat,xlon,currentdate,station,iseq,outunit)

   IMPLICIT NONE

   !  There are a few variables that we can define.

   INTEGER :: levels
   REAL , DIMENSION(levels) :: &
          p,z,t,td,spd,dir
   REAL :: slp, ter, xlat, xlon

   character(len=19) :: currentdate

   CHARACTER(LEN=5) :: station

   LOGICAL :: bogus = .FALSE. , end_of_data = .FALSE.
  
   CHARACTER(LEN=40) :: station_info
 
   INTEGER :: outunit,iseq

      !  Build the character string that holds the 5-digit station identifier.
   
      station_info = station // '                                   '
   
      !  Output mandatory level data.  This is pressure based
      !  temperature, dew point and wind.
   
      CALL write_obs (p,z,t,td,spd,dir, &
                      slp, ter, xlat, xlon, currentdate, levels, &
                      station_info ,  &
                      'Soundings from NCAR DS353.4 ADP         ', &
                      'FM-35 TEMP                              ', & 
                      '                                        ', &
                      bogus , iseq , outunit )
   
END SUBROUTINE conv_adp_r

!-------------------------------------------------------------------------------

SUBROUTINE write_obs ( p , z , t , td , spd , dir , &
                      slp , ter , xlat , xlon , currentdate , kx ,  &
                      string1 , string2 , string3 , string4 , &
                      bogus , iseq_num , iunit )

   IMPLICIT NONE

   !  Input data.

   INTEGER              :: kx , iseq_num , iunit
   REAL , DIMENSION(kx) :: p , z , t , td , spd , dir
   REAL                 :: slp , ter , xlat , xlon 
   character(len=19)    :: currentdate
   CHARACTER(LEN=40)    :: string1, string2 , string3 , string4
   LOGICAL              :: bogus
   
   !  Local data.

   INTEGER              :: k
   CHARACTER(LEN=20)    :: date_char
   CHARACTER(LEN=84)    :: rpt_format   = ' ( 2F20.5 , 2A40 , ' &
                                          // ' 2A40 , 1F20.5 , 5I10 , 3L10 , ' &
                                          // ' 2I10 , A20 ,  13( f13.5 , I7 ) ) '
   CHARACTER(LEN=22)    :: meas_format  = ' ( 10( F13.5 , I7 ) ) '
   CHARACTER(LEN=14)    :: end_format   = ' ( 3 ( I7 ) ) '

   date_char( 1: 6) = '      '
   date_char( 7:10) = currentdate( 1: 4)
   date_char(11:12) = currentdate( 6: 7)
   date_char(13:14) = currentdate( 9:10)
   date_char(15:16) = currentdate(12:13)
   date_char(17:20) = '0000'
   
   !  There are three distinct WRITES for the little_r format.  The
   !  first is this one-time header that has information concerning
   !  the location and elevation of the station, the station ID and
   !  name.  Also included is the sea level pressure.  Note that all 
   !  of the measured data have a qc flag associated with them.

   WRITE ( UNIT = iunit , FMT = rpt_format ) &
           xlat,xlon, string1 , string2 , & 
           string3 , string4 , ter, kx*6, 0,0,iseq_num,0, & 
           .TRUE.,bogus,.FALSE., &
           -888888, -888888, date_char , slp,0, &
           -888888.,0, -888888.,0, -888888.,0, -888888.,0, -888888.,0,  &
           -888888.,0, -888888.,0, -888888.,0, -888888.,0, -888888.,0,  &
           -888888.,0, -888888.,0
      
   !  Here is the second type of data for the little_r format.  This is
   !  the vertical list of the various data values.  

   DO k = 1 , kx
      WRITE ( UNIT = iunit , FMT = meas_format ) &
              p(k), 0, z(k),0, t(k),0, td(k),0, &
              spd(k),0, dir(k),0, &
              -888888.,0, -888888.,0,-888888.,0, -888888.,0
   END DO

   !  In the same format as the second data type we write a flag
   !  value so that the program knows we have hit the end of real
   !  data.

   WRITE ( UNIT = iunit , FMT = meas_format ) &
           -777777.,0, -777777.,0,float(kx),0, &
           -888888.,0, -888888.,0, -888888.,0,  &
           -888888.,0, -888888.,0, -888888.,0,  &
           -888888.,0

   !  Finally, the last type of data in the little_r format is the
   !  flag that says this this report is finished.  It says how many
   !  vertical levels were found and some error information, but the
   !  error info is simply turned off.

   WRITE ( UNIT = iunit , FMT = end_format )  kx, 0, 0

END SUBROUTINE write_obs

!-------------------------------------------------------------------------------

SUBROUTINE read_adp ( p_man , z_man , t_man , td_man , spd_man , dir_man , &
                      p_sig , z_sig , t_sig , td_sig , spd_sig , dir_sig , & 
                      p_p   , z_p   , t_p   , td_p   , spd_p   , dir_p   , &
                      p_hgt , z_hgt , t_hgt , td_hgt , spd_hgt , dir_hgt , &
                      slp, ter, xlat, xlon , &
                      mdate, iseq_num , id_station , &
                      kx_man , kx_sig , kx_p , kx_hgt , &
                      end_of_data , iunit )

   IMPLICIT NONE

   !  Input data.

   REAL , DIMENSION(1000) :: &
          p_man , z_man , t_man , td_man , spd_man , dir_man , & 
          p_sig , z_sig , t_sig , td_sig , spd_sig , dir_sig , & 
          p_p   , z_p   , t_p   , td_p   , spd_p   , dir_p   , &
          p_hgt , z_hgt , t_hgt , td_hgt , spd_hgt , dir_hgt

   REAL :: slp, ter, xlat, xlon

   INTEGER :: mdate, iseq_num , iunit
   CHARACTER(LEN=5) :: id_station
   INTEGER :: kx_man , kx_sig , kx_p , kx_hgt

   LOGICAL :: end_of_data

   !  Local data.

   INTEGER :: read_status , i
   LOGICAL :: still_at_it

   CHARACTER(LEN= 1) :: char
   CHARACTER(LEN=20) :: report_fmt             = '(37X,I5,3X,A5,4X,I8)'
   CHARACTER(LEN=12) :: location_fmt           = '(21X,3F10.3)'
   CHARACTER(LEN= 7) :: name_fmt               = '(11X,A)'
   CHARACTER(LEN= 8) :: mandatory_header_fmt   = '(30X,I5)'
   CHARACTER(LEN=38) :: mandatory_fmt          = '(14X,F12.1,4(F10.1,2x),F12.1,6X,F12.1)'
   CHARACTER(LEN= 8) :: significant_header_fmt = '(47X,I5)'
   CHARACTER(LEN=12) :: significant_fmt        = '(14X,3F12.1)'
   CHARACTER(LEN= 8) :: pres_wind_header_fmt   = '(34X,I5)'
   CHARACTER(LEN=12) :: pres_wind_fmt          = '(14X,3F12.1)'
   CHARACTER(LEN= 8) :: height_wind_header_fmt = '(32X,I5)'
   CHARACTER(LEN=12) :: height_wind_fmt        = '(14X,3F12.1)'
   
   !  Initialize the data to undefined.

   p_man   = -888888.  
   z_man   = -888888.  
   t_man   = -888888.  
   td_man  = -888888.  
   spd_man = -888888.  
   dir_man = -888888. 
   p_sig   = -888888.  
   z_sig   = -888888.  
   t_sig   = -888888.  
   td_sig  = -888888.  
   spd_sig = -888888.  
   dir_sig = -888888. 
   p_p     = -888888.    
   z_p     = -888888.    
   t_p     = -888888.    
   td_p    = -888888.    
   spd_p   = -888888.    
   dir_p   = -888888.  
   p_hgt   = -888888.  
   z_hgt   = -888888.  
   t_hgt   = -888888.  
   td_hgt  = -888888.  
   spd_hgt = -888888.  
   dir_hgt = -888888.
   slp     = -888888. 
   ter     = -888888. 
   xlat    = -888888. 
   xlon    = -888888.
   kx_man  = 0
   kx_sig  = 0
   kx_p    = 0
   kx_hgt  = 0

   !  Read in a single report.  This can contain as many as three
   !  different kinds of data: mandatory (temp and wind), sig temp,
   !  sig press wind, and sig height wind.

   report_loop : DO WHILE ( .NOT. end_of_data ) 

      !  This is the first read of the report.  Check for EOF also.
 
      READ ( UNIT = iunit , FMT = name_fmt , IOSTAT = read_status ) char

      !  Any problems, such as the end-of-file, should show up here.

      IF ( read_status .NE. 0 ) THEN
         PRINT '(A)','Hit end of data on report header read.  This is expected.'
         end_of_data = .TRUE.
         EXIT report_loop
      END IF

      IF      ( char .EQ. ' ' ) THEN
         READ ( UNIT = iunit , FMT = '(A)' ) char
         READ ( UNIT = iunit , FMT = '(A)' ) char
         READ ( UNIT = iunit , FMT = '(A)' ) char
         READ ( UNIT = iunit , FMT = '(A)' ) char
      ELSE IF ( char .EQ. 'E' ) THEN
         BACKSPACE ( UNIT = iunit ) 
      ELSE
         PRINT '(A)','This should not happen.'
         STOP
      END IF

      !  This is the first read of the report.

      READ ( UNIT = iunit , FMT = report_fmt ) iseq_num , id_station , mdate
      
      !  This is the second read of the report.  This is the location
      !  and elevation of the station.

      READ ( UNIT = iunit , FMT = location_fmt ) xlat , xlon , ter

      !  There are 4 possible data types.
      
      still_at_it = .TRUE.
      loop_of_4 : DO WHILE ( still_at_it )  

         READ ( UNIT = iunit , FMT = '(A)' , IOSTAT = read_status ) char 
         IF ( read_status .NE. 0 ) THEN
            end_of_data = .TRUE.
            EXIT report_loop
         END IF
         READ ( UNIT = iunit , FMT = name_fmt ) char  
    
         BACKSPACE ( UNIT = iunit ) 

         !  Which of the 4 types was that data?

         IF      ( char .EQ. 'M' ) THEN
            READ ( UNIT = iunit , FMT = mandatory_header_fmt ) kx_man
            READ ( UNIT = iunit , FMT = '(A)' ) char 
            DO i = 1 , kx_man
               READ ( UNIT = iunit , FMT = mandatory_fmt ) p_man(i),z_man(i),t_man(i),td_man(i),dir_man(i),spd_man(i)
               p_man(i) = p_man(i) * 100.
               IF ( t_man(i) .GT. 900 ) THEN
                  t_man(i) = -888888.
                  td_man(i) = -888888.
               ELSE
                  t_man(i) = t_man(i) + 273.15
               END IF
               IF ( ( td_man(i) .GT. 900 ) .OR. ( td_man(i) .LT. -888880 ) ) THEN
                  td_man(i) = -888888.
               ELSE
                  td_man(i) = td_man(i) + 273.15
               END IF
               IF ( ( dir_man(i) .GT. 900 ) .OR. ( spd_man(i) .GT. 900 ) ) THEN
                  dir_man(i) = -888888.
                  spd_man(i) = -888888.
               END IF
! IF((p_man(i).le.20000).and.(td_man(i).gt.0).and.(mdate.eq.87060400).and.&
! (xlat.lt.60).and.(xlat.gt.20).and.(xlon.lt.-65).and.(xlon.gt.-140)) print *,id_station,xlat,xlon,p_man(i),td_man(i)
            END DO

         ELSE IF ( char .EQ. 'S' ) THEN
            READ ( UNIT = iunit , FMT = significant_header_fmt ) kx_sig
            READ ( UNIT = iunit , FMT = '(A)' ) char 
            DO i = 1 , kx_sig
               READ ( UNIT = iunit , FMT = significant_fmt ) p_sig(i),t_sig(i),td_sig(i)
               p_sig(i) = p_sig(i) * 100.
               IF ( t_sig(i) .GT. 900 ) THEN
                  t_sig(i) = -888888.
                  td_sig(i) = -888888.
               ELSE
                  t_sig(i) = t_sig(i) + 273.15
               END IF
               IF ( ( td_sig(i) .GT. 900 ) .OR. ( td_sig(i) .LT. -888880 ) ) THEN
                  td_sig(i) = -888888.
               ELSE
                  td_sig(i) = td_sig(i) + 273.15
               END IF
! IF((p_sig(i).le.20000).and.(td_sig(i).gt.0).and.(mdate.eq.87060400).and.&
! (xlat.lt.60).and.(xlat.gt.20).and.(xlon.lt.-65).and.(xlon.gt.-140)) print *,id_station,xlat,xlon,p_sig(i),td_sig(i)
            END DO
            z_sig(1) = ter

         ELSE IF ( char .EQ. 'P' ) THEN
            READ ( UNIT = iunit , FMT = pres_wind_header_fmt ) kx_p  
            READ ( UNIT = iunit , FMT = '(A)' ) char 
            DO i = 1 , kx_p  
               READ ( UNIT = iunit , FMT = pres_wind_fmt ) p_p(i),dir_p(i),spd_p(i)
               p_p(i) = p_p(i) * 100.
               IF ( ( dir_p(i) .GT. 900 ) .OR. ( spd_p(i) .GT. 900 ) ) THEN
                  dir_p(i) = -888888.
                  spd_p(i) = -888888.
               END IF
            END DO
            z_p(1) = ter

         ELSE IF ( char .EQ. 'H' ) THEN
            READ ( UNIT = iunit , FMT = height_wind_header_fmt ) kx_hgt  
            READ ( UNIT = iunit , FMT = '(A)' ) char 
            DO i = 1 , kx_hgt  
               READ ( UNIT = iunit , FMT = height_wind_fmt ) z_hgt(i),dir_hgt(i),spd_hgt(i)
               IF ( ( dir_hgt(i) .GT. 900 ) .OR. ( spd_hgt(i) .GT. 900 ) ) THEN
                  dir_hgt(i) = -888888.
                  spd_hgt(i) = -888888.
               END IF
            END DO
            z_hgt(1) = ter

         ELSE IF ( char .EQ. ' ' ) THEN
            READ ( UNIT = iunit , FMT = '(A)' , IOSTAT = read_status ) char 
            IF ( read_status .NE. 0 ) THEN
               end_of_data = .TRUE.
            END IF
            READ ( UNIT = iunit , FMT = '(A)' , IOSTAT = read_status ) char 
            IF ( read_status .NE. 0 ) THEN
               end_of_data = .TRUE.
            END IF
            READ ( UNIT = iunit , FMT = '(A)' , IOSTAT = read_status ) char 
            IF ( read_status .NE. 0 ) THEN
               end_of_data = .TRUE.
            END IF
            READ ( UNIT = iunit , FMT = '(A)' , IOSTAT = read_status ) char 
            still_at_it = .FALSE.
            IF ( read_status .NE. 0 ) THEN
               end_of_data = .TRUE.
            END IF
            EXIT report_loop
         END IF

      END DO loop_of_4

   END DO report_loop

END SUBROUTINE read_adp
