      SUBROUTINE GETRAW (istartdate,ienddate)
!
!        PURPOSE: THIS ROUTINE READS A PACKED UPPER AIR DATA TAPE,
!                 RETRIEVES AND UNPACKS DESIRED RECORDS.
!
!-----------------------------------------------------------------------
      PARAMETER(IRS=50)
include 'commonb.inc'
include 'commonc.inc'
include 'commonadp.inc'
!-----------------------------------------------------------------------
!
      DIMENSION IUPTYP(6)
      DATA NVOLUP /15/, IUPTYP /11,12,13,21,22,23/
!
!-----------------------------------------------------------------------
!
!  DEFINE GETRAW INTERNAL CODES:
!
!    TAPE VOLUME NUMBERS:
!      NVOLUP = 15-19  :   VOL. NO. FOR ARCHIVED UPPER-AIR
!                          (RADIOSONDE) DATA
!
!      MXRTYP       :   MAXIMUM VALUE OF REPORT TYPE CODE TO BE SOUGHT,
!                       CONTROLLED BY USER-DEFINITION OF IUPPER,
!                       = 23   UPPER AIR SOUNDINGS
!
!      LIST OF REPORT-TYPE CODES
!
!        011 - UPPER AIR, LAND, BY BLOCK AND STATION NO.
!        012 - UPPER AIR, LAND, BY CALL LETTERS
!        013 - UPPER AIR, LAND, BY LAT. AND LONG.
!        021 - UPPER AIR, FIXED SHIP
!        022 - UPPER AIR, MOVING SHIP WITH NAME
!        023 - UPPER AIR, MOVING SHIP WITHOUT NAME
!        031 - UPPER AIR, RECONNAISSANCE AIRCRAFT
!        041 - UPPER AIR, AIRCRAFT REPORT (PILOT OBS.)
!        051 - UPPER AIR, MONITORING BOGUS STA., BY LAT. AND LONG.
!        061 - UPPER AIR, SATELL., SIRS SOUNDING
!        062 - UPPER AIR, SATELL., CLOUD WIND ESTIMATE
!        063 - UPPER AIR, SATELL., ATS WIND ESTIMATE
!
!-----------------------------------------------------------------------
!
      DIMENSION MDUP(IRS)
!
      PRINT 5
      print*, 'bounding dates = ',istartdate,ienddate
    5 FORMAT(1H1,*@@@@@@@@@@ CALL GETRAW---INACCT,SAVSTN,(SAVFIL)*,12X,*RAOB INVENTORY*//)
      JSTATN=0
!
!-----------------------------------------------------------------------
!---------SET UP SEARCH FOR UPPER AIR DATA (AT 00 GMT OR 12 GMT)
      IT=NVOLUP
      IREC=0
      IWDS=0
      NPT=9
      LTH=0
!
!---------BEGIN DATA PROCESSING CYCLE
300   CONTINUE
!
!---------READ DATA TAPE
   10 CONTINUE
   11 CONTINUE
      CALL RDADP(IT,IST,NYR,NMO,NDY,NHR)
       print *,'date from omservation=',NYR,NMO,NDY,NHR
!         IF END OF FILE IS DETECTED, IST=1 IS RETURNED BY RDADP,
!         SKIP TO BOTTOM OF PROCESSING CYCLE
      IF(IST.EQ.1)GO TO 90
!
!---------DATE AND REPORT-TYPE CHECKS:
       print *,'mystery date         =',IYR,IMO,IDY,IHR
      stop 1
      IDATE=IHR+100*(IDY+100*(IMO+100*IYR))

      IF(IDATE.LT.MDATE)THEN
         GO TO 10
      ENDIF
      IF(IDATE.GT.MDATE)THEN
         GO TO 50
      ENDIF

      KYR=IYR
      KMO=IMO
      KDY=IDY
      KHR=IHR
!
!---------OBS. DATE MATCHES DESIRED ANALYSIS DATE.
!
!---------NEXT, CHECK TO SEE IF ACTUAL TIME OF OBSERVATION IS CLOSE TO
!         DESIRED ANALYSIS TIME (MHR).  THE TIME WINDOW HAS BEEN SET
!         ACCORDING TO THE DATA TYPE.
      RHRP24=MHR+24.0
      DHR1=ABS(MHR-TIME)
      DHR2=ABS(RHRP24-TIME)
      DHR=AMIN1(DHR1,DHR2)
      IF(IRTYP.LE.23.AND.DHR.LE.2.01)GO TO 202
      GO TO 10
202   CONTINUE
!
!---------CHECK REPORT TYPES OFF UPPER-AIR DATA.
      DO 32 I=1,6
         IF(IRTYP.EQ.IUPTYP(I))GO TO 60
32    CONTINUE
      GO TO 10
!
!---------DATE HAS BEEN FOUND TO BE TOO LATE.  CHECK IF READ-PHASE
!         SHOULD BE TERMINATED.
 50   CONTINUE
      GO TO 91
60    CONTINUE
!
!---------CORRECT DATE AND REPORT TYPE HAS BEEN FOUND.
!         PROCEED WITH DOMAIN AND LOCATION CHECKS.
!
!---------SAVE ALL DATA IN SPECIFIED LAT.-LONG. BOX
      IF(YLAT.GT.XLATN .OR. YLAT.LT.XLATS) GO TO 10
      IF(YLON.LT.XLONW .OR. YLON.GT.XLONE) GO TO 10
!
!---***---PROCESS UPPER AIR SOUNDING DATA:  PRE-ANALYSIS PHASE
!
      CALL PROUPR(itime)
      GO TO 11

   90 CONTINUE
      IF(  (IT.EQ.NVOLUP  ) .OR. (IT.EQ.NVOLUP+1) .OR. &
           (IT.EQ.NVOLUP+2) .OR. (IT.EQ.NVOLUP+3) .OR. &
           (IT.EQ.NVOLUP+4) .OR. (IT.EQ.NVOLUP+5) .OR. &
           (IT.EQ.NVOLUP+6) .OR. (IT.EQ.NVOLUP+7) .OR. &
           (IT.EQ.NVOLUP+8) .OR. (IT.EQ.NVOLUP+9) .OR. &
           (IT.EQ.NVOLUP+10) .OR. (IT.EQ.NVOLUP+11) ) THEN
         PRINT *,'INCREMENTING UPPER AIR OBS FILE, ORIG UNIT=15, ', &
                 'CURRENT UNIT=',IT+1
         NVOLUP=NVOLUP+1
         IT=NVOLUP
         GO TO 300
      ELSE
         PRINT *,'IT=',IT,'   TOO MANY OBS FILES, MAX OF 5 EACH'
         print *,'NVOLUP=',NVOLUP,'   ORIG WAS 15'
         STOP 90
      END IF
!
!---------REAL UPPER-AIR DATA READ-STAGE IS FINISHED.  RETURN TO TOP
!         OF GETRAW TO CHECK IF SFC. DATA SHOULD BE READ.
!
   91 IYR=KYR
      IMO=KMO
      IDY=KDY
      IHR=KHR
      PRINT 100,NSTATN,ISTATN
 100  FORMAT(' NSTATN =',I5,'  ISTATN, NO. OF STATIONS FOUND =',I5)
!
!     *** IF NO STATIONS ARE FOUND THERE IS NO POINT IN GOING FURTHER
!
      IF (ISTATN.EQ.0)THEN
         PRINT 99
 99      FORMAT(1H0,2X,*NO STATIONS FOUND--CHECK DATE OR SEARCH AREA*)
         STOP
      END IF
      NSTATN = ISTATN
!
      return
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
!        NOW CHECK UNIQUENESS
      PRINT 630,MDATE
630   FORMAT(///,10X,'UNIQUENESS CHECK OF STATION NUMBERS AT MDATE= ',I8)
!      print*, 'mdup = ', mdup
      NUNIQU=0
      NTOT=NSTATN+JSTATN
      IF(NTOT.GT.0)THEN
      DO 655 I=1,NTOT
         SSTA=ISTNUM(3,I)
         IF(NUNIQU.GT.0)THEN
            DO 635 II=1,NUNIQU
               IF(SSTA.EQ.MDUP(II))THEN
                  DECODE(8,18,MDUP(II))ICNT
 18               FORMAT(5X,I3)
                  ICNT=ICNT+1
                  ENCODE(8,19,INNNN)SSTA,ICNT
 19               FORMAT(A5,I3)
                  ISTNUM(3,I)=INNNN
                  GO TO 655
               ENDIF
 635        CONTINUE
         ENDIF
         DO 650 N=1,NTOT
            IF(SSTA.NE.ISTNUM(3,N).OR.I.EQ.N)GO TO 650
            NUNIQU=NUNIQU+1
            MDUP(NUNIQU)=SSTA
 650     CONTINUE
 655  CONTINUE
      ENDIF
      PRINT 660,MDATE,NUNIQU
660   FORMAT(10X,'AT MDATE=',I8,2X,'THE TOTAL OF NON-UNIQUE STA. NOS. =',I5)
!
!
      PRINT 1000,IREC,IST
1000  FORMAT(5X,'TOTAL RECORDS READ=',I5,2X,'IST=',I5,10X,'...EXIT GETRAW')
!
      RETURN
      END
