      SUBROUTINE PROUPR(currentdate,itime)
      USE adp_module
!
!-----------------------------------------------------------------------
!
!      PURPOSE:  A DESIRABLE UPPER-AIR SOUNDING HAS BEEN FOUND.
!                UNPACK DATA
!
!-----------------------------------------------------------------------
!
      PARAMETER(IRS=50)
      character(len=19) :: currentdate
!
!-----------------------------------------------------------------------
!
      parameter (maxlev = 500)
      dimension prs(maxlev), hgt(maxlev), temp(maxlev), dwpt(maxlev),&
           wdir(maxlev), spdms(maxlev), PSCR(MAXLEV)
      COMMON/STATION/PRS, HGT, TEMP, DWPT, WDIR, SPDMS
!
!-----------------------------------------------------------------------
!
      LOGICAL ISNDGS
      REAL,DIMENSION(500)::pp,fp,dp,t,z,h,d,f,p,td
      INTEGER,DIMENSION(500)::q

      character csta*6, flnm*4, stnm*3, H4*4
      write(csta, '(A6)') ssta

      PRS = 0.
      HGT = 0.
      TEMP = 0.
      DWPT = 0.
      WDIR = 0.
      SPDMS = 0.
!
!
      ISNDGS = .FALSE.

!     PRINT 150,ISTATN
150   FORMAT(' UPPER AIR STATION REPORT NO.',I4)
!     if (ISTATN.NE.1) write(198+itime-1, '(////)')
!     write(198+itime-1,54) ISTATN, SSTA, currentdate
 54   format('REPORT NUMBER,  STATION ID   DATE  = ', I5,3x, A6, 3x, a)
!     write(*,56) INSTYP
 56   format('Instrument type: ', I5)
!     write(198+itime-1,57) YLAT, YLON, ELEV
 57   format('LAT, LON, Elevation: ', 3f10.3)
      LEVTOT = 0
!
!---------ACCESS MANDATORY LEVEL DATA
!
      CALL MANADP(P,Z,T,H,D,F,Q,numman)
      IF(numman.LE.1) then
!        write(198+itime-1,59) 0
         GO TO 230
      ENDIF
      IF(ISNDGS) THEN
         
         PRINT 180,ISTATN,numman
 180     FORMAT(10X,'MANDATORY LEVEL DATA FOR THE',I3,'-TH STATION ',&
              'FOUND, WHICH HAS',I3,' LEVELS')
         PRINT 190
 190     FORMAT(12x,'LVL',4X,'PRES(MB)',5X,'HGT(M)',6X,'TEMP(C)',3X,&
              'DEW DEPR.(C)',2X,'WIND DIR.(DEG)',2X,'WIND SPD(KT)',3X,&
              'Q(I)')
         DO I=1,numman
            PRINT 210,I,P(I),Z(I),T(I),H(I),D(I),F(I)
 210        FORMAT(9X,I5,5F12.1,6X,F12.1)
 211        FORMAT(9X,I5,F12.1,4(F10.1,1x,A1),F12.1,6X,F12.1)
         ENDDO
      ENDIF
!     write(198+itime-1,59) numman
 59   format(/,' ********  MANDATORY LEVELS = ', I5,/&
           12x,'LVL',4X,'PRES(MB)',5X,'HGT(M)',6X,'TEMP(C)',4X,&
           'DEWPT.(C)',1X,'WIND DIR.(DEG)',5X,'WIND SPD(m/s)')

      do i = 1, numman
         IF (H(I).EQ.999. .or. H(I).EQ.99.9) THEN
            HP = 999.
         ELSE
            HP = T(I) - H(I)
         ENDIF

         IF (F(I).EQ.999.) THEN
            FPRNT = 999.
         ELSE
            FPRNT = F(I)*.51444444444
         ENDIF
         
         write(H4,'(A4)') Q(i)
!        print*, 'Q(I) = ', Q(I)

!        write(198+itime-1,211) I, P(I), Z(I), H4(1:1), T(I), H4(2:2),&
!             HP, H4(3:3), D(I), H4(4:4), FPRNT
 61      format(I5, 10f11.4)

         p(i)=p(i)*100
!        z(i)=z(i)
         if(t(i).lt.99.9) then
            t(i)=t(i)+273.15
         else
            t(i)=999999.0
         endif
         if(hp.lt.998) then
            td(i)=hp+273.15
         else
            td(i)=999999.0
         endif
         if((d(i).lt.361).and.(f(i).lt.998)) then
            f(i)=F(I)*.51444444444
         else
            f(i)=999999.0
            d(i)=999999.0
         endif

      enddo

      if(numman.gt.0) then
         slp=999999.0
         iseq=1
         DO ik = 1, 8
            IF (SSTA (ik:ik) .eq.char (0) ) ssta (ik:ik) = ' '
         enddo
         mdate=mod(iyr,100)*1000000+imo*10000+idy*100+ihr
         CALL conv_adp_r (numman,p,z,t,td,f,d,&
                   slp,ELEV,YLAT,YLON,currentdate,ssta,iseq,itime+20)
      endif


 230  CONTINUE
!
!---------ACCESS SIGNIFICANT LEVEL TEMP. AND MOISTURE DATA;
!

      CALL SIGADP(P,T,H,Q,numtsig)
      IF(numtsig.GE.1) THEN
         IF(ISNDGS)THEN
            PRINT 250,numtsig
 250        FORMAT(1H0,10X,'SIGNIFICANT LEVEL TEMPERATURE AND '//&
                 'MOISTURE DATA',4X,'TOTAL OF',I3,' LEVELS')
            PRINT 260
 260        FORMAT(12x,'LVL',4X,'PRES(MB)',5X,'TEMP(C)',3X,&
                 'DEW DEPR.(C)',4X,'Q(I)')
            DO I=1,numtsig
               PRINT 270,I,P(I),T(I),H(I)
            ENDDO
         ENDIF
!        write (198+itime-1, 58) numtsig
 58      format(/,' ********* SIGNIFICANT LEVEL TEMP. AND DEWPT = ',I5,/&
              12x,'LVL',4X,'PRES(MB)',5X,'TEMP(C)',3X,&
                 'DEWPT.(C)')
         Z = 99999.
         Z(1) = ELEV
         do I = 1, numtsig
            if (H(I).EQ.99.9) THEN
               HPR = 999.
            ELSE
               HPR = T(I) - H(I)
            ENDIF
!           write(198+itime-1,270) I, P(I), T(I), HPR
         enddo
         D = 999.
         F = 999.
      else
!        write (198+itime-1, 58) 0
      ENDIF
!
      do i=1,numtsig
         p(i)=p(i)*100
         if(z(i).gt.99998)then
            z(i)=999999.0
         endif
         if(t(i).lt.99.9) then
            t(i)=t(i)+273.15
         else
            t(i)=999999.0
         endif
         if((t(i).lt.999998).and.(h(i).lt.99.8)) then
            td(i)=t(i)-h(i)
         else
            td(i)=999999.0
         endif
         f(i)=999999.0
         d(i)=999999.0
      enddo

      if(numtsig.gt.0) then
         prs(1)=p(1)
         slp=999999.0
         iseq=1
         DO ik = 1, 8
            IF (SSTA (ik:ik) .eq.char (0) ) ssta (ik:ik) = ' '
         enddo
         mdate=mod(iyr,100)*1000000+imo*10000+idy*100+ihr
         CALL conv_adp_r (numtsig,p,z,t,td,f,d,&
                   slp,ELEV,YLAT,YLON,currentdate,ssta,iseq,itime+20)
      endif
!---------ACCESS SIGNIFICANT LEVEL WIND DATA;
!
         PP=1.E33
         P=1.E33
!
!---------WIND BY PRESSURE LEVELS
!
      CALL WPPADP(PP,DP,FP,Q,numwsig,0)
      IF(numwsig.GE.1) THEN
         IF(ISNDGS) THEN
            PRINT 330,numwsig
 330        FORMAT(10X,'SIGNIFICANT LEVEL WIND DATA',25X,'TOTAL OF',I3,&
                 'LEVELS')
            PRINT 340
 340        FORMAT(12x,'LVL',4X,'PRES(MB)',2X,'WIND DIR.(DEG)',2X,&
                 'WIND SPD(KT)',3X,'Q(I)')
            DO I=1,numwsig
               PRINT 270,I,PP(I),DP(I),FP(I)
            ENDDO
         ENDIF
!        write (198+itime-1, 47) numwsig
 47      format(/,' ********* PRESSURE-LEVEL WINDS = ', i5,/&
              12x,'LVL',4X,'PRES(MB)',2X,'WIND DIR.(DEG)',2X,&
              'WIND SPD(m/s)')
         
         Z = 99999.
         T = 999.
         H = 999.
         IF (PP(1).EQ.PRS(1)) Z(1) = ELEV
         DO I = 1, numwsig
            IF (FP(I).LT.900) THEN
               FPRNT = FP(I)*.5144444444444
            ELSE
               FPRNT = 999.
            ENDIF
!           write(198+itime-1,270) I, PP(I), DP(I), FPRNT
         p(i)=pp(i)*100
         z(i)=999999.0
         t(i)=999999.0
         td(i)=999999.0
         if((dp(i).lt.361).and.(fp(i).lt.998)) then
            f(i)=Fp(I)*.51444444444
            d(i)=dp(I)
         else
            f(i)=999999.0
            d(i)=999999.0
         endif

      enddo

         IF (ABS(P(1)-PRS(1)).lt.1) Z(1) = ELEV
         slp=999999.0
         iseq=1
         DO ik = 1, 8
            IF (SSTA (ik:ik) .eq.char (0) ) ssta (ik:ik) = ' '
         enddo
         mdate=mod(iyr,100)*1000000+imo*10000+idy*100+ihr
         CALL conv_adp_r (numwsig,p,z,t,td,f,d,&
                   slp,ELEV,YLAT,YLON,currentdate,ssta,iseq,itime+20)
      ENDIF
!
!---------WIND BY HEIGHT LEVELS
      CALL WZZADP(Z,D,F,Q,numwsigh,1)
      IF(numwsigh.GE.1) THEN
         IF(ISNDGS) THEN
            PRINT 380,numwsigh
 380        FORMAT(10X,'SIGNIFICANT LEVEL WIND DATA BY HEIGHT',15X,&
                 'TOTAL OF',I3,' LEVELS')
            PRINT 390
 390        FORMAT(12x,'LVL',5X,'HGT(M)',3X,'WIND DIR.(DEG)',2X,&
                 'WIND SPD(KT)',3X,'Q(I)')
            DO I=1,numwsigh
               PRINT 270,I,Z(I),D(I),F(I)
 270           FORMAT(9X,I5,3F12.1)
            ENDDO
         ENDIF
!        write (198+itime-1, 46) numwsigh
 46      format(/' ********* HEIGHT-LEVEL WINDS = ', i5,/&
              12x,'LVL',5X,'HGT(M)',3X,'WIND DIR.(DEG)',2X,&
              'WIND SPD(m/s)')
         DO I = 1, numwsigh
            IF (F(I).LT.900) THEN
               FPRNT = F(I) * .51444444444
            ELSE
               FPRNT = 999.
            ENDIF
!           write(198+itime-1,270) I, Z(I), D(I), FPRNT
         p(i)=999999.0
         t(i)=999999.0
         td(i)=999999.0
         if((d(i).lt.361).and.(f(i).lt.998)) then
            f(i)=F(I)*.51444444444
         else
            f(i)=999999.0
            d(i)=999999.0
         endif

      enddo

         slp=999999.0
         iseq=1
         DO ik = 1, 8
            IF (SSTA (ik:ik) .eq.char (0) ) ssta (ik:ik) = ' '
         enddo
         mdate=mod(iyr,100)*1000000+imo*10000+idy*100+ihr
         CALL conv_adp_r (numwsigh,p,z,t,td,f,d,&
                   slp,ELEV,YLAT,YLON,currentdate,ssta,iseq,itime+20)
         PSCR = 99999.
         T = 999.
         H = 999.

      ENDIF
      RETURN
      END
