#!/bin/csh

#	This shell fetches data from the NCAR MSS system and
#	converts it into a format suitable for the little_r
#	program. 
#
#       Three types of data files are created:
#             obs:DATE             : Upper-air and surface data used as
#                                    input to little_R
#             surface_obs_r:DATE   : Surface data needed for FDDA in lillte_r
#                                    (if no FDDA will be done, these are not
#                                    needed, since they are also contained
#                                    in obs:DATE)
#             upper-air_obs_r:DATE : Upper-air data (this file is contained
#                                    in obs:DATE file, and is not needed for
#                                    input to little_r)
#


set starting_date = 1993031300
set ending_date   = 1993031400

#	The amount of CPU time spent unpacking the entire
#	globe is embarrassing.  As much as possible, restrict the 
#	bounds.

set lon_e         =  180
set lon_w         = -180
set lat_s         =  -90
set lat_n         =   90

set lon_e         =  -40
set lon_w         = -130
set lat_s         =   20
set lat_n         =   70

#set Host = user@local_machine.domain:/usr/tmp

##############################################
#	End of user modification
##############################################

set LETTERS = (A B C D E F G H I J K L M N O P Q R S T U V W X Y Z)

#	Pull ADP surface data from the MSS

pushd adp_sfc
./fetch_adp_sfc.csh $starting_date $ending_date >&! fetch_sfc_print &

#	Build the conversion routine, set the namelist up.

make
m4 -Dxstryy=`echo $starting_date | cut -c1-4`  \
   -Dxstrmm=`echo $starting_date | cut -c5-6`  \
   -Dxstrdd=`echo $starting_date | cut -c7-8`  \
   -Dxstrhh=`echo $starting_date | cut -c9-10` \
   -Dxendyy=`echo $ending_date | cut -c1-4`  \
   -Dxendmm=`echo $ending_date | cut -c5-6`  \
   -Dxenddd=`echo $ending_date | cut -c7-8`  \
   -Dxendhh=`echo $ending_date | cut -c9-10` \
   -Dxloe=$lon_e -Dxlow=$lon_w -Dxlas=$lat_s -Dxlan=$lat_n \
   namelist.template >! namelist.input

#	The msreads are in the background, wait for everyone
#	to catch up.

wait

#	Run the program (convert data to little_r format).
#	At least a single file must exist for input.

if ( ( -e A.1 ) || ( -e B.1 ) || ( -e E.1 ) || ( -e F.1 ) ) then
	( time ./adp_sfc.exe [ABEF].[1-9]* ) >&! adp_sfc_print
endif

#	

set y = `echo $starting_date | cut -c1-4`
set m = `echo $starting_date | cut -c5-6`
set d = `echo $starting_date | cut -c7-8`
set h = `echo $starting_date | cut -c9-10`

if ( -e surface_obs_r:${y}-${m}-${d}_${h} ) then
	if ( -e surface_obs_r.tar ) rm surface_obs_r.tar*
  	( tar -cvf surface_obs_r.tar surface_obs_r* ; gzip surface_obs_r.tar ) &
endif

if ( -e A.1 ) then
   foreach file ( A.[1-9] )
        set num = $file:e
        echo "Save surface data to sfc3hr$LETTERS[${num}] and sfc3hr$LETTERS[${num}] - these files can also be used as input to RAWINS "
        mv A.$num        sfc6hr$LETTERS[${num}]
        mv B.$num        sfc3hr$LETTERS[${num}]
   end
endif
if ( -e E.1 ) then
   foreach file ( E.[1-9] )
        set num = $file:e
        echo "Save surface data to sfc3hr$LETTERS[${num}] and sfc3hr$LETTERS[${num}]   these files can also be used as input to RAWINS "
        mv E.$num        sfc6hr$LETTERS[${num}]
        mv F.$num        sfc3hr$LETTERS[${num}]
   end
endif

popd

#	Pull ADP upper-air data from the MSS

pushd adp_upa
./fetch_adp_upa.csh $starting_date $ending_date >&! fetch_upa_print &

#	Build the conversion routine, set the namelist up.

make
m4 -Dxstryy=`echo $starting_date | cut -c1-4`  \
   -Dxstrmm=`echo $starting_date | cut -c5-6`  \
   -Dxstrdd=`echo $starting_date | cut -c7-8`  \
   -Dxstrhh=`echo $starting_date | cut -c9-10` \
   -Dxendyy=`echo $ending_date | cut -c1-4`  \
   -Dxendmm=`echo $ending_date | cut -c5-6`  \
   -Dxenddd=`echo $ending_date | cut -c7-8`  \
   -Dxendhh=`echo $ending_date | cut -c9-10` \
   -Dxloe=$lon_e -Dxlow=$lon_w -Dxlas=$lat_s -Dxlan=$lat_n \
   namelist.template >! namelist.input

#	The msreads are in the background, wait for everyone
#	to catch up.

wait

#	Run the program (convert data to little_r format).
#	At least a single file must exist for input.

if ( -e UPA.1 ) then
	( time ./adp_upa.exe UPA.* ) >&! adp_upa_print
endif

#	

set y = `echo $starting_date | cut -c1-4`
set m = `echo $starting_date | cut -c5-6`
set d = `echo $starting_date | cut -c7-8`
set h = `echo $starting_date | cut -c9-10`

if ( -e upper-air_obs_r:${y}-${m}-${d}_${h} ) then
        if ( -e upper-air_obs_r.tar ) rm upper-air_obs_r.tar*
        tar -cvf upper-air_obs_r.tar upper-air_obs_r*
        gzip upper-air_obs_r.tar

        if ( -e obs.tar ) rm obs.tar
        if ( -e obs.tar.gz ) rm obs.tar.gz
          foreach fil ( upper-air_obs_r:* )
            set dd = ` echo $fil | cut -c17-30 `
            set fil2 = ../adp_sfc/surface\*{$dd}
            cat $fil > obs:$dd
            cat $fil2 >> obs:$dd
        end
        tar -cvf obs.tar obs*
        gzip obs.tar

endif

if ( -e UPA.1 ) then
   foreach file ( UPA.[1-9] )
        set num = $file:e
        echo "Save upper-air data to raobs$LETTERS[${num}]  - this file can also be used as input to RAWINS "
        mv UPA.$num        raobs$LETTERS[${num}]
   end
endif

popd
