#!/bin/csh

#	This shell converts ADP data (surface/ship and upper air)
#	into a format suitable for the little_r program. 
#       USE THIS ONLY IF YOU HAVE ADP DATA ON YOUR MACHINE
#       THIS SCRIPT WILL NOT DOWNLOAD ADP DATA FOR YOU
#
#       Three types of data files are created:
#             obs:DATE             : Upper-air and surface data used as
#                                    input to little_R
#             surface_obs_r:DATE   : Surface data needed for FDDA in lillte_r
#                                    (if no FDDA will be done, these are not
#                                    needed, since they are also contained
#                                    in obs:DATE)

### DataDir MUST be the ABSOLUTE path to your data directory
set DataDir       =  /usr/$USER                   

### INSFCData is both surface and ship data
set InUpperData   =  ( $DataDir/Y77940.bin )
set InSFCData     =  ( $DataDir/Y77933.bin $DataDir/Y77939.bin )

set starting_date = 2003110100
set ending_date   = 2003110200

#	The amount of CPU time spent unpacking the entire
#	globe is embarrassing.  As much as possible, restrict the 
#	bounds.

set lon_e         =  180
set lon_w         = -180
set lat_s         =  -90
set lat_n         =   90

set lon_e         =  -40
set lon_w         = -130
set lat_s         =   20
set lat_n         =   70

##############################################
#	End of user modification
##############################################

set LETTERS = (A B C D E F G H I J K L M N O P Q R S T U V W X Y Z)

### Do surface data

pushd adp_sfc

#	Build the conversion routine, set the namelist up.

echo "Making code - Surface"

make
m4 -Dxstryy=`echo $starting_date | cut -c1-4`  \
   -Dxstrmm=`echo $starting_date | cut -c5-6`  \
   -Dxstrdd=`echo $starting_date | cut -c7-8`  \
   -Dxstrhh=`echo $starting_date | cut -c9-10` \
   -Dxendyy=`echo $ending_date | cut -c1-4`  \
   -Dxendmm=`echo $ending_date | cut -c5-6`  \
   -Dxenddd=`echo $ending_date | cut -c7-8`  \
   -Dxendhh=`echo $ending_date | cut -c9-10` \
   -Dxloe=$lon_e -Dxlow=$lon_w -Dxlas=$lat_s -Dxlan=$lat_n \
   namelist.template >! namelist.input


#	Run the program (convert data to little_r format).
#	At least a single file must exist for input.

set NUM = 1
foreach fil ( $InSFCData )
   ln -sf  $fil Data.$NUM
   @ NUM ++
   echo Data.$NUM
end

echo "Converting Surface Data"
	( time ./adp_sfc.exe Data.* ) >&! adp_sfc_print

#	

set y = `echo $starting_date | cut -c1-4`
set m = `echo $starting_date | cut -c5-6`
set d = `echo $starting_date | cut -c7-8`
set h = `echo $starting_date | cut -c9-10`

popd


### Do upper_air data

pushd adp_upa

#	Build the conversion routine, set the namelist up.

echo "Making code - Upper-Air"

make
m4 -Dxstryy=`echo $starting_date | cut -c1-4`  \
   -Dxstrmm=`echo $starting_date | cut -c5-6`  \
   -Dxstrdd=`echo $starting_date | cut -c7-8`  \
   -Dxstrhh=`echo $starting_date | cut -c9-10` \
   -Dxendyy=`echo $ending_date | cut -c1-4`  \
   -Dxendmm=`echo $ending_date | cut -c5-6`  \
   -Dxenddd=`echo $ending_date | cut -c7-8`  \
   -Dxendhh=`echo $ending_date | cut -c9-10` \
   -Dxloe=$lon_e -Dxlow=$lon_w -Dxlas=$lat_s -Dxlan=$lat_n \
   namelist.template >! namelist.input

#	Run the program (convert data to little_r format).
#	At least a single file must exist for input.

set NUM = 1
foreach fil ( $InUpperData )
   ln -sf  $fil Data.$NUM
   @ NUM ++
   echo Data.$NUM
end

echo "Converting Upper-Air Data"
	( time ./adp_upa.exe Data.* ) >&! adp_upa_print

#	

set y = `echo $starting_date | cut -c1-4`
set m = `echo $starting_date | cut -c5-6`
set d = `echo $starting_date | cut -c7-8`
set h = `echo $starting_date | cut -c9-10`

if ( -e upper-air_obs_r:${y}-${m}-${d}_${h} ) then

          foreach fil ( upper-air_obs_r:* )
            set dd = ` echo $fil | cut -c17-30 `
            set fil2 = ../adp_sfc/surface\*{$dd}
            cat $fil > obs:$dd
            cat $fil2 >> obs:$dd
          end
          rm -rf upper-air_obs_r:*
endif

popd

mv adp_sfc/surface* .
mv adp_upa/obs:* .

echo "DONE with conversion"
