#!/bin/csh
set echo

#	This shell fetches the required ADP upper-air data from 
#	the NCAR MSS system.  The starting and ending dates 
#	YYYYMMDDHH come in as arguments to this shell.  Users
#	should not need to change this file.

set numbers = ( 1 2 3 4 5 6 7 8 9 10 11 12 )
set numbers0 = ( 01 02 03 04 05 06 07 08 09 10 11 12 )

if ( ${#argv} != 2 ) then
	echo "usage: ${0}:"
	echo "$0 starting_date ending_date"
	echo "where the dates are YYYYMMDDHH"
	exit ( 1 )
endif

if ( $1 > $2 ) then
	echo "usage: ${0}:"
        echo "$0 starting_date ending_date"
        echo "where the dates are YYYYMMDDHH"
	echo "starting_date must be <= ending_date"
	exit ( 2 )
endif

if ( ( $1 < 1900000000 ) || ( $2 < 1900000000 ) ) then
	echo "usage: ${0}:"
        echo "$0 starting_date ending_date"
        echo "where the dates are YYYYMMDDHH"
	exit ( 3 )
endif

if ( ( $1 > 2100000000 ) || ( $2 > 2100000000 ) ) then
	echo "usage: ${0}:"
        echo "$0 starting_date ending_date"
        echo "where the dates are YYYYMMDDHH"
	exit ( 4 )
endif

set start_date = $1
set end_date   = $2

set start_year = `echo ${start_date} | cut -c1-4`
set start_month = `echo ${start_date} | cut -c5-6`
        set start_month = $numbers[$start_month]
set start_day = `echo ${start_date} | cut -c7-8`
set start_hour = `echo ${start_date} | cut -c9-10`

set end_year = `echo ${end_date} | cut -c1-4`
set end_month = `echo ${end_date} | cut -c5-6`
        set end_month = $numbers[$end_month]
set end_day = `echo ${end_date} | cut -c7-8`
set end_hour = `echo ${end_date} | cut -c9-10`

# Set up the ftp command-script to get the archive lists.  First, set 
# up to login anonymously to ncardata.ucar.edu

cat >! ftp.cmd << EOF1
open roy-s
user anonymous@ncardata.ucar.edu ${user}@ucar.edu
get datasets/ds353.4/MSS-file-list catalog.raob
quit
EOF1

# Now invoke ftp to get the archive lists.

if ( ! -e ncep.master ) then
   ftp -n < ftp.cmd
   rm ftp.cmd
endif

set month = ( jan feb mar apr may jun jul aug sep oct nov dec )

set file_names = ( ` grep ${start_year}$month[$start_month] catalog.raob | grep "LIST A" | grep blks | cut -d" " -f2 ` )
set file_start = ( ` grep ${start_year}$month[$start_month] catalog.raob | grep "LIST A" | grep blks | awk -F, '{ print $1 }' | awk -F" " '{ print $2 }' | awk -F- '{ print $1 }' ` )
set file_end   = ( ` grep ${start_year}$month[$start_month] catalog.raob | grep "LIST A" | grep blks | awk -F, '{ print $1 }' | awk -F- '{ print $2 }' ` )

if ( ( $start_year != $end_year ) || ( $start_month != $end_month ) ) then

	if ( $start_month != 12 ) then
		set y = $start_year
	else
		@ y = $start_year + 1
	endif

	while ( $y <= $end_year )
		if ( $y == $start_year ) then
			@ m = $start_month + 1
		else
			set m = 1
		endif
		if ( $y != $end_year ) then
			set em = 12
		else
			set em = $end_month
		endif
		while ( $m <= $em ) 
			set file_names = ( $file_names ` grep ${y}$month[$m] catalog.raob | \\
				grep "LIST A" | grep blks | cut -d" " -f2 ` )
			set file_start = ( $file_start ` grep ${y}$month[$m] catalog.raob | \\
				grep "LIST A" | grep blks | awk -F, '{ print $1 }' | awk -F" " '{ print $2 }' | awk -F- '{ print $1 }' ` )
			set file_end   = ( $file_end ` grep ${y}$month[$m] catalog.raob | \\
				grep "LIST A" | grep blks | awk -F, '{ print $1 }' | awk -F- '{ print $2 }' ` )
			@ m ++
		end
		@ y ++
	end
endif

set count = ${#file_start}
set file_start_b = ( $file_start )
foreach f ( $file_start )
	set file_start_b[$count] = $f
	@ count --
end

#	Find the first of the DATA files that is needed.

set start_count = 0
set start_found_flag = FALSE
foreach n ( $file_end )

	@ start_count ++

	set test_date = ${start_year}$numbers0[${start_month}]${start_day}

	if ( -e data_tmp ) rm data_tmp
	echo "$test_date" > data_tmp
	echo "$n" >> data_tmp

	cat >! ed_input << EOF
		r data_tmp
		g/jan/s//01/
		g/feb/s//02/
		g/mar/s//03/
		g/apr/s//04/
		g/may/s//05/
		g/jun/s//06/
		g/jul/s//07/
		g/aug/s//08/
		g/sep/s//09/
		g/oct/s//10/
		g/nov/s//11/
		g/dec/s//12/
		1,2w
		q
EOF
	ed < ed_input >& /dev/null

	if ( `cat data_tmp | sort | head -1` == $test_date ) then
		set start_found_flag = TRUE
		goto start_found
	endif

end

echo Never found the starting RAOB file successfully.
set start_count = 100

start_found:

if ( $start_found_flag == TRUE ) then 
	echo Found starting RAOB file: $file_names[$start_count]
endif

#	Find the last of the DATA files that is needed.

set end_count = 0
set end_found_flag = FALSE
foreach n ( $file_start_b )

	@ end_count ++

	set test_date = ${end_year}$numbers0[${end_month}]${end_day}

	if ( -e data_tmp ) rm data_tmp
	echo "$test_date" > data_tmp
	echo "$n" >> data_tmp

	cat >! ed_input << EOF
		r data_tmp
		g/jan/s//01/
		g/feb/s//02/
		g/mar/s//03/
		g/apr/s//04/
		g/may/s//05/
		g/jun/s//06/
		g/jul/s//07/
		g/aug/s//08/
		g/sep/s//09/
		g/oct/s//10/
		g/nov/s//11/
		g/dec/s//12/
		1,2w
		q
EOF
	ed < ed_input >& /dev/null

	if ( `cat data_tmp | sort -r | head -1` == $test_date ) then
		@ end_count = ${#file_start_b} + 1 - $end_count
		set end_found_flag = TRUE
		goto end_found
	endif


end

echo Never found the ending RAOB file successfully.
set end_count = 0

end_found:

if ( $end_found_flag == TRUE ) then
	echo Found ending RAOB file: $file_names[$end_count]
endif

set count = 0
set incr  = 0
foreach f ( $file_names )
	@ count ++
	if ( ( $count >= $start_count ) && ( $count <= $end_count ) ) then
		if ( $count > 1 ) then
			@ prev = $count - 1
			if ( $f != $file_names[$prev] ) then
				@ incr ++
				msread -fBI UPA.$incr /DSS/$f &
			endif
		else
			@ incr ++
			msread -fBI UPA.$incr /DSS/$f &
		endif
	endif
end

wait
rm data_tmp catalog.raob ed_input
