#!/bin/csh -f

#       this is INTERACTIVE or BATCH

if ( $?ENVIRONMENT ) then
   echo "environment variable defined as $ENVIRONMENT"
else
   setenv ENVIRONMENT INTERACTIVE
   echo "environment variable defined as $ENVIRONMENT"
endif

#       initializations, no user modification required

set FILE_EXT = ( 00 01 02 03 04 05 06 07 08 09 \
                 10 11 12 13 14 15 16 17 18 19 \
                 20 21 22 23 24 25 26 27 28 29 \
                 30 31 32 33 34 35 36 37 38 39 \
                 40 41 42 43 44 45 46 47 48 49 \
                 50 51 52 53 54 55 56 57 58 59 \
                 60 61 62 63 64 65 66 67 68 69 )

#       is it color

# set Color = BW
set Color = CO

#	If this is an HP-UX machine, the generic name for fortran files
#	starts with "ftn" not "fort".

model >& /dev/null
set OK = $status
if ( $OK == 0 ) then
	set ForUnit = ftn
#       echo "This is an HP-UX"
else
	set ForUnit = fort.
#       echo "This is not an HP-UX"
endif

if ( -e numsplit.tbl ) rm numsplit.tbl
if ( -e med.input ) rm med.input
if ( ( `uname` == AIX ) || ( `uname` == SunOS ) || ( `uname` == HP-UX ) ) then
   if ( -e ${ForUnit}20 ) rm ${ForUnit}2*
   if ( -e ${ForUnit}30 ) rm ${ForUnit}3*
   if ( -e ${ForUnit}40 ) rm ${ForUnit}4*
   if ( -e ${ForUnit}50 ) rm ${ForUnit}5*
   if ( -e ${ForUnit}60 ) rm ${ForUnit}6*
   if ( -e ${ForUnit}70 ) rm ${ForUnit}7*
   if ( -e ${ForUnit}80 ) rm ${ForUnit}8*
else
   if ( ( -e ${ForUnit}20 ) || ( -l ${ForUnit}20 ) ) rm ${ForUnit}2*
   if ( ( -e ${ForUnit}30 ) || ( -l ${ForUnit}30 ) ) rm ${ForUnit}3*
   if ( ( -e ${ForUnit}40 ) || ( -l ${ForUnit}40 ) ) rm ${ForUnit}4*
   if ( ( -e ${ForUnit}50 ) || ( -l ${ForUnit}50 ) ) rm ${ForUnit}5*
   if ( ( -e ${ForUnit}60 ) || ( -l ${ForUnit}60 ) ) rm ${ForUnit}6*
   if ( ( -e ${ForUnit}70 ) || ( -l ${ForUnit}70 ) ) rm ${ForUnit}7*
   if ( ( -e ${ForUnit}80 ) || ( -l ${ForUnit}80 ) ) rm ${ForUnit}8*
endif

#       simple error check on call

if (( $#argv == 0 ) && ( $ENVIRONMENT == INTERACTIVE )) then
   echo -n "into how many pieces is the metafile to be split (1) "
   set NumSplit = "$<"
   echo -n "how many input files are there                   (1) "
   set TotFiles = "$<"
   echo -n "what is the name of the file         (MMOUT_DOMAIN1) "
   set FileName = "$<"
else if ( $#argv < 3 ) then
   echo "graph.deck:  error in call"
   echo "usage:  graph.deck ns nf filename [filename2 filename3 ...]"
   echo "      where ns is the number of files into which metacode is split"
   echo "      where nf is the number of input files"
   echo "      where filename is either the root name, or several names"
   exit (1)
else if ( $#argv == 3 ) then
   set NumSplit = $1
   set TotFiles = $2
   set FileName = $3 
else if ( $#argv >  3 ) then
   set NumSplit = $1
   set TotFiles = $2
endif

#       consistency checks on input

if (( $NumSplit < 1 ) || ( $NumSplit > 99 )) then
   set NumSplit = 1
endif
cat >! numsplit.tbl << EOF
$NumSplit 
EOF
if (( $TotFiles < 1 ) || ( $TotFiles > 69 )) then
   set TotFiles = 1
endif
if ( $#argv == 0 ) then
   if (( ! -e $FileName ) && ( ! -e ${FileName}_00 )) then
      echo "file $FileName does not exist"
      exit (2)
   endif
else if ( $#argv >=  3 ) then
   if (( ! -e $argv[3] ) && ( ! -e $argv[3]_00 ) ) then
      echo "file $argv[3] does not exist"
      exit (3)
   endif
endif

if ( ! -e graph.exe ) ln -s src/graph.exe graph.exe
chmod +x graph.exe

#       make sure we have all the required tables

if ( -e g_map.tbl ) then
   echo "using local copy of g_map.tbl"
else
   echo "need a copy of g_map.tbl"
   exit (4)
endif

if ( -e g_color.tbl ) then
   echo "using local copy of g_color.tbl"
else
   echo "need a copy of g_color.tbl"
   exit (5)
endif

if ( -e g_plots.tbl ) then
   echo "using local copy of g_plots.tbl"
else
   echo "need a copy of g_plots.tbl"
   exit (6)
endif

if ( -e g_defaults.nml ) then
   echo "using local copy of g_defaults.nml"
else
   echo "need a copy of g_defaults.nml"
   exit (7)
endif

#       run graph program

if ( ( `uname` == AIX ) || ( `uname` == SunOS ) || ( `uname` == HP-UX ) ) then
   if ( -e ${ForUnit}18 ) rm ${ForUnit}18
else
   if ( ( -e ${ForUnit}18 ) || ( -l ${ForUnit}18 ) ) rm ${ForUnit}18
endif
ln -s     g_plots.tbl                  ${ForUnit}18
if ( -e .assign ) rm .assign
if ((( $TotFiles == 1 ) && ( $#argv == 3 )) || \
    (( $TotFiles >  1 ) && ( $#argv >  3 ))) then
   shift
   shift
   set NUMFIL = 1
   while ( $#argv ) 
      @ UNIT = 19 + $NUMFIL
      ln -s     $argv[1]               ${ForUnit}$UNIT
#     assign -a $argv[1] -Ff77 -Nieee  ${ForUnit}$UNIT
      shift
      @ NUMFIL ++
   end
else if ( (( $TotFiles > 1 ) && ( $#argv == 3 )) || ( $#argv == 0 ) ) then
   if ( ( `uname` == AIX ) || ( `uname` == SunOS ) || ( `uname` == HP-UX ) ) then
      set AIX = true
   else
      set AIX = false
   endif
   set NUMFIL = 1
   while ( $NUMFIL <= $TotFiles ) 
      @ UNIT = 19 + $NUMFIL
      if ( $AIX == true ) then
         if ( ( $NUMFIL == 1 ) && ( -e $FileName ) ) then
            ln -s     $FileName                                   ${ForUnit}$UNIT
#           assign -a $FileName                      -Ff77 -Nieee ${ForUnit}$UNIT
            @ NUMFIL ++
         else if ( ( $NUMFIL == 1 ) && ( -e ${FileName}_00 ) ) then
            ln -s     ${FileName}_$FILE_EXT[${NUMFIL}]              ${ForUnit}$UNIT
#           assign -a ${FileName}_$FILE_EXT[${NUMFIL}] -Ff77 -Nieee ${ForUnit}$UNIT
            @ NUMFIL ++
         else
            ln -s     ${FileName}_$FILE_EXT[${NUMFIL}]              ${ForUnit}$UNIT
#           assign -a ${FileName}_$FILE_EXT[${NUMFIL}] -Ff77 -Nieee ${ForUnit}$UNIT
            @ NUMFIL ++
         endif
      else if ( $AIX == false ) then
         if ( ( $NUMFIL == 1 ) && ( ( -e $FileName ) || ( -l $FileName ) ) ) then
            ln -s     $FileName                                   ${ForUnit}$UNIT
#           assign -a $FileName                      -Ff77 -Nieee ${ForUnit}$UNIT
            @ NUMFIL ++
         else if ( ( $NUMFIL == 1 ) && ( ( -e ${FileName}_00 ) || ( -l ${FileName}_00 ) ) ) then
            ln -s     ${FileName}_$FILE_EXT[${NUMFIL}]              ${ForUnit}$UNIT
#           assign -a ${FileName}_$FILE_EXT[${NUMFIL}] -Ff77 -Nieee ${ForUnit}$UNIT
            @ NUMFIL ++
         else
            ln -s     ${FileName}_$FILE_EXT[${NUMFIL}]              ${ForUnit}$UNIT
#           assign -a ${FileName}_$FILE_EXT[${NUMFIL}] -Ff77 -Nieee ${ForUnit}$UNIT
            @ NUMFIL ++
         endif
      endif
   end
endif

#       run graph program

graph.exe

#       split metacode apart

if      ( $NumSplit != 1 ) then 
   cat med.input
   med -f med.input
else if ( $NumSplit == 1 ) then
#  cat med.input
#  cp gmeta gmeta.split1
endif

rm med.input numsplit.tbl
rm tmp.*
echo "GRAPH run complete"
