      SUBROUTINE ADVEC(U,V,DMF,XMF,Q,I1,J1,K1,DS,OUT)                            ADVEC.1
C                                                                                ADVEC.2
C COMPUTES ADVECTION OF A SCALAR. ON INPUT, OUT CONTAINS                         ADVEC.3
C THE SCALAR TO BE ADVECTED AND ON OUTPUT IT CONTAINS THE                        ADVEC.4
C ADVECTION                                                                      ADVEC.5
C                                                                                ADVEC.6
      DIMENSION U(I1,J1,K1), V(I1,J1,K1), OUT(I1,J1,K1),                         ADVEC.7
     &  XMF(I1,J1), DMF(I1,J1), Q(I1,J1)                                         ADVEC.8
C                                                                                ADVEC.9
      IF (DS .LT. 1000.) THEN                                                    ADVEC.10
         DS2R = 1./(2.*DS*1000.)                                                 ADVEC.11
      ELSE                                                                       ADVEC.12
         DS2R = 1./(2.*DS)                                                       ADVEC.13
      ENDIF                                                                      ADVEC.14
C                                                                                ADVEC.15
      DO 200 K = 1, K1                                                           ADVEC.16
         DO 90 J = 1, J1-1                                                       ADVEC.17
         DO 90 I = 1, I1-1                                                       ADVEC.18
            Q(I,J)=OUT(I,J,K)                                                    ADVEC.19
90       CONTINUE                                                                ADVEC.20
         DO 100 J = 2, J1-2                                                      ADVEC.21
         DO 100 I = 2, I1-2                                                      ADVEC.22
            U1=U(I  ,J  ,K)/DMF(I  ,J  )                                         ADVEC.23
            U2=U(I+1,J  ,K)/DMF(I+1,J  )                                         ADVEC.24
            U3=U(I  ,J+1,K)/DMF(I  ,J+1)                                         ADVEC.25
            U4=U(I+1,J+1,K)/DMF(I+1,J+1)                                         ADVEC.26
            V1=V(I  ,J  ,K)/DMF(I  ,J  )                                         ADVEC.27
            V2=V(I+1,J  ,K)/DMF(I+1,J  )                                         ADVEC.28
            V3=V(I  ,J+1,K)/DMF(I  ,J+1)                                         ADVEC.29
            V4=V(I+1,J+1,K)/DMF(I+1,J+1)                                         ADVEC.30
            DQDX = (Q(I,J+1) - Q(I,J-1)) * DS2R                                  ADVEC.31
            DQDY = (Q(I+1,J) - Q(I-1,J)) * DS2R                                  ADVEC.32
            OUT(I,J,K) = -1.*XMF(I,J)*XMF(I,J)*0.25*                             ADVEC.33
     &          ((U1+U2+U3+U4)*DQDX + (V1+V2+V3+V4)*DQDY)                        ADVEC.34
100      CONTINUE                                                                ADVEC.35
200   CONTINUE                                                                   ADVEC.36
      CALL FILLIT(OUT,I1,J1,K1,I1,J1,2,I1-2,2,J1-2)                              ADVEC.37
      RETURN                                                                     ADVEC.38
      END                                                                        ADVEC.39
                                                                                 ADVEC.40
