         SUBROUTINE CLOUDF (RH, I1, J1, K1, SIGMA, PTOP, KS, LEV, CLDF)          CLOUDF.1
C CALCULATE THE CLOUD FRACTION (IN %) AS IN THE MM4 MODEL (ASSUME IT'S           CLOUDF.2
C ONLY CALLED FROM DIAGSIG.)                                                     CLOUDF.3
         DIMENSION RH(I1,J1,K1), CLDF(I1,J1), SIGMA(KS)                          CLOUDF.4
         CLOBOT = 970.                                                           CLOUDF.5
         CMDBOT = 800.                                                           CLOUDF.6
         CHIBOT = 450.                                                           CLOUDF.7
         DO 160 K = 1, KS                                                        CLOUDF.8
           PK = SIGMA(K)*(1000.-PTOP)+PTOP                                       CLOUDF.9
           IF (PK .GT. CLOBOT) GO TO 160                                         CLOUDF.10
           KCLO = K                                                              CLOUDF.11
           IF (PK .GT. CMDBOT) GO TO 160                                         CLOUDF.12
           KCMD = K                                                              CLOUDF.13
           IF (PK .GT. CHIBOT) GO TO 160                                         CLOUDF.14
           KCHI = K                                                              CLOUDF.15
  160   CONTINUE                                                                 CLOUDF.16
C        WRITE(6,*) 'KCLO = ',KCLO                                               CLOUDF.17
C        WRITE(6,*) 'KCMD = ',KCMD                                               CLOUDF.18
C        WRITE(6,*) 'KCHI = ',KCHI                                               CLOUDF.19
C        WRITE(6,*) 'I1 = ',I1,' J1 = ',J1,' K1 = ',K1,' KS = ',KS               CLOUDF.20
C        WRITE(6,*) 'PTOP = ',PTOP,' LEV = ',LEV                                 CLOUDF.21
C GET THE MAX RH WITHIN THE CORRECT CLOUD LAYER                                  CLOUDF.22
      IF (LEV .EQ. 3) THEN                                                       CLOUDF.23
        KL = KCMD + 1                                                            CLOUDF.24
        KU = KCLO                                                                CLOUDF.25
      ELSE IF (LEV .EQ. 2) THEN                                                  CLOUDF.26
        KL = KCHI + 1                                                            CLOUDF.27
        KU = KCMD                                                                CLOUDF.28
      ELSE                                                                       CLOUDF.29
        KL = 1                                                                   CLOUDF.30
        KU = KCHI                                                                CLOUDF.31
      ENDIF                                                                      CLOUDF.32
C      WRITE(6,*) 'KL = ',KL,' KU = ',KU                                         CLOUDF.33
      DO 20 J = 1, J1-1                                                          CLOUDF.34
      DO 20 I = 1, I1-1                                                          CLOUDF.35
        CLDF(I,J) = 0.                                                           CLOUDF.36
        XRH = 0.                                                                 CLOUDF.37
        XD = 0.                                                                  CLOUDF.38
        DO 15 K = KL, KU                                                         CLOUDF.39
          CLDF(I,J) = AMAX1(RH(I,J,K), CLDF(I,J))                                CLOUDF.40
   15   CONTINUE                                                                 CLOUDF.41
   20 CONTINUE                                                                   CLOUDF.42
C NOW COMPUTE THE APPROPRIATE CLOUD FRACTION BASED ON THE MAX RH                 CLOUDF.43
      IF (LEV .EQ. 1) THEN                                                       CLOUDF.44
        A = 2.5                                                                  CLOUDF.45
        B = 1.5                                                                  CLOUDF.46
      ELSE                                                                       CLOUDF.47
        A = 4.                                                                   CLOUDF.48
        B = 3.                                                                   CLOUDF.49
      ENDIF                                                                      CLOUDF.50
      DO 30 J = 1, J1-1                                                          CLOUDF.51
        DO 30 I = 1, I1-1                                                        CLOUDF.52
          CLDF(I,J) = A * CLDF(I,J) - B                                          CLOUDF.53
          CLDF(I,J) = AMIN1(CLDF(I,J), 1.0)                                      CLOUDF.54
          CLDF(I,J) = AMAX1(CLDF(I,J), 0.0)                                      CLOUDF.55
          CLDF(I,J) = CLDF(I,J) * 100.                                           CLOUDF.56
   30 CONTINUE                                                                   CLOUDF.57
C        WRITE(6,*) 'CLDF(20,20) = ',CLDF(20,20)                                 CLOUDF.58
C        WRITE(6,*) 'CLDF(30,30) = ',CLDF(30,30)                                 CLOUDF.59
      RETURN                                                                     CLOUDF.60
      END                                                                        CLOUDF.61
                                                                                 CLOUDF.62
