C                                                                                CONREC.1
C	... THIS VERSION OF CONREC WAS OBTAINED 3 DEC 92                               CONREC.2
C	     IT IS MODIFIED TO ALLOW 100 CONTOUR LEVELS                                CONREC.3
C	     DAVE GILL                                                                 CONREC.4
C                                                                                CONREC.5
      SUBROUTINE CONREC (Z,L,M,N,FLO,HI,FINC,NSET,NHI,NDOT)                      CONREC.6
C                                                                                CONREC.7
C     DIMENSION OF           Z(L,N)                                              CONREC.8
C     ARGUMENTS                                                                  CONREC.9
C                                                                                CONREC.10
C     PURPOSE                CONREC DRAWS A CONTOUR MAP FROM DATA STORED         CONREC.11
C                            IN A RECTANGULAR ARRAY, LABELING THE LINES.         CONREC.12
C                                                                                CONREC.13
C     USAGE                  IF THE FOLLOWING ASSUMPTIONS ARE MET, USE           CONREC.14
C                                                                                CONREC.15
C                              CALL EZCNTR (Z,M,N)                               CONREC.16
C                                                                                CONREC.17
C                              ASSUMPTIONS:                                      CONREC.18
C                                  --ALL OF THE ARRAY IS TO BE CONTOURED.        CONREC.19
C                                  --CONTOUR LEVELS ARE PICKED                   CONREC.20
C                                    INTERNALLY.                                 CONREC.21
C                                  --CONTOURING ROUTINE PICKS SCALE              CONREC.22
C                                    FACTORS.                                    CONREC.23
C                                  --HIGHS AND LOWS ARE MARKED.                  CONREC.24
C                                  --NEGATIVE LINES ARE DRAWN WITH A             CONREC.25
C                                    DASHED LINE PATTERN.                        CONREC.26
C                                  --EZCNTR CALLS FRAME AFTER DRAWING THE        CONREC.27
C                                    CONTOUR MAP.                                CONREC.28
C                                                                                CONREC.29
C                            IF THESE ASSUMPTIONS ARE NOT MET, USE               CONREC.30
C                                                                                CONREC.31
C                              CALL CONREC (Z,L,M,N,FLO,HI,FINC,NSET,            CONREC.32
C                                           NHI,NDOT)                            CONREC.33
C                                                                                CONREC.34
C     ARGUMENTS                                                                  CONREC.35
C                                                                                CONREC.36
C     ON INPUT               Z                                                   CONREC.37
C     FOR EZCNTR               M BY N ARRAY TO BE CONTOURED.                     CONREC.38
C                                                                                CONREC.39
C                            M                                                   CONREC.40
C                              FIRST DIMENSION OF Z.                             CONREC.41
C                                                                                CONREC.42
C                            N                                                   CONREC.43
C                              SECOND DIMENSION OF Z.                            CONREC.44
C                                                                                CONREC.45
C     ON OUTPUT              ALL ARGUMENTS ARE UNCHANGED.                        CONREC.46
C     FOR EZCNTR                                                                 CONREC.47
C                                                                                CONREC.48
C     ON INPUT               Z                                                   CONREC.49
C     FOR CONREC               THE (ORIGIN OF THE) ARRAY TO BE                   CONREC.50
C                              CONTOURED.  Z IS DIMENSIONED L BY N.              CONREC.51
C                                                                                CONREC.52
C                            L                                                   CONREC.53
C                              THE FIRST DIMENSION OF Z IN THE CALLING           CONREC.54
C                              PROGRAM.                                          CONREC.55
C                                                                                CONREC.56
C                            M                                                   CONREC.57
C                              THE NUMBER OF DATA VALUES TO BE CONTOURED         CONREC.58
C                              IN THE X-DIRECTION (THE FIRST SUBSCRIPT           CONREC.59
C                              DIRECTION).  WHEN PLOTTING AN ENTIRE              CONREC.60
C                              ARRAY, L = M.                                     CONREC.61
C                                                                                CONREC.62
C                            N                                                   CONREC.63
C                              THE NUMBER OF DATA VALUES TO BE CONTOURED         CONREC.64
C                              IN THE Y-DIRECTION (THE SECOND SUBSCRIPT          CONREC.65
C                              DIRECTION).                                       CONREC.66
C                                                                                CONREC.67
C                            FLO                                                 CONREC.68
C                              THE VALUE OF THE LOWEST CONTOUR LEVEL.            CONREC.69
C                              IF FLO = HI = 0., A VALUE ROUNDED UP FROM         CONREC.70
C                              THE MINIMUM Z IS GENERATED BY CONREC.             CONREC.71
C                                                                                CONREC.72
C                            HI                                                  CONREC.73
C                              THE VALUE OF THE HIGHEST CONTOUR LEVEL.           CONREC.74
C                              IF HI = FLO = 0., A VALUE ROUNDED DOWN            CONREC.75
C                              FROM THE MAXIMUM Z IS GENERATED BY                CONREC.76
C                              CONREC.                                           CONREC.77
C                                                                                CONREC.78
C                            FINC                                                CONREC.79
C                              > 0  INCREMENT BETWEEN CONTOUR LEVELS.            CONREC.80
C                              = 0  A VALUE, WHICH PRODUCES BETWEEN 10           CONREC.81
C                                   AND 30 CONTOUR LEVELS AT NICE VALUES,        CONREC.82
C                                   IS GENERATED BY CONREC.                      CONREC.83
C                              < 0  THE NUMBER OF LEVELS GENERATED BY            CONREC.84
C                                   CONREC IS ABS(FINC).                         CONREC.85
C                                                                                CONREC.86
C                            NSET                                                CONREC.87
C                              FLAG TO CONTROL SCALING.                          CONREC.88
C                              = 0  CONREC AUTOMATICALLY SETS THE                CONREC.89
C                                   WINDOW AND VIEWPORT TO PROPERLY              CONREC.90
C                                   SCALE THE FRAME TO THE STANDARD              CONREC.91
C                                   CONFIGURATION.                               CONREC.92
C                                   THE GRIDAL ENTRY PERIM IS                    CONREC.93
C                                   CALLED AND TICK MARKS ARE PLACED             CONREC.94
C                                   CORRESPONDING TO THE DATA POINTS.            CONREC.95
C                              > 0  CONREC ASSUMES THAT THE USER                 CONREC.96
C                                   HAS SET THE WINDOW AND VIEWPORT              CONREC.97
C                                   IN SUCH A WAY AS TO PROPERLY                 CONREC.98
C                                   SCALE THE PLOTTING                           CONREC.99
C                                   INSTRUCTIONS GENERATED BY CONREC.            CONREC.100
C                                   PERIM IS NOT CALLED.                         CONREC.101
C                              < 0  CONREC GENERATES COORDINATES SO AS           CONREC.102
C                                   TO PLACE THE (UNTRANSFORMED) CONTOUR         CONREC.103
C                                   PLOT WITHIN THE LIMITS OF THE                CONREC.104
C                                   USER'S CURRENT WINDOW AND                    CONREC.105
C                                   VIEWPORT.  PERIM IS NOT CALLED.              CONREC.106
C                                                                                CONREC.107
C                            NHI                                                 CONREC.108
C                              FLAG TO CONTROL EXTRA INFORMATION ON THE          CONREC.109
C                              CONTOUR PLOT.                                     CONREC.110
C                              = 0  HIGHS AND LOWS ARE MARKED WITH AN H          CONREC.111
C                                   OR L AS APPROPRIATE, AND THE VALUE           CONREC.112
C                                   OF THE HIGH OR LOW IS PLOTTED UNDER          CONREC.113
C                                   THE SYMBOL.                                  CONREC.114
C                              > 0  THE DATA VALUES ARE PLOTTED AT               CONREC.115
C                                   EACH Z POINT, WITH THE CENTER OF             CONREC.116
C                                   THE STRING INDICATING THE DATA               CONREC.117
C                                   POINT LOCATION.                              CONREC.118
C                              < 0  NEITHER OF THE ABOVE.                        CONREC.119
C                                                                                CONREC.120
C                            NDOT                                                CONREC.121
C                              A 10-BIT CONSTANT DESIGNATING THE DESIRED         CONREC.122
C                              DASHED LINE PATTERN.                              CONREC.123
C                              IF ABS(NDOT) = 0, 1, OR 1023, SOLID LINES         CONREC.124
C                              ARE DRAWN.                                        CONREC.125
C                              > 0 NDOT PATTERN IS USED FOR ALL LINES.           CONREC.126
C                              < 0 ABS(NDOT) PATTERN IS USED FOR NEGA-           CONREC.127
C                                TIVE-VALUED CONTOUR LINES, AND SOLID IS         CONREC.128
C                                USED FOR POSITIVE-VALUED CONTOURS.              CONREC.129
C                                CONREC CONVERTS NDOT                            CONREC.130
C                                TO A 16-BIT PATTERN AND DASHDB IS USED.         CONREC.131
C                                SEE DASHDB COMMENTS IN THE DASHLINE             CONREC.132
C                                DOCUMENTATION FOR DETAILS.                      CONREC.133
C                                                                                CONREC.134
C                                                                                CONREC.135
C                                                                                CONREC.136
C     ON OUTPUT              ALL ARGUMENTS ARE UNCHANGED.                        CONREC.137
C     FOR CONREC                                                                 CONREC.138
C                                                                                CONREC.139
C                                                                                CONREC.140
C     ENTRY POINTS           CONREC, CLGEN, REORD, STLINE, CRDRLN,               CONREC.141
C                            MINMAX, PNTVAL, CALCNT, EZCNTR, CONBD               CONREC.142
C                                                                                CONREC.143
C     COMMON BLOCKS          INTPR, RECINT, CONRE1, CONRE2, CONRE3,              CONREC.144
C                            CONRE4,CONRE5                                       CONREC.145
C                                                                                CONREC.146
C     REQUIRED LIBRARY       STANDARD VERSION: DASHCHAR, WHICH AT                CONREC.147
C     ROUTINES               NCAR IS LOADED BY DEFAULT.                          CONREC.148
C                            SMOOTH VERSION: DASHSMTH WHICH MUST BE              CONREC.149
C                            REQUESTED AT NCAR.                                  CONREC.150
C                            BOTH VERSIONS REQUIRE  GRIDAL, THE                  CONREC.151
C                            ERPRT77 PACKAGE, AND THE SPPS.                      CONREC.152
C                                                                                CONREC.153
C     REQUIRED GKS LEVEL     0A                                                  CONREC.154
C                                                                                CONREC.155
C     I/O                    PLOTS CONTOUR MAP.                                  CONREC.156
C                                                                                CONREC.157
C     PRECISION              SINGLE                                              CONREC.158
C                                                                                CONREC.159
C     LANGUAGE               FORTRAN 77                                          CONREC.160
C                                                                                CONREC.161
C     HISTORY                REPLACES OLD CONTOURING PACKAGE CALLED              CONREC.162
C                            CALCNT AT NCAR.                                     CONREC.163
C                                                                                CONREC.164
C     ALGORITHM              EACH LINE IS FOLLOWED TO COMPLETION.  POINTS        CONREC.165
C                            ALONG A LINE ARE FOUND ON BOUNDARIES OF THE         CONREC.166
C                            (RECTANGULAR) CELLS. THESE POINTS ARE               CONREC.167
C                            CONNECTED BY LINE SEGMENTS USING THE                CONREC.168
C                            SOFTWARE DASHED LINE PACKAGE, DASHCHAR.             CONREC.169
C                            DASHCHAR IS ALSO USED TO LABEL THE                  CONREC.170
C                            LINES.                                              CONREC.171
C                                                                                CONREC.172
C     NOTE                   TO DRAW NON-UNIFORM CONTOUR LEVELS, SEE             CONREC.173
C                            THE COMMENTS IN CLGEN.  TO MAKE SPECIAL             CONREC.174
C                            MODIFICATIONS FOR SPECIFIC NEEDS SEE THE            CONREC.175
C                            EXPLANATION OF THE INTERNAL PARAMETERS              CONREC.176
C                            BELOW.                                              CONREC.177
C                                                                                CONREC.178
C     TIMING                 VARIES WIDELY WITH SIZE AND SMOOTHNESS OF           CONREC.179
C                            Z.                                                  CONREC.180
C                                                                                CONREC.181
C     INTERNAL PARAMETERS    NAME   DEFAULT         FUNCTION                     CONREC.182
C                            ----   -------         --------                     CONREC.183
C                                                                                CONREC.184
C                            ISIZEL   1      SIZE OF LINE LABELS,                CONREC.185
C                                            AS PER THE SIZE DEFINITIONS         CONREC.186
C                                            GIVEN IN THE SPPS                   CONREC.187
C                                            DOCUMENTATION FOR WTSTR.            CONREC.188
C                                                                                CONREC.189
C                            ISIZEM   2      SIZE OF LABELS FOR MINIMUMS         CONREC.190
C                                            AND MAXIMUMS,                       CONREC.191
C                                            AS PER THE SIZE DEFINITIONS         CONREC.192
C                                            GIVEN IN THE SPPS                   CONREC.193
C                                            DOCUMENTATION FOR WTSTR.            CONREC.194
C                                                                                CONREC.195
C                            ISIZEP   0      SIZE OF LABELS FOR DATA             CONREC.196
C                                            POINT VALUES AS PER THE SIZE        CONREC.197
C                                            DEFINITIONS GIVEN IN THE SPPS       CONREC.198
C                                            DOCUMENTATION FOR WTSTR.            CONREC.199
C                                                                                CONREC.200
C                            NLA      16     APPROXIMATE NUMBER OF               CONREC.201
C                                            CONTOUR LEVELS WHEN                 CONREC.202
C                                            INTERNALLY GENERATED.               CONREC.203
C                                                                                CONREC.204
C                            NLM      40     MAXIMUM NUMBER OF CONTOUR           CONREC.205
C                                            LEVELS.  IF THIS IS TO BE           CONREC.206
C                                            INCREASED, THE DIMENSIONS           CONREC.207
C                                            OF CL AND RWORK IN CONREC           CONREC.208
C                                            MUST BE INCREASED BY THE            CONREC.209
C                                            SAME AMOUNT.                        CONREC.210
C                                                                                CONREC.211
C                            XLT      .05    LEFT HAND EDGE OF THE PLOT          CONREC.212
C                                            (0.0 IS THE LEFT EDGE OF            CONREC.213
C                                            THE FRAME AND 1.0 IS THE            CONREC.214
C                                            RIGHT EDGE OF THE FRAME.)           CONREC.215
C                                                                                CONREC.216
C                            YBT      .05    BOTTOM EDGE OF THE PLOT             CONREC.217
C                                            (0.0 IS THE BOTTOM OF THE           CONREC.218
C                                            FRAME AND 1.0 IS THE TOP            CONREC.219
C                                            OF THE FRAME.)                      CONREC.220
C                                                                                CONREC.221
C                            SIDE     0.9    LENGTH OF LONGER EDGE OF            CONREC.222
C                                            PLOT (SEE ALSO EXT).                CONREC.223
C                                                                                CONREC.224
C                            NREP     6      NUMBER OF REPETITIONS OF            CONREC.225
C                                            THE DASH PATTERN BETWEEN            CONREC.226
C                                            LINE LABELS.                        CONREC.227
C                                                                                CONREC.228
C                            NCRT     4      NUMBER OF CRT UNITS PER             CONREC.229
C                                            ELEMENT (BIT) IN THE DASH           CONREC.230
C                                            PATTERN.                            CONREC.231
C                                                                                CONREC.232
C                            ILAB     1      FLAG TO CONTROL THE DRAWING         CONREC.233
C                                            OF LINE LABELS.                     CONREC.234
C                                            . ILAB NON-ZERO MEANS LABEL         CONREC.235
C                                              THE LINES.                        CONREC.236
C                                            . ILAB = 0 MEANS DO NOT             CONREC.237
C                                              LABEL THE LINES.                  CONREC.238
C                                                                                CONREC.239
C                            NULBLL   3      NUMBER OF UNLABELED LINES           CONREC.240
C                                            BETWEEN LABELED LINES.  FOR         CONREC.241
C                                            EXAMPLE, WHEN NULBLL = 3,           CONREC.242
C                                            EVERY FOURTH LEVEL IS               CONREC.243
C                                            LABELED.                            CONREC.244
C                                                                                CONREC.245
C                            IOFFD    0      FLAG TO CONTROL                     CONREC.246
C                                            NORMALIZATION OF LABEL              CONREC.247
C                                            NUMBERS.                            CONREC.248
C                                            . IOFFD = 0 MEANS INCLUDE           CONREC.249
C                                              DECIMAL POINT WHEN                CONREC.250
C                                              POSSIBLE (DO NOT                  CONREC.251
C                                              NORMALIZE UNLESS                  CONREC.252
C                                              REQUIRED).                        CONREC.253
C                                            . IOFFD NON-ZERO MEANS              CONREC.254
C                                              NORMALIZE ALL LABEL               CONREC.255
C                                              NUMBERS AND OUTPUT A              CONREC.256
C                                              SCALE FACTOR IN THE               CONREC.257
C                                              MESSAGE BELOW THE GRAPH.          CONREC.258
C                                                                                CONREC.259
C                            EXT      .25    LENGTHS OF THE SIDES OF THE         CONREC.260
C                                            PLOT ARE PROPORTIONAL TO M          CONREC.261
C                                            AND N (WHEN CONREC SETS             CONREC.262
C                                            THE WINDOW AND VIEWPORT).           CONREC.263
C                                            IN EXTREME CASES, WHEN              CONREC.264
C                                            MIN(M,N)/MAX(M,N) IS LESS           CONREC.265
C                                            THAN EXT, CONREC                    CONREC.266
C                                            PRODUCES A SQUARE PLOT.             CONREC.267
C                                                                                CONREC.268
C                            IOFFP      0    FLAG TO CONTROL SPECIAL             CONREC.269
C                                            VALUE FEATURE.                      CONREC.270
C                                            . IOFFP = 0 MEANS SPECIAL           CONREC.271
C                                              VALUE FEATURE NOT IN USE.         CONREC.272
C                                            . IOFFP NON-ZERO MEANS              CONREC.273
C                                              SPECIAL VALUE FEATURE IN          CONREC.274
C                                              USE.  (SPVAL IS SET TO THE        CONREC.275
C                                              SPECIAL VALUE.)  CONTOUR          CONREC.276
C                                              LINES WILL THEN BE                CONREC.277
C                                              OMITTED FROM ANY CELL             CONREC.278
C                                              WITH ANY CORNER EQUAL TO          CONREC.279
C                                              THE SPECIAL VALUE.                CONREC.280
C                                                                                CONREC.281
C                            SPVAL    0.     CONTAINS THE SPECIAL VALUE          CONREC.282
C                                            WHEN IOFFP IS NON-ZERO.             CONREC.283
C                                                                                CONREC.284
C                            IOFFM    0      FLAG TO CONTROL THE MESSAGE         CONREC.285
C                                            BELOW THE PLOT.                     CONREC.286
C                                            . IOFFM = 0  IF THE MESSAGE         CONREC.287
C                                              IS TO BE PLOTTED.                 CONREC.288
C                                            . IOFFM NON-ZERO IF THE             CONREC.289
C                                              MESSAGE IS TO BE OMITTED.         CONREC.290
C                                                                                CONREC.291
C                            ISOLID   1023   DASH PATTERN FOR                    CONREC.292
C                                            NON-NEGATIVE CONTOUR LINES.         CONREC.293
C                                                                                CONREC.294
C                                                                                CONREC.295
      EXTERNAL        CONBD                                                      CONREC.296
C                                                                                CONREC.297
      SAVE                                                                       CONREC.298
      CHARACTER*1     IGAP       ,ISOL       ,RCHAR                              CONREC.299
      CHARACTER       ENCSCR*22  ,IWORK*126                                      CONREC.300
      DIMENSION       LNGTHS(5)  ,HOLD(5)    ,WIND(4),VIEW(4),RECT(4)            CONREC.301
      DIMENSION       Z(L,N)     ,CL(100)    ,RWORK(100) ,LASF(13)               CONREC.302
      COMMON /INTPR/ PAD1, FPART, PAD(8)                                         CONREC.303
      COMMON /CONRE1/ IOFFP      ,SPVAL                                          CONREC.304
      COMMON /CONRE3/ IXBITS     ,IYBITS                                         CONREC.305
      COMMON /CONRE4/ ISIZEL     ,ISIZEM     ,ISIZEP     ,NREP       ,           CONREC.306
     1                NCRT       ,ILAB       ,NULBLL     ,IOFFD      ,           CONREC.307
     2                EXT        ,IOFFM      ,ISOLID     ,NLA        ,           CONREC.308
     3                NLM        ,XLT        ,YBT        ,SIDE                   CONREC.309
      COMMON /CONRE5/ SCLY                                                       CONREC.310
      COMMON /RECINT/ IRECMJ     ,IRECMN     ,IRECTX                             CONREC.311
      DATA  LNGTHS(1),LNGTHS(2),LNGTHS(3),LNGTHS(4),LNGTHS(5)                    CONREC.312
     1      /  12,       3,        20,       9,        17       /                CONREC.313
      DATA  ISOL, IGAP /'$', ''''/                                               CONREC.314
C                                                                                CONREC.315
C ISOL AND IGAP (DOLLAR-SIGN AND APOSTROPHE) ARE USED TO CONSTRUCT PAT-          CONREC.316
C TERNS PASSED TO ROUTINE DASHDC IN THE SOFTWARE DASHED-LINE PACKAGE.            CONREC.317
C                                                                                CONREC.318
C                                                                                CONREC.319
C                                                                                CONREC.320
C THE FOLLOWING CALL IS FOR GATHERING STATISTICS ON LIBRARY USE AT NCAR          CONREC.321
C                                                                                CONREC.322
      CALL Q8QST4 ('GRAPHX','CONREC','CONREC','VERSION 01')                      CONREC.323
C                                                                                CONREC.324
C NONSMOOTHING VERSION                                                           CONREC.325
C                                                                                CONREC.326
C                                                                                CONREC.327
C                                                                                CONREC.328
C  CALL RESET FOR COMPATIBILITY WITH ALL DASH ROUTINES(EXCEPT DASHLINE)          CONREC.329
C                                                                                CONREC.330
      CALL RESET                                                                 CONREC.331
C                                                                                CONREC.332
C  GET NUMBER OF BITS IN INTEGER ARITHMETIC                                      CONREC.333
C                                                                                CONREC.334
      IARTH = I1MACH(8)                                                          CONREC.335
      IXBITS = 0                                                                 CONREC.336
      DO 101 I=1,IARTH                                                           CONREC.337
         IF (M .LE. (2**I-1)) GO TO 102                                          CONREC.338
         IXBITS = I+1                                                            CONREC.339
  101 CONTINUE                                                                   CONREC.340
  102 IYBITS = 0                                                                 CONREC.341
      DO 103 I=1,IARTH                                                           CONREC.342
         IF (N .LE. (2**I-1)) GO TO 104                                          CONREC.343
         IYBITS = I+1                                                            CONREC.344
  103 CONTINUE                                                                   CONREC.345
  104 IF ((IXBITS*IYBITS).GT.0 .AND. (IXBITS+IYBITS).LE.24) GO TO 105            CONREC.346
C                                                                                CONREC.347
C REPORT ERROR NUMBER ONE                                                        CONREC.348
C                                                                                CONREC.349
      IWORK =    'CONREC  - DIMENSION ERROR - M*N .GT. (2**IARTH)    M =         CONREC.350
     +            N = '                                                          CONREC.351
      WRITE (IWORK(56:62),'(I6)') M                                              CONREC.352
      WRITE (IWORK(73:79),'(I6)') N                                              CONREC.353
      CALL SETER( IWORK, 1, 1 )                                                  CONREC.354
      RETURN                                                                     CONREC.355
  105 CONTINUE                                                                   CONREC.356
C                                                                                CONREC.357
C INQUIRE CURRENT TEXT AND LINE COLOR INDEX                                      CONREC.358
C                                                                                CONREC.359
      CALL GQTXCI ( IERR, ITXCI )                                                CONREC.360
      CALL GQPLCI ( IERR, IPLCI )                                                CONREC.361
C                                                                                CONREC.362
C SET REQUESTED TEXT COLOR.                                                      CONREC.363
C                                                                                CONREC.364
      CALL GSTXCI(IRECTX)                                                        CONREC.365
C                                                                                CONREC.366
C SET LINE AND TEXT ASF TO INDIVIDUAL                                            CONREC.367
C                                                                                CONREC.368
      CALL GQASF ( IERR, LASF )                                                  CONREC.369
      LSV3  = LASF(3)                                                            CONREC.370
      LSV10 = LASF(10)                                                           CONREC.371
      LASF(3)  = 1                                                               CONREC.372
      LASF(10) = 1                                                               CONREC.373
      CALL GSASF ( LASF )                                                        CONREC.374
C                                                                                CONREC.375
      GL = FLO                                                                   CONREC.376
      HA = HI                                                                    CONREC.377
      GP = FINC                                                                  CONREC.378
      MX = L                                                                     CONREC.379
      NX = M                                                                     CONREC.380
      NY = N                                                                     CONREC.381
      IDASH = NDOT                                                               CONREC.382
      NEGPOS = ISIGN(1,IDASH)                                                    CONREC.383
      IDASH = IABS(IDASH)                                                        CONREC.384
      IF (IDASH.EQ.0 .OR. IDASH.EQ.1) IDASH = ISOLID                             CONREC.385
C                                                                                CONREC.386
C SET CONTOUR LEVELS.                                                            CONREC.387
C                                                                                CONREC.388
      CALL CLGEN (Z,MX,NX,NY,GL,HA,GP,NLA,NLM,CL,NCL,ICNST)                      CONREC.389
C                                                                                CONREC.390
C FIND MAJOR AND MINOR LINES                                                     CONREC.391
C                                                                                CONREC.392
      IF (ILAB .NE. 0) CALL REORD (CL,NCL,RWORK,NML,NULBLL+1)                    CONREC.393
      IF (ILAB .EQ. 0) NML = 0                                                   CONREC.394
C                                                                                CONREC.395
C SAVE THE CURRENT SET PARAMETERS.                                               CONREC.396
C                                                                                CONREC.397
      CALL GETSET (VIEW(1),VIEW(2),VIEW(3),VIEW(4),                              CONREC.398
     +             WIND(1),WIND(2),WIND(3),WIND(4),IOLLS)                        CONREC.399
C                                                                                CONREC.400
C SET UP SCALING                                                                 CONREC.401
C                                                                                CONREC.402
      CALL GETUSV ( 'YF' , IYVAL )                                               CONREC.403
      SCLY = 1.0 / ISHIFT ( 1, 15 - IYVAL )                                      CONREC.404
C                                                                                CONREC.405
      IF (NSET) 106,107,111                                                      CONREC.406
C                                                                                CONREC.407
  106 X1 = VIEW(1)                                                               CONREC.408
      X2 = VIEW(2)                                                               CONREC.409
      Y1 = VIEW(3)                                                               CONREC.410
      Y2 = VIEW(4)                                                               CONREC.411
C                                                                                CONREC.412
C                                                                                CONREC.413
C                                                                                CONREC.414
C                                                                                CONREC.415
C                                                                                CONREC.416
C DEFINE NORMALIZATION TRANS AND LOG SCALING                                     CONREC.417
C                                                                                CONREC.418
      CALL SET(X1, X2, Y1, Y2, 1.0, FLOAT(NX), 1.0, FLOAT(NY), 1)                CONREC.419
      GO TO 111                                                                  CONREC.420
  107 CONTINUE                                                                   CONREC.421
      X1 = XLT                                                                   CONREC.422
      X2 = XLT+SIDE                                                              CONREC.423
      Y1 = YBT                                                                   CONREC.424
      Y2 = YBT+SIDE                                                              CONREC.425
      X3 = NX                                                                    CONREC.426
      Y3 = NY                                                                    CONREC.427
      IF (AMIN1(X3,Y3)/AMAX1(X3,Y3) .LT. EXT) GO TO 110                          CONREC.428
      IF (NX-NY) 108,110,109                                                     CONREC.429
  108 X2 = SIDE*X3/Y3+XLT                                                        CONREC.430
      GO TO 110                                                                  CONREC.431
  109 Y2 = SIDE*Y3/X3+YBT                                                        CONREC.432
C                                                                                CONREC.433
C                                                                                CONREC.434
C                                                                                CONREC.435
C                                                                                CONREC.436
C                                                                                CONREC.437
C DEFINE NORMALIZATION TRANS 1 AND LOG SCALING                                   CONREC.438
C                                                                                CONREC.439
  110 CALL SET(X1,X2,Y1,Y2,1.0,X3,1.0,Y3,1)                                      CONREC.440
C                                                                                CONREC.441
C DRAW PERIMETER                                                                 CONREC.442
C                                                                                CONREC.443
      CALL PERIM (NX-1,1,NY-1,1)                                                 CONREC.444
  111 IF (ICNST .NE. 0) GO TO 124                                                CONREC.445
C                                                                                CONREC.446
C SET UP LABEL SCALING                                                           CONREC.447
C                                                                                CONREC.448
      IOFFDT = IOFFD                                                             CONREC.449
      IF (GL.NE.0.0 .AND. (ABS(GL).LT.0.1 .OR. ABS(GL).GE.1.E5))                 CONREC.450
     1    IOFFDT = 1                                                             CONREC.451
      IF (HA.NE.0.0 .AND. (ABS(HA).LT.0.1 .OR. ABS(HA).GE.1.E5))                 CONREC.452
     1    IOFFDT = 1                                                             CONREC.453
      ASH = 10.**(3-IFIX(ALOG10(AMAX1(ABS(GL),ABS(HA),ABS(GP)))                  CONREC.454
     1                                                  -4999.999)-5000)         CONREC.455
      IF (IOFFDT .EQ. 0) ASH = 1.                                                CONREC.456
      IF (IOFFM .NE. 0) GO TO 115                                                CONREC.457
      IWORK ='CONTOUR FROM              TO              CONTOUR INTERVAL         CONREC.458
     1 OF              PT(3,3)=              LABELS SCALED BY'                   CONREC.459
      HOLD(1) = GL                                                               CONREC.460
      HOLD(2) = HA                                                               CONREC.461
      HOLD(3) = GP                                                               CONREC.462
      HOLD(4) = Z(3,3)                                                           CONREC.463
      HOLD(5) = ASH                                                              CONREC.464
      NCHAR = 0                                                                  CONREC.465
      DO 114 I=1,5                                                               CONREC.466
         WRITE ( ENCSCR, '(G13.5)' ) HOLD(I)                                     CONREC.467
         NCHAR = NCHAR+LNGTHS(I)                                                 CONREC.468
         DO 113 J=1,13                                                           CONREC.469
            NCHAR = NCHAR+1                                                      CONREC.470
            IWORK(NCHAR:NCHAR) = ENCSCR(J:J)                                     CONREC.471
  113    CONTINUE                                                                CONREC.472
  114 CONTINUE                                                                   CONREC.473
      IF (ASH .EQ. 1.) NCHAR = NCHAR-13-LNGTHS(5)                                CONREC.474
C                                                                                CONREC.475
C WRITE TITLE                                                                    CONREC.476
C                                                                                CONREC.477
C                                                                                CONREC.478
      CALL GQCLIP (IERR,ICLP,RECT)                                               CONREC.479
      CALL GSCLIP (0)                                                            CONREC.480
      CALL WTSTR (CFUX(.5),CFUY(.015625),IWORK(1:NCHAR),0,0,0)                   CONREC.481
      CALL GSCLIP (ICLP)                                                         CONREC.482
C                                                                                CONREC.483
C                                                                                CONREC.484
C                                                                                CONREC.485
C                                                                                CONREC.486
C                       * * * * * * * * * *                                      CONREC.487
C                            * * * * * * * * * *                                 CONREC.488
C                                                                                CONREC.489
C                                                                                CONREC.490
C PROCESS EACH LEVEL                                                             CONREC.491
C                                                                                CONREC.492
  115 FPART = .5                                                                 CONREC.493
C                                                                                CONREC.494
      DO 123 I=1,NCL                                                             CONREC.495
         CALL PLOTIT(0,0,0)                                                      CONREC.496
         CALL GSPLCI ( IRECMJ )                                                  CONREC.497
         CONTR = CL(I)                                                           CONREC.498
         NDASH = IDASH                                                           CONREC.499
         IF (NEGPOS.LT.0 .AND. CONTR.GE.0.) NDASH = ISOLID                       CONREC.500
C                                                                                CONREC.501
C CHANGE 10 BIT PATTERN TO 10 CHARACTER PATTERN.                                 CONREC.502
C                                                                                CONREC.503
         DO 116 J=1,10                                                           CONREC.504
            IBIT = IAND(ISHIFT(NDASH,(J-10)),1)                                  CONREC.505
            RCHAR = IGAP                                                         CONREC.506
            IF (IBIT .NE. 0) RCHAR = ISOL                                        CONREC.507
            IWORK(J:J) = RCHAR                                                   CONREC.508
  116    CONTINUE                                                                CONREC.509
         IF (I .GT. NML) GO TO 121                                               CONREC.510
C                                                                                CONREC.511
C SET UP MAJOR LINE (LABELED)                                                    CONREC.512
C                                                                                CONREC.513
C                                                                                CONREC.514
C NREP REPITITIONS OF PATTERN PER LABEL.                                         CONREC.515
C                                                                                CONREC.516
         NCHAR = 10                                                              CONREC.517
         IF (NREP .LT. 2) GO TO 119                                              CONREC.518
         DO 118 J=1,10                                                           CONREC.519
            NCHAR = J                                                            CONREC.520
            RCHAR = IWORK(J:J)                                                   CONREC.521
            DO 117 K=2,NREP                                                      CONREC.522
               NCHAR = NCHAR+10                                                  CONREC.523
               IWORK(NCHAR:NCHAR) = RCHAR                                        CONREC.524
  117       CONTINUE                                                             CONREC.525
  118    CONTINUE                                                                CONREC.526
  119    CONTINUE                                                                CONREC.527
C                                                                                CONREC.528
C PUT IN LABEL.                                                                  CONREC.529
C                                                                                CONREC.530
         CALL ENCD (CONTR,ASH,ENCSCR,NCUSED,IOFFDT)                              CONREC.531
         DO 120 J=1,NCUSED                                                       CONREC.532
            NCHAR = NCHAR+1                                                      CONREC.533
            IWORK(NCHAR:NCHAR) = ENCSCR(J:J)                                     CONREC.534
  120    CONTINUE                                                                CONREC.535
         GO TO 122                                                               CONREC.536
C                                                                                CONREC.537
C SET UP MINOR LINE (UNLABELED).                                                 CONREC.538
C                                                                                CONREC.539
  121    CONTINUE                                                                CONREC.540
C                                                                                CONREC.541
C SET LINE INTENSITY TO LOW                                                      CONREC.542
C                                                                                CONREC.543
         CALL GSPLCI ( IRECMN )                                                  CONREC.544
         NCHAR = 10                                                              CONREC.545
  122    CALL DASHDC ( IWORK(1:NCHAR),NCRT, ISIZEL )                             CONREC.546
C                                                                                CONREC.547
C DRAW ALL LINES AT THIS LEVEL.                                                  CONREC.548
C                                                                                CONREC.549
         CALL STLINE (Z,MX,NX,NY,CONTR)                                          CONREC.550
C                                                                                CONREC.551
  123 CONTINUE                                                                   CONREC.552
      CALL GSPLCI(IRECMJ)                                                        CONREC.553
C                                                                                CONREC.554
C FIND RELATIVE MINIMUMS AND MAXIMUMS IF WANTED, AND MARK VALUES IF              CONREC.555
C WANTED.                                                                        CONREC.556
C                                                                                CONREC.557
      IF (NHI .EQ. 0) CALL MINMAX (Z,MX,NX,NY,ISIZEM,ASH,IOFFDT)                 CONREC.558
      IF (NHI .GT. 0) CALL MINMAX (Z,MX,NX,NY,ISIZEP,-ASH,IOFFDT)                CONREC.559
      FPART = 1.                                                                 CONREC.560
      GO TO 127                                                                  CONREC.561
  124 CONTINUE                                                                   CONREC.562
         IWORK = 'CONSTANT FIELD'                                                CONREC.563
      WRITE( ENCSCR, '(G22.14)' ) GL                                             CONREC.564
      DO 126 I=1,22                                                              CONREC.565
         IWORK(I+14:I+14) = ENCSCR(I:I)                                          CONREC.566
  126 CONTINUE                                                                   CONREC.567
C                                                                                CONREC.568
C WRITE TITLE                                                                    CONREC.569
C                                                                                CONREC.570
      CALL GQCLIP (IERR,ICLP,RECT)                                               CONREC.571
      CALL GSCLIP (0)                                                            CONREC.572
      CALL WTSTR (CFUX(.09765),CFUY(.48825),IWORK(1:36),3,0,-1)                  CONREC.573
      CALL GSCLIP (ICLP)                                                         CONREC.574
C                                                                                CONREC.575
C RESTORE NORMALIZATION TRANS 1, LINE AND TEXT INTENSITY TO ORIGINAL             CONREC.576
C                                                                                CONREC.577
  127 IF (NSET.LE.0)                                                             CONREC.578
     +    CALL SET(VIEW(1),VIEW(2),VIEW(3),VIEW(4),                              CONREC.579
     +             WIND(1),WIND(2),WIND(3),WIND(4),IOLLS)                        CONREC.580
C                                                                                CONREC.581
      CALL GSPLCI ( IPLCI )                                                      CONREC.582
      CALL GSTXCI ( ITXCI )                                                      CONREC.583
C                                                                                CONREC.584
C RESTORE THE ORIGINAL ASPECT SOURCE FLAGS.                                      CONREC.585
C                                                                                CONREC.586
C                                                                                CONREC.587
      LASF(3)  = LSV3                                                            CONREC.588
      LASF(10) = LSV10                                                           CONREC.589
      CALL GSASF ( LASF )                                                        CONREC.590
C                                                                                CONREC.591
      RETURN                                                                     CONREC.592
C                                                                                CONREC.593
C                                                                                CONREC.594
      END                                                                        CONREC.595
