      SUBROUTINE CRS2DOT (CRS,IMX,JMX,KX,IEND,JEND)                              CRS2DOT.1
#     include <scratch.incl>                                                     CRS2DOT.2
C                                                                                CRS2DOT.3
      INEED = IMX*JMX                                                            CRS2DOT.4
      IN1 = NTEMP                                                                CRS2DOT.5
      NTEMP = NTEMP+INEED                                                        CRS2DOT.6
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('CRS2DOT')                        CRS2DOT.7
      IF(VERBOSE) WRITE(6,*) ' CALLING CRS2DOT ',INEED,IN1,NTEMP                 CRS2DOT.8
C                                                                                CRS2DOT.9
        CALL CRS2DOT_0 (CRS,IMX,JMX,KX,IEND,JEND,SCR(IN1))                       CRS2DOT.10
C                                                                                CRS2DOT.11
      NTEMP = NTEMP - INEED                                                      CRS2DOT.12
      IF(VERBOSE) WRITE(6,*) ' RET FROM CRS2DOT ',NTEMP                          CRS2DOT.13
      RETURN                                                                     CRS2DOT.14
      END                                                                        CRS2DOT.15
C                                                                                CRS2DOT.16
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC                CRS2DOT.17
C                                                                                CRS2DOT.18
      SUBROUTINE CRS2DOT_0 (CRS,IMX,JMX,KX,IEND,JEND,DOT)                        CRS2DOT.19
C                                                                                CRS2DOT.20
C     SECTION  TOOLS                                                             CRS2DOT.21
C     PURPOSE  HORIZONTALLY INTERPOLATE A CROSS POINT SLAB TO DOT                CRS2DOT.22
C              POINTS                                                            CRS2DOT.23
C                                                                                CRS2DOT.24
      DIMENSION CRS(IMX,JMX,KX), DOT(IMX,JMX)                                    CRS2DOT.25
C                                                                                CRS2DOT.26
      DO 200 K=1,KX                                                              CRS2DOT.27
         DO 100 J=2,JEND-1                                                       CRS2DOT.28
         DO 100 I=2,IEND-1                                                       CRS2DOT.29
            DOT(I,J)=(CRS(I,J,K) + CRS(I-1,J,K) +                                CRS2DOT.30
     *                CRS(I,J-1,K) + CRS(I-1,J-1,K))*0.25                        CRS2DOT.31
100      CONTINUE                                                                CRS2DOT.32
         DO 120 J=2,JEND-1                                                       CRS2DOT.33
            DOT(1,J)=((CRS(1,J,K) + CRS(1,J-1,K))*1.5 -                          CRS2DOT.34
     *                (CRS(2,J,K) + CRS(2,J-1,K))*0.5) * 0.5                     CRS2DOT.35
120      CONTINUE                                                                CRS2DOT.36
         DO 125 J=2,JEND-1                                                       CRS2DOT.37
            DOT(IEND,J)=((CRS(IEND-1,J,K)+CRS(IEND-1,J-1,K))*1.5 -               CRS2DOT.38
     *                   (CRS(IEND-2,J,K)+CRS(IEND-2,J-1,K))*0.5) * 0.5          CRS2DOT.39
125      CONTINUE                                                                CRS2DOT.40
         DO 130 I=2,IEND-1                                                       CRS2DOT.41
            DOT(I,1)=((CRS(I,1,K) + CRS(I-1,1,K))*1.5 -                          CRS2DOT.42
     *                (CRS(I,2,K) + CRS(I-1,2,K))*0.5) * 0.5                     CRS2DOT.43
130      CONTINUE                                                                CRS2DOT.44
         DO 135 I=2,IEND-1                                                       CRS2DOT.45
            DOT(I,JEND)=((CRS(I,JEND-1,K)+CRS(I-1,JEND-1,K))*1.5 -               CRS2DOT.46
     *                   (CRS(I,JEND-2,K)+CRS(I-1,JEND-2,K))*0.5) * 0.5          CRS2DOT.47
135      CONTINUE                                                                CRS2DOT.48
         DOT(1,1)       =4. * CRS(1,1,K)      -                                  CRS2DOT.49
     *      (DOT(1,2)         + DOT(2,1)           + DOT(2,2))                   CRS2DOT.50
         DOT(IEND,1)    =4. * CRS(IEND-1,1,K) -                                  CRS2DOT.51
     *      (DOT(IEND-1,1)    + DOT(IEND-1,2)      + DOT(IEND,2))                CRS2DOT.52
         DOT(1,JEND)    =4. * CRS(1,JEND-1,K) -                                  CRS2DOT.53
     *      (DOT(1,JEND-1)    + DOT(2,JEND)        + DOT(2,JEND-1))              CRS2DOT.54
         DOT(IEND,JEND) =4. * CRS(IEND-1,JEND-1,K) -                             CRS2DOT.55
     *      (DOT(IEND,JEND-1) + DOT(IEND-1,JEND-1) + DOT(IEND-1,JEND))           CRS2DOT.56
C                                                                                CRS2DOT.57
C     ... PUT THE INTERPOLATED DOT POINT VALUES INTO THE CRS ARRAY               CRS2DOT.58
C                                                                                CRS2DOT.59
         DO 190 J=1,JEND                                                         CRS2DOT.60
         DO 190 I=1,IEND                                                         CRS2DOT.61
            CRS(I,J,K)=DOT(I,J)                                                  CRS2DOT.62
190      CONTINUE                                                                CRS2DOT.63
200   CONTINUE                                                                   CRS2DOT.64
      RETURN                                                                     CRS2DOT.65
      END                                                                        CRS2DOT.66
C                                                                                CRS2DOT.67
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC                     CRS2DOT.68
C                                                                                CRS2DOT.69
      SUBROUTINE SPACE_STOP(ROUTINE)                                             CRS2DOT.70
C                                                                                CRS2DOT.71
      CHARACTER*(*) ROUTINE                                                      CRS2DOT.72
#     include <scratch.incl>                                                     CRS2DOT.73
C                                                                                CRS2DOT.74
      WRITE(6,*) ' NOT ENOUGH SCRATCH SPACE '                                    CRS2DOT.75
      WRITE(6,*) ' IN SCRATCH.INCL, I_SCRATCH IS ',I_SCRATCH                     CRS2DOT.76
      WRITE(6,*) ' MAX NEEDED FOR ROUTINE ',ROUTINE,' IS ',NTEMP                 CRS2DOT.77
      WRITE(6,*) ' ERROR STOP '                                                  CRS2DOT.78
      STOP                                                                       CRS2DOT.79
C                                                                                CRS2DOT.80
      RETURN                                                                     CRS2DOT.81
      END                                                                        CRS2DOT.82
