      SUBROUTINE CRSWINDS (U, V, I1, J1, K1, FLD, OUT)                           CRSWINDS.1
C                                                                                CRSWINDS.2
C  SUPPORT ROUTINE FOR PLOTTING CROSS SECTION WINDS. OUT CONTAINS THE            CRSWINDS.3
C  PLANE-PARALLEL OR CROSS-PLANE WINDS TO BE PLOTTED                             CRSWINDS.4
C                                                                                CRSWINDS.5
      DIMENSION U(I1,J1,K1), V(I1,J1,K1), OUT(I1,J1,K1)                          CRSWINDS.6
      CHARACTER FLD*80                                                           CRSWINDS.7
      COMMON /XSECTION/ IXCRSB,JXCRSL,IXCRST,JXCRSR,LOCCRS                       CRSWINDS.8
      LOGICAL LOCCRS                                                             CRSWINDS.9
      INTEGER DASH1, DASH2, COLOR1, COLOR2, COLOR3,                              CRSWINDS.10
     *                      COLOR4, COLOR5, COLOR6                               CRSWINDS.11
      LOGICAL HDRINFO,ICONDRV(2)                                                 CRSWINDS.12
      REAL LEVELS(100)                                                           CRSWINDS.13
      COMMON /DEFAULTS/ TRUELAT1, TRUELAT2, LW1, LW2,                            CRSWINDS.14
     * DASH1, DASH2, COLOR1, COLOR2, COLOR3,COLOR4,COLOR5,COLOR6,                CRSWINDS.15
     * HDRINFO,LOGP,XPTOP,ICONDRV,LMETH,LEVELS,UREL,VREL,                        CRSWINDS.16
     * LABLINE,LABMESG,NOZERO                                                    CRSWINDS.17
         DDX = FLOAT(JXCRSR - JXCRSL)                                            CRSWINDS.18
         DDY = FLOAT(IXCRST - IXCRSB)                                            CRSWINDS.19
C                                                                                CRSWINDS.20
C        ... XXW : CROSS CROSS-SECTION WIND.                                     CRSWINDS.21
C        ... AXW : ALONG CROSS-SECTION WIND.                                     CRSWINDS.22
C        ... CXW : CIRCULATION ALONG CROSS-SECTION                               CRSWINDS.23
C        ... AM  : ABSOLUTE MOMENTUM                                             CRSWINDS.24
C                                                                                CRSWINDS.25
         IF ((FLD(1:3) .EQ. 'AXW') .OR. (FLD(1:3) .EQ.'CXW') ) THEN              CRSWINDS.26
           VX = DDX/SQRT(DDX*DDX+DDY*DDY)                                        CRSWINDS.27
           VY = DDY/SQRT(DDX*DDX+DDY*DDY)                                        CRSWINDS.28
         ELSE IF (FLD(1:2) .EQ. 'AM') THEN                                       CRSWINDS.29
           VX = -1. * DDY/SQRT(DDX*DDX+DDY*DDY)                                  CRSWINDS.30
           VY = DDX/SQRT(DDX*DDX+DDY*DDY)                                        CRSWINDS.31
         ELSE IF (FLD(1:3) .EQ. 'XXW') THEN                                      CRSWINDS.32
           VX = -1. * DDY/SQRT(DDX*DDX+DDY*DDY)                                  CRSWINDS.33
           VY = DDX/SQRT(DDX*DDX+DDY*DDY)                                        CRSWINDS.34
         END IF                                                                  CRSWINDS.35
C                                                                                CRSWINDS.36
        DO 101 K = 2, K1                                                         CRSWINDS.37
        DO 101 J = 1, J1                                                         CRSWINDS.38
        DO 101 I = 1, I1                                                         CRSWINDS.39
           OUT(I,J,K) = (U(I,J,K)-UREL)*VX + (V(I,J,K)-VREL)*VY                  CRSWINDS.40
  101   CONTINUE                                                                 CRSWINDS.41
      DO 200 J=1,J1                                                              CRSWINDS.42
      DO 200 I=1,I1                                                              CRSWINDS.43
         OUT(I,J,1)=OUT(I,J,2)                                                   CRSWINDS.44
200   CONTINUE                                                                   CRSWINDS.45
      RETURN                                                                     CRSWINDS.46
      END                                                                        CRSWINDS.47
