      SUBROUTINE CURV1 (N,X,Y,SLP1,SLPN,YP,TEMP,SIGMA)                           CURV1.1
C                                                                                CURV1.2
      INTEGER         N                                                          CURV1.3
      REAL            X(N)       ,Y(N)       ,SLP1       ,SLPN       ,           CURV1.4
     1                YP(N)      ,TEMP(N)    ,SIGMA                              CURV1.5
      DO 10 I = 2, N                                                             CURV1.6
         IF (X(I).GT.X(I-1)) GO TO 10                                            CURV1.7
         PRINT *,' *** ERROR IN CURV1, X NOT IN INCREASING ORDER'                CURV1.8
         STOP10                                                                  CURV1.9
   10 CONTINUE                                                                   CURV1.10
C                                                                                CURV1.11
      NN = N                                                                     CURV1.12
      NM1 = NN-1                                                                 CURV1.13
      NP1 = NN+1                                                                 CURV1.14
      DELX1 = X(2)-X(1)                                                          CURV1.15
      DX1 = (Y(2)-Y(1))/DELX1                                                    CURV1.16
C                                                                                CURV1.17
C DETERMINE SLOPES IF NECESSARY                                                  CURV1.18
C                                                                                CURV1.19
      IF (SIGMA.LT.0.) GO TO 60                                                  CURV1.20
      SLPP1 = SLP1                                                               CURV1.21
      SLPPN = SLPN                                                               CURV1.22
C                                                                                CURV1.23
C DENORMALIZE TENSION FACTOR                                                     CURV1.24
C                                                                                CURV1.25
   20 SIGMAP = ABS(SIGMA)*FLOAT(NN-1)/(X(NN)-X(1))                               CURV1.26
C                                                                                CURV1.27
C SET UP RIGHT HAND SIDE AND TRIDIAGONAL SYSTEM FOR YP AND                       CURV1.28
C PERFORM FORWARD ELIMINATION                                                    CURV1.29
C                                                                                CURV1.30
      DELS = SIGMAP*DELX1                                                        CURV1.31
      EXPS = EXP(DELS)                                                           CURV1.32
      SINHS = .5*(EXPS-1./EXPS)                                                  CURV1.33
      SINHIN = 1./(DELX1*SINHS)                                                  CURV1.34
      DIAG1 = SINHIN*(DELS*.5*(EXPS+1./EXPS)-SINHS)                              CURV1.35
      DIAGIN = 1./DIAG1                                                          CURV1.36
      YP(1) = DIAGIN*(DX1-SLPP1)                                                 CURV1.37
      SPDIAG = SINHIN*(SINHS-DELS)                                               CURV1.38
      TEMP(1) = DIAGIN*SPDIAG                                                    CURV1.39
      IF (NN.EQ.2) GO TO 40                                                      CURV1.40
      DO 30 I = 2, NM1                                                           CURV1.41
         DELX2 = X(I+1)-X(I)                                                     CURV1.42
         DX2 = (Y(I+1)-Y(I))/DELX2                                               CURV1.43
         DELS = SIGMAP*DELX2                                                     CURV1.44
         EXPS = EXP(DELS)                                                        CURV1.45
         SINHS = .5*(EXPS-1./EXPS)                                               CURV1.46
         SINHIN = 1./(DELX2*SINHS)                                               CURV1.47
         DIAG2 = SINHIN*(DELS*(.5*(EXPS+1./EXPS))-SINHS)                         CURV1.48
         DIAGIN = 1./(DIAG1+DIAG2-SPDIAG*TEMP(I-1))                              CURV1.49
         YP(I) = DIAGIN*(DX2-DX1-SPDIAG*YP(I-1))                                 CURV1.50
         SPDIAG = SINHIN*(SINHS-DELS)                                            CURV1.51
         TEMP(I) = DIAGIN*SPDIAG                                                 CURV1.52
         DX1 = DX2                                                               CURV1.53
         DIAG1 = DIAG2                                                           CURV1.54
   30 CONTINUE                                                                   CURV1.55
   40 DIAGIN = 1./(DIAG1-SPDIAG*TEMP(NM1))                                       CURV1.56
      YP(NN) = DIAGIN*(SLPPN-DX1-SPDIAG*YP(NM1))                                 CURV1.57
C                                                                                CURV1.58
C PERFORM BACK SUBSTITUTION                                                      CURV1.59
C                                                                                CURV1.60
      DO 50 I = 2, NN                                                            CURV1.61
         IBAK = NP1-I                                                            CURV1.62
         YP(IBAK) = YP(IBAK)-TEMP(IBAK)*YP(IBAK+1)                               CURV1.63
   50 CONTINUE                                                                   CURV1.64
      RETURN                                                                     CURV1.65
C                                                                                CURV1.66
   60 IF (NN.EQ.2) GO TO 70                                                      CURV1.67
C                                                                                CURV1.68
C IF NO DERIVATIVES ARE GIVEN USE SECOND ORDER POLYNOMIAL                        CURV1.69
C INTERPOLATION ON INPUT DATA FOR VALUES AT ENDPOINTS.                           CURV1.70
C                                                                                CURV1.71
      DELX2 = X(3)-X(2)                                                          CURV1.72
      DELX12 = X(3)-X(1)                                                         CURV1.73
      C1 = -(DELX12+DELX1)/DELX12/DELX1                                          CURV1.74
      C2 = DELX12/DELX1/DELX2                                                    CURV1.75
      C3 = -DELX1/DELX12/DELX2                                                   CURV1.76
      SLPP1 = C1*Y(1)+C2*Y(2)+C3*Y(3)                                            CURV1.77
      DELN = X(NN)-X(NM1)                                                        CURV1.78
      DELNM1 = X(NM1)-X(NN-2)                                                    CURV1.79
      DELNN = X(NN)-X(NN-2)                                                      CURV1.80
      C1 = (DELNN+DELN)/DELNN/DELN                                               CURV1.81
      C2 = -DELNN/DELN/DELNM1                                                    CURV1.82
      C3 = DELN/DELNN/DELNM1                                                     CURV1.83
      SLPPN = C3*Y(NN-2)+C2*Y(NM1)+C1*Y(NN)                                      CURV1.84
      GO TO 20                                                                   CURV1.85
C                                                                                CURV1.86
C IF ONLY TWO POINTS AND NO DERIVATIVES ARE GIVEN, USE                           CURV1.87
C STRAIGHT LINE FOR CURVE                                                        CURV1.88
C                                                                                CURV1.89
   70 YP(1) = 0.                                                                 CURV1.90
      YP(2) = 0.                                                                 CURV1.91
      RETURN                                                                     CURV1.92
C                                                                                CURV1.93
      END                                                                        CURV1.94
