      subroutine geth_idts (ndate, odate, idt)                                   DATE.1
                                                                                 DATE.2
C  This program is modified based on KWM's f90 code                              DATE.3
C  1.  geth_idts (ndate, odate, idts)                                            DATE.4
C  Get the time period between two dates.                                        DATE.5
                                                                                 DATE.6
      implicit none                                                              DATE.7
                                                                                 DATE.8
C  From 2 input mdates ('YYYY-MM-DD HH:MM:SS.ffff'),                             DATE.9
C  compute the time difference.                                                  DATE.10
                                                                                 DATE.11
C  on entry     -  ndate  -  the new hdate.                                      DATE.12
C                  odate  -  the old hdate.                                      DATE.13
                                                                                 DATE.14
C  on exit      -  idt    -  the change in time.                                 DATE.15
C                            Units depend on length of date strings.             DATE.16
                                                                                 DATE.17
      character*(*) ndate, odate                                                 DATE.18
      integer       idt                                                          DATE.19
                                                                                 DATE.20
C  Local Variables                                                               DATE.21
                                                                                 DATE.22
C  yrnew    -  indicates the year associated with "ndate"                        DATE.23
C  yrold    -  indicates the year associated with "odate"                        DATE.24
C  monew    -  indicates the month associated with "ndate"                       DATE.25
C  moold    -  indicates the month associated with "odate"                       DATE.26
C  dynew    -  indicates the day associated with "ndate"                         DATE.27
C  dyold    -  indicates the day associated with "odate"                         DATE.28
C  hrnew    -  indicates the hour associated with "ndate"                        DATE.29
C  hrold    -  indicates the hour associated with "odate"                        DATE.30
C  minew    -  indicates the minute associated with "ndate"                      DATE.31
C  miold    -  indicates the minute associated with "odate"                      DATE.32
C  scnew    -  indicates the second associated with "ndate"                      DATE.33
C  scold    -  indicates the second associated with "odate"                      DATE.34
C  i        -  loop counter                                                      DATE.35
C  mday     -  a list assigning the number of days in each month                 DATE.36
C  newhrs   -  the number of hours between "ndate" and 1901                      DATE.37
C              whole 24 hour days                                                DATE.38
C  oldhrs   -  the number of hours between "odate" and 1901                      DATE.39
                                                                                 DATE.40
      character*24 tdate                                                         DATE.41
CJM Capitalize LEN to avoid clash with M4 macro of same name                     DATE.42
      INTEGER LEN, olen, nlen                                                    DATE.43
      integer yrnew, monew, dynew, hrnew, minew, scnew, frnew                    DATE.44
      integer yrold, moold, dyold, hrold, miold, scold, frold                    DATE.45
      integer mday(12), i, newdys, olddys                                        DATE.46
      logical npass, opass                                                       DATE.47
      integer isign                                                              DATE.48
      integer ifrc                                                               DATE.49
                                                                                 DATE.50
      integer nfeb                                                               DATE.51
                                                                                 DATE.52
      olen = len(odate)                                                          DATE.53
      nlen = len(ndate)                                                          DATE.54
      if (nlen.ne.olen) then                                                     DATE.55
         write(*,'("GETH_IDTS: NLEN /= OLEN: ", A, 3x, A)')                      DATE.56
     &         ndate(1:nlen), odate(1:olen)                                      DATE.57
         stop 'char_len1'                                                        DATE.58
      endif                                                                      DATE.59
                                                                                 DATE.60
      if (odate.gt.ndate) then                                                   DATE.61
         isign = -1                                                              DATE.62
         tdate=ndate                                                             DATE.63
         ndate=odate                                                             DATE.64
         odate=tdate                                                             DATE.65
      else                                                                       DATE.66
         isign = 1                                                               DATE.67
      end if                                                                     DATE.68
                                                                                 DATE.69
C  Assign the number of days in a months                                         DATE.70
                                                                                 DATE.71
      mday( 1) = 31                                                              DATE.72
      mday( 2) = 28                                                              DATE.73
      mday( 3) = 31                                                              DATE.74
      mday( 4) = 30                                                              DATE.75
      mday( 5) = 31                                                              DATE.76
      mday( 6) = 30                                                              DATE.77
      mday( 7) = 31                                                              DATE.78
      mday( 8) = 31                                                              DATE.79
      mday( 9) = 30                                                              DATE.80
      mday(10) = 31                                                              DATE.81
      mday(11) = 30                                                              DATE.82
      mday(12) = 31                                                              DATE.83
                                                                                 DATE.84
C  Break down old hdate into parts                                               DATE.85
                                                                                 DATE.86
      hrold = 0                                                                  DATE.87
      miold = 0                                                                  DATE.88
      scold = 0                                                                  DATE.89
      frold = 0                                                                  DATE.90
                                                                                 DATE.91
      read(odate(1:4),  '(i4)') yrold                                            DATE.92
      read(odate(6:7),  '(i2)') moold                                            DATE.93
      read(odate(9:10), '(i2)') dyold                                            DATE.94
      if (olen.ge.13) then                                                       DATE.95
         read(odate(12:13),'(i2)') hrold                                         DATE.96
         if (olen.ge.16) then                                                    DATE.97
            read(odate(15:16),'(i2)') miold                                      DATE.98
            if (olen.ge.19) then                                                 DATE.99
               read(odate(18:19),'(i2)') scold                                   DATE.100
               if (olen.gt.20) then                                              DATE.101
                  if (olen.eq.21) then                                           DATE.102
                     read(odate(21:21),'(i1)') frold                             DATE.103
                  else if (olen.eq.22) then                                      DATE.104
                     read(odate(21:22),'(i2)') frold                             DATE.105
                  else if (olen.eq.23) then                                      DATE.106
                     read(odate(21:32),'(i3)') frold                             DATE.107
                  else if (olen.eq.24) then                                      DATE.108
                     read(odate(21:24),'(i4)') frold                             DATE.109
                  endif                                                          DATE.110
               end if                                                            DATE.111
            end if                                                               DATE.112
         end if                                                                  DATE.113
      end if                                                                     DATE.114
                                                                                 DATE.115
C  Break down new hdate into parts                                               DATE.116
                                                                                 DATE.117
      hrnew = 0                                                                  DATE.118
      minew = 0                                                                  DATE.119
      scnew = 0                                                                  DATE.120
      frnew = 0                                                                  DATE.121
                                                                                 DATE.122
      read(ndate(1:4),  '(i4)') yrnew                                            DATE.123
      read(ndate(6:7),  '(i2)') monew                                            DATE.124
      read(ndate(9:10), '(i2)') dynew                                            DATE.125
      if (nlen.ge.13) then                                                       DATE.126
         read(ndate(12:13),'(i2)') hrnew                                         DATE.127
         if (nlen.ge.16) then                                                    DATE.128
            read(ndate(15:16),'(i2)') minew                                      DATE.129
            if (nlen.ge.19) then                                                 DATE.130
               read(ndate(18:19),'(i2)') scnew                                   DATE.131
               if (nlen.gt.20) then                                              DATE.132
                  read(ndate(21:nlen),*) frnew                                   DATE.133
               end if                                                            DATE.134
            end if                                                               DATE.135
         end if                                                                  DATE.136
      end if                                                                     DATE.137
                                                                                 DATE.138
C  Check that the dates make sense.                                              DATE.139
                                                                                 DATE.140
      npass = .true.                                                             DATE.141
      opass = .true.                                                             DATE.142
                                                                                 DATE.143
C  Check that the month of NDATE makes sense.                                    DATE.144
                                                                                 DATE.145
      if ((monew.gt.12).or.(monew.lt.1)) then                                    DATE.146
         print*, 'GETH_IDTS:  Month of NDATE = ', monew                          DATE.147
         npass = .false.                                                         DATE.148
      end if                                                                     DATE.149
                                                                                 DATE.150
C  Check that the month of ODATE makes sense.                                    DATE.151
                                                                                 DATE.152
      if ((moold.gt.12).or.(moold.lt.1)) then                                    DATE.153
         print*, 'GETH_IDTS:  Month of ODATE = ', moold                          DATE.154
         opass = .false.                                                         DATE.155
      end if                                                                     DATE.156
                                                                                 DATE.157
C  Check that the day of NDATE makes sense.                                      DATE.158
                                                                                 DATE.159
      if (monew.ne.2) then                                                       DATE.160
C ...... For all months but February                                             DATE.161
         if ((dynew.gt.mday(monew)).or.(dynew.lt.1)) then                        DATE.162
            print*, 'GETH_IDTS:  Day of NDATE = ', dynew                         DATE.163
            npass = .false.                                                      DATE.164
         end if                                                                  DATE.165
      else if (monew.eq.2) then                                                  DATE.166
C ...... For February                                                            DATE.167
         if (mod(yrnew,4).eq.0) then   ! Leap Year                               DATE.168
            if ((dynew.gt.29).or.(dynew.lt.1)) then                              DATE.169
               print*, 'GETH_IDTS:  Day of NDATE = ', dynew                      DATE.170
               npass = .false.                                                   DATE.171
            end if                                                               DATE.172
         else                                                                    DATE.173
            if ((dynew.gt.28).or.(dynew.lt.1)) then    ! Not a leap year         DATE.174
               print*, 'GETH_IDTS:  Day of NDATE = ', dynew                      DATE.175
               STOP 'ndate_1'                                                    DATE.176
            end if                                                               DATE.177
         end if                                                                  DATE.178
      end if                                                                     DATE.179
                                                                                 DATE.180
C  Check that the day of ODATE makes sense.                                      DATE.181
                                                                                 DATE.182
      if (moold.ne.2) then                                                       DATE.183
C ...... For all months but February                                             DATE.184
         if ((dyold.gt.mday(moold)).or.(dyold.lt.1)) then                        DATE.185
            print*, 'GETH_IDTS:  Day of ODATE = ', dyold                         DATE.186
            opass = .false.                                                      DATE.187
         end if                                                                  DATE.188
      else if (moold.eq.2) then                                                  DATE.189
C ....... For February                                                           DATE.190
         if (mod(yrold,4).eq.0) then ! Leap Year                                 DATE.191
            if ((dyold.gt.29).or.(dyold.lt.1)) then                              DATE.192
               print*, 'GETH_IDTS:  Day of ODATE = ', dyold                      DATE.193
               opass = .false.                                                   DATE.194
            end if                                                               DATE.195
         else                                                                    DATE.196
            if ((dyold.gt.28).or.(dyold.lt.1)) then    ! Not a leap year         DATE.197
               print*, 'GETH_IDTS:  Day of ODATE = ', dyold                      DATE.198
               opass = .false.                                                   DATE.199
            end if                                                               DATE.200
         end if                                                                  DATE.201
      end if                                                                     DATE.202
                                                                                 DATE.203
C  Check that the hour of NDATE makes sense.                                     DATE.204
                                                                                 DATE.205
      if ((hrnew.gt.23).or.(hrnew.lt.0)) then                                    DATE.206
         print*, 'GETH_IDTS:  Hour of NDATE = ', hrnew                           DATE.207
         npass = .false.                                                         DATE.208
      end if                                                                     DATE.209
                                                                                 DATE.210
C  Check that the hour of ODATE makes sense.                                     DATE.211
                                                                                 DATE.212
      if ((hrold.gt.23).or.(hrold.lt.0)) then                                    DATE.213
         print*, 'GETH_IDTS:  Hour of ODATE = ', hrold                           DATE.214
         opass = .false.                                                         DATE.215
      end if                                                                     DATE.216
                                                                                 DATE.217
C  Check that the minute of NDATE makes sense.                                   DATE.218
                                                                                 DATE.219
      if ((minew.gt.59).or.(minew.lt.0)) then                                    DATE.220
         print*, 'GETH_IDTS:  Minute of NDATE = ', minew                         DATE.221
         npass = .false.                                                         DATE.222
      end if                                                                     DATE.223
                                                                                 DATE.224
C  Check that the minute of ODATE makes sense.                                   DATE.225
                                                                                 DATE.226
      if ((miold.gt.59).or.(miold.lt.0)) then                                    DATE.227
         print*, 'GETH_IDTS:  Minute of ODATE = ', miold                         DATE.228
         opass = .false.                                                         DATE.229
      end if                                                                     DATE.230
                                                                                 DATE.231
C  Check that the second of NDATE makes sense.                                   DATE.232
                                                                                 DATE.233
      if ((scnew.gt.59).or.(scnew.lt.0)) then                                    DATE.234
         print*, 'GETH_IDTS:  SECOND of NDATE = ', scnew                         DATE.235
         npass = .false.                                                         DATE.236
      end if                                                                     DATE.237
                                                                                 DATE.238
C  Check that the second of ODATE makes sense.                                   DATE.239
                                                                                 DATE.240
      if ((scold.gt.59).or.(scold.lt.0)) then                                    DATE.241
         print*, 'GETH_IDTS:  Second of ODATE = ', scold                         DATE.242
         opass = .false.                                                         DATE.243
      end if                                                                     DATE.244
                                                                                 DATE.245
      if (.not. npass) then                                                      DATE.246
         print*, 'Screwy NDATE: ', ndate(1:nlen)                                 DATE.247
         STOP 'ndate_2'                                                          DATE.248
      end if                                                                     DATE.249
                                                                                 DATE.250
      if (.not. opass) then                                                      DATE.251
         print*, 'Screwy ODATE: ', odate(1:olen)                                 DATE.252
         STOP 'odate_1'                                                          DATE.253
      end if                                                                     DATE.254
                                                                                 DATE.255
C  Date Checks are completed.  Continue.                                         DATE.256
                                                                                 DATE.257
C  Compute number of days from 1 January ODATE, 00:00:00 until ndate             DATE.258
C  Compute number of hours from 1 January ODATE, 00:00:00 until ndate            DATE.259
C  Compute number of minutes from 1 January ODATE, 00:00:00 until ndate          DATE.260
                                                                                 DATE.261
      newdys = 0                                                                 DATE.262
      do i = yrold, yrnew - 1                                                    DATE.263
         if (nfeb(i).eq.29) then                                                 DATE.264
            newdys = newdys + 366                                                DATE.265
         else                                                                    DATE.266
            newdys = newdys + 365                                                DATE.267
         end if                                                                  DATE.268
      end do                                                                     DATE.269
                                                                                 DATE.270
      if (monew .gt. 1) then                                                     DATE.271
         if (mod(yrnew, 4) .eq. 0) mday(2) = nfeb(yrnew)                         DATE.272
         do i = 1, monew - 1                                                     DATE.273
            newdys = newdys + mday(i)                                            DATE.274
         end do                                                                  DATE.275
         mday(2) = 28                                                            DATE.276
      end if                                                                     DATE.277
                                                                                 DATE.278
      newdys = newdys + dynew - 1                                                DATE.279
                                                                                 DATE.280
C  Compute number of hours from 1 January ODATE, 00:00:00 until odate            DATE.281
C  Compute number of minutes from 1 January ODATE, 00:00:00 until odate          DATE.282
                                                                                 DATE.283
      olddys = 0                                                                 DATE.284
                                                                                 DATE.285
      if (moold .gt. 1) then                                                     DATE.286
         if (mod(yrold, 4) .eq. 0) mday(2) = nfeb(yrold)                         DATE.287
         do i = 1, moold - 1                                                     DATE.288
            olddys = olddys + mday(i)                                            DATE.289
         end do                                                                  DATE.290
         mday(2) = 28                                                            DATE.291
      end if                                                                     DATE.292
                                                                                 DATE.293
      olddys = olddys + dyold -1                                                 DATE.294
                                                                                 DATE.295
C  Determine the time difference                                                 DATE.296
                                                                                 DATE.297
      idt = (newdys - olddys)                                                    DATE.298
      if (olen.gt.10) then                                                       DATE.299
         idt = idt*24 + (hrnew - hrold)                                          DATE.300
         if (olen.gt.13) then                                                    DATE.301
            idt = idt*60 + (minew - miold)                                       DATE.302
            if (olen.gt.16) then                                                 DATE.303
               idt = idt*60 + (scnew - scold)                                    DATE.304
               if (olen.gt.20) then                                              DATE.305
                  ifrc = olen-20                                                 DATE.306
                  ifrc = 10**ifrc                                                DATE.307
                  idt = idt * ifrc + (frnew-frold)                               DATE.308
               endif                                                             DATE.309
            endif                                                                DATE.310
         endif                                                                   DATE.311
      endif                                                                      DATE.312
                                                                                 DATE.313
      if (isign .eq. -1) then                                                    DATE.314
         tdate=ndate                                                             DATE.315
         ndate=odate                                                             DATE.316
         odate=tdate                                                             DATE.317
         idt = idt * isign                                                       DATE.318
      end if                                                                     DATE.319
                                                                                 DATE.320
      return                                                                     DATE.321
      end                                                                        DATE.322
                                                                                 DATE.323
C end subroutine geth_idts                                                       DATE.324
                                                                                 DATE.325
      subroutine geth_newdate (ndate, odate, idt)                                DATE.326
                                                                                 DATE.327
C  This program is modified based on KWM's f90 code                              DATE.328
C  2. geth_newdate ( ndate, odate, idts)                                         DATE.329
C  Get the new date based on the old date and a time difference.                 DATE.330
                                                                                 DATE.331
      implicit none                                                              DATE.332
                                                                                 DATE.333
C  From old date ('YYYY-MM-DD HH:MM:SS.ffff') and                                DATE.334
C  delta-time, compute the new date.                                             DATE.335
                                                                                 DATE.336
C  on entry     -  odate  -  the old hdate.                                      DATE.337
C                  idt    -  the change in time                                  DATE.338
                                                                                 DATE.339
C  on exit      -  ndate  -  the new hdate.                                      DATE.340
                                                                                 DATE.341
      integer idt                                                                DATE.342
      character*(*) ndate                                                        DATE.343
      character*(*) odate                                                        DATE.344
                                                                                 DATE.345
C  Local Variables                                                               DATE.346
                                                                                 DATE.347
C  yrold    -  indicates the year associated with "odate"                        DATE.348
C  moold    -  indicates the month associated with "odate"                       DATE.349
C  dyold    -  indicates the day associated with "odate"                         DATE.350
C  hrold    -  indicates the hour associated with "odate"                        DATE.351
C  miold    -  indicates the minute associated with "odate"                      DATE.352
C  scold    -  indicates the second associated with "odate"                      DATE.353
                                                                                 DATE.354
C  yrnew    -  indicates the year associated with "ndate"                        DATE.355
C  monew    -  indicates the month associated with "ndate"                       DATE.356
C  dynew    -  indicates the day associated with "ndate"                         DATE.357
C  hrnew    -  indicates the hour associated with "ndate"                        DATE.358
C  minew    -  indicates the minute associated with "ndate"                      DATE.359
C  scnew    -  indicates the second associated with "ndate"                      DATE.360
                                                                                 DATE.361
C  mday     -  a list assigning the number of days in each month                 DATE.362
                                                                                 DATE.363
C  i        -  loop counter                                                      DATE.364
C  nday     -  the integer number of days represented by "idt"                   DATE.365
C  nhour    -  the integer number of hours in "idt" after taking out             DATE.366
C              all the whole days                                                DATE.367
C  nmin     -  the integer number of minutes in "idt" after taking out           DATE.368
C              all the whole days and whole hours.                               DATE.369
C  nsec     -  the integer number of minutes in "idt" after taking out           DATE.370
C              all the whole days, whole hours, and whole minutes.               DATE.371
                                                                                 DATE.372
CJM Capitalize LEN to avoid clash with M4 macro of same name                     DATE.373
      INTEGER LEN, nlen, olen                                                    DATE.374
      integer yrnew, monew, dynew, hrnew, minew, scnew, frnew                    DATE.375
      integer yrold, moold, dyold, hrold, miold, scold, frold                    DATE.376
      integer mday(12), nday, nhour, nmin, nsec, nfrac, i, ifrc                  DATE.377
      logical opass                                                              DATE.378
      character*10 hfrc                                                          DATE.379
      character*1  sp                                                            DATE.380
      integer nfeb                                                               DATE.381
                                                                                 DATE.382
C  Assign the number of days in a months                                         DATE.383
                                                                                 DATE.384
      mday( 1) = 31                                                              DATE.385
      mday( 2) = 28                                                              DATE.386
      mday( 3) = 31                                                              DATE.387
      mday( 4) = 30                                                              DATE.388
      mday( 5) = 31                                                              DATE.389
      mday( 6) = 30                                                              DATE.390
      mday( 7) = 31                                                              DATE.391
      mday( 8) = 31                                                              DATE.392
      mday( 9) = 30                                                              DATE.393
      mday(10) = 31                                                              DATE.394
      mday(11) = 30                                                              DATE.395
      mday(12) = 31                                                              DATE.396
                                                                                 DATE.397
C  Break down old hdate into parts                                               DATE.398
                                                                                 DATE.399
      hrold = 0                                                                  DATE.400
      miold = 0                                                                  DATE.401
      scold = 0                                                                  DATE.402
      frold = 0                                                                  DATE.403
      olen = LEN(odate)                                                          DATE.404
      if (olen.ge.11) then                                                       DATE.405
         sp = odate(11:11)                                                       DATE.406
      else                                                                       DATE.407
         sp = ' '                                                                DATE.408
      end if                                                                     DATE.409
                                                                                 DATE.410
C  Use internal READ statements to convert the CHARACTER string                  DATE.411
C  date into INTEGER components.                                                 DATE.412
                                                                                 DATE.413
      read(odate(1:4),  '(i4)') yrold                                            DATE.414
      read(odate(6:7),  '(i2)') moold                                            DATE.415
      read(odate(9:10), '(i2)') dyold                                            DATE.416
      if (olen.ge.13) then                                                       DATE.417
         read(odate(12:13),'(i2)') hrold                                         DATE.418
         if (olen.ge.16) then                                                    DATE.419
            read(odate(15:16),'(i2)') miold                                      DATE.420
            if (olen.ge.19) then                                                 DATE.421
               read(odate(18:19),'(i2)') scold                                   DATE.422
               if (olen.gt.20) then                                              DATE.423
                  read(odate(21:olen),*) frold                                   DATE.424
               end if                                                            DATE.425
            end if                                                               DATE.426
         end if                                                                  DATE.427
      end if                                                                     DATE.428
                                                                                 DATE.429
C  Set the number of days in February for that year.                             DATE.430
                                                                                 DATE.431
      mday(2) = nfeb(yrold)                                                      DATE.432
                                                                                 DATE.433
C  Check that ODATE makes sense.                                                 DATE.434
                                                                                 DATE.435
      opass = .TRUE.                                                             DATE.436
                                                                                 DATE.437
C  Check that the month of ODATE makes sense.                                    DATE.438
                                                                                 DATE.439
      if ((moold.gt.12).or.(moold.lt.1)) then                                    DATE.440
         write(*,*) 'GETH_NEWDATE:  Month of ODATE = ', moold                    DATE.441
         opass = .FALSE.                                                         DATE.442
      end if                                                                     DATE.443
                                                                                 DATE.444
C  Check that the day of ODATE makes sense.                                      DATE.445
                                                                                 DATE.446
      if ((dyold.gt.mday(moold)).or.(dyold.lt.1)) then                           DATE.447
         write(*,*) 'GETH_NEWDATE:  Day of ODATE = ', dyold                      DATE.448
         opass = .FALSE.                                                         DATE.449
      end if                                                                     DATE.450
                                                                                 DATE.451
C  Check that the hour of ODATE makes sense.                                     DATE.452
                                                                                 DATE.453
      if ((hrold.gt.23).or.(hrold.lt.0)) then                                    DATE.454
         write(*,*) 'GETH_NEWDATE:  Hour of ODATE = ', hrold                     DATE.455
         opass = .FALSE.                                                         DATE.456
      end if                                                                     DATE.457
                                                                                 DATE.458
C  Check that the minute of ODATE makes sense.                                   DATE.459
                                                                                 DATE.460
      if ((miold.gt.59).or.(miold.lt.0)) then                                    DATE.461
         write(*,*) 'GETH_NEWDATE:  Minute of ODATE = ', miold                   DATE.462
         opass = .FALSE.                                                         DATE.463
      end if                                                                     DATE.464
                                                                                 DATE.465
C  Check that the second of ODATE makes sense.                                   DATE.466
                                                                                 DATE.467
      if ((scold.gt.59).or.(scold.lt.0)) then                                    DATE.468
         write(*,*) 'GETH_NEWDATE:  Second of ODATE = ', scold                   DATE.469
         opass = .FALSE.                                                         DATE.470
      end if                                                                     DATE.471
                                                                                 DATE.472
C  Check that the fractional part  of ODATE makes sense.                         DATE.473
                                                                                 DATE.474
C!KWM      IF ((scold.GT.59).or.(scold.LT.0)) THEN                               DATE.475
C!KWM         WRITE(*,*) 'GETH_NEWDATE:  Second of ODATE = ', scold              DATE.476
C!KWM         opass = .FALSE.                                                    DATE.477
C!KWM      END IF                                                                DATE.478
                                                                                 DATE.479
      if (.not.opass) then                                                       DATE.480
         write(*,*) 'Crazy ODATE: ', odate(1:olen), olen                         DATE.481
         STOP 'odate_3'                                                          DATE.482
      end if                                                                     DATE.483
                                                                                 DATE.484
C  Date Checks are completed.  Continue.                                         DATE.485
                                                                                 DATE.486
C  Compute the number of days, hours, minutes, and seconds in idt                DATE.487
                                                                                 DATE.488
      if (olen.gt.20) then !idt should be in fractions of seconds                DATE.489
         ifrc = olen-20                                                          DATE.490
         ifrc = 10**ifrc                                                         DATE.491
         nday   = abs(idt)/(86400*ifrc)                                          DATE.492
         nhour  = mod(abs(idt),86400*ifrc)/(3600*ifrc)                           DATE.493
         nmin   = mod(abs(idt),3600*ifrc)/(60*ifrc)                              DATE.494
         nsec   = mod(abs(idt),60*ifrc)/(ifrc)                                   DATE.495
         nfrac = mod(abs(idt), ifrc)                                             DATE.496
      else if (olen.eq.19) then  !idt should be in seconds                       DATE.497
         ifrc = 1                                                                DATE.498
         nday   = abs(idt)/86400 ! integer number of days in delta-time          DATE.499
         nhour  = mod(abs(idt),86400)/3600                                       DATE.500
         nmin   = mod(abs(idt),3600)/60                                          DATE.501
         nsec   = mod(abs(idt),60)                                               DATE.502
         nfrac  = 0                                                              DATE.503
      else if (olen.eq.16) then !idt should be in minutes                        DATE.504
         ifrc = 1                                                                DATE.505
         nday   = abs(idt)/1440 ! integer number of days in delta-time           DATE.506
         nhour  = mod(abs(idt),1440)/60                                          DATE.507
         nmin   = mod(abs(idt),60)                                               DATE.508
         nsec   = 0                                                              DATE.509
         nfrac  = 0                                                              DATE.510
      else if (olen.eq.13) then !idt should be in hours                          DATE.511
         ifrc = 1                                                                DATE.512
         nday   = abs(idt)/24 ! integer number of days in delta-time             DATE.513
         nhour  = mod(abs(idt),24)                                               DATE.514
         nmin   = 0                                                              DATE.515
         nsec   = 0                                                              DATE.516
         nfrac  = 0                                                              DATE.517
      else if (olen.eq.10) then !idt should be in days                           DATE.518
         ifrc = 1                                                                DATE.519
         nday   = abs(idt)    ! integer number of days in delta-time             DATE.520
         nhour  = 0                                                              DATE.521
         nmin   = 0                                                              DATE.522
         nsec   = 0                                                              DATE.523
         nfrac  = 0                                                              DATE.524
      else                                                                       DATE.525
         write(*,'("GETH_NEWDATE: Strange length for ODATE: ", i3)')             DATE.526
     &         olen                                                              DATE.527
         stop 'odate_4'                                                          DATE.528
      end if                                                                     DATE.529
                                                                                 DATE.530
      if (idt.ge.0) then                                                         DATE.531
                                                                                 DATE.532
         frnew = frold + nfrac                                                   DATE.533
         if (frnew.ge.ifrc) then                                                 DATE.534
            frnew = frnew - ifrc                                                 DATE.535
            nsec = nsec + 1                                                      DATE.536
         end if                                                                  DATE.537
                                                                                 DATE.538
         scnew = scold + nsec                                                    DATE.539
         if (scnew .ge. 60) then                                                 DATE.540
            scnew = scnew - 60                                                   DATE.541
            nmin  = nmin + 1                                                     DATE.542
         end if                                                                  DATE.543
                                                                                 DATE.544
         minew = miold + nmin                                                    DATE.545
         if (minew .ge. 60) then                                                 DATE.546
            minew = minew - 60                                                   DATE.547
            nhour  = nhour + 1                                                   DATE.548
         end if                                                                  DATE.549
                                                                                 DATE.550
         hrnew = hrold + nhour                                                   DATE.551
         if (hrnew .ge. 24) then                                                 DATE.552
            hrnew = hrnew - 24                                                   DATE.553
            nday  = nday + 1                                                     DATE.554
         end if                                                                  DATE.555
                                                                                 DATE.556
         dynew = dyold                                                           DATE.557
         monew = moold                                                           DATE.558
         yrnew = yrold                                                           DATE.559
         do i = 1, nday                                                          DATE.560
            dynew = dynew + 1                                                    DATE.561
            if (dynew.gt.mday(monew)) then                                       DATE.562
               dynew = dynew - mday(monew)                                       DATE.563
               monew = monew + 1                                                 DATE.564
               if (monew .gt. 12) then                                           DATE.565
                  monew = 1                                                      DATE.566
                  yrnew = yrnew + 1                                              DATE.567
C        If the year changes, recompute the number of days in February           DATE.568
                  mday(2) = nfeb(yrnew)                                          DATE.569
               end if                                                            DATE.570
            end if                                                               DATE.571
         end do                                                                  DATE.572
                                                                                 DATE.573
      else if (idt.lt.0) then                                                    DATE.574
                                                                                 DATE.575
         frnew = frold - nfrac                                                   DATE.576
         if (frnew .lt. 0) then                                                  DATE.577
            frnew = frnew + ifrc                                                 DATE.578
            nsec = nsec + 1                                                      DATE.579
         end if                                                                  DATE.580
                                                                                 DATE.581
         scnew = scold - nsec                                                    DATE.582
         if (scnew .lt. 00) then                                                 DATE.583
            scnew = scnew + 60                                                   DATE.584
            nmin  = nmin + 1                                                     DATE.585
         end if                                                                  DATE.586
                                                                                 DATE.587
         minew = miold - nmin                                                    DATE.588
         if (minew .lt. 00) then                                                 DATE.589
            minew = minew + 60                                                   DATE.590
            nhour  = nhour + 1                                                   DATE.591
         end if                                                                  DATE.592
                                                                                 DATE.593
         hrnew = hrold - nhour                                                   DATE.594
         if (hrnew .lt. 00) then                                                 DATE.595
            hrnew = hrnew + 24                                                   DATE.596
            nday  = nday + 1                                                     DATE.597
         end if                                                                  DATE.598
                                                                                 DATE.599
         dynew = dyold                                                           DATE.600
         monew = moold                                                           DATE.601
         yrnew = yrold                                                           DATE.602
         do i = 1, nday                                                          DATE.603
            dynew = dynew - 1                                                    DATE.604
            if (dynew.eq.0) then                                                 DATE.605
               monew = monew - 1                                                 DATE.606
               if (monew.eq.0) then                                              DATE.607
                  monew = 12                                                     DATE.608
                  yrnew = yrnew - 1                                              DATE.609
C        If the year changes, recompute the number of days in February           DATE.610
                  mday(2) = nfeb(yrnew)                                          DATE.611
               end if                                                            DATE.612
               dynew = mday(monew)                                               DATE.613
            end if                                                               DATE.614
         end do                                                                  DATE.615
      end if                                                                     DATE.616
                                                                                 DATE.617
C  Now construct the new mdate                                                   DATE.618
                                                                                 DATE.619
      nlen = LEN(ndate)                                                          DATE.620
                                                                                 DATE.621
      if (nlen.gt.20) then                                                       DATE.622
         write(ndate(1:19),19) yrnew, monew, dynew, hrnew, minew, scnew          DATE.623
         write(hfrc,'(i10)') frnew+1000000000                                    DATE.624
         ndate = ndate(1:19)//'.'//hfrc(31-nlen:10)                              DATE.625
                                                                                 DATE.626
      else if (nlen.eq.19.or.nlen.eq.20) then                                    DATE.627
         write(ndate(1:19),19) yrnew, monew, dynew, hrnew, minew, scnew          DATE.628
19    format(i4,'-',i2.2,'-',i2.2,'_',i2.2,':',i2.2,':',i2.2)                    DATE.629
         if (nlen.eq.20) ndate = ndate(1:19)//'.'                                DATE.630
                                                                                 DATE.631
      else if (nlen.eq.16) then                                                  DATE.632
         write(ndate,16) yrnew, monew, dynew, hrnew, minew                       DATE.633
16    format(i4,'-',i2.2,'-',i2.2,'_',i2.2,':',i2.2)                             DATE.634
                                                                                 DATE.635
      else if (nlen.eq.13) then                                                  DATE.636
         write(ndate,13) yrnew, monew, dynew, hrnew                              DATE.637
13    format(i4,'-',i2.2,'-',i2.2,'_',i2.2)                                      DATE.638
                                                                                 DATE.639
      else if (nlen.eq.10) then                                                  DATE.640
         write(ndate,10) yrnew, monew, dynew                                     DATE.641
10    format(i4,'-',i2.2,'-',i2.2)                                               DATE.642
                                                                                 DATE.643
      end if                                                                     DATE.644
                                                                                 DATE.645
      if (olen.ge.11) ndate(11:11) = sp                                          DATE.646
                                                                                 DATE.647
      return                                                                     DATE.648
      end                                                                        DATE.649
                                                                                 DATE.650
C end subroutine geth_newdate                                                    DATE.651
                                                                                 DATE.652
      integer function nfeb(year)                                                DATE.653
C Compute the number of days in February for the given year                      DATE.654
      implicit none                                                              DATE.655
      integer year                                                               DATE.656
                                                                                 DATE.657
      nfeb = 28 ! By default, February has 28 days ...                           DATE.658
      if (mod(year,4).eq.0) then                                                 DATE.659
         nfeb = 29  ! But every four years, it has 29 days ...                   DATE.660
         if (mod(year,100).eq.0) then                                            DATE.661
            nfeb = 28  ! Except every 100 years, when it has 28 days ...         DATE.662
            if (mod(year,400).eq.0) then                                         DATE.663
               nfeb = 29  ! Except every 400 years, when it has 29 days.         DATE.664
               if (mod(year,3600).eq.0) then                                     DATE.665
                  nfeb = 28  ! Except every 3600 years, when it has 28 days.     DATE.666
               endif                                                             DATE.667
            endif                                                                DATE.668
         endif                                                                   DATE.669
      endif                                                                      DATE.670
      return                                                                     DATE.671
      end                                                                        DATE.672
                                                                                 DATE.673
C end function nfeb                                                              DATE.674
                                                                                 DATE.675
      SUBROUTINE split_date_char ( date , century_year , month , day ,           DATE.676
     -           hour , minute , second )                                        DATE.677
                                                                                 DATE.678
C  This program is modified based on DOG's f90 code                              DATE.679
C  3. split_date_char ( date , century_year , month , day , hour , minute , seco DATE.680
C  Given the date, return the integer components.                                DATE.681
                                                                                 DATE.682
      IMPLICIT NONE                                                              DATE.683
                                                                                 DATE.684
C        Input data.                                                             DATE.685
                                                                                 DATE.686
      CHARACTER*24 date                                                          DATE.687
                                                                                 DATE.688
C        Output data.                                                            DATE.689
                                                                                 DATE.690
      INTEGER century_year , month , day , hour , minute , second                DATE.691
                                                                                 DATE.692
      READ(date,FMT='(    I4.4)') century_year                                   DATE.693
      READ(date,FMT='( 5X,I2.2)') month                                          DATE.694
      READ(date,FMT='( 8X,I2.2)') day                                            DATE.695
      READ(date,FMT='(11X,I2.2)') hour                                           DATE.696
      READ(date,FMT='(14X,I2.2)') minute                                         DATE.697
      READ(date,FMT='(17X,I2.2)') second                                         DATE.698
                                                                                 DATE.699
      RETURN                                                                     DATE.700
      END                                                                        DATE.701
                                                                                 DATE.702
C  END SUBROUTINE split_date_char                                                DATE.703
