      SUBROUTINE DELTATIM(MDATENEW,MDATEOLD,DTS,METHOD,                          DELTATIM.1
     *   NY,NM,ND,NH,NI,JULDAYO,JULDAYN)                                         DELTATIM.2
C                                                                                DELTATIM.3
C     SECTION  TOOLS                                                             DELTATIM.4
C     PURPOSE  METHOD 1: FROM 2 INPUT MDATES (YYMMDDHH), COMPUTE THE             DELTATIM.5
C              TIME DIFFERENCE IN SECONDS                                        DELTATIM.6
C              METHOD 2: FROM 2 INITIAL MDATE (YYMMDDHH) AND TIME                DELTATIM.7
C              INCREMENT IN SECONDS, COMPUTE NEW MDATE                           DELTATIM.8
C              CODE WILL WORK WITH YYMMDDHH OR YYMMDDHHMM FORMAT FOR             DELTATIM.9
C              MDATE                                                             DELTATIM.10
C                                                                                DELTATIM.11
      INTEGER YEARNEW,MONTHNEW,DAYNEW,HOURNEW,MINNEW                             DELTATIM.12
      INTEGER YEAROLD,MONTHOLD,DAYOLD,HOUROLD,MINOLD                             DELTATIM.13
C                                                                                DELTATIM.14
      DIMENSION MDAY(12)                                                         DELTATIM.15
      MDAY( 1)=31                                                                DELTATIM.16
      MDAY( 2)=28                                                                DELTATIM.17
      MDAY( 3)=31                                                                DELTATIM.18
      MDAY( 4)=30                                                                DELTATIM.19
      MDAY( 5)=31                                                                DELTATIM.20
      MDAY( 6)=30                                                                DELTATIM.21
      MDAY( 7)=31                                                                DELTATIM.22
      MDAY( 8)=31                                                                DELTATIM.23
      MDAY( 9)=30                                                                DELTATIM.24
      MDAY(10)=31                                                                DELTATIM.25
      MDAY(11)=30                                                                DELTATIM.26
      MDAY(12)=31                                                                DELTATIM.27
C                                                                                DELTATIM.28
C     ... IF METHOD=1, THEN NEWMDATE - OLDMDATE ---> TIME IN SECONDS             DELTATIM.29
C                                                                                DELTATIM.30
      IF(METHOD.EQ.1) THEN                                                       DELTATIM.31
C                                                                                DELTATIM.32
C        ... ALLOW FOR YYMMDDHHMM                                                DELTATIM.33
C                                                                                DELTATIM.34
         IF(MDATEOLD.LT.1E9) THEN                                                DELTATIM.35
C                                                                                DELTATIM.36
C           ... DECOMPOSE MDATE INTO YEAR, MONTH, DAY, HOUR AND MINUTE           DELTATIM.37
C                                                                                DELTATIM.38
            YEARNEW=MDATENEW/1000000                                             DELTATIM.39
            MONTHNEW=(MDATENEW-YEARNEW*1000000)/10000                            DELTATIM.40
            DAYNEW=(MDATENEW-YEARNEW*1000000-MONTHNEW*10000)/100                 DELTATIM.41
            HOURNEW=(MDATENEW-YEARNEW*1000000-MONTHNEW*10000-DAYNEW*100)         DELTATIM.42
            MINNEW=0                                                             DELTATIM.43
C                                                                                DELTATIM.44
            YEAROLD=MDATEOLD/1000000                                             DELTATIM.45
            MONTHOLD=(MDATEOLD-YEAROLD*1000000)/10000                            DELTATIM.46
            DAYOLD=(MDATEOLD-YEAROLD*1000000-MONTHOLD*10000)/100                 DELTATIM.47
            HOUROLD=(MDATEOLD-YEAROLD*1000000-MONTHOLD*10000-DAYOLD*100)         DELTATIM.48
            MINOLD=0                                                             DELTATIM.49
         ELSE IF(MDATEOLD.GT.1E9) THEN                                           DELTATIM.50
C                                                                                DELTATIM.51
C           ... DECOMPOSE MDATE INTO YEAR, MONTH, DAY, HOUR AND MINUTE           DELTATIM.52
C                                                                                DELTATIM.53
            YEARNEW=  MDATENEW                    /100000000                     DELTATIM.54
            MONTHNEW=(MDATENEW-YEARNEW*100000000) /1000000                       DELTATIM.55
            DAYNEW=  (MDATENEW-YEARNEW*100000000-MONTHNEW*1000000)               DELTATIM.56
     *                                            /10000                         DELTATIM.57
            HOURNEW= (MDATENEW-YEARNEW*100000000-MONTHNEW*1000000-               DELTATIM.58
     *                DAYNEW*10000)               /100                           DELTATIM.59
            MINNEW=  (MDATENEW-YEARNEW*100000000-MONTHNEW*1000000-               DELTATIM.60
     *                DAYNEW*10000-HOURNEW*100)                                  DELTATIM.61
C                                                                                DELTATIM.62
            YEAROLD=  MDATEOLD                    /100000000                     DELTATIM.63
            MONTHOLD=(MDATEOLD-YEAROLD*100000000) /1000000                       DELTATIM.64
            DAYOLD=  (MDATEOLD-YEAROLD*100000000-MONTHOLD*1000000)               DELTATIM.65
     *                                            /10000                         DELTATIM.66
            HOUROLD= (MDATEOLD-YEAROLD*100000000-MONTHOLD*1000000-               DELTATIM.67
     *                DAYOLD*10000)               /100                           DELTATIM.68
            MINOLD=  (MDATEOLD-YEAROLD*100000000-MONTHOLD*1000000-               DELTATIM.69
     *                DAYOLD*10000-HOUROLD*100)                                  DELTATIM.70
         END IF                                                                  DELTATIM.71
C                                                                                DELTATIM.72
C        ... COMPUTE NUMBER OF MINUTES FROM 1901 UNTIL MDATENEW                  DELTATIM.73
C                                                                                DELTATIM.74
         JULDAYN=0                                                               DELTATIM.75
         IMINNEW=0                                                               DELTATIM.76
         DO 100 IYR=1901,1900+YEARNEW-1                                          DELTATIM.77
            IF(MOD(IYR,4).NE.0) THEN                                             DELTATIM.78
               IMINNEW=IMINNEW+365*24*60                                         DELTATIM.79
            ELSE                                                                 DELTATIM.80
               IMINNEW=IMINNEW+366*24*60                                         DELTATIM.81
            END IF                                                               DELTATIM.82
100      CONTINUE                                                                DELTATIM.83
         IF(MONTHNEW.GT.1) THEN                                                  DELTATIM.84
            IF(MOD(YEARNEW,4).EQ.0) MDAY(2)=29                                   DELTATIM.85
            DO 200 IMON=1,MONTHNEW-1                                             DELTATIM.86
               IMINNEW=IMINNEW+MDAY(IMON)*24*60                                  DELTATIM.87
               JULDAYN=JULDAYN+MDAY(IMON)                                        DELTATIM.88
200         CONTINUE                                                             DELTATIM.89
            MDAY(2)=28                                                           DELTATIM.90
         END IF                                                                  DELTATIM.91
         IF(DAYNEW.GT.1) THEN                                                    DELTATIM.92
            DO 300 IDAY=1,DAYNEW-1                                               DELTATIM.93
               IMINNEW=IMINNEW+24*60                                             DELTATIM.94
               JULDAYN=JULDAYN+1                                                 DELTATIM.95
300         CONTINUE                                                             DELTATIM.96
         END IF                                                                  DELTATIM.97
         JULDAYN=JULDAYN+1                                                       DELTATIM.98
         DO 400 IHRS=0,HOURNEW                                                   DELTATIM.99
            IMINNEW=IMINNEW+60                                                   DELTATIM.100
400      CONTINUE                                                                DELTATIM.101
         IMINNEW=IMINNEW+MINNEW                                                  DELTATIM.102
C                                                                                DELTATIM.103
C        ... COMPUTE NUMBER OF MINUTES FROM 1901 UNTIL MDATEOLD                  DELTATIM.104
C                                                                                DELTATIM.105
         IMINOLD=0                                                               DELTATIM.106
         JULDAYO=0                                                               DELTATIM.107
         DO 500 IYR=1901,1900+YEAROLD-1                                          DELTATIM.108
            IF(MOD(IYR,4).NE.0) THEN                                             DELTATIM.109
               IMINOLD=IMINOLD+365*24*60                                         DELTATIM.110
            ELSE                                                                 DELTATIM.111
               IMINOLD=IMINOLD+366*24*60                                         DELTATIM.112
            END IF                                                               DELTATIM.113
500      CONTINUE                                                                DELTATIM.114
         IF(MONTHOLD.GT.1) THEN                                                  DELTATIM.115
            IF(MOD(YEAROLD,4).EQ.0) MDAY(2)=29                                   DELTATIM.116
            DO 600 IMON=1,MONTHOLD-1                                             DELTATIM.117
               IMINOLD=IMINOLD+MDAY(IMON)*24*60                                  DELTATIM.118
               JULDAYO=JULDAYO+MDAY(IMON)                                        DELTATIM.119
600         CONTINUE                                                             DELTATIM.120
            MDAY(2)=28                                                           DELTATIM.121
         END IF                                                                  DELTATIM.122
         IF(DAYOLD.GT.1) THEN                                                    DELTATIM.123
            DO 700 IDAY=1,DAYOLD-1                                               DELTATIM.124
               IMINOLD=IMINOLD+24*60                                             DELTATIM.125
               JULDAYO=JULDAYO+1                                                 DELTATIM.126
700         CONTINUE                                                             DELTATIM.127
         END IF                                                                  DELTATIM.128
         JULDAYO=JULDAYO+1                                                       DELTATIM.129
         DO 800 IHRS=0,HOUROLD                                                   DELTATIM.130
            IMINOLD=IMINOLD+60                                                   DELTATIM.131
800      CONTINUE                                                                DELTATIM.132
         IMINOLD=IMINOLD+MINOLD                                                  DELTATIM.133
C                                                                                DELTATIM.134
C        ... TIME DIFFERENCE IN SECONDS                                          DELTATIM.135
C                                                                                DELTATIM.136
         DTS=FLOAT(IMINNEW-IMINOLD)*60.                                          DELTATIM.137
         IF(DTS.LT.0.) THEN                                                      DELTATIM.138
            PRINT *,'TIME DIFFERENCE BETWEEN MDATES IS NEGATIVE'                 DELTATIM.139
         END IF                                                                  DELTATIM.140
         NY=YEARNEW                                                              DELTATIM.141
         NM=MONTHNEW                                                             DELTATIM.142
         ND=DAYNEW                                                               DELTATIM.143
         NH=HOURNEW                                                              DELTATIM.144
         NI=MINNEW                                                               DELTATIM.145
C                                                                                DELTATIM.146
C     ... IF METHOD=2, THEN OLDMDATE + TIME(SECONDS) ---> NEWMDATE               DELTATIM.147
C                                                                                DELTATIM.148
      ELSE IF(METHOD.EQ.2) THEN                                                  DELTATIM.149
C                                                                                DELTATIM.150
C        ... ALLOW FOR YYMMDDHHMM                                                DELTATIM.151
C                                                                                DELTATIM.152
         IF(MDATEOLD.LT.1E9) THEN                                                DELTATIM.153
C                                                                                DELTATIM.154
C           ... DECOMPOSE MDATE INTO YEAR, MONTH, DAY, HOUR AND MINUTE           DELTATIM.155
C                                                                                DELTATIM.156
            YEAROLD=MDATEOLD/1000000                                             DELTATIM.157
            MONTHOLD=(MDATEOLD-YEAROLD*1000000)/10000                            DELTATIM.158
            DAYOLD=(MDATEOLD-YEAROLD*1000000-MONTHOLD*10000)/100                 DELTATIM.159
            HOUROLD=(MDATEOLD-YEAROLD*1000000-MONTHOLD*10000-DAYOLD*100)         DELTATIM.160
            MINOLD=0                                                             DELTATIM.161
         ELSE IF(MDATEOLD.GT.1E9) THEN                                           DELTATIM.162
C                                                                                DELTATIM.163
C           ... DECOMPOSE MDATE INTO YEAR, MONTH, DAY, HOUR AND MINUTE           DELTATIM.164
C                                                                                DELTATIM.165
            YEAROLD=  MDATEOLD                    /100000000                     DELTATIM.166
            MONTHOLD=(MDATEOLD-YEAROLD*100000000) /1000000                       DELTATIM.167
            DAYOLD=  (MDATEOLD-YEAROLD*100000000-MONTHOLD*1000000)               DELTATIM.168
     *                                            /10000                         DELTATIM.169
            HOUROLD= (MDATEOLD-YEAROLD*100000000-MONTHOLD*1000000-               DELTATIM.170
     *                DAYOLD*10000)               /100                           DELTATIM.171
            MINOLD=  (MDATEOLD-YEAROLD*100000000-MONTHOLD*1000000-               DELTATIM.172
     *                DAYOLD*10000-HOUROLD*100)                                  DELTATIM.173
         END IF                                                                  DELTATIM.174
C                                                                                DELTATIM.175
C        ... DELTA TIME IN SECONDS INTO MINUTES, HOURS, MONTHS, YEARS            DELTATIM.176
C                                                                                DELTATIM.177
         NHOUR=INT(DTS/(60.*60.)+ 0.000001)                                      DELTATIM.178
         NMIN =INT(DTS/ 60. -FLOAT(NHOUR)*60. + 0.000001)                        DELTATIM.179
         MINNEW=MINOLD+NMIN                                                      DELTATIM.180
         IF(MINNEW.GE.60) THEN                                                   DELTATIM.181
            MINNEW=MINNEW-60                                                     DELTATIM.182
            HOUROLD=HOUROLD+1                                                    DELTATIM.183
         END IF                                                                  DELTATIM.184
C                                                                                DELTATIM.185
         NDAY =INT(DTS/(24.*60.*60.) + 0.00001)                                  DELTATIM.186
         NHOUR=INT(DTS/(60.*60.)-FLOAT(NDAY)*24. + 0.000001)                     DELTATIM.187
         HOURNEW=HOUROLD + NHOUR                                                 DELTATIM.188
         IF(HOURNEW.GE.24) THEN                                                  DELTATIM.189
            HOURNEW=HOURNEW-24                                                   DELTATIM.190
            NDAY=NDAY+1                                                          DELTATIM.191
         END IF                                                                  DELTATIM.192
C                                                                                DELTATIM.193
         DAYNEW=DAYOLD + NDAY                                                    DELTATIM.194
         YEARNEW=YEAROLD                                                         DELTATIM.195
         MONTHNEW=MONTHOLD                                                       DELTATIM.196
         IF( ((DAYNEW.GT.28).AND. (MONTHOLD.EQ.2) .AND.                          DELTATIM.197
     *        (MOD(YEAROLD,4).NE.0)              )   .OR.                        DELTATIM.198
     *       ((DAYNEW.GT.29).AND. (MONTHOLD.EQ.2) .AND.                          DELTATIM.199
     *        (MOD(YEAROLD,4).EQ.0)              )   .OR.                        DELTATIM.200
     *       ((DAYNEW.GT.30).AND.((MONTHOLD.EQ. 4)   .OR.                        DELTATIM.201
     *                            (MONTHOLD.EQ. 6)   .OR.                        DELTATIM.202
     *                            (MONTHOLD.EQ. 9)   .OR.                        DELTATIM.203
     *                            (MONTHOLD.EQ.11))) .OR.                        DELTATIM.204
     *        (DAYNEW.GT.31)) THEN                                               DELTATIM.205
            DAYNEW=DAYNEW-MDAY(MONTHOLD)                                         DELTATIM.206
            MONTHNEW=MONTHOLD+1                                                  DELTATIM.207
            IF((MONTHOLD.EQ.2).AND.(MOD(YEAROLD,4).EQ.0))                        DELTATIM.208
     *         DAYNEW=DAYNEW-1                                                   DELTATIM.209
         END IF                                                                  DELTATIM.210
C                                                                                DELTATIM.211
         IF(MONTHNEW.GT.12) THEN                                                 DELTATIM.212
            MONTHNEW=1                                                           DELTATIM.213
            YEARNEW=YEARNEW+1                                                    DELTATIM.214
         END IF                                                                  DELTATIM.215
C                                                                                DELTATIM.216
C        ... NOW THE NEW MDATE                                                   DELTATIM.217
C                                                                                DELTATIM.218
         IF(MDATEOLD.LT.1E9) THEN                                                DELTATIM.219
            MDATENEW=YEARNEW*1000000+MONTHNEW*10000+DAYNEW*100+HOURNEW           DELTATIM.220
         ELSE IF(MDATEOLD.GT.1E9) THEN                                           DELTATIM.221
            MDATENEW=YEARNEW*100000000+MONTHNEW*1000000+DAYNEW*10000+            DELTATIM.222
     *               HOURNEW*100+MINNEW                                          DELTATIM.223
         END IF                                                                  DELTATIM.224
         NY=YEARNEW                                                              DELTATIM.225
         NM=MONTHNEW                                                             DELTATIM.226
         ND=DAYNEW                                                               DELTATIM.227
         NH=HOURNEW                                                              DELTATIM.228
         NI=MINNEW                                                               DELTATIM.229
C                                                                                DELTATIM.230
C        ... JULIAN DATE                                                         DELTATIM.231
C                                                                                DELTATIM.232
         JULDAYO=0                                                               DELTATIM.233
         IF(MONTHOLD.GT.1) THEN                                                  DELTATIM.234
            IF(MOD(YEAROLD,4).EQ.0) MDAY(2)=29                                   DELTATIM.235
            DO 1600 IMON=1,MONTHOLD-1                                            DELTATIM.236
               JULDAYO=JULDAYO+MDAY(IMON)                                        DELTATIM.237
1600        CONTINUE                                                             DELTATIM.238
            MDAY(2)=28                                                           DELTATIM.239
         END IF                                                                  DELTATIM.240
         DO 1700 IDAY=1,DAYOLD                                                   DELTATIM.241
            JULDAYO=JULDAYO+1                                                    DELTATIM.242
1700     CONTINUE                                                                DELTATIM.243
         JULDAYN=0                                                               DELTATIM.244
         IF(MONTHNEW.GT.1) THEN                                                  DELTATIM.245
            IF(MOD(YEARNEW,4).EQ.0) MDAY(2)=29                                   DELTATIM.246
            DO 2600 IMON=1,MONTHNEW-1                                            DELTATIM.247
               JULDAYN=JULDAYN+MDAY(IMON)                                        DELTATIM.248
2600        CONTINUE                                                             DELTATIM.249
            MDAY(2)=28                                                           DELTATIM.250
         END IF                                                                  DELTATIM.251
         DO 2700 IDAY=1,DAYNEW                                                   DELTATIM.252
            JULDAYN=JULDAYN+1                                                    DELTATIM.253
2700     CONTINUE                                                                DELTATIM.254
      END IF                                                                     DELTATIM.255
      RETURN                                                                     DELTATIM.256
      END                                                                        DELTATIM.257
