      SUBROUTINE DIAGPRS(VARNAM,UNITS,CNT,NPASS,ICRSDOT,KDIM,                    DIAGPRS.1
     *   I3DFLD1,I3DFLD2,I3DFLD3,I3DFLD4,I2DSTART,I3DSTART,IERROR)               DIAGPRS.2
C                                                                                DIAGPRS.3
#     include <data.incl>                                                        DIAGPRS.4
       call DIAGPRS_1(VARNAM,UNITS,CNT,NPASS,ICRSDOT,KDIM,                       DIAGPRS.5
     *   I3DFLD1,I3DFLD2,I3DFLD3,I3DFLD4,I2DSTART,I3DSTART,IERROR,               DIAGPRS.6
     *                 DATASP(PTRD31),DATASP(PTRD32),                            DIAGPRS.7
     *                 DATASP(PTRD33),                                           DIAGPRS.8
     *                 DATASP(PTRD21),DATASP(PTRD22),                            DIAGPRS.9
     *                 DATASP(PTRD23),DATASP(PTRD24),                            DIAGPRS.10
     *                               I1,J1,K1 )                                  DIAGPRS.11
      RETURN                                                                     DIAGPRS.12
      END                                                                        DIAGPRS.13
C                                                                                DIAGPRS.14
      SUBROUTINE DIAGPRS_1(VARNAM,UNITS,CNT,NPASS,ICRSDOT,KDIM,                  DIAGPRS.15
     *   I3DFLD1,I3DFLD2,I3DFLD3,I3DFLD4,I2DSTART,I3DSTART,IERROR,               DIAGPRS.16
     *  D31,D32,D33,D21,D22,D23,D24,I1,J1,K1)                                    DIAGPRS.17
C                                                                                DIAGPRS.18
C     SECTION  DIAGNOSTIC                                                        DIAGPRS.19
C     PURPOSE  USES AVAILABLE FIELDS TO COMPUTE REQUIRED                         DIAGPRS.20
C              DIAGNOSTIC ON PRESSURE LEVELS.  THIS IS THEN STORED               DIAGPRS.21
C              ON DISK FOR POSSIBLE LATER USE                                    DIAGPRS.22
C                                                                                DIAGPRS.23
#     include <headerv3.incl>                                                    DIAGPRS.24
#     include <progname.incl>                                                    DIAGPRS.25
#     include <modelpar.incl>                                                    DIAGPRS.26
#     include <vlevel.incl>                                                      DIAGPRS.27
                                                                                 DIAGPRS.28
      real D31(I1*J1,K1),D32(I1*J1,K1),D33(I1*J1,K1),                            DIAGPRS.29
     *     D21(I1*J1),D22(I1*J1),D23(I1*J1),D24(I1*J1)                           DIAGPRS.30
      COMMON /GLEAN1/ FIELD,UNIT,FIELD2,UNIT2                                    DIAGPRS.31
      CHARACTER *80   FIELD,UNIT,FIELD2,UNIT2                                    DIAGPRS.32
      COMMON /GLEAN2/ CONT,ISMTHR,CONT2,ISMTHR2,XLATX,YLONY                      DIAGPRS.33
      LOGICAL   MLF(10)                                                          DIAGPRS.34
      DIMENSION JYR(18), JMO(18), JDY(18), JHR(18),                              DIAGPRS.35
     *          NBOGUS(18), KBOGUS(18)                                           DIAGPRS.36
      LOGICAL   IPLOT(18), NSELIM(18)                                            DIAGPRS.37
      COMMON /HEADER/ MDATE,IPROG,ICOORD,                                        DIAGPRS.38
     *   NLV,IVCOORD(100),VCOORD(100),                                           DIAGPRS.39
     *   MIF, MRF, MLF,                                                          DIAGPRS.40
     *   JYR,JMO,JDY,JHR,IPLOT,NSELIM,NBOGUS,KBOGUS,IPROJ                        DIAGPRS.41
      COMMON /WHEN/ MDATENOW,mdatebeg                                            DIAGPRS.42
      COMMON /HDRCHR/  PROG                                                      DIAGPRS.43
      COMMON /MM5PHY/ NFLAGS,IFLAGS(100)                                         DIAGPRS.44
      COMMON /DADTAB1/ TABNAME,TNPERM                                            DIAGPRS.45
      COMMON /DADTAB2/ TABREC,TRPERM                                             DIAGPRS.46
      PARAMETER (LENTAB=5000,LTPERM=1000)                                        DIAGPRS.47
      CHARACTER *8 TABNAME(LENTAB),TNPERM(LTPERM)                                DIAGPRS.48
      INTEGER TABREC(LENTAB),TRPERM(LTPERM)                                      DIAGPRS.49
      PARAMETER (IDAD2D=91,IDAD3D=92,IMMHDR=93)                                  DIAGPRS.50
      COMMON /MAPSTUFF/ XLONC,PHIC,XLAT1,XLON1,XLAT2,XLON2,                      DIAGPRS.51
     *   ISTART,IEND,JSTART,JEND,                                                DIAGPRS.52
     *   IMAPMAX,IMAPST,IMAPEND,JMAPMAX,JMAPST,JMAPEND,                          DIAGPRS.53
     *   XPA,XPB,YPA,YPB,                                                        DIAGPRS.54
     *   DS,OVERLAY,IFRAME,INSIDE,IFORM,NUMFRAME                                 DIAGPRS.55
      LOGICAL OVERLAY                                                            DIAGPRS.56
C                                                                                DIAGPRS.57
      CHARACTER *8 VARNAM,UNITS                                                  DIAGPRS.58
      LOGICAL FOUND,DIAGS                                                        DIAGPRS.59
      CHARACTER *2 KDIM                                                          DIAGPRS.60
C                                                                                DIAGPRS.61
C     ... GET DEFAULTS                                                           DIAGPRS.62
C                                                                                DIAGPRS.63
      IERROR=0                                                                   DIAGPRS.64
      DIAGS=.TRUE.                                                               DIAGPRS.65
      IF((FIELD(1:5).EQ.'BARB '    ) .OR.    ! WIND BARBS                        DIAGPRS.66
     *   (FIELD(1:5).EQ.'VECT '    ) .OR.    ! WIND VECTORS                      DIAGPRS.67
     *   (FIELD(1:5).EQ.'VESL '    )) THEN   ! WIND STREAM LINES                 DIAGPRS.68
         VARNAM(1:8)='BARB UV '                                                  DIAGPRS.69
         IF(FIELD(1:4).EQ.'BARB') THEN                                           DIAGPRS.70
            IFORM=3                                                              DIAGPRS.71
         ELSE IF(FIELD(1:4).EQ.'VECT') THEN                                      DIAGPRS.72
            IFORM=1                                                              DIAGPRS.73
            FIELD(1:4)='BARB'                                                    DIAGPRS.74
         ELSE IF(FIELD(1:4).EQ.'VESL') THEN                                      DIAGPRS.75
            IFORM=2                                                              DIAGPRS.76
            FIELD(1:4)='BARB'                                                    DIAGPRS.77
         END IF                                                                  DIAGPRS.78
         CNT=CONT                                                                DIAGPRS.79
         NPASS=ISMTHR                                                            DIAGPRS.80
         ICRSDOT=0                                                               DIAGPRS.81
         KDIM='3D'                                                               DIAGPRS.82
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.83
     *      .FALSE.,FOUND)                                                       DIAGPRS.84
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.85
     *      .FALSE.,FOUND)                                                       DIAGPRS.86
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.87
            UNIT(1:8)='m/s     '                                                 DIAGPRS.88
            UNITS(1:8)='m/s     '                                                DIAGPRS.89
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.90
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.91
            CALL MPS2KT(D32,I1,J1,K1,0)                                          DIAGPRS.92
            UNIT(1:8)='kt      '                                                 DIAGPRS.93
            UNITS(1:8)='kt      '                                                DIAGPRS.94
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.95
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.96
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.97
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.98
            UNITS(1:8)='cm/s    '                                                DIAGPRS.99
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.100
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.101
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.102
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.103
            UNITS(1:8)='mm/s    '                                                DIAGPRS.104
         ELSE                                                                    DIAGPRS.105
            UNIT(1:8)='m/s     '                                                 DIAGPRS.106
            UNITS(1:8)='m/s     '                                                DIAGPRS.107
         END IF                                                                  DIAGPRS.108
C                                                                                DIAGPRS.109
      ELSE IF(FIELD(1:4).EQ.'AGL '    ) THEN    ! ABOVE GROUND LEVEL             DIAGPRS.110
         VARNAM(1:8)='AGL     '                                                  DIAGPRS.111
         CNT=CONT                                                                DIAGPRS.112
         NPASS=ISMTHR                                                            DIAGPRS.113
         ICRSDOT=1                                                               DIAGPRS.114
         KDIM='3D'                                                               DIAGPRS.115
         CALL READDAD(D32,'H       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.116
     *   .FALSE.,FOUND)                                                          DIAGPRS.117
         CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1, 1,0,                          DIAGPRS.118
     *   .FALSE.,FOUND)                                                          DIAGPRS.119
         call d3md2(d32,d22,i1,j1,k1,1,d31)                                      DIAGPRS.120
         IF(UNIT(1:1).EQ.'m') THEN                                               DIAGPRS.121
            UNIT(1:8)='m       '                                                 DIAGPRS.122
            UNITS(1:8)='m       '                                                DIAGPRS.123
         ELSE IF(UNIT(1:2).EQ.'Dm') THEN                                         DIAGPRS.124
            CALL SCALE(D31,'DIV ',10.,I1,J1,K1,I1,J1,1)                          DIAGPRS.125
            UNIT(1:8)='Dm      '                                                 DIAGPRS.126
            UNITS(1:8)='Dm      '                                                DIAGPRS.127
         ELSE IF(UNIT(1:2).EQ.'cm') THEN                                         DIAGPRS.128
            CALL SCALE(D31,'MULT',100.,I1,J1,K1,I1,J1,1)                         DIAGPRS.129
            UNIT(1:8)='cm      '                                                 DIAGPRS.130
            UNITS(1:8)='cm      '                                                DIAGPRS.131
         ELSE                                                                    DIAGPRS.132
            UNIT(1:8)='m       '                                                 DIAGPRS.133
            UNITS(1:8)='m       '                                                DIAGPRS.134
         ENDIF                                                                   DIAGPRS.135
C                                                                                DIAGPRS.136
      ELSE IF((FIELD(1:6).EQ.'BARBA '   ) .OR.    ! AGEOS WIND BARBS             DIAGPRS.137
     *   (FIELD(1:6).EQ.'VECTA '    ) .OR.    ! AGEOS WIND VECTORS               DIAGPRS.138
     *   (FIELD(1:6).EQ.'VESLA '    )) THEN   ! AGEOS WIND STREAM LINES          DIAGPRS.139
         VARNAM(1:8)='BARB AG '                                                  DIAGPRS.140
         IF(FIELD(1:4).EQ.'BARB') THEN                                           DIAGPRS.141
            IFORM=3                                                              DIAGPRS.142
         ELSE IF(FIELD(1:4).EQ.'VECT') THEN                                      DIAGPRS.143
            IFORM=1                                                              DIAGPRS.144
            FIELD(1:4)='BARB'                                                    DIAGPRS.145
         ELSE IF(FIELD(1:4).EQ.'VESL') THEN                                      DIAGPRS.146
            IFORM=2                                                              DIAGPRS.147
            FIELD(1:4)='BARB'                                                    DIAGPRS.148
         END IF                                                                  DIAGPRS.149
         CNT=CONT                                                                DIAGPRS.150
         NPASS=ISMTHR                                                            DIAGPRS.151
         ICRSDOT=0                                                               DIAGPRS.152
         KDIM='3D'                                                               DIAGPRS.153
         IF(PROG(1:6).EQ.'REGRID') THEN                                          DIAGPRS.154
            CALL READDAD(D33,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.155
     *         .FALSE.,FOUND)                                                    DIAGPRS.156
            CALL DOT2CRS(D33(1,2),I1,J1,K1-1,I1,J1)                              DIAGPRS.157
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.158
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.159
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.160
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.161
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.162
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.163
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.164
     *            .FALSE.,FOUND)                                                 DIAGPRS.165
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.166
     *            .FALSE.,FOUND)                                                 DIAGPRS.167
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.168
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.169
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.170
            END IF                                                               DIAGPRS.171
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.172
     *                I3DSTART,0)                                                DIAGPRS.173
            I3DSTART=I3DSTART+1                                                  DIAGPRS.174
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.175
     *         .FALSE.,FOUND)                                                    DIAGPRS.176
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.177
     *         .FALSE.,FOUND)                                                    DIAGPRS.178
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.179
     *         .FALSE.,FOUND)                                                    DIAGPRS.180
            CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                        DIAGPRS.181
     *         .FALSE.,FOUND)                                                    DIAGPRS.182
            CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                        DIAGPRS.183
     *         .FALSE.,FOUND)                                                    DIAGPRS.184
            CALL SFCPRS(D32,D33,D31,D21,D22,P,                                   DIAGPRS.185
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.186
            CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                         DIAGPRS.187
     *                  I3DSTART,0)                                              DIAGPRS.188
            I3DSTART=I3DSTART+1                                                  DIAGPRS.189
            CALL READDAD(D33,'GHT INTG',IDAD3D,I1,J1,K1,0,                       DIAGPRS.190
     *         .FALSE.,FOUND)                                                    DIAGPRS.191
C           CALL READDAD(D33,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.192
C    *         .FALSE.,FOUND)                                                    DIAGPRS.193
C           CALL CRS2DOT(D33,I1,J1,K1,I1,J1)                                     DIAGPRS.194
            CALL SMTHER(D33,D21,I1,J1,K1,NPASS,1)                                DIAGPRS.195
         ELSE IF(PROG(1:6).EQ.'RAWSFC') THEN                                     DIAGPRS.196
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.197
            IERROR=1                                                             DIAGPRS.198
            RETURN                                                               DIAGPRS.199
         END IF                                                                  DIAGPRS.200
         CALL READDAD(D21,'CORIOLIS',IDAD2D,I1,J1, 1,0,                          DIAGPRS.201
     *      .FALSE.,FOUND)                                                       DIAGPRS.202
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.203
     *      .FALSE.,FOUND)                                                       DIAGPRS.204
         CALL READDAD(D23,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.205
     *      .FALSE.,FOUND)                                                       DIAGPRS.206
         CALL GEOWINDP(D33,D21,D22,D23,I1,J1,K1,DS,D31,D32)                      DIAGPRS.207
C                                                                                DIAGPRS.208
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.209
     *      .FALSE.,FOUND)                                                       DIAGPRS.210
         CALL AGEOW(D33,D31,D21,I1,J1,K1)                                        DIAGPRS.211
         CALL WRITDAD(D31,'U AGEO  ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.212
         I3DSTART=I3DSTART+1                                                     DIAGPRS.213
C                                                                                DIAGPRS.214
         CALL READDAD(D33,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.215
     *      .FALSE.,FOUND)                                                       DIAGPRS.216
         CALL AGEOW(D33,D32,D21,I1,J1,K1)                                        DIAGPRS.217
         CALL WRITDAD(D32,'V AGEO  ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.218
         I3DSTART=I3DSTART+1                                                     DIAGPRS.219
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.220
            UNIT(1:8)='m/s     '                                                 DIAGPRS.221
            UNITS(1:8)='m/s     '                                                DIAGPRS.222
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.223
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.224
            CALL MPS2KT(D32,I1,J1,K1,0)                                          DIAGPRS.225
            UNIT(1:8)='kt      '                                                 DIAGPRS.226
            UNITS(1:8)='kt      '                                                DIAGPRS.227
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.228
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.229
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.230
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.231
            UNITS(1:8)='cm/s    '                                                DIAGPRS.232
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.233
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.234
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.235
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.236
            UNITS(1:8)='mm/s    '                                                DIAGPRS.237
         ELSE                                                                    DIAGPRS.238
            UNIT(1:8)='m/s     '                                                 DIAGPRS.239
            UNITS(1:8)='m/s     '                                                DIAGPRS.240
         END IF                                                                  DIAGPRS.241
C                                                                                DIAGPRS.242
      ELSE IF(FIELD(1:2).EQ.'W '   ) THEN    ! VERTICAL WIND SPEED               DIAGPRS.243
         VARNAM(1:8)='W       '                                                  DIAGPRS.244
         CNT=CONT                                                                DIAGPRS.245
         NPASS=ISMTHR                                                            DIAGPRS.246
         ICRSDOT=1                                                               DIAGPRS.247
         KDIM='3D'                                                               DIAGPRS.248
         CALL READDAD(D31,'W       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.249
     *      .FALSE.,FOUND)                                                       DIAGPRS.250
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.251
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.252
            IERROR=1                                                             DIAGPRS.253
            RETURN                                                               DIAGPRS.254
         endif                                                                   DIAGPRS.255
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.256
            UNIT(1:8)='m/s     '                                                 DIAGPRS.257
            UNITS(1:8)='m/s     '                                                DIAGPRS.258
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.259
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.260
            UNIT(1:8)='kt      '                                                 DIAGPRS.261
            UNITS(1:8)='kt      '                                                DIAGPRS.262
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.263
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.264
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.265
            UNITS(1:8)='cm/s    '                                                DIAGPRS.266
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.267
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.268
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.269
            UNITS(1:8)='mm/s    '                                                DIAGPRS.270
         ELSE                                                                    DIAGPRS.271
            UNIT(1:8)='m/s     '                                                 DIAGPRS.272
            UNITS(1:8)='m/s     '                                                DIAGPRS.273
         END IF                                                                  DIAGPRS.274
C                                                                                DIAGPRS.275
      ELSE IF(FIELD(1:3).EQ.'PP '      ) THEN    ! PRESSURE PERTURB              DIAGPRS.276
         VARNAM(1:8)='P PRIME '                                                  DIAGPRS.277
         CNT=CONT                                                                DIAGPRS.278
         NPASS=ISMTHR                                                            DIAGPRS.279
         ICRSDOT=1                                                               DIAGPRS.280
         KDIM='3D'                                                               DIAGPRS.281
         CALL READDAD(D31,'PP      ',IDAD3D,I1,J1,k1,0,                          DIAGPRS.282
     *      DIAGS,FOUND)                                                         DIAGPRS.283
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.284
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.285
            IERROR=1                                                             DIAGPRS.286
            RETURN                                                               DIAGPRS.287
         endif                                                                   DIAGPRS.288
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGPRS.289
            UNIT(1:8)='mb      '                                                 DIAGPRS.290
            UNITS(1:8)='mb      '                                                DIAGPRS.291
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGPRS.292
            CALL SCALE(D31,'MULT',100.0,I1,J1,k1,I1,J1,1)                        DIAGPRS.293
            UNIT(1:8)='Pa      '                                                 DIAGPRS.294
            UNITS(1:8)='Pa      '                                                DIAGPRS.295
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGPRS.296
            UNIT(1:8)='hPa     '                                                 DIAGPRS.297
            UNITS(1:8)='hPa     '                                                DIAGPRS.298
         ELSE                                                                    DIAGPRS.299
            UNIT(1:8)='mb      '                                                 DIAGPRS.300
            UNITS(1:8)='mb      '                                                DIAGPRS.301
         END IF                                                                  DIAGPRS.302
C                                                                                DIAGPRS.303
      ELSE IF((FIELD(1:6).EQ.'BARBG '   ) .OR.    ! GEOS WIND BARBS              DIAGPRS.304
     *   (FIELD(1:6).EQ.'VECTG '    ) .OR.    ! WIND VECTORS                     DIAGPRS.305
     *   (FIELD(1:6).EQ.'VESLG '    )) THEN   ! GEOS WIND STREAM LINES           DIAGPRS.306
         VARNAM(1:8)='BARB GEO'                                                  DIAGPRS.307
         IF(FIELD(1:4).EQ.'BARB') THEN                                           DIAGPRS.308
            IFORM=3                                                              DIAGPRS.309
         ELSE IF(FIELD(1:4).EQ.'VECT') THEN                                      DIAGPRS.310
            IFORM=1                                                              DIAGPRS.311
            FIELD(1:4)='BARB'                                                    DIAGPRS.312
         ELSE IF(FIELD(1:4).EQ.'VESL') THEN                                      DIAGPRS.313
            IFORM=2                                                              DIAGPRS.314
            FIELD(1:4)='BARB'                                                    DIAGPRS.315
         END IF                                                                  DIAGPRS.316
C                                                                                DIAGPRS.317
C                                                                                DIAGPRS.318
         CNT=CONT                                                                DIAGPRS.319
         NPASS=ISMTHR                                                            DIAGPRS.320
         ICRSDOT=0                                                               DIAGPRS.321
         KDIM='3D'                                                               DIAGPRS.322
         IF(PROG(1:6).EQ.'REGRID') THEN                                          DIAGPRS.323
            CALL READDAD(D33,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.324
     *         .FALSE.,FOUND)                                                    DIAGPRS.325
            CALL DOT2CRS(D33(1,2),I1,J1,K1-1,I1,J1)                              DIAGPRS.326
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.327
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.328
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.329
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.330
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.331
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.332
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.333
     *            .FALSE.,FOUND)                                                 DIAGPRS.334
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.335
     *            .FALSE.,FOUND)                                                 DIAGPRS.336
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.337
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.338
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.339
            END IF                                                               DIAGPRS.340
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.341
     *                I3DSTART,0)                                                DIAGPRS.342
            I3DSTART=I3DSTART+1                                                  DIAGPRS.343
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.344
     *         .FALSE.,FOUND)                                                    DIAGPRS.345
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.346
     *         .FALSE.,FOUND)                                                    DIAGPRS.347
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.348
     *         .FALSE.,FOUND)                                                    DIAGPRS.349
            CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                        DIAGPRS.350
     *         .FALSE.,FOUND)                                                    DIAGPRS.351
            CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                        DIAGPRS.352
     *         .FALSE.,FOUND)                                                    DIAGPRS.353
            CALL SFCPRS(D32,D33,D31,D21,D22,P,                                   DIAGPRS.354
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.355
            CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                         DIAGPRS.356
     *                  I3DSTART,0)                                              DIAGPRS.357
            I3DSTART=I3DSTART+1                                                  DIAGPRS.358
            CALL READDAD(D33,'GHT INTG',IDAD3D,I1,J1,K1,0,                       DIAGPRS.359
     *         .FALSE.,FOUND)                                                    DIAGPRS.360
C           CALL READDAD(D33,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.361
C    *         .FALSE.,FOUND)                                                    DIAGPRS.362
C           CALL CRS2DOT(D33,I1,J1,K1,I1,J1)                                     DIAGPRS.363
            CALL SMTHER(D33,D21,I1,J1,K1,NPASS,1)                                DIAGPRS.364
         ELSE IF(PROG(1:6).EQ.'RAWSFC') THEN                                     DIAGPRS.365
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.366
            IERROR=1                                                             DIAGPRS.367
            RETURN                                                               DIAGPRS.368
         END IF                                                                  DIAGPRS.369
         CALL READDAD(D21,'CORIOLIS',IDAD2D,I1,J1, 1,0,                          DIAGPRS.370
     *      .FALSE.,FOUND)                                                       DIAGPRS.371
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.372
     *      .FALSE.,FOUND)                                                       DIAGPRS.373
         CALL READDAD(D23,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.374
     *      .FALSE.,FOUND)                                                       DIAGPRS.375
         CALL GEOWINDP(D33,D21,D22,D23,I1,J1,K1,DS,D31,D32)                      DIAGPRS.376
         CALL WRITDAD(D31,'U GEO   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.377
         I3DSTART=I3DSTART+1                                                     DIAGPRS.378
         CALL WRITDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.379
         I3DSTART=I3DSTART+1                                                     DIAGPRS.380
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.381
            UNIT(1:8)='m/s     '                                                 DIAGPRS.382
            UNITS(1:8)='m/s     '                                                DIAGPRS.383
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.384
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.385
            CALL MPS2KT(D32,I1,J1,K1,0)                                          DIAGPRS.386
            UNIT(1:8)='kt      '                                                 DIAGPRS.387
            UNITS(1:8)='kt      '                                                DIAGPRS.388
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.389
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.390
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.391
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.392
            UNITS(1:8)='cm/s    '                                                DIAGPRS.393
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.394
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.395
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.396
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.397
            UNITS(1:8)='mm/s    '                                                DIAGPRS.398
         ELSE                                                                    DIAGPRS.399
            UNIT(1:8)='m/s     '                                                 DIAGPRS.400
            UNITS(1:8)='m/s     '                                                DIAGPRS.401
         END IF                                                                  DIAGPRS.402
C                                                                                DIAGPRS.403
      ELSE IF(FIELD(1:4).EQ.'CLW '    ) THEN    ! CLOUD WATER                    DIAGPRS.404
         VARNAM(1:8)='CL WATER'                                                  DIAGPRS.405
         CNT=CONT                                                                DIAGPRS.406
         NPASS=ISMTHR                                                            DIAGPRS.407
         ICRSDOT=1                                                               DIAGPRS.408
         KDIM='3D'                                                               DIAGPRS.409
         CALL READDAD(D31,'CLW     ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.410
     *      DIAGS,FOUND)                                                         DIAGPRS.411
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.412
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.413
            IERROR=1                                                             DIAGPRS.414
            RETURN                                                               DIAGPRS.415
         END IF                                                                  DIAGPRS.416
C        CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGPRS.417
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.418
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.419
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.420
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.421
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.422
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.423
            UNITS(1:8)='g/kg    '                                                DIAGPRS.424
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.425
            UNIT(1:8)='g/g     '                                                 DIAGPRS.426
            UNITS(1:8)='g/g     '                                                DIAGPRS.427
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGPRS.428
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.429
            UNIT(1:8)='mg/kg   '                                                 DIAGPRS.430
            UNITS(1:8)='mg/kg   '                                                DIAGPRS.431
         ELSE                                                                    DIAGPRS.432
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.433
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.434
         END IF                                                                  DIAGPRS.435
C                                                                                DIAGPRS.436
      ELSE IF(FIELD(1:4).EQ.'RNW '    ) THEN    ! RAIN WATER                     DIAGPRS.437
         VARNAM(1:8)='RN WATER'                                                  DIAGPRS.438
         CNT=CONT                                                                DIAGPRS.439
         NPASS=ISMTHR                                                            DIAGPRS.440
         ICRSDOT=1                                                               DIAGPRS.441
         KDIM='3D'                                                               DIAGPRS.442
         CALL READDAD(D31,'RNW     ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.443
     *      DIAGS,FOUND)                                                         DIAGPRS.444
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.445
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.446
            IERROR=1                                                             DIAGPRS.447
            RETURN                                                               DIAGPRS.448
         END IF                                                                  DIAGPRS.449
C        CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGPRS.450
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.451
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.452
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.453
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.454
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.455
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.456
            UNITS(1:8)='g/kg    '                                                DIAGPRS.457
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.458
            UNIT(1:8)='g/g     '                                                 DIAGPRS.459
            UNITS(1:8)='g/g     '                                                DIAGPRS.460
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGPRS.461
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.462
            UNIT(1:8)='mg/kg   '                                                 DIAGPRS.463
            UNITS(1:8)='mg/kg   '                                                DIAGPRS.464
         ELSE                                                                    DIAGPRS.465
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.466
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.467
         END IF                                                                  DIAGPRS.468
C                                                                                DIAGPRS.469
      ELSE IF(FIELD(1:5).EQ.'SNOW '    ) THEN    ! SNOW                          DIAGPRS.470
         VARNAM(1:8)='SNOW    '                                                  DIAGPRS.471
         CNT=CONT                                                                DIAGPRS.472
         NPASS=ISMTHR                                                            DIAGPRS.473
         ICRSDOT=1                                                               DIAGPRS.474
         KDIM='3D'                                                               DIAGPRS.475
         CALL READDAD(D31,'SNOWW   ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.476
     *      DIAGS,FOUND)                                                         DIAGPRS.477
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.478
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.479
            IERROR=1                                                             DIAGPRS.480
            RETURN                                                               DIAGPRS.481
         END IF                                                                  DIAGPRS.482
         CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGPRS.483
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.484
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.485
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.486
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.487
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.488
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.489
            UNITS(1:8)='g/kg    '                                                DIAGPRS.490
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.491
            UNIT(1:8)='g/g     '                                                 DIAGPRS.492
            UNITS(1:8)='g/g     '                                                DIAGPRS.493
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGPRS.494
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.495
            UNIT(1:8)='mg/kg   '                                                 DIAGPRS.496
            UNITS(1:8)='mg/kg   '                                                DIAGPRS.497
         ELSE                                                                    DIAGPRS.498
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.499
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.500
         END IF                                                                  DIAGPRS.501
C                                                                                DIAGPRS.502
      ELSE IF(FIELD(1:4).EQ.'ICE '    ) THEN    ! CLOUD ICE                      DIAGPRS.503
         VARNAM(1:8)='CLD ICE '                                                  DIAGPRS.504
         CNT=CONT                                                                DIAGPRS.505
         NPASS=ISMTHR                                                            DIAGPRS.506
         ICRSDOT=1                                                               DIAGPRS.507
         KDIM='3D'                                                               DIAGPRS.508
         CALL READDAD(D31,'ICEW    ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.509
     *      DIAGS,FOUND)                                                         DIAGPRS.510
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.511
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.512
            IERROR=1                                                             DIAGPRS.513
            RETURN                                                               DIAGPRS.514
         END IF                                                                  DIAGPRS.515
         CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGPRS.516
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.517
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.518
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.519
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.520
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.521
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.522
            UNITS(1:8)='g/kg    '                                                DIAGPRS.523
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.524
            UNIT(1:8)='g/g     '                                                 DIAGPRS.525
            UNITS(1:8)='g/g     '                                                DIAGPRS.526
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGPRS.527
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.528
            UNIT(1:8)='mg/kg   '                                                 DIAGPRS.529
            UNITS(1:8)='mg/kg   '                                                DIAGPRS.530
         ELSE                                                                    DIAGPRS.531
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.532
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.533
         END IF                                                                  DIAGPRS.534
C                                                                                DIAGPRS.535
      ELSE IF(FIELD(1:5).EQ.'NCI  '    ) THEN    ! NUMBER CONCENTRATION OF ICE   DIAGPRS.536
         VARNAM(1:8)='NO. CONC'                                                  DIAGPRS.537
         CNT=CONT                                                                DIAGPRS.538
         NPASS=ISMTHR                                                            DIAGPRS.539
         ICRSDOT=1                                                               DIAGPRS.540
         KDIM='3D'                                                               DIAGPRS.541
         CALL READDAD(D31,'NCI     ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.542
     *      DIAGS,FOUND)                                                         DIAGPRS.543
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.544
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.545
            IERROR=1                                                             DIAGPRS.546
            RETURN                                                               DIAGPRS.547
         END IF                                                                  DIAGPRS.548
         CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGPRS.549
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.550
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.551
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.552
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.553
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.554
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.555
            UNITS(1:8)='g/kg    '                                                DIAGPRS.556
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.557
            UNIT(1:8)='g/g     '                                                 DIAGPRS.558
            UNITS(1:8)='g/g     '                                                DIAGPRS.559
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGPRS.560
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.561
            UNIT(1:8)='mg/kg   '                                                 DIAGPRS.562
            UNITS(1:8)='mg/kg   '                                                DIAGPRS.563
         ELSE                                                                    DIAGPRS.564
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.565
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.566
         END IF                                                                  DIAGPRS.567
C                                                                                DIAGPRS.568
      ELSE IF(FIELD(1:5).EQ.'GRA  '                                              DIAGPRS.569
     *    .OR.FIELD(1:8).EQ.'GRAUPEL ') THEN     ! NUMBER CONCENTRATION OF ICE   DIAGPRS.570
         VARNAM(1:8)='GRAUPEL '                                                  DIAGPRS.571
         CNT=CONT                                                                DIAGPRS.572
         NPASS=ISMTHR                                                            DIAGPRS.573
         ICRSDOT=1                                                               DIAGPRS.574
         KDIM='3D'                                                               DIAGPRS.575
         CALL READDAD(D31,'GRAUPEL ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.576
     *      DIAGS,FOUND)                                                         DIAGPRS.577
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.578
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.579
            IERROR=1                                                             DIAGPRS.580
            RETURN                                                               DIAGPRS.581
         END IF                                                                  DIAGPRS.582
         CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGPRS.583
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.584
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.585
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.586
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.587
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.588
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.589
            UNITS(1:8)='g/kg    '                                                DIAGPRS.590
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.591
            UNIT(1:8)='g/g     '                                                 DIAGPRS.592
            UNITS(1:8)='g/g     '                                                DIAGPRS.593
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGPRS.594
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.595
            UNIT(1:8)='mg/kg   '                                                 DIAGPRS.596
            UNITS(1:8)='mg/kg   '                                                DIAGPRS.597
         ELSE                                                                    DIAGPRS.598
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.599
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.600
         END IF                                                                  DIAGPRS.601
C                                                                                DIAGPRS.602
      ELSE IF(FIELD(1:4).EQ.'SLW '    ) THEN    ! SUPER COOLED LIQ WATER         DIAGPRS.603
         VARNAM(1:8)='SLW     '                                                  DIAGPRS.604
         CNT=CONT                                                                DIAGPRS.605
         NPASS=ISMTHR                                                            DIAGPRS.606
         ICRSDOT=1                                                               DIAGPRS.607
         KDIM='3D'                                                               DIAGPRS.608
         CALL READDAD(D33,'CLW     ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.609
     *      DIAGS,FOUND)                                                         DIAGPRS.610
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.611
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.612
            IERROR=1                                                             DIAGPRS.613
            RETURN                                                               DIAGPRS.614
         END IF                                                                  DIAGPRS.615
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.616
     *      .FALSE.,FOUND)                                                       DIAGPRS.617
         twarm=273.15                                                            DIAGPRS.618
         tcold=twarm-75.                                                         DIAGPRS.619
         CALL SLW(D33,D32,i1,j1,k1,twarm,tcold,d31)                              DIAGPRS.620
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.621
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.622
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.623
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.624
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.625
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.626
            UNITS(1:8)='g/kg    '                                                DIAGPRS.627
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.628
            UNIT(1:8)='g/g     '                                                 DIAGPRS.629
            UNITS(1:8)='g/g     '                                                DIAGPRS.630
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGPRS.631
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.632
            UNIT(1:8)='mg/kg   '                                                 DIAGPRS.633
            UNITS(1:8)='mg/kg   '                                                DIAGPRS.634
         ELSE                                                                    DIAGPRS.635
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.636
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.637
         END IF                                                                  DIAGPRS.638
C                                                                                DIAGPRS.639
      ELSE IF(FIELD(1:4).EQ.'CLB  '    ) THEN    ! CLOUD BOUNDARY                DIAGPRS.640
         VARNAM(1:8)='CLD BDY '                                                  DIAGPRS.641
         CNT=CONT                                                                DIAGPRS.642
         NPASS=ISMTHR                                                            DIAGPRS.643
         ICRSDOT=1                                                               DIAGPRS.644
         KDIM='3D'                                                               DIAGPRS.645
         CALL READDAD(D33,'ICEW    ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.646
     *      DIAGS,FOUND)                                                         DIAGPRS.647
         IF(.NOT.FOUND) CALL CLEAR(d33,i1,j1,k1)                                 DIAGPRS.648
         CALL READDAD(D32,'SNOWW   ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.649
     *      DIAGS,FOUND)                                                         DIAGPRS.650
         IF(.NOT.FOUND) CALL CLEAR(d32,i1,j1,k1)                                 DIAGPRS.651
         call sum(d32,d33,i1,j1,k1,1,d32)                                        DIAGPRS.652
         CALL READDAD(D33,'CLW     ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.653
     *      DIAGS,FOUND)                                                         DIAGPRS.654
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.655
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.656
            IERROR=1                                                             DIAGPRS.657
            RETURN                                                               DIAGPRS.658
         END IF                                                                  DIAGPRS.659
         CALL READDAD(D31,'RNW     ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.660
     *      DIAGS,FOUND)                                                         DIAGPRS.661
         call sum(d31,d33,i1,j1,k1,1,d33)                                        DIAGPRS.662
         call cloudbdy(d32,d33,i1,j1,k1,d31,cnt)                                 DIAGPRS.663
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.664
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.665
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.666
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.667
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.668
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.669
            UNITS(1:8)='g/kg    '                                                DIAGPRS.670
            cnt=cnt*1.e3                                                         DIAGPRS.671
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.672
            UNIT(1:8)='g/g     '                                                 DIAGPRS.673
            UNITS(1:8)='g/g     '                                                DIAGPRS.674
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGPRS.675
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.676
            UNIT(1:8)='mg/kg   '                                                 DIAGPRS.677
            UNITS(1:8)='mg/kg   '                                                DIAGPRS.678
            cnt=cnt*1.e6                                                         DIAGPRS.679
         ELSE                                                                    DIAGPRS.680
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.681
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.682
         END IF                                                                  DIAGPRS.683
C                                                                                DIAGPRS.684
      ELSE IF(FIELD(1:2).EQ.'P '    ) THEN    ! PRESSURE                         DIAGPRS.685
         VARNAM(1:8)='P       '                                                  DIAGPRS.686
         CNT=CONT                                                                DIAGPRS.687
         NPASS=ISMTHR                                                            DIAGPRS.688
         ICRSDOT=1                                                               DIAGPRS.689
         KDIM='3D'                                                               DIAGPRS.690
         CALL PSIMPLE(P,I1,J1,K1,D31)                                            DIAGPRS.691
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGPRS.692
            UNIT(1:8)='mb            '                                           DIAGPRS.693
            UNITS(1:8)='mb       '                                               DIAGPRS.694
         ELSE                                                                    DIAGPRS.695
            UNIT(1:8)='mb      '                                                 DIAGPRS.696
            UNITS(1:8)='mb         '                                             DIAGPRS.697
         ENDIF                                                                   DIAGPRS.698
C                                                                                DIAGPRS.699
      ELSE IF(FIELD(1:2).EQ.'H '    ) THEN    ! STRAIGHT HEIGHT                  DIAGPRS.700
         VARNAM(1:8)='H       '                                                  DIAGPRS.701
         CNT=CONT                                                                DIAGPRS.702
         NPASS=ISMTHR                                                            DIAGPRS.703
         ICRSDOT=1                                                               DIAGPRS.704
         KDIM='3D'                                                               DIAGPRS.705
         CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.706
     *   .FALSE.,FOUND)                                                          DIAGPRS.707
         IF(UNIT(1:1).EQ.'m') THEN                                               DIAGPRS.708
            UNIT(1:8)='m       '                                                 DIAGPRS.709
            UNITS(1:8)='m       '                                                DIAGPRS.710
         ELSE                                                                    DIAGPRS.711
            UNIT(1:8)='m       '                                                 DIAGPRS.712
            UNITS(1:8)='m       '                                                DIAGPRS.713
         ENDIF                                                                   DIAGPRS.714
C                                                                                DIAGPRS.715
      ELSE IF(FIELD(1:2).EQ.'U '   ) THEN    ! U-COMP WIND SPEED                 DIAGPRS.716
         VARNAM(1:8)='U       '                                                  DIAGPRS.717
         CNT=CONT                                                                DIAGPRS.718
         NPASS=ISMTHR                                                            DIAGPRS.719
         ICRSDOT=0                                                               DIAGPRS.720
         KDIM='3D'                                                               DIAGPRS.721
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.722
     *      .FALSE.,FOUND)                                                       DIAGPRS.723
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.724
            UNIT(1:8)='m/s     '                                                 DIAGPRS.725
            UNITS(1:8)='m/s     '                                                DIAGPRS.726
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.727
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.728
            UNIT(1:8)='kt      '                                                 DIAGPRS.729
            UNITS(1:8)='kt      '                                                DIAGPRS.730
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.731
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.732
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.733
            UNITS(1:8)='cm/s    '                                                DIAGPRS.734
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.735
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.736
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.737
            UNITS(1:8)='mm/s    '                                                DIAGPRS.738
         ELSE                                                                    DIAGPRS.739
            UNIT(1:8)='m/s     '                                                 DIAGPRS.740
            UNITS(1:8)='m/s     '                                                DIAGPRS.741
         END IF                                                                  DIAGPRS.742
C                                                                                DIAGPRS.743
      ELSE IF(FIELD(1:2).EQ.'V '   ) THEN    ! V-COMP WIND SPEED                 DIAGPRS.744
         VARNAM(1:8)='V       '                                                  DIAGPRS.745
         CNT=CONT                                                                DIAGPRS.746
         NPASS=ISMTHR                                                            DIAGPRS.747
         ICRSDOT=0                                                               DIAGPRS.748
         KDIM='3D'                                                               DIAGPRS.749
         CALL READDAD(D31,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.750
     *      .FALSE.,FOUND)                                                       DIAGPRS.751
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.752
            UNIT(1:8)='m/s     '                                                 DIAGPRS.753
            UNITS(1:8)='m/s     '                                                DIAGPRS.754
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.755
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.756
            UNIT(1:8)='kt      '                                                 DIAGPRS.757
            UNITS(1:8)='kt      '                                                DIAGPRS.758
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.759
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.760
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.761
            UNITS(1:8)='cm/s    '                                                DIAGPRS.762
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.763
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.764
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.765
            UNITS(1:8)='mm/s    '                                                DIAGPRS.766
         ELSE                                                                    DIAGPRS.767
            UNIT(1:8)='m/s     '                                                 DIAGPRS.768
            UNITS(1:8)='m/s     '                                                DIAGPRS.769
         END IF                                                                  DIAGPRS.770
C                                                                                DIAGPRS.771
      ELSE IF(FIELD(1:7).EQ.'HEIGHT ' .or.                                       19DEC02.1
     *        FIELD(1:6).EQ.'HDIFF ') THEN    ! GEOPOT HEIGHT                    19DEC02.2
         VARNAM(1:8)='H INTEG '                                                  19DEC02.3
         CNT=CONT                                                                DIAGPRS.774
         NPASS=ISMTHR                                                            DIAGPRS.775
         ICRSDOT=1                                                               DIAGPRS.776
         KDIM='3D'                                                               DIAGPRS.777
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.788
     *            .FALSE.,FOUND)                                                 DIAGPRS.789
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.790
     *            .FALSE.,FOUND)                                                 DIAGPRS.791
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       19DEC02.4
            CALL WRITDAD(D33,'QQ      ',IDAD3D,I1,J1,K1,                         19DEC02.5
     *                I3DSTART,0)                                                DIAGPRS.797
            I3DSTART=I3DSTART+1                                                  DIAGPRS.798
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.799
     *         .FALSE.,FOUND)                                                    DIAGPRS.800
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.801
     *         .FALSE.,FOUND)                                                    DIAGPRS.802
            CALL READDAD(D33,'QQ      ',IDAD3D,I1,J1,K1,0,                       19DEC02.6
     *         .FALSE.,FOUND)                                                    DIAGPRS.804
            CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                        DIAGPRS.805
     *         .FALSE.,FOUND)                                                    DIAGPRS.806
            CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                        DIAGPRS.807
     *         .FALSE.,FOUND)                                                    DIAGPRS.808
            CALL SFCPRS(D32,D33,D31,D21,D22,P,                                   19DEC02.7
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.810
         if(FIELD(1:6).EQ.'HDIFF ') THEN                                         19DEC02.8
            CALL READDAD(D32,'H       ',IDAD3D,I1,J1,K1,0,                       19DEC02.9
     *         .FALSE.,FOUND)                                                    19DEC02.10
            VARNAM(1:8)='HINTEG-H'                                               19DEC02.11
            call diffh(d31,d32,I1,J1,K1)                                         19DEC02.12
         endif                                                                   19DEC02.13
         IF(UNIT(1:1).EQ.'m') THEN                                               DIAGPRS.819
            UNIT(1:8)='m       '                                                 DIAGPRS.820
            UNITS(1:8)='m       '                                                DIAGPRS.821
         ELSE IF(UNIT(1:2).EQ.'ft') THEN                                         DIAGPRS.822
            CALL M2FT(D31,I1,J1,K1,1)                                            DIAGPRS.823
            UNIT(1:8)='ft      '                                                 DIAGPRS.824
            UNITS(1:8)='ft      '                                                DIAGPRS.825
         ELSE                                                                    DIAGPRS.826
            UNIT(1:8)='m       '                                                 DIAGPRS.827
            UNITS(1:8)='m       '                                                DIAGPRS.828
         END IF                                                                  DIAGPRS.829
C                                                                                DIAGPRS.830
      ELSE IF(FIELD(1:5).EQ.'MDIV ') THEN    ! MOISTURE DIVERGENCE               DIAGPRS.831
        VARNAM(1:8) = 'MDIVERG '                                                 DIAGPRS.832
        CNT=CONT                                                                 DIAGPRS.833
        NPASS=ISMTHR                                                             DIAGPRS.834
        ICRSDOT=1                                                                DIAGPRS.835
        KDIM='3D'                                                                DIAGPRS.836
        IF(PROG(1:6).EQ.'RAWSFC') THEN                                           DIAGPRS.837
           PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                         DIAGPRS.838
           IERROR = 1                                                            DIAGPRS.839
           RETURN                                                                DIAGPRS.840
        ELSE                                                                     DIAGPRS.841
          IF((PROG(1:6).EQ.'MMOUTP') .OR.                                        DIAGPRS.842
     *       (PROG(1:6).EQ.'MM5PRS') .OR.                                        DIAGPRS.843
     *       (PROG(1:6).EQ.'MM4NHP') .OR.                                        DIAGPRS.844
     *       (PROG(1:6).EQ.'MZIGPR')) THEN                                       DIAGPRS.845
            CALL READDAD(D31,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.846
     *         DIAGS,FOUND)                                                      DIAGPRS.847
            IF (.NOT. FOUND) THEN                                                DIAGPRS.848
              PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                      DIAGPRS.849
              IERROR = 1                                                         DIAGPRS.850
              RETURN                                                             DIAGPRS.851
            ENDIF                                                                DIAGPRS.852
          ELSE                                                                   DIAGPRS.853
            CALL READDAD(D33,'RH      ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.854
     *         DIAGS,FOUND)                                                      DIAGPRS.855
            IF (.NOT. FOUND) THEN                                                DIAGPRS.856
              PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                      DIAGPRS.857
              IERROR = 1                                                         DIAGPRS.858
              RETURN                                                             DIAGPRS.859
            ENDIF                                                                DIAGPRS.860
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.861
     *         .FALSE.,FOUND)                                                    DIAGPRS.862
            CALL MXRATPRS(D33,D32,P,D21,I1,J1,K1,0,D31)                          DIAGPRS.863
          ENDIF                                                                  DIAGPRS.864
          CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                         DIAGPRS.865
     *        .FALSE.,FOUND)                                                     DIAGPRS.866
          CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                         DIAGPRS.867
     *        .FALSE.,FOUND)                                                     DIAGPRS.868
          CALL READDAD(D21,'MAPFACDT',IDAD2D,I1,J1, 1,0,                         DIAGPRS.869
     *        .FALSE.,FOUND)                                                     DIAGPRS.870
          CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                         DIAGPRS.871
     *        .FALSE.,FOUND)                                                     DIAGPRS.872
          CALL MDIV(D33,D32,D21,D22,D23,I1,J1,K1,DS,D31)                         DIAGPRS.873
C         CALL WRITDAD(D31,'MDIVERG ',IDAD3D,I1,J1,K1,I3DSTART,0)                DIAGPRS.874
C         I3DSTART=I3DSTART+1                                                    DIAGPRS.875
          IF(UNIT(1:3).EQ.'1/s') THEN                                            DIAGPRS.876
             UNIT(1:8)='1/s     '                                                DIAGPRS.877
             UNITS(1:8)='1/s     '                                               DIAGPRS.878
          ELSE IF(UNIT(1:7).EQ.'10**7/s') THEN                                   DIAGPRS.879
             CALL SCALE(D31,'MULT',10000000.,I1,J1,K1,I1,J1,1)                   DIAGPRS.880
             UNIT(1:8)='10**7/s '                                                DIAGPRS.881
             UNITS(1:8)='10**7/s '                                               DIAGPRS.882
          ELSE                                                                   DIAGPRS.883
             UNIT(1:8)='1/s     '                                                DIAGPRS.884
             UNITS(1:8)='1/s     '                                               DIAGPRS.885
          ENDIF                                                                  DIAGPRS.886
        ENDIF                                                                    DIAGPRS.887
C                                                                                DIAGPRS.888
      ELSE IF(FIELD(1:4).EQ.'AXW ') THEN    ! ALONG CROSS SECTION WINDS          DIAGPRS.889
         VARNAM(1:8)='AXW     '                                                  DIAGPRS.890
         CNT=CONT                                                                DIAGPRS.891
         NPASS=ISMTHR                                                            DIAGPRS.892
         ICRSDOT=0                                                               DIAGPRS.893
         KDIM='3D'                                                               DIAGPRS.894
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.895
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.896
            IERROR=1                                                             DIAGPRS.897
            RETURN                                                               DIAGPRS.898
         ENDIF                                                                   DIAGPRS.899
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.900
     *      .FALSE.,FOUND)                                                       DIAGPRS.901
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.902
     *      .FALSE.,FOUND)                                                       DIAGPRS.903
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGPRS.904
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.905
            UNIT(1:8)='m/s     '                                                 DIAGPRS.906
            UNITS(1:8)='m/s     '                                                DIAGPRS.907
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGPRS.908
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGPRS.909
            UNIT(1:8)='kt      '                                                 DIAGPRS.910
            UNITS(1:8)='kt      '                                                DIAGPRS.911
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.912
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.913
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.914
            UNITS(1:8)='cm/s    '                                                DIAGPRS.915
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.916
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.917
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.918
            UNITS(1:8)='mm/s    '                                                DIAGPRS.919
         ELSE                                                                    DIAGPRS.920
            UNIT(1:8)='m/s     '                                                 DIAGPRS.921
            UNITS(1:8)='m/s     '                                                DIAGPRS.922
         ENDIF                                                                   DIAGPRS.923
      ELSE IF(FIELD(1:4).EQ.'XXW ') THEN  ! NORMAL CROSS SECTION WINDS           DIAGPRS.924
         VARNAM(1:8)='XXW     '                                                  DIAGPRS.925
         CNT=CONT                                                                DIAGPRS.926
         NPASS=ISMTHR                                                            DIAGPRS.927
         ICRSDOT=0                                                               DIAGPRS.928
         KDIM='3D'                                                               DIAGPRS.929
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.930
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.931
            IERROR=1                                                             DIAGPRS.932
            RETURN                                                               DIAGPRS.933
         ENDIF                                                                   DIAGPRS.934
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.935
     *      .FALSE.,FOUND)                                                       DIAGPRS.936
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.937
     *      .FALSE.,FOUND)                                                       DIAGPRS.938
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGPRS.939
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.940
            UNIT(1:8)='m/s     '                                                 DIAGPRS.941
            UNITS(1:8)='m/s     '                                                DIAGPRS.942
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGPRS.943
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGPRS.944
            UNIT(1:8)='kt      '                                                 DIAGPRS.945
            UNITS(1:8)='kt      '                                                DIAGPRS.946
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.947
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.948
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.949
            UNITS(1:8)='cm/s    '                                                DIAGPRS.950
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.951
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.952
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.953
            UNITS(1:8)='mm/s    '                                                DIAGPRS.954
         ELSE                                                                    DIAGPRS.955
            UNIT(1:8)='m/s     '                                                 DIAGPRS.956
            UNITS(1:8)='m/s     '                                                DIAGPRS.957
         ENDIF                                                                   DIAGPRS.958
      ELSE IF(FIELD(1:4).EQ.'CXW ') THEN  ! CROSS SECTION CIRCULATION            DIAGPRS.959
         VARNAM(1:8)='CXW     '                                                  DIAGPRS.960
         CNT=AMAX1(CONT,1.)                                                      DIAGPRS.961
         NPASS=ISMTHR                                                            DIAGPRS.962
         ICRSDOT=0                                                               DIAGPRS.963
         KDIM='3D'                                                               DIAGPRS.964
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.965
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.966
            IERROR=1                                                             DIAGPRS.967
            RETURN                                                               DIAGPRS.968
         ENDIF                                                                   DIAGPRS.969
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.970
     *      .FALSE.,FOUND)                                                       DIAGPRS.971
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.972
     *      .FALSE.,FOUND)                                                       DIAGPRS.973
         CALL READDAD(D21,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.974
     *        .FALSE.,FOUND)                                                     DIAGPRS.975
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.976
     *        .FALSE.,FOUND)                                                     DIAGPRS.977
         CALL DIVERG(D33,D32,D21,D22,I1,J1,K1,DS,D31)                            DIAGPRS.978
         CALL READDAD(D23,'P SFC   ',IDAD2D,I1,J1, 1,0,                          DIAGPRS.979
     *        .FALSE.,FOUND)                                                     DIAGPRS.980
         CALL READDAD(D33(1,1),'U       ',IDAD3D,I1,J1, 1,0,                     DIAGPRS.981
     *      .FALSE.,FOUND)                                                       DIAGPRS.982
         CALL READDAD(D33(1,2),'V       ',IDAD3D,I1,J1, 1,0,                     DIAGPRS.983
     *      .FALSE.,FOUND)                                                       DIAGPRS.984
         CALL OMEGAP(D31,D33(1,1),D33(1,2),                                      DIAGPRS.985
     *      D21,D22,D23,P,DS,I1,J1,K1,PROG,                                      DIAGPRS.986
     *      D32)                                                                 DIAGPRS.987
         CALL SCALE(D32,'MULT',-1.,I1,J1,K1,I1,J1,1)                             DIAGPRS.988
         CALL WRITDAD(D32,'OMG*CXW ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.989
         I3DSTART=I3DSTART+1                                                     DIAGPRS.990
         CALL READDAD(D32,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.991
     *      .FALSE.,FOUND)                                                       DIAGPRS.992
         CALL READDAD(D33,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.993
     *      .FALSE.,FOUND)                                                       DIAGPRS.994
         CALL CRSWINDS(D32,D33,I1,J1,K1,FIELD,D31)                               DIAGPRS.995
         FIELD(1:4)='BARB'                                                       DIAGPRS.996
         CALL READDAD(D32,'OMG*CXW ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.997
     *      .FALSE.,FOUND)                                                       DIAGPRS.998
C        CALL WRITDAD(D31,'CXW     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.999
C        I3DSTART=I3DSTART+1                                                     DIAGPRS.1000
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.1001
            UNIT(1:8)='m/s     '                                                 DIAGPRS.1002
            UNITS(1:8)='m/s     '                                                DIAGPRS.1003
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGPRS.1004
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGPRS.1005
            UNIT(1:8)='kt      '                                                 DIAGPRS.1006
            UNITS(1:8)='kt      '                                                DIAGPRS.1007
         ELSE                                                                    DIAGPRS.1008
            UNIT(1:8)='m/s     '                                                 DIAGPRS.1009
            UNITS(1:8)='m/s     '                                                DIAGPRS.1010
         ENDIF                                                                   DIAGPRS.1011
      ELSE IF(FIELD(1:4).EQ.'CUV ') THEN  ! PROFILERISH PLOT                     DIAGPRS.1012
         VARNAM(1:8)='CUV     '                                                  DIAGPRS.1013
         CNT=AMAX1(CONT,1.)                                                      DIAGPRS.1014
         NPASS=ISMTHR                                                            DIAGPRS.1015
         ICRSDOT=0                                                               DIAGPRS.1016
         KDIM='3D'                                                               DIAGPRS.1017
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1018
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1019
            IERROR=1                                                             DIAGPRS.1020
            RETURN                                                               DIAGPRS.1021
         ENDIF                                                                   DIAGPRS.1022
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1023
     *      .FALSE.,FOUND)                                                       DIAGPRS.1024
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1025
     *      .FALSE.,FOUND)                                                       DIAGPRS.1026
         CALL READDAD(D21,'LONGIDOT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1027
     *        .FALSE.,FOUND)                                                     DIAGPRS.1028
         CALL MAP2MET(D31,D32,D21,I1,J1,K1,XLONC)                                DIAGPRS.1029
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.1030
            UNIT(1:8)='m/s     '                                                 DIAGPRS.1031
            UNITS(1:8)='m/s     '                                                DIAGPRS.1032
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGPRS.1033
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGPRS.1034
            CALL MPS2KT(D32, I1, J1, K1, 0)                                      DIAGPRS.1035
            UNIT(1:8)='kt      '                                                 DIAGPRS.1036
            UNITS(1:8)='kt      '                                                DIAGPRS.1037
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.1038
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.1039
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.1040
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.1041
            UNITS(1:8)='cm/s    '                                                DIAGPRS.1042
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.1043
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.1044
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.1045
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.1046
            UNITS(1:8)='mm/s    '                                                DIAGPRS.1047
         ELSE                                                                    DIAGPRS.1048
            UNIT(1:8)='m/s     '                                                 DIAGPRS.1049
            UNITS(1:8)='m/s     '                                                DIAGPRS.1050
         ENDIF                                                                   DIAGPRS.1051
         CALL WRITDAD(D31,'U MET   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.1052
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1053
         CALL WRITDAD(D32,'V MET   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.1054
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1055
      ELSE IF(FIELD(1:3).EQ.'AM ') THEN  ! ABSOLUTE MOMENTUM                     DIAGPRS.1056
         VARNAM(1:8)='AM      '                                                  DIAGPRS.1057
         CNT=CONT                                                                DIAGPRS.1058
         NPASS=ISMTHR                                                            DIAGPRS.1059
         ICRSDOT=0                                                               DIAGPRS.1060
         KDIM='3D'                                                               DIAGPRS.1061
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1062
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1063
            IERROR=1                                                             DIAGPRS.1064
            RETURN                                                               DIAGPRS.1065
         ENDIF                                                                   DIAGPRS.1066
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1067
     *      .FALSE.,FOUND)                                                       DIAGPRS.1068
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1069
     *      .FALSE.,FOUND)                                                       DIAGPRS.1070
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGPRS.1071
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.1072
            UNIT(1:8)='m/s     '                                                 DIAGPRS.1073
            UNITS(1:8)='m/s     '                                                DIAGPRS.1074
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGPRS.1075
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGPRS.1076
            UNIT(1:8)='kt      '                                                 DIAGPRS.1077
            UNITS(1:8)='kt      '                                                DIAGPRS.1078
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.1079
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.1080
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.1081
            UNITS(1:8)='cm/s    '                                                DIAGPRS.1082
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.1083
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.1084
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.1085
            UNITS(1:8)='mm/s    '                                                DIAGPRS.1086
         ELSE                                                                    DIAGPRS.1087
            UNIT(1:8)='m/s     '                                                 DIAGPRS.1088
            UNITS(1:8)='m/s     '                                                DIAGPRS.1089
         ENDIF                                                                   DIAGPRS.1090
C                                                                                DIAGPRS.1091
      ELSE IF(FIELD(1:4).EQ.'MSE '    ) THEN    ! MOIST STATIC ENERGY            DIAGPRS.1092
         VARNAM(1:8)='MSE     '                                                  DIAGPRS.1093
         CNT=CONT                                                                DIAGPRS.1094
         NPASS=ISMTHR                                                            DIAGPRS.1095
         ICRSDOT=1                                                               DIAGPRS.1096
         KDIM='3D'                                                               DIAGPRS.1097
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1098
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1099
            IERROR=1                                                             DIAGPRS.1100
            RETURN                                                               DIAGPRS.1101
         ELSE IF(PROG(1:6).EQ.'REGRID') THEN                                     DIAGPRS.1102
            CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1103
     *      .FALSE.,FOUND)                                                       DIAGPRS.1104
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1105
     *      .FALSE.,FOUND)                                                       DIAGPRS.1106
            CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                          DIAGPRS.1107
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1108
     *                I3DSTART,0)                                                DIAGPRS.1109
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1110
            CALL READDAD(D33,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1111
     *         .FALSE.,FOUND)                                                    DIAGPRS.1112
            CALL DOT2CRS(D33(1,2),I1,J1,K1-1,I1,J1)                              DIAGPRS.1113
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.1114
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.1115
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.1116
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.1117
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.1118
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.1119
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1120
     *            .FALSE.,FOUND)                                                 DIAGPRS.1121
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1122
     *            .FALSE.,FOUND)                                                 DIAGPRS.1123
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.1124
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.1125
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.1126
            END IF                                                               DIAGPRS.1127
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1128
     *                I3DSTART,0)                                                DIAGPRS.1129
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1130
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1131
     *         .FALSE.,FOUND)                                                    DIAGPRS.1132
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1133
     *         .FALSE.,FOUND)                                                    DIAGPRS.1134
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1135
     *         .FALSE.,FOUND)                                                    DIAGPRS.1136
            CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                        DIAGPRS.1137
     *         .FALSE.,FOUND)                                                    DIAGPRS.1138
            CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                        DIAGPRS.1139
     *         .FALSE.,FOUND)                                                    DIAGPRS.1140
            CALL SFCPRS(D32,D33,D31,D21,D22,P,                                   DIAGPRS.1141
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.1142
            CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                         DIAGPRS.1143
     *                  I3DSTART,0)                                              DIAGPRS.1144
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1145
            CALL READDAD(D33,'GHT INTG',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1146
     *      .FALSE.,FOUND)                                                       DIAGPRS.1147
         ENDIF                                                                   DIAGPRS.1148
         CALL READDAD(D31,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1149
     *   .FALSE.,FOUND)                                                          DIAGPRS.1150
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1151
     *   .FALSE.,FOUND)                                                          DIAGPRS.1152
         CALL MSE(D32,D31,D33,I1,J1,K1,D31)                                      DIAGPRS.1153
         CALL WRITDAD(D31,'MSE     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.1154
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1155
         IF(UNIT(1:4).EQ.'J/kg') THEN                                            DIAGPRS.1156
            UNIT(1:8)='J/kg    '                                                 DIAGPRS.1157
            UNITS(1:8)='J/kg    '                                                DIAGPRS.1158
         ELSE IF(UNIT(1:5).EQ.'KJ/kg') THEN                                      DIAGPRS.1159
            CALL SCALE(D31,'DIV ',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.1160
            UNIT(1:8)='KJ/kg   '                                                 DIAGPRS.1161
            UNITS(1:8)='KJ/kg   '                                                DIAGPRS.1162
         ELSE                                                                    DIAGPRS.1163
            UNIT(1:8)='J/kg    '                                                 DIAGPRS.1164
            UNITS(1:8)='J/kg    '                                                DIAGPRS.1165
         ENDIF                                                                   DIAGPRS.1166
C                                                                                DIAGPRS.1167
      ELSE IF(FIELD(1:4).EQ.'MSS '    ) THEN    ! SAT MOIST STATIC ENERG         DIAGPRS.1168
         VARNAM(1:8)='MSS     '                                                  DIAGPRS.1169
         CNT=CONT                                                                DIAGPRS.1170
         NPASS=ISMTHR                                                            DIAGPRS.1171
         ICRSDOT=1                                                               DIAGPRS.1172
         KDIM='3D'                                                               DIAGPRS.1173
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1174
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1175
            IERROR=1                                                             DIAGPRS.1176
            RETURN                                                               DIAGPRS.1177
         ELSE IF(PROG(1:6).EQ.'REGRID') THEN                                     DIAGPRS.1178
            CALL READDAD(D33,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1179
     *         .FALSE.,FOUND)                                                    DIAGPRS.1180
            CALL DOT2CRS(D33(1,2),I1,J1,K1-1,I1,J1)                              DIAGPRS.1181
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.1182
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.1183
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.1184
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.1185
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.1186
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.1187
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1188
     *            .FALSE.,FOUND)                                                 DIAGPRS.1189
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1190
     *            .FALSE.,FOUND)                                                 DIAGPRS.1191
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.1192
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.1193
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.1194
            END IF                                                               DIAGPRS.1195
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1196
     *                I3DSTART,0)                                                DIAGPRS.1197
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1198
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1199
     *         .FALSE.,FOUND)                                                    DIAGPRS.1200
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1201
     *         .FALSE.,FOUND)                                                    DIAGPRS.1202
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1203
     *         .FALSE.,FOUND)                                                    DIAGPRS.1204
            CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                        DIAGPRS.1205
     *         .FALSE.,FOUND)                                                    DIAGPRS.1206
            CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                        DIAGPRS.1207
     *         .FALSE.,FOUND)                                                    DIAGPRS.1208
            CALL SFCPRS(D32,D33,D31,D21,D22,P,                                   DIAGPRS.1209
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.1210
            CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                         DIAGPRS.1211
     *                  I3DSTART,0)                                              DIAGPRS.1212
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1213
            CALL READDAD(D33,'GHT INTG',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1214
     *      .FALSE.,FOUND)                                                       DIAGPRS.1215
         ENDIF                                                                   DIAGPRS.1216
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1217
     *   .FALSE.,FOUND)                                                          DIAGPRS.1218
         CALL MSESP(D32,D33,P,I1,J1,K1,D31)                                      DIAGPRS.1219
         CALL WRITDAD(D31,'MSS     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.1220
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1221
         IF(UNIT(1:4).EQ.'J/kg') THEN                                            DIAGPRS.1222
            UNIT(1:8)='J/kg    '                                                 DIAGPRS.1223
            UNITS(1:8)='J/kg    '                                                DIAGPRS.1224
         ELSE IF(UNIT(1:5).EQ.'KJ/kg') THEN                                      DIAGPRS.1225
            CALL SCALE(D31,'DIV ',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.1226
            UNIT(1:8)='KJ/kg   '                                                 DIAGPRS.1227
            UNITS(1:8)='KJ/kg   '                                                DIAGPRS.1228
         ELSE                                                                    DIAGPRS.1229
            UNIT(1:8)='J/kg    '                                                 DIAGPRS.1230
            UNITS(1:8)='J/kg    '                                                DIAGPRS.1231
         ENDIF                                                                   DIAGPRS.1232
C                                                                                DIAGPRS.1233
C                                                                                DIAGPRS.1234
      ELSE IF(FIELD(1:4).EQ.'DIV ') THEN    ! DIVERGENCE                         DIAGPRS.1235
        VARNAM(1:8) = 'DIVERG  '                                                 DIAGPRS.1236
        CNT=CONT                                                                 DIAGPRS.1237
        NPASS=ISMTHR                                                             DIAGPRS.1238
        ICRSDOT=1                                                                DIAGPRS.1239
        KDIM='3D'                                                                DIAGPRS.1240
        IF(PROG(1:6).EQ.'RAWSFC') THEN                                           DIAGPRS.1241
           PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                         DIAGPRS.1242
           IERROR = 1                                                            DIAGPRS.1243
           RETURN                                                                DIAGPRS.1244
        ENDIF                                                                    DIAGPRS.1245
        CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                           DIAGPRS.1246
     *        .FALSE.,FOUND)                                                     DIAGPRS.1247
        CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                           DIAGPRS.1248
     *        .FALSE.,FOUND)                                                     DIAGPRS.1249
        CALL READDAD(D21,'MAPFACDT',IDAD2D,I1,J1, 1,0,                           DIAGPRS.1250
     *        .FALSE.,FOUND)                                                     DIAGPRS.1251
        CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                           DIAGPRS.1252
     *        .FALSE.,FOUND)                                                     DIAGPRS.1253
        CALL DIVERG(D33,D32,D21,D22,I1,J1,K1,DS,D31)                             DIAGPRS.1254
C       CALL WRITDAD(D31,'DIVERG  ',IDAD3D,I1,J1,K1,I3DSTART,0)                  DIAGPRS.1255
C       I3DSTART=I3DSTART+1                                                      DIAGPRS.1256
        IF(UNIT(1:3).EQ.'1/s') THEN                                              DIAGPRS.1257
           UNIT(1:8)='1/s     '                                                  DIAGPRS.1258
           UNITS(1:8)='1/s     '                                                 DIAGPRS.1259
        ELSE IF(UNIT(1:7).EQ.'10**5/s') THEN                                     DIAGPRS.1260
           CALL SCALE(D31,'MULT',100000.,I1,J1,K1,I1,J1,1)                       DIAGPRS.1261
           UNIT(1:8)='10**5/s '                                                  DIAGPRS.1262
           UNITS(1:8)='10**5/s '                                                 DIAGPRS.1263
        ELSE                                                                     DIAGPRS.1264
           UNIT(1:8)='1/s     '                                                  DIAGPRS.1265
           UNITS(1:8)='1/s     '                                                 DIAGPRS.1266
        ENDIF                                                                    DIAGPRS.1267
      ELSE IF(FIELD(1:3).EQ.'THK') THEN    ! THICKNESS                           DIAGPRS.1268
         VARNAM(1:8) = 'THK'//' '//FIELD(4:4)//'-'//FIELD(5:5)//' '              DIAGPRS.1269
         CNT=CONT                                                                DIAGPRS.1270
         NPASS=ISMTHR                                                            DIAGPRS.1271
         ICRSDOT=1                                                               DIAGPRS.1272
         KDIM='2D'                                                               DIAGPRS.1273
         IF(PROG(1:6).EQ.'REGRID') THEN                                          DIAGPRS.1274
            CALL READDAD(D32,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1275
     *         .FALSE.,FOUND)                                                    DIAGPRS.1276
            CALL DOT2CRS(D32(1,2),I1,J1,K1-1,I1,J1)                              DIAGPRS.1277
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.1278
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.1279
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.1280
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.1281
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.1282
            CALL READDAD(D32,'GHT INTG',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1283
     *         DIAGS,FOUND)                                                      DIAGPRS.1284
            IF(.NOT.FOUND) THEN                                                  DIAGPRS.1285
               IF(IDRY.NE.1) THEN                                                DIAGPRS.1286
                  CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                 DIAGPRS.1287
     *               .FALSE.,FOUND)                                              DIAGPRS.1288
                  CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                 DIAGPRS.1289
     *               .FALSE.,FOUND)                                              DIAGPRS.1290
                  CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                    DIAGPRS.1291
               ELSE IF(IDRY.EQ.1) THEN                                           DIAGPRS.1292
                  CALL CLEAR(D33,I1,J1,K1)                                       DIAGPRS.1293
               END IF                                                            DIAGPRS.1294
               CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1295
     *            .FALSE.,FOUND)                                                 DIAGPRS.1296
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1297
     *            .FALSE.,FOUND)                                                 DIAGPRS.1298
               CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                     DIAGPRS.1299
     *            .FALSE.,FOUND)                                                 DIAGPRS.1300
               CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                     DIAGPRS.1301
     *            .FALSE.,FOUND)                                                 DIAGPRS.1302
               CALL SFCPRS(D32,D33,D31,D21,D22,P,                                DIAGPRS.1303
     *                  I1,J1,K1,D23,D24,PROG)                                   DIAGPRS.1304
               CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                      DIAGPRS.1305
     *                     I3DSTART,0)                                           DIAGPRS.1306
               I3DSTART=I3DSTART+1                                               DIAGPRS.1307
               CALL READDAD(D32,'GHT INTG',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1308
     *            .FALSE.,FOUND)                                                 DIAGPRS.1309
            END IF                                                               DIAGPRS.1310
         ELSE IF(PROG(1:6).EQ.'RAWSFC') THEN                                     DIAGPRS.1311
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1312
            IERROR=1                                                             DIAGPRS.1313
            RETURN                                                               DIAGPRS.1314
        ENDIF                                                                    DIAGPRS.1315
        CALL THCKNS (D32,I1,J1,K1,D31,ICRSDOT,FIELD,P)                           DIAGPRS.1316
C       CALL WRITDAD(D31,VARNAM(1:8),IDAD2D,I1,J1,1,I2DSTART,0)                  DIAGPRS.1317
C       I2DSTART=I2DSTART+1                                                      DIAGPRS.1318
        IF(UNIT(1:1).EQ.'m') THEN                                                DIAGPRS.1319
           UNIT(1:8)='m       '                                                  DIAGPRS.1320
           UNITS(1:8)='m       '                                                 DIAGPRS.1321
        ELSE IF(UNIT(1:2).EQ.'ft') THEN                                          DIAGPRS.1322
           CALL M2FT(D31,I1,J1,1,1)                                              DIAGPRS.1323
           UNIT(1:8)='ft      '                                                  DIAGPRS.1324
           UNITS(1:8)='ft      '                                                 DIAGPRS.1325
        ELSE                                                                     DIAGPRS.1326
           UNIT(1:8)='m       '                                                  DIAGPRS.1327
           UNITS(1:8)='m       '                                                 DIAGPRS.1328
        ENDIF                                                                    DIAGPRS.1329
      ELSE IF(FIELD(1:8).EQ.'OBS/BOX '  ) THEN    ! 4DDA OBS DENSITY             DIAGPRS.1330
         VARNAM(1:8)='OBS/BOX '                                                  DIAGPRS.1331
         IF(CONT.GT.0.1) THEN                                                    DIAGPRS.1332
            CNT=CONT                                                             DIAGPRS.1333
         ELSE                                                                    DIAGPRS.1334
            CNT=1.                                                               DIAGPRS.1335
         END IF                                                                  DIAGPRS.1336
         NPASS=ISMTHR                                                            DIAGPRS.1337
         ICRSDOT=1                                                               DIAGPRS.1338
         KDIM='2D'                                                               DIAGPRS.1339
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1340
            CALL READDAD(D31,'OBS/BOX ',IDAD2D,I1,J1, 1,0,                       DIAGPRS.1341
     *         .FALSE.,FOUND)                                                    DIAGPRS.1342
         ELSE                                                                    DIAGPRS.1343
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1344
            IERROR=1                                                             DIAGPRS.1345
            RETURN                                                               DIAGPRS.1346
         END IF                                                                  DIAGPRS.1347
         UNIT(1:8)='STATIONS'                                                    DIAGPRS.1348
         UNITS(1:8)='STATIONS'                                                   DIAGPRS.1349
C                                                                                DIAGPRS.1350
      ELSE IF(FIELD(1:4).EQ.'OMG ') THEN    ! OMEGA                              DIAGPRS.1351
        VARNAM(1:8) = 'OMEGA   '                                                 DIAGPRS.1352
        CNT=CONT                                                                 DIAGPRS.1353
        NPASS=ISMTHR                                                             DIAGPRS.1354
        ICRSDOT=1                                                                DIAGPRS.1355
        KDIM='3D'                                                                DIAGPRS.1356
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1357
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1358
            IERROR=1                                                             DIAGPRS.1359
            RETURN                                                               DIAGPRS.1360
        ENDIF                                                                    DIAGPRS.1361
        CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                           DIAGPRS.1362
     *        .FALSE.,FOUND)                                                     DIAGPRS.1363
        CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                           DIAGPRS.1364
     *        .FALSE.,FOUND)                                                     DIAGPRS.1365
        CALL READDAD(D21,'MAPFACDT',IDAD2D,I1,J1, 1,0,                           DIAGPRS.1366
     *        .FALSE.,FOUND)                                                     DIAGPRS.1367
        CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                           DIAGPRS.1368
     *        .FALSE.,FOUND)                                                     DIAGPRS.1369
        CALL DIVERG(D31,D32,D21,D22,I1,J1,K1,DS,D33)                             DIAGPRS.1370
        CALL READDAD(D23,'P SFC   ',IDAD2D,I1,J1, 1,0,                           DIAGPRS.1371
     *        DIAGS,FOUND)                                                       DIAGPRS.1372
        IF(.NOT.FOUND) THEN                                                      DIAGPRS.1373
           PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                         DIAGPRS.1374
           IERROR = 1                                                            DIAGPRS.1375
           RETURN                                                                DIAGPRS.1376
        ENDIF                                                                    DIAGPRS.1377
        CALL READDAD(D32(1,1),'U       ',IDAD3D,I1,J1, 1,0,                      DIAGPRS.1378
     *      .FALSE.,FOUND)                                                       DIAGPRS.1379
        CALL READDAD(D32(1,2),'V       ',IDAD3D,I1,J1, 1,0,                      DIAGPRS.1380
     *      .FALSE.,FOUND)                                                       DIAGPRS.1381
        CALL OMEGAP(D33,D32(1,1),D32(1,2),                                       DIAGPRS.1382
     *      D21,D22,D23,P,DS,I1,J1,K1,PROG,                                      DIAGPRS.1383
     *      D31)                                                                 DIAGPRS.1384
C       CALL WRITDAD(D31,'OMEGA   ',IDAD3D,I1,J1,K1,I3DSTART,0)                  DIAGPRS.1385
C       I3DSTART=I3DSTART+1                                                      DIAGPRS.1386
        IF(UNIT(1:4).EQ.'mb/s') THEN                                             DIAGPRS.1387
           UNIT(1:8)='mb/s    '                                                  DIAGPRS.1388
           UNITS(1:8)='mb/s    '                                                 DIAGPRS.1389
        ELSE IF(UNIT(1:4).EQ.'ub/s') THEN                                        DIAGPRS.1390
           CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                         DIAGPRS.1391
           UNIT(1:8)='ub/s    '                                                  DIAGPRS.1392
           UNITS(1:8)='ub/s    '                                                 DIAGPRS.1393
        ELSE                                                                     DIAGPRS.1394
           UNIT(1:8)='mb/s    '                                                  DIAGPRS.1395
           UNITS(1:8)='mb/s    '                                                 DIAGPRS.1396
        ENDIF                                                                    DIAGPRS.1397
C                                                                                DIAGPRS.1398
      ELSE IF((FIELD(1:5).EQ.'PSLV '     ).OR.                                   DIAGPRS.1399
     *        (FIELD(1:6).EQ.'PSLV2 '    ))THEN    ! SEA LEVEL PRESSURE          DIAGPRS.1400
         VARNAM(1:8)='SEA PRES'                                                  DIAGPRS.1401
         CNT=CONT                                                                DIAGPRS.1402
         NPASS=ISMTHR                                                            DIAGPRS.1403
         ICRSDOT=1                                                               DIAGPRS.1404
         KDIM='2D'                                                               DIAGPRS.1405
         CALL READDAD(D31,'PSEALVLC',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1406
     *      .FALSE.,FOUND)                                                       DIAGPRS.1407
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGPRS.1408
            UNIT(1:8)='mb      '                                                 DIAGPRS.1409
            UNITS(1:8)='mb      '                                                DIAGPRS.1410
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGPRS.1411
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,1)                        DIAGPRS.1412
            UNIT(1:8)='Pa      '                                                 DIAGPRS.1413
            UNITS(1:8)='Pa      '                                                DIAGPRS.1414
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGPRS.1415
            UNIT(1:8)='hPa     '                                                 DIAGPRS.1416
            UNITS(1:8)='hPa     '                                                DIAGPRS.1417
         ELSE IF(UNIT(1:5).EQ.'inHg ') THEN                                      DIAGPRS.1418
            CALL SCALE(D31,'DIV ',33.86388640,I1,J1, 1,I1,J1,1)                  DIAGPRS.1419
            UNIT(1:8)='inHg    '                                                 DIAGPRS.1420
            UNITS(1:8)='inHg    '                                                DIAGPRS.1421
         ELSE                                                                    DIAGPRS.1422
            UNIT(1:8)='mb      '                                                 DIAGPRS.1423
            UNITS(1:8)='mb      '                                                DIAGPRS.1424
         END IF                                                                  DIAGPRS.1425
C                                                                                DIAGPRS.1426
      ELSE IF(FIELD(1:5).EQ.'PSFC '     ) THEN    ! SURFACE PRESSURE             DIAGPRS.1427
         VARNAM(1:8)='SFC PRES'                                                  DIAGPRS.1428
         CNT=CONT                                                                DIAGPRS.1429
         NPASS=ISMTHR                                                            DIAGPRS.1430
         ICRSDOT=1                                                               DIAGPRS.1431
         KDIM='2D'                                                               DIAGPRS.1432
         IF((PROG(1:6).EQ.'MMOUTP').OR.                                          DIAGPRS.1433
     *      (PROG(1:6).EQ.'RAWSFC').OR.                                          DIAGPRS.1434
     *      (PROG(1:6).EQ.'MM5PRS') .OR.                                         DIAGPRS.1435
     *      (PROG(1:6).EQ.'MM4NHP') .OR.                                         DIAGPRS.1436
     *      (PROG(1:6).EQ.'MZIGPR')) THEN                                        DIAGPRS.1437
         CALL READDAD(D31,'P SFC   ',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1438
     *      .FALSE.,FOUND)                                                       DIAGPRS.1439
         ELSE                                                                    DIAGPRS.1440
         CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1441
     *      .FALSE.,FOUND)                                                       DIAGPRS.1442
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1443
     *      .FALSE.,FOUND)                                                       DIAGPRS.1444
         CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                             DIAGPRS.1445
         CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                            DIAGPRS.1446
     *                I3DSTART,0)                                                DIAGPRS.1447
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1448
         CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1449
     *      .FALSE.,FOUND)                                                       DIAGPRS.1450
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1451
     *      .FALSE.,FOUND)                                                       DIAGPRS.1452
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1453
     *      .FALSE.,FOUND)                                                       DIAGPRS.1454
         CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                           DIAGPRS.1455
     *      .FALSE.,FOUND)                                                       DIAGPRS.1456
         CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                           DIAGPRS.1457
     *      .FALSE.,FOUND)                                                       DIAGPRS.1458
         CALL SFCPRS(D32,D33,D31,D21,D22,P,                                      DIAGPRS.1459
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.1460
         CALL EQUATE(D23,I1,J1,1,1,D31,I1,J1,1)                                  DIAGPRS.1461
         CALL WRITDAD(D31,'P SFC   ',IDAD2D,I1,J1,1,                             DIAGPRS.1462
     *                I2DSTART,0)                                                DIAGPRS.1463
         I2DSTART=I2DSTART+1                                                     DIAGPRS.1464
         END IF                                                                  DIAGPRS.1465
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGPRS.1466
            UNIT(1:8)='mb      '                                                 DIAGPRS.1467
            UNITS(1:8)='mb      '                                                DIAGPRS.1468
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGPRS.1469
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,1)                        DIAGPRS.1470
            UNIT(1:8)='Pa      '                                                 DIAGPRS.1471
            UNITS(1:8)='Pa      '                                                DIAGPRS.1472
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGPRS.1473
            UNIT(1:8)='hPa     '                                                 DIAGPRS.1474
            UNITS(1:8)='hPa     '                                                DIAGPRS.1475
         ELSE IF(UNIT(1:5).EQ.'inHg ') THEN                                      DIAGPRS.1476
            CALL SCALE(D31,'DIV ',33.86388640,I1,J1, 1,I1,J1,1)                  DIAGPRS.1477
            UNIT(1:8)='inHg    '                                                 DIAGPRS.1478
            UNITS(1:8)='inHg    '                                                DIAGPRS.1479
         ELSE                                                                    DIAGPRS.1480
            UNIT(1:8)='mb      '                                                 DIAGPRS.1481
            UNITS(1:8)='mb      '                                                DIAGPRS.1482
         END IF                                                                  DIAGPRS.1483
C                                                                                DIAGPRS.1484
      ELSE IF(FIELD(1:3).EQ.'PV '     ) THEN    ! POTENTIAL VORTICITY            DIAGPRS.1485
         VARNAM(1:8)='PV      '                                                  DIAGPRS.1486
         CNT=CONT                                                                DIAGPRS.1487
         NPASS=ISMTHR                                                            DIAGPRS.1488
         ICRSDOT=1                                                               DIAGPRS.1489
         KDIM='3D'                                                               DIAGPRS.1490
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1491
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1492
            IERROR=1                                                             DIAGPRS.1493
            RETURN                                                               DIAGPRS.1494
         ENDIF                                                                   DIAGPRS.1495
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1496
     *      .FALSE.,FOUND)                                                       DIAGPRS.1497
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1498
     *      .FALSE.,FOUND)                                                       DIAGPRS.1499
         CALL READDAD(D33,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1500
     *      .FALSE.,FOUND)                                                       DIAGPRS.1501
         CALL READDAD(D21,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1502
     *      .FALSE.,FOUND)                                                       DIAGPRS.1503
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1504
     *      .FALSE.,FOUND)                                                       DIAGPRS.1505
         CALL READDAD(D23,'CORIOLIS',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1506
     *      .FALSE.,FOUND)                                                       DIAGPRS.1507
         CALL PVP(D31,D32,D33,D21,D22,D23,P,DS,                                  DIAGPRS.1508
     *            I1,J1,K1,D31)                                                  DIAGPRS.1509
         CALL WRITDAD(D31,'PV      ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.1510
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1511
         IF(UNIT(1:3).EQ.'PVU') THEN                                             DIAGPRS.1512
            UNIT(1:8)='PVU     '                                                 DIAGPRS.1513
            UNITS(1:8)='PVU     '                                                DIAGPRS.1514
         ELSE IF(UNIT(1:8).EQ.'KM/S^3PA') THEN                                   DIAGPRS.1515
            UNIT(1:8)='KM/S^3PA'                                                 DIAGPRS.1516
            UNITS(1:8)='KM/S^3PA'                                                DIAGPRS.1517
         ELSE                                                                    DIAGPRS.1518
            UNIT(1:8)='PVU     '                                                 DIAGPRS.1519
            UNITS(1:8)='PVU     '                                                DIAGPRS.1520
         ENDIF                                                                   DIAGPRS.1521
C                                                                                DIAGPRS.1522
      ELSE IF(FIELD(1:3).EQ.'QV '                                                DIAGPRS.1523
     *    .OR.FIELD(1:2).EQ.'Q '      ) THEN      ! MIXING RATIO                 DIAGPRS.1524
         VARNAM(1:8)='QV      '                                                  DIAGPRS.1525
         CNT=CONT                                                                DIAGPRS.1526
         NPASS=ISMTHR                                                            DIAGPRS.1527
         ICRSDOT=1                                                               DIAGPRS.1528
         KDIM='3D'                                                               DIAGPRS.1529
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1530
            CALL READDAD(D31,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1531
     *         .FALSE.,FOUND)                                                    DIAGPRS.1532
         ELSE IF((PROG(1:6).EQ.'MMOUTP').OR.                                     DIAGPRS.1533
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.1534
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.1535
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.1536
            CALL READDAD(D31,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1537
     *         DIAGS,FOUND)                                                      DIAGPRS.1538
            IF(.NOT.FOUND) THEN                                                  DIAGPRS.1539
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGPRS.1540
               IERROR=1                                                          DIAGPRS.1541
               RETURN                                                            DIAGPRS.1542
            END IF                                                               DIAGPRS.1543
         ELSE                                                                    DIAGPRS.1544
            CALL READDAD(D33,'RH      ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1545
     *         .false.,FOUND)                                                    DIAGPRS.1546
            IF(.NOT.FOUND) THEN                                                  DIAGPRS.1547
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGPRS.1548
               IERROR=1                                                          DIAGPRS.1549
               RETURN                                                            DIAGPRS.1550
            END IF                                                               DIAGPRS.1551
            CALL READDAD(D21,'P SFC   ',IDAD2D,I1,J1, 1,0,                       DIAGPRS.1552
     *      diags,FOUND)                                                         DIAGPRS.1553
            IF(.NOT.FOUND) THEN                                                  DIAGPRS.1554
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGPRS.1555
               IERROR=1                                                          DIAGPRS.1556
               RETURN                                                            DIAGPRS.1557
            END IF                                                               DIAGPRS.1558
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1559
     *         .FALSE.,FOUND)                                                    DIAGPRS.1560
            CALL MXRATPRS(D33,D32,P,D21,I1,J1,K1,2,D31)                          DIAGPRS.1561
            CALL WRITDAD(D31,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1562
     *                   I3DSTART,0)                                             DIAGPRS.1563
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1564
         END IF                                                                  DIAGPRS.1565
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGPRS.1566
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.1567
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.1568
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGPRS.1569
            UNIT(1:8)='g/g     '                                                 DIAGPRS.1570
            UNITS(1:8)='g/g     '                                                DIAGPRS.1571
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGPRS.1572
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGPRS.1573
            UNIT(1:8)='g/kg    '                                                 DIAGPRS.1574
            UNITS(1:8)='g/kg    '                                                DIAGPRS.1575
         ELSE                                                                    DIAGPRS.1576
            UNIT(1:8)='kg/kg   '                                                 DIAGPRS.1577
            UNITS(1:8)='kg/kg   '                                                DIAGPRS.1578
         END IF                                                                  DIAGPRS.1579
C                                                                                DIAGPRS.1580
      ELSE IF((FIELD(1:5).EQ.'QVEC ' ) .OR.                                      DIAGPRS.1581
     *        (FIELD(1:5).EQ.'QDIV ' )) THEN         ! Q VECTORS                 DIAGPRS.1582
         IF(FIELD(1:5).EQ.'QVEC ' ) THEN                                         DIAGPRS.1583
            VARNAM(1:8)='Q VECTOR'                                               DIAGPRS.1584
            IFORM=1                                                              DIAGPRS.1585
            ICRSDOT=0                                                            DIAGPRS.1586
         ELSE IF(FIELD(1:5).EQ.'QDIV ' ) THEN                                    DIAGPRS.1587
            VARNAM(1:8)='QVEC DIV'                                               DIAGPRS.1588
            ICRSDOT=1                                                            DIAGPRS.1589
         ENDIF                                                                   DIAGPRS.1590
         CNT=CONT                                                                DIAGPRS.1591
         NPASS=ISMTHR                                                            DIAGPRS.1592
         KDIM='3D'                                                               DIAGPRS.1593
         IF(PROG(1:6).EQ.'REGRID') THEN                                          DIAGPRS.1594
            CALL READDAD(D33,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1595
     *         .FALSE.,FOUND)                                                    DIAGPRS.1596
            CALL DOT2CRS(D33(1,2),I1,J1,K1-1,I1,J1)                              DIAGPRS.1597
         ELSE IF((PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.1598
     *           (PROG(1:6).EQ.'MMOUTP')) THEN                                   DIAGPRS.1599
            CALL READDAD(D33,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1600
     *         .FALSE.,FOUND)                                                    DIAGPRS.1601
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.1602
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.1603
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.1604
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.1605
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1606
     *            .FALSE.,FOUND)                                                 DIAGPRS.1607
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1608
     *            .FALSE.,FOUND)                                                 DIAGPRS.1609
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.1610
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.1611
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.1612
            END IF                                                               DIAGPRS.1613
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1614
     *                I3DSTART,0)                                                DIAGPRS.1615
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1616
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1617
     *         .FALSE.,FOUND)                                                    DIAGPRS.1618
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1619
     *         .FALSE.,FOUND)                                                    DIAGPRS.1620
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1621
     *         .FALSE.,FOUND)                                                    DIAGPRS.1622
            CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                        DIAGPRS.1623
     *         .FALSE.,FOUND)                                                    DIAGPRS.1624
            CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                        DIAGPRS.1625
     *         .FALSE.,FOUND)                                                    DIAGPRS.1626
            CALL SFCPRS(D32,D33,D31,D21,D22,P,                                   DIAGPRS.1627
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.1628
            CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                         DIAGPRS.1629
     *                  I3DSTART,0)                                              DIAGPRS.1630
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1631
            CALL READDAD(D33,'GHT INTG',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1632
     *         .FALSE.,FOUND)                                                    DIAGPRS.1633
         ELSE IF(PROG(1:6).EQ.'RAWSFC') THEN                                     DIAGPRS.1634
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1635
            IERROR=1                                                             DIAGPRS.1636
            RETURN                                                               DIAGPRS.1637
         END IF                                                                  DIAGPRS.1638
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1639
     *      .FALSE.,FOUND)                                                       DIAGPRS.1640
         CALL SMTHER(D33,D21,I1,J1,K1,NPASS,1)                                   DIAGPRS.1641
         CALL SMTHER(D32,D21,I1,J1,K1,NPASS,1)                                   DIAGPRS.1642
         CALL READDAD(D21,'CORIOLIS',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1643
     *      .FALSE.,FOUND)                                                       DIAGPRS.1644
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1645
     *      .FALSE.,FOUND)                                                       DIAGPRS.1646
         CALL READDAD(D23,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1647
     *      .FALSE.,FOUND)                                                       DIAGPRS.1648
C                                                                                DIAGPRS.1649
         IF(FIELD(1:5).EQ.'QVEC ' ) THEN                                         DIAGPRS.1650
            CALL QVECTR(D33,D21,D22,D23,P,I1,J1,K1,DS,D31,D32)                   DIAGPRS.1651
            FIELD(1:4)='BARB'                                                    DIAGPRS.1652
            IF(UNIT(1:4).EQ.'K/ms') THEN                                         DIAGPRS.1653
               UNIT(1:8)='K/ms    '                                              DIAGPRS.1654
               UNITS(1:8)='K/ms    '                                             DIAGPRS.1655
               CALL SCALE(D31,'MULT',10000000000.,I1,J1,K1,I1,J1,0)              DIAGPRS.1656
               CALL SCALE(D32,'MULT',10000000000.,I1,J1,K1,I1,J1,0)              DIAGPRS.1657
            ELSE IF(UNIT(1:8).EQ.'K/hkm3hr') THEN                                DIAGPRS.1658
               UNIT(1:8)='K/hkm3hr'                                              DIAGPRS.1659
               UNITS(1:8)='K/hkm3hr'                                             DIAGPRS.1660
C                    M->KM    S->HR  100KM   3HR                                 DIAGPRS.1661
               XSCALE=1000. * 3600. * 100. * 3.                                  DIAGPRS.1662
               CALL SCALE(D31,'MULT',XSCALE,I1,J1,K1,I1,J1,0)                    DIAGPRS.1663
               CALL SCALE(D32,'MULT',XSCALE,I1,J1,K1,I1,J1,0)                    DIAGPRS.1664
            ELSE                                                                 DIAGPRS.1665
               UNIT(1:8)='K/ms    '                                              DIAGPRS.1666
               UNITS(1:8)='K/ms    '                                             DIAGPRS.1667
               CALL SCALE(D31,'MULT',10000000000.,I1,J1,K1,I1,J1,0)              DIAGPRS.1668
               CALL SCALE(D32,'MULT',10000000000.,I1,J1,K1,I1,J1,0)              DIAGPRS.1669
            END IF                                                               DIAGPRS.1670
         ELSE IF(FIELD(1:5).EQ.'QDIV ' ) THEN                                    DIAGPRS.1671
            CALL QVECTR(D33,D21,D22,D23,P,I1,J1,K1,DS,D31,D32)                   DIAGPRS.1672
            CALL DIVERG(D31,D32,D23,D22,I1,J1,K1,DS,D33)                         DIAGPRS.1673
            CALL EQUATE(D33,I1,J1,K1,1,D31,I1,J1,K1)                             DIAGPRS.1674
            DO 10100 KK=1,K1                                                     DIAGPRS.1675
               XSCALE=2. * 287./P(KK) * (P(KK)/1000.)**0.286                     DIAGPRS.1676
               CALL SCALE(D31(1,KK),'MULT',XSCALE,I1,J1,1,I1,J1,1)               DIAGPRS.1677
10100       CONTINUE                                                             DIAGPRS.1678
            IF(UNIT(1:6).EQ.'K/m^2s') THEN                                       DIAGPRS.1679
               UNIT(1:8)='K/m^2s  '                                              DIAGPRS.1680
               UNITS(1:8)='K/m^2s  '                                             DIAGPRS.1681
            ELSE                                                                 DIAGPRS.1682
               UNIT(1:8)='K/m^2s  '                                              DIAGPRS.1683
               UNITS(1:8)='K/m^2s  '                                             DIAGPRS.1684
            END IF                                                               DIAGPRS.1685
         ENDIF                                                                   DIAGPRS.1686
C                                                                                DIAGPRS.1687
      ELSE IF(FIELD(1:3).EQ.'RH '     ) THEN    ! RELATIVE HUMIDITY              DIAGPRS.1688
         VARNAM(1:8)='REL HUM '                                                  DIAGPRS.1689
         CNT=CONT                                                                DIAGPRS.1690
         NPASS=ISMTHR                                                            DIAGPRS.1691
         ICRSDOT=1                                                               DIAGPRS.1692
         KDIM='3D'                                                               DIAGPRS.1693
         CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1694
     *      DIAGS,FOUND)                                                         DIAGPRS.1695
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.1696
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1697
            IERROR=1                                                             DIAGPRS.1698
            RETURN                                                               DIAGPRS.1699
         END IF                                                                  DIAGPRS.1700
         IF(UNIT(1:1).EQ.'%') THEN                                               DIAGPRS.1701
            UNIT(1:8)='%       '                                                 DIAGPRS.1702
            UNITS(1:8)='%       '                                                DIAGPRS.1703
         ELSE                                                                    DIAGPRS.1704
            UNIT(1:8)='%       '                                                 DIAGPRS.1705
            UNITS(1:8)='%       '                                                DIAGPRS.1706
         END IF                                                                  DIAGPRS.1707
C                                                                                DIAGPRS.1708
      ELSE IF(FIELD(1:2).EQ.'T '      ) THEN    ! TEMPERATURE                    DIAGPRS.1709
         VARNAM(1:8)='T       '                                                  DIAGPRS.1710
         CNT=CONT                                                                DIAGPRS.1711
         NPASS=ISMTHR                                                            DIAGPRS.1712
         ICRSDOT=1                                                               DIAGPRS.1713
         KDIM='3D'                                                               DIAGPRS.1714
         CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1715
     *      .FALSE.,FOUND)                                                       DIAGPRS.1716
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGPRS.1717
            UNIT(1:8)='K       '                                                 DIAGPRS.1718
            UNITS(1:8)='K       '                                                DIAGPRS.1719
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGPRS.1720
            CALL SCALE(D31,'SUB ',273.16,I1,J1,K1,I1,J1,1)                       DIAGPRS.1721
            UNIT(1:8)='C       '                                                 DIAGPRS.1722
            UNITS(1:8)='C       '                                                DIAGPRS.1723
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGPRS.1724
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGPRS.1725
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGPRS.1726
            UNIT(1:8)='F       '                                                 DIAGPRS.1727
            UNITS(1:8)='F       '                                                DIAGPRS.1728
         ELSE                                                                    DIAGPRS.1729
            UNIT(1:8)='K       '                                                 DIAGPRS.1730
            UNITS(1:8)='K       '                                                DIAGPRS.1731
         END IF                                                                  DIAGPRS.1732
C                                                                                DIAGPRS.1733
      ELSE IF(FIELD(1:4).EQ.'TSEA'  ) THEN  ! SEA SURFACE TEMPERATURE            DIAGPRS.1734
         VARNAM(1:8)='T SEASFC'                                                  DIAGPRS.1735
         CNT=CONT                                                                DIAGPRS.1736
         NPASS=ISMTHR                                                            DIAGPRS.1737
         ICRSDOT=1                                                               DIAGPRS.1738
         KDIM='2D'                                                               DIAGPRS.1739
         CALL READDAD(D31,'TSEASFC ',IDAD2D,I1,J1, 1,0,                          DIAGPRS.1740
     *      .FALSE.,FOUND)                                                       DIAGPRS.1741
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGPRS.1742
            UNIT(1:8)='K       '                                                 DIAGPRS.1743
            UNITS(1:8)='K       '                                                DIAGPRS.1744
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGPRS.1745
            CALL SCALE(D31,'SUB ',273.16,I1,J1,K1,I1,J1,1)                       DIAGPRS.1746
            UNIT(1:8)='C       '                                                 DIAGPRS.1747
            UNITS(1:8)='C       '                                                DIAGPRS.1748
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGPRS.1749
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGPRS.1750
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGPRS.1751
            UNIT(1:8)='F       '                                                 DIAGPRS.1752
            UNITS(1:8)='F       '                                                DIAGPRS.1753
         ELSE                                                                    DIAGPRS.1754
            UNIT(1:8)='K       '                                                 DIAGPRS.1755
            UNITS(1:8)='K       '                                                DIAGPRS.1756
         END IF                                                                  DIAGPRS.1757
C                                                                                DIAGPRS.1758
      ELSE IF(FIELD(1:5).EQ.'LNDUS'  ) THEN  ! LAND USE                          DIAGPRS.1759
         VARNAM(1:8)='LAND USE'                                                  DIAGPRS.1760
         CNT=CONT                                                                DIAGPRS.1761
         NPASS=ISMTHR                                                            DIAGPRS.1762
         ICRSDOT=1                                                               DIAGPRS.1763
         KDIM='2D'                                                               DIAGPRS.1764
            CALL READDAD(D31,'LAND USE',IDAD2D,I1,J1, 1, 0,                      DIAGPRS.1765
     *           .FALSE.,FOUND)                                                  DIAGPRS.1766
            UNIT(1:8)='category'                                                 DIAGPRS.1767
            UNITS(1:8)='category'                                                DIAGPRS.1768
C                                                                                DIAGPRS.1769
      ELSE IF((FIELD(1:3).EQ.'TD '    ) .OR.        ! DEW POINT                  DIAGPRS.1770
     *        (FIELD(1:4).EQ.'TDD '   )) THEN       ! DEW POINT DEPR             DIAGPRS.1771
         IF (FIELD(1:3).EQ.'TD ') THEN                                           DIAGPRS.1772
            IDEW=1                                                               DIAGPRS.1773
            VARNAM(1:8)='T DEW PT'                                               DIAGPRS.1774
         ELSE IF (FIELD(1:4).EQ.'TDD ') THEN                                     DIAGPRS.1775
            IDEW=0                                                               DIAGPRS.1776
            VARNAM(1:8)='T DEW DP'                                               DIAGPRS.1777
         END IF                                                                  DIAGPRS.1778
         CNT=CONT                                                                DIAGPRS.1779
         NPASS=ISMTHR                                                            DIAGPRS.1780
         ICRSDOT=1                                                               DIAGPRS.1781
         KDIM='3D'                                                               DIAGPRS.1782
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1783
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1784
            IERROR=1                                                             DIAGPRS.1785
            RETURN                                                               DIAGPRS.1786
         ELSE IF(PROG(1:6).EQ.'REGRID') THEN                                     DIAGPRS.1787
            CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1788
     *      .FALSE.,FOUND)                                                       DIAGPRS.1789
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1790
     *      .FALSE.,FOUND)                                                       DIAGPRS.1791
            CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                          DIAGPRS.1792
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1793
     *                I3DSTART,0)                                                DIAGPRS.1794
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1795
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.1796
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.1797
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.1798
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.1799
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.1800
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.1801
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1802
     *            .FALSE.,FOUND)                                                 DIAGPRS.1803
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1804
     *            .FALSE.,FOUND)                                                 DIAGPRS.1805
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.1806
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.1807
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.1808
            END IF                                                               DIAGPRS.1809
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1810
     *                I3DSTART,0)                                                DIAGPRS.1811
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1812
         ENDIF                                                                   DIAGPRS.1813
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1814
     *      .FALSE.,FOUND)                                                       DIAGPRS.1815
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1816
     *      .FALSE.,FOUND)                                                       DIAGPRS.1817
         CALL DEWPOINP(D32,D33,P,IDEW,I1,J1,K1,D31)                              DIAGPRS.1818
         IF(IDEW.EQ.1) THEN                                                      DIAGPRS.1819
            CALL WRITDAD(D31,'TD      ',IDAD3D,I1,J1,K1,                         DIAGPRS.1820
     *                  I3DSTART,0)                                              DIAGPRS.1821
         ELSE IF(IDEW.EQ.0) THEN                                                 DIAGPRS.1822
            CALL WRITDAD(D31,'TDD     ',IDAD3D,I1,J1,K1,                         DIAGPRS.1823
     *                  I3DSTART,0)                                              DIAGPRS.1824
         END IF                                                                  DIAGPRS.1825
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1826
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGPRS.1827
            UNIT(1:8)='K       '                                                 DIAGPRS.1828
            UNITS(1:8)='K       '                                                DIAGPRS.1829
         ELSE IF((UNIT(1:1).EQ.'C').AND.(IDEW.EQ.1)) THEN                        DIAGPRS.1830
            CALL SCALE(D31,'SUB ',273.16,I1,J1,K1,I1,J1,1)                       DIAGPRS.1831
            UNIT(1:8)='C       '                                                 DIAGPRS.1832
            UNITS(1:8)='C       '                                                DIAGPRS.1833
         ELSE IF((UNIT(1:1).EQ.'C').AND.(IDEW.EQ.0)) THEN                        DIAGPRS.1834
            UNIT(1:8)='C       '                                                 DIAGPRS.1835
            UNITS(1:8)='C       '                                                DIAGPRS.1836
         ELSE IF((UNIT(1:1).EQ.'F').AND.(IDEW.EQ.1)) THEN                        DIAGPRS.1837
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGPRS.1838
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGPRS.1839
            UNIT(1:8)='F       '                                                 DIAGPRS.1840
            UNITS(1:8)='F       '                                                DIAGPRS.1841
         ELSE IF((UNIT(1:1).EQ.'F').AND.(IDEW.EQ.0)) THEN                        DIAGPRS.1842
            CALL SCALE(D31,'MULT',1.8,I1,J1,K1,I1,J1,1)                          DIAGPRS.1843
            UNIT(1:8)='F       '                                                 DIAGPRS.1844
            UNITS(1:8)='F       '                                                DIAGPRS.1845
         ELSE                                                                    DIAGPRS.1846
            UNIT(1:8)='K       '                                                 DIAGPRS.1847
            UNITS(1:8)='K       '                                                DIAGPRS.1848
         ENDIF                                                                   DIAGPRS.1849
C                                                                                DIAGPRS.1850
      ELSE IF(FIELD(1:6).EQ.'THETA '     ) THEN    ! POTENTIAL TEMP              DIAGPRS.1851
         VARNAM(1:8)='THETA   '                                                  DIAGPRS.1852
         CNT=CONT                                                                DIAGPRS.1853
         NPASS=ISMTHR                                                            DIAGPRS.1854
         ICRSDOT=1                                                               DIAGPRS.1855
         KDIM='3D'                                                               DIAGPRS.1856
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1857
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1858
            IERROR=1                                                             DIAGPRS.1859
            RETURN                                                               DIAGPRS.1860
         END IF                                                                  DIAGPRS.1861
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1862
     *      .FALSE.,FOUND)                                                       DIAGPRS.1863
        CALL READDAD(D21,'P SFC   ',IDAD2D,I1,J1, 1,0,                           DIAGPRS.1864
     *        DIAGS,FOUND)                                                       DIAGPRS.1865
        IF(.NOT.FOUND) THEN                                                      DIAGPRS.1866
           PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                         DIAGPRS.1867
           IERROR = 1                                                            DIAGPRS.1868
           RETURN                                                                DIAGPRS.1869
        ENDIF                                                                    DIAGPRS.1870
         CALL THETAP(D32,D21,P,I1,J1,K1,D31)                                     DIAGPRS.1871
         CALL WRITDAD(D31,'THETA   ',IDAD3D,I1,J1,K1,                            DIAGPRS.1872
     *               I3DSTART,0)                                                 DIAGPRS.1873
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1874
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGPRS.1875
            UNIT(1:8)='K       '                                                 DIAGPRS.1876
            UNITS(1:8)='K       '                                                DIAGPRS.1877
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGPRS.1878
            CALL SCALE(D31,'SUB ',273.16,I1,J1,K1,I1,J1,1)                       DIAGPRS.1879
            UNIT(1:8)='C       '                                                 DIAGPRS.1880
            UNITS(1:8)='C       '                                                DIAGPRS.1881
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGPRS.1882
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGPRS.1883
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGPRS.1884
            UNIT(1:8)='F       '                                                 DIAGPRS.1885
            UNITS(1:8)='F       '                                                DIAGPRS.1886
         ELSE                                                                    DIAGPRS.1887
            UNIT(1:8)='K       '                                                 DIAGPRS.1888
            UNITS(1:8)='K       '                                                DIAGPRS.1889
         ENDIF                                                                   DIAGPRS.1890
C                                                                                DIAGPRS.1891
      ELSE IF(FIELD(1:7).EQ.'THETAE '    ) THEN    ! EQUIV POT TEMP              DIAGPRS.1892
         VARNAM(1:8)='THETAE  '                                                  DIAGPRS.1893
         CNT=CONT                                                                DIAGPRS.1894
         NPASS=ISMTHR                                                            DIAGPRS.1895
         ICRSDOT=1                                                               DIAGPRS.1896
         KDIM='3D'                                                               DIAGPRS.1897
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1898
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1899
            IERROR=1                                                             DIAGPRS.1900
            RETURN                                                               DIAGPRS.1901
         ELSE IF(PROG(1:6).EQ.'REGRID') THEN                                     DIAGPRS.1902
            CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1903
     *      .FALSE.,FOUND)                                                       DIAGPRS.1904
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1905
     *      .FALSE.,FOUND)                                                       DIAGPRS.1906
            CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                          DIAGPRS.1907
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1908
     *                I3DSTART,0)                                                DIAGPRS.1909
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1910
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.1911
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.1912
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.1913
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.1914
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.1915
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.1916
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1917
     *            .FALSE.,FOUND)                                                 DIAGPRS.1918
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1919
     *            .FALSE.,FOUND)                                                 DIAGPRS.1920
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.1921
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.1922
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.1923
            END IF                                                               DIAGPRS.1924
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1925
     *                I3DSTART,0)                                                DIAGPRS.1926
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1927
         ENDIF                                                                   DIAGPRS.1928
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1929
     *      .FALSE.,FOUND)                                                       DIAGPRS.1930
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.1931
     *      .FALSE.,FOUND)                                                       DIAGPRS.1932
        CALL READDAD(D21,'P SFC   ',IDAD2D,I1,J1, 1,0,                           DIAGPRS.1933
     *        DIAGS,FOUND)                                                       DIAGPRS.1934
        IF(.NOT.FOUND) THEN                                                      DIAGPRS.1935
           PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                         DIAGPRS.1936
           IERROR = 1                                                            DIAGPRS.1937
           RETURN                                                                DIAGPRS.1938
        ENDIF                                                                    DIAGPRS.1939
         CALL THETAEP(D32,D33,D21,P,I1,J1,K1,D31)                                DIAGPRS.1940
         CALL WRITDAD(D31,'THETAE  ',IDAD3D,I1,J1,K1,                            DIAGPRS.1941
     *               I3DSTART,0)                                                 DIAGPRS.1942
         I3DSTART=I3DSTART+1                                                     DIAGPRS.1943
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGPRS.1944
            UNIT(1:8)='K       '                                                 DIAGPRS.1945
            UNITS(1:8)='K       '                                                DIAGPRS.1946
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGPRS.1947
            CALL SCALE(D31,'SUB ',273.16,I1,J1,K1,I1,J1,1)                       DIAGPRS.1948
            UNIT(1:8)='C       '                                                 DIAGPRS.1949
            UNITS(1:8)='C       '                                                DIAGPRS.1950
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGPRS.1951
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGPRS.1952
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGPRS.1953
            UNIT(1:8)='F       '                                                 DIAGPRS.1954
            UNITS(1:8)='F       '                                                DIAGPRS.1955
         ELSE                                                                    DIAGPRS.1956
            UNIT(1:8)='K       '                                                 DIAGPRS.1957
            UNITS(1:8)='K       '                                                DIAGPRS.1958
         ENDIF                                                                   DIAGPRS.1959
C                                                                                DIAGPRS.1960
      ELSE IF(FIELD(1:2).EQ.'LI'    ) THEN    ! LIFTED INDEX                     DIAGPRS.1961
         if (field(3:3) .eq. '8') then                                           DIAGPRS.1962
           VARNAM(1:8)='LI 850  '                                                DIAGPRS.1963
         else if (field(3:3) .eq. 'S') then                                      DIAGPRS.1964
           VARNAM(1:8)='SFC LI  '                                                DIAGPRS.1965
         else if (field(3:3) .eq. 'M') then                                      DIAGPRS.1966
           VARNAM(1:8)='LI MIN  '                                                DIAGPRS.1967
         else                                                                    DIAGPRS.1968
           VARNAM(1:8)='LI      '                                                DIAGPRS.1969
         endif                                                                   DIAGPRS.1970
         CNT=CONT                                                                DIAGPRS.1971
         NPASS=ISMTHR                                                            DIAGPRS.1972
         ICRSDOT=1                                                               DIAGPRS.1973
         KDIM='2D'                                                               DIAGPRS.1974
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.1975
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.1976
            IERROR=1                                                             DIAGPRS.1977
            RETURN                                                               DIAGPRS.1978
         ELSE IF(PROG(1:6).EQ.'REGRID') THEN                                     DIAGPRS.1979
            CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1980
     *      .FALSE.,FOUND)                                                       DIAGPRS.1981
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.1982
     *      .FALSE.,FOUND)                                                       DIAGPRS.1983
            CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                          DIAGPRS.1984
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.1985
     *                I3DSTART,0)                                                DIAGPRS.1986
            I3DSTART=I3DSTART+1                                                  DIAGPRS.1987
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.1988
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.1989
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.1990
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.1991
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.1992
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.1993
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1994
     *            .FALSE.,FOUND)                                                 DIAGPRS.1995
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.1996
     *            .FALSE.,FOUND)                                                 DIAGPRS.1997
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.1998
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.1999
            END IF                                                               DIAGPRS.2000
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.2001
     *                I3DSTART,0)                                                DIAGPRS.2002
            I3DSTART=I3DSTART+1                                                  DIAGPRS.2003
         ENDIF                                                                   DIAGPRS.2004
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2005
     *      .FALSE.,FOUND)                                                       DIAGPRS.2006
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2007
     *      .FALSE.,FOUND)                                                       DIAGPRS.2008
        CALL READDAD(D21,'P SFC   ',IDAD2D,I1,J1, 1,0,                           DIAGPRS.2009
     *        DIAGS,FOUND)                                                       DIAGPRS.2010
        IF(.NOT.FOUND) THEN                                                      DIAGPRS.2011
           PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                         DIAGPRS.2012
           IERROR = 1                                                            DIAGPRS.2013
           RETURN                                                                DIAGPRS.2014
        ENDIF                                                                    DIAGPRS.2015
         CALL THETAEP(D32,D33,D21,P,I1,J1,K1,D31)                                DIAGPRS.2016
         CALL WRITDAD(D31,'THETAE  ',IDAD3D,I1,J1,K1,                            DIAGPRS.2017
     *               I3DSTART,0)                                                 DIAGPRS.2018
         I3DSTART=I3DSTART+1                                                     DIAGPRS.2019
         CALL READDAD(D33,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2020
     *      .FALSE.,FOUND)                                                       DIAGPRS.2021
         CALL READDAD(D32,'THETAE  ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2022
     *      .FALSE.,FOUND)                                                       DIAGPRS.2023
         CALL READDAD(D21,'P SFC   ',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2024
     *        DIAGS,FOUND)                                                       DIAGPRS.2025
         call li(field,d32,d33,d21,p,i1,j1,k1,d31)                               DIAGPRS.2026
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGPRS.2027
            UNIT(1:8)='K       '                                                 DIAGPRS.2028
            UNITS(1:8)='K       '                                                DIAGPRS.2029
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGPRS.2030
            UNIT(1:8)='C       '                                                 DIAGPRS.2031
            UNITS(1:8)='C       '                                                DIAGPRS.2032
         ELSE                                                                    DIAGPRS.2033
            UNIT(1:8)='K       '                                                 DIAGPRS.2034
            UNITS(1:8)='K       '                                                DIAGPRS.2035
         ENDIF                                                                   DIAGPRS.2036
C                                                                                DIAGPRS.2037
      ELSE IF(FIELD(1:7).EQ.'RDTEND '                                            DIAGPRS.2038
     *    .OR.FIELD(1:8).EQ.'RADTEND ') THEN    ! RADIATION TEND                 DIAGPRS.2039
         VARNAM(1:8)='RAD TEND'                                                  DIAGPRS.2040
         CNT=CONT                                                                DIAGPRS.2041
         NPASS=ISMTHR                                                            DIAGPRS.2042
         ICRSDOT=1                                                               DIAGPRS.2043
         KDIM='3D'                                                               DIAGPRS.2044
         CALL READDAD(D31,'RAD TEND',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2045
     *      .FALSE.,FOUND)                                                       DIAGPRS.2046
         IF(UNIT(1:5).EQ.'K/day') THEN                                           DIAGPRS.2047
            UNIT(1:8)='K/day   '                                                 DIAGPRS.2048
            UNITS(1:8)='K/day   '                                                DIAGPRS.2049
         ELSE IF(UNIT(1:3).EQ.'K/h') THEN                                        DIAGPRS.2050
            CALL SCALE(D31,'DIV ',24.0,I1,J1,K1,I1,J1,0)                         DIAGPRS.2051
            UNIT(1:8)='K/h     '                                                 DIAGPRS.2052
            UNITS(1:8)='K/h     '                                                DIAGPRS.2053
         END IF                                                                  DIAGPRS.2054
C                                                                                DIAGPRS.2055
      ELSE IF(FIELD(1:7).EQ.'TKE    '  ) THEN    ! TKE                           DIAGPRS.2056
         VARNAM(1:8)='TKE     '                                                  DIAGPRS.2057
         CNT=CONT                                                                DIAGPRS.2058
         NPASS=ISMTHR                                                            DIAGPRS.2059
         ICRSDOT=1                                                               DIAGPRS.2060
         KDIM='3D'                                                               DIAGPRS.2061
         CALL READDAD(D31,'TKE     ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2062
     *      .FALSE.,FOUND)                                                       DIAGPRS.2063
         IF(UNIT(1:4).EQ.'J/kg') THEN                                            DIAGPRS.2064
            UNIT(1:8)='J/kg    '                                                 DIAGPRS.2065
            UNITS(1:8)='J/kg    '                                                DIAGPRS.2066
         END IF                                                                  DIAGPRS.2067
C                                                                                DIAGPRS.2068
      ELSE IF(FIELD(1:5).EQ.'TADV ') THEN    ! Temperature advection             DIAGPRS.2069
        VARNAM(1:8) = 'TADVEC  '                                                 DIAGPRS.2070
        CNT=CONT                                                                 DIAGPRS.2071
        NPASS=ISMTHR                                                             DIAGPRS.2072
        ICRSDOT=1                                                                DIAGPRS.2073
        KDIM='3D'                                                                DIAGPRS.2074
        IF(PROG(1:6).EQ.'RAWSFC') THEN                                           DIAGPRS.2075
           PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                         DIAGPRS.2076
           IERROR = 1                                                            DIAGPRS.2077
           RETURN                                                                DIAGPRS.2078
        ELSE                                                                     DIAGPRS.2079
            CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2080
     *         DIAGS,FOUND)                                                      DIAGPRS.2081
            IF (.NOT. FOUND) THEN                                                DIAGPRS.2082
              PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                      DIAGPRS.2083
              IERROR = 1                                                         DIAGPRS.2084
              RETURN                                                             DIAGPRS.2085
            ENDIF                                                                DIAGPRS.2086
          CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                         DIAGPRS.2087
     *        .FALSE.,FOUND)                                                     DIAGPRS.2088
          CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                         DIAGPRS.2089
     *        .FALSE.,FOUND)                                                     DIAGPRS.2090
          CALL READDAD(D21,'MAPFACDT',IDAD2D,I1,J1, 1,0,                         DIAGPRS.2091
     *        .FALSE.,FOUND)                                                     DIAGPRS.2092
          CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                         DIAGPRS.2093
     *        .FALSE.,FOUND)                                                     DIAGPRS.2094
          CALL advec(D33,D32,D21,D22,D23,I1,J1,K1,DS,D31)                        DIAGPRS.2095
C         CALL WRITDAD(D31,'MDIVERG ',IDAD3D,I1,J1,K1,I3DSTART,0)                DIAGPRS.2096
C         I3DSTART=I3DSTART+1                                                    DIAGPRS.2097
          IF(UNIT(1:3).EQ.'K/s') THEN                                            DIAGPRS.2098
             UNIT(1:8)='K/s     '                                                DIAGPRS.2099
             UNITS(1:8)='K/s     '                                               DIAGPRS.2100
          ELSE IF(UNIT(1:7).EQ.'10**5/s') THEN                                   DIAGPRS.2101
             CALL SCALE(D31,'MULT',100000.,I1,J1,K1,I1,J1,1)                     DIAGPRS.2102
             UNIT(1:8)='10**5/s '                                                DIAGPRS.2103
             UNITS(1:8)='10**5/s '                                               DIAGPRS.2104
          ELSE IF(UNIT(1:5).EQ.'C/12h') THEN                                     DIAGPRS.2105
             CALL SCALE(D31,'MULT',43200.,I1,J1,K1,I1,J1,1)                      DIAGPRS.2106
             UNIT(1:8)='C/12h   '                                                DIAGPRS.2107
             UNITS(1:8)='C/12h   '                                               DIAGPRS.2108
          ELSE IF(UNIT(1:5).EQ.'K/12h') THEN                                     DIAGPRS.2109
             CALL SCALE(D31,'MULT',43200.,I1,J1,K1,I1,J1,1)                      DIAGPRS.2110
             UNIT(1:8)='K/12h   '                                                DIAGPRS.2111
             UNITS(1:8)='K/12h   '                                               DIAGPRS.2112
          ELSE                                                                   DIAGPRS.2113
             UNIT(1:8)='K/s     '                                                DIAGPRS.2114
             UNITS(1:8)='K/s     '                                               DIAGPRS.2115
          ENDIF                                                                  DIAGPRS.2116
        ENDIF                                                                    DIAGPRS.2117
C                                                                                DIAGPRS.2118
      ELSE IF(FIELD(1:4).EQ.'TER '      ) THEN    ! TERRAIN                      DIAGPRS.2119
         VARNAM(1:8)='TERRAIN '                                                  DIAGPRS.2120
         CNT=CONT                                                                DIAGPRS.2121
         NPASS=ISMTHR                                                            DIAGPRS.2122
         ICRSDOT=1                                                               DIAGPRS.2123
         KDIM='2D'                                                               DIAGPRS.2124
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.2125
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.2126
            IERROR=1                                                             DIAGPRS.2127
            RETURN                                                               DIAGPRS.2128
         END IF                                                                  DIAGPRS.2129
         CALL READDAD(D31,'TERRAIN ',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2130
     *      .FALSE.,FOUND)                                                       DIAGPRS.2131
         IF(UNIT(1:1).EQ.'m') THEN                                               DIAGPRS.2132
            UNIT(1:8)='m       '                                                 DIAGPRS.2133
            UNITS(1:8)='m       '                                                DIAGPRS.2134
         ELSE IF(UNIT(1:2).EQ.'ft') THEN                                         DIAGPRS.2135
            CALL M2FT(D31,I1,J1, 1,1)                                            DIAGPRS.2136
            UNIT(1:8)='ft      '                                                 DIAGPRS.2137
            UNITS(1:8)='ft      '                                                DIAGPRS.2138
         ELSE                                                                    DIAGPRS.2139
            UNIT(1:8)='m       '                                                 DIAGPRS.2140
            UNITS(1:8)='m       '                                                DIAGPRS.2141
         END IF                                                                  DIAGPRS.2142
C                                                                                DIAGPRS.2143
      ELSE IF(FIELD(1:4).EQ.'TGD '    ) THEN    ! GROUND TEMPERATURE             DIAGPRS.2144
         VARNAM(1:8)='GROUND T'                                                  DIAGPRS.2145
         CNT=CONT                                                                DIAGPRS.2146
         NPASS=ISMTHR                                                            DIAGPRS.2147
         ICRSDOT=1                                                               DIAGPRS.2148
         KDIM='2D'                                                               DIAGPRS.2149
         IF((PROG(1:6).EQ.'MMOUTP').OR.                                          DIAGPRS.2150
     *      (PROG(1:6).EQ.'MM5PRS') .OR.                                         DIAGPRS.2151
     *      (PROG(1:6).EQ.'MM4NHP') .OR.                                         DIAGPRS.2152
     *      (PROG(1:6).EQ.'MZIGPR')) THEN                                        DIAGPRS.2153
            CALL READDAD(D31,'GROUND T',IDAD2D,I1,J1,1,0,                        DIAGPRS.2154
     *         DIAGS,FOUND)                                                      DIAGPRS.2155
            IF(.NOT.FOUND) THEN                                                  DIAGPRS.2156
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGPRS.2157
               IERROR=1                                                          DIAGPRS.2158
               RETURN                                                            DIAGPRS.2159
            END IF                                                               DIAGPRS.2160
         ELSE IF(PROG(1:6).EQ.'RAWSFC') THEN                                     DIAGPRS.2161
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.2162
            IERROR=1                                                             DIAGPRS.2163
            RETURN                                                               DIAGPRS.2164
         ELSE                                                                    DIAGPRS.2165
            CALL READDAD(D21,'TSEASFC ',IDAD2D,I1,J1,1,0,                        DIAGPRS.2166
     *         .TRUE.,FOUND)                                                     05DEC01.33
            IF (.NOT. FOUND)                                                     05DEC01.34
     *         CALL READDAD(D21,'SKINTEMP',IDAD2D,I1,J1,1,0,                     05DEC01.35
     *         .FALSE.,FOUND)                                                    05DEC01.36
            CALL READDAD(D22,'TEMPSFC ',IDAD2D,I1,J1,1,0,                        DIAGPRS.2168
     *         .FALSE.,FOUND)                                                    DIAGPRS.2169
            CALL READDAD(D23,'LAND USE',IDAD2D,I1,J1,1,0,                        DIAGPRS.2170
     *         .FALSE.,FOUND)                                                    DIAGPRS.2171
            CALL GRNDTMP(D21,D22,D23,I1,J1,D31,ISWATER)                          DIAGPRS.2172
            CALL WRITDAD(D31,'GROUND T',IDAD2D,I1,J1,1,                          DIAGPRS.2173
     *                   I2DSTART,0)                                             DIAGPRS.2174
            I2DSTART=I2DSTART+1                                                  DIAGPRS.2175
         END IF                                                                  DIAGPRS.2176
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGPRS.2177
            UNIT(1:8)='K       '                                                 DIAGPRS.2178
            UNITS(1:8)='K       '                                                DIAGPRS.2179
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGPRS.2180
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGPRS.2181
            UNIT(1:8)='C       '                                                 DIAGPRS.2182
            UNITS(1:8)='C       '                                                DIAGPRS.2183
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGPRS.2184
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGPRS.2185
            CALL CEL2F  (D31,I1,J1,1)                                            DIAGPRS.2186
            UNIT(1:8)='F       '                                                 DIAGPRS.2187
            UNITS(1:8)='F       '                                                DIAGPRS.2188
         ELSE                                                                    DIAGPRS.2189
            UNIT(1:8)='K       '                                                 DIAGPRS.2190
            UNITS(1:8)='K       '                                                DIAGPRS.2191
         END IF                                                                  DIAGPRS.2192
C                                                                                DIAGPRS.2193
      ELSE IF(FIELD(1:5).EQ.'TSFC '   ) THEN    ! TEMPERATURE                    DIAGPRS.2194
         VARNAM(1:8)='T       '                                                  DIAGPRS.2195
         CNT=CONT                                                                DIAGPRS.2196
         NPASS=ISMTHR                                                            DIAGPRS.2197
         ICRSDOT=1                                                               DIAGPRS.2198
         KDIM='2D'                                                               DIAGPRS.2199
         CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2200
     *      .FALSE.,FOUND)                                                       DIAGPRS.2201
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGPRS.2202
            UNIT(1:8)='K       '                                                 DIAGPRS.2203
            UNITS(1:8)='K       '                                                DIAGPRS.2204
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGPRS.2205
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGPRS.2206
            UNIT(1:8)='C       '                                                 DIAGPRS.2207
            UNITS(1:8)='C       '                                                DIAGPRS.2208
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGPRS.2209
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGPRS.2210
            CALL CEL2F  (D31,I1,J1,1)                                            DIAGPRS.2211
            UNIT(1:8)='F       '                                                 DIAGPRS.2212
            UNITS(1:8)='F       '                                                DIAGPRS.2213
         ELSE                                                                    DIAGPRS.2214
            UNIT(1:8)='K       '                                                 DIAGPRS.2215
            UNITS(1:8)='K       '                                                DIAGPRS.2216
         END IF                                                                  DIAGPRS.2217
C                                                                                DIAGPRS.2218
      ELSE IF(FIELD(1:6).EQ.'UNDER '   ) THEN    ! BELOW SURFACE                 DIAGPRS.2219
         VARNAM(1:8)='UNDER   '                                                  DIAGPRS.2220
         CNT=10.                                                                 DIAGPRS.2221
         NPASS=0                                                                 DIAGPRS.2222
         ICRSDOT=1                                                               DIAGPRS.2223
         KDIM='3D'                                                               DIAGPRS.2224
         CALL READDAD(D31,'UNDRGRND',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2225
     *      DIAGS,FOUND)                                                         DIAGPRS.2226
         IF(.NOT.FOUND) THEN                                                     DIAGPRS.2227
            IF((PROG(1:6).EQ.'MMOUTP').OR.                                       DIAGPRS.2228
     *         (PROG(1:6).EQ.'MM5PRS') .OR.                                      DIAGPRS.2229
     *         (PROG(1:6).EQ.'MM4NHP') .OR.                                      DIAGPRS.2230
     *         (PROG(1:6).EQ.'MZIGPR')) THEN                                     DIAGPRS.2231
               CALL READDAD(D23,'P SFC   ',IDAD2D,I1,J1, 1,0,                    DIAGPRS.2232
     *            .FALSE.,FOUND)                                                 DIAGPRS.2233
            ELSE IF(PROG(1:6).EQ.'RAWSFC') THEN                                  DIAGPRS.2234
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGPRS.2235
               IERROR=1                                                          DIAGPRS.2236
               RETURN                                                            DIAGPRS.2237
            ELSE                                                                 DIAGPRS.2238
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2239
     *            .FALSE.,FOUND)                                                 DIAGPRS.2240
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2241
     *            .FALSE.,FOUND)                                                 DIAGPRS.2242
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.2243
               CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                      DIAGPRS.2244
     *                      I3DSTART,0)                                          DIAGPRS.2245
               I3DSTART=I3DSTART+1                                               DIAGPRS.2246
               CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2247
     *            .FALSE.,FOUND)                                                 DIAGPRS.2248
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2249
     *            .FALSE.,FOUND)                                                 DIAGPRS.2250
               CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2251
     *            .FALSE.,FOUND)                                                 DIAGPRS.2252
               CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                     DIAGPRS.2253
     *            .FALSE.,FOUND)                                                 DIAGPRS.2254
               CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                     DIAGPRS.2255
     *            .FALSE.,FOUND)                                                 DIAGPRS.2256
               CALL SFCPRS(D32,D33,D31,D21,D22,P,                                DIAGPRS.2257
     *                     I1,J1,K1,D23,D24,PROG)                                DIAGPRS.2258
            END IF                                                               DIAGPRS.2259
            CALL UNDRGRND(D31,D23,P,I1,J1,K1,2000.,0.)                           DIAGPRS.2260
            CALL WRITDAD(D31,'UNDRGRND',IDAD3D,I1,J1,K1,                         DIAGPRS.2261
     *                   I3DSTART,0)                                             DIAGPRS.2262
            I3DSTART=I3DSTART+1                                                  DIAGPRS.2263
         END IF                                                                  DIAGPRS.2264
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGPRS.2265
            UNIT(1:8)='mb      '                                                 DIAGPRS.2266
            UNITS(1:8)='mb      '                                                DIAGPRS.2267
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGPRS.2268
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,1)                        DIAGPRS.2269
            UNIT(1:8)='Pa      '                                                 DIAGPRS.2270
            UNITS(1:8)='Pa      '                                                DIAGPRS.2271
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGPRS.2272
            UNIT(1:8)='hPa     '                                                 DIAGPRS.2273
            UNITS(1:8)='hPa     '                                                DIAGPRS.2274
         ELSE IF(UNIT(1:5).EQ.'inHg ') THEN                                      DIAGPRS.2275
            CALL SCALE(D31,'DIV ',33.86388640,I1,J1,K1,I1,J1,1)                  DIAGPRS.2276
            UNIT(1:8)='inHg    '                                                 DIAGPRS.2277
            UNITS(1:8)='inHg    '                                                DIAGPRS.2278
         ELSE                                                                    DIAGPRS.2279
            UNIT(1:8)='mb      '                                                 DIAGPRS.2280
            UNITS(1:8)='mb      '                                                DIAGPRS.2281
         END IF                                                                  DIAGPRS.2282
C                                                                                DIAGPRS.2283
      ELSE IF(FIELD(1:4).EQ.'VAB '    ) THEN    ! ABSOLUTE VORTICITY             DIAGPRS.2284
         VARNAM(1:8)='VORT ABS'                                                  DIAGPRS.2285
         CNT=CONT                                                                DIAGPRS.2286
         NPASS=ISMTHR                                                            DIAGPRS.2287
         ICRSDOT=1                                                               DIAGPRS.2288
         KDIM='3D'                                                               DIAGPRS.2289
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.2290
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.2291
            IERROR=1                                                             DIAGPRS.2292
            RETURN                                                               DIAGPRS.2293
         END IF                                                                  DIAGPRS.2294
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2295
     *      .FALSE.,FOUND)                                                       DIAGPRS.2296
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2297
     *      .FALSE.,FOUND)                                                       DIAGPRS.2298
         CALL READDAD(D21,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2299
     *      .FALSE.,FOUND)                                                       DIAGPRS.2300
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2301
     *      .FALSE.,FOUND)                                                       DIAGPRS.2302
         CALL READDAD(D23,'CORIOLIS',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2303
     *      .FALSE.,FOUND)                                                       DIAGPRS.2304
         CALL VORTABS(D33,D32,D23,D21,D22,I1,J1,K1,DS,D31)                       DIAGPRS.2305
         CALL WRITDAD(D31,'VAB     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.2306
         I3DSTART=I3DSTART+1                                                     DIAGPRS.2307
         IF(UNIT(1:3).EQ.'1/s') THEN                                             DIAGPRS.2308
            UNIT(1:8)='1/s     '                                                 DIAGPRS.2309
            UNITS(1:8)='1/s     '                                                DIAGPRS.2310
         ELSE IF(UNIT(1:7).EQ.'10**5/s') THEN                                    DIAGPRS.2311
            CALL SCALE(D31,'MULT',100000.,I1,J1,K1,I1,J1,1)                      DIAGPRS.2312
            UNIT(1:8)='10**5/s '                                                 DIAGPRS.2313
            UNITS(1:8)='10**5/s '                                                DIAGPRS.2314
         ELSE                                                                    DIAGPRS.2315
            UNIT(1:8)='1/s     '                                                 DIAGPRS.2316
            UNITS(1:8)='1/s     '                                                DIAGPRS.2317
         END IF                                                                  DIAGPRS.2318
C                                                                                DIAGPRS.2319
      ELSE IF(FIELD(1:4).EQ.'VOR '    ) THEN    ! MIXING RATIO                   DIAGPRS.2320
         VARNAM(1:8)='VORT    '                                                  DIAGPRS.2321
         CNT=CONT                                                                DIAGPRS.2322
         NPASS=ISMTHR                                                            DIAGPRS.2323
         ICRSDOT=1                                                               DIAGPRS.2324
         KDIM='3D'                                                               DIAGPRS.2325
         IF(PROG(1:6).EQ.'RAWSFC') THEN                                          DIAGPRS.2326
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.2327
            IERROR=1                                                             DIAGPRS.2328
            RETURN                                                               DIAGPRS.2329
         END IF                                                                  DIAGPRS.2330
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2331
     *      .FALSE.,FOUND)                                                       DIAGPRS.2332
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2333
     *      .FALSE.,FOUND)                                                       DIAGPRS.2334
         CALL READDAD(D21,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2335
     *      .FALSE.,FOUND)                                                       DIAGPRS.2336
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2337
     *      .FALSE.,FOUND)                                                       DIAGPRS.2338
         CALL VOR(D33,D32,D21,D22,I1,J1,K1,DS,D31)                               DIAGPRS.2339
         CALL WRITDAD(D31,'VOR     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.2340
         I3DSTART=I3DSTART+1                                                     DIAGPRS.2341
         IF(UNIT(1:3).EQ.'1/s') THEN                                             DIAGPRS.2342
            UNIT(1:8)='1/s     '                                                 DIAGPRS.2343
            UNITS(1:8)='1/s     '                                                DIAGPRS.2344
         ELSE IF(UNIT(1:7).EQ.'10**5/s') THEN                                    DIAGPRS.2345
            CALL SCALE(D31,'MULT',100000.,I1,J1,K1,I1,J1,1)                      DIAGPRS.2346
            UNIT(1:8)='10**5/s '                                                 DIAGPRS.2347
            UNITS(1:8)='10**5/s '                                                DIAGPRS.2348
         ELSE                                                                    DIAGPRS.2349
            UNIT(1:8)='1/s     '                                                 DIAGPRS.2350
            UNITS(1:8)='1/s     '                                                DIAGPRS.2351
         END IF                                                                  DIAGPRS.2352
C                                                                                DIAGPRS.2353
      ELSE IF(FIELD(1:5).EQ.'WIND '   ) THEN    ! WIND SPEED                     DIAGPRS.2354
         VARNAM(1:8)='WIND UV '                                                  DIAGPRS.2355
         CNT=CONT                                                                DIAGPRS.2356
         NPASS=ISMTHR                                                            DIAGPRS.2357
         ICRSDOT=0                                                               DIAGPRS.2358
         KDIM='3D'                                                               DIAGPRS.2359
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2360
     *      .FALSE.,FOUND)                                                       DIAGPRS.2361
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2362
     *      .FALSE.,FOUND)                                                       DIAGPRS.2363
         CALL WINDSPD(D33,D32,I1,J1,K1,D31)                                      DIAGPRS.2364
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.2365
            UNIT(1:8)='m/s     '                                                 DIAGPRS.2366
            UNITS(1:8)='m/s     '                                                DIAGPRS.2367
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.2368
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.2369
            UNIT(1:8)='kt      '                                                 DIAGPRS.2370
            UNITS(1:8)='kt      '                                                DIAGPRS.2371
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.2372
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.2373
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.2374
            UNITS(1:8)='cm/s    '                                                DIAGPRS.2375
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.2376
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.2377
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.2378
            UNITS(1:8)='mm/s    '                                                DIAGPRS.2379
         ELSE                                                                    DIAGPRS.2380
            UNIT(1:8)='m/s     '                                                 DIAGPRS.2381
            UNITS(1:8)='m/s     '                                                DIAGPRS.2382
         END IF                                                                  DIAGPRS.2383
C                                                                                DIAGPRS.2384
      ELSE IF(FIELD(1:6).EQ.'WINDA '   ) THEN    ! AGEOS WIND SPEED              DIAGPRS.2385
         VARNAM(1:8)='WIND AG '                                                  DIAGPRS.2386
         CNT=CONT                                                                DIAGPRS.2387
         NPASS=ISMTHR                                                            DIAGPRS.2388
         ICRSDOT=0                                                               DIAGPRS.2389
         KDIM='3D'                                                               DIAGPRS.2390
         IF(PROG(1:6).EQ.'REGRID') THEN                                          DIAGPRS.2391
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2392
     *         .FALSE.,FOUND)                                                    DIAGPRS.2393
            CALL DOT2CRS(D31(1,2),I1,J1,K1-1,I1,J1)                              DIAGPRS.2394
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.2395
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.2396
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.2397
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.2398
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.2399
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.2400
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2401
     *            .FALSE.,FOUND)                                                 DIAGPRS.2402
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2403
     *            .FALSE.,FOUND)                                                 DIAGPRS.2404
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.2405
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.2406
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.2407
            END IF                                                               DIAGPRS.2408
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.2409
     *                I3DSTART,0)                                                DIAGPRS.2410
            I3DSTART=I3DSTART+1                                                  DIAGPRS.2411
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2412
     *         .FALSE.,FOUND)                                                    DIAGPRS.2413
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2414
     *         .FALSE.,FOUND)                                                    DIAGPRS.2415
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2416
     *         .FALSE.,FOUND)                                                    DIAGPRS.2417
            CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                        DIAGPRS.2418
     *         .FALSE.,FOUND)                                                    DIAGPRS.2419
            CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                        DIAGPRS.2420
     *         .FALSE.,FOUND)                                                    DIAGPRS.2421
            CALL SFCPRS(D32,D33,D31,D21,D22,P,                                   DIAGPRS.2422
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.2423
            CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                         DIAGPRS.2424
     *                  I3DSTART,0)                                              DIAGPRS.2425
            I3DSTART=I3DSTART+1                                                  DIAGPRS.2426
            CALL READDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2427
     *         .FALSE.,FOUND)                                                    DIAGPRS.2428
C           CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2429
C    *         .FALSE.,FOUND)                                                    DIAGPRS.2430
C           CALL CRS2DOT(D31,I1,J1,K1,I1,J1)                                     DIAGPRS.2431
            CALL SMTHER(D31,D21,I1,J1,K1,NPASS,1)                                DIAGPRS.2432
         ELSE IF(PROG(1:6).EQ.'RAWSFC') THEN                                     DIAGPRS.2433
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.2434
            IERROR=1                                                             DIAGPRS.2435
            RETURN                                                               DIAGPRS.2436
         END IF                                                                  DIAGPRS.2437
         CALL READDAD(D21,'CORIOLIS',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2438
     *      .FALSE.,FOUND)                                                       DIAGPRS.2439
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2440
     *      .FALSE.,FOUND)                                                       DIAGPRS.2441
         CALL READDAD(D23,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2442
     *      .FALSE.,FOUND)                                                       DIAGPRS.2443
         CALL GEOWINDP(D31,D21,D22,D23,I1,J1,K1,DS,D33,D32)                      DIAGPRS.2444
C                                                                                DIAGPRS.2445
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2446
     *      .FALSE.,FOUND)                                                       DIAGPRS.2447
         CALL AGEOW(D31,D33,D21,I1,J1,K1)                                        DIAGPRS.2448
C        CALL WRITDAD(D33,'U AGEO  ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.2449
C        I3DSTART=I3DSTART+1                                                     DIAGPRS.2450
C                                                                                DIAGPRS.2451
         CALL READDAD(D31,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGPRS.2452
     *      .FALSE.,FOUND)                                                       DIAGPRS.2453
         CALL AGEOW(D31,D32,D21,I1,J1,K1)                                        DIAGPRS.2454
C        CALL WRITDAD(D32,'V AGEO  ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.2455
C        I3DSTART=I3DSTART+1                                                     DIAGPRS.2456
         CALL WINDSPD(D33,D32,I1,J1,K1,D31)                                      DIAGPRS.2457
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.2458
            UNIT(1:8)='m/s     '                                                 DIAGPRS.2459
            UNITS(1:8)='m/s     '                                                DIAGPRS.2460
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.2461
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.2462
            UNIT(1:8)='kt      '                                                 DIAGPRS.2463
            UNITS(1:8)='kt      '                                                DIAGPRS.2464
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.2465
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.2466
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.2467
            UNITS(1:8)='cm/s    '                                                DIAGPRS.2468
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.2469
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.2470
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.2471
            UNITS(1:8)='mm/s    '                                                DIAGPRS.2472
         ELSE                                                                    DIAGPRS.2473
            UNIT(1:8)='m/s     '                                                 DIAGPRS.2474
            UNITS(1:8)='m/s     '                                                DIAGPRS.2475
         END IF                                                                  DIAGPRS.2476
C                                                                                DIAGPRS.2477
      ELSE IF(FIELD(1:6).EQ.'WINDG '   ) THEN    ! GEOS WIND SPEED               DIAGPRS.2478
         VARNAM(1:8)='WIND GEO'                                                  DIAGPRS.2479
         CNT=CONT                                                                DIAGPRS.2480
         NPASS=ISMTHR                                                            DIAGPRS.2481
         ICRSDOT=0                                                               DIAGPRS.2482
         KDIM='3D'                                                               DIAGPRS.2483
         IF(PROG(1:6).EQ.'REGRID') THEN                                          DIAGPRS.2484
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2485
     *         .FALSE.,FOUND)                                                    DIAGPRS.2486
            CALL DOT2CRS(D31(1,2),I1,J1,K1-1,I1,J1)                              DIAGPRS.2487
         ELSE IF((PROG(1:6).EQ.'RAWINS').OR.                                     DIAGPRS.2488
     *           (PROG(1:6).EQ.'MMOUTP') .OR.                                    DIAGPRS.2489
     *           (PROG(1:6).EQ.'MM5PRS') .OR.                                    DIAGPRS.2490
     *           (PROG(1:6).EQ.'MM4NHP') .OR.                                    DIAGPRS.2491
     *           (PROG(1:6).EQ.'MZIGPR')) THEN                                   DIAGPRS.2492
            IF(IDRY.NE.1) THEN                                                   DIAGPRS.2493
               CALL READDAD(D31,'RH      ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2494
     *            .FALSE.,FOUND)                                                 DIAGPRS.2495
               CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                    DIAGPRS.2496
     *            .FALSE.,FOUND)                                                 DIAGPRS.2497
               CALL MXRATPRS(D31,D32,P,D21,I1,J1,K1,0,D33)                       DIAGPRS.2498
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGPRS.2499
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGPRS.2500
            END IF                                                               DIAGPRS.2501
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGPRS.2502
     *                I3DSTART,0)                                                DIAGPRS.2503
            I3DSTART=I3DSTART+1                                                  DIAGPRS.2504
            CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2505
     *         .FALSE.,FOUND)                                                    DIAGPRS.2506
            CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2507
     *         .FALSE.,FOUND)                                                    DIAGPRS.2508
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2509
     *         .FALSE.,FOUND)                                                    DIAGPRS.2510
            CALL READDAD(D21,'PSEALVLC',IDAD2D,I1,J1,1,0,                        DIAGPRS.2511
     *         .FALSE.,FOUND)                                                    DIAGPRS.2512
            CALL READDAD(D22,'TERRAIN ',IDAD2D,I1,J1,1,0,                        DIAGPRS.2513
     *         .FALSE.,FOUND)                                                    DIAGPRS.2514
            CALL SFCPRS(D32,D33,D31,D21,D22,P,                                   DIAGPRS.2515
     *               I1,J1,K1,D23,D24,PROG)                                      DIAGPRS.2516
            CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                         DIAGPRS.2517
     *                  I3DSTART,0)                                              DIAGPRS.2518
            I3DSTART=I3DSTART+1                                                  DIAGPRS.2519
            CALL READDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2520
     *         .FALSE.,FOUND)                                                    DIAGPRS.2521
C           CALL READDAD(D31,'H       ',IDAD3D,I1,J1,K1,0,                       DIAGPRS.2522
C    *         .FALSE.,FOUND)                                                    DIAGPRS.2523
C           CALL CRS2DOT(D31,I1,J1,K1,I1,J1)                                     DIAGPRS.2524
            CALL SMTHER(D31,D21,I1,J1,K1,NPASS,1)                                DIAGPRS.2525
         ELSE IF(PROG(1:6).EQ.'RAWSFC') THEN                                     DIAGPRS.2526
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.2527
            IERROR=1                                                             DIAGPRS.2528
            RETURN                                                               DIAGPRS.2529
         END IF                                                                  DIAGPRS.2530
         CALL READDAD(D21,'CORIOLIS',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2531
     *      .FALSE.,FOUND)                                                       DIAGPRS.2532
         CALL READDAD(D22,'MAPFACCR',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2533
     *      .FALSE.,FOUND)                                                       DIAGPRS.2534
         CALL READDAD(D23,'MAPFACDT',IDAD2D,I1,J1, 1,0,                          DIAGPRS.2535
     *      .FALSE.,FOUND)                                                       DIAGPRS.2536
         CALL GEOWINDP(D31,D21,D22,D23,I1,J1,K1,DS,D33,D32)                      DIAGPRS.2537
         CALL WINDSPD(D33,D32,I1,J1,K1,D31)                                      DIAGPRS.2538
C        CALL WRITDAD(D31,'WIND GEO',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGPRS.2539
C        I3DSTART=I3DSTART+1                                                     DIAGPRS.2540
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGPRS.2541
            UNIT(1:8)='m/s     '                                                 DIAGPRS.2542
            UNITS(1:8)='m/s     '                                                DIAGPRS.2543
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGPRS.2544
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGPRS.2545
            UNIT(1:8)='kt      '                                                 DIAGPRS.2546
            UNITS(1:8)='kt      '                                                DIAGPRS.2547
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGPRS.2548
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGPRS.2549
            UNIT(1:8)='cm/s    '                                                 DIAGPRS.2550
            UNITS(1:8)='cm/s    '                                                DIAGPRS.2551
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGPRS.2552
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGPRS.2553
            UNIT(1:8)='mm/s    '                                                 DIAGPRS.2554
            UNITS(1:8)='mm/s    '                                                DIAGPRS.2555
         ELSE                                                                    DIAGPRS.2556
            UNIT(1:8)='m/s     '                                                 DIAGPRS.2557
            UNITS(1:8)='m/s     '                                                DIAGPRS.2558
         END IF                                                                  DIAGPRS.2559
C                                                                                DIAGPRS.2560
C                                                                                DIAGPRS.2561
      ELSE                                                                       DIAGPRS.2562
         CALL READDAD(D31,FIELD(1:8),IDAD2D,I1,J1, 1,0,                          DIAGPRS.2563
     *      DIAGS,FOUND)                                                         DIAGPRS.2564
         IF(FOUND) THEN                                                          DIAGPRS.2565
            VARNAM(1:8)=FIELD(1:8)                                               DIAGPRS.2566
            CNT=CONT                                                             DIAGPRS.2567
            NPASS=0                                                              DIAGPRS.2568
            ICRSDOT=ISMTHR                                                       DIAGPRS.2569
            KDIM='2D'                                                            DIAGPRS.2570
            UNIT(1:8)='        '                                                 DIAGPRS.2571
            UNITS(1:8)=UNIT(1:8)                                                 DIAGPRS.2572
         ELSE                                                                    DIAGPRS.2573
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGPRS.2574
            IERROR=1                                                             DIAGPRS.2575
            RETURN                                                               DIAGPRS.2576
         END IF                                                                  DIAGPRS.2577
      END IF                                                                     DIAGPRS.2578
C                                                                                DIAGPRS.2579
C     ... STORE DATA TO AVOID CONTAMINATION                                      DIAGPRS.2580
C                                                                                DIAGPRS.2581
      IF(((.NOT.OVERLAY).OR.((OVERLAY).AND.(IFRAME.EQ.1))) .AND.                 DIAGPRS.2582
     *   (FIELD(1:4).NE.'BARB')) THEN                                            DIAGPRS.2583
         CALL WRITDAD(D31,'CONREC 1',IDAD3D,I1,J1,K1,I3DFLD1,0)                  DIAGPRS.2584
      ELSEIF (((OVERLAY).AND.(IFRAME.EQ.2)) .AND.                                DIAGPRS.2585
     *   (FIELD(1:4).NE.'BARB')) THEN                                            DIAGPRS.2586
         CALL WRITDAD(D31,'CONREC 2',IDAD3D,I1,J1,K1,I3DFLD2,0)                  DIAGPRS.2587
      ELSE IF (FIELD(1:4).EQ.'BARB') THEN                                        DIAGPRS.2588
         CALL WRITDAD(D31,'VELVCN U',IDAD3D,I1,J1,K1,I3DFLD3,0)                  DIAGPRS.2589
         CALL WRITDAD(D32,'VELVCN V',IDAD3D,I1,J1,K1,I3DFLD4,0)                  DIAGPRS.2590
      END IF                                                                     DIAGPRS.2591
      RETURN                                                                     DIAGPRS.2592
      END                                                                        DIAGPRS.2593
         subroutine diffh(hinteg,h,i1,j1,k1)                                     19DEC02.14
         real hinteg(i1,j1,k1),h(i1,j1,k1)                                       19DEC02.15
         do k=2,k1                                                               19DEC02.16
         do j=1,j1-1                                                             19DEC02.17
         do i=1,i1-1                                                             19DEC02.18
            hinteg(i,j,k)=hinteg(i,j,k)-h(i,j,k)                                 19DEC02.19
         enddo                                                                   19DEC02.20
         enddo                                                                   19DEC02.21
         enddo                                                                   19DEC02.22
         end                                                                     19DEC02.23
