      SUBROUTINE DIAGSIG(VARNAM,UNITS,CNT,NPASS,ICRSDOT,KDIM,                    DIAGSIG.1
     *   I3DFLD1,I3DFLD2,I3DFLD3,I3DFLD4,I2DSTART,I3DSTART,IERROR)               DIAGSIG.2
C                                                                                DIAGSIG.3
#     include <data.incl>                                                        DIAGSIG.4
       call DIAGSIG_1(VARNAM,UNITS,CNT,NPASS,ICRSDOT,KDIM,                       DIAGSIG.5
     *   I3DFLD1,I3DFLD2,I3DFLD3,I3DFLD4,I2DSTART,I3DSTART,IERROR,               DIAGSIG.6
     *                 DATASP(PTRD31),DATASP(PTRD32),                            DIAGSIG.7
     *                 DATASP(PTRD33),DATASP(PTRD34),                            DIAGSIG.8
     *                 DATASP(PTRD21),DATASP(PTRD22),                            DIAGSIG.9
     *                 DATASP(PTRD23),DATASP(PTRD24),                            DIAGSIG.10
     *                               I1,J1,K1 )                                  DIAGSIG.11
      RETURN                                                                     DIAGSIG.12
      END                                                                        DIAGSIG.13
C                                                                                DIAGSIG.14
      SUBROUTINE DIAGSIG_1(VARNAM,UNITS,CNT,NPASS,ICRSDOT,KDIM,                  DIAGSIG.15
     *   I3DFLD1,I3DFLD2,I3DFLD3,I3DFLD4,I2DSTART,I3DSTART,IERROR,               DIAGSIG.16
     *  D31,D32,D33,D34,D21,D22,D23,D24,I1,J1,K1)                                DIAGSIG.17
C                                                                                DIAGSIG.18
C     SECTION  DIAGNOSTIC                                                        DIAGSIG.19
C     PURPOSE  USES AVAILABLE FIELDS TO COMPUTE REQUIRED                         DIAGSIG.20
C              DIAGNOSTIC ON SIGMA LEVELS.  THIS IS THEN STORED                  DIAGSIG.21
C              ON DISK FOR POSSIBLE LATER USE                                    DIAGSIG.22
C                                                                                DIAGSIG.23
#     include <headerv3.incl>                                                    DIAGSIG.24
#     include <progname.incl>                                                    DIAGSIG.25
#     include <modelpar.incl>                                                    DIAGSIG.26
#     include <vlevel.incl>                                                      DIAGSIG.27
                                                                                 DIAGSIG.28
      real D31(I1*J1,K1),D32(I1*J1,K1),D33(I1*J1,K1),D34(I1*J1,K1),              DIAGSIG.29
     *     D21(I1*J1),D22(I1*J1),D23(I1*J1),D24(I1*J1)                           DIAGSIG.30
c                                                                                DIAGSIG.31
      COMMON /GLEAN1/ FIELD,UNIT,FIELD2,UNIT2                                    DIAGSIG.32
      CHARACTER *80   FIELD,UNIT,FIELD2,UNIT2                                    DIAGSIG.33
      COMMON /GLEAN2/ CONT,ISMTHR,CONT2,ISMTHR2,XLATX,YLONY                      DIAGSIG.34
      LOGICAL   MLF(10)                                                          DIAGSIG.35
      DIMENSION JYR(18), JMO(18), JDY(18), JHR(18),                              DIAGSIG.36
     *          NBOGUS(18), KBOGUS(18)                                           DIAGSIG.37
      LOGICAL   IPLOT(18), NSELIM(18)                                            DIAGSIG.38
      COMMON /HEADER/ MDATE,IPROG,ICOORD,                                        DIAGSIG.39
     *   NLV,IVCOORD(100),VCOORD(100),                                           DIAGSIG.40
     *   MIF, MRF, MLF,                                                          DIAGSIG.41
     *   JYR,JMO,JDY,JHR,IPLOT,NSELIM,NBOGUS,KBOGUS,IPROJ                        DIAGSIG.42
      COMMON /WHEN/ MDATENOW,mdatebeg                                            DIAGSIG.43
      COMMON /HDRCHR/  PROG                                                      DIAGSIG.44
      COMMON /MM5PHY/ NFLAGS,IFLAGS(100)                                         DIAGSIG.45
      COMMON /DADTAB1/ TABNAME,TNPERM                                            DIAGSIG.46
      COMMON /DADTAB2/ TABREC,TRPERM                                             DIAGSIG.47
      PARAMETER (LENTAB=5000,LTPERM=1000)                                        DIAGSIG.48
      CHARACTER *8 TABNAME(LENTAB),TNPERM(LTPERM)                                DIAGSIG.49
      INTEGER TABREC(LENTAB),TRPERM(LTPERM)                                      DIAGSIG.50
      PARAMETER (IDAD2D=91,IDAD3D=92,IMMHDR=93)                                  DIAGSIG.51
      COMMON /MAPSTUFF/ XLONC,PHIC,XLAT1,XLON1,XLAT2,XLON2,                      DIAGSIG.52
     *   ISTART,IEND,JSTART,JEND,                                                DIAGSIG.53
     *   IMAPMAX,IMAPST,IMAPEND,JMAPMAX,JMAPST,JMAPEND,                          DIAGSIG.54
     *   XPA,XPB,YPA,YPB,                                                        DIAGSIG.55
     *   DS,OVERLAY,IFRAME,INSIDE,IFORM,NUMFRAME                                 DIAGSIG.56
      COMMON /MASK/ IMASK                                                        DIAGSIG.57
      LOGICAL OVERLAY                                                            DIAGSIG.58
C                                                                                DIAGSIG.59
      LOGICAL TINT,PINT,ZINT                                                     DIAGSIG.60
      COMMON /COORDINT/ TINT,PINT,ZINT,VERTVAL                                   DIAGSIG.61
      CHARACTER *3 VERTVALC                                                      DIAGSIG.62
      COMMON /COORDIN2/ VERTVALC                                                 DIAGSIG.63
C                                                                                DIAGSIG.64
      CHARACTER *8 VARNAM,UNITS                                                  DIAGSIG.65
      LOGICAL FOUND,DIAGS                                                        DIAGSIG.66
      CHARACTER *2 KDIM                                                          DIAGSIG.67
C                                                                                DIAGSIG.68
      COMMON /CONRE1/ IOFFP      ,SPVAL                                          DIAGSIG.69
C                                                                                DIAGSIG.70
C     ... GET DEFAULTS                                                           DIAGSIG.71
C                                                                                DIAGSIG.72
C  Get the FLAGs from MM5 model output:                                          DIAGSIG.73
C                                                                                DIAGSIG.74
      INDEX = BHI( 1,1)                                                          DIAGSIG.75
C     PRINT 5,INDEX,PROG(1:6),IDRY,IMOIST,INHYD,ITGFLG,IICE,INAV,                DIAGSIG.76
C    +        IGRAUPEL                                                           DIAGSIG.77
5     FORMAT(2X,'INDEX=',I2,'  PROG=',A6,'  IDRY=',I2,'  IMOIST=',I2,            DIAGSIG.78
     +     '  INHYD=',I2,'  ITGFLG=',I2,'  IICE=',I2,'  INAV=',I2,               DIAGSIG.79
     +     '  IGRAUPEL=',I2)                                                     DIAGSIG.80
      IERROR=0                                                                   DIAGSIG.81
                                                                                 DIAGSIG.82
      DIAGS=.TRUE.                                                               DIAGSIG.83
      IF((FIELD(1:5).EQ.'BARB '   ) .OR.    ! WIND BARBS                         DIAGSIG.84
     *   (FIELD(1:5).EQ.'VECT '    ) .OR.    ! WIND VECTORS                      DIAGSIG.85
     *   (FIELD(1:5).EQ.'VESL '    )) THEN   ! WIND STREAM LINES                 DIAGSIG.86
         VARNAM(1:8)='BARB UV '                                                  DIAGSIG.87
         IF(FIELD(1:4).EQ.'BARB') THEN                                           DIAGSIG.88
            IFORM=3                                                              DIAGSIG.89
         ELSE IF(FIELD(1:4).EQ.'VECT') THEN                                      DIAGSIG.90
            IFORM=1                                                              DIAGSIG.91
            FIELD(1:4)='BARB'                                                    DIAGSIG.92
         ELSE IF(FIELD(1:4).EQ.'VESL') THEN                                      DIAGSIG.93
            IFORM=2                                                              DIAGSIG.94
            FIELD(1:4)='BARB'                                                    DIAGSIG.95
         END IF                                                                  DIAGSIG.96
         CNT=CONT                                                                DIAGSIG.97
         NPASS=ISMTHR                                                            DIAGSIG.98
         ICRSDOT=0                                                               DIAGSIG.99
         KDIM='3D'                                                               DIAGSIG.100
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.101
     *      .FALSE.,FOUND)                                                       DIAGSIG.102
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.103
     *      .FALSE.,FOUND)                                                       DIAGSIG.104
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.105
            UNIT(1:8)='m/s     '                                                 DIAGSIG.106
            UNITS(1:8)='m/s     '                                                DIAGSIG.107
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.108
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.109
            CALL MPS2KT(D32,I1,J1,K1,0)                                          DIAGSIG.110
            UNIT(1:8)='kt      '                                                 DIAGSIG.111
            UNITS(1:8)='kt      '                                                DIAGSIG.112
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.113
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.114
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.115
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.116
            UNITS(1:8)='cm/s    '                                                DIAGSIG.117
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.118
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.119
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.120
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.121
            UNITS(1:8)='mm/s    '                                                DIAGSIG.122
         ELSE                                                                    DIAGSIG.123
            UNIT(1:8)='m/s     '                                                 DIAGSIG.124
            UNITS(1:8)='m/s     '                                                DIAGSIG.125
         END IF                                                                  DIAGSIG.126
C                                                                                DIAGSIG.127
      ELSE IF((FIELD(1:6).EQ.'BARBG '   ) .OR.! GEOS WIND BARBS                  DIAGSIG.128
     *   (FIELD(1:6).EQ.'VECTG '    ) .OR.    ! WIND VECTORS                     DIAGSIG.129
     *   (FIELD(1:6).EQ.'VESLG '    )) THEN   ! GEOS WIND STREAM LINES           DIAGSIG.130
         VARNAM(1:8)='BARB GEO'                                                  DIAGSIG.131
         IF(FIELD(1:4).EQ.'BARB') THEN                                           DIAGSIG.132
            IFORM=3                                                              DIAGSIG.133
         ELSE IF(FIELD(1:4).EQ.'VECT') THEN                                      DIAGSIG.134
            IFORM=1                                                              DIAGSIG.135
            FIELD(1:4)='BARB'                                                    DIAGSIG.136
         ELSE IF(FIELD(1:4).EQ.'VESL') THEN                                      DIAGSIG.137
            IFORM=2                                                              DIAGSIG.138
            FIELD(1:4)='BARB'                                                    DIAGSIG.139
         END IF                                                                  DIAGSIG.140
C                                                                                DIAGSIG.141
         CNT=CONT                                                                DIAGSIG.142
         NPASS=ISMTHR                                                            DIAGSIG.143
         ICRSDOT=0                                                               DIAGSIG.144
         KDIM='3D'                                                               DIAGSIG.145
C                                                                                DIAGSIG.146
         IF (INHYD.EQ.1) THEN                                                    DIAGSIG.147
           CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                        DIAGSIG.148
     *     DIAGS,FOUND)                                                          DIAGSIG.149
           IF(.NOT.FOUND) THEN                                                   DIAGSIG.150
             PRINT *,'FIELD PP NOT FOUND'                                        DIAGSIG.151
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                       DIAGSIG.152
             IERROR=1                                                            DIAGSIG.153
             RETURN                                                              DIAGSIG.154
           ENDIF                                                                 DIAGSIG.155
           CALL CLEAR(D24,I1,J1, 1)                                              DIAGSIG.156
         ELSE                                                                    DIAGSIG.157
           CALL CLEAR(D33,I1,J1,K1)                                              DIAGSIG.158
           CALL READDAD(D24,'TERRAIN ',IMMHDR,I1,J1,1,1,                         DIAGSIG.159
     *      .FALSE.,FOUND)                                                       DIAGSIG.160
         ENDIF                                                                   DIAGSIG.161
         IF(BHI(  1,1).EQ.5) THEN                                                DIAGSIG.162
            CALL READDAD(D32,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.163
     *      .FALSE.,FOUND)                                                       DIAGSIG.164
         ELSE IF(BHI(  1,1).EQ.11) THEN                                          DIAGSIG.165
            IF(IDRY.NE.1) THEN                                                   DIAGSIG.166
               CALL READDAD(D32,'Q       ',IDAD3D,I1,J1,K1,0,                    DIAGSIG.167
     *            .FALSE.,FOUND)                                                 DIAGSIG.168
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGSIG.169
               CALL CLEAR(D32,I1,J1,K1)                                          DIAGSIG.170
               CALL WRITDAD(D32,'Q       ',IDAD3D,I1,J1,K1,                      DIAGSIG.171
     *               I3DSTART,0)                                                 DIAGSIG.172
               I3DSTART=I3DSTART+1                                               DIAGSIG.173
            END IF                                                               DIAGSIG.174
         END IF                                                                  DIAGSIG.175
         CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.176
     *      .FALSE.,FOUND)                                                       DIAGSIG.177
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1,1,0,                           DIAGSIG.178
     *      .FALSE.,FOUND)                                                       DIAGSIG.179
         CALL READDAD(D22,'CORIOLIS',IMMHDR,I1,J1, 1,1,                          DIAGSIG.180
     *      .FALSE.,FOUND)                                                       DIAGSIG.181
         CALL READDAD(D23,'MAPFACDT',IMMHDR,I1,J1, 1,1,                          DIAGSIG.182
     *      .FALSE.,FOUND)                                                       DIAGSIG.183
                                                                                 DIAGSIG.184
         CALL GEOWINDS(D31,D32,D33,D21,D23,D22,D24,SIGMA,DS,DS,                  DIAGSIG.185
     *                 I1,J1,K1,PTOP,INHYD,IDRY,D31,D32)                         DIAGSIG.186
         CALL WRITDAD(D31,'U GEO   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.187
         I3DSTART=I3DSTART+1                                                     DIAGSIG.188
         CALL WRITDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.189
         I3DSTART=I3DSTART+1                                                     DIAGSIG.190
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.191
            UNIT(1:8)='m/s     '                                                 DIAGSIG.192
            UNITS(1:8)='m/s     '                                                DIAGSIG.193
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.194
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.195
            CALL MPS2KT(D32,I1,J1,K1,0)                                          DIAGSIG.196
            UNIT(1:8)='kt      '                                                 DIAGSIG.197
            UNITS(1:8)='kt      '                                                DIAGSIG.198
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.199
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.200
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.201
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.202
            UNITS(1:8)='cm/s    '                                                DIAGSIG.203
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.204
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.205
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.206
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.207
            UNITS(1:8)='mm/s    '                                                DIAGSIG.208
         ELSE                                                                    DIAGSIG.209
            UNIT(1:8)='m/s     '                                                 DIAGSIG.210
            UNITS(1:8)='m/s     '                                                DIAGSIG.211
         END IF                                                                  DIAGSIG.212
C                                                                                DIAGSIG.213
      ELSE IF((FIELD(1:6).EQ.'BARBA '   ) .OR.! GEOS WIND BARBS                  DIAGSIG.214
     *   (FIELD(1:6).EQ.'VECTA '    ) .OR.    ! WIND VECTORS                     DIAGSIG.215
     *   (FIELD(1:6).EQ.'VESLA '    )) THEN   ! GEOS WIND STREAM LINES           DIAGSIG.216
         VARNAM(1:8)='BARB AG '                                                  DIAGSIG.217
         IF(FIELD(1:4).EQ.'BARB') THEN                                           DIAGSIG.218
            IFORM=3                                                              DIAGSIG.219
         ELSE IF(FIELD(1:4).EQ.'VECT') THEN                                      DIAGSIG.220
            IFORM=1                                                              DIAGSIG.221
            FIELD(1:4)='BARB'                                                    DIAGSIG.222
         ELSE IF(FIELD(1:4).EQ.'VESL') THEN                                      DIAGSIG.223
            IFORM=2                                                              DIAGSIG.224
            FIELD(1:4)='BARB'                                                    DIAGSIG.225
         END IF                                                                  DIAGSIG.226
C                                                                                DIAGSIG.227
         CNT=CONT                                                                DIAGSIG.228
         NPASS=ISMTHR                                                            DIAGSIG.229
         ICRSDOT=0                                                               DIAGSIG.230
         KDIM='3D'                                                               DIAGSIG.231
         CALL READDAD(D31,'U GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.232
     *   DIAGS,FOUND)                                                            DIAGSIG.233
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.234
            PRINT *,'FIELD U GEO NOT FOUND'                                      DIAGSIG.235
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.236
            IERROR=1                                                             DIAGSIG.237
            RETURN                                                               DIAGSIG.238
         ENDIF                                                                   DIAGSIG.239
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.240
     *      .FALSE.,FOUND)                                                       DIAGSIG.241
         CALL AGEOW(D33,D31,D21,i1,j1,k1)                                        DIAGSIG.242
         CALL WRITDAD(D31,'U AGEO  ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.243
         I3DSTART=I3DSTART+1                                                     DIAGSIG.244
         CALL READDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.245
     *      .FALSE.,FOUND)                                                       DIAGSIG.246
         CALL READDAD(D33,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.247
     *      .FALSE.,FOUND)                                                       DIAGSIG.248
         CALL AGEOW(D33,D32,D21,i1,j1,k1)                                        DIAGSIG.249
         CALL WRITDAD(D32,'V AGEO  ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.250
         I3DSTART=I3DSTART+1                                                     DIAGSIG.251
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.252
            UNIT(1:8)='m/s     '                                                 DIAGSIG.253
            UNITS(1:8)='m/s     '                                                DIAGSIG.254
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.255
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.256
            CALL MPS2KT(D32,I1,J1,K1,0)                                          DIAGSIG.257
            UNIT(1:8)='kt      '                                                 DIAGSIG.258
            UNITS(1:8)='kt      '                                                DIAGSIG.259
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.260
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.261
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.262
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.263
            UNITS(1:8)='cm/s    '                                                DIAGSIG.264
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.265
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.266
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.267
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.268
            UNITS(1:8)='mm/s    '                                                DIAGSIG.269
         ELSE                                                                    DIAGSIG.270
            UNIT(1:8)='m/s     '                                                 DIAGSIG.271
            UNITS(1:8)='m/s     '                                                DIAGSIG.272
         END IF                                                                  DIAGSIG.273
C                                                                                DIAGSIG.274
      ELSE IF(FIELD(1:6).EQ.'WINDA '   ) THEN    ! AGEOS WIND SPEED              DIAGSIG.275
         VARNAM(1:8)='WIND AG '                                                  DIAGSIG.276
         CNT=CONT                                                                DIAGSIG.277
         NPASS=ISMTHR                                                            DIAGSIG.278
         ICRSDOT=0                                                               DIAGSIG.279
         KDIM='3D'                                                               DIAGSIG.280
         CALL READDAD(D33,'U GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.281
     *   DIAGS,FOUND)                                                            DIAGSIG.282
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.283
            PRINT *,'FIELD U GEO NOT FOUND'                                      DIAGSIG.284
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.285
            IERROR=1                                                             DIAGSIG.286
            RETURN                                                               DIAGSIG.287
         ENDIF                                                                   DIAGSIG.288
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.289
     *      .FALSE.,FOUND)                                                       DIAGSIG.290
         CALL AGEOW(D31,D33,D21,i1,j1,k1)                                        DIAGSIG.291
         CALL READDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.292
     *      .FALSE.,FOUND)                                                       DIAGSIG.293
         CALL READDAD(D31,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.294
     *      .FALSE.,FOUND)                                                       DIAGSIG.295
         CALL AGEOW(D31,D32,D21,i1,j1,k1)                                        DIAGSIG.296
         CALL WINDSPD(D33,D32,I1,J1,K1,D31)                                      DIAGSIG.297
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.298
            UNIT(1:8)='m/s     '                                                 DIAGSIG.299
            UNITS(1:8)='m/s     '                                                DIAGSIG.300
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.301
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.302
            UNIT(1:8)='kt      '                                                 DIAGSIG.303
            UNITS(1:8)='kt      '                                                DIAGSIG.304
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.305
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.306
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.307
            UNITS(1:8)='cm/s    '                                                DIAGSIG.308
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.309
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.310
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.311
            UNITS(1:8)='mm/s    '                                                DIAGSIG.312
         ELSE                                                                    DIAGSIG.313
            UNIT(1:8)='m/s     '                                                 DIAGSIG.314
            UNITS(1:8)='m/s     '                                                DIAGSIG.315
         END IF                                                                  DIAGSIG.316
C                                                                                DIAGSIG.317
      ELSE IF(FIELD(1:6).EQ.'WINDG '   ) THEN    ! GEOS WIND SPEED               DIAGSIG.318
         VARNAM(1:8)='WIND GEO'                                                  DIAGSIG.319
         CNT=CONT                                                                DIAGSIG.320
         NPASS=ISMTHR                                                            DIAGSIG.321
         ICRSDOT=0                                                               DIAGSIG.322
         KDIM='3D'                                                               DIAGSIG.323
         CALL READDAD(D33,'U GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.324
     *   DIAGS,FOUND)                                                            DIAGSIG.325
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.326
            PRINT *,'FIELD U GEO NOT FOUND'                                      DIAGSIG.327
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.328
            IERROR=1                                                             DIAGSIG.329
            RETURN                                                               DIAGSIG.330
         ENDIF                                                                   DIAGSIG.331
         CALL READDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.332
     *      .FALSE.,FOUND)                                                       DIAGSIG.333
         CALL WINDSPD(D33,D32,I1,J1,K1,D31)                                      DIAGSIG.334
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.335
            UNIT(1:8)='m/s     '                                                 DIAGSIG.336
            UNITS(1:8)='m/s     '                                                DIAGSIG.337
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.338
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.339
            UNIT(1:8)='kt      '                                                 DIAGSIG.340
            UNITS(1:8)='kt      '                                                DIAGSIG.341
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.342
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.343
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.344
            UNITS(1:8)='cm/s    '                                                DIAGSIG.345
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.346
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.347
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.348
            UNITS(1:8)='mm/s    '                                                DIAGSIG.349
         ELSE                                                                    DIAGSIG.350
            UNIT(1:8)='m/s     '                                                 DIAGSIG.351
            UNITS(1:8)='m/s     '                                                DIAGSIG.352
         ENDIF                                                                   DIAGSIG.353
C                                                                                DIAGSIG.354
      ELSE IF(FIELD(1:5).EQ.'AXWG ') THEN    ! ALONG CROSS SECTION WINDS         DIAGSIG.355
         VARNAM(1:8)='AXWG    '                                                  DIAGSIG.356
         CNT=CONT                                                                DIAGSIG.357
         NPASS=ISMTHR                                                            DIAGSIG.358
         ICRSDOT=0                                                               DIAGSIG.359
         KDIM='3D'                                                               DIAGSIG.360
         CALL READDAD(D33,'U GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.361
     *      .FALSE.,FOUND)                                                       DIAGSIG.362
         CALL READDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.363
     *      .FALSE.,FOUND)                                                       DIAGSIG.364
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.365
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.366
            UNIT(1:8)='m/s     '                                                 DIAGSIG.367
            UNITS(1:8)='m/s     '                                                DIAGSIG.368
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.369
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.370
            UNIT(1:8)='kt      '                                                 DIAGSIG.371
            UNITS(1:8)='kt      '                                                DIAGSIG.372
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.373
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.374
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.375
            UNITS(1:8)='cm/s    '                                                DIAGSIG.376
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.377
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.378
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.379
            UNITS(1:8)='mm/s    '                                                DIAGSIG.380
         ELSE                                                                    DIAGSIG.381
            UNIT(1:8)='m/s     '                                                 DIAGSIG.382
            UNITS(1:8)='m/s     '                                                DIAGSIG.383
         ENDIF                                                                   DIAGSIG.384
      ELSE IF(FIELD(1:5).EQ.'XXWG ') THEN  ! NORMAL CROSS SECTION WINDS          DIAGSIG.385
         VARNAM(1:8)='XXWG    '                                                  DIAGSIG.386
         CNT=CONT                                                                DIAGSIG.387
         NPASS=ISMTHR                                                            DIAGSIG.388
         ICRSDOT=0                                                               DIAGSIG.389
         KDIM='3D'                                                               DIAGSIG.390
         CALL READDAD(D33,'U GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.391
     *      .FALSE.,FOUND)                                                       DIAGSIG.392
         CALL READDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.393
     *      .FALSE.,FOUND)                                                       DIAGSIG.394
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.395
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.396
            UNIT(1:8)='m/s     '                                                 DIAGSIG.397
            UNITS(1:8)='m/s     '                                                DIAGSIG.398
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.399
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.400
            UNIT(1:8)='kt      '                                                 DIAGSIG.401
            UNITS(1:8)='kt      '                                                DIAGSIG.402
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.403
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.404
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.405
            UNITS(1:8)='cm/s    '                                                DIAGSIG.406
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.407
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.408
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.409
            UNITS(1:8)='mm/s    '                                                DIAGSIG.410
         ELSE                                                                    DIAGSIG.411
            UNIT(1:8)='m/s     '                                                 DIAGSIG.412
            UNITS(1:8)='m/s     '                                                DIAGSIG.413
         ENDIF                                                                   DIAGSIG.414
      ELSE IF(FIELD(1:5).EQ.'CXWG ') THEN  ! CROSS SECTION CIRCULATION           DIAGSIG.415
         VARNAM(1:8)='CXWG    '                                                  DIAGSIG.416
         CNT=AMAX1(CONT,1.)                                                      DIAGSIG.417
         NPASS=ISMTHR                                                            DIAGSIG.418
         ICRSDOT=0                                                               DIAGSIG.419
         KDIM='3D'                                                               DIAGSIG.420
         CALL READDAD(D32,'W       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.421
     *      diags,FOUND)                                                         DIAGSIG.422
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.423
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.424
            IERROR=1                                                             DIAGSIG.425
            RETURN                                                               DIAGSIG.426
         END IF                                                                  DIAGSIG.427
         CALL WRITDAD(D32,'OMG*CXW ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.428
         CALL READDAD(D32,'U GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.429
     *      .FALSE.,FOUND)                                                       DIAGSIG.430
         CALL READDAD(D33,'V GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.431
     *      .FALSE.,FOUND)                                                       DIAGSIG.432
         CALL CRSWINDS(D32,D33,I1,J1,K1,FIELD,D31)                               DIAGSIG.433
         FIELD(1:4)='BARB'                                                       DIAGSIG.434
         CALL READDAD(D32,'W       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.435
     *      .FALSE.,FOUND)                                                       DIAGSIG.436
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.437
            UNIT(1:8)='m/s     '                                                 DIAGSIG.438
            UNITS(1:8)='m/s     '                                                DIAGSIG.439
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.440
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.441
            CALL MPS2KT(D32, I1, J1, K1, 0)                                      DIAGSIG.442
            UNIT(1:8)='kt      '                                                 DIAGSIG.443
            UNITS(1:8)='kt      '                                                DIAGSIG.444
         ELSE                                                                    DIAGSIG.445
            UNIT(1:8)='m/s     '                                                 DIAGSIG.446
            UNITS(1:8)='m/s     '                                                DIAGSIG.447
         ENDIF                                                                   DIAGSIG.448
      ELSE IF(FIELD(1:5).EQ.'CUVG ') THEN  ! PROFILERISH PLOT                    DIAGSIG.449
         VARNAM(1:8)='CUVG    '                                                  DIAGSIG.450
         CNT=AMAX1(CONT,1.)                                                      DIAGSIG.451
         NPASS=ISMTHR                                                            DIAGSIG.452
         ICRSDOT=0                                                               DIAGSIG.453
         KDIM='3D'                                                               DIAGSIG.454
         CALL READDAD(D31,'U GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.455
     *      .FALSE.,FOUND)                                                       DIAGSIG.456
         CALL READDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.457
     *      .FALSE.,FOUND)                                                       DIAGSIG.458
         CALL READDAD(D21,'LONGIDOT',IMMHDR,I1,J1, 1,1,                          DIAGSIG.459
     *        .FALSE.,FOUND)                                                     DIAGSIG.460
         CALL MAP2MET(D31,D32,D21,I1,J1,K1,XLONC)                                DIAGSIG.461
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.462
            UNIT(1:8)='m/s     '                                                 DIAGSIG.463
            UNITS(1:8)='m/s     '                                                DIAGSIG.464
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.465
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.466
            CALL MPS2KT(D32, I1, J1, K1, 0)                                      DIAGSIG.467
            UNIT(1:8)='kt      '                                                 DIAGSIG.468
            UNITS(1:8)='kt      '                                                DIAGSIG.469
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.470
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.471
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.472
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.473
            UNITS(1:8)='cm/s    '                                                DIAGSIG.474
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.475
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.476
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.477
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.478
            UNITS(1:8)='mm/s    '                                                DIAGSIG.479
         ELSE                                                                    DIAGSIG.480
            UNIT(1:8)='m/s     '                                                 DIAGSIG.481
            UNITS(1:8)='m/s     '                                                DIAGSIG.482
         ENDIF                                                                   DIAGSIG.483
         CALL WRITDAD(D31,'U MET   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.484
         I3DSTART=I3DSTART+1                                                     DIAGSIG.485
         CALL WRITDAD(D32,'V MET   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.486
         I3DSTART=I3DSTART+1                                                     DIAGSIG.487
      ELSE IF(FIELD(1:4).EQ.'AMG ') THEN  ! ABSOLUTE MOMENTUM                    DIAGSIG.488
         VARNAM(1:8)='AMG     '                                                  DIAGSIG.489
         CNT=CONT                                                                DIAGSIG.490
         NPASS=ISMTHR                                                            DIAGSIG.491
         ICRSDOT=0                                                               DIAGSIG.492
         KDIM='3D'                                                               DIAGSIG.493
         CALL READDAD(D33,'U GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.494
     *      .FALSE.,FOUND)                                                       DIAGSIG.495
         CALL READDAD(D32,'V GEO   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.496
     *      .FALSE.,FOUND)                                                       DIAGSIG.497
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.498
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.499
            UNIT(1:8)='m/s     '                                                 DIAGSIG.500
            UNITS(1:8)='m/s     '                                                DIAGSIG.501
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.502
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.503
            UNIT(1:8)='kt      '                                                 DIAGSIG.504
            UNITS(1:8)='kt      '                                                DIAGSIG.505
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.506
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.507
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.508
            UNITS(1:8)='cm/s    '                                                DIAGSIG.509
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.510
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.511
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.512
            UNITS(1:8)='mm/s    '                                                DIAGSIG.513
         ELSE                                                                    DIAGSIG.514
            UNIT(1:8)='m/s     '                                                 DIAGSIG.515
            UNITS(1:8)='m/s     '                                                DIAGSIG.516
         ENDIF                                                                   DIAGSIG.517
C                                                                                DIAGSIG.518
      ELSE IF(FIELD(1:5).EQ.'AXWA ') THEN    ! ALONG CROSS SECTION WINDS         DIAGSIG.519
         VARNAM(1:8)='AXWA    '                                                  DIAGSIG.520
         CNT=CONT                                                                DIAGSIG.521
         NPASS=ISMTHR                                                            DIAGSIG.522
         ICRSDOT=0                                                               DIAGSIG.523
         KDIM='3D'                                                               DIAGSIG.524
         CALL READDAD(D33,'U AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.525
     *      .FALSE.,FOUND)                                                       DIAGSIG.526
         CALL READDAD(D32,'V AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.527
     *      .FALSE.,FOUND)                                                       DIAGSIG.528
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.529
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.530
            UNIT(1:8)='m/s     '                                                 DIAGSIG.531
            UNITS(1:8)='m/s     '                                                DIAGSIG.532
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.533
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.534
            UNIT(1:8)='kt      '                                                 DIAGSIG.535
            UNITS(1:8)='kt      '                                                DIAGSIG.536
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.537
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.538
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.539
            UNITS(1:8)='cm/s    '                                                DIAGSIG.540
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.541
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.542
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.543
            UNITS(1:8)='mm/s    '                                                DIAGSIG.544
         ELSE                                                                    DIAGSIG.545
            UNIT(1:8)='m/s     '                                                 DIAGSIG.546
            UNITS(1:8)='m/s     '                                                DIAGSIG.547
         ENDIF                                                                   DIAGSIG.548
      ELSE IF(FIELD(1:5).EQ.'XXWA ') THEN  ! NORMAL CROSS SECTION WINDS          DIAGSIG.549
         VARNAM(1:8)='XXWA    '                                                  DIAGSIG.550
         CNT=CONT                                                                DIAGSIG.551
         NPASS=ISMTHR                                                            DIAGSIG.552
         ICRSDOT=0                                                               DIAGSIG.553
         KDIM='3D'                                                               DIAGSIG.554
         CALL READDAD(D33,'U AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.555
     *      .FALSE.,FOUND)                                                       DIAGSIG.556
         CALL READDAD(D32,'V AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.557
     *      .FALSE.,FOUND)                                                       DIAGSIG.558
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.559
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.560
            UNIT(1:8)='m/s     '                                                 DIAGSIG.561
            UNITS(1:8)='m/s     '                                                DIAGSIG.562
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.563
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.564
            UNIT(1:8)='kt      '                                                 DIAGSIG.565
            UNITS(1:8)='kt      '                                                DIAGSIG.566
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.567
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.568
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.569
            UNITS(1:8)='cm/s    '                                                DIAGSIG.570
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.571
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.572
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.573
            UNITS(1:8)='mm/s    '                                                DIAGSIG.574
         ELSE                                                                    DIAGSIG.575
            UNIT(1:8)='m/s     '                                                 DIAGSIG.576
            UNITS(1:8)='m/s     '                                                DIAGSIG.577
         ENDIF                                                                   DIAGSIG.578
      ELSE IF(FIELD(1:5).EQ.'CXWA ') THEN  ! CROSS SECTION CIRCULATION           DIAGSIG.579
         VARNAM(1:8)='CXWA    '                                                  DIAGSIG.580
         CNT=AMAX1(CONT,1.)                                                      DIAGSIG.581
         NPASS=ISMTHR                                                            DIAGSIG.582
         ICRSDOT=0                                                               DIAGSIG.583
         KDIM='3D'                                                               DIAGSIG.584
         CALL READDAD(D32,'W       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.585
     *      diags,FOUND)                                                         DIAGSIG.586
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.587
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.588
            IERROR=1                                                             DIAGSIG.589
            RETURN                                                               DIAGSIG.590
         END IF                                                                  DIAGSIG.591
         CALL WRITDAD(D32,'OMG*CXW ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.592
         CALL READDAD(D32,'U AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.593
     *      .FALSE.,FOUND)                                                       DIAGSIG.594
         CALL READDAD(D33,'V AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.595
     *      .FALSE.,FOUND)                                                       DIAGSIG.596
         CALL CRSWINDS(D32,D33,I1,J1,K1,FIELD,D31)                               DIAGSIG.597
         FIELD(1:4)='BARB'                                                       DIAGSIG.598
         CALL READDAD(D32,'W       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.599
     *      .FALSE.,FOUND)                                                       DIAGSIG.600
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.601
            UNIT(1:8)='m/s     '                                                 DIAGSIG.602
            UNITS(1:8)='m/s     '                                                DIAGSIG.603
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.604
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.605
            CALL MPS2KT(D32, I1, J1, K1, 0)                                      DIAGSIG.606
            UNIT(1:8)='kt      '                                                 DIAGSIG.607
            UNITS(1:8)='kt      '                                                DIAGSIG.608
         ELSE                                                                    DIAGSIG.609
            UNIT(1:8)='m/s     '                                                 DIAGSIG.610
            UNITS(1:8)='m/s     '                                                DIAGSIG.611
         ENDIF                                                                   DIAGSIG.612
      ELSE IF(FIELD(1:5).EQ.'CUVA ') THEN  ! PROFILERISH PLOT                    DIAGSIG.613
         VARNAM(1:8)='CUVA    '                                                  DIAGSIG.614
         CNT=AMAX1(CONT,1.)                                                      DIAGSIG.615
         NPASS=ISMTHR                                                            DIAGSIG.616
         ICRSDOT=0                                                               DIAGSIG.617
         KDIM='3D'                                                               DIAGSIG.618
         CALL READDAD(D31,'U AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.619
     *      .FALSE.,FOUND)                                                       DIAGSIG.620
         CALL READDAD(D32,'V AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.621
     *      .FALSE.,FOUND)                                                       DIAGSIG.622
         CALL READDAD(D21,'LONGIDOT',IMMHDR,I1,J1, 1,1,                          DIAGSIG.623
     *        .FALSE.,FOUND)                                                     DIAGSIG.624
         CALL MAP2MET(D31,D32,D21,I1,J1,K1,XLONC)                                DIAGSIG.625
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.626
            UNIT(1:8)='m/s     '                                                 DIAGSIG.627
            UNITS(1:8)='m/s     '                                                DIAGSIG.628
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.629
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.630
            CALL MPS2KT(D32, I1, J1, K1, 0)                                      DIAGSIG.631
            UNIT(1:8)='kt      '                                                 DIAGSIG.632
            UNITS(1:8)='kt      '                                                DIAGSIG.633
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.634
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.635
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.636
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.637
            UNITS(1:8)='cm/s    '                                                DIAGSIG.638
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.639
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.640
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.641
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.642
            UNITS(1:8)='mm/s    '                                                DIAGSIG.643
         ELSE                                                                    DIAGSIG.644
            UNIT(1:8)='m/s     '                                                 DIAGSIG.645
            UNITS(1:8)='m/s     '                                                DIAGSIG.646
         ENDIF                                                                   DIAGSIG.647
         CALL WRITDAD(D31,'U MET   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.648
         I3DSTART=I3DSTART+1                                                     DIAGSIG.649
         CALL WRITDAD(D32,'V MET   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.650
         I3DSTART=I3DSTART+1                                                     DIAGSIG.651
      ELSE IF(FIELD(1:4).EQ.'AMA ') THEN  ! ABSOLUTE MOMENTUM                    DIAGSIG.652
         VARNAM(1:8)='AMA     '                                                  DIAGSIG.653
         CNT=CONT                                                                DIAGSIG.654
         NPASS=ISMTHR                                                            DIAGSIG.655
         ICRSDOT=0                                                               DIAGSIG.656
         KDIM='3D'                                                               DIAGSIG.657
         CALL READDAD(D33,'U AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.658
     *      .FALSE.,FOUND)                                                       DIAGSIG.659
         CALL READDAD(D32,'V AGEO  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.660
     *      .FALSE.,FOUND)                                                       DIAGSIG.661
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.662
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.663
            UNIT(1:8)='m/s     '                                                 DIAGSIG.664
            UNITS(1:8)='m/s     '                                                DIAGSIG.665
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.666
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.667
            UNIT(1:8)='kt      '                                                 DIAGSIG.668
            UNITS(1:8)='kt      '                                                DIAGSIG.669
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.670
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.671
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.672
            UNITS(1:8)='cm/s    '                                                DIAGSIG.673
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.674
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.675
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.676
            UNITS(1:8)='mm/s    '                                                DIAGSIG.677
         ELSE                                                                    DIAGSIG.678
            UNIT(1:8)='m/s     '                                                 DIAGSIG.679
            UNITS(1:8)='m/s     '                                                DIAGSIG.680
         ENDIF                                                                   DIAGSIG.681
C                                                                                DIAGSIG.682
      ELSE IF((FIELD(1:7).EQ.'HEIGHT ') .or.                                     DIAGSIG.683
     *        (FIELD(1:2).EQ.'H '     )) THEN    ! HEIGHT                        DIAGSIG.684
         VARNAM(1:8)='HEIGHT  '                                                  DIAGSIG.685
         CNT=CONT                                                                DIAGSIG.686
         NPASS=ISMTHR                                                            DIAGSIG.687
         ICRSDOT=1                                                               DIAGSIG.688
         KDIM='3D'                                                               DIAGSIG.689
         IF (BHI(  1,1).EQ.5) THEN                                               DIAGSIG.690
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.691
     *      .FALSE.,FOUND)                                                       DIAGSIG.692
         ELSE IF (BHI(  1,1).EQ.11) THEN                                         DIAGSIG.693
            IF(IDRY.NE.1) THEN                                                   DIAGSIG.694
               CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                    DIAGSIG.695
     *            .FALSE.,FOUND)                                                 DIAGSIG.696
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGSIG.697
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGSIG.698
               CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                      DIAGSIG.699
     *               I3DSTART,0)                                                 DIAGSIG.700
               I3DSTART=I3DSTART+1                                               DIAGSIG.701
            END IF                                                               DIAGSIG.702
         END IF                                                                  DIAGSIG.703
         CALL READDAD(D22,'TERRAIN ',IMMHDR,I1,J1,1,1,                           DIAGSIG.704
     *      .FALSE.,FOUND)                                                       DIAGSIG.705
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.706
     *      .FALSE.,FOUND)                                                       DIAGSIG.707
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.708
     *      .FALSE.,FOUND)                                                       DIAGSIG.709
         IF(INHYD.NE.1) THEN                                                     DIAGSIG.710
            PRINT *, 'CALL HYDRO HEIGHT'                                         DIAGSIG.711
            CALL GEOPOT(D32,D33,D22,D21,IDRY,SIGMA,PTOP,I1,J1,K1,D31)            DIAGSIG.712
         ELSE                                                                    DIAGSIG.713
            PRINT *, 'CALL NONHYDRO HEIGHT'                                      DIAGSIG.714
            CALL NHGEOSIG(D21,SIGMA,PTOP,I1,J1,K1,D31)                           DIAGSIG.715
         ENDIF                                                                   DIAGSIG.716
         IF(UNIT(1:1).EQ.'m') THEN                                               DIAGSIG.717
            UNIT(1:8)='m       '                                                 DIAGSIG.718
            UNITS(1:8)='m       '                                                DIAGSIG.719
         ELSE IF(UNIT(1:2).EQ.'Dm') THEN                                         DIAGSIG.720
            CALL SCALE(D31,'DIV ',10.,I1,J1,K1,I1,J1,1)                          DIAGSIG.721
            UNIT(1:8)='Dm      '                                                 DIAGSIG.722
            UNITS(1:8)='Dm      '                                                DIAGSIG.723
         ELSE IF(UNIT(1:2).EQ.'cm') THEN                                         DIAGSIG.724
            CALL SCALE(D31,'MULT',100.,I1,J1,K1,I1,J1,1)                         DIAGSIG.725
            UNIT(1:8)='cm      '                                                 DIAGSIG.726
            UNITS(1:8)='cm      '                                                DIAGSIG.727
         ELSE                                                                    DIAGSIG.728
            UNIT(1:8)='m       '                                                 DIAGSIG.729
            UNITS(1:8)='m       '                                                DIAGSIG.730
         ENDIF                                                                   DIAGSIG.731
C                                                                                DIAGSIG.732
      ELSE IF(FIELD(1:4).EQ.'AGL '    ) THEN    ! ABOVE GROUND LEVEL             DIAGSIG.733
         VARNAM(1:8)='AGL     '                                                  DIAGSIG.734
         CNT=CONT                                                                DIAGSIG.735
         NPASS=ISMTHR                                                            DIAGSIG.736
         ICRSDOT=1                                                               DIAGSIG.737
         KDIM='3D'                                                               DIAGSIG.738
         IF (BHI(  1,1).EQ.5) THEN                                               DIAGSIG.739
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.740
     *      .FALSE.,FOUND)                                                       DIAGSIG.741
         ELSE IF (BHI(  1,1).EQ.11) THEN                                         DIAGSIG.742
            IF(IDRY.NE.1) THEN                                                   DIAGSIG.743
               CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                    DIAGSIG.744
     *            .FALSE.,FOUND)                                                 DIAGSIG.745
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGSIG.746
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGSIG.747
               CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                      DIAGSIG.748
     *               I3DSTART,0)                                                 DIAGSIG.749
               I3DSTART=I3DSTART+1                                               DIAGSIG.750
            END IF                                                               DIAGSIG.751
         END IF                                                                  DIAGSIG.752
         CALL READDAD(D22,'TERRAIN ',IMMHDR,I1,J1,1,1,                           DIAGSIG.753
     *      .FALSE.,FOUND)                                                       DIAGSIG.754
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.755
     *      .FALSE.,FOUND)                                                       DIAGSIG.756
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.757
     *      .FALSE.,FOUND)                                                       DIAGSIG.758
         if(inhyd.ne.1) then                                                     DIAGSIG.759
            CALL GEOPOT(D32,D33,D22,D21,IDRY,SIGMA,PTOP,I1,J1,K1,D31)            DIAGSIG.760
         else                                                                    DIAGSIG.761
            CALL nhgeosig(d21,sigma,ptop,i1,j1,k1,d31)                           DIAGSIG.762
         endif                                                                   DIAGSIG.763
         CALL d3md2(d31,d22,i1,j1,k1,icrsdot,d31)                                DIAGSIG.764
         IF(UNIT(1:1).EQ.'m') THEN                                               DIAGSIG.765
            UNIT(1:8)='m       '                                                 DIAGSIG.766
            UNITS(1:8)='m       '                                                DIAGSIG.767
         ELSE IF(UNIT(1:2).EQ.'Dm') THEN                                         DIAGSIG.768
            CALL SCALE(D31,'DIV ',10.,I1,J1,K1,I1,J1,1)                          DIAGSIG.769
            UNIT(1:8)='Dm      '                                                 DIAGSIG.770
            UNITS(1:8)='Dm      '                                                DIAGSIG.771
         ELSE IF(UNIT(1:2).EQ.'cm') THEN                                         DIAGSIG.772
            CALL SCALE(D31,'MULT',100.,I1,J1,K1,I1,J1,1)                         DIAGSIG.773
            UNIT(1:8)='cm      '                                                 DIAGSIG.774
            UNITS(1:8)='cm      '                                                DIAGSIG.775
         ELSE                                                                    DIAGSIG.776
            UNIT(1:8)='m       '                                                 DIAGSIG.777
            UNITS(1:8)='m       '                                                DIAGSIG.778
         ENDIF                                                                   DIAGSIG.779
C                                                                                DIAGSIG.780
      ELSE IF(FIELD(1:4).EQ.'AXW ') THEN    ! ALONG CROSS SECTION WINDS          DIAGSIG.781
         VARNAM(1:8)='AXW     '                                                  DIAGSIG.782
         CNT=CONT                                                                DIAGSIG.783
         NPASS=ISMTHR                                                            DIAGSIG.784
         ICRSDOT=0                                                               DIAGSIG.785
         KDIM='3D'                                                               DIAGSIG.786
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.787
     *      .FALSE.,FOUND)                                                       DIAGSIG.788
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.789
     *      .FALSE.,FOUND)                                                       DIAGSIG.790
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.791
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.792
            UNIT(1:8)='m/s     '                                                 DIAGSIG.793
            UNITS(1:8)='m/s     '                                                DIAGSIG.794
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.795
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.796
            UNIT(1:8)='kt      '                                                 DIAGSIG.797
            UNITS(1:8)='kt      '                                                DIAGSIG.798
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.799
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.800
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.801
            UNITS(1:8)='cm/s    '                                                DIAGSIG.802
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.803
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.804
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.805
            UNITS(1:8)='mm/s    '                                                DIAGSIG.806
         ELSE                                                                    DIAGSIG.807
            UNIT(1:8)='m/s     '                                                 DIAGSIG.808
            UNITS(1:8)='m/s     '                                                DIAGSIG.809
         ENDIF                                                                   DIAGSIG.810
      ELSE IF(FIELD(1:4).EQ.'XXW ') THEN  ! NORMAL CROSS SECTION WINDS           DIAGSIG.811
         VARNAM(1:8)='XXW     '                                                  DIAGSIG.812
         CNT=CONT                                                                DIAGSIG.813
         NPASS=ISMTHR                                                            DIAGSIG.814
         ICRSDOT=0                                                               DIAGSIG.815
         KDIM='3D'                                                               DIAGSIG.816
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.817
     *      .FALSE.,FOUND)                                                       DIAGSIG.818
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.819
     *      .FALSE.,FOUND)                                                       DIAGSIG.820
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.821
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.822
            UNIT(1:8)='m/s     '                                                 DIAGSIG.823
            UNITS(1:8)='m/s     '                                                DIAGSIG.824
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.825
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.826
            UNIT(1:8)='kt      '                                                 DIAGSIG.827
            UNITS(1:8)='kt      '                                                DIAGSIG.828
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.829
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.830
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.831
            UNITS(1:8)='cm/s    '                                                DIAGSIG.832
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.833
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.834
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.835
            UNITS(1:8)='mm/s    '                                                DIAGSIG.836
         ELSE                                                                    DIAGSIG.837
            UNIT(1:8)='m/s     '                                                 DIAGSIG.838
            UNITS(1:8)='m/s     '                                                DIAGSIG.839
         ENDIF                                                                   DIAGSIG.840
      ELSE IF(FIELD(1:4).EQ.'CXW ') THEN  ! CROSS SECTION CIRCULATION            DIAGSIG.841
         VARNAM(1:8)='CXW     '                                                  DIAGSIG.842
         CNT=AMAX1(CONT,1.)                                                      DIAGSIG.843
         NPASS=ISMTHR                                                            DIAGSIG.844
         ICRSDOT=0                                                               DIAGSIG.845
         KDIM='3D'                                                               DIAGSIG.846
         CALL READDAD(D32,'W       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.847
     *      diags,FOUND)                                                         DIAGSIG.848
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.849
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.850
            IERROR=1                                                             DIAGSIG.851
            RETURN                                                               DIAGSIG.852
         END IF                                                                  DIAGSIG.853
         CALL WRITDAD(D32,'OMG*CXW ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.854
         CALL READDAD(D32,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.855
     *      .FALSE.,FOUND)                                                       DIAGSIG.856
         CALL READDAD(D33,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.857
     *      .FALSE.,FOUND)                                                       DIAGSIG.858
         CALL CRSWINDS(D32,D33,I1,J1,K1,FIELD,D31)                               DIAGSIG.859
         FIELD(1:4)='BARB'                                                       DIAGSIG.860
         CALL READDAD(D32,'W       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.861
     *      .FALSE.,FOUND)                                                       DIAGSIG.862
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.863
            UNIT(1:8)='m/s     '                                                 DIAGSIG.864
            UNITS(1:8)='m/s     '                                                DIAGSIG.865
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.866
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.867
            CALL MPS2KT(D32, I1, J1, K1, 0)                                      DIAGSIG.868
            UNIT(1:8)='kt      '                                                 DIAGSIG.869
            UNITS(1:8)='kt      '                                                DIAGSIG.870
         ELSE                                                                    DIAGSIG.871
            UNIT(1:8)='m/s     '                                                 DIAGSIG.872
            UNITS(1:8)='m/s     '                                                DIAGSIG.873
         ENDIF                                                                   DIAGSIG.874
      ELSE IF(FIELD(1:4).EQ.'CUV ') THEN  ! PROFILERISH PLOT                     DIAGSIG.875
         VARNAM(1:8)='CUV     '                                                  DIAGSIG.876
         CNT=AMAX1(CONT,1.)                                                      DIAGSIG.877
         NPASS=ISMTHR                                                            DIAGSIG.878
         ICRSDOT=0                                                               DIAGSIG.879
         KDIM='3D'                                                               DIAGSIG.880
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.881
     *      .FALSE.,FOUND)                                                       DIAGSIG.882
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.883
     *      .FALSE.,FOUND)                                                       DIAGSIG.884
         CALL READDAD(D21,'LONGIDOT',IMMHDR,I1,J1, 1,1,                          DIAGSIG.885
     *        .FALSE.,FOUND)                                                     DIAGSIG.886
         CALL MAP2MET(D31,D32,D21,I1,J1,K1,XLONC)                                DIAGSIG.887
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.888
            UNIT(1:8)='m/s     '                                                 DIAGSIG.889
            UNITS(1:8)='m/s     '                                                DIAGSIG.890
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.891
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.892
            CALL MPS2KT(D32, I1, J1, K1, 0)                                      DIAGSIG.893
            UNIT(1:8)='kt      '                                                 DIAGSIG.894
            UNITS(1:8)='kt      '                                                DIAGSIG.895
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.896
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.897
            CALL SCALE(D32,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.898
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.899
            UNITS(1:8)='cm/s    '                                                DIAGSIG.900
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.901
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.902
            CALL SCALE(D32,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.903
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.904
            UNITS(1:8)='mm/s    '                                                DIAGSIG.905
         ELSE                                                                    DIAGSIG.906
            UNIT(1:8)='m/s     '                                                 DIAGSIG.907
            UNITS(1:8)='m/s     '                                                DIAGSIG.908
         ENDIF                                                                   DIAGSIG.909
         CALL WRITDAD(D31,'U MET   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.910
         I3DSTART=I3DSTART+1                                                     DIAGSIG.911
         CALL WRITDAD(D32,'V MET   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.912
         I3DSTART=I3DSTART+1                                                     DIAGSIG.913
      ELSE IF(FIELD(1:3).EQ.'AM ') THEN  ! ABSOLUTE MOMENTUM                     DIAGSIG.914
         VARNAM(1:8)='AM      '                                                  DIAGSIG.915
         CNT=CONT                                                                DIAGSIG.916
         NPASS=ISMTHR                                                            DIAGSIG.917
         ICRSDOT=0                                                               DIAGSIG.918
         KDIM='3D'                                                               DIAGSIG.919
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.920
     *      .FALSE.,FOUND)                                                       DIAGSIG.921
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.922
     *      .FALSE.,FOUND)                                                       DIAGSIG.923
         CALL CRSWINDS(D33,D32,I1,J1,K1,FIELD,D31)                               DIAGSIG.924
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.925
            UNIT(1:8)='m/s     '                                                 DIAGSIG.926
            UNITS(1:8)='m/s     '                                                DIAGSIG.927
         ELSE IF (UNIT(1:2).EQ.'kt') THEN                                        DIAGSIG.928
            CALL MPS2KT(D31, I1, J1, K1, 0)                                      DIAGSIG.929
            UNIT(1:8)='kt      '                                                 DIAGSIG.930
            UNITS(1:8)='kt      '                                                DIAGSIG.931
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.932
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.933
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.934
            UNITS(1:8)='cm/s    '                                                DIAGSIG.935
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.936
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.937
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.938
            UNITS(1:8)='mm/s    '                                                DIAGSIG.939
         ELSE                                                                    DIAGSIG.940
            UNIT(1:8)='m/s     '                                                 DIAGSIG.941
            UNITS(1:8)='m/s     '                                                DIAGSIG.942
         ENDIF                                                                   DIAGSIG.943
C                                                                                DIAGSIG.944
      ELSE IF(FIELD(1:5).EQ.'FIELD'    ) THEN    ! CLOUD WATER                   DIAGSIG.945
         VARNAM(1:6)=FIELD(1:6)                                                  DIAGSIG.946
         VARNAM(7:8)='  '                                                        DIAGSIG.947
         CNT=CONT                                                                DIAGSIG.948
         NPASS=ISMTHR                                                            DIAGSIG.949
         ICRSDOT=1                                                               DIAGSIG.950
         KDIM='3D'                                                               DIAGSIG.951
         CALL READDAD(D31,VARNAM(1:8),IDAD3D,I1,J1,K1,0,                         DIAGSIG.952
     *      DIAGS,FOUND)                                                         DIAGSIG.953
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.954
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.955
            IERROR=1                                                             DIAGSIG.956
            RETURN                                                               DIAGSIG.957
         END IF                                                                  DIAGSIG.958
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.959
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.960
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.961
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.962
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.963
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.964
            UNITS(1:8)='g/kg    '                                                DIAGSIG.965
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.966
            UNIT(1:8)='g/g     '                                                 DIAGSIG.967
            UNITS(1:8)='g/g     '                                                DIAGSIG.968
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGSIG.969
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.970
            UNIT(1:8)='mg/kg   '                                                 DIAGSIG.971
            UNITS(1:8)='mg/kg   '                                                DIAGSIG.972
         ELSE                                                                    DIAGSIG.973
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.974
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.975
         END IF                                                                  DIAGSIG.976
C                                                                                DIAGSIG.977
      ELSE IF(FIELD(1:4).EQ.'CLW '    ) THEN    ! CLOUD WATER                    DIAGSIG.978
         VARNAM(1:8)='CL WATER'                                                  DIAGSIG.979
         CNT=CONT                                                                DIAGSIG.980
         NPASS=ISMTHR                                                            DIAGSIG.981
         ICRSDOT=1                                                               DIAGSIG.982
         KDIM='3D'                                                               DIAGSIG.983
         CALL READDAD(D31,'CLW     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.984
     *      DIAGS,FOUND)                                                         DIAGSIG.985
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.986
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.987
            IERROR=1                                                             DIAGSIG.988
            RETURN                                                               DIAGSIG.989
         END IF                                                                  DIAGSIG.990
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.991
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.992
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.993
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.994
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.995
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.996
            UNITS(1:8)='g/kg    '                                                DIAGSIG.997
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.998
            UNIT(1:8)='g/g     '                                                 DIAGSIG.999
            UNITS(1:8)='g/g     '                                                DIAGSIG.1000
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGSIG.1001
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.1002
            UNIT(1:8)='mg/kg   '                                                 DIAGSIG.1003
            UNITS(1:8)='mg/kg   '                                                DIAGSIG.1004
         ELSE                                                                    DIAGSIG.1005
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1006
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1007
         END IF                                                                  DIAGSIG.1008
C                                                                                DIAGSIG.1009
      ELSE IF(FIELD(1:5).EQ.'SNOW '    ) THEN    ! SNOW                          DIAGSIG.1010
         VARNAM(1:8)='SNOW    '                                                  DIAGSIG.1011
         CNT=CONT                                                                DIAGSIG.1012
         NPASS=ISMTHR                                                            DIAGSIG.1013
         ICRSDOT=1                                                               DIAGSIG.1014
         KDIM='3D'                                                               DIAGSIG.1015
         CALL READDAD(D31,'SNOW    ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1016
     *      DIAGS,FOUND)                                                         DIAGSIG.1017
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1018
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1019
            IERROR=1                                                             DIAGSIG.1020
            RETURN                                                               DIAGSIG.1021
         END IF                                                                  DIAGSIG.1022
         CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGSIG.1023
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.1024
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1025
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1026
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.1027
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1028
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.1029
            UNITS(1:8)='g/kg    '                                                DIAGSIG.1030
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.1031
            UNIT(1:8)='g/g     '                                                 DIAGSIG.1032
            UNITS(1:8)='g/g     '                                                DIAGSIG.1033
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGSIG.1034
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.1035
            UNIT(1:8)='mg/kg   '                                                 DIAGSIG.1036
            UNITS(1:8)='mg/kg   '                                                DIAGSIG.1037
         ELSE                                                                    DIAGSIG.1038
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1039
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1040
         END IF                                                                  DIAGSIG.1041
C                                                                                DIAGSIG.1042
      ELSE IF(FIELD(1:4).EQ.'ICE  '    ) THEN    ! CLOUD ICE                     DIAGSIG.1043
         VARNAM(1:8)='CLD ICE '                                                  DIAGSIG.1044
         CNT=CONT                                                                DIAGSIG.1045
         NPASS=ISMTHR                                                            DIAGSIG.1046
         ICRSDOT=1                                                               DIAGSIG.1047
         KDIM='3D'                                                               DIAGSIG.1048
         CALL READDAD(D31,'ICE     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1049
     *      DIAGS,FOUND)                                                         DIAGSIG.1050
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1051
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1052
            IERROR=1                                                             DIAGSIG.1053
            RETURN                                                               DIAGSIG.1054
         END IF                                                                  DIAGSIG.1055
         CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGSIG.1056
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.1057
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1058
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1059
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.1060
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1061
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.1062
            UNITS(1:8)='g/kg    '                                                DIAGSIG.1063
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.1064
            UNIT(1:8)='g/g     '                                                 DIAGSIG.1065
            UNITS(1:8)='g/g     '                                                DIAGSIG.1066
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGSIG.1067
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.1068
            UNIT(1:8)='mg/kg   '                                                 DIAGSIG.1069
            UNITS(1:8)='mg/kg   '                                                DIAGSIG.1070
         ELSE                                                                    DIAGSIG.1071
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1072
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1073
         END IF                                                                  DIAGSIG.1074
C                                                                                DIAGSIG.1075
      ELSE IF(FIELD(1:5).EQ.'NCI  '    ) THEN    ! NUMBER CONCENTRATION OF ICE   DIAGSIG.1076
         VARNAM(1:8)='NO. CONC'                                                  DIAGSIG.1077
         CNT=CONT                                                                DIAGSIG.1078
         NPASS=ISMTHR                                                            DIAGSIG.1079
         ICRSDOT=1                                                               DIAGSIG.1080
         KDIM='3D'                                                               DIAGSIG.1081
         CALL READDAD(D31,'NCI     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1082
     *      DIAGS,FOUND)                                                         DIAGSIG.1083
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1084
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1085
            IERROR=1                                                             DIAGSIG.1086
            RETURN                                                               DIAGSIG.1087
         END IF                                                                  DIAGSIG.1088
         CALL SCALE(D31,'ADD ',0.0001,I1,J1,K1,I1,J1,1)                          DIAGSIG.1089
         IF(UNIT(1:6).EQ.'no/m^3') THEN                                          DIAGSIG.1090
            UNIT(1:8)='no/m^3  '                                                 DIAGSIG.1091
            UNITS(1:8)='no/m^3  '                                                DIAGSIG.1092
         ELSE IF(UNIT(1:6).EQ.'no/l^3') THEN                                     DIAGSIG.1093
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1094
            UNIT(1:8)='no/l^3  '                                                 DIAGSIG.1095
            UNITS(1:8)='no/l^3  '                                                DIAGSIG.1096
         ELSE IF(UNIT(1:6).EQ.'no/L^3') THEN                                     DIAGSIG.1097
            UNIT(1:8)='no/L^3  '                                                 DIAGSIG.1098
            UNITS(1:8)='no/L^3  '                                                DIAGSIG.1099
         ELSE IF(UNIT(1:7).EQ.'no/cm^3') THEN                                    DIAGSIG.1100
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.1101
            UNIT(1:8)='no/cm^3 '                                                 DIAGSIG.1102
            UNITS(1:8)='no/cm^3 '                                                DIAGSIG.1103
         END IF                                                                  DIAGSIG.1104
C                                                                                DIAGSIG.1105
      ELSE IF(FIELD(1:5).EQ.'GRA  '                                              DIAGSIG.1106
     *   .OR. FIELD(1:8).EQ.'GRAUPEL ') THEN     ! NUMBER CONCENTRATION OF ICE   DIAGSIG.1107
         VARNAM(1:8)='GRAUPEL '                                                  DIAGSIG.1108
         CNT=CONT                                                                DIAGSIG.1109
         NPASS=ISMTHR                                                            DIAGSIG.1110
         ICRSDOT=1                                                               DIAGSIG.1111
         KDIM='3D'                                                               DIAGSIG.1112
         CALL READDAD(D31,'GRAUPEL ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1113
     *      DIAGS,FOUND)                                                         DIAGSIG.1114
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1115
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1116
            IERROR=1                                                             DIAGSIG.1117
            RETURN                                                               DIAGSIG.1118
         END IF                                                                  DIAGSIG.1119
         CALL SCALE(D31,'ADD ',0.00000001,I1,J1,K1,I1,J1,1)                      DIAGSIG.1120
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.1121
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1122
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1123
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.1124
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1125
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.1126
            UNITS(1:8)='g/kg    '                                                DIAGSIG.1127
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.1128
            UNIT(1:8)='g/g     '                                                 DIAGSIG.1129
            UNITS(1:8)='g/g     '                                                DIAGSIG.1130
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGSIG.1131
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.1132
            UNIT(1:8)='mg/kg   '                                                 DIAGSIG.1133
            UNITS(1:8)='mg/kg   '                                                DIAGSIG.1134
         ELSE                                                                    DIAGSIG.1135
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1136
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1137
         END IF                                                                  DIAGSIG.1138
C                                                                                DIAGSIG.1139
      ELSE IF(FIELD(1:4).EQ.'SLW '    ) THEN    ! SUPER COOLED LIQ WATER         DIAGSIG.1140
         VARNAM(1:8)='SLW     '                                                  DIAGSIG.1141
         CNT=CONT                                                                DIAGSIG.1142
         NPASS=ISMTHR                                                            DIAGSIG.1143
         ICRSDOT=1                                                               DIAGSIG.1144
         KDIM='3D'                                                               DIAGSIG.1145
         CALL READDAD(D33,'CLW     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1146
     *      DIAGS,FOUND)                                                         DIAGSIG.1147
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1148
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1149
            IERROR=1                                                             DIAGSIG.1150
            RETURN                                                               DIAGSIG.1151
         END IF                                                                  DIAGSIG.1152
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1153
     *      .FALSE.,FOUND)                                                       DIAGSIG.1154
         twarm=273.15                                                            DIAGSIG.1155
         tcold=twarm-75.                                                         DIAGSIG.1156
         CALL SLW(D33,D32,i1,j1,k1,twarm,tcold,d31)                              DIAGSIG.1157
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.1158
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1159
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1160
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.1161
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1162
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.1163
            UNITS(1:8)='g/kg    '                                                DIAGSIG.1164
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.1165
            UNIT(1:8)='g/g     '                                                 DIAGSIG.1166
            UNITS(1:8)='g/g     '                                                DIAGSIG.1167
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGSIG.1168
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.1169
            UNIT(1:8)='mg/kg   '                                                 DIAGSIG.1170
            UNITS(1:8)='mg/kg   '                                                DIAGSIG.1171
         ELSE                                                                    DIAGSIG.1172
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1173
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1174
         END IF                                                                  DIAGSIG.1175
C                                                                                DIAGSIG.1176
      ELSE IF(FIELD(1:4).EQ.'CLB  '    ) THEN    ! CLOUD BOUNDARY                DIAGSIG.1177
         VARNAM(1:8)='CLD BDY '                                                  DIAGSIG.1178
         CNT=CONT                                                                DIAGSIG.1179
         NPASS=ISMTHR                                                            DIAGSIG.1180
         ICRSDOT=1                                                               DIAGSIG.1181
         KDIM='3D'                                                               DIAGSIG.1182
         CALL READDAD(D33,'ICEW    ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1183
     *      DIAGS,FOUND)                                                         DIAGSIG.1184
         IF(.NOT.FOUND) CALL CLEAR(d33,i1,j1,k1)                                 DIAGSIG.1185
         CALL READDAD(D32,'SNOWW   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1186
     *      DIAGS,FOUND)                                                         DIAGSIG.1187
         IF(.NOT.FOUND) CALL CLEAR(d32,i1,j1,k1)                                 DIAGSIG.1188
         call sum(d32,d33,i1,j1,k1,1,d32)                                        DIAGSIG.1189
         CALL READDAD(D33,'CLW     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1190
     *      DIAGS,FOUND)                                                         DIAGSIG.1191
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1192
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1193
            IERROR=1                                                             DIAGSIG.1194
            RETURN                                                               DIAGSIG.1195
         END IF                                                                  DIAGSIG.1196
         CALL READDAD(D31,'RNW     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1197
     *      DIAGS,FOUND)                                                         DIAGSIG.1198
         call sum(d31,d33,i1,j1,k1,1,d33)                                        DIAGSIG.1199
         call cloudbdy(d32,d33,i1,j1,k1,d31,cnt)                                 DIAGSIG.1200
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.1201
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1202
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1203
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.1204
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1205
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.1206
            UNITS(1:8)='g/kg    '                                                DIAGSIG.1207
            cnt=cnt*1.e3                                                         DIAGSIG.1208
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.1209
            UNIT(1:8)='g/g     '                                                 DIAGSIG.1210
            UNITS(1:8)='g/g     '                                                DIAGSIG.1211
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGSIG.1212
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.1213
            UNIT(1:8)='mg/kg   '                                                 DIAGSIG.1214
            UNITS(1:8)='mg/kg   '                                                DIAGSIG.1215
            cnt=cnt*1.e6                                                         DIAGSIG.1216
         ELSE                                                                    DIAGSIG.1217
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.1218
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.1219
         END IF                                                                  DIAGSIG.1220
C                                                                                DIAGSIG.1221
      ELSE IF(FIELD(1:4).EQ.'DIV ') THEN    ! DIVERGENCE                         DIAGSIG.1222
        VARNAM(1:8) = 'DIVERG  '                                                 DIAGSIG.1223
        CNT=CONT                                                                 DIAGSIG.1224
        NPASS=ISMTHR                                                             DIAGSIG.1225
        ICRSDOT=1                                                                DIAGSIG.1226
        KDIM='3D'                                                                DIAGSIG.1227
        CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                           DIAGSIG.1228
     *        .FALSE.,FOUND)                                                     DIAGSIG.1229
        CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                           DIAGSIG.1230
     *        .FALSE.,FOUND)                                                     DIAGSIG.1231
        CALL READDAD(D21,'MAPFACDT',IMMHDR,I1,J1, 1,1,                           DIAGSIG.1232
     *        .FALSE.,FOUND)                                                     DIAGSIG.1233
        CALL READDAD(D22,'MAPFACCR',IMMHDR,I1,J1, 1,1,                           DIAGSIG.1234
     *        .FALSE.,FOUND)                                                     DIAGSIG.1235
        CALL DIVERG(D33,D32,D21,D22,I1,J1,K1,DS,D31)                             DIAGSIG.1236
C       CALL WRITDAD(D31,'DIVERG  ',IDAD3D,I1,J1,K1,I3DSTART,0)                  DIAGSIG.1237
C       I3DSTART=I3DSTART+1                                                      DIAGSIG.1238
        IF(UNIT(1:3).EQ.'1/s') THEN                                              DIAGSIG.1239
           UNIT(1:8)='1/s     '                                                  DIAGSIG.1240
           UNITS(1:8)='1/s     '                                                 DIAGSIG.1241
        ELSE IF(UNIT(1:7).EQ.'10**5/s') THEN                                     DIAGSIG.1242
           CALL SCALE(D31,'MULT',100000.,I1,J1,K1,I1,J1,1)                       DIAGSIG.1243
           UNIT(1:8)='10**5/s '                                                  DIAGSIG.1244
           UNITS(1:8)='10**5/s '                                                 DIAGSIG.1245
        ELSE                                                                     DIAGSIG.1246
           UNIT(1:8)='1/s     '                                                  DIAGSIG.1247
           UNITS(1:8)='1/s     '                                                 DIAGSIG.1248
        ENDIF                                                                    DIAGSIG.1249
C                                                                                DIAGSIG.1250
      ELSE IF(FIELD(1:2).EQ.'H '    ) THEN    ! STRAIGHT HEIGHT                  DIAGSIG.1251
         VARNAM(1:8)='H       '                                                  DIAGSIG.1252
         CNT=CONT                                                                DIAGSIG.1253
         NPASS=ISMTHR                                                            DIAGSIG.1254
         ICRSDOT=1                                                               DIAGSIG.1255
         KDIM='3D'                                                               DIAGSIG.1256
         CALL READDAD(D32,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1257
     *   diags,FOUND)                                                            DIAGSIG.1258
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1259
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1260
            IERROR=1                                                             DIAGSIG.1261
            RETURN                                                               DIAGSIG.1262
         END IF                                                                  DIAGSIG.1263
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1264
     *   .false.,FOUND)                                                          DIAGSIG.1265
         call nhgeosig(d21,sigma,ptop,i1,j1,k1,d31)                              DIAGSIG.1266
         IF(UNIT(1:1).EQ.'m') THEN                                               DIAGSIG.1267
            UNIT(1:8)='m       '                                                 DIAGSIG.1268
            UNITS(1:8)='m       '                                                DIAGSIG.1269
         ELSE                                                                    DIAGSIG.1270
            UNIT(1:8)='m       '                                                 DIAGSIG.1271
            UNITS(1:8)='m       '                                                DIAGSIG.1272
         ENDIF                                                                   DIAGSIG.1273
C                                                                                DIAGSIG.1274
      ELSE IF(FIELD(1:5).EQ.'ICLW '    ) THEN ! INTEGRATED CLOUD WATER           DIAGSIG.1275
         VARNAM(1:8)='INTG CLW'                                                  DIAGSIG.1276
         CNT=CONT                                                                DIAGSIG.1277
         NPASS=ISMTHR                                                            DIAGSIG.1278
         ICRSDOT=1                                                               DIAGSIG.1279
         KDIM='2D'                                                               DIAGSIG.1280
         IF (INHYD.EQ.1) THEN                                                    DIAGSIG.1281
           CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                        DIAGSIG.1282
     *     DIAGS,FOUND)                                                          DIAGSIG.1283
           IF(.NOT.FOUND) THEN                                                   DIAGSIG.1284
             PRINT *,'FIELD PP NOT FOUND'                                        DIAGSIG.1285
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                       DIAGSIG.1286
             IERROR=1                                                            DIAGSIG.1287
             RETURN                                                              DIAGSIG.1288
           ENDIF                                                                 DIAGSIG.1289
         ELSE                                                                    DIAGSIG.1290
           CALL CLEAR(D33,I1,J1,K1)                                              DIAGSIG.1291
         END IF                                                                  DIAGSIG.1292
           CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                        DIAGSIG.1293
     *     .FALSE.,FOUND)                                                        DIAGSIG.1294
         CALL READDAD(D32,'CLW     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1295
     *      DIAGS,FOUND)                                                         DIAGSIG.1296
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1297
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1298
            IERROR=1                                                             DIAGSIG.1299
            RETURN                                                               DIAGSIG.1300
         END IF                                                                  DIAGSIG.1301
      CALL INTEGRAT(D32,D33,D21,I1,J1,K1,SIGMA,PTOP,ICRSDOT,D31)                 DIAGSIG.1302
         CALL WRITDAD(D31,'INTG CLW',IDAD2D,I1,J1, 1,I2DSTART,0)                 DIAGSIG.1303
         I2DSTART=I2DSTART+1                                                     DIAGSIG.1304
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.1305
            UNIT(1:8)='cm      '                                                 DIAGSIG.1306
            UNITS(1:8)='cm      '                                                DIAGSIG.1307
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.1308
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.1309
            UNIT(1:8)='mm      '                                                 DIAGSIG.1310
            UNITS(1:8)='mm      '                                                DIAGSIG.1311
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.1312
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.1313
            UNIT(1:8)='in      '                                                 DIAGSIG.1314
            UNITS(1:8)='in      '                                                DIAGSIG.1315
         ELSE                                                                    DIAGSIG.1316
            UNIT(1:8)='cm      '                                                 DIAGSIG.1317
            UNITS(1:8)='cm      '                                                DIAGSIG.1318
         END IF                                                                  DIAGSIG.1319
C                                                                                DIAGSIG.1320
      ELSE IF(FIELD(1:5).EQ.'IRNW '    ) THEN ! INTEGRATED RAIN WATER            DIAGSIG.1321
         VARNAM(1:8)='INTG RNW'                                                  DIAGSIG.1322
         CNT=CONT                                                                DIAGSIG.1323
         NPASS=ISMTHR                                                            DIAGSIG.1324
         ICRSDOT=1                                                               DIAGSIG.1325
         KDIM='2D'                                                               DIAGSIG.1326
         IF (INHYD.EQ.1) THEN                                                    DIAGSIG.1327
           CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                        DIAGSIG.1328
     *     DIAGS,FOUND)                                                          DIAGSIG.1329
           IF(.NOT.FOUND) THEN                                                   DIAGSIG.1330
             PRINT *,'FIELD PP NOT FOUND'                                        DIAGSIG.1331
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                       DIAGSIG.1332
             IERROR=1                                                            DIAGSIG.1333
             RETURN                                                              DIAGSIG.1334
           ENDIF                                                                 DIAGSIG.1335
         ELSE                                                                    DIAGSIG.1336
           CALL CLEAR(D33,I1,J1,K1)                                              DIAGSIG.1337
         END IF                                                                  DIAGSIG.1338
           CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                        DIAGSIG.1339
     *     .FALSE.,FOUND)                                                        DIAGSIG.1340
         CALL READDAD(D32,'RNW     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1341
     *      DIAGS,FOUND)                                                         DIAGSIG.1342
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1343
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1344
            IERROR=1                                                             DIAGSIG.1345
            RETURN                                                               DIAGSIG.1346
         END IF                                                                  DIAGSIG.1347
      CALL INTEGRAT(D32,D33,D21,I1,J1,K1,SIGMA,PTOP,ICRSDOT,D31)                 DIAGSIG.1348
         CALL WRITDAD(D31,'INTG RNW',IDAD2D,I1,J1, 1,I2DSTART,0)                 DIAGSIG.1349
         I2DSTART=I2DSTART+1                                                     DIAGSIG.1350
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.1351
            UNIT(1:8)='cm      '                                                 DIAGSIG.1352
            UNITS(1:8)='cm      '                                                DIAGSIG.1353
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.1354
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.1355
            UNIT(1:8)='mm      '                                                 DIAGSIG.1356
            UNITS(1:8)='mm      '                                                DIAGSIG.1357
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.1358
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.1359
            UNIT(1:8)='in      '                                                 DIAGSIG.1360
            UNITS(1:8)='in      '                                                DIAGSIG.1361
         ELSE                                                                    DIAGSIG.1362
            UNIT(1:8)='cm      '                                                 DIAGSIG.1363
            UNITS(1:8)='cm      '                                                DIAGSIG.1364
         END IF                                                                  DIAGSIG.1365
C                                                                                DIAGSIG.1366
      ELSE IF(FIELD(1:5).EQ.'IICE '    ) THEN ! INTEGRATED CLOUD ICE             06NOV00.7
         VARNAM(1:8)='INTG ICE'                                                  DIAGSIG.1368
         CNT=CONT                                                                DIAGSIG.1369
         NPASS=ISMTHR                                                            DIAGSIG.1370
         ICRSDOT=1                                                               DIAGSIG.1371
         KDIM='2D'                                                               DIAGSIG.1372
         IF (INHYD.EQ.1) THEN                                                    DIAGSIG.1373
           CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                        DIAGSIG.1374
     *     DIAGS,FOUND)                                                          DIAGSIG.1375
           IF(.NOT.FOUND) THEN                                                   DIAGSIG.1376
             PRINT *,'FIELD PP NOT FOUND'                                        DIAGSIG.1377
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                       DIAGSIG.1378
             IERROR=1                                                            DIAGSIG.1379
             RETURN                                                              DIAGSIG.1380
           ENDIF                                                                 DIAGSIG.1381
         ELSE                                                                    DIAGSIG.1382
           CALL CLEAR(D33,I1,J1,K1)                                              DIAGSIG.1383
         END IF                                                                  DIAGSIG.1384
           CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                        DIAGSIG.1385
     *     .FALSE.,FOUND)                                                        DIAGSIG.1386
         CALL READDAD(D32,'ICE     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1387
     *      DIAGS,FOUND)                                                         DIAGSIG.1388
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1389
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1390
            IERROR=1                                                             DIAGSIG.1391
            RETURN                                                               DIAGSIG.1392
         END IF                                                                  DIAGSIG.1393
      CALL INTEGRAT(D32,D33,D21,I1,J1,K1,SIGMA,PTOP,ICRSDOT,D31)                 DIAGSIG.1394
         CALL WRITDAD(D31,'INTG ICE',IDAD2D,I1,J1, 1,I2DSTART,0)                 DIAGSIG.1395
         I2DSTART=I2DSTART+1                                                     DIAGSIG.1396
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.1397
            UNIT(1:8)='cm      '                                                 DIAGSIG.1398
            UNITS(1:8)='cm      '                                                DIAGSIG.1399
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.1400
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.1401
            UNIT(1:8)='mm      '                                                 DIAGSIG.1402
            UNITS(1:8)='mm      '                                                DIAGSIG.1403
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.1404
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.1405
            UNIT(1:8)='in      '                                                 DIAGSIG.1406
            UNITS(1:8)='in      '                                                DIAGSIG.1407
         ELSE                                                                    DIAGSIG.1408
            UNIT(1:8)='cm      '                                                 DIAGSIG.1409
            UNITS(1:8)='cm      '                                                DIAGSIG.1410
         END IF                                                                  DIAGSIG.1411
C                                                                                DIAGSIG.1412
      ELSE IF(FIELD(1:5).EQ.'ISNOW'    ) THEN ! INTEGRATED SNOW                  06NOV00.8
         VARNAM(1:8)='INTG SNW'                                                  DIAGSIG.1414
         CNT=CONT                                                                DIAGSIG.1415
         NPASS=ISMTHR                                                            DIAGSIG.1416
         ICRSDOT=1                                                               DIAGSIG.1417
         KDIM='2D'                                                               DIAGSIG.1418
         IF (INHYD.EQ.1) THEN                                                    DIAGSIG.1419
           CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                        DIAGSIG.1420
     *     DIAGS,FOUND)                                                          DIAGSIG.1421
           IF(.NOT.FOUND) THEN                                                   DIAGSIG.1422
             PRINT *,'FIELD PP NOT FOUND'                                        DIAGSIG.1423
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                       DIAGSIG.1424
             IERROR=1                                                            DIAGSIG.1425
             RETURN                                                              DIAGSIG.1426
           ENDIF                                                                 DIAGSIG.1427
         ELSE                                                                    DIAGSIG.1428
           CALL CLEAR(D33,I1,J1,K1)                                              DIAGSIG.1429
         END IF                                                                  DIAGSIG.1430
           CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                        DIAGSIG.1431
     *     .FALSE.,FOUND)                                                        DIAGSIG.1432
         CALL READDAD(D32,'SNOW    ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1433
     *      DIAGS,FOUND)                                                         DIAGSIG.1434
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1435
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1436
            IERROR=1                                                             DIAGSIG.1437
            RETURN                                                               DIAGSIG.1438
         END IF                                                                  DIAGSIG.1439
      CALL INTEGRAT(D32,D33,D21,I1,J1,K1,SIGMA,PTOP,ICRSDOT,D31)                 DIAGSIG.1440
         CALL WRITDAD(D31,'INTG SNW',IDAD2D,I1,J1, 1,I2DSTART,0)                 DIAGSIG.1441
         I2DSTART=I2DSTART+1                                                     DIAGSIG.1442
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.1443
            UNIT(1:8)='cm      '                                                 DIAGSIG.1444
            UNITS(1:8)='cm      '                                                DIAGSIG.1445
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.1446
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.1447
            UNIT(1:8)='mm      '                                                 DIAGSIG.1448
            UNITS(1:8)='mm      '                                                DIAGSIG.1449
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.1450
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.1451
            UNIT(1:8)='in      '                                                 DIAGSIG.1452
            UNITS(1:8)='in      '                                                DIAGSIG.1453
         ELSE                                                                    DIAGSIG.1454
            UNIT(1:8)='cm      '                                                 DIAGSIG.1455
            UNITS(1:8)='cm      '                                                DIAGSIG.1456
         END IF                                                                  DIAGSIG.1457
C                                                                                DIAGSIG.1458
      ELSE IF(FIELD(1:5).EQ.'IGRA '    ) THEN ! INTEGRATED GRAUPEL               06NOV00.9
         VARNAM(1:8)='INTG GRA'                                                  DIAGSIG.1460
         CNT=CONT                                                                DIAGSIG.1461
         NPASS=ISMTHR                                                            DIAGSIG.1462
         ICRSDOT=1                                                               DIAGSIG.1463
         KDIM='2D'                                                               DIAGSIG.1464
         IF (INHYD.EQ.1) THEN                                                    DIAGSIG.1465
           CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                        DIAGSIG.1466
     *     DIAGS,FOUND)                                                          DIAGSIG.1467
           IF(.NOT.FOUND) THEN                                                   DIAGSIG.1468
             PRINT *,'FIELD PP NOT FOUND'                                        DIAGSIG.1469
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                       DIAGSIG.1470
             IERROR=1                                                            DIAGSIG.1471
             RETURN                                                              DIAGSIG.1472
           ENDIF                                                                 DIAGSIG.1473
         ELSE                                                                    DIAGSIG.1474
           CALL CLEAR(D33,I1,J1,K1)                                              DIAGSIG.1475
         END IF                                                                  DIAGSIG.1476
           CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                        DIAGSIG.1477
     *     .FALSE.,FOUND)                                                        DIAGSIG.1478
         CALL READDAD(D32,'GRAUPEL ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1479
     *      DIAGS,FOUND)                                                         DIAGSIG.1480
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1481
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1482
            IERROR=1                                                             DIAGSIG.1483
            RETURN                                                               DIAGSIG.1484
         END IF                                                                  DIAGSIG.1485
      CALL INTEGRAT(D32,D33,D21,I1,J1,K1,SIGMA,PTOP,ICRSDOT,D31)                 DIAGSIG.1486
         CALL WRITDAD(D31,'INTG GRA',IDAD2D,I1,J1, 1,I2DSTART,0)                 DIAGSIG.1487
         I2DSTART=I2DSTART+1                                                     DIAGSIG.1488
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.1489
            UNIT(1:8)='cm      '                                                 DIAGSIG.1490
            UNITS(1:8)='cm      '                                                DIAGSIG.1491
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.1492
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.1493
            UNIT(1:8)='mm      '                                                 DIAGSIG.1494
            UNITS(1:8)='mm      '                                                DIAGSIG.1495
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.1496
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.1497
            UNIT(1:8)='in      '                                                 DIAGSIG.1498
            UNITS(1:8)='in      '                                                DIAGSIG.1499
         ELSE                                                                    DIAGSIG.1500
            UNIT(1:8)='cm      '                                                 DIAGSIG.1501
            UNITS(1:8)='cm      '                                                DIAGSIG.1502
         END IF                                                                  DIAGSIG.1503
C                                                                                DIAGSIG.1504
      ELSE IF(FIELD(1:5).EQ.'INCI '    ) THEN ! INTEGRATED ICE NO CONC           06NOV00.10
         VARNAM(1:8)='INTG NCI'                                                  DIAGSIG.1506
         CNT=CONT                                                                DIAGSIG.1507
         NPASS=ISMTHR                                                            DIAGSIG.1508
         ICRSDOT=1                                                               DIAGSIG.1509
         KDIM='2D'                                                               DIAGSIG.1510
         IF (INHYD.EQ.1) THEN                                                    DIAGSIG.1511
           CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                        DIAGSIG.1512
     *     DIAGS,FOUND)                                                          DIAGSIG.1513
           IF(.NOT.FOUND) THEN                                                   DIAGSIG.1514
             PRINT *,'FIELD PP NOT FOUND'                                        DIAGSIG.1515
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                       DIAGSIG.1516
             IERROR=1                                                            DIAGSIG.1517
             RETURN                                                              DIAGSIG.1518
           ENDIF                                                                 DIAGSIG.1519
         ELSE                                                                    DIAGSIG.1520
           CALL CLEAR(D33,I1,J1,K1)                                              DIAGSIG.1521
         END IF                                                                  DIAGSIG.1522
           CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                        DIAGSIG.1523
     *     .FALSE.,FOUND)                                                        DIAGSIG.1524
         CALL READDAD(D32,'NCI     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1525
     *      DIAGS,FOUND)                                                         DIAGSIG.1526
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1527
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1528
            IERROR=1                                                             DIAGSIG.1529
            RETURN                                                               DIAGSIG.1530
         END IF                                                                  DIAGSIG.1531
      CALL INTEGRAT(D32,D33,D21,I1,J1,K1,SIGMA,PTOP,ICRSDOT,D31)                 DIAGSIG.1532
         CALL WRITDAD(D31,'INTG NCI',IDAD2D,I1,J1, 1,I2DSTART,0)                 DIAGSIG.1533
         I2DSTART=I2DSTART+1                                                     DIAGSIG.1534
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.1535
            UNIT(1:8)='cm      '                                                 DIAGSIG.1536
            UNITS(1:8)='cm      '                                                DIAGSIG.1537
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.1538
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.1539
            UNIT(1:8)='mm      '                                                 DIAGSIG.1540
            UNITS(1:8)='mm      '                                                DIAGSIG.1541
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.1542
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.1543
            UNIT(1:8)='in      '                                                 DIAGSIG.1544
            UNITS(1:8)='in      '                                                DIAGSIG.1545
         ELSE                                                                    DIAGSIG.1546
            UNIT(1:8)='cm      '                                                 DIAGSIG.1547
            UNITS(1:8)='cm      '                                                DIAGSIG.1548
         END IF                                                                  DIAGSIG.1549
C                                                                                DIAGSIG.1550
      ELSE IF(FIELD(2:4).EQ.'CLD'    ) THEN    ! Cloud fraction                  DIAGSIG.1551
         if (field(1:1) .eq. 'L') then                                           DIAGSIG.1552
           lev = 3                                                               DIAGSIG.1553
           VARNAM(1:8)='LOW CLD '                                                DIAGSIG.1554
         else if (field(1:1) .eq. 'M') then                                      DIAGSIG.1555
           lev = 2                                                               DIAGSIG.1556
           VARNAM(1:8)='MID CLD '                                                DIAGSIG.1557
         else if (field(1:1) .eq. 'H') then                                      DIAGSIG.1558
           lev = 1                                                               DIAGSIG.1559
           VARNAM(1:8)='HI CLD '                                                 DIAGSIG.1560
         else                                                                    DIAGSIG.1561
           PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                         DIAGSIG.1562
           IERROR=1                                                              DIAGSIG.1563
           RETURN                                                                DIAGSIG.1564
         endif                                                                   DIAGSIG.1565
         CNT=CONT                                                                DIAGSIG.1566
         NPASS=ISMTHR                                                            DIAGSIG.1567
         ICRSDOT=1                                                               DIAGSIG.1568
         KDIM='2D'                                                               DIAGSIG.1569
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1570
     *      .FALSE.,FOUND)                                                       DIAGSIG.1571
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1572
     *      DIAGS,FOUND)                                                         DIAGSIG.1573
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1574
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1575
            IERROR=1                                                             DIAGSIG.1576
            RETURN                                                               DIAGSIG.1577
         END IF                                                                  DIAGSIG.1578
         CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1579
     *      .FALSE.,FOUND)                                                       DIAGSIG.1580
         CALL READDAD(D32,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1581
     *       DIAGS,FOUND)                                                        DIAGSIG.1582
         IF(.NOT.FOUND) CALL CLEAR(D32,I1,J1,K1)                                 DIAGSIG.1583
         CALL QTORH(D33,D31,D32,SIGMA,D21,PTOP,I1,J1,K1,                         DIAGSIG.1584
     *              D32)                                                         DIAGSIG.1585
         CALL SCALE(D32,'MULT',0.01,I1,J1,K1,I1,J1,1)                            DIAGSIG.1586
         call cloudf (d32,i1,j1,k1,sigma,ptop,k1,lev,d31)                        DIAGSIG.1587
         IF(UNIT(1:1).EQ.'%') THEN                                               DIAGSIG.1588
            UNIT(1:8)='%       '                                                 DIAGSIG.1589
            UNITS(1:8)='%       '                                                DIAGSIG.1590
         ELSE                                                                    DIAGSIG.1591
            UNIT(1:8)='%       '                                                 DIAGSIG.1592
            UNITS(1:8)='%       '                                                DIAGSIG.1593
         END IF                                                                  DIAGSIG.1594
C                                                                                DIAGSIG.1595
      ELSE IF(FIELD(1:5).EQ.'MDIV ') THEN    ! MOISTURE DIVERGENCE               DIAGSIG.1596
        VARNAM(1:8) = 'MDIVERG '                                                 DIAGSIG.1597
        CNT=CONT                                                                 DIAGSIG.1598
        NPASS=ISMTHR                                                             DIAGSIG.1599
        ICRSDOT=1                                                                DIAGSIG.1600
        KDIM='3D'                                                                DIAGSIG.1601
         IF (BHI(  1,1).EQ.11) THEN                                              DIAGSIG.1602
            CALL READDAD(D31,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.1603
     *         DIAGS,FOUND)                                                      DIAGSIG.1604
            IF (.NOT. FOUND) THEN                                                DIAGSIG.1605
              PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                      DIAGSIG.1606
              IERROR = 1                                                         DIAGSIG.1607
              RETURN                                                             DIAGSIG.1608
            ENDIF                                                                DIAGSIG.1609
          ELSE                                                                   DIAGSIG.1610
            CALL READDAD(D31,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.1611
     *         .FALSE.,FOUND)                                                    DIAGSIG.1612
          ENDIF                                                                  DIAGSIG.1613
          CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                         DIAGSIG.1614
     *        .FALSE.,FOUND)                                                     DIAGSIG.1615
          CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                         DIAGSIG.1616
     *        .FALSE.,FOUND)                                                     DIAGSIG.1617
          CALL READDAD(D21,'MAPFACDT',IMMHDR,I1,J1, 1,1,                         DIAGSIG.1618
     *        .FALSE.,FOUND)                                                     DIAGSIG.1619
          CALL READDAD(D22,'MAPFACCR',IMMHDR,I1,J1, 1,1,                         DIAGSIG.1620
     *        .FALSE.,FOUND)                                                     DIAGSIG.1621
          CALL MDIV(D33,D32,D21,D22,D23,I1,J1,K1,DS,D31)                         DIAGSIG.1622
C         CALL WRITDAD(D31,'MDIVERG ',IDAD3D,I1,J1,K1,I3DSTART,0)                DIAGSIG.1623
C         I3DSTART=I3DSTART+1                                                    DIAGSIG.1624
          IF(UNIT(1:3).EQ.'1/s') THEN                                            DIAGSIG.1625
             UNIT(1:8)='1/s     '                                                DIAGSIG.1626
             UNITS(1:8)='1/s     '                                               DIAGSIG.1627
          ELSE IF(UNIT(1:7).EQ.'10**7/s') THEN                                   DIAGSIG.1628
             CALL SCALE(D31,'MULT',10000000.,I1,J1,K1,I1,J1,1)                   DIAGSIG.1629
             UNIT(1:8)='10**7/s '                                                DIAGSIG.1630
             UNITS(1:8)='10**7/s '                                               DIAGSIG.1631
          ELSE                                                                   DIAGSIG.1632
             UNIT(1:8)='1/s     '                                                DIAGSIG.1633
             UNITS(1:8)='1/s     '                                               DIAGSIG.1634
          ENDIF                                                                  DIAGSIG.1635
C                                                                                DIAGSIG.1636
      ELSE IF(FIELD(1:4).EQ.'MSE '    ) THEN    ! MOIST STATIC ENERGY            DIAGSIG.1637
         VARNAM(1:8)='MSE     '                                                  DIAGSIG.1638
         CNT=CONT                                                                DIAGSIG.1639
         NPASS=ISMTHR                                                            DIAGSIG.1640
         ICRSDOT=1                                                               DIAGSIG.1641
         KDIM='3D'                                                               DIAGSIG.1642
         IF (BHI(  1,1).EQ.5) THEN                                               DIAGSIG.1643
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.1644
     *      .FALSE.,FOUND)                                                       DIAGSIG.1645
         ELSE IF (BHI(  1,1).EQ.11) THEN                                         DIAGSIG.1646
            IF(IDRY.NE.1) THEN                                                   DIAGSIG.1647
               CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                    DIAGSIG.1648
     *            .FALSE.,FOUND)                                                 DIAGSIG.1649
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGSIG.1650
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGSIG.1651
               CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                      DIAGSIG.1652
     *               I3DSTART,0)                                                 DIAGSIG.1653
               I3DSTART=I3DSTART+1                                               DIAGSIG.1654
            END IF                                                               DIAGSIG.1655
         END IF                                                                  DIAGSIG.1656
         CALL READDAD(D22,'TERRAIN ',IMMHDR,I1,J1,1,1,                           DIAGSIG.1657
     *      .FALSE.,FOUND)                                                       DIAGSIG.1658
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1659
     *      .FALSE.,FOUND)                                                       DIAGSIG.1660
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1661
     *      .FALSE.,FOUND)                                                       DIAGSIG.1662
         if(inhyd.ne.1) then                                                     DIAGSIG.1663
            CALL GEOPOT(D32,D33,D22,D21,IDRY,SIGMA,PTOP,I1,J1,K1,D31)            DIAGSIG.1664
         else                                                                    DIAGSIG.1665
            CALL nhgeosig(d21,sigma,ptop,i1,j1,k1,d31)                           DIAGSIG.1666
         endif                                                                   DIAGSIG.1667
         CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                            DIAGSIG.1668
     *               I3DSTART,0)                                                 DIAGSIG.1669
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1670
         CALL MSE(D32,D33,D31,I1,J1,K1,D31)                                      DIAGSIG.1671
         CALL WRITDAD(D31,'MSE     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.1672
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1673
         IF(UNIT(1:4).EQ.'J/kg') THEN                                            DIAGSIG.1674
            UNIT(1:8)='J/kg    '                                                 DIAGSIG.1675
            UNITS(1:8)='J/kg    '                                                DIAGSIG.1676
         ELSE IF(UNIT(1:5).EQ.'KJ/kg') THEN                                      DIAGSIG.1677
            CALL SCALE(D31,'DIV ',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1678
            UNIT(1:8)='KJ/kg   '                                                 DIAGSIG.1679
            UNITS(1:8)='KJ/kg   '                                                DIAGSIG.1680
         ELSE                                                                    DIAGSIG.1681
            UNIT(1:8)='J/kg    '                                                 DIAGSIG.1682
            UNITS(1:8)='J/kg    '                                                DIAGSIG.1683
         ENDIF                                                                   DIAGSIG.1684
C                                                                                DIAGSIG.1685
      ELSE IF(FIELD(1:4).EQ.'MSS '    ) THEN    ! SAT MOIST STATIC ENERG         DIAGSIG.1686
         VARNAM(1:8)='MSS     '                                                  DIAGSIG.1687
         CNT=CONT                                                                DIAGSIG.1688
         NPASS=ISMTHR                                                            DIAGSIG.1689
         ICRSDOT=1                                                               DIAGSIG.1690
         KDIM='3D'                                                               DIAGSIG.1691
         IF (BHI(  1,1).EQ.5) THEN                                               DIAGSIG.1692
            CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.1693
     *      .FALSE.,FOUND)                                                       DIAGSIG.1694
         ELSE IF (BHI(  1,1).EQ.11) THEN                                         DIAGSIG.1695
            IF(IDRY.NE.1) THEN                                                   DIAGSIG.1696
               CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                    DIAGSIG.1697
     *            .FALSE.,FOUND)                                                 DIAGSIG.1698
            ELSE IF(IDRY.EQ.1) THEN                                              DIAGSIG.1699
               CALL CLEAR(D33,I1,J1,K1)                                          DIAGSIG.1700
               CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                      DIAGSIG.1701
     *               I3DSTART,0)                                                 DIAGSIG.1702
               I3DSTART=I3DSTART+1                                               DIAGSIG.1703
            END IF                                                               DIAGSIG.1704
         END IF                                                                  DIAGSIG.1705
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1706
     *      .FALSE.,FOUND)                                                       DIAGSIG.1707
         CALL READDAD(D22,'TERRAIN ',IMMHDR,I1,J1,1,1,                           DIAGSIG.1708
     *      .FALSE.,FOUND)                                                       DIAGSIG.1709
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1,1,0,                           DIAGSIG.1710
     *      .FALSE.,FOUND)                                                       DIAGSIG.1711
         if(inhyd.ne.1) then                                                     DIAGSIG.1712
            CALL GEOPOT(D32,D33,D22,D21,IDRY,SIGMA,PTOP,I1,J1,K1,D31)            DIAGSIG.1713
         else                                                                    DIAGSIG.1714
            CALL nhgeosig(d21,sigma,ptop,i1,j1,k1,d31)                           DIAGSIG.1715
         endif                                                                   DIAGSIG.1716
         CALL WRITDAD(D31,'GHT INTG',IDAD3D,I1,J1,K1,                            DIAGSIG.1717
     *               I3DSTART,0)                                                 DIAGSIG.1718
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1719
         CALL READDAD(D33,'GHT INTG',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1720
     *   .FALSE.,FOUND)                                                          DIAGSIG.1721
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1722
     *   .FALSE.,FOUND)                                                          DIAGSIG.1723
         if(inhyd.ne.1) then                                                     DIAGSIG.1724
         CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1725
     *      .FALSE.,FOUND)                                                       DIAGSIG.1726
         else                                                                    DIAGSIG.1727
         CALL CLEAR(D33,I1,J1,K1)                                                DIAGSIG.1728
         end if                                                                  DIAGSIG.1729
         CALL MSESS(D32,D31,D33,SIGMA,D21,I1,J1,K1,PTOP,D31)                     DIAGSIG.1730
         CALL WRITDAD(D31,'MSS     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.1731
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1732
         IF(UNIT(1:4).EQ.'J/kg') THEN                                            DIAGSIG.1733
            UNIT(1:8)='J/kg    '                                                 DIAGSIG.1734
            UNITS(1:8)='J/kg    '                                                DIAGSIG.1735
         ELSE IF(UNIT(1:5).EQ.'KJ/kg') THEN                                      DIAGSIG.1736
            CALL SCALE(D31,'DIV ',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1737
            UNIT(1:8)='KJ/kg   '                                                 DIAGSIG.1738
            UNITS(1:8)='KJ/kg   '                                                DIAGSIG.1739
         ELSE                                                                    DIAGSIG.1740
            UNIT(1:8)='J/kg    '                                                 DIAGSIG.1741
            UNITS(1:8)='J/kg    '                                                DIAGSIG.1742
         ENDIF                                                                   DIAGSIG.1743
C                                                                                DIAGSIG.1744
      ELSE IF(FIELD(1:3).EQ.'LI '    ) THEN    ! THETAE LIFTED INDEX             DIAGSIG.1745
         VARNAM(1:8)='LI      '                                                  DIAGSIG.1746
         CNT=CONT                                                                DIAGSIG.1747
         NPASS=ISMTHR                                                            DIAGSIG.1748
         ICRSDOT=1                                                               DIAGSIG.1749
         KDIM='2D'                                                               DIAGSIG.1750
C         IF((PROG(1:2).EQ.'MM').AND.(IDRY.EQ.1)) THEN                           DIAGSIG.1751
         IF((BHI( 1,1).EQ.11).AND.(BHI(  3,13).EQ.1)) THEN                       DIAGSIG.1752
            CALL CLEAR(D33,I1,J1,K1)                                             DIAGSIG.1753
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGSIG.1754
     *                I3DSTART,0)                                                DIAGSIG.1755
            I3DSTART=I3DSTART+1                                                  DIAGSIG.1756
         ENDIF                                                                   DIAGSIG.1757
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1758
     *      .FALSE.,FOUND)                                                       DIAGSIG.1759
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1760
     *      .FALSE.,FOUND)                                                       DIAGSIG.1761
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1762
     *      .FALSE.,FOUND)                                                       DIAGSIG.1763
c dave                                                                           DIAGSIG.1764
         CALL READDAD(D31,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1765
     *      DIAGS,FOUND)                                                         DIAGSIG.1766
         IF(.NOT.FOUND) CALL CLEAR(D31,i1,j1,k1)                                 DIAGSIG.1767
         CALL THETAES(D32,D33,D31,D21,SIGMA,PTOP,I1,J1,K1,D31)                   DIAGSIG.1768
         CALL WRITDAD(D31,'THETAE  ',IDAD3D,I1,J1,K1,                            DIAGSIG.1769
     *               I3DSTART,0)                                                 DIAGSIG.1770
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1771
C     NOW COMPUTE SATURATED THETAE                                               DIAGSIG.1772
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1773
     *      .FALSE.,FOUND)                                                       DIAGSIG.1774
      CALL SIG2PRS(D31,D21,SIGMA,PTOP,I1,J1,K1,D31)                              DIAGSIG.1775
         CALL CLEAR(D33,I1,J1,K1)                                                DIAGSIG.1776
         CALL SCALE(D33,'ADD ',100.,I1,J1,K1,I1,J1,0)                            DIAGSIG.1777
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1778
     *      .FALSE.,FOUND)                                                       DIAGSIG.1779
         CALL MXRAT(D33,D32,D31,I1,J1,K1,D31)                                    DIAGSIG.1780
c dave                                                                           DIAGSIG.1781
         CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1782
     *      DIAGS,FOUND)                                                         DIAGSIG.1783
         IF(.NOT.FOUND) CALL CLEAR(D33,i1,j1,k1)                                 DIAGSIG.1784
         CALL THETAES(D32,D31,D33,D21,SIGMA,PTOP,I1,J1,K1,D33)                   DIAGSIG.1785
C     NOW THE DIFFERENCE FIELDS                                                  DIAGSIG.1786
         CALL READDAD(D32,'THETAE  ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1787
     *      .FALSE.,FOUND)                                                       DIAGSIG.1788
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1789
     *      .FALSE.,FOUND)                                                       DIAGSIG.1790
         CALL READDAD(D31,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1791
     *       DIAGS,FOUND)                                                        DIAGSIG.1792
         IF(.NOT.FOUND) CALL CLEAR(D31,I1,J1,K1)                                 DIAGSIG.1793
         CALL LIS(D32,D33,D31,D21,SIGMA,PTOP,I1,J1,K1,D31)                       DIAGSIG.1794
         CALL WRITDAD(D31,'LI      ',IDAD3D,I1,J1, 1,I2DSTART,0)                 DIAGSIG.1795
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1796
         CALL WRITDAD(D31,'LI      ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.1797
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1798
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGSIG.1799
            UNIT(1:8)='K       '                                                 DIAGSIG.1800
            UNITS(1:8)='K       '                                                DIAGSIG.1801
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGSIG.1802
            UNIT(1:8)='C       '                                                 DIAGSIG.1803
            UNITS(1:8)='C       '                                                DIAGSIG.1804
         ELSE                                                                    DIAGSIG.1805
            UNIT(1:8)='K       '                                                 DIAGSIG.1806
            UNITS(1:8)='K       '                                                DIAGSIG.1807
         ENDIF                                                                   DIAGSIG.1808
      ELSE IF(FIELD(1:4).EQ.'OMG '    ) THEN    ! OMEGA                          DIAGSIG.1809
          IF (INHYD.EQ.1) THEN                                                   DIAGSIG.1810
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED,',                     DIAGSIG.1811
     +         ' BECAUSE INHYD=',INHYD,' IS NON-HYDROSTATIC RUN.'                DIAGSIG.1812
            IERROR=1                                                             DIAGSIG.1813
            RETURN                                                               DIAGSIG.1814
         END IF                                                                  DIAGSIG.1815
         VARNAM(1:8)='OMEGA   '                                                  DIAGSIG.1816
         CNT=CONT                                                                DIAGSIG.1817
         NPASS=ISMTHR                                                            DIAGSIG.1818
         ICRSDOT=1                                                               DIAGSIG.1819
         KDIM='3D'                                                               DIAGSIG.1820
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1821
     *      .FALSE.,FOUND)                                                       DIAGSIG.1822
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1823
     *      .FALSE.,FOUND)                                                       DIAGSIG.1824
         CALL READDAD(D21,'MAPFACDT',IMMHDR,I1,J1, 1,1,                          DIAGSIG.1825
     *      .FALSE.,FOUND)                                                       DIAGSIG.1826
         CALL READDAD(D22,'MAPFACCR',IMMHDR,I1,J1, 1,1,                          DIAGSIG.1827
     *      .FALSE.,FOUND)                                                       DIAGSIG.1828
         CALL READDAD(D23,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1829
     *      .FALSE.,FOUND)                                                       DIAGSIG.1830
         CALL READDAD(D24,'PSTARDOT',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1831
     *      .FALSE.,FOUND)                                                       DIAGSIG.1832
         CALL OMEGAS(D33,D32,D21,D22,D23,D24,SIGMA,                              DIAGSIG.1833
     *      I1,J1,K1,DS,D31)                                                     DIAGSIG.1834
         CALL WRITDAD(D31,'OMEGA   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.1835
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1836
         IF(UNIT(1:4).EQ.'mb/s') THEN                                            DIAGSIG.1837
            UNIT(1:8)='mb/s    '                                                 DIAGSIG.1838
            UNITS(1:8)='mb/s    '                                                DIAGSIG.1839
         ELSE IF(UNIT(1:4).EQ.'ub/s') THEN                                       DIAGSIG.1840
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.1841
            UNIT(1:8)='ub/s    '                                                 DIAGSIG.1842
            UNITS(1:8)='ub/s    '                                                DIAGSIG.1843
         ELSE IF(UNIT(1:4).EQ.'Pa/s') THEN                                       DIAGSIG.1844
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,1)                        DIAGSIG.1845
            UNIT(1:8)='Pa/s    '                                                 DIAGSIG.1846
            UNITS(1:8)='Pa/s    '                                                DIAGSIG.1847
         ELSE IF(UNIT(1:5).EQ.'hPa/s') THEN                                      DIAGSIG.1848
            UNIT(1:8)='hPa/s   '                                                 DIAGSIG.1849
            UNITS(1:8)='hPa/s   '                                                DIAGSIG.1850
         ELSE                                                                    DIAGSIG.1851
            UNIT(1:8)='mb/s    '                                                 DIAGSIG.1852
            UNITS(1:8)='mb/s    '                                                DIAGSIG.1853
         END IF                                                                  DIAGSIG.1854
C                                                                                DIAGSIG.1855
      ELSE IF(FIELD(1:2).EQ.'P '      ) THEN    ! PRESSURE                       DIAGSIG.1856
         VARNAM(1:8)='PRESSURE'                                                  DIAGSIG.1857
         CNT=CONT                                                                DIAGSIG.1858
         NPASS=ISMTHR                                                            DIAGSIG.1859
         ICRSDOT=1                                                               DIAGSIG.1860
         KDIM='3D'                                                               DIAGSIG.1861
         CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1862
     *      DIAGS,FOUND)                                                         DIAGSIG.1863
         IF(.NOT.FOUND) CALL CLEAR(D33,I1,J1,K1)                                 DIAGSIG.1864
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1865
     *      .FALSE.,FOUND)                                                       DIAGSIG.1866
      CALL SIG2PRS(D33,D21,SIGMA,PTOP,I1,J1,K1,D31)                              DIAGSIG.1867
         CALL WRITDAD(D31,'P       ',IDAD3D,I1,J1,K1,                            DIAGSIG.1868
     *               I3DSTART,0)                                                 DIAGSIG.1869
         I3DSTART=I3DSTART+1                                                     DIAGSIG.1870
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGSIG.1871
            UNIT(1:8)='mb      '                                                 DIAGSIG.1872
            UNITS(1:8)='mb      '                                                DIAGSIG.1873
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGSIG.1874
            CALL SCALE(D31,'MULT',100.0,I1,J1,KUPRD,I1,J1,1)                     DIAGSIG.1875
            UNIT(1:8)='Pa      '                                                 DIAGSIG.1876
            UNITS(1:8)='Pa      '                                                DIAGSIG.1877
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGSIG.1878
            UNIT(1:8)='hPa     '                                                 DIAGSIG.1879
            UNITS(1:8)='hPa     '                                                DIAGSIG.1880
         ELSE                                                                    DIAGSIG.1881
            UNIT(1:8)='mb      '                                                 DIAGSIG.1882
            UNITS(1:8)='mb      '                                                DIAGSIG.1883
         END IF                                                                  DIAGSIG.1884
C                                                                                DIAGSIG.1885
      ELSE IF(FIELD(1:3).EQ.'PP '      ) THEN    ! PRESSURE PERTURB              DIAGSIG.1886
         VARNAM(1:8)='P PRIME '                                                  DIAGSIG.1887
         CNT=CONT                                                                DIAGSIG.1888
         NPASS=ISMTHR                                                            DIAGSIG.1889
         ICRSDOT=1                                                               DIAGSIG.1890
         KDIM='3D'                                                               DIAGSIG.1891
         CALL READDAD(D31,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1892
     *      DIAGS,FOUND)                                                         DIAGSIG.1893
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1894
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1895
            IERROR=1                                                             DIAGSIG.1896
            RETURN                                                               DIAGSIG.1897
         ENDIF                                                                   DIAGSIG.1898
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGSIG.1899
            UNIT(1:8)='mb      '                                                 DIAGSIG.1900
            UNITS(1:8)='mb      '                                                DIAGSIG.1901
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGSIG.1902
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,1)                        DIAGSIG.1903
            UNIT(1:8)='Pa      '                                                 DIAGSIG.1904
            UNITS(1:8)='Pa      '                                                DIAGSIG.1905
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGSIG.1906
            UNIT(1:8)='hPa     '                                                 DIAGSIG.1907
            UNITS(1:8)='hPa     '                                                DIAGSIG.1908
         ELSE                                                                    DIAGSIG.1909
            UNIT(1:8)='mb      '                                                 DIAGSIG.1910
            UNITS(1:8)='mb      '                                                DIAGSIG.1911
         END IF                                                                  DIAGSIG.1912
C                                                                                DIAGSIG.1913
      ELSE IF((FIELD(1:6).EQ.'PRH2O '     ) .OR.                                 DIAGSIG.1914
     *        (FIELD(1:6).EQ.'PRH20 '     )) THEN ! PRECIPTABLE WATER            DIAGSIG.1915
         VARNAM(1:8)='PRH2O   '                                                  DIAGSIG.1916
         CNT=CONT                                                                DIAGSIG.1917
         NPASS=ISMTHR                                                            DIAGSIG.1918
         ICRSDOT=1                                                               DIAGSIG.1919
         KDIM='2D'                                                               DIAGSIG.1920
         IF (INHYD.EQ.1) THEN                                                    DIAGSIG.1921
           CALL READDAD(D32,'PP      ',IDAD3D,I1,J1,K1,0,                        DIAGSIG.1922
     *     DIAGS,FOUND)                                                          DIAGSIG.1923
           IF(.NOT.FOUND) THEN                                                   DIAGSIG.1924
             PRINT *,'FIELD PP NOT FOUND'                                        DIAGSIG.1925
             PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                       DIAGSIG.1926
             IERROR=1                                                            DIAGSIG.1927
             RETURN                                                              DIAGSIG.1928
           ENDIF                                                                 DIAGSIG.1929
         ELSE                                                                    DIAGSIG.1930
           CALL CLEAR(D32,I1,J1,K1)                                              DIAGSIG.1931
         END IF                                                                  DIAGSIG.1932
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.1933
     *      DIAGS,FOUND)                                                         DIAGSIG.1934
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.1935
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.1936
            IERROR=1                                                             DIAGSIG.1937
            RETURN                                                               DIAGSIG.1938
         END IF                                                                  DIAGSIG.1939
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1940
     *      .FALSE.,FOUND)                                                       DIAGSIG.1941
      CALL INTEGRAT(D33,D32,D21,I1,J1,K1,SIGMA,PTOP,ICRSDOT,D31)                 DIAGSIG.1942
         CALL WRITDAD(D31,'PRH2O   ',IDAD2D,I1,J1, 1,                            DIAGSIG.1943
     *                I2DSTART,0)                                                DIAGSIG.1944
         I2DSTART=I2DSTART+1                                                     DIAGSIG.1945
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.1946
            UNIT(1:8)='cm      '                                                 DIAGSIG.1947
            UNITS(1:8)='cm      '                                                DIAGSIG.1948
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.1949
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.1950
            UNIT(1:8)='mm      '                                                 DIAGSIG.1951
            UNITS(1:8)='mm      '                                                DIAGSIG.1952
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.1953
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.1954
            UNIT(1:8)='in      '                                                 DIAGSIG.1955
            UNITS(1:8)='in      '                                                DIAGSIG.1956
         ELSE                                                                    DIAGSIG.1957
            UNIT(1:8)='cm      '                                                 DIAGSIG.1958
            UNITS(1:8)='cm      '                                                DIAGSIG.1959
         END IF                                                                  DIAGSIG.1960
C                                                                                DIAGSIG.1961
      ELSE IF(FIELD(1:5).EQ.'PSFC '     ) THEN    ! SURFACE PRESSURE             DIAGSIG.1962
         VARNAM(1:8)='SFC PRES'                                                  DIAGSIG.1963
         CNT=CONT                                                                DIAGSIG.1964
         NPASS=ISMTHR                                                            DIAGSIG.1965
         ICRSDOT=1                                                               DIAGSIG.1966
         KDIM='2D'                                                               DIAGSIG.1967
         CALL READDAD(D31,'P SFC   ',IDAD2D,I1,J1, 1,0,                          DIAGSIG.1968
     *      .FALSE.,FOUND)                                                       DIAGSIG.1969
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGSIG.1970
            UNIT(1:8)='mb      '                                                 DIAGSIG.1971
            UNITS(1:8)='mb      '                                                DIAGSIG.1972
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGSIG.1973
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,1)                        DIAGSIG.1974
            UNIT(1:8)='Pa      '                                                 DIAGSIG.1975
            UNITS(1:8)='Pa      '                                                DIAGSIG.1976
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGSIG.1977
            UNIT(1:8)='hPa     '                                                 DIAGSIG.1978
            UNITS(1:8)='hPa     '                                                DIAGSIG.1979
         ELSE IF(UNIT(1:5).EQ.'inHg ') THEN                                      DIAGSIG.1980
            CALL SCALE(D31,'DIV ',33.86388640,I1,J1, 1,I1,J1,1)                  DIAGSIG.1981
            UNIT(1:8)='inHg    '                                                 DIAGSIG.1982
            UNITS(1:8)='inHg    '                                                DIAGSIG.1983
         ELSE                                                                    DIAGSIG.1984
            UNIT(1:8)='mb      '                                                 DIAGSIG.1985
            UNITS(1:8)='mb      '                                                DIAGSIG.1986
         END IF                                                                  DIAGSIG.1987
C                                                                                DIAGSIG.1988
      ELSE IF(FIELD(1:5).EQ.'PSLV '     ) THEN    ! SEA LEVEL PRESSURE           DIAGSIG.1989
         VARNAM(1:8)='SEA PRES'                                                  DIAGSIG.1990
         CNT=CONT                                                                DIAGSIG.1991
         NPASS=ISMTHR                                                            DIAGSIG.1992
         ICRSDOT=1                                                               DIAGSIG.1993
         KDIM='2D'                                                               DIAGSIG.1994
         IF(IDRY.NE.1) THEN                                                      DIAGSIG.1995
            CALL READDAD(D33,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.1996
     *         .FALSE.,FOUND)                                                    DIAGSIG.1997
            CALL READDAD(D32,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.1998
     *         .FALSE.,FOUND)                                                    DIAGSIG.1999
            CALL TVIRT(D33,D32,I1,J1,K1,D31,I1,J1)                               DIAGSIG.2000
         ELSE IF(IDRY.EQ.1) THEN                                                 DIAGSIG.2001
            CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2002
     *         .FALSE.,FOUND)                                                    DIAGSIG.2003
         END IF                                                                  DIAGSIG.2004
         CALL READDAD(D21,'TERRAIN ',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2005
     *      .FALSE.,FOUND)                                                       DIAGSIG.2006
         CALL READDAD(D22,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2007
     *      .FALSE.,FOUND)                                                       DIAGSIG.2008
         CALL READDAD(D23,'P SFC   ',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2009
     *      .FALSE.,FOUND)                                                       DIAGSIG.2010
         CALL READDAD(D32,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2011
     *      DIAGS,FOUND)                                                         DIAGSIG.2012
         IF(.NOT.FOUND) CALL CLEAR(D32,I1,J1,K1)                                 DIAGSIG.2013
         CALL SEAPRS(D31,D32,D21,D22,D23,SIGMA,                                  DIAGSIG.2014
     *               I1,J1,K1,PTOP,D24)                                          DIAGSIG.2015
         CALL EQUATE(D24,I1,J1,1,1,D31,I1,J1,1)                                  DIAGSIG.2016
         CALL WRITDAD(D31,'PSEALVLC',IDAD2D,I1,J1,1,                             DIAGSIG.2017
     *                I2DSTART,0)                                                DIAGSIG.2018
         I2DSTART=I2DSTART+1                                                     DIAGSIG.2019
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGSIG.2020
            UNIT(1:8)='mb      '                                                 DIAGSIG.2021
            UNITS(1:8)='mb      '                                                DIAGSIG.2022
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGSIG.2023
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,1)                        DIAGSIG.2024
            UNIT(1:8)='Pa      '                                                 DIAGSIG.2025
            UNITS(1:8)='Pa      '                                                DIAGSIG.2026
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGSIG.2027
            UNIT(1:8)='hPa     '                                                 DIAGSIG.2028
            UNITS(1:8)='hPa     '                                                DIAGSIG.2029
         ELSE IF(UNIT(1:5).EQ.'inHg ') THEN                                      DIAGSIG.2030
            CALL SCALE(D31,'DIV ',33.86388640,I1,J1, 1,I1,J1,1)                  DIAGSIG.2031
            UNIT(1:8)='inHg    '                                                 DIAGSIG.2032
            UNITS(1:8)='inHg    '                                                DIAGSIG.2033
         ELSE                                                                    DIAGSIG.2034
            UNIT(1:8)='mb      '                                                 DIAGSIG.2035
            UNITS(1:8)='mb      '                                                DIAGSIG.2036
         END IF                                                                  DIAGSIG.2037
C                                                                                DIAGSIG.2038
      ELSE IF(FIELD(1:6).EQ.'PSLV2 '    ) THEN    ! SEA LEVEL PRESSURE           DIAGSIG.2039
         VARNAM(1:8)='SEA PRS2'                                                  DIAGSIG.2040
         CNT=CONT                                                                DIAGSIG.2041
         NPASS=ISMTHR                                                            DIAGSIG.2042
         ICRSDOT=1                                                               DIAGSIG.2043
         KDIM='2D'                                                               DIAGSIG.2044
         IF(IDRY.NE.1) THEN                                                      DIAGSIG.2045
            CALL READDAD(D33,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2046
     *         .FALSE.,FOUND)                                                    DIAGSIG.2047
            CALL READDAD(D32,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2048
     *         .FALSE.,FOUND)                                                    DIAGSIG.2049
            CALL TVIRT(D33,D32,I1,J1,K1,D31,I1,J1)                               DIAGSIG.2050
         ELSE IF(IDRY.EQ.1) THEN                                                 DIAGSIG.2051
            CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2052
     *         .FALSE.,FOUND)                                                    DIAGSIG.2053
         END IF                                                                  DIAGSIG.2054
         CALL READDAD(D21,'TERRAIN ',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2055
     *      .FALSE.,FOUND)                                                       DIAGSIG.2056
         CALL READDAD(D22,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2057
     *      .FALSE.,FOUND)                                                       DIAGSIG.2058
         CALL READDAD(D23,'P SFC   ',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2059
     *      .FALSE.,FOUND)                                                       DIAGSIG.2060
         CALL READDAD(D32,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2061
     *      DIAGS,FOUND)                                                         DIAGSIG.2062
         IF(.NOT.FOUND) CALL CLEAR(D32,I1,J1,K1)                                 DIAGSIG.2063
         CALL SEAPRS(D31,D32,D21,D22,D23,SIGMA,                                  DIAGSIG.2064
     *               I1,J1,K1,PTOP,D24)                                          DIAGSIG.2065
C        CALL WRITDAD(DUM2D4,'PSEALVLC',IDAD2D,I1,J1,1,                          DIAGSIG.2066
C    *                I2DSTART,0)                                                DIAGSIG.2067
C                                                                                DIAGSIG.2068
         CALL READDAD(D21,'TERRAIN ',IMMHDR,I1,J1,  1,1,                         DIAGSIG.2069
     *      .FALSE.,FOUND)                                                       DIAGSIG.2070
         IF(IDRY.NE.1) THEN                                                      DIAGSIG.2071
            CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2072
     *         .FALSE.,FOUND)                                                    DIAGSIG.2073
            CALL READDAD(D32,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2074
     *         .FALSE.,FOUND)                                                    DIAGSIG.2075
            CALL TVIRT(D31(1,K1),D32(1,K1),I1,J1,1,D22,I1,J1)                    DIAGSIG.2076
         ELSE IF(IDRY.EQ.1) THEN                                                 DIAGSIG.2077
            CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2078
     *         .FALSE.,FOUND)                                                    DIAGSIG.2079
            CALL EQUATE(D31(1,K1),I1,J1,1,1,D22,I1,J1,1)                         DIAGSIG.2080
         END IF                                                                  DIAGSIG.2081
         CALL READDAD(D23,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2082
     *      .FALSE.,FOUND)                                                       DIAGSIG.2083
         CALL READDAD(D32,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2084
     *      DIAGS,FOUND)                                                         DIAGSIG.2085
         IF(.NOT.FOUND) CALL CLEAR(D32,I1,J1,K1)                                 DIAGSIG.2086
         CALL SEAPRS2(D32,D21,D22,D23,D24,                                       DIAGSIG.2087
     *      D31(1,1),D31(1,2),                                                   DIAGSIG.2088
     *      D31(1,3),D31(1,4),                                                   DIAGSIG.2089
     *      D31(1,5),D31(1,6),                                                   DIAGSIG.2090
     *      D31(1,7),D31(1,8),                                                   DIAGSIG.2091
     *      D31(1,9),                                                            DIAGSIG.2092
     *      SIGMA,I1,J1,K1,PTOP,DS)                                              DIAGSIG.2093
         CALL EQUATE(D24,I1,J1,1,1,D31,I1,J1,1)                                  DIAGSIG.2094
         CALL WRITDAD(D31,'PSEALVL2',IDAD2D,I1,J1,1,                             DIAGSIG.2095
     *                I2DSTART,0)                                                DIAGSIG.2096
         I2DSTART=I2DSTART+1                                                     DIAGSIG.2097
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGSIG.2098
            UNIT(1:8)='mb      '                                                 DIAGSIG.2099
            UNITS(1:8)='mb      '                                                DIAGSIG.2100
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGSIG.2101
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,1)                        DIAGSIG.2102
            UNIT(1:8)='Pa      '                                                 DIAGSIG.2103
            UNITS(1:8)='Pa      '                                                DIAGSIG.2104
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGSIG.2105
            UNIT(1:8)='hPa     '                                                 DIAGSIG.2106
            UNITS(1:8)='hPa     '                                                DIAGSIG.2107
         ELSE                                                                    DIAGSIG.2108
            UNIT(1:8)='mb      '                                                 DIAGSIG.2109
            UNITS(1:8)='mb      '                                                DIAGSIG.2110
         END IF                                                                  DIAGSIG.2111
C                                                                                DIAGSIG.2112
      ELSE IF(FIELD(1:6).EQ.'PSLV3 '     ) THEN    ! SEA LEVEL PRESSURE          DIAGSIG.2113
         VARNAM(1:8)='SEA PRS3'                                                  DIAGSIG.2114
         CNT=CONT                                                                DIAGSIG.2115
         NPASS=ISMTHR                                                            DIAGSIG.2116
         ICRSDOT=1                                                               DIAGSIG.2117
         KDIM='2D'                                                               DIAGSIG.2118
         CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2119
     *      .FALSE.,FOUND)                                                       DIAGSIG.2120
         CALL READDAD(D21,'TERRAIN ',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2121
     *      .FALSE.,FOUND)                                                       DIAGSIG.2122
         CALL READDAD(D22,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2123
     *      .FALSE.,FOUND)                                                       DIAGSIG.2124
         CALL READDAD(D32,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2125
     *      DIAGS,FOUND)                                                         DIAGSIG.2126
         IF(.NOT.FOUND) CALL CLEAR(D32,I1,J1,K1)                                 DIAGSIG.2127
         CALL SEAPRS3(D22,D31,D32,D21,I1,J1,K1,PTOP,SIGMA,D24)                   DIAGSIG.2128
         CALL EQUATE(D24,I1,J1,1,1,D31,I1,J1,1)                                  DIAGSIG.2129
         CALL WRITDAD(D31,'PSEALVLC',IDAD2D,I1,J1,1,                             DIAGSIG.2130
     *                I2DSTART,0)                                                DIAGSIG.2131
         I2DSTART=I2DSTART+1                                                     DIAGSIG.2132
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGSIG.2133
            UNIT(1:8)='mb      '                                                 DIAGSIG.2134
            UNITS(1:8)='mb      '                                                DIAGSIG.2135
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGSIG.2136
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,1)                        DIAGSIG.2137
            UNIT(1:8)='Pa      '                                                 DIAGSIG.2138
            UNITS(1:8)='Pa      '                                                DIAGSIG.2139
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGSIG.2140
            UNIT(1:8)='hPa     '                                                 DIAGSIG.2141
            UNITS(1:8)='hPa     '                                                DIAGSIG.2142
         ELSE IF(UNIT(1:5).EQ.'inHg ') THEN                                      DIAGSIG.2143
            CALL SCALE(D31,'DIV ',33.86388640,I1,J1, 1,I1,J1,1)                  DIAGSIG.2144
            UNIT(1:8)='inHg    '                                                 DIAGSIG.2145
            UNITS(1:8)='inHg    '                                                DIAGSIG.2146
         ELSE                                                                    DIAGSIG.2147
            UNIT(1:8)='mb      '                                                 DIAGSIG.2148
            UNITS(1:8)='mb      '                                                DIAGSIG.2149
         END IF                                                                  DIAGSIG.2150
C                                                                                DIAGSIG.2151
      ELSE IF(FIELD(1:6).EQ.'PSLV4 '     ) THEN    ! SEA LEVEL PRESSURE          DIAGSIG.2152
         VARNAM(1:8)='SEA PRS4'                                                  DIAGSIG.2153
         CNT=CONT                                                                DIAGSIG.2154
         NPASS=ISMTHR                                                            DIAGSIG.2155
         ICRSDOT=1                                                               DIAGSIG.2156
         KDIM='2D'                                                               DIAGSIG.2157
         IF(IDRY.NE.1) THEN                                                      DIAGSIG.2158
            CALL READDAD(D33,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2159
     *         .FALSE.,FOUND)                                                    DIAGSIG.2160
            CALL READDAD(D32,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2161
     *         .FALSE.,FOUND)                                                    DIAGSIG.2162
            CALL TVIRT(D33,D32,I1,J1,K1,D31,I1,J1)                               DIAGSIG.2163
         ELSE IF(IDRY.EQ.1) THEN                                                 DIAGSIG.2164
            CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                       DIAGSIG.2165
     *         .FALSE.,FOUND)                                                    DIAGSIG.2166
         END IF                                                                  DIAGSIG.2167
         CALL READDAD(D21,'TERRAIN ',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2168
     *      .FALSE.,FOUND)                                                       DIAGSIG.2169
         CALL READDAD(D22,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2170
     *      .FALSE.,FOUND)                                                       DIAGSIG.2171
         CALL READDAD(D32,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2172
     *      DIAGS,FOUND)                                                         DIAGSIG.2173
         IF(.NOT.FOUND) CALL CLEAR(D32,I1,J1,K1)                                 DIAGSIG.2174
         CALL SEAPRS3(D22,D31,D32,D21,I1,J1,K1,PTOP,SIGMA,D24)                   DIAGSIG.2175
         CALL EQUATE(D24,I1,J1,1,1,D31,I1,J1,1)                                  DIAGSIG.2176
         CALL WRITDAD(D31,'PSEALVLC',IDAD2D,I1,J1,1,                             DIAGSIG.2177
     *                I2DSTART,0)                                                DIAGSIG.2178
         I2DSTART=I2DSTART+1                                                     DIAGSIG.2179
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGSIG.2180
            UNIT(1:8)='mb      '                                                 DIAGSIG.2181
            UNITS(1:8)='mb      '                                                DIAGSIG.2182
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGSIG.2183
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,1)                        DIAGSIG.2184
            UNIT(1:8)='Pa      '                                                 DIAGSIG.2185
            UNITS(1:8)='Pa      '                                                DIAGSIG.2186
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGSIG.2187
            UNIT(1:8)='hPa     '                                                 DIAGSIG.2188
            UNITS(1:8)='hPa     '                                                DIAGSIG.2189
         ELSE IF(UNIT(1:5).EQ.'inHg ') THEN                                      DIAGSIG.2190
            CALL SCALE(D31,'DIV ',33.86388640,I1,J1, 1,I1,J1,1)                  DIAGSIG.2191
            UNIT(1:8)='inHg    '                                                 DIAGSIG.2192
            UNITS(1:8)='inHg    '                                                DIAGSIG.2193
         ELSE                                                                    DIAGSIG.2194
            UNIT(1:8)='mb      '                                                 DIAGSIG.2195
            UNITS(1:8)='mb      '                                                DIAGSIG.2196
         END IF                                                                  DIAGSIG.2197
C                                                                                DIAGSIG.2198
      ELSE IF(FIELD(1:6).EQ.'PTEND '     ) THEN    ! PRESSURE TENDENCY           DIAGSIG.2199
         VARNAM(1:8)='PRS TEND'                                                  DIAGSIG.2200
         CNT=CONT                                                                DIAGSIG.2201
         NPASS=ISMTHR                                                            DIAGSIG.2202
         ICRSDOT=1                                                               DIAGSIG.2203
         KDIM='2D'                                                               DIAGSIG.2204
         CALL READDAD(D21,'PSFC 1  ',IMMHDR,I1,J1,1,1,                           DIAGSIG.2205
     *      DIAGS,FOUND)                                                         DIAGSIG.2206
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.2207
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2208
            IERROR=1                                                             DIAGSIG.2209
            RETURN                                                               DIAGSIG.2210
         END IF                                                                  DIAGSIG.2211
         CALL READDAD(D22,'PSFC 2  ',IMMHDR,I1,J1,1,1,                           DIAGSIG.2212
     *      .FALSE.,FOUND)                                                       DIAGSIG.2213
         CALL PRESTEND(D21,D22,I1,J1,D31,1)                                      DIAGSIG.2214
         CALL WRITDAD(D31,'PRS TEND',IDAD2D,I1,J1,1,                             DIAGSIG.2215
     *                I2DSTART,0)                                                DIAGSIG.2216
         I2DSTART=I2DSTART+1                                                     DIAGSIG.2217
         IF(UNIT(1:2).EQ.'mb') THEN                                              DIAGSIG.2218
            UNIT(1:8)='mb      '                                                 DIAGSIG.2219
            UNITS(1:8)='mb      '                                                DIAGSIG.2220
         ELSE IF(UNIT(1:2).EQ.'Pa') THEN                                         DIAGSIG.2221
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,1)                        DIAGSIG.2222
            UNIT(1:8)='Pa      '                                                 DIAGSIG.2223
            UNITS(1:8)='Pa      '                                                DIAGSIG.2224
         ELSE IF(UNIT(1:3).EQ.'hPa') THEN                                        DIAGSIG.2225
            UNIT(1:8)='hPa     '                                                 DIAGSIG.2226
            UNITS(1:8)='hPa     '                                                DIAGSIG.2227
         ELSE                                                                    DIAGSIG.2228
            UNIT(1:8)='mb      '                                                 DIAGSIG.2229
            UNITS(1:8)='mb      '                                                DIAGSIG.2230
         END IF                                                                  DIAGSIG.2231
C                                                                                DIAGSIG.2232
      ELSE IF(FIELD(1:3).EQ.'PV '     ) THEN    ! POTENTIAL VORTICITY            DIAGSIG.2233
         VARNAM(1:8)='PV      '                                                  DIAGSIG.2234
         CNT=CONT                                                                DIAGSIG.2235
         NPASS=ISMTHR                                                            DIAGSIG.2236
         ICRSDOT=1                                                               DIAGSIG.2237
         KDIM='3D'                                                               DIAGSIG.2238
         CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2239
     *      DIAGS,FOUND)                                                         DIAGSIG.2240
         IF(.NOT.FOUND) CALL CLEAR(D33,I1,J1,K1)                                 DIAGSIG.2241
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2242
     *      .FALSE.,FOUND)                                                       DIAGSIG.2243
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2244
     *      .FALSE.,FOUND)                                                       DIAGSIG.2245
         CALL THETAS(d32,D33,D21,SIGMA,PTOP,I1,J1,K1,D31)                        DIAGSIG.2246
         CALL WRITDAD(D31,'THETA   ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.2247
         I3DSTART=I3DSTART+1                                                     DIAGSIG.2248
c                                                                                DIAGSIG.2249
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2250
     *      .FALSE.,FOUND)                                                       DIAGSIG.2251
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2252
     *      .FALSE.,FOUND)                                                       DIAGSIG.2253
         CALL READDAD(D33,'THETA   ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2254
     *      .FALSE.,FOUND)                                                       DIAGSIG.2255
         CALL READDAD(D21,'MAPFACDT',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2256
     *      .FALSE.,FOUND)                                                       DIAGSIG.2257
         CALL READDAD(D22,'MAPFACCR',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2258
     *      .FALSE.,FOUND)                                                       DIAGSIG.2259
         CALL READDAD(D23,'CORIOLIS',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2260
     *      .FALSE.,FOUND)                                                       DIAGSIG.2261
         CALL READDAD(D24,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2262
     *      .FALSE.,FOUND)                                                       DIAGSIG.2263
         CALL READDAD(D34,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2264
     *       DIAGS,FOUND)                                                        DIAGSIG.2265
         IF(.NOT.FOUND) CALL CLEAR(D34,I1,J1,K1)                                 DIAGSIG.2266
         CALL PVS(D31,D32,D33,D34,D21,D22,D23,D24,SIGMA,PTOP,DS,                 DIAGSIG.2267
     *            I1,J1,K1,D31)                                                  DIAGSIG.2268
         CALL WRITDAD(D31,'PV      ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.2269
         I3DSTART=I3DSTART+1                                                     DIAGSIG.2270
         IF(UNIT(1:3).EQ.'PVU') THEN                                             DIAGSIG.2271
            UNIT(1:8)='PVU     '                                                 DIAGSIG.2272
            UNITS(1:8)='PVU     '                                                DIAGSIG.2273
         ELSE IF(UNIT(1:8).EQ.'Km/s^3Pa') THEN                                   DIAGSIG.2274
            UNIT(1:8)='Km/s^3Pa'                                                 DIAGSIG.2275
            UNITS(1:8)='Km/s^3Pa'                                                DIAGSIG.2276
         ELSE                                                                    DIAGSIG.2277
            UNIT(1:8)='PVU     '                                                 DIAGSIG.2278
            UNITS(1:8)='PVU     '                                                DIAGSIG.2279
         ENDIF                                                                   DIAGSIG.2280
C                                                                                DIAGSIG.2281
      ELSE IF(FIELD(1:3).EQ.'QV '                                                DIAGSIG.2282
     *   .OR. FIELD(1:2).EQ.'Q '     ) THEN     ! MIXING RATIO                   DIAGSIG.2283
         VARNAM(1:8)='QV      '                                                  DIAGSIG.2284
         CNT=CONT                                                                DIAGSIG.2285
         NPASS=ISMTHR                                                            DIAGSIG.2286
         ICRSDOT=1                                                               DIAGSIG.2287
         KDIM='3D'                                                               DIAGSIG.2288
         CALL READDAD(D31,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2289
     *      DIAGS,FOUND)                                                         DIAGSIG.2290
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.2291
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2292
            IERROR=1                                                             DIAGSIG.2293
            RETURN                                                               DIAGSIG.2294
         END IF                                                                  DIAGSIG.2295
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.2296
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.2297
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.2298
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.2299
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.2300
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.2301
            UNITS(1:8)='g/kg    '                                                DIAGSIG.2302
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.2303
            UNIT(1:8)='g/g     '                                                 DIAGSIG.2304
            UNITS(1:8)='g/g     '                                                DIAGSIG.2305
         ELSE                                                                    DIAGSIG.2306
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.2307
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.2308
         END IF                                                                  DIAGSIG.2309
C                                                                                DIAGSIG.2310
      ELSE IF(FIELD(1:4).EQ.'RAIN'    ) THEN    ! ONE OF RAIN FIELDS             DIAGSIG.2311
         IF(FIELD(5:5).EQ.'N') THEN                                              DIAGSIG.2312
            VARNAM(1:8)='RAIN NON'                                               DIAGSIG.2313
            CALL READDAD(D31,'RAIN NON',IDAD2D,I1,J1,1,0,                        DIAGSIG.2314
     *      DIAGS,FOUND)                                                         DIAGSIG.2315
         ELSE IF(FIELD(5:5).EQ.'C') THEN                                         DIAGSIG.2316
            VARNAM(1:8)='RAIN CON'                                               DIAGSIG.2317
            CALL READDAD(D31,'RAIN CON',IDAD2D,I1,J1,1,0,                        DIAGSIG.2318
     *      DIAGS,FOUND)                                                         DIAGSIG.2319
         ELSE IF(FIELD(5:5).EQ.'T') THEN                                         DIAGSIG.2320
            VARNAM(1:8)='RAIN TOT'                                               DIAGSIG.2321
            CALL READDAD(D31,'RAIN TOT',IDAD2D,I1,J1,1,0,                        DIAGSIG.2322
     *      DIAGS,FOUND)                                                         DIAGSIG.2323
         END IF                                                                  DIAGSIG.2324
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.2325
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2326
            IERROR=1                                                             DIAGSIG.2327
            RETURN                                                               DIAGSIG.2328
         END IF                                                                  DIAGSIG.2329
         CNT=CONT                                                                DIAGSIG.2330
         NPASS=ISMTHR                                                            DIAGSIG.2331
         ICRSDOT=1                                                               DIAGSIG.2332
         KDIM='2D'                                                               DIAGSIG.2333
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.2334
            UNIT(1:8)='cm      '                                                 DIAGSIG.2335
            UNITS(1:8)='cm      '                                                DIAGSIG.2336
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.2337
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.2338
            UNIT(1:8)='mm      '                                                 DIAGSIG.2339
            UNITS(1:8)='mm      '                                                DIAGSIG.2340
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.2341
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.2342
            UNIT(1:8)='in      '                                                 DIAGSIG.2343
            UNITS(1:8)='in      '                                                DIAGSIG.2344
         ELSE                                                                    DIAGSIG.2345
            UNIT(1:8)='cm      '                                                 DIAGSIG.2346
            UNITS(1:8)='cm      '                                                DIAGSIG.2347
         END IF                                                                  DIAGSIG.2348
C                                                                                DIAGSIG.2349
      ELSE IF((FIELD(1:7).EQ.'PRECIPT').AND.                                     DIAGSIG.2350
     *        (FIELD(8:8).NE.' '))  THEN    ! RAIN TENDENCY                      DIAGSIG.2351
         IF(FIELD(8:8).EQ.'N') THEN                                              DIAGSIG.2352
            VARNAM(1:8)='TEND RNN'                                               DIAGSIG.2353
            CALL READDAD(D21,'RAINN 1 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2354
     *      DIAGS,FOUND)                                                         DIAGSIG.2355
            IF(.NOT.FOUND) THEN                                                  DIAGSIG.2356
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGSIG.2357
               IERROR=1                                                          DIAGSIG.2358
               RETURN                                                            DIAGSIG.2359
            END IF                                                               DIAGSIG.2360
            CALL READDAD(D22,'RAINN 2 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2361
     *      DIAGS,FOUND)                                                         DIAGSIG.2362
         ELSE IF(FIELD(8:8).EQ.'C') THEN                                         DIAGSIG.2363
            VARNAM(1:8)='TEND RNC'                                               DIAGSIG.2364
            CALL READDAD(D21,'RAINC 1 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2365
     *      DIAGS,FOUND)                                                         DIAGSIG.2366
            IF(.NOT.FOUND) THEN                                                  DIAGSIG.2367
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGSIG.2368
               IERROR=1                                                          DIAGSIG.2369
               RETURN                                                            DIAGSIG.2370
            END IF                                                               DIAGSIG.2371
            CALL READDAD(D22,'RAINC 2 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2372
     *      DIAGS,FOUND)                                                         DIAGSIG.2373
         ELSE IF(FIELD(8:8).EQ.'T') THEN                                         DIAGSIG.2374
            VARNAM(1:8)='TEND RNT'                                               DIAGSIG.2375
            CALL READDAD(D21,'RAINT 1 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2376
     *      DIAGS,FOUND)                                                         DIAGSIG.2377
            IF(.NOT.FOUND) THEN                                                  DIAGSIG.2378
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGSIG.2379
               IERROR=1                                                          DIAGSIG.2380
               RETURN                                                            DIAGSIG.2381
            END IF                                                               DIAGSIG.2382
            CALL READDAD(D22,'RAINT 2 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2383
     *      DIAGS,FOUND)                                                         DIAGSIG.2384
         ELSE                                                                    DIAGSIG.2385
            PRINT *,'OOPS ON THE RAIN FIELD, N, C, OR T'                         DIAGSIG.2386
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2387
            IERROR=1                                                             DIAGSIG.2388
            RETURN                                                               DIAGSIG.2389
         END IF                                                                  DIAGSIG.2390
         CNT=CONT                                                                DIAGSIG.2391
         NPASS=ISMTHR                                                            DIAGSIG.2392
         ICRSDOT=1                                                               DIAGSIG.2393
         KDIM='2D'                                                               DIAGSIG.2394
         CALL PRESTEND(D21,D22,I1,J1,D31,1)                                      DIAGSIG.2395
         CALL WRITDAD(D31,VARNAME,IDAD2D,I1,J1,1,                                DIAGSIG.2396
     *             I2DSTART,0)                                                   DIAGSIG.2397
         I2DSTART=I2DSTART+1                                                     DIAGSIG.2398
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.2399
            UNIT(1:8)='cm      '                                                 DIAGSIG.2400
            UNITS(1:8)='cm      '                                                DIAGSIG.2401
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.2402
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.2403
            UNIT(1:8)='mm      '                                                 DIAGSIG.2404
            UNITS(1:8)='mm      '                                                DIAGSIG.2405
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.2406
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.2407
            UNIT(1:8)='in      '                                                 DIAGSIG.2408
            UNITS(1:8)='in      '                                                DIAGSIG.2409
         ELSE                                                                    DIAGSIG.2410
            UNIT(1:8)='cm      '                                                 DIAGSIG.2411
            UNITS(1:8)='cm      '                                                DIAGSIG.2412
         END IF                                                                  DIAGSIG.2413
C                                                                                DIAGSIG.2414
      ELSE IF(FIELD(1:6).EQ.'PRECIP') THEN    ! ONE OF RAIN FIELDS               DIAGSIG.2415
         IF(FIELD(7:7).EQ.'N') THEN                                              DIAGSIG.2416
            VARNAM(1:8)='RAIN NON'                                               DIAGSIG.2417
            CALL READDAD(D31,'RAIN NON',IDAD2D,I1,J1,1,0,                        DIAGSIG.2418
     *      DIAGS,FOUND)                                                         DIAGSIG.2419
         ELSE IF(FIELD(7:7).EQ.'C') THEN                                         DIAGSIG.2420
            VARNAM(1:8)='RAIN CON'                                               DIAGSIG.2421
            CALL READDAD(D31,'RAIN CON',IDAD2D,I1,J1,1,0,                        DIAGSIG.2422
     *      DIAGS,FOUND)                                                         DIAGSIG.2423
         ELSE IF(FIELD(7:7).EQ.'T') THEN                                         DIAGSIG.2424
            VARNAM(1:8)='RAIN TOT'                                               DIAGSIG.2425
            CALL READDAD(D31,'RAIN TOT',IDAD2D,I1,J1,1,0,                        DIAGSIG.2426
     *      DIAGS,FOUND)                                                         DIAGSIG.2427
         ELSE                                                                    DIAGSIG.2428
            PRINT *,'OOPS ON THE RAIN FIELD, N, C, OR T'                         DIAGSIG.2429
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2430
            IERROR=1                                                             DIAGSIG.2431
            RETURN                                                               DIAGSIG.2432
         END IF                                                                  DIAGSIG.2433
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.2434
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2435
            IERROR=1                                                             DIAGSIG.2436
            RETURN                                                               DIAGSIG.2437
         END IF                                                                  DIAGSIG.2438
         CNT=CONT                                                                DIAGSIG.2439
         NPASS=ISMTHR                                                            DIAGSIG.2440
         ICRSDOT=1                                                               DIAGSIG.2441
         KDIM='2D'                                                               DIAGSIG.2442
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.2443
            UNIT(1:8)='cm      '                                                 DIAGSIG.2444
            UNITS(1:8)='cm      '                                                DIAGSIG.2445
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.2446
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.2447
            UNIT(1:8)='mm      '                                                 DIAGSIG.2448
            UNITS(1:8)='mm      '                                                DIAGSIG.2449
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.2450
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.2451
            UNIT(1:8)='in      '                                                 DIAGSIG.2452
            UNITS(1:8)='in      '                                                DIAGSIG.2453
         ELSE                                                                    DIAGSIG.2454
            UNIT(1:8)='cm      '                                                 DIAGSIG.2455
            UNITS(1:8)='cm      '                                                DIAGSIG.2456
         END IF                                                                  DIAGSIG.2457
C                                                                                DIAGSIG.2458
      ELSE IF(FIELD(1:3).EQ.'RH '     ) THEN    ! RELATIVE HUMIDITY              DIAGSIG.2459
         VARNAM(1:8)='RH      '                                                  DIAGSIG.2460
         CNT=CONT                                                                DIAGSIG.2461
         NPASS=ISMTHR                                                            DIAGSIG.2462
         ICRSDOT=1                                                               DIAGSIG.2463
         KDIM='3D'                                                               DIAGSIG.2464
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2465
     *      .FALSE.,FOUND)                                                       DIAGSIG.2466
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2467
     *      DIAGS,FOUND)                                                         DIAGSIG.2468
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.2469
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2470
            IERROR=1                                                             DIAGSIG.2471
            RETURN                                                               DIAGSIG.2472
         END IF                                                                  DIAGSIG.2473
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2474
     *      .FALSE.,FOUND)                                                       DIAGSIG.2475
         CALL READDAD(D31,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2476
     *       DIAGS,FOUND)                                                        DIAGSIG.2477
         IF(.NOT.FOUND) CALL CLEAR(D31,I1,J1,K1)                                 DIAGSIG.2478
      CALL QTORH(D33,D32,D31,SIGMA,D21,PTOP,I1,J1,K1,D31)                        DIAGSIG.2479
         CALL WRITDAD(D31,'RH      ',IDAD3D,I1,J1,K1,                            DIAGSIG.2480
     *                I3DSTART,0)                                                DIAGSIG.2481
         I3DSTART=I3DSTART+1                                                     DIAGSIG.2482
         IF(UNIT(1:1).EQ.'%') THEN                                               DIAGSIG.2483
            UNIT(1:8)='%       '                                                 DIAGSIG.2484
            UNITS(1:8)='%       '                                                DIAGSIG.2485
         ELSE                                                                    DIAGSIG.2486
            UNIT(1:8)='%       '                                                 DIAGSIG.2487
            UNITS(1:8)='%       '                                                DIAGSIG.2488
         END IF                                                                  DIAGSIG.2489
C                                                                                DIAGSIG.2490
      ELSE IF(FIELD(1:4).EQ.'RNW '    ) THEN    ! RAIN WATER                     DIAGSIG.2491
         VARNAM(1:8)='RN WATER'                                                  DIAGSIG.2492
         CNT=CONT                                                                DIAGSIG.2493
         NPASS=ISMTHR                                                            DIAGSIG.2494
         ICRSDOT=1                                                               DIAGSIG.2495
         KDIM='3D'                                                               DIAGSIG.2496
         CALL READDAD(D31,'RNW     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2497
     *      DIAGS,FOUND)                                                         DIAGSIG.2498
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.2499
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2500
            IERROR=1                                                             DIAGSIG.2501
            RETURN                                                               DIAGSIG.2502
         END IF                                                                  DIAGSIG.2503
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           DIAGSIG.2504
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.2505
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.2506
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       DIAGSIG.2507
            CALL SCALE(D31,'MULT',1000.,I1,J1,K1,I1,J1,1)                        DIAGSIG.2508
            UNIT(1:8)='g/kg    '                                                 DIAGSIG.2509
            UNITS(1:8)='g/kg    '                                                DIAGSIG.2510
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        DIAGSIG.2511
            UNIT(1:8)='g/g     '                                                 DIAGSIG.2512
            UNITS(1:8)='g/g     '                                                DIAGSIG.2513
         ELSE IF(UNIT(1:5).EQ.'mg/kg') THEN                                      DIAGSIG.2514
            CALL SCALE(D31,'MULT',1000000.,I1,J1,K1,I1,J1,1)                     DIAGSIG.2515
            UNIT(1:8)='mg/kg   '                                                 DIAGSIG.2516
            UNITS(1:8)='mg/kg   '                                                DIAGSIG.2517
         ELSE                                                                    DIAGSIG.2518
            UNIT(1:8)='kg/kg   '                                                 DIAGSIG.2519
            UNITS(1:8)='kg/kg   '                                                DIAGSIG.2520
         END IF                                                                  DIAGSIG.2521
C                                                                                DIAGSIG.2522
      ELSE IF(FIELD(1:5).EQ.'RTEND'     ) THEN    ! RAIN TENDENCY                DIAGSIG.2523
         IF(FIELD(6:6).EQ.'N') THEN                                              DIAGSIG.2524
            VARNAM(1:8)='TEND RNN'                                               DIAGSIG.2525
            CALL READDAD(D21,'RAINN 1 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2526
     *      DIAGS,FOUND)                                                         DIAGSIG.2527
            IF(.NOT.FOUND) THEN                                                  DIAGSIG.2528
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGSIG.2529
               IERROR=1                                                          DIAGSIG.2530
               RETURN                                                            DIAGSIG.2531
            END IF                                                               DIAGSIG.2532
            CALL READDAD(D22,'RAINN 2 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2533
     *      DIAGS,FOUND)                                                         DIAGSIG.2534
         ELSE IF(FIELD(6:6).EQ.'C') THEN                                         DIAGSIG.2535
            VARNAM(1:8)='TEND RNC'                                               DIAGSIG.2536
            CALL READDAD(D21,'RAINC 1 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2537
     *      DIAGS,FOUND)                                                         DIAGSIG.2538
            IF(.NOT.FOUND) THEN                                                  DIAGSIG.2539
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGSIG.2540
               IERROR=1                                                          DIAGSIG.2541
               RETURN                                                            DIAGSIG.2542
            END IF                                                               DIAGSIG.2543
            CALL READDAD(D22,'RAINC 2 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2544
     *      DIAGS,FOUND)                                                         DIAGSIG.2545
         ELSE IF(FIELD(6:6).EQ.'T') THEN                                         DIAGSIG.2546
            VARNAM(1:8)='TEND RNT'                                               DIAGSIG.2547
            CALL READDAD(D21,'RAINT 1 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2548
     *      DIAGS,FOUND)                                                         DIAGSIG.2549
            IF(.NOT.FOUND) THEN                                                  DIAGSIG.2550
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGSIG.2551
               IERROR=1                                                          DIAGSIG.2552
               RETURN                                                            DIAGSIG.2553
            END IF                                                               DIAGSIG.2554
            CALL READDAD(D22,'RAINT 2 ',IMMHDR,I1,J1,1,1,                        DIAGSIG.2555
     *      DIAGS,FOUND)                                                         DIAGSIG.2556
         END IF                                                                  DIAGSIG.2557
         CNT=CONT                                                                DIAGSIG.2558
         NPASS=ISMTHR                                                            DIAGSIG.2559
         ICRSDOT=1                                                               DIAGSIG.2560
         KDIM='2D'                                                               DIAGSIG.2561
         CALL PRESTEND(D21,D22,I1,J1,D31,1)                                      DIAGSIG.2562
         CALL WRITDAD(D31,VARNAME,IDAD2D,I1,J1,1,                                DIAGSIG.2563
     *             I2DSTART,0)                                                   DIAGSIG.2564
         I2DSTART=I2DSTART+1                                                     DIAGSIG.2565
         IF(UNIT(1:2).EQ.'cm') THEN                                              DIAGSIG.2566
            UNIT(1:8)='cm      '                                                 DIAGSIG.2567
            UNITS(1:8)='cm      '                                                DIAGSIG.2568
         ELSE IF(UNIT(1:2).EQ.'mm') THEN                                         DIAGSIG.2569
            CALL SCALE(D31,'MULT',10.,I1,J1,1,I1,J1,1)                           DIAGSIG.2570
            UNIT(1:8)='mm      '                                                 DIAGSIG.2571
            UNITS(1:8)='mm      '                                                DIAGSIG.2572
         ELSE IF(UNIT(1:2).EQ.'in') THEN                                         DIAGSIG.2573
            CALL SCALE(D31,'DIV ',2.54,I1,J1,1,I1,J1,1)                          DIAGSIG.2574
            UNIT(1:8)='in      '                                                 DIAGSIG.2575
            UNITS(1:8)='in      '                                                DIAGSIG.2576
         ELSE                                                                    DIAGSIG.2577
            UNIT(1:8)='cm      '                                                 DIAGSIG.2578
            UNITS(1:8)='cm      '                                                DIAGSIG.2579
         END IF                                                                  DIAGSIG.2580
C                                                                                DIAGSIG.2581
      ELSE IF(FIELD(1:2).EQ.'T '      ) THEN    ! TEMPERATURE                    DIAGSIG.2582
         VARNAM(1:8)='T       '                                                  DIAGSIG.2583
         CNT=CONT                                                                DIAGSIG.2584
         NPASS=ISMTHR                                                            DIAGSIG.2585
         ICRSDOT=1                                                               DIAGSIG.2586
         KDIM='3D'                                                               DIAGSIG.2587
         CALL READDAD(D31,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2588
     *      .FALSE.,FOUND)                                                       DIAGSIG.2589
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGSIG.2590
            UNIT(1:8)='K       '                                                 DIAGSIG.2591
            UNITS(1:8)='K       '                                                DIAGSIG.2592
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGSIG.2593
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGSIG.2594
            UNIT(1:8)='C       '                                                 DIAGSIG.2595
            UNITS(1:8)='C       '                                                DIAGSIG.2596
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGSIG.2597
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGSIG.2598
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGSIG.2599
            UNIT(1:8)='F       '                                                 DIAGSIG.2600
            UNITS(1:8)='F       '                                                DIAGSIG.2601
         ELSE                                                                    DIAGSIG.2602
            UNIT(1:8)='K       '                                                 DIAGSIG.2603
            UNITS(1:8)='K       '                                                DIAGSIG.2604
         END IF                                                                  DIAGSIG.2605
C                                                                                DIAGSIG.2606
      ELSE IF((FIELD(1:3).EQ.'TD '    ) .OR.        ! DEW POINT                  DIAGSIG.2607
     *        (FIELD(1:4).EQ.'TDD '   )) THEN       ! DEW POINT DEPR             DIAGSIG.2608
         IF (FIELD(1:3).EQ.'TD ') THEN                                           DIAGSIG.2609
            IDEW=1                                                               DIAGSIG.2610
            VARNAM(1:8)='T DEW PT'                                               DIAGSIG.2611
         ELSE IF (FIELD(1:4).EQ.'TDD ') THEN                                     DIAGSIG.2612
            IDEW=0                                                               DIAGSIG.2613
            VARNAM(1:8)='T DEW DP'                                               DIAGSIG.2614
         END IF                                                                  DIAGSIG.2615
         CNT=CONT                                                                DIAGSIG.2616
         NPASS=ISMTHR                                                            DIAGSIG.2617
         ICRSDOT=1                                                               DIAGSIG.2618
         KDIM='3D'                                                               DIAGSIG.2619
         IF (BHI(  1,1).EQ.11 .AND. BHI(  3,13).EQ.1) THEN                       DIAGSIG.2620
            CALL CLEAR(D33,I1,J1,K1)                                             DIAGSIG.2621
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGSIG.2622
     *                I3DSTART,0)                                                DIAGSIG.2623
            I3DSTART=I3DSTART+1                                                  DIAGSIG.2624
         ENDIF                                                                   DIAGSIG.2625
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2626
     *      .FALSE.,FOUND)                                                       DIAGSIG.2627
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2628
     *      .FALSE.,FOUND)                                                       DIAGSIG.2629
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2630
     *      .FALSE.,FOUND)                                                       DIAGSIG.2631
         CALL READDAD(D31,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2632
     *       DIAGS,FOUND)                                                        DIAGSIG.2633
         IF(.NOT.FOUND) CALL CLEAR(D31,I1,J1,K1)                                 DIAGSIG.2634
      CALL DEWPOINS(D32,D33,D31,SIGMA,D21,PTOP,IDEW,I1,J1,K1,D31)                DIAGSIG.2635
         IF(IDEW.EQ.1) THEN                                                      DIAGSIG.2636
            CALL WRITDAD(D31,'TD      ',IDAD3D,I1,J1,K1,                         DIAGSIG.2637
     *                  I3DSTART,0)                                              DIAGSIG.2638
         ELSE IF(IDEW.EQ.0) THEN                                                 DIAGSIG.2639
            CALL WRITDAD(D31,'TDD     ',IDAD3D,I1,J1,K1,                         DIAGSIG.2640
     *                  I3DSTART,0)                                              DIAGSIG.2641
         END IF                                                                  DIAGSIG.2642
         I3DSTART=I3DSTART+1                                                     DIAGSIG.2643
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGSIG.2644
            UNIT(1:8)='K       '                                                 DIAGSIG.2645
            UNITS(1:8)='K       '                                                DIAGSIG.2646
         ELSE IF((UNIT(1:1).EQ.'C').AND.(IDEW.EQ.1)) THEN                        DIAGSIG.2647
            CALL SCALE(D31,'SUB ',273.16,I1,J1,K1,I1,J1,1)                       DIAGSIG.2648
            UNIT(1:8)='C       '                                                 DIAGSIG.2649
            UNITS(1:8)='C       '                                                DIAGSIG.2650
         ELSE IF((UNIT(1:1).EQ.'C').AND.(IDEW.EQ.0)) THEN                        DIAGSIG.2651
            UNIT(1:8)='C       '                                                 DIAGSIG.2652
            UNITS(1:8)='C       '                                                DIAGSIG.2653
         ELSE IF((UNIT(1:1).EQ.'F').AND.(IDEW.EQ.1)) THEN                        DIAGSIG.2654
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGSIG.2655
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGSIG.2656
            UNIT(1:8)='F       '                                                 DIAGSIG.2657
            UNITS(1:8)='F       '                                                DIAGSIG.2658
         ELSE IF((UNIT(1:1).EQ.'F').AND.(IDEW.EQ.0)) THEN                        DIAGSIG.2659
            CALL SCALE(D31,'MULT',1.8,I1,J1,K1,I1,J1,1)                          DIAGSIG.2660
            UNIT(1:8)='F       '                                                 DIAGSIG.2661
            UNITS(1:8)='F       '                                                DIAGSIG.2662
         ELSE                                                                    DIAGSIG.2663
            UNIT(1:8)='K       '                                                 DIAGSIG.2664
            UNITS(1:8)='K       '                                                DIAGSIG.2665
         ENDIF                                                                   DIAGSIG.2666
C                                                                                DIAGSIG.2667
      ELSE IF(FIELD(1:6).EQ.'THETA '     ) THEN    ! POTENTIAL TEMP              DIAGSIG.2668
         VARNAM(1:8)='THETA   '                                                  DIAGSIG.2669
         CNT=CONT                                                                DIAGSIG.2670
         NPASS=ISMTHR                                                            DIAGSIG.2671
         ICRSDOT=1                                                               DIAGSIG.2672
         KDIM='3D'                                                               DIAGSIG.2673
         CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2674
     *      DIAGS,FOUND)                                                         DIAGSIG.2675
         IF(.NOT.FOUND) CALL CLEAR(D33,I1,J1,K1)                                 DIAGSIG.2676
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2677
     *      .FALSE.,FOUND)                                                       DIAGSIG.2678
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2679
     *      .FALSE.,FOUND)                                                       DIAGSIG.2680
         CALL THETAS(d32,D33,D21,SIGMA,PTOP,I1,J1,K1,D31)                        DIAGSIG.2681
         CALL WRITDAD(D31,'THETA   ',IDAD3D,I1,J1,K1,                            DIAGSIG.2682
     *               I3DSTART,0)                                                 DIAGSIG.2683
         I3DSTART=I3DSTART+1                                                     DIAGSIG.2684
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGSIG.2685
            UNIT(1:8)='K       '                                                 DIAGSIG.2686
            UNITS(1:8)='K       '                                                DIAGSIG.2687
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGSIG.2688
            CALL SCALE(D31,'SUB ',273.16,I1,J1,K1,I1,J1,1)                       DIAGSIG.2689
            UNIT(1:8)='C       '                                                 DIAGSIG.2690
            UNITS(1:8)='C       '                                                DIAGSIG.2691
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGSIG.2692
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGSIG.2693
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGSIG.2694
            UNIT(1:8)='F       '                                                 DIAGSIG.2695
            UNITS(1:8)='F       '                                                DIAGSIG.2696
         ELSE                                                                    DIAGSIG.2697
            UNIT(1:8)='K       '                                                 DIAGSIG.2698
            UNITS(1:8)='K       '                                                DIAGSIG.2699
         ENDIF                                                                   DIAGSIG.2700
C                                                                                DIAGSIG.2701
      ELSE IF(FIELD(1:7).EQ.'THETAE '    ) THEN    ! EQUIV POT TEMP              DIAGSIG.2702
         VARNAM(1:8)='THETAE  '                                                  DIAGSIG.2703
         CNT=CONT                                                                DIAGSIG.2704
         NPASS=ISMTHR                                                            DIAGSIG.2705
         ICRSDOT=1                                                               DIAGSIG.2706
         KDIM='3D'                                                               DIAGSIG.2707
         IF (BHI(  1,1).EQ.11 .AND. BHI(  3,13).EQ.1) THEN                       DIAGSIG.2708
            CALL CLEAR(D33,I1,J1,K1)                                             DIAGSIG.2709
            CALL WRITDAD(D33,'Q       ',IDAD3D,I1,J1,K1,                         DIAGSIG.2710
     *                I3DSTART,0)                                                DIAGSIG.2711
            I3DSTART=I3DSTART+1                                                  DIAGSIG.2712
         ENDIF                                                                   DIAGSIG.2713
         CALL READDAD(D32,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2714
     *      .FALSE.,FOUND)                                                       DIAGSIG.2715
         CALL READDAD(D33,'Q       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2716
     *      .FALSE.,FOUND)                                                       DIAGSIG.2717
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSIG.2718
     *      .FALSE.,FOUND)                                                       DIAGSIG.2719
c dave                                                                           DIAGSIG.2720
         CALL READDAD(D31,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2721
     *      DIAGS,FOUND)                                                         DIAGSIG.2722
         IF(.NOT.FOUND) CALL CLEAR(D31,i1,j1,k1)                                 DIAGSIG.2723
         CALL THETAES(D32,D33,D31,D21,SIGMA,PTOP,I1,J1,K1,D31)                   DIAGSIG.2724
         CALL WRITDAD(D31,'THETAE  ',IDAD3D,I1,J1,K1,                            DIAGSIG.2725
     *               I3DSTART,0)                                                 DIAGSIG.2726
         I3DSTART=I3DSTART+1                                                     DIAGSIG.2727
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGSIG.2728
            UNIT(1:8)='K       '                                                 DIAGSIG.2729
            UNITS(1:8)='K       '                                                DIAGSIG.2730
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGSIG.2731
            CALL SCALE(D31,'SUB ',273.16,I1,J1,K1,I1,J1,1)                       DIAGSIG.2732
            UNIT(1:8)='C       '                                                 DIAGSIG.2733
            UNITS(1:8)='C       '                                                DIAGSIG.2734
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGSIG.2735
            CALL KEL2CEL(D31,I1,J1,K1)                                           DIAGSIG.2736
            CALL CEL2F  (D31,I1,J1,K1)                                           DIAGSIG.2737
            UNIT(1:8)='F       '                                                 DIAGSIG.2738
            UNITS(1:8)='F       '                                                DIAGSIG.2739
         ELSE                                                                    DIAGSIG.2740
            UNIT(1:8)='K       '                                                 DIAGSIG.2741
            UNITS(1:8)='K       '                                                DIAGSIG.2742
         ENDIF                                                                   DIAGSIG.2743
C                                                                                DIAGSIG.2744
      ELSE IF(FIELD(1:4).EQ.'TER '      ) THEN    ! TERRAIN                      DIAGSIG.2745
         VARNAM(1:8)='TERRAIN '                                                  DIAGSIG.2746
         CNT=CONT                                                                DIAGSIG.2747
         NPASS=ISMTHR                                                            DIAGSIG.2748
         ICRSDOT=1                                                               DIAGSIG.2749
         KDIM='2D'                                                               DIAGSIG.2750
         CALL READDAD(D31,'TERRAIN ',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2751
     *      .FALSE.,FOUND)                                                       DIAGSIG.2752
         IF(UNIT(1:1).EQ.'m') THEN                                               DIAGSIG.2753
            UNIT(1:8)='m       '                                                 DIAGSIG.2754
            UNITS(1:8)='m       '                                                DIAGSIG.2755
         ELSE IF(UNIT(1:2).EQ.'ft') THEN                                         DIAGSIG.2756
            CALL M2FT(D31,I1,J1, 1,1)                                            DIAGSIG.2757
            UNIT(1:8)='ft      '                                                 DIAGSIG.2758
            UNITS(1:8)='ft      '                                                DIAGSIG.2759
         ELSE                                                                    DIAGSIG.2760
            UNIT(1:8)='m       '                                                 DIAGSIG.2761
            UNITS(1:8)='m       '                                                DIAGSIG.2762
         END IF                                                                  DIAGSIG.2763
C                                                                                DIAGSIG.2764
      ELSE IF(FIELD(1:5).EQ.'LNDUS'  ) THEN  ! LAND USE                          DIAGSIG.2765
         VARNAM(1:8)='LAND USE'                                                  DIAGSIG.2766
         CNT=CONT                                                                DIAGSIG.2767
         NPASS=ISMTHR                                                            DIAGSIG.2768
         ICRSDOT=1                                                               DIAGSIG.2769
         KDIM='2D'                                                               DIAGSIG.2770
            CALL READDAD(D31,'LAND USE',IMMHDR,I1,J1, 1, 1,                      DIAGSIG.2771
     *           .FALSE.,FOUND)                                                  DIAGSIG.2772
            UNIT(1:8)='category'                                                 DIAGSIG.2773
            UNITS(1:8)='category'                                                DIAGSIG.2774
                                                                                 DIAGSIG.2775
      ELSE IF(FIELD(1:4).EQ.'TGD '    ) THEN    ! GROUND TEMPERATURE             DIAGSIG.2776
         VARNAM(1:8)='GROUND T'                                                  DIAGSIG.2777
         CNT=CONT                                                                DIAGSIG.2778
         NPASS=ISMTHR                                                            DIAGSIG.2779
         ICRSDOT=1                                                               DIAGSIG.2780
         KDIM='2D'                                                               DIAGSIG.2781
         CALL READDAD(D31,'GROUND T',IDAD2D,I1,J1,1,0,                           DIAGSIG.2782
     *      DIAGS,FOUND)                                                         DIAGSIG.2783
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.2784
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2785
            IERROR=1                                                             DIAGSIG.2786
            RETURN                                                               DIAGSIG.2787
         END IF                                                                  DIAGSIG.2788
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGSIG.2789
            UNIT(1:8)='K       '                                                 DIAGSIG.2790
            UNITS(1:8)='K       '                                                DIAGSIG.2791
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGSIG.2792
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGSIG.2793
            UNIT(1:8)='C       '                                                 DIAGSIG.2794
            UNITS(1:8)='C       '                                                DIAGSIG.2795
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGSIG.2796
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGSIG.2797
            CALL CEL2F  (D31,I1,J1,1)                                            DIAGSIG.2798
            UNIT(1:8)='F       '                                                 DIAGSIG.2799
            UNITS(1:8)='F       '                                                DIAGSIG.2800
         ELSE                                                                    DIAGSIG.2801
            UNIT(1:8)='K       '                                                 DIAGSIG.2802
            UNITS(1:8)='K       '                                                DIAGSIG.2803
         END IF                                                                  DIAGSIG.2804
C                                                                                DIAGSIG.2805
      ELSE IF(FIELD(1:4).EQ.'VAB '    ) THEN    ! ABSOLUTE VORTICITY             DIAGSIG.2806
         VARNAM(1:8)='VORT ABS'                                                  DIAGSIG.2807
         CNT=CONT                                                                DIAGSIG.2808
         NPASS=ISMTHR                                                            DIAGSIG.2809
         ICRSDOT=1                                                               DIAGSIG.2810
         KDIM='3D'                                                               DIAGSIG.2811
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2812
     *      .FALSE.,FOUND)                                                       DIAGSIG.2813
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2814
     *      .FALSE.,FOUND)                                                       DIAGSIG.2815
         CALL READDAD(D21,'MAPFACDT',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2816
     *      .FALSE.,FOUND)                                                       DIAGSIG.2817
         CALL READDAD(D22,'MAPFACCR',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2818
     *      .FALSE.,FOUND)                                                       DIAGSIG.2819
         CALL READDAD(D23,'CORIOLIS',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2820
     *      .FALSE.,FOUND)                                                       DIAGSIG.2821
         CALL VORTABS(D33,D32,D23,D21,D22,I1,J1,K1,DS,D31)                       DIAGSIG.2822
         CALL WRITDAD(D31,'VAB     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.2823
         I3DSTART=I3DSTART+1                                                     DIAGSIG.2824
         IF(UNIT(1:3).EQ.'1/s') THEN                                             DIAGSIG.2825
            UNIT(1:8)='1/s     '                                                 DIAGSIG.2826
            UNITS(1:8)='1/s     '                                                DIAGSIG.2827
         ELSE IF(UNIT(1:7).EQ.'10**5/s') THEN                                    DIAGSIG.2828
            CALL SCALE(D31,'MULT',100000.,I1,J1,K1,I1,J1,1)                      DIAGSIG.2829
            UNIT(1:8)='10**5/s '                                                 DIAGSIG.2830
            UNITS(1:8)='10**5/s '                                                DIAGSIG.2831
         ELSE                                                                    DIAGSIG.2832
            UNIT(1:8)='1/s     '                                                 DIAGSIG.2833
            UNITS(1:8)='1/s     '                                                DIAGSIG.2834
         END IF                                                                  DIAGSIG.2835
C                                                                                DIAGSIG.2836
      ELSE IF(FIELD(1:4).EQ.'VOR '    ) THEN    ! VORTICITY                      DIAGSIG.2837
         VARNAM(1:8)='VORT    '                                                  DIAGSIG.2838
         CNT=CONT                                                                DIAGSIG.2839
         NPASS=ISMTHR                                                            DIAGSIG.2840
         ICRSDOT=1                                                               DIAGSIG.2841
         KDIM='3D'                                                               DIAGSIG.2842
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2843
     *      .FALSE.,FOUND)                                                       DIAGSIG.2844
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2845
     *      .FALSE.,FOUND)                                                       DIAGSIG.2846
         CALL READDAD(D21,'MAPFACDT',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2847
     *      .FALSE.,FOUND)                                                       DIAGSIG.2848
         CALL READDAD(D22,'MAPFACCR',IMMHDR,I1,J1, 1,1,                          DIAGSIG.2849
     *      .FALSE.,FOUND)                                                       DIAGSIG.2850
         CALL VOR(D33,D32,D21,D22,I1,J1,K1,DS,D31)                               DIAGSIG.2851
         CALL WRITDAD(D31,'VOR     ',IDAD3D,I1,J1,K1,I3DSTART,0)                 DIAGSIG.2852
         I3DSTART=I3DSTART+1                                                     DIAGSIG.2853
         IF(UNIT(1:3).EQ.'1/s') THEN                                             DIAGSIG.2854
            UNIT(1:8)='1/s     '                                                 DIAGSIG.2855
            UNITS(1:8)='1/s     '                                                DIAGSIG.2856
         ELSE IF(UNIT(1:7).EQ.'10**5/s') THEN                                    DIAGSIG.2857
            CALL SCALE(D31,'MULT',100000.,I1,J1,K1,I1,J1,1)                      DIAGSIG.2858
            UNIT(1:8)='10**5/s '                                                 DIAGSIG.2859
            UNITS(1:8)='10**5/s '                                                DIAGSIG.2860
         ELSE                                                                    DIAGSIG.2861
            UNIT(1:8)='1/s     '                                                 DIAGSIG.2862
            UNITS(1:8)='1/s     '                                                DIAGSIG.2863
         END IF                                                                  DIAGSIG.2864
C                                                                                DIAGSIG.2865
      ELSE IF(FIELD(1:2).EQ.'W '   ) THEN    ! VERTICAL WIND SPEED               DIAGSIG.2866
         VARNAM(1:8)='W       '                                                  DIAGSIG.2867
         CNT=CONT                                                                DIAGSIG.2868
         NPASS=ISMTHR                                                            DIAGSIG.2869
         ICRSDOT=1                                                               DIAGSIG.2870
         KDIM='3D'                                                               DIAGSIG.2871
         CALL READDAD(D31,'W       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2872
     *      DIAGS,FOUND)                                                         DIAGSIG.2873
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.2874
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.2875
            IERROR=1                                                             DIAGSIG.2876
            RETURN                                                               DIAGSIG.2877
         ENDIF                                                                   DIAGSIG.2878
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.2879
            UNIT(1:8)='m/s     '                                                 DIAGSIG.2880
            UNITS(1:8)='m/s     '                                                DIAGSIG.2881
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.2882
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.2883
            UNIT(1:8)='kt      '                                                 DIAGSIG.2884
            UNITS(1:8)='kt      '                                                DIAGSIG.2885
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.2886
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.2887
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.2888
            UNITS(1:8)='cm/s    '                                                DIAGSIG.2889
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.2890
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.2891
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.2892
            UNITS(1:8)='mm/s    '                                                DIAGSIG.2893
         ELSE                                                                    DIAGSIG.2894
            UNIT(1:8)='m/s     '                                                 DIAGSIG.2895
            UNITS(1:8)='m/s     '                                                DIAGSIG.2896
         END IF                                                                  DIAGSIG.2897
C                                                                                DIAGSIG.2898
      ELSE IF(FIELD(1:2).EQ.'U '   ) THEN    ! U-COMP WIND SPEED                 DIAGSIG.2899
         VARNAM(1:8)='U       '                                                  DIAGSIG.2900
         CNT=CONT                                                                DIAGSIG.2901
         NPASS=ISMTHR                                                            DIAGSIG.2902
         ICRSDOT=0                                                               DIAGSIG.2903
         KDIM='3D'                                                               DIAGSIG.2904
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2905
     *      .FALSE.,FOUND)                                                       DIAGSIG.2906
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.2907
            UNIT(1:8)='m/s     '                                                 DIAGSIG.2908
            UNITS(1:8)='m/s     '                                                DIAGSIG.2909
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.2910
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.2911
            UNIT(1:8)='kt      '                                                 DIAGSIG.2912
            UNITS(1:8)='kt      '                                                DIAGSIG.2913
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.2914
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.2915
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.2916
            UNITS(1:8)='cm/s    '                                                DIAGSIG.2917
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.2918
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.2919
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.2920
            UNITS(1:8)='mm/s    '                                                DIAGSIG.2921
         ELSE                                                                    DIAGSIG.2922
            UNIT(1:8)='m/s     '                                                 DIAGSIG.2923
            UNITS(1:8)='m/s     '                                                DIAGSIG.2924
         END IF                                                                  DIAGSIG.2925
C                                                                                DIAGSIG.2926
      ELSE IF(FIELD(1:2).EQ.'V '   ) THEN    ! V-COMP WIND SPEED                 DIAGSIG.2927
         VARNAM(1:8)='V       '                                                  DIAGSIG.2928
         CNT=CONT                                                                DIAGSIG.2929
         NPASS=ISMTHR                                                            DIAGSIG.2930
         ICRSDOT=0                                                               DIAGSIG.2931
         KDIM='3D'                                                               DIAGSIG.2932
         CALL READDAD(D31,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2933
     *      .FALSE.,FOUND)                                                       DIAGSIG.2934
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.2935
            UNIT(1:8)='m/s     '                                                 DIAGSIG.2936
            UNITS(1:8)='m/s     '                                                DIAGSIG.2937
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.2938
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.2939
            UNIT(1:8)='kt      '                                                 DIAGSIG.2940
            UNITS(1:8)='kt      '                                                DIAGSIG.2941
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.2942
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.2943
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.2944
            UNITS(1:8)='cm/s    '                                                DIAGSIG.2945
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.2946
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.2947
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.2948
            UNITS(1:8)='mm/s    '                                                DIAGSIG.2949
         ELSE                                                                    DIAGSIG.2950
            UNIT(1:8)='m/s     '                                                 DIAGSIG.2951
            UNITS(1:8)='m/s     '                                                DIAGSIG.2952
         END IF                                                                  DIAGSIG.2953
C                                                                                DIAGSIG.2954
      ELSE IF(FIELD(1:5).EQ.'WIND '   ) THEN    ! WIND SPEED                     DIAGSIG.2955
         VARNAM(1:8)='WIND UV '                                                  DIAGSIG.2956
         CNT=CONT                                                                DIAGSIG.2957
         NPASS=ISMTHR                                                            DIAGSIG.2958
         ICRSDOT=0                                                               DIAGSIG.2959
         KDIM='3D'                                                               DIAGSIG.2960
         CALL READDAD(D33,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2961
     *      .FALSE.,FOUND)                                                       DIAGSIG.2962
         CALL READDAD(D32,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.2963
     *      .FALSE.,FOUND)                                                       DIAGSIG.2964
         CALL WINDSPD(D33,D32,I1,J1,K1,D31)                                      DIAGSIG.2965
         IF(UNIT(1:3).EQ.'m/s') THEN                                             DIAGSIG.2966
            UNIT(1:8)='m/s     '                                                 DIAGSIG.2967
            UNITS(1:8)='m/s     '                                                DIAGSIG.2968
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         DIAGSIG.2969
            CALL MPS2KT(D31,I1,J1,K1,0)                                          DIAGSIG.2970
            UNIT(1:8)='kt      '                                                 DIAGSIG.2971
            UNITS(1:8)='kt      '                                                DIAGSIG.2972
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       DIAGSIG.2973
            CALL SCALE(D31,'MULT',100.0,I1,J1,K1,I1,J1,0)                        DIAGSIG.2974
            UNIT(1:8)='cm/s    '                                                 DIAGSIG.2975
            UNITS(1:8)='cm/s    '                                                DIAGSIG.2976
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       DIAGSIG.2977
            CALL SCALE(D31,'MULT',1000.0,I1,J1,K1,I1,J1,0)                       DIAGSIG.2978
            UNIT(1:8)='mm/s    '                                                 DIAGSIG.2979
            UNITS(1:8)='mm/s    '                                                DIAGSIG.2980
         ELSE                                                                    DIAGSIG.2981
            UNIT(1:8)='m/s     '                                                 DIAGSIG.2982
            UNITS(1:8)='m/s     '                                                DIAGSIG.2983
         END IF                                                                  DIAGSIG.2984
C                                                                                DIAGSIG.2985
      ELSE IF(FIELD(1:7).EQ.'REGIME ') THEN  ! PBL REGIME                        DIAGSIG.2986
         VARNAM(1:8)='PBL REGM'                                                  DIAGSIG.2987
         CNT=CONT                                                                DIAGSIG.2988
         NPASS=ISMTHR                                                            DIAGSIG.2989
         ICRSDOT=1                                                               DIAGSIG.2990
         KDIM='2D'                                                               DIAGSIG.2991
            CALL READDAD(D31,'REGIME  ',IDAD2D,I1,J1, 1, 0,                      DIAGSIG.2992
     *           DIAGS,FOUND)                                                    DIAGSIG.2993
            UNIT(1:8)='category'                                                 DIAGSIG.2994
            UNITS(1:8)='category'                                                DIAGSIG.2995
C                                                                                DIAGSIG.2996
      ELSE IF(FIELD(1:7).EQ.'RDTEND '                                            DIAGSIG.2997
     *   .OR. FIELD(1:8).EQ.'RADTEND ' ) THEN    ! RADIATION TEND                DIAGSIG.2998
         VARNAM(1:8)='RAD TEND'                                                  DIAGSIG.2999
         CNT=CONT                                                                DIAGSIG.3000
         NPASS=ISMTHR                                                            DIAGSIG.3001
         ICRSDOT=1                                                               DIAGSIG.3002
         KDIM='3D'                                                               DIAGSIG.3003
         CALL READDAD(D31,'RAD TEND',IDAD3D,I1,J1,K1,0,                          DIAGSIG.3004
     *      .FALSE.,FOUND)                                                       DIAGSIG.3005
         IF(UNIT(1:5).EQ.'K/day') THEN                                           DIAGSIG.3006
            UNIT(1:8)='K/day   '                                                 DIAGSIG.3007
            UNITS(1:8)='K/day   '                                                DIAGSIG.3008
         ELSE IF(UNIT(1:3).EQ.'K/h') THEN                                        DIAGSIG.3009
            CALL SCALE(D31,'DIV ',24.0,I1,J1,K1,I1,J1,0)                         DIAGSIG.3010
            UNIT(1:8)='K/h     '                                                 DIAGSIG.3011
            UNITS(1:8)='K/h     '                                                DIAGSIG.3012
         END IF                                                                  DIAGSIG.3013
                                                                                 DIAGSIG.3014
      ELSE IF(FIELD(1:7).EQ.'TKE    '  ) THEN    ! TKE                           DIAGSIG.3015
         VARNAM(1:8)='TKE     '                                                  DIAGSIG.3016
         CNT=CONT                                                                DIAGSIG.3017
         NPASS=ISMTHR                                                            DIAGSIG.3018
         ICRSDOT=1                                                               DIAGSIG.3019
         KDIM='3D'                                                               DIAGSIG.3020
         CALL READDAD(D31,'TKE     ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.3021
     *      .FALSE.,FOUND)                                                       DIAGSIG.3022
         IF(UNIT(1:4).EQ.'J/kg') THEN                                            DIAGSIG.3023
            UNIT(1:8)='J/kg    '                                                 DIAGSIG.3024
            UNITS(1:8)='J/kg    '                                                DIAGSIG.3025
         END IF                                                                  DIAGSIG.3026
                                                                                 DIAGSIG.3027
      ELSE IF(FIELD(1:8).EQ.'RESTEMP') THEN    ! SUBSTRATE TEMPERATURE           DIAGSIG.3028
         VARNAM(1:8)='RES TEMP'                                                  DIAGSIG.3029
         CNT=CONT                                                                DIAGSIG.3030
         NPASS=ISMTHR                                                            DIAGSIG.3031
         ICRSDOT=1                                                               DIAGSIG.3032
         KDIM='2D'                                                               DIAGSIG.3033
         CALL READDAD(D31,'RES TEMP',IMMHDR,I1,J1,1,1,                           DIAGSIG.3034
     *      DIAGS,FOUND)                                                         DIAGSIG.3035
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.3036
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.3037
            IERROR=1                                                             DIAGSIG.3038
            RETURN                                                               DIAGSIG.3039
         END IF                                                                  DIAGSIG.3040
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGSIG.3041
            UNIT(1:8)='K       '                                                 DIAGSIG.3042
            UNITS(1:8)='K       '                                                DIAGSIG.3043
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGSIG.3044
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGSIG.3045
            UNIT(1:8)='C       '                                                 DIAGSIG.3046
            UNITS(1:8)='C       '                                                DIAGSIG.3047
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGSIG.3048
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGSIG.3049
            CALL CEL2F  (D31,I1,J1,1)                                            DIAGSIG.3050
            UNIT(1:8)='F       '                                                 DIAGSIG.3051
            UNITS(1:8)='F       '                                                DIAGSIG.3052
         ELSE                                                                    DIAGSIG.3053
            UNIT(1:8)='K       '                                                 DIAGSIG.3054
            UNITS(1:8)='K       '                                                DIAGSIG.3055
         END IF                                                                  DIAGSIG.3056
C                                                                                DIAGSIG.3057
      ELSE IF(FIELD(1:5).EQ.'SOILT'
     *        .AND. FIELD(8:8).NE.'0') THEN        ! SOIL TEMPERATURE
         VARNAM(1:8)=FIELD(1:8)                                                  DIAGSIG.3059
         CNT=CONT                                                                DIAGSIG.3060
         NPASS=ISMTHR                                                            DIAGSIG.3061
         ICRSDOT=1                                                               DIAGSIG.3062
         KDIM='2D'                                                               DIAGSIG.3063
         CALL READDAD(D31,FIELD(1:8),IDAD2D,I1,J1,1,0,                           DIAGSIG.3064
     *      DIAGS,FOUND)                                                         DIAGSIG.3065
         IF(.NOT.FOUND) THEN                                                     DIAGSIG.3066
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        DIAGSIG.3067
            IERROR=1                                                             DIAGSIG.3068
            RETURN                                                               DIAGSIG.3069
         END IF                                                                  DIAGSIG.3070
         IF(UNIT(1:1).EQ.'K') THEN                                               DIAGSIG.3071
            UNIT(1:8)='K       '                                                 DIAGSIG.3072
            UNITS(1:8)='K       '                                                DIAGSIG.3073
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          DIAGSIG.3074
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGSIG.3075
            UNIT(1:8)='C       '                                                 DIAGSIG.3076
            UNITS(1:8)='C       '                                                DIAGSIG.3077
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          DIAGSIG.3078
            CALL KEL2CEL(D31,I1,J1,1)                                            DIAGSIG.3079
            CALL CEL2F  (D31,I1,J1,1)                                            DIAGSIG.3080
            UNIT(1:8)='F       '                                                 DIAGSIG.3081
            UNITS(1:8)='F       '                                                DIAGSIG.3082
         ELSE                                                                    DIAGSIG.3083
            UNIT(1:8)='K       '                                                 DIAGSIG.3084
            UNITS(1:8)='K       '                                                DIAGSIG.3085
         END IF                                                                  DIAGSIG.3086
C                                                                                DIAGSIG.3087
      ELSE IF((FIELD(1:8).EQ.'BARB10M ') .OR.    ! WIND BARBS AT 10M             06NOV00.11
     *   (FIELD(1:8).EQ.'VECT10M ') .OR.    ! WIND VECTORS                       06NOV00.12
     *   (FIELD(1:8).EQ.'VESL10M ')) THEN   ! WIND STREAM LINES                  06NOV00.13
         VARNAM(1:8)='BARB 10M'                                                  06NOV00.14
         IF(FIELD(1:4).EQ.'BARB') THEN                                           06NOV00.15
            IFORM=3                                                              06NOV00.16
         ELSE IF(FIELD(1:4).EQ.'VECT') THEN                                      06NOV00.17
            IFORM=1                                                              06NOV00.18
            FIELD(1:4)='BARB'                                                    06NOV00.19
         ELSE IF(FIELD(1:4).EQ.'VESL') THEN                                      06NOV00.20
            IFORM=2                                                              06NOV00.21
            FIELD(1:4)='BARB'                                                    06NOV00.22
         END IF                                                                  06NOV00.23
         CNT=CONT                                                                06NOV00.24
         NPASS=ISMTHR                                                            06NOV00.25
         ICRSDOT=1                                                               06NOV00.26
         KDIM='2D'                                                               06NOV00.27
         CALL READDAD(D31,'U10     ',IDAD2D,I1,J1, 1,0,                          06NOV00.28
     *      .FALSE.,FOUND)                                                       06NOV00.29
         CALL READDAD(D32,'V10     ',IDAD2D,I1,J1, 1,0,                          06NOV00.30
     *      .FALSE.,FOUND)                                                       06NOV00.31
         IF(UNIT(1:3).EQ.'m/s') THEN                                             06NOV00.32
            UNIT(1:8)='m/s     '                                                 06NOV00.33
            UNITS(1:8)='m/s     '                                                06NOV00.34
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         06NOV00.35
            CALL MPS2KT(D31,I1,J1, 1,0)                                          06NOV00.36
            CALL MPS2KT(D32,I1,J1, 1,0)                                          06NOV00.37
            UNIT(1:8)='kt      '                                                 06NOV00.38
            UNITS(1:8)='kt      '                                                06NOV00.39
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       06NOV00.40
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,0)                        06NOV00.41
            CALL SCALE(D32,'MULT',100.0,I1,J1, 1,I1,J1,0)                        06NOV00.42
            UNIT(1:8)='cm/s    '                                                 06NOV00.43
            UNITS(1:8)='cm/s    '                                                06NOV00.44
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       06NOV00.45
            CALL SCALE(D31,'MULT',1000.0,I1,J1, 1,I1,J1,0)                       06NOV00.46
            CALL SCALE(D32,'MULT',1000.0,I1,J1, 1,I1,J1,0)                       06NOV00.47
            UNIT(1:8)='mm/s    '                                                 06NOV00.48
            UNITS(1:8)='mm/s    '                                                06NOV00.49
         ELSE                                                                    06NOV00.50
            UNIT(1:8)='m/s     '                                                 06NOV00.51
            UNITS(1:8)='m/s     '                                                06NOV00.52
         END IF                                                                  06NOV00.53
C                                                                                06NOV00.54
      ELSE IF(FIELD(1:8).EQ.'WIND10M '   ) THEN    ! WIND SPEED AT 10M           06NOV00.55
         VARNAM(1:8)='WIND 10M'                                                  06NOV00.56
         CNT=CONT                                                                06NOV00.57
         NPASS=ISMTHR                                                            06NOV00.58
         ICRSDOT=1                                                               06NOV00.59
         KDIM='2D'                                                               06NOV00.60
         CALL READDAD(D23,'U10     ',IDAD2D,I1,J1, 1,0,                          06NOV00.61
     *      .FALSE.,FOUND)                                                       06NOV00.62
         CALL READDAD(D22,'V10     ',IDAD2D,I1,J1, 1,0,                          06NOV00.63
     *      .FALSE.,FOUND)                                                       06NOV00.64
         CALL WINDSPD(D23,D22,I1,J1, 1,D31)                                      06NOV00.65
         IF(UNIT(1:3).EQ.'m/s') THEN                                             06NOV00.66
            UNIT(1:8)='m/s     '                                                 06NOV00.67
            UNITS(1:8)='m/s     '                                                06NOV00.68
         ELSE IF(UNIT(1:2).EQ.'kt') THEN                                         06NOV00.69
            CALL MPS2KT(D31,I1,J1, 1,0)                                          06NOV00.70
            UNIT(1:8)='kt      '                                                 06NOV00.71
            UNITS(1:8)='kt      '                                                06NOV00.72
         ELSE IF(UNIT(1:4).EQ.'cm/s') THEN                                       06NOV00.73
            CALL SCALE(D31,'MULT',100.0,I1,J1, 1,I1,J1,0)                        06NOV00.74
            UNIT(1:8)='cm/s    '                                                 06NOV00.75
            UNITS(1:8)='cm/s    '                                                06NOV00.76
         ELSE IF(UNIT(1:4).EQ.'mm/s') THEN                                       06NOV00.77
            CALL SCALE(D31,'MULT',1000.0,I1,J1, 1,I1,J1,0)                       06NOV00.78
            UNIT(1:8)='mm/s    '                                                 06NOV00.79
            UNITS(1:8)='mm/s    '                                                06NOV00.80
         ELSE                                                                    06NOV00.81
            UNIT(1:8)='m/s     '                                                 06NOV00.82
            UNITS(1:8)='m/s     '                                                06NOV00.83
         END IF                                                                  06NOV00.84
C                                                                                06NOV00.85
      ELSE IF(FIELD(1:4).EQ.'T2M '                                               06NOV00.86
     *   .OR. FIELD(1:4).EQ.'T2  '    ) THEN    ! TEMPERATURE AT 2M              06NOV00.87
         VARNAM(1:8)='T 2M    '                                                  06NOV00.88
         CNT=CONT                                                                06NOV00.89
         NPASS=ISMTHR                                                            06NOV00.90
         ICRSDOT=1                                                               06NOV00.91
         KDIM='2D'                                                               06NOV00.92
         CALL READDAD(D31,'T2      ',IDAD2D,I1,J1, 1,0,                          06NOV00.93
     *      .FALSE.,FOUND)                                                       06NOV00.94
         IF(UNIT(1:1).EQ.'K') THEN                                               06NOV00.95
            UNIT(1:8)='K       '                                                 06NOV00.96
            UNITS(1:8)='K       '                                                06NOV00.97
         ELSE IF(UNIT(1:1).EQ.'C') THEN                                          06NOV00.98
            CALL KEL2CEL(D31,I1,J1, 1)                                           06NOV00.99
            UNIT(1:8)='C       '                                                 06NOV00.100
            UNITS(1:8)='C       '                                                06NOV00.101
         ELSE IF(UNIT(1:1).EQ.'F') THEN                                          06NOV00.102
            CALL KEL2CEL(D31,I1,J1, 1)                                           06NOV00.103
            CALL CEL2F  (D31,I1,J1, 1)                                           06NOV00.104
            UNIT(1:8)='F       '                                                 06NOV00.105
            UNITS(1:8)='F       '                                                06NOV00.106
         ELSE                                                                    06NOV00.107
            UNIT(1:8)='K       '                                                 06NOV00.108
            UNITS(1:8)='K       '                                                06NOV00.109
         END IF                                                                  06NOV00.110
C                                                                                06NOV00.111
      ELSE IF(FIELD(1:5).EQ.'QV2M '                                              06NOV00.112
     *   .OR. FIELD(1:4).EQ.'Q2M '                                               06NOV00.113
     *   .OR. FIELD(1:3).eq.'Q2 '     ) THEN    ! MIXING RATIO AT 2M             06NOV00.114
         VARNAM(1:8)='QV 2M   '                                                  06NOV00.115
         CNT=CONT                                                                06NOV00.116
         NPASS=ISMTHR                                                            06NOV00.117
         ICRSDOT=1                                                               06NOV00.118
         KDIM='2D'                                                               06NOV00.119
         CALL READDAD(D31,'Q2      ',IDAD2D,I1,J1, 1,0,                          06NOV00.120
     *      DIAGS,FOUND)                                                         06NOV00.121
         IF(.NOT.FOUND) THEN                                                     06NOV00.122
            PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                        06NOV00.123
            IERROR=1                                                             06NOV00.124
            RETURN                                                               06NOV00.125
         END IF                                                                  06NOV00.126
         IF(UNIT(1:5).EQ.'kg/kg') THEN                                           06NOV00.127
            UNIT(1:8)='kg/kg   '                                                 06NOV00.128
            UNITS(1:8)='kg/kg   '                                                06NOV00.129
         ELSE IF(UNIT(1:4).EQ.'g/kg') THEN                                       06NOV00.130
            CALL SCALE(D31,'MULT',1000.,I1,J1, 1,I1,J1,1)                        06NOV00.131
            UNIT(1:8)='g/kg    '                                                 06NOV00.132
            UNITS(1:8)='g/kg    '                                                06NOV00.133
         ELSE IF(UNIT(1:3).EQ.'g/g') THEN                                        06NOV00.134
            UNIT(1:8)='g/g     '                                                 06NOV00.135
            UNITS(1:8)='g/g     '                                                06NOV00.136
         ELSE                                                                    06NOV00.137
            UNIT(1:8)='kg/kg   '                                                 06NOV00.138
            UNITS(1:8)='kg/kg   '                                                06NOV00.139
         END IF                                                                  06NOV00.140
C                                                                                06NOV00.141
      ELSE IF((FIELD(1:5).EQ.'TD2M '    ) .OR.        ! DEW POINT                06NOV00.142
     *        (FIELD(1:6).EQ.'TDD2M '   )) THEN       ! DEW POINT DEPR           06NOV00.143
         IF (FIELD(1:3).EQ.'TD2') THEN                                           06NOV00.144
            IDEW=1                                                               06NOV00.145
            VARNAM(1:8)='T DEW PT'                                               06NOV00.146
         ELSE IF (FIELD(1:4).EQ.'TDD2') THEN                                     06NOV00.147
            IDEW=0                                                               06NOV00.148
            VARNAM(1:8)='T DEW DP'                                               06NOV00.149
         END IF                                                                  06NOV00.150
         CNT=CONT                                                                06NOV00.151
         NPASS=ISMTHR                                                            06NOV00.152
         ICRSDOT=1                                                               06NOV00.153
         KDIM='2D'                                                               06NOV00.154
         IF (BHI(  1,1).EQ.11 .AND. BHI(  3,13).EQ.1) THEN                       06NOV00.155
C    if it is dry run                                                            06NOV00.156
            CALL CLEAR(D23,I1,J1, 1)                                             06NOV00.157
            CALL WRITDAD(D23,'Q2      ',IDAD2D,I1,J1, 1,                         06NOV00.158
     *                I2DSTART,0)                                                06NOV00.159
            I2DSTART=I2DSTART+1                                                  06NOV00.160
         ENDIF                                                                   06NOV00.161
         CALL READDAD(D22,'T2      ',IDAD2D,I1,J1, 1,0,                          06NOV00.162
     *      .FALSE.,FOUND)                                                       06NOV00.163
         CALL READDAD(D23,'Q2      ',IDAD2D,I1,J1, 1,0,                          06NOV00.164
     *      .FALSE.,FOUND)                                                       06NOV00.165
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          06NOV00.166
     *      .FALSE.,FOUND)                                                       06NOV00.167
         CALL READDAD(D31,'PP      ',IDAD3D,I1,J1,K1,0,                          06NOV00.168
     *       DIAGS,FOUND)                                                        06NOV00.169
         IF(.NOT.FOUND) CALL CLEAR(D31,I1,J1,K1)                                 06NOV00.170
      CALL DEWPOINS(D22,D23,D31,SIGMA,D21,PTOP,IDEW,I1,J1, 1,D31)                06NOV00.171
         IF(IDEW.EQ.1) THEN                                                      06NOV00.172
            CALL WRITDAD(D31,'TD2M    ',IDAD2D,I1,J1, 1,                         06NOV00.173
     *                  I2DSTART,0)                                              06NOV00.174
         ELSE IF(IDEW.EQ.0) THEN                                                 06NOV00.175
            CALL WRITDAD(D31,'TDD2M   ',IDAD2D,I1,J1, 1,                         06NOV00.176
     *                  I2DSTART,0)                                              06NOV00.177
         END IF                                                                  06NOV00.178
         I2DSTART=I2DSTART+1                                                     06NOV00.179
         IF(UNIT(1:1).EQ.'K') THEN                                               06NOV00.180
            UNIT(1:8)='K       '                                                 06NOV00.181
            UNITS(1:8)='K       '                                                06NOV00.182
         ELSE IF((UNIT(1:1).EQ.'C').AND.(IDEW.EQ.1)) THEN                        06NOV00.183
            CALL SCALE(D31,'SUB ',273.16,I1,J1, 1,I1,J1,1)                       06NOV00.184
            UNIT(1:8)='C       '                                                 06NOV00.185
            UNITS(1:8)='C       '                                                06NOV00.186
         ELSE IF((UNIT(1:1).EQ.'C').AND.(IDEW.EQ.0)) THEN                        06NOV00.187
            UNIT(1:8)='C       '                                                 06NOV00.188
            UNITS(1:8)='C       '                                                06NOV00.189
         ELSE IF((UNIT(1:1).EQ.'F').AND.(IDEW.EQ.1)) THEN                        06NOV00.190
            CALL KEL2CEL(D31,I1,J1, 1)                                           06NOV00.191
            CALL CEL2F  (D31,I1,J1, 1)                                           06NOV00.192
            UNIT(1:8)='F       '                                                 06NOV00.193
            UNITS(1:8)='F       '                                                06NOV00.194
         ELSE IF((UNIT(1:1).EQ.'F').AND.(IDEW.EQ.0)) THEN                        06NOV00.195
            CALL SCALE(D31,'MULT',1.8,I1,J1, 1,I1,J1,1)                          06NOV00.196
            UNIT(1:8)='F       '                                                 06NOV00.197
            UNITS(1:8)='F       '                                                06NOV00.198
         ELSE                                                                    06NOV00.199
            UNIT(1:8)='K       '                                                 06NOV00.200
            UNITS(1:8)='K       '                                                06NOV00.201
         ENDIF                                                                   06NOV00.202
C                                                                                06NOV00.203
      ELSE                                                                       DIAGSIG.3088
         CALL READDAD(D31,FIELD(1:8),IDAD2D,I1,J1, 1,0,                          DIAGSIG.3089
     *      DIAGS,FOUND)                                                         DIAGSIG.3090
         IF(FOUND) THEN                                                          DIAGSIG.3091
            VARNAM(1:8)=FIELD(1:8)                                               DIAGSIG.3092
            CNT=CONT                                                             DIAGSIG.3093
            NPASS=ISMTHR                                                         DIAGSIG.3094
            ICRSDOT=1                                                            DIAGSIG.3095
            IF(FIELD(1:3).EQ.'U10'.OR.FIELD(1:3).EQ.'V10') ICRSDOT=0             06NOV00.204
            KDIM='2D'                                                            DIAGSIG.3096
            UNIT(1:8)='        '                                                 DIAGSIG.3097
            UNITS(1:8)=UNIT(1:8)                                                 DIAGSIG.3098
         ELSE                                                                    DIAGSIG.3099
            CALL READDAD(D31,FIELD(1:8),IMMHDR,I1,J1, 1,1,                       DIAGSIG.3100
     *         DIAGS,FOUND)                                                      DIAGSIG.3101
            IF(FOUND) THEN                                                       DIAGSIG.3102
               VARNAM(1:8)=FIELD(1:8)                                            DIAGSIG.3103
               CNT=CONT                                                          DIAGSIG.3104
               NPASS=0                                                           DIAGSIG.3105
               ICRSDOT=1                                                         DIAGSIG.3106
               IF   (FIELD(1:8).EQ.'MAPFACDT'                                    DIAGSIG.3107
     *           .OR.FIELD(1:8).EQ.'CORIOLIS'                                    DIAGSIG.3108
     *           .OR.FIELD(1:8).EQ.'LATITDOT'                                    DIAGSIG.3109
     *           .OR.FIELD(1:8).EQ.'LONGIDOT') ICRSDOT=0                         DIAGSIG.3110
               KDIM='2D'                                                         DIAGSIG.3111
               UNITS(1:8)=UNIT(1:8)                                              DIAGSIG.3112
            ELSE                                                                 DIAGSIG.3113
               PRINT *,'FIELD=',FIELD(1:8),' IS NOT PLOTTED'                     DIAGSIG.3114
               IERROR=1                                                          DIAGSIG.3115
               RETURN                                                            DIAGSIG.3116
            END IF                                                               DIAGSIG.3117
         END IF                                                                  DIAGSIG.3118
      END IF                                                                     DIAGSIG.3119
C                                                                                DIAGSIG.3120
C     ... MAYBE VERTICALLY INTERPOLATE DATA                                      DIAGSIG.3121
C                                                                                DIAGSIG.3122
      IF ((TINT).AND.(KDIM.EQ.'3D')) THEN                                        DIAGSIG.3123
         CALL READDAD(D33,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.3124
     *      .FALSE.,FOUND)                                                       DIAGSIG.3125
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1,1,0,                           DIAGSIG.3126
     *      .FALSE.,FOUND)                                                       DIAGSIG.3127
         CALL READDAD(D34,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.3128
     *        DIAGS,FOUND)                                                       DIAGSIG.3129
         IF(.NOT.FOUND) CALL CLEAR(D34,I1,J1,K1)                                 DIAGSIG.3130
         CALL THTSURF(D31,D34,D33,D24,D21,D22,D23,I1,J1,K1,                      DIAGSIG.3131
     *                VERTVALC,VERTVAL,SIGMA,PTOP,ICRSDOT)                       DIAGSIG.3132
         IF (FIELD(1:4).EQ.'BARB')                                               DIAGSIG.3133
     *   CALL THTSURF(D32,D34,D33,D24,D21,D22,D23,I1,J1,K1,                      DIAGSIG.3134
     *                VERTVALC,VERTVAL,SIGMA,PTOP,ICRSDOT)                       DIAGSIG.3135
      ELSEIF ((PINT).AND.(KDIM.EQ.'3D')) THEN                                    DIAGSIG.3136
         CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSIG.3137
     *      DIAGS,FOUND)                                                         DIAGSIG.3138
         IF(.NOT.FOUND) CALL CLEAR(D33,I1,J1,K1)                                 DIAGSIG.3139
         CALL READDAD(D21,'PSTARCRS',IDAD2D,I1,J1,1,0,                           DIAGSIG.3140
     *      .FALSE.,FOUND)                                                       DIAGSIG.3141
         CALL PRSSURF(D31,D33,D24,D21,D22,D23,I1,J1,K1,                          DIAGSIG.3142
     *                VERTVALC,VERTVAL,SIGMA,PTOP,ICRSDOT)                       DIAGSIG.3143
                                                                                 DIAGSIG.3144
C mask underground values - not activated                                        DIAGSIG.3145
                                                                                 DIAGSIG.3146
         IF (IMASK.EQ.1) THEN                                                    DIAGSIG.3147
         ioffp = 1                                                               DIAGSIG.3148
         spval = 9999.                                                           DIAGSIG.3149
         call fillsp2(d31,VERTVAL,d21,sigma,ptop,d33,i1,j1,k1,spval,d24)         DIAGSIG.3150
         END IF                                                                  DIAGSIG.3151
                                                                                 DIAGSIG.3152
         IF (FIELD(1:4).EQ.'BARB')                                               DIAGSIG.3153
     *   CALL PRSSURF(D32,D33,D24,D21,D22,D23,I1,J1,K1,                          DIAGSIG.3154
     *                VERTVALC,VERTVAL,SIGMA,PTOP,ICRSDOT)                       DIAGSIG.3155
      ENDIF                                                                      DIAGSIG.3156
C                                                                                DIAGSIG.3157
C     ... STORE DATA TO AVOID CONTAMINATION                                      DIAGSIG.3158
C                                                                                DIAGSIG.3159
      IF(((.NOT.OVERLAY).OR.((OVERLAY).AND.(IFRAME.EQ.1))) .AND.                 DIAGSIG.3160
     *   (FIELD(1:4).NE.'BARB')) THEN                                            DIAGSIG.3161
         CALL WRITDAD(D31,'CONREC 1',IDAD3D,I1,J1,K1,I3DFLD1,0)                  DIAGSIG.3162
      ELSEIF (((OVERLAY).AND.(IFRAME.EQ.2)) .AND.                                DIAGSIG.3163
     *   (FIELD(1:4).NE.'BARB')) THEN                                            DIAGSIG.3164
         CALL WRITDAD(D31,'CONREC 2',IDAD3D,I1,J1,K1,I3DFLD2,0)                  DIAGSIG.3165
      ELSE IF ((FIELD(1:4).EQ.'BARB').or.                                        DIAGSIG.3166
     *         (FIELD(1:3).eq.'CXW' )) THEN                                      DIAGSIG.3167
         CALL WRITDAD(D31,'VELVCN U',IDAD3D,I1,J1,K1,I3DFLD3,0)                  DIAGSIG.3168
         CALL WRITDAD(D32,'VELVCN V',IDAD3D,I1,J1,K1,I3DFLD4,0)                  DIAGSIG.3169
      END IF                                                                     DIAGSIG.3170
      RETURN                                                                     DIAGSIG.3171
      END                                                                        DIAGSIG.3172
