      SUBROUTINE DIAGSKT(XLOC,YLOC,KGOOD,IERROR,                                 DIAGSKT.1
     *  PSTR,TSTR,TDSTR,SPDSTR,DIRSTR,YLAT,YLON,BADVAL)                          DIAGSKT.2
#     include <data.incl>                                                        DIAGSKT.3
C                                                                                DIAGSKT.4
        CALL DIAGSKT_1(XLOC,YLOC,KGOOD,IERROR,                                   DIAGSKT.5
     *  PSTR,TSTR,TDSTR,SPDSTR,DIRSTR,YLAT,YLON,BADVAL,                          DIAGSKT.6
     *                 DATASP(PTRD31),DATASP(PTRD32),                            DIAGSKT.7
     *                 DATASP(PTRD33),                                           DIAGSKT.8
     *                 DATASP(PTRD21),DATASP(PTRD22),                            DIAGSKT.9
     *                 DATASP(PTRD23),DATASP(PTRD24),                            DIAGSKT.10
     *                               I1,J1,K1 )                                  DIAGSKT.11
        RETURN                                                                   DIAGSKT.12
       END                                                                       DIAGSKT.13
C                                                                                DIAGSKT.14
      SUBROUTINE DIAGSKT_1(XLOC,YLOC,KGOOD,IERROR,                               DIAGSKT.15
     *  PSTR,TSTR,TDSTR,SPDSTR,DIRSTR,YLAT,YLON,BADVAL,                          DIAGSKT.16
     *  D31,D32,D33,D21,D22,D23,D24,I1,J1,K1)                                    DIAGSKT.17
C                                                                                DIAGSKT.18
C     SECTION  DIAGNOSTIC                                                        DIAGSKT.19
C     PURPOSE  COMPUTE THE 1-D STRINGS OF PRESSURE, TEMPERATURE,                 DIAGSKT.20
C              DEW POINT, SPEED AND DIRECTION FOR SKEW T PLOTS                   DIAGSKT.21
C                                                                                DIAGSKT.22
#     include <headerv3.incl>                                                    DIAGSKT.23
#     include <progname.incl>                                                    DIAGSKT.24
#     include <modelpar.incl>                                                    DIAGSKT.25
#     include <vlevel.incl>                                                      DIAGSKT.26
                                                                                 DIAGSKT.27
      REAL D31(I1*J1,K1),D32(I1*J1,K1),D33(I1*J1,K1),                            DIAGSKT.28
     *     D21(I1*J1),D22(I1*J1),D23(I1*J1),D24(I1*J1)                           DIAGSKT.29
C                                                                                DIAGSKT.30
      COMMON /GLEAN1/ FIELD,UNIT,FIELD2,UNIT2                                    DIAGSKT.31
      CHARACTER *80   FIELD,UNIT,FIELD2,UNIT2                                    DIAGSKT.32
      COMMON /GLEAN2/ CONT,ISMTHR,CONT2,ISMTHR2,XLATX,YLONY                      DIAGSKT.33
      LOGICAL   MLF(10)                                                          DIAGSKT.34
      DIMENSION JYR(18), JMO(18), JDY(18), JHR(18),                              DIAGSKT.35
     *          NBOGUS(18), KBOGUS(18)                                           DIAGSKT.36
      LOGICAL   IPLOT(18), NSELIM(18)                                            DIAGSKT.37
      COMMON /HEADER/ MDATE,IPROG,ICOORD,                                        DIAGSKT.38
     *   NLV,IVCOORD(100),VCOORD(100),                                           DIAGSKT.39
     *   MIF, MRF, MLF,                                                          DIAGSKT.40
     *   JYR,JMO,JDY,JHR,IPLOT,NSELIM,NBOGUS,KBOGUS,IPROJ                        DIAGSKT.41
      COMMON /WHEN/ MDATENOW                                                     DIAGSKT.42
      COMMON /HDRCHR/  PROG                                                      DIAGSKT.43
      COMMON /MM5PHY/ NFLAGS,IFLAGS(100)                                         DIAGSKT.44
      COMMON /MAPSTUFF/ XLONC,PHIC,XLAT1,XLON1,XLAT2,XLON2,                      DIAGSKT.45
     *   ISTART,IEND,JSTART,JEND,                                                DIAGSKT.46
     *   IMAPMAX,IMAPST,IMAPEND,JMAPMAX,JMAPST,JMAPEND,                          DIAGSKT.47
     *   XPA,XPB,YPA,YPB,                                                        DIAGSKT.48
     *   DS,OVERLAY,IFRAME,INSIDE,IFORM,NUMFRAME                                 DIAGSKT.49
      LOGICAL OVERLAY                                                            DIAGSKT.50
      COMMON /DADTAB1/ TABNAME,TNPERM                                            DIAGSKT.51
      COMMON /DADTAB2/ TABREC,TRPERM                                             DIAGSKT.52
      PARAMETER (LENTAB=5000,LTPERM=1000)                                        DIAGSKT.53
      CHARACTER *8 TABNAME(LENTAB),TNPERM(LTPERM)                                DIAGSKT.54
      INTEGER TABREC(LENTAB),TRPERM(LTPERM)                                      DIAGSKT.55
      PARAMETER (IDAD2D=91,IDAD3D=92,IMMHDR=93)                                  DIAGSKT.56
C                                                                                DIAGSKT.57
      COMMON /XYLLC/ XN,DDS,XLAT,XLON,IMAX,JMAX,KPROJ,PSI1,PSI2                  DIAGSKT.58
      PARAMETER (NT=100)                                                         DIAGSKT.59
      DIMENSION PSTR(NT),TSTR(NT),TDSTR(NT),                                     DIAGSKT.60
     *          SPDSTR(NT),DIRSTR(NT),PPSTR(NT)                                  DIAGSKT.61
      DIMENSION USTR(NT),VSTR(NT)                                                DIAGSKT.62
      CHARACTER*6PROJECT                                                         DIAGSKT.63
      LOGICAL FOUND                                                              DIAGSKT.64
C                                                                                DIAGSKT.65
C     ... INTIIALIZE VALUES FOR XYLL, AND ERRORS                                 DIAGSKT.66
C                                                                                DIAGSKT.67
      IERROR=0                                                                   DIAGSKT.68
         IF (BHI(  7,1) .EQ.1) THEN                                              DIAGSKT.69
            PROJECT='LAMCON'                                                     DIAGSKT.70
         ELSE IF (BHI(  7,1) .EQ.2) THEN                                         DIAGSKT.71
            PROJECT='POLSTR'                                                     DIAGSKT.72
         ELSE IF (BHI(  7,1) .EQ.3) THEN                                         DIAGSKT.73
            PROJECT='MERCAT'                                                     DIAGSKT.74
         ELSE                                                                    DIAGSKT.75
            PRINT *,'== MAP PROJECTION INDEX=',BHI(7,1),                         DIAGSKT.76
     +              ' IS NOT VALID VALUE (1, 2 OR 3) =='                         DIAGSKT.77
            STOP                                                                 DIAGSKT.78
         END IF                                                                  DIAGSKT.79
      IF(PROJECT.EQ.'LAMCON') THEN                                               DIAGSKT.80
C        PRINT *,'LAMBERT CONFORMAL PROJECTION'                                  DIAGSKT.81
C        XN=0.716                                                                DIAGSKT.82
         XN=BHR(4,1)                                                             DIAGSKT.83
         KPROJ = 1                                                               DIAGSKT.84
      ELSE IF(PROJECT.EQ.'POLSTR') THEN                                          DIAGSKT.85
C        PRINT *,'POLAR STEREOGRAPHIC PROJECTION'                                DIAGSKT.86
         XN=1.0                                                                  DIAGSKT.87
         KPROJ = 2                                                               DIAGSKT.88
      ELSE IF(PROJECT.EQ.'MERCAT') THEN                                          DIAGSKT.89
C        PRINT *,'MERCATOR PROJECTION'                                           DIAGSKT.90
         XN=0.0                                                                  DIAGSKT.91
         KPROJ = 3                                                               DIAGSKT.92
      ELSE                                                                       DIAGSKT.93
         PRINT *,'UNDEFINED PROJECTION, ASSUMING ',                              DIAGSKT.94
     *           'LAMBERT CONFORMAL PROJECTION'                                  DIAGSKT.95
         XN=0.716                                                                DIAGSKT.96
         KPROJ = 1                                                               DIAGSKT.97
      END IF                                                                     DIAGSKT.98
      PSI1=BHR(5,1)                                                              DIAGSKT.99
      PSI2=BHR(6,1)                                                              DIAGSKT.100
      DDS = DS / 1000.                                                           DIAGSKT.101
      XLAT = PHIC                                                                DIAGSKT.102
      XLON = XLONC                                                               DIAGSKT.103
      IMAX = IMAPMAX                                                             DIAGSKT.104
      JMAX = JMAPMAX                                                             DIAGSKT.105
      RATIO  = FLOAT(BHI(20,1))                                                  19DEC02.24
      YSNEST = BHR(10,1)                                                         19DEC02.25
      XSNEST = BHR(11,1)                                                         19DEC02.26
C                                                                                DIAGSKT.106
C     .. GET THE X,Y LOCATION FOR SKEWT                                          DIAGSKT.107
C                                                                                DIAGSKT.108
      IF(FIELD(1:7).EQ.'SKEWTLL') THEN                                           DIAGSKT.109
         IF(PROJECT.EQ.'LAMCON'.OR.PROJECT.EQ.'MERCAT') THEN                     DIAGSKT.110
            CALL LLXY(XLATX,YLONY,XLOC,YLOC)                                     DIAGSKT.111
         ELSE IF(PROJECT.EQ.'POLSTR') THEN                                       DIAGSKT.112
            CALL LLXYST(XLATX,YLONY,XLOC,YLOC)                                   DIAGSKT.113
         END IF                                                                  DIAGSKT.114
         XLOC=XLOC-FLOAT(JMAPST-1)                                               DIAGSKT.115
         YLOC=YLOC-FLOAT(IMAPST-1)                                               DIAGSKT.116
      ELSE                                                                       DIAGSKT.117
         XLOC=XLATX                                                              DIAGSKT.118
         YLOC=YLONY                                                              DIAGSKT.119
      END IF                                                                     DIAGSKT.120
C                                                                                DIAGSKT.121
C     ... ERROR CHECK FOR LOCATION OUT OF DOMAIN                                 DIAGSKT.122
C                                                                                DIAGSKT.123
      IF( (NINT(XLOC).GT.J1-3) .OR.                                              DIAGSKT.124
     *    (NINT(XLOC).LT.   3) .OR.                                              DIAGSKT.125
     *    (NINT(YLOC).GT.I1-3) .OR.                                              DIAGSKT.126
     *    (NINT(YLOC).LT.   3) )THEN                                             DIAGSKT.127
         PRINT *,'GRID LOCATION IS OUT OF RANGE FOR SKEWT'                       DIAGSKT.128
         PRINT *,'XLOC=',XLOC,'   JMAX=',J1                                      DIAGSKT.129
         PRINT *,'YLOC=',YLOC,'   IMAX=',I1                                      DIAGSKT.130
         IERROR=1                                                                DIAGSKT.131
         RETURN                                                                  DIAGSKT.132
      END IF                                                                     DIAGSKT.133
C                                                                                19DEC02.27
      IF(FIELD(1:7).EQ.'SKEWTXY') THEN                                           19DEC02.28
C     .. GET LAT/LONG VALUES FOR X/Y                                             19DEC02.29
        X1 = (XSNEST-1.)*RATIO + XLOC                                            19DEC02.30
        Y1 = (YSNEST-1.)*RATIO + YLOC                                            19DEC02.31
        CALL XYLL (X1,Y1,YLAT,YLON)                                              19DEC02.32
      END IF                                                                     19DEC02.33
C                                                                                DIAGSKT.134
C     ... SIGMA LEVEL, MODEL INPUT OR OUTPUT                                     DIAGSKT.135
      IF((PROG(1:6).EQ.'MMOUT ').OR.(PROG(1:6).EQ.'MMINP ').OR.                  DIAGSKT.136
     *   (PROG(1:6).EQ.'MZIGGY').OR.(PROG(1:6).EQ.'MM4NH ').OR.                  DIAGSKT.137
     *   (PROG(1:6).EQ.'MM5NHI').OR.(PROG(1:6).EQ.'MM5   ')) THEN                DIAGSKT.138
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSKT.139
     *      .FALSE.,FOUND)                                                       DIAGSKT.140
         CALL VERTSTR(D31,I1,J1,K1,YLOC,XLOC,USTR,0)                             DIAGSKT.141
C                                                                                DIAGSKT.142
         CALL READDAD(D31,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSKT.143
     *      .FALSE.,FOUND)                                                       DIAGSKT.144
         CALL VERTSTR(D31,I1,J1,K1,YLOC,XLOC,VSTR,0)                             DIAGSKT.145
C                                                                                DIAGSKT.146
         CALL READDAD(D31,'LONGIDOT',IMMHDR,I1,J1, 1,1,                          DIAGSKT.147
     *      .FALSE.,FOUND)                                                       DIAGSKT.148
         CALL VERTSTR(D31,I1,J1, 1,YLOC,XLOC,XLONSK,0)                           DIAGSKT.149
C                                                                                DIAGSKT.150
C        CALL XYLL (XLOC,YLOC,                                                   19DEC02.34
C    *      YLAT,YLON)                                                           19DEC02.35
C        PHI=(XLONC-XLONSK)*XN*3.14159265/180.                                   DIAGSKT.153
         ZLON = XLONC - XLONSK                                                   DIAGSKT.154
         IF (ZLON.GT.180) ZLON = ZLON - 360.                                     DIAGSKT.155
         IF (ZLON.LT.-180) ZLON = ZLON + 360.                                    DIAGSKT.156
         PHI = ZLON*XN*3.14159265/180.                                           DIAGSKT.157
         IF (YLON.GT.180) YLON = YLON - 360.                                     DIAGSKT.158
         IF (YLON.LT.-180) YLON = YLON + 360.                                    DIAGSKT.159
         DO 100 K=1,K1                                                           DIAGSKT.160
            SPDSTR(K)=SQRT(USTR(K)*USTR(K)+VSTR(K)*VSTR(K))                      DIAGSKT.161
            UMET=-VSTR(K)*SIN(PHI)+USTR(K)*COS(PHI)                              DIAGSKT.162
            VMET= VSTR(K)*COS(PHI)+USTR(K)*SIN(PHI)                              DIAGSKT.163
            IF (SPDSTR(K) .EQ. 0.) THEN                                          DIAGSKT.164
              DIRSTR(K) = 0.                                                     DIAGSKT.165
            ELSE                                                                 DIAGSKT.166
              DIRSTR(K) = ACOS(-VMET/SPDSTR(K))*180./3.1415926535                DIAGSKT.167
              IF (UMET .GT. 0.) DIRSTR(K) = 360. - DIRSTR(K)                     DIAGSKT.168
            ENDIF                                                                DIAGSKT.169
100      CONTINUE                                                                DIAGSKT.170
C                                                                                DIAGSKT.171
         CALL READDAD(D33,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSKT.172
     *         .FALSE.,FOUND)                                                    DIAGSKT.173
         CALL SCALE(D33,'SUB ',273.16,I1,J1,K1,I1,J1,1)                          DIAGSKT.174
         CALL VERTSTR(D33,I1,J1,K1,YLOC-0.5,XLOC-0.5,TSTR,1)                     DIAGSKT.175
C                                                                                DIAGSKT.176
         CALL READDAD(D22,'P SFC   ',IDAD2D,I1,J1, 1,0,                          DIAGSKT.177
     *      .FALSE.,FOUND)                                                       DIAGSKT.178
         CALL VERTSTR(D22,I1,J1, 1,YLOC-0.5,XLOC-0.5,PSFC,1)                     DIAGSKT.179
         CALL READDAD(D22,'PSTARCRS',IDAD2D,I1,J1, 1,0,                          DIAGSKT.180
     *      .FALSE.,FOUND)                                                       DIAGSKT.181
         CALL VERTSTR(D22,I1,J1, 1,YLOC-0.5,XLOC-0.5,PSTAR,1)                    DIAGSKT.182
         CALL READDAD(D33,'PP      ',IDAD3D,I1,J1,K1,0,                          DIAGSKT.183
     *         .TRUE.,FOUND)                                                     DIAGSKT.184
         IF(.NOT.FOUND) THEN                                                     DIAGSKT.185
            DO 200 K=1,K1                                                        DIAGSKT.186
               PSTR(K)=SIGMA(K)*PSTAR+PTOP                                       DIAGSKT.187
200         CONTINUE                                                             DIAGSKT.188
         ELSE                                                                    DIAGSKT.189
            CALL VERTSTR(D33,I1,J1,K1,YLOC-0.5,XLOC-0.5,PPSTR,1)                 DIAGSKT.190
            DO 210 K=1,K1                                                        DIAGSKT.191
               PSTR(K)=SIGMA(K)*PSTAR+PTOP+PPSTR(K)                              DIAGSKT.192
210         CONTINUE                                                             DIAGSKT.193
         ENDIF                                                                   DIAGSKT.194
C                                                                                DIAGSKT.195
         IF(IDRY.NE.1) THEN                                                      DIAGSKT.196
            CALL READDAD(D32,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSKT.197
     *         .FALSE.,FOUND)                                                    DIAGSKT.198
            CALL VERTSTR(D32,I1,J1,K1,YLOC-0.5,XLOC-0.5,TDSTR,1)                 DIAGSKT.199
C                                                                                DIAGSKT.200
C           COMPUTE TD FROM T, QV                                                DIAGSKT.201
C                                                                                DIAGSKT.202
            DO 300 K=1,K1                                                        DIAGSKT.203
               EW = PSTR(K) * TDSTR(K) / (0.622 + TDSTR(K))                      DIAGSKT.204
               TDSTR(K) = DEWPT(AMAX1(EW,1.E-15))                                DIAGSKT.205
300         CONTINUE                                                             DIAGSKT.206
         ELSE IF(IDRY.EQ.1) THEN                                                 DIAGSKT.207
            CALL CLEAR(D32,I1,J1,K1)                                             DIAGSKT.208
            CALL SCALE(D32,'SUB ',99.,I1,J1,K1,I1,J1,1)                          DIAGSKT.209
            CALL VERTSTR(D32,I1,J1,K1,YLOC-0.5,XLOC-0.5,TDSTR,1)                 DIAGSKT.210
         END IF                                                                  DIAGSKT.211
         KGOOD=K1                                                                DIAGSKT.212
C                                                                                DIAGSKT.213
C     ... MODEL OUTPUT ON P                                                      DIAGSKT.214
C                                                                                DIAGSKT.215
      ELSE IF((PROG(1:6).EQ.'MMOUTP').OR.(PROG(1:6).EQ.'MZIGPR').OR.             DIAGSKT.216
     *        (PROG(1:6).EQ.'REGRID').OR.(PROG(1:6).EQ.'RAWINS').OR.             DIAGSKT.217
     *        (PROG(1:6).EQ.'MM4NHP').OR.(PROG(1:6).EQ.'MM5PRS'))THEN            DIAGSKT.218
         CALL READDAD(D31,'U       ',IDAD3D,I1,J1,K1,0,                          DIAGSKT.219
     *      .FALSE.,FOUND)                                                       DIAGSKT.220
         CALL VERTSTR(D31,I1,J1,K1,YLOC,XLOC,USTR,0)                             DIAGSKT.221
C                                                                                DIAGSKT.222
         CALL READDAD(D31,'V       ',IDAD3D,I1,J1,K1,0,                          DIAGSKT.223
     *      .FALSE.,FOUND)                                                       DIAGSKT.224
         CALL VERTSTR(D31,I1,J1,K1,YLOC,XLOC,VSTR,0)                             DIAGSKT.225
C                                                                                DIAGSKT.226
         CALL READDAD(D31,'LONGIDOT',IDAD2D,I1,J1, 1,0,                          DIAGSKT.227
     *      .FALSE.,FOUND)                                                       DIAGSKT.228
         CALL VERTSTR(D31,I1,J1, 1,YLOC,XLOC,XLONSK,0)                           DIAGSKT.229
C                                                                                DIAGSKT.230
C        CALL XYLL (XLOC+FLOAT(JMAPST-1),YLOC+FLOAT(IMAPST-1),                   19DEC02.36
C    *      YLAT,YLON)                                                           19DEC02.37
C        PHI=(XLONC-XLONSK)*XN*3.14159265/180.                                   DIAGSKT.233
         ZLON = XLONC - XLONSK                                                   DIAGSKT.234
         IF (ZLON.GT.180) ZLON = ZLON - 360.                                     DIAGSKT.235
         IF (ZLON.LT.-180) ZLON = ZLON + 360.                                    DIAGSKT.236
         PHI = ZLON*XN*3.14159265/180.                                           DIAGSKT.237
         IF (YLON.GT.180) YLON = YLON - 360.                                     DIAGSKT.238
         IF (YLON.LT.-180) YLON = YLON + 360.                                    DIAGSKT.239
         DO 1100 K=1,K1                                                          DIAGSKT.240
            SPDSTR(K)=SQRT(USTR(K)*USTR(K)+VSTR(K)*VSTR(K))                      DIAGSKT.241
            UMET=-VSTR(K)*SIN(PHI)+USTR(K)*COS(PHI)                              DIAGSKT.242
            VMET= VSTR(K)*COS(PHI)+USTR(K)*SIN(PHI)                              DIAGSKT.243
            IF (SPDSTR(K) .EQ. 0.) THEN                                          DIAGSKT.244
              DIRSTR(K) = 0.                                                     DIAGSKT.245
            ELSE                                                                 DIAGSKT.246
              DIRSTR(K) = ACOS(-VMET/SPDSTR(K))*180./3.1415926535                DIAGSKT.247
              IF (UMET .GT. 0.) DIRSTR(K) = 360. - DIRSTR(K)                     DIAGSKT.248
            ENDIF                                                                DIAGSKT.249
1100     CONTINUE                                                                DIAGSKT.250
C                                                                                DIAGSKT.251
         CALL READDAD(D33,'T       ',IDAD3D,I1,J1,K1,0,                          DIAGSKT.252
     *         .FALSE.,FOUND)                                                    DIAGSKT.253
         CALL SCALE(D33,'SUB ',273.16,I1,J1,K1,I1,J1,1)                          DIAGSKT.254
         CALL VERTSTR(D33,I1,J1,K1,YLOC-0.5,XLOC-0.5,TSTR,1)                     DIAGSKT.255
C                                                                                DIAGSKT.256
         CALL READDAD(D22,'P SFC   ',IDAD2D,I1,J1, 1,0,                          DIAGSKT.257
     *      .FALSE.,FOUND)                                                       DIAGSKT.258
         CALL VERTSTR(D22,I1,J1, 1,YLOC-0.5,XLOC-0.5,PSFC,1)                     DIAGSKT.259
         PSTR(1)=PSFC                                                            DIAGSKT.260
         DO 1200 K=2,K1                                                          DIAGSKT.261
            PSTR(K)=P(K)                                                         DIAGSKT.262
1200     CONTINUE                                                                DIAGSKT.263
C                                                                                DIAGSKT.264
         IF(IDRY.NE.1) THEN                                                      DIAGSKT.265
            CALL READDAD(D32,'Q       ',IDAD3D,I1,J1,K1,0,                       DIAGSKT.266
     *         .FALSE.,FOUND)                                                    DIAGSKT.267
            CALL VERTSTR(D32,I1,J1,K1,YLOC-0.5,XLOC-0.5,TDSTR,1)                 DIAGSKT.268
C                                                                                DIAGSKT.269
C           COMPUTE TD FROM T, QV                                                DIAGSKT.270
C                                                                                DIAGSKT.271
            DO 1300 K=1,K1                                                       DIAGSKT.272
               EW = PSTR(K) * TDSTR(K) / (0.622 + TDSTR(K))                      DIAGSKT.273
               TDSTR(K) = DEWPT(AMAX1(EW,1.E-15))                                DIAGSKT.274
1300        CONTINUE                                                             DIAGSKT.275
         ELSE IF(IDRY.EQ.1) THEN                                                 DIAGSKT.276
            CALL CLEAR(D32,I1,J1,K1)                                             DIAGSKT.277
            CALL SCALE(D32,'SUB ',99.,I1,J1,K1,I1,J1,1)                          DIAGSKT.278
            CALL VERTSTR(D32,I1,J1,K1,YLOC-0.5,XLOC-0.5,TDSTR,1)                 DIAGSKT.279
         END IF                                                                  DIAGSKT.280
C                                                                                DIAGSKT.281
C        ... FIND WHERE STRING SHOULD START, ABOVE SURFACE                       DIAGSKT.282
C                                                                                DIAGSKT.283
         DO 1400 KALL=2,K1                                                       DIAGSKT.284
            IF((PSTR(1).GT.PSTR(KALL)).AND.                                      DIAGSKT.285
     *         (PSTR(1).LE.PSTR(KALL-1))) THEN                                   DIAGSKT.286
               KSTART=KALL                                                       DIAGSKT.287
               GOTO 1401                                                         DIAGSKT.288
            END IF                                                               DIAGSKT.289
1400     CONTINUE                                                                DIAGSKT.290
         PRINT *,'TROUBLES IN SKEWT, CAN NOT FIND REASONABLE SURFACE P'          DIAGSKT.291
1401     CONTINUE                                                                DIAGSKT.292
C                                                                                DIAGSKT.293
         KCOUNT=2                                                                DIAGSKT.294
         DO 1500 K=KSTART,K1                                                     DIAGSKT.295
            PSTR   (KCOUNT)=PSTR   (K)                                           DIAGSKT.296
            SPDSTR (KCOUNT)=SPDSTR (K)                                           DIAGSKT.297
            DIRSTR (KCOUNT)=DIRSTR (K)                                           DIAGSKT.298
            TSTR   (KCOUNT)=TSTR   (K)                                           DIAGSKT.299
            TDSTR  (KCOUNT)=TDSTR  (K)                                           DIAGSKT.300
            KCOUNT=KCOUNT+1                                                      DIAGSKT.301
1500     CONTINUE                                                                DIAGSKT.302
         DO 1501 K=KCOUNT,K1                                                     DIAGSKT.303
            PSTR   (K)= BADVAL                                                   DIAGSKT.304
            SPDSTR (K)= BADVAL                                                   DIAGSKT.305
            DIRSTR (K)= BADVAL                                                   DIAGSKT.306
            TSTR   (K)= BADVAL                                                   DIAGSKT.307
            TDSTR  (K)= BADVAL                                                   DIAGSKT.308
1501     CONTINUE                                                                DIAGSKT.309
         KGOOD=KCOUNT-1                                                          DIAGSKT.310
      END IF                                                                     DIAGSKT.311
C                                                                                DIAGSKT.312
      RETURN                                                                     DIAGSKT.313
      END                                                                        DIAGSKT.314
