        SUBROUTINE DIVERG(U,V,DMF,XMF,I1,J1,K1,DS,DIV)                           DIVERG.1
C                                                                                DIVERG.2
C  SECTION DIAGNOSTIC                                                            DIVERG.3
C  PUPOSE  COMPUTES DIVERGENCE                                                   DIVERG.4
C          DIV = M*M (DU/DX + DV/DY) (PATTERNED AFTER SUBR VOR)                  DIVERG.5
C                                                                                DIVERG.6
      DIMENSION U(I1,J1,K1), V(I1,J1,K1), DIV(I1,J1,K1),                         DIVERG.7
     &  XMF(I1,J1), DMF(I1,J1)                                                   DIVERG.8
C                                                                                DIVERG.9
      IF (DS .LT. 1000.) THEN                                                    DIVERG.10
        DS2R = 1./(2.*DS*1000.)                                                  DIVERG.11
      ELSE                                                                       DIVERG.12
        DS2R = 1./(2.*DS)                                                        DIVERG.13
      ENDIF                                                                      DIVERG.14
C                                                                                DIVERG.15
      DO 100 K = 1, K1                                                           DIVERG.16
      DO 100 J = 1, J1-1                                                         DIVERG.17
      DO 100 I = 1, I1-1                                                         DIVERG.18
        U1=U(I  ,J  ,K)/DMF(I  ,J  )                                             DIVERG.19
        U2=U(I+1,J  ,K)/DMF(I+1,J  )                                             DIVERG.20
        U3=U(I  ,J+1,K)/DMF(I  ,J+1)                                             DIVERG.21
        U4=U(I+1,J+1,K)/DMF(I+1,J+1)                                             DIVERG.22
        V1=V(I  ,J  ,K)/DMF(I  ,J  )                                             DIVERG.23
        V2=V(I+1,J  ,K)/DMF(I+1,J  )                                             DIVERG.24
        V3=V(I  ,J+1,K)/DMF(I  ,J+1)                                             DIVERG.25
        V4=V(I+1,J+1,K)/DMF(I+1,J+1)                                             DIVERG.26
        DIV(I,J,K)=XMF(I,J)*XMF(I,J)*DS2R*                                       DIVERG.27
     &       ((U3-U1+U4-U2)+(V2-V1+V4-V3))                                       DIVERG.28
  100 CONTINUE                                                                   DIVERG.29
      RETURN                                                                     DIVERG.30
      END                                                                        DIVERG.31
