C                                                                                DRWSTR.1
C	$ID: DRWSTR.F,V 2.0 1997/01/11 20:31:11 MESOUSER EXP $                         DRWSTR.2
C                                                                                DRWSTR.3
      SUBROUTINE DRWSTR  (U,V,UX,VY,IMAX,JPTSY)                                  DRWSTR.4
C                                                                                DRWSTR.5
      PARAMETER (NCHK=750)                                                       DRWSTR.6
C                                                                                DRWSTR.7
C THIS ROUTINE DRAWS THE STREAMLINES.                                            DRWSTR.8
C .   THE XCHK AND YCHK ARRAYS SERVE AS A CIRCULAR LIST. THEY                    DRWSTR.9
C .   ARE USED TO PREVENT LINES FROM CROSSING ONE ANOTHER.                       DRWSTR.10
C                                                                                DRWSTR.11
C THE WORK ARRAY HAS BEEN BROKEN UP INTO TWO ARRAYS FOR CLARITY.  THE            DRWSTR.12
C .   TOP HALF OF WORK (CALLED UX) WILL HAVE THE NORMALIZED (AND                 DRWSTR.13
C .   POSSIBLY TRANSFORMED) U COMPONENTS AND WILL BE USED FOR BOOK               DRWSTR.14
C .   KEEPING.  THE LOWER HALF OF THE WORK ARRAY (CALLED VY) WILL                DRWSTR.15
C .   CONTAIN THE NORMALIZED (AND POSSIBLY TRANSFORMED) V COMPONENTS.            DRWSTR.16
C                                                                                DRWSTR.17
      DIMENSION       U(IMAX,JPTSY)         ,V(IMAX,JPTSY)                       DRWSTR.18
     1             ,  UX(IMAX,JPTSY)        ,VY(IMAX,JPTSY)                      DRWSTR.19
      COMMON /STR01/  IS         ,IEND      ,JS        ,JEND                     DRWSTR.20
     1             ,  IEND1      ,JEND1     ,I         ,J                        DRWSTR.21
     2             ,  X          ,Y         ,DELX      ,DELY                     DRWSTR.22
     3             ,  ICYC1      ,IMSG1     ,IGFL1                               DRWSTR.23
      COMMON /STR03/  INITA , INITB , AROWL , ITERP , ITERC , IGFLG              DRWSTR.24
     1             ,  IMSG , UVMSG , ICYC , DISPL , DISPC , CSTOP                DRWSTR.25
      COMMON /STR04/  XCHK(NCHK) ,YCHK(NCHK) , NUMCHK , UXSML                    DRWSTR.26
C                                                                                DRWSTR.27
C                                                                                DRWSTR.28
        SAVE                                                                     DRWSTR.29
C                                                                                DRWSTR.30
C STATEMENT FUNCTIONS FOR SPATIAL AND VELOCITY TRANSFORMATIONS.                  DRWSTR.31
C .   (IF THE USER WISHES OTHER TRANSFORMATIONS  REPLACE THESE STATEMENT         DRWSTR.32
C .   FUNCTIONS WITH THE APPROPRIATE NEW ONES, OR , IF THE TRANSFORMA-           DRWSTR.33
C .   TIONS ARE COMPLICATED DELETE THESE STATEMENT FUNCTIONS                     DRWSTR.34
C .   AND ADD EXTERNAL ROUTINES WITH THE SAME NAMES TO DO THE TRANS-             DRWSTR.35
C .   FORMING.)                                                                  DRWSTR.36
C                                                                                DRWSTR.37
C     FX(X,Y) = X                                                                DRWSTR.38
C     FY(X,Y) = Y                                                                DRWSTR.39
      FU(X,Y) = X                                                                DRWSTR.40
      FV(X,Y) = Y                                                                DRWSTR.41
C                                                                                DRWSTR.42
C INITIALIZE                                                                     DRWSTR.43
C                                                                                DRWSTR.44
      ISKIP    = I1MACH(5) - 2                                                   DRWSTR.45
      ISKIP1   = ISKIP + 1                                                       DRWSTR.46
      UXSML    = R1MACH(3) * DISPL                                               DRWSTR.47
C                                                                                DRWSTR.48
C                                                                                DRWSTR.49
      NUMCHK   = NCHK                                                            DRWSTR.50
      LCHK = 1                                                                   DRWSTR.51
      ICHK = 1                                                                   DRWSTR.52
      XCHK(1) = 0.                                                               DRWSTR.53
      YCHK(1) = 0.                                                               DRWSTR.54
      KFLAG = 0                                                                  DRWSTR.55
      IZERO = 0                                                                  DRWSTR.56
      IONE = 1                                                                   DRWSTR.57
      ITWO = 2                                                                   DRWSTR.58
C                                                                                DRWSTR.59
C                                                                                DRWSTR.60
C COMPUTE THE X AND Y NORMALIZED (AND POSSIBLY TRANSFORMED)                      DRWSTR.61
C .   DISPLACEMENT COMPONENTS (UX AND VY).                                       DRWSTR.62
C                                                                                DRWSTR.63
      DO  40 J=JS,JEND                                                           DRWSTR.64
      DO  30 I=IS,IEND                                                           DRWSTR.65
      UX(I,J) = FU(U(I,J),V(I,J))                                                DRWSTR.66
      VY(I,J) = FV(U(I,J),V(I,J))                                                DRWSTR.67
      IF (UX(I,J).NE.0. .OR. VY(I,J).NE.0.) THEN                                 DRWSTR.68
        CON = DISPL/SQRT(UX(I,J)*UX(I,J) + VY(I,J)*VY(I,J))                      DRWSTR.69
        UX(I,J) = CON*UX(I,J)                                                    DRWSTR.70
        VY(I,J) = CON*VY(I,J)                                                    DRWSTR.71
      END IF                                                                     DRWSTR.72
C                                                                                DRWSTR.73
C BOOKKEEPING IS DONE IN THE LEAST SIGNIFICANT BITS OF THE UX ARRAY.             DRWSTR.74
C .   WHEN UX(I,J) IS EXACTLY ZERO THIS CAN PRESENT SOME PROBLEMS.               DRWSTR.75
C .   TO GET AROUND THIS PROBLEM, SET IT TO A RELATIVELY SMALL NUMBER.           DRWSTR.76
C                                                                                DRWSTR.77
      IF(UX(I,J) .EQ. 0.) UX(I,J) = UXSML                                        DRWSTR.78
C                                                                                DRWSTR.79
C MASK OUT THE LEAST SIGNIFICANT TWO BITS AS FLAGS FOR EACH GRID BOX             DRWSTR.80
C .   A GRID BOX IS ANY REGION SURROUNDED BY FOUR GRID POINTS.                   DRWSTR.81
C .   FLAG 1 INDICATES WHETHER ANY STREAMLINE HAS PREVIOUSLY PASSED              DRWSTR.82
C .          THROUGH THIS BOX.                                                   DRWSTR.83
C .   FLAG 2 INDICATES WHETHER ANY DIRECTIONAL ARROW HAS ALREADY                 DRWSTR.84
C .          APPEARED IN THIS BOX.                                               DRWSTR.85
C .   JUDICIOUS USE OF THESE FLAGS PREVENTS OVERCROWDING OF                      DRWSTR.86
C .   STREAMLINES AND DIRECTIONAL ARROWS.                                        DRWSTR.87
C                                                                                DRWSTR.88
      CALL SBYTES( UX(I,J) , IZERO , ISKIP , 2 , 0 , 1 )                         DRWSTR.89
C                                                                                DRWSTR.90
      IF (MOD(I,INITA).NE.0 .OR. MOD(J,INITA).NE.0)                              DRWSTR.91
     1    CALL SBYTES( UX(I,J) , IONE , ISKIP1, 1 , 0 , 1 )                      DRWSTR.92
      IF (MOD(I,INITB).NE.0 .OR. MOD(J,INITB).NE.0)                              DRWSTR.93
     1    CALL SBYTES( UX(I,J) , IONE , ISKIP , 1 , 0 , 1 )                      DRWSTR.94
C                                                                                DRWSTR.95
   30 CONTINUE                                                                   DRWSTR.96
   40 CONTINUE                                                                   DRWSTR.97
C                                                                                DRWSTR.98
   50 CONTINUE                                                                   DRWSTR.99
C                                                                                DRWSTR.100
C START A STREAMLINE. EXPERIENCE HAS SHOWN THAT A PLEASING PICTURE               DRWSTR.101
C .   WILL BE PRODUCED IF NEW STREAMLINES ARE STARTED ONLY IN GRID               DRWSTR.102
C .   BOXES THAT PREVIOUSLY HAVE NOT HAD OTHER STREAMLINES PASS THROUGH          DRWSTR.103
C .   THEM. AS LONG AS A REASONABLY DENSE PATTERN OF AVAILABLE BOXES             DRWSTR.104
C .   IS INITIALLY PRESCRIBED, THE ORDER OF SCANNING THE GRID PTS. FOR           DRWSTR.105
C .   AVAILABLE BOXES IS IMMATERIAL                                              DRWSTR.106
C                                                                                DRWSTR.107
C FIND AN AVAILABLE BOX FOR STARTING A STREAMLINE                                DRWSTR.108
C                                                                                DRWSTR.109
      IF (KFLAG.NE.0) GO TO  90                                                  DRWSTR.110
      DO  70 J=JS,JEND1                                                          DRWSTR.111
      DO  60 I=IS,IEND1                                                          DRWSTR.112
      CALL GBYTES( UX(I,J) , IUX , ISKIP , 2 , 0 , 1 )                           DRWSTR.113
      IF ( IAND( IUX , IONE ) .EQ. IZERO ) GO TO 80                              DRWSTR.114
   60 CONTINUE                                                                   DRWSTR.115
   70 CONTINUE                                                                   DRWSTR.116
C                                                                                DRWSTR.117
C MUST BE NO AVAILABLE BOXES FOR STARTING A STREAMLINE                           DRWSTR.118
C                                                                                DRWSTR.119
      GO TO 190                                                                  DRWSTR.120
   80 CONTINUE                                                                   DRWSTR.121
C                                                                                DRWSTR.122
C INITILIZE PARAMETERS FOR STARTING A STREAMLINE                                 DRWSTR.123
C .   TURN THE BOX OFF FOR STARTING A STREAMLINE                                 DRWSTR.124
C .   CHECK TO SEE IF THIS BOX HAS MISSING DATA (IMSG.NE.0). IF SO ,             DRWSTR.125
C .      FIND A NEW STARTING BOX                                                 DRWSTR.126
C                                                                                DRWSTR.127
      CALL SBYTES( UX(I,J) , IONE , ISKIP1 , 1 , 0 , 1 )                         DRWSTR.128
      IF ( IMSG.EQ.0) GO TO 85                                                   DRWSTR.129
      IF (U(I,J).EQ.UVMSG .OR. U(I,J+1).EQ.UVMSG .OR.                            DRWSTR.130
     1    U(I+1,J).EQ.UVMSG .OR. U(I+1,J+1).EQ.UVMSG) GO TO 50                   DRWSTR.131
C                                                                                DRWSTR.132
   85 ISAV = I                                                                   DRWSTR.133
      JSAV = J                                                                   DRWSTR.134
      KFLAG = 1                                                                  DRWSTR.135
      PLMN1 = +1.                                                                DRWSTR.136
      GO TO 100                                                                  DRWSTR.137
   90 CONTINUE                                                                   DRWSTR.138
C                                                                                DRWSTR.139
C COME TO HERE TO DRAW IN THE OPPOSITE DIRECTION                                 DRWSTR.140
C                                                                                DRWSTR.141
      KFLAG = 0                                                                  DRWSTR.142
      PLMN1 = -1.                                                                DRWSTR.143
      I = ISAV                                                                   DRWSTR.144
      J = JSAV                                                                   DRWSTR.145
  100 CONTINUE                                                                   DRWSTR.146
C                                                                                DRWSTR.147
C INITIATE THE DRAWING SEQUENCE                                                  DRWSTR.148
C .   START ALL STREAMLINES IN THE CENTER OF A BOX                               DRWSTR.149
C                                                                                DRWSTR.150
      NBOX = 0                                                                   DRWSTR.151
      ITER = 0                                                                   DRWSTR.152
      IF (KFLAG.NE.0) ICHKB = ICHK+1                                             DRWSTR.153
      IF (ICHKB.GT.NUMCHK) ICHKB = 1                                             DRWSTR.154
      X = FLOAT(I)+0.5                                                           DRWSTR.155
      Y = FLOAT(J)+0.5                                                           DRWSTR.156
      XBASE = X                                                                  DRWSTR.157
      YBASE = Y                                                                  DRWSTR.158
      CALL FL2INT (FX(X,Y),FY(X,Y),IFX,IFY)                                      DRWSTR.159
      CALL PLOTIT (IFX,IFY,0)                                                    DRWSTR.160
      CALL GBYTES( UX(I,J) , IUX , ISKIP , 2 , 0 , 1 )                           DRWSTR.161
      IF ( (KFLAG.EQ.0) .OR. (IAND( IUX , ITWO ) .NE. 0 ) ) GO TO 110            DRWSTR.162
C                                                                                DRWSTR.163
C GRID BOX MUST BE ELIGIBLE FOR A DIRECTIONAL ARROW                              DRWSTR.164
C                                                                                DRWSTR.165
      CALL GNEWPT (UX,VY,IMAX,JPTSY)                                             DRWSTR.166
      MFLAG = 1                                                                  DRWSTR.167
      GO TO 160                                                                  DRWSTR.168
C                                                                                DRWSTR.169
  110 CONTINUE                                                                   DRWSTR.170
C                                                                                DRWSTR.171
C PLOT LOOP                                                                      DRWSTR.172
C .   CHECK TO SEE IF THE STREAMLINE HAS ENTERED A NEW GRID BOX                  DRWSTR.173
C                                                                                DRWSTR.174
      IF (I.NE.IFIX(X) .OR. J.NE.IFIX(Y)) GO TO 120                              DRWSTR.175
C                                                                                DRWSTR.176
C MUST BE IN SAME BOX CALCULATE THE DISPLACEMENT COMPONENTS                      DRWSTR.177
C                                                                                DRWSTR.178
      CALL GNEWPT (UX,VY,IMAX,JPTSY)                                             DRWSTR.179
C                                                                                DRWSTR.180
C UPDATE THE POSITION AND DRAW THE VECTOR                                        DRWSTR.181
C                                                                                DRWSTR.182
      X = X+PLMN1*DELX                                                           DRWSTR.183
      Y = Y+PLMN1*DELY                                                           DRWSTR.184
      CALL FL2INT (FX(X,Y),FY(X,Y),IFX,IFY)                                      DRWSTR.185
      CALL PLOTIT (IFX,IFY,1)                                                    DRWSTR.186
      ITER = ITER+1                                                              DRWSTR.187
C                                                                                DRWSTR.188
C CHECK STREAMLINE PROGRESS EVERY 'ITERP' OR SO ITERATIONS                       DRWSTR.189
C                                                                                DRWSTR.190
      IF (MOD(ITER,ITERP).NE.0) GO TO 115                                        DRWSTR.191
      IF (ABS(X-XBASE).LT.DISPC  .AND. ABS(Y-YBASE).LT.DISPC ) GO TO  50         DRWSTR.192
      XBASE = X                                                                  DRWSTR.193
      YBASE = Y                                                                  DRWSTR.194
      GO TO 110                                                                  DRWSTR.195
  115 CONTINUE                                                                   DRWSTR.196
C                                                                                DRWSTR.197
C SHOULD THE CIRCULAR LISTS BE CHECKED FOR STREAMLINE CROSSOVER                  DRWSTR.198
C                                                                                DRWSTR.199
      IF ( (ITERC.LT.0) .OR. (MOD(ITER,ITERC).NE.0) ) GO TO 110                  DRWSTR.200
C                                                                                DRWSTR.201
C MUST WANT THE CIRCULAR LIST CHECKED                                            DRWSTR.202
C                                                                                DRWSTR.203
      GO TO 130                                                                  DRWSTR.204
  120 CONTINUE                                                                   DRWSTR.205
C                                                                                DRWSTR.206
C MUST HAVE ENTERED A NEW GRID BOX  CHECK FOR THE FOLLOWING :                    DRWSTR.207
C .   (1) ARE THE NEW POINTS ON THE GRID                                         DRWSTR.208
C .   (2) CHECK FOR MISSING DATA IF MSG  DATA FLAG (IMSG) HAS BEEN SET.          DRWSTR.209
C .   (3) IS THIS BOX ELIGIBLE FOR A DIRECTIONAL ARROW                           DRWSTR.210
C .   (4) LOCATION OF THIS ENTRY VERSUS OTHER STREAMLINE ENTRIES                 DRWSTR.211
C                                                                                DRWSTR.212
      NBOX = NBOX+1                                                              DRWSTR.213
C                                                                                DRWSTR.214
C CHECK (1)                                                                      DRWSTR.215
C                                                                                DRWSTR.216
      IF (IFIX(X).LT.IS .OR. IFIX(X).GT.IEND1) GO TO  50                         DRWSTR.217
      IF (IFIX(Y).LT.JS .OR. IFIX(Y).GT.JEND1) GO TO  50                         DRWSTR.218
C                                                                                DRWSTR.219
C CHECK (2)                                                                      DRWSTR.220
C                                                                                DRWSTR.221
      IF ( IMSG.EQ.0) GO TO 125                                                  DRWSTR.222
      II = IFIX(X)                                                               DRWSTR.223
      JJ = IFIX(Y)                                                               DRWSTR.224
      IF (U(II,JJ).EQ.UVMSG .OR. U(II,JJ+1).EQ.UVMSG .OR.                        DRWSTR.225
     1    U(II+1,JJ).EQ.UVMSG .OR. U(II+1,JJ+1).EQ.UVMSG) GO TO 50               DRWSTR.226
  125 CONTINUE                                                                   DRWSTR.227
C                                                                                DRWSTR.228
C CHECK (3)                                                                      DRWSTR.229
C                                                                                DRWSTR.230
      CALL GBYTES( UX(I,J) , IUX , ISKIP , 2 , 0 , 1 )                           DRWSTR.231
      IF ( IAND( IUX , ITWO )  .NE. 0) GO TO 130                                 DRWSTR.232
      MFLAG = 2                                                                  DRWSTR.233
      GO TO 160                                                                  DRWSTR.234
  130 CONTINUE                                                                   DRWSTR.235
C                                                                                DRWSTR.236
C CHECK (4)                                                                      DRWSTR.237
C                                                                                DRWSTR.238
      DO 140 LOC=1,LCHK                                                          DRWSTR.239
      IF (ABS( X-XCHK(LOC) ).GT.CSTOP .OR.                                       DRWSTR.240
     1    ABS( Y-YCHK(LOC) ).GT.CSTOP) GO TO 140                                 DRWSTR.241
      LFLAG = 1                                                                  DRWSTR.242
      IF (ICHKB.LE.ICHK .AND. LOC.GE.ICHKB .AND. LOC.LE.ICHK) LFLAG = 2          DRWSTR.243
      IF (ICHKB.GE.ICHK .AND. (LOC.GE.ICHKB .OR. LOC.LE.ICHK)) LFLAG = 2         DRWSTR.244
      IF (LFLAG.EQ.1) GO TO  50                                                  DRWSTR.245
  140 CONTINUE                                                                   DRWSTR.246
      LCHK = MIN0(LCHK+1,NUMCHK)                                                 DRWSTR.247
      ICHK = ICHK+1                                                              DRWSTR.248
      IF (ICHK.GT.NUMCHK) ICHK = 1                                               DRWSTR.249
      XCHK(ICHK) = X                                                             DRWSTR.250
      YCHK(ICHK) = Y                                                             DRWSTR.251
      I = IFIX(X)                                                                DRWSTR.252
      J = IFIX(Y)                                                                DRWSTR.253
      CALL SBYTES( UX(I,J) , IONE , ISKIP1 , 1 , 0 , 1 )                         DRWSTR.254
      IF (NBOX.LT.5) GO TO 150                                                   DRWSTR.255
      ICHKB = ICHKB+1                                                            DRWSTR.256
      IF (ICHKB.GT.NUMCHK) ICHKB = 1                                             DRWSTR.257
  150 CONTINUE                                                                   DRWSTR.258
      GO TO 110                                                                  DRWSTR.259
C                                                                                DRWSTR.260
  160 CONTINUE                                                                   DRWSTR.261
C                                                                                DRWSTR.262
C THIS SECTION DRAWS A DIRECTIONAL ARROW BASED ON THE MOST RECENT DIS-           DRWSTR.263
C .   PLACEMENT COMPONENTS ,DELX AND DELY, RETURNED BY GNEWPT. IN EARLIE         DRWSTR.264
C .   VERSIONS THIS WAS A SEPARATE SUBROUTINE (CALLED DRWDAR). IN THAT           DRWSTR.265
C .   CASE ,HOWEVER, FX AND FY WERE DEFINED EXTERNAL SINCE THESE                 DRWSTR.266
C .   FUNCTIONS WERE USED BY BOTH DRWSTR AND DRWDAR. IN ORDER TO                 DRWSTR.267
C .   MAKE ALL DEFAULT TRANSFORMATIONS STATEMENT FUNCTIONS I HAVE                DRWSTR.268
C .   PUT DRWDAR  HERE AND I WILL USE MFLAG TO RETURN  TO THE CORRECT            DRWSTR.269
C .   LOCATION IN THE CODE.                                                      DRWSTR.270
C                                                                                DRWSTR.271
      IF ( (DELX.EQ.0.) .AND. (DELY.EQ.0.) ) GO TO 50                            DRWSTR.272
C                                                                                DRWSTR.273
      CALL SBYTES( UX(I,J) ,IONE , ISKIP , 1 ,0 , 1 )                            DRWSTR.274
      D = ATAN2(-DELX,DELY)                                                      DRWSTR.275
      D30 = D+0.5                                                                DRWSTR.276
  170 YY = -AROWL*COS(D30)+Y                                                     DRWSTR.277
      XX = +AROWL*SIN(D30)+X                                                     DRWSTR.278
      CALL FL2INT (FX(XX,YY),FY(XX,YY),IFXX,IFYY)                                DRWSTR.279
      CALL PLOTIT (IFXX,IFYY,1)                                                  DRWSTR.280
      CALL FL2INT (FX(X,Y),FY(X,Y),IFX,IFY)                                      DRWSTR.281
      CALL PLOTIT (IFX,IFY,0)                                                    DRWSTR.282
      IF (D30.LT.D) GO TO 180                                                    DRWSTR.283
      D30 = D-0.5                                                                DRWSTR.284
      GO TO 170                                                                  DRWSTR.285
  180 IF (MFLAG.EQ.1) GO TO 110                                                  DRWSTR.286
      IF (MFLAG.EQ.2) GO TO 130                                                  DRWSTR.287
C                                                                                DRWSTR.288
  190 CONTINUE                                                                   DRWSTR.289
C                                                                                DRWSTR.290
C     FLUSH PLOTIT BUFFER                                                        DRWSTR.291
C                                                                                DRWSTR.292
      CALL PLOTIT(0,0,0)                                                         DRWSTR.293
      RETURN                                                                     DRWSTR.294
      END                                                                        DRWSTR.295
