C                                                                                DRWVCN.1
      SUBROUTINE DRWVCN (M1,M2,M3,M4,ITRI,IARR,EXTR,IFORM,LABEL,NC)              DRWVCN.2
C                                                                                DRWVCN.3
C THIS ROUTINE IS CALLED TO DRAW A SINGLE ARROW.  IT HAS ARGUMENTS AS            DRWVCN.4
C FOLLOWS -                                                                      DRWVCN.5
C                                                                                DRWVCN.6
C     (M1,M2)  -  COORDINATE OF ARROW BASE, ON A 2**15 X 2**15 GRID.             DRWVCN.7
C     (M3,M4)  -  COORDINATE OF ARROW HEAD, ON A 2**15 X 2**15 GRID.             DRWVCN.8
C     LABEL    -  CHARACTER LABEL TO BE PUT ABOVE ARROW.                         DRWVCN.9
C     NC       -  NUMBER OF CHARACTERS IN LABEL.                                 DRWVCN.10
C                                                                                DRWVCN.11
        SAVE                                                                     DRWVCN.12
C                                                                                DRWVCN.13
C                                                                                DRWVCN.14
      COMMON /VEC1/   ASH        ,EXT        ,ICTRFG     ,ILAB       ,           DRWVCN.15
     +                IOFFD      ,IOFFM      ,ISX        ,ISY        ,           DRWVCN.16
     +                RMN        ,RMX        ,SIDE       ,SIZE       ,           DRWVCN.17
     +                XLT        ,YBT        ,ZMN        ,ZMX                    DRWVCN.18
      COMMON /VEC3/  LENVMX      ,VMX        ,EPSVL      ,VMAX                   DRWVCN.19
C                                                                                DRWVCN.20
        CHARACTER*10 LABEL                                                       DRWVCN.21
C                                                                                DRWVCN.22
C SOME LOCAL PARAMETERS ARE THE FOLLOWING -                                      DRWVCN.23
C                                                                                DRWVCN.24
C     CL     -  ARROW HEAD LENGTH SCALE FACTOR - EACH SIDE OF THE ARROW          DRWVCN.25
C               HEAD IS THIS LONG RELATIVE TO THE LENGTH OF THE ARROW            DRWVCN.26
C     ST,CT  -  SIN AND COS OF THE ARROW HEAD ANGLE                              DRWVCN.27
C     PI     -  THE CONSTANT PI                                                  DRWVCN.28
C     TWOPI  -  TWO TIMES PI                                                     DRWVCN.29
C     OHOPI  -  ONE HALF OF PI                                                   DRWVCN.30
C     FHOPI  -  FIVE HALVES OF PI                                                DRWVCN.31
C                                                                                DRWVCN.32
      DATA    CL / .25 /                                                         DRWVCN.33
      DATA    ST / .216439614/                                                   DRWVCN.34
      DATA    CT / .976296007/                                                   DRWVCN.35
      DATA    PI / 3.14159265358979 /                                            DRWVCN.36
      DATA TWOPI / 6.28318530717959 /                                            DRWVCN.37
      DATA OHOPI / 1.57079632679489 /                                            DRWVCN.38
      DATA FHOPI / 7.85398163397448 /                                            DRWVCN.39
C                                                                                DRWVCN.40
      DATA    C2 / 0.60 /    ! ORIGINALLY 0.60   HEIGHT                          DRWVCN.41
      DATA    C4 / 0.342 /   ! ORIGINALLY 0.50   FATNESS                         DRWVCN.42
      DATA  IBIG / 6500 /                                                        DRWVCN.43
C                                                                                DRWVCN.44
      DIST(X,Y) = SQRT(X*X+Y*Y)                                                  DRWVCN.45
C                                                                                DRWVCN.46
C TRANSFER ARGUMENTS TO LOCAL VARIABLES AND COMPUTE THE VECTOR LENGTH.           DRWVCN.47
C                                                                                DRWVCN.48
      N1 = M1                                                                    DRWVCN.49
      N2 = M2                                                                    DRWVCN.50
      N3 = M3                                                                    DRWVCN.51
      N4 = M4                                                                    DRWVCN.52
      DX = N3-N1                                                                 DRWVCN.53
      DY = N4-N2                                                                 DRWVCN.54
      R = DIST(DX,DY)                                                            DRWVCN.55
C                                                                                DRWVCN.56
C SORT OUT POSSIBLE CASES, DEPENDING ON VECTOR LENGTH.                           DRWVCN.57
C                                                                                DRWVCN.58
      IF (R .LE. ZMN) RETURN                                                     DRWVCN.59
C                                                                                DRWVCN.60
      IF (R .LE. ZMX) GO TO 101                                                  DRWVCN.61
C                                                                                DRWVCN.62
C PLOT A POINT FOR VECTORS WHICH ARE TOO LONG.                                   DRWVCN.63
C                                                                                DRWVCN.64
      CALL PLOTIT (N1,N2,0)                                                      DRWVCN.65
      CALL PLOTIT (N1,N2,1)                                                      DRWVCN.66
      CALL PLOTIT (N1,N2,0)                                                      DRWVCN.67
      RETURN                                                                     DRWVCN.68
C                                                                                DRWVCN.69
C ADJUST THE COORDINATES OF THE VECTOR ENDPOINTS AS IMPLIED BY THE               DRWVCN.70
C CENTERING OPTION.                                                              DRWVCN.71
C                                                                                DRWVCN.72
  101 IF (ICTRFG) 102,103,104                                                    DRWVCN.73
C                                                                                DRWVCN.74
  102 N3 = N1                                                                    DRWVCN.75
      N4 = N2                                                                    DRWVCN.76
      N1 = FLOAT(N1)-DX                                                          DRWVCN.77
      N2 = FLOAT(N2)-DY                                                          DRWVCN.78
      GO TO 104                                                                  DRWVCN.79
C                                                                                DRWVCN.80
  103 N1 = FLOAT(N1)-.5*DX                                                       DRWVCN.81
      N2 = FLOAT(N2)-.5*DY                                                       DRWVCN.82
      N3 = FLOAT(N3)-.5*DX                                                       DRWVCN.83
      N4 = FLOAT(N4)-.5*DY                                                       DRWVCN.84
C                                                                                DRWVCN.85
C DETERMINE THE COORDINATES OF THE POINTS USED TO DRAW THE ARROWHEAD.            DRWVCN.86
C                                                                                DRWVCN.87
  104 IF (IFORM .EQ. 3) GOTO 105                                                 DRWVCN.88
      C1 = CL                                                                    DRWVCN.89
C                                                                                DRWVCN.90
C SHORT ARROWS HAVE HEADS OF A FIXED MINIMUM SIZE.                               DRWVCN.91
C                                                                                DRWVCN.92
      IF (R .LT. RMN) C1 = RMN*CL/R                                              DRWVCN.93
C                                                                                DRWVCN.94
C LONG ARROWS HAVE HEADS OF A FIXED MAXIMUM SIZE.                                DRWVCN.95
C                                                                                DRWVCN.96
      IF (R .GT. RMX) C1 = RMX*CL/R                                              DRWVCN.97
C                                                                                DRWVCN.98
C COMPUTE THE COORDINATES OF THE HEAD.                                           DRWVCN.99
C                                                                                DRWVCN.100
      N5 = FLOAT(N3)-C1*(CT*DX-ST*DY)                                            DRWVCN.101
      N6 = FLOAT(N4)-C1*(CT*DY+ST*DX)                                            DRWVCN.102
      N7 = FLOAT(N3)-C1*(CT*DX+ST*DY)                                            DRWVCN.103
      N8 = FLOAT(N4)-C1*(CT*DY-ST*DX)                                            DRWVCN.104
C                                                                                DRWVCN.105
C PLOT THE ARROW.                                                                DRWVCN.106
C                                                                                DRWVCN.107
      CALL PLOTIT (N1,N2,0)                                                      DRWVCN.108
      CALL PLOTIT (N3,N4,1)                                                      DRWVCN.109
      CALL PLOTIT (N5,N6,0)                                                      DRWVCN.110
      CALL PLOTIT (N3,N4,1)                                                      DRWVCN.111
      CALL PLOTIT (N7,N8,1)                                                      DRWVCN.112
      GO TO 110                                                                  DRWVCN.113
  105 CONTINUE                                                                   DRWVCN.114
C                                                                                DRWVCN.115
C COMPUTE TAILS                                                                  DRWVCN.116
C                                                                                DRWVCN.117
      CALL PLOTIT (N3,N4,0)                                                      DRWVCN.118
      CALL PLOTIT (N1,N2,1)                                                      DRWVCN.119
      C3 = 0.                                                                    DRWVCN.120
      N7 = N1                                                                    DRWVCN.121
      N8 = N2                                                                    DRWVCN.122
      IF (ITRI .EQ. 0) GO TO 107                                                 DRWVCN.123
      DO 106 II=1,ITRI                                                           DRWVCN.124
      N7 = FLOAT(N7)+C4*DX + 0.5                                                 DRWVCN.125
      N8 = FLOAT(N8)+C4*DY + 0.5                                                 DRWVCN.126
      N5 = FLOAT(N7) - C2*(ST*DX + CT*DY) + 0.5                                  DRWVCN.127
      N6 = FLOAT(N8) - C2*(ST*DY - CT*DX) + 0.5                                  DRWVCN.128
      CALL PLOTIT (N5,N6,1)                                                      DRWVCN.129
 106  CALL PLOTIT (N7,N8,1)                                                      DRWVCN.130
      C3 = 1.    ! WAS 2                                                         DRWVCN.131
  107 IF (IARR .EQ. 0) GO TO 109                                                 DRWVCN.132
      DO 108 II=1,IARR                                                           DRWVCN.133
      N7 = FLOAT(N7)+C2*C3*CL*DX + 0.5                                           DRWVCN.134
      N8 = FLOAT(N8)+C2*C3*CL*DY + 0.5                                           DRWVCN.135
      CALL PLOTIT (N7,N8,0)                                                      DRWVCN.136
      N5 = FLOAT(N7) - C2*(ST*DX + CT*DY) + 0.5                                  DRWVCN.137
      N6 = FLOAT(N8) - C2*(ST*DY - CT*DX) + 0.5                                  DRWVCN.138
      C3 = 1.    ! WAS 2                                                         DRWVCN.139
  108 CALL PLOTIT (N5,N6,1)                                                      DRWVCN.140
  109 IF (EXTR .EQ. 0.) GO TO 110                                                DRWVCN.141
C	MOVE 5 KTS AWAY FROM END OF BARB                                               DRWVCN.142
      IF (ITRI .EQ. 0 .AND. IARR .EQ. 0) THEN                                    DRWVCN.143
         C3 = 1.                                                                 DRWVCN.144
      ENDIF                                                                      DRWVCN.145
      N7 = FLOAT(N7)+C2*C3*CL*DX + 0.5                                           DRWVCN.146
      N8 = FLOAT(N8)+C2*C3*CL*DY + 0.5                                           DRWVCN.147
      CALL PLOTIT (N7,N8,0)                                                      DRWVCN.148
      N5 = FLOAT(N7) - C2*(ST*DX + CT*DY)*EXTR + 0.5                             DRWVCN.149
      N6 = FLOAT(N8) - C2*(ST*DY - CT*DX)*EXTR + 0.5                             DRWVCN.150
      N5 = MAX0(1,N5)                                                            DRWVCN.151
      N6 = MAX0(1,N6)                                                            DRWVCN.152
      CALL PLOTIT (N5,N6,1)                                                      DRWVCN.153
  110 CONTINUE                                                                   DRWVCN.154
      CALL PLOTIT (0,0,0)                                                        DRWVCN.155
C                                                                                DRWVCN.156
C IF REQUESTED, PUT THE VECTOR MAGNITUDE ABOVE THE ARROW.                        DRWVCN.157
C                                                                                DRWVCN.158
C     NC=0                                                                       DRWVCN.159
      IF (NC .EQ. 0) RETURN                                                      DRWVCN.160
      PHI = ATAN2(DY,DX)                                                         DRWVCN.161
      IF (AMOD(PHI+FHOPI,TWOPI) .GT. PI) PHI = PHI+PI                            DRWVCN.162
      IX = 1+IFIX(.5*FLOAT(N1+N3)+1.25*                                          DRWVCN.163
     +            FLOAT(ISX*MAX0(IFIX(SIZE)/ISX,8))*COS(PHI+OHOPI))/ISX          DRWVCN.164
      IY = 1+IFIX(.5*FLOAT(N2+N4)+1.25*                                          DRWVCN.165
     +            FLOAT(ISX*MAX0(IFIX(SIZE)/ISX,8))*SIN(PHI+OHOPI))/ISY          DRWVCN.166
        CALL GQCNTN(IER,ICN)                                                     DRWVCN.167
        CALL GSELNT(0)                                                           DRWVCN.168
        XC = CPUX(IX)                                                            DRWVCN.169
        YC = CPUY(IY)                                                            DRWVCN.170
      CALL WTSTR(XC,YC,                                                          DRWVCN.171
     +           LABEL,MAX0(IFIX(SIZE)/ISX,8),                                   DRWVCN.172
     +                                     IFIX(57.2957795130823*PHI),0)         DRWVCN.173
        CALL GSELNT(ICN)                                                         DRWVCN.174
      RETURN                                                                     DRWVCN.175
      END                                                                        DRWVCN.176
