      SUBROUTINE GEOPOT(T,Q,TER,PS,IDRY,SIGH,PTOP,I1,J1,K1,                      GEOPOT.1
     *                  PHIH,PHIF )                                              GEOPOT.2
                                                                                 GEOPOT.3
#     include <scratch.incl>                                                     GEOPOT.4
C                                                                                GEOPOT.5
      INEED = 2*(I1*J1*(K1+1)) + I1*J1                                           GEOPOT.6
      IN1 = NTEMP                                                                GEOPOT.7
      IN2 = IN1 + (I1*J1*(K1+1))                                                 GEOPOT.8
      IN3 = IN2 + (I1*J1*(K1))                                                   GEOPOT.9
      NTEMP = NTEMP+INEED                                                        GEOPOT.10
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('GEOPOT')                         GEOPOT.11
      IF(VERBOSE) WRITE(6,*) ' CALLING GEOPOT ',INEED,IN1,NTEMP                  GEOPOT.12
        CALL GEOPOT_0(T,Q,TER,PS,IDRY,SIGH,PTOP,I1,J1,K1,                        GEOPOT.13
     *                  PHIH,SCR(IN1),SCR(IN2),SCR(IN3))                         GEOPOT.14
      NTEMP = NTEMP - INEED                                                      GEOPOT.15
      IF(VERBOSE) WRITE(6,*) ' RET FROM GEOPOT ',NTEMP                           GEOPOT.16
      RETURN                                                                     GEOPOT.17
      END                                                                        GEOPOT.18
C                                                                                GEOPOT.19
      SUBROUTINE GEOPOT_0(T,Q,TER,PS,IDRY,SIGH,PTOP,I1,J1,K1,                    GEOPOT.20
     *                  PHIH,PHIF,TV,ALNP )                                      GEOPOT.21
C                                                                                GEOPOT.22
C     INPUT       T        TEMPERATURE                CROSS    3D                GEOPOT.23
C                 Q        MIXING RATIO               CROSS    3D                GEOPOT.24
C                 TER      TERRAIN                    CROSS    2D                GEOPOT.25
C                 PS       P* = PSURF - PTOP          CROSS    2D                GEOPOT.26
C                 IDRY     0=MIXING RATIO AVAILABLE                              GEOPOT.27
C                 SIGH     SIGMA ON HALF LEVELS                1D                GEOPOT.28
C                 PTOP     PRESSURE AT MODEL LID                                 GEOPOT.29
C                 I1       DOT POINT DIMENSION N-S                               GEOPOT.30
C                 J1       DOT POINT DIMENSION E-W                               GEOPOT.31
C                                                                                GEOPOT.32
C     STACK       PHIF     HEIGHT ON FULL LEVELS      CROSS    3D                GEOPOT.33
C                 ALNP     SLAB OF PRESSURE DIFF      CROSS    2D                GEOPOT.34
C                 TV       VIRTUAL TEMPERATURE        CROSS    3D                GEOPOT.35
C                                                                                GEOPOT.36
C     OUTPUT      PHIH     HEIGHT ON HALF LEVELS      CROSS    3D                GEOPOT.37
C                                                                                GEOPOT.38
#     include <scratch.incl>                                                     GEOPOT.39
      DIMENSION T(I1,J1,K1)  ,Q(I1,J1,K1)  ,TER(I1,J1)    ,                      GEOPOT.40
     1          PS(I1,J1)     ,SIGH(K1)                                          GEOPOT.41
      DIMENSION PHIF(I1,J1,K1+1),            ALNP(I1,J1) ,                       GEOPOT.42
     *          TV(I1,J1,K1),SIGF(K_MAX)                                         GEOPOT.43
      DIMENSION PHIH(I1,J1,K1)                                                   GEOPOT.44
      PARAMETER (R=287.04,G=9.8)                                                 GEOPOT.45
C                                                                                GEOPOT.46
C     ... SURFACE VALUES OF HEIGHT ON FULL LEVELS                                GEOPOT.47
C                                                                                GEOPOT.48
      IF(K_MAX .LT. K1+1) THEN                                                   GEOPOT.49
        WRITE(6,*) ' K_MAX IN SCRATCH.H TOO SMALL '                              GEOPOT.50
        WRITE(6,*) ' SET K_MAX TO ',K1+1,' AND RECOMPILE GRAPH '                 GEOPOT.51
        STOP                                                                     GEOPOT.52
      END IF                                                                     GEOPOT.53
      DO 110 J=1,J1-1                                                            GEOPOT.54
      DO 110 I=1,I1-1                                                            GEOPOT.55
         PHIF(I,J,K1+1) = TER(I,J) * G                                           GEOPOT.56
110   CONTINUE                                                                   GEOPOT.57
      SIGF(1)=0.                                                                 GEOPOT.58
      DO 111 K=1,K1                                                              GEOPOT.59
         SIGF(K+1)= 2.*SIGH(K) - SIGF(K)                                         GEOPOT.60
111   CONTINUE                                                                   GEOPOT.61
C                                                                                GEOPOT.62
C     ... INTEGRATE HYDROSTATIC EQN                                              GEOPOT.63
C                                                                                GEOPOT.64
      IF(IDRY.EQ.0) THEN                                                         GEOPOT.65
         CALL TVIRT(T,Q,I1,J1,K1,TV,I1,J1) ! GET VIRTUAL TEMP                    GEOPOT.66
      ELSE                                                                       GEOPOT.67
         PRINT *,'GEOPOTENTIAL HEIGHTS COMPUTED WITHOUT ',                       GEOPOT.68
     *      'MIXING RATIO'                                                       GEOPOT.69
         DO 112 K=1,K1                                                           GEOPOT.70
         DO 112 J=1,J1-1                                                         GEOPOT.71
         DO 112 I=1,I1-1                                                         GEOPOT.72
            TV(I,J,K)=T(I,J,K)                                                   GEOPOT.73
112      CONTINUE                                                                GEOPOT.74
      END IF                                                                     GEOPOT.75
      DO 125 K=K1,1,-1                                                           GEOPOT.76
         DO 120 J=1,J1-1                                                         GEOPOT.77
         DO 120 I=1,I1-1                                                         GEOPOT.78
            ALNP(I,J) = ALOG ((SIGF(K+1)*PS(I,J)+PTOP) /                         GEOPOT.79
     *      (SIGF(K)*PS(I,J)+PTOP)) * R                                          GEOPOT.80
120      CONTINUE                                                                GEOPOT.81
         DO 122 J=1,J1-1                                                         GEOPOT.82
         DO 122 I=1,I1-1                                                         GEOPOT.83
            PHIF(I,J,K) = PHIF(I,J,K+1) + TV(I,J,K) * ALNP(I,J)                  GEOPOT.84
122      CONTINUE                                                                GEOPOT.85
125   CONTINUE                                                                   GEOPOT.86
C                                                                                GEOPOT.87
C     ... LOGARITHMIC INTERPOLATION TO HALF-LEVELS                               GEOPOT.88
C                                                                                GEOPOT.89
      ONEOVG=1./9.8                                                              GEOPOT.90
      DO 155 K=1,K1                                                              GEOPOT.91
         DO 150 J=1,J1-1                                                         GEOPOT.92
         DO 150 I=1,I1-1                                                         GEOPOT.93
            ALNP(I,J) = ALOG ((SIGH(K)*PS(I,J)+PTOP)/                            GEOPOT.94
     *      (SIGF(K+1)*PS(I,J)+PTOP)) /                                          GEOPOT.95
     *      ALOG((SIGF(K)*PS(I,J)+PTOP)/                                         GEOPOT.96
     *      (SIGF(K+1)*PS(I,J)+PTOP))                                            GEOPOT.97
150      CONTINUE                                                                GEOPOT.98
         DO 152 J=1,J1-1                                                         GEOPOT.99
         DO 152 I=1,I1-1                                                         GEOPOT.100
            PHIH(I,J,K)=(PHIF(I,J,K+1)+PHIF(I,J,K)*ALNP(I,J)-                    GEOPOT.101
     *      PHIF(I,J,K+1)*ALNP(I,J)) * ONEOVG                                    GEOPOT.102
152      CONTINUE                                                                GEOPOT.103
155   CONTINUE                                                                   GEOPOT.104
      RETURN                                                                     GEOPOT.105
      END                                                                        GEOPOT.106
