      SUBROUTINE GEOWINDP(HEIGHT,F,XMF,DMF,IMX,JMX,KX,DS,UG,VG)                  GEOWINDP.1
C                                                                                GEOWINDP.2
C     SECTION  DIAGNOSTIC                                                        GEOWINDP.3
C     PURPOSE  COMPUTES THE THE GEOSTROPHIC WIND COMPONENTS                      GEOWINDP.4
C              ON PRESSURE LEVELS FROM THE AVAILABLE                             GEOWINDP.5
C              HEIGHT (*GRAVITY) AND CORIOLIS PARAMETER                          GEOWINDP.6
C                                                                                GEOWINDP.7
C     INPUT       HEIGHT   GEOPOTENTIAL HEIGHT        CROSS    3D                GEOWINDP.8
C                 F        CORIOLIS PARAMETER         CROSS    2D                GEOWINDP.9
C                 XMF      MAP FACTORS                CROSS    2D                GEOWINDP.10
C                 DMF      MAP FACTORS                DOT      2D                GEOWINDP.11
C                 IMX      DOT POINT DIMENSION N-S                               GEOWINDP.12
C                 JMX      DOT POINT DIMENSION E-W                               GEOWINDP.13
C                 KX       NUMBER OF VERTICAL LEVELS                             GEOWINDP.14
C                                                                                GEOWINDP.15
C     OUTPUT      UG       U COMPONENT OF GEO WIND    CROSS    3D                GEOWINDP.16
C                 VG       V COMPONENT OF GEO WIND    CROSS    3D                GEOWINDP.17
C                                                                                GEOWINDP.18
      DIMENSION HEIGHT(IMX,JMX,KX) ,F(IMX,JMX),                                  GEOWINDP.19
     *   XMF(IMX,JMX),DMF(IMX,JMX)                                               GEOWINDP.20
      DIMENSION UG(IMX,JMX,KX),VG(IMX,JMX,KX)                                    GEOWINDP.21
      PARAMETER (G=9.8)                                                          GEOWINDP.22
C                                                                                GEOWINDP.23
      IF(DS.LT.1000.) THEN                                                       GEOWINDP.24
         DS2R=1./(2.*DS*1000.)                                                   GEOWINDP.25
      ELSE                                                                       GEOWINDP.26
         DS2R=1./(2.*DS)                                                         GEOWINDP.27
      END IF                                                                     GEOWINDP.28
C                                                                                GEOWINDP.29
      DO 1000 K=1,KX                                                             GEOWINDP.30
      DO 1000 J=2,JMX-1                                                          GEOWINDP.31
      DO 1000 I=2,IMX-1                                                          GEOWINDP.32
C        H1=HEIGHT(I-1,J-1,K)/XMF(I-1,J-1)                                       GEOWINDP.33
C        H2=HEIGHT(I  ,J-1,K)/XMF(I  ,J-1)                                       GEOWINDP.34
C        H3=HEIGHT(I-1,J  ,K)/XMF(I-1,J  )                                       GEOWINDP.35
C        H4=HEIGHT(I  ,J  ,K)/XMF(I  ,J  )                                       GEOWINDP.36
C        UG(I,J,K)=-1.*G*DMF(I,J)*DMF(I,J)/F(I,J)*DS2R*(H4-H3+H2-H1)             GEOWINDP.37
C        VG(I,J,K)=    G*DMF(I,J)*DMF(I,J)/F(I,J)*DS2R*(H4-H2+H3-H1)             GEOWINDP.38
         H1=HEIGHT(I-1,J-1,K)                                                    GEOWINDP.39
         H2=HEIGHT(I  ,J-1,K)                                                    GEOWINDP.40
         H3=HEIGHT(I-1,J  ,K)                                                    GEOWINDP.41
         H4=HEIGHT(I  ,J  ,K)                                                    GEOWINDP.42
         UG(I,J,K)=-1.*G*DMF(I,J)/F(I,J)*DS2R*(H4-H3+H2-H1)                      GEOWINDP.43
         VG(I,J,K)=    G*DMF(I,J)/F(I,J)*DS2R*(H4-H2+H3-H1)                      GEOWINDP.44
1000  CONTINUE                                                                   GEOWINDP.45
C                                                                                GEOWINDP.46
      CALL FILLIT(UG,IMX,JMX,KX,IMX,JMX,2,IMX-1,2,JMX-1)                         GEOWINDP.47
      CALL FILLIT(VG,IMX,JMX,KX,IMX,JMX,2,IMX-1,2,JMX-1)                         GEOWINDP.48
      RETURN                                                                     GEOWINDP.49
      END                                                                        GEOWINDP.50
