      SUBROUTINE GEOWINDS(T, Q, PP, PS, MD, F, TER,SIG, DX, DY,                  GEOWINDS.1
     *                    IX,JX,KX,PTOP,INHYD,IDRY,UG, VG )                      GEOWINDS.2
#     include <scratch.incl>                                                     GEOWINDS.3
C                                                                                GEOWINDS.4
      INEED = 2*(IX*JX*(KX))                                                     GEOWINDS.5
      IN1 = NTEMP                                                                GEOWINDS.6
      IN2 = IN1 + (IX*JX*(KX))                                                   GEOWINDS.7
      NTEMP = NTEMP+INEED                                                        GEOWINDS.8
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('GEOWINDS')                       GEOWINDS.9
      IF(VERBOSE) WRITE(6,*) ' CALLING GEOWINDS ',INEED,IN1,NTEMP                GEOWINDS.10
        CALL GEOWINDS_0(T, Q, PP, PS, MD, F, TER,SIG, DX, DY,                    GEOWINDS.11
     *                    IX,JX,KX,PTOP,INHYD,IDRY,UG, VG,                       GEOWINDS.12
     *                SCR(IN1),SCR(IN2))                                         GEOWINDS.13
      NTEMP = NTEMP - INEED                                                      GEOWINDS.14
      IF(VERBOSE) WRITE(6,*) ' RET FROM GEOWINDS ',NTEMP                         GEOWINDS.15
      RETURN                                                                     GEOWINDS.16
      END                                                                        GEOWINDS.17
C                                                                                GEOWINDS.18
      SUBROUTINE GEOWINDS_0(T, Q, PP, PS, MD, F, TER,SIG, DX, DY,                GEOWINDS.19
     *                    IX,JX,KX,PTOP,INHYD,IDRY,UG, VG, GHT, RHO)             GEOWINDS.20
C                                                                                GEOWINDS.21
C  PURPOSE : COMPUTES THE GEOSTROPHIC WIND COMPONENTS ON SIGMA LEVEL.            GEOWINDS.22
C                                                                                GEOWINDS.23
C  ON ENTRY: T       : TEMOERATURE                                               GEOWINDS.24
C            Q       : MIXING RATIO                                              GEOWINDS.25
C            PP      ; P PERTURBATION                                            GEOWINDS.26
C            PS      ; SURFACE PRESSURE                                          GEOWINDS.27
C            MD      : MAP FACTOR AT DOT POINTS                                  GEOWINDS.28
C            F       : CORIOLIS PARAMETER AT DOT POINTS                          GEOWINDS.29
C            TER     : TERRAIN HEIGHT AT CROSS POINTS                            GEOWINDS.30
C            SIG     : HALF SIGMA VALUE                                          GEOWINDS.31
C            DX,DY   : GRID DISTANCE IN X AND Y DIRECTIONS                       GEOWINDS.32
C            IX,JX,KX: DIMENSIONS                                                GEOWINDS.33
C            PTOP    : PRESSURE AT TOP OF MODEL                                  GEOWINDS.34
C            INHYD   : =1 NON-HYDROSTATIC, =0 HYDROSTATIC                        GEOWINDS.35
C            IDRY    : =1 DRY RUN, =0 MOIST RUN                                  GEOWINDS.36
C  ON EXIT:  UG      : GEOSTROPHIC WIND U-COMPONENT                              GEOWINDS.37
C            VG      : GEOSTROPHIC WIND V-COMPONENT                              GEOWINDS.38
      PARAMETER (RD=287.)                                                        GEOWINDS.39
      REAL PP(IX,JX,KX),PS(IX,JX),SIG(KX),                                       GEOWINDS.40
     +     T(IX,JX,KX),RHO(IX,JX,KX),MD(IX,JX), F(IX,JX),                        GEOWINDS.41
     +     Q(IX,JX,KX),GHT(IX,JX,KX),UG(IX,JX,KX),VG(IX,JX,KX)                   GEOWINDS.42
C                                                                                GEOWINDS.43
      IF (INHYD.EQ.0) THEN                                                       GEOWINDS.44
        CALL GEOPOT(T, Q, TER, PS,IDRY,SIG,PTOP,IX,JX,KX,GHT)                    GEOWINDS.45
C                                                                                GEOWINDS.46
        DO 10 K=1,KX                                                             GEOWINDS.47
        DO 10 I=2,IX-1                                                           GEOWINDS.48
        DO 10 J=2,JX-1                                                           GEOWINDS.49
        SIGPSA=SIG(K)*(PS(I,J)+PS(I-1,J)+PS(I,J-1)+PS(I-1,J-1))                  GEOWINDS.50
        TV1=T(I-1,J-1,K)*(1.+.608*Q(I-1,J-1,K))                                  GEOWINDS.51
        TV2=T(I,J-1,K)*(1.+.608*Q(I,J-1,K))                                      GEOWINDS.52
        TV3=T(I-1,J,K)*(1.+.608*Q(I-1,J,K))                                      GEOWINDS.53
        TV4=T(I,J,K)*(1.+.608*Q(I,J,K))                                          GEOWINDS.54
        RHO(I,J,K)=RD*(TV1+TV2+TV3+TV4)*(SIGPSA/(SIGPSA+PTOP))                   GEOWINDS.55
 10     CONTINUE                                                                 GEOWINDS.56
C                                                                                GEOWINDS.57
        DO 20 I=2,IX-1                                                           GEOWINDS.58
        DO 20 J=2,JX-1                                                           GEOWINDS.59
          MOF = MD(I,J)/F(I,J)                                                   GEOWINDS.60
          MOFDX = MOF/8.0/DX                                                     GEOWINDS.61
          MOFDY = MOF/8.0/DY                                                     GEOWINDS.62
          DO 20 K=1,KX                                                           GEOWINDS.63
            UG(I,J,K)=-MOFDY*(RHO(I,J,K)*(PS(I,J-1)  +PS(I,J)                    GEOWINDS.64
     1                                 -PS(I-1,J-1)-PS(I-1,J))                   GEOWINDS.65
     2          +GHT(I,J,K)+GHT(I,J-1,K)-GHT(I-1,J,K)-GHT(I-1,J-1,K))            GEOWINDS.66
            VG(I,J,K)= MOFDX*(RHO(I,J,K)*(PS(I,J)  +PS(I-1,J)                    GEOWINDS.67
     1                                   -PS(I,J-1)-PS(I-1,J-1))                 GEOWINDS.68
     2          +GHT(I,J,K)+GHT(I-1,J,K)-GHT(I,J-1,K)-GHT(I-1,J-1,K))            GEOWINDS.69
  20    CONTINUE                                                                 GEOWINDS.70
      ELSE IF (INHYD.EQ.1) THEN                                                  GEOWINDS.71
C                                                                                GEOWINDS.72
C****** COMPUTE DENSITY *************                                            GEOWINDS.73
C                                                                                GEOWINDS.74
      DO 26 K=1,KX                                                               GEOWINDS.75
      DO 26 J=1,JX-1                                                             GEOWINDS.76
      DO 26 I=1,IX-1                                                             GEOWINDS.77
C                                                                                GEOWINDS.78
C***** PR IN PA, FROM PS(I,J) IN MB AND PP(I,J,K),PTOP IN MB ****                GEOWINDS.79
C                                                                                GEOWINDS.80
       PR=1.E2*( SIG(K)*PS(I,J) + PP(I,J,K) + PTOP )                             GEOWINDS.81
        RHO(I,J,K)=PR/(RD*T(I,J,K))/(1.+ .608*Q(I,J,K))                          GEOWINDS.82
 26   CONTINUE                                                                   GEOWINDS.83
C                                                                                GEOWINDS.84
C****** COMPUTE DIFFERENCES FOR P-GRAD TERM *************                        GEOWINDS.85
C                                                                                GEOWINDS.86
      DO 30 K=1,KX                                                               GEOWINDS.87
      DO 30 J=2,JX-1                                                             GEOWINDS.88
      DO 30 I=2,IX-1                                                             GEOWINDS.89
       RHOA=0.25*(RHO(I-1,J-1,K) + RHO(I,J-1,K) + RHO(I-1,J,K) +                 GEOWINDS.90
     +            RHO(I,J,K))                                                    GEOWINDS.91
       IF (K.EQ.1) THEN                                                          GEOWINDS.92
        PPA=0.25*(PP(I-1,J-1,K) + PP(I,J-1,K) + PP(I-1,J,K) +                    GEOWINDS.93
     +            PP(I,J,K))                                                     GEOWINDS.94
        PPAP=0.25*(PP(I-1,J-1,K+1) + PP(I,J-1,K+1) + PP(I-1,J,K+1) +             GEOWINDS.95
     +            PP(I,J,K+1))                                                   GEOWINDS.96
        DPPA=(PPAP - PPA)/(SIG(K+1) - SIG(K))                                    GEOWINDS.97
       ELSE IF (K.EQ.KX) THEN                                                    GEOWINDS.98
        PPA=0.25*(PP(I-1,J-1,K) + PP(I,J-1,K) + PP(I-1,J,K) +                    GEOWINDS.99
     +            PP(I,J,K))                                                     GEOWINDS.100
        PPAM=0.25*(PP(I-1,J-1,K-1) + PP(I,J-1,K-1) + PP(I-1,J,K-1) +             GEOWINDS.101
     +            PP(I,J,K-1))                                                   GEOWINDS.102
        DPPA=(PPA - PPAM)/(SIG(K) - SIG(K-1))                                    GEOWINDS.103
       ELSE                                                                      GEOWINDS.104
        PPAP=0.25*(PP(I-1,J-1,K+1) + PP(I,J-1,K+1) + PP(I-1,J,K+1) +             GEOWINDS.105
     +            PP(I,J,K+1))                                                   GEOWINDS.106
        PPAM=0.25*(PP(I-1,J-1,K-1) + PP(I,J-1,K-1) + PP(I-1,J,K-1) +             GEOWINDS.107
     +            PP(I,J,K-1))                                                   GEOWINDS.108
        DPPA=(PPAP - PPAM)/(SIG(K+1) - SIG(K-1))                                 GEOWINDS.109
       END IF                                                                    GEOWINDS.110
       DPPY=0.5*( PP(I,J,K)+PP(I,J-1,K) - PP(I-1,J,K)-PP(I-1,J-1,K) )/DY         GEOWINDS.111
       DPSY=0.5*SIG(K)*( PS(I,J)+PS(I,J-1) - PS(I-1,J)-PS(I-1,J-1) )/DY          GEOWINDS.112
       DPPX=0.5*( PP(I,J,K)+PP(I-1,J,K) - PP(I,J-1,K)-PP(I-1,J-1,K) )/DX         GEOWINDS.113
       DPSX=0.5*SIG(K)*( PS(I-1,J)+PS(I,J) - PS(I-1,J-1)-PS(I,J-1) )/DX          GEOWINDS.114
        ZMA=MD(I,J)                                                              GEOWINDS.115
       PSD=0.25*( PS(I-1,J-1) + PS(I-1,J) + PS(I,J-1) + PS(I,J) )                GEOWINDS.116
        FF = F(I,J)                                                              GEOWINDS.117
       UG(I,J,K)=-(1.E2*ZMA/(FF*RHOA))*(DPPY - DPSY*DPPA/PSD)                    GEOWINDS.118
       VG(I,J,K)=(1.E2*ZMA/(FF*RHOA))*(DPPX - DPSX*DPPA/PSD)                     GEOWINDS.119
 30   CONTINUE                                                                   GEOWINDS.120
C                                                                                GEOWINDS.121
      ELSE                                                                       GEOWINDS.122
        PRINT *,'INHYD=',INHYD,' IS NOT 0 OR 1, UG/VG IS NOT PLOTTED'            GEOWINDS.123
        RETURN                                                                   GEOWINDS.124
      END IF                                                                     GEOWINDS.125
C                                                                                GEOWINDS.126
C****** SIDES (DOT POINTS) *************                                         GEOWINDS.127
C                                                                                GEOWINDS.128
      DO 40 K=1,KX                                                               GEOWINDS.129
       DO 42 I=2,IX-1                                                            GEOWINDS.130
        UG(I,1,K)=UG(I,2,K)                                                      GEOWINDS.131
        UG(I,JX,K)=UG(I,JX-1,K)                                                  GEOWINDS.132
        VG(I,1,K)=VG(I,2,K)                                                      GEOWINDS.133
        VG(I,JX,K)=VG(I,JX-1,K)                                                  GEOWINDS.134
 42    CONTINUE                                                                  GEOWINDS.135
       DO 44 J=2,JX-1                                                            GEOWINDS.136
        UG(1,J,K)=UG(2,J,K)                                                      GEOWINDS.137
        UG(IX,J,K)=UG(IX-1,J,K)                                                  GEOWINDS.138
        VG(1,J,K)=VG(2,J,K)                                                      GEOWINDS.139
        VG(IX,J,K)=VG(IX-1,J,K)                                                  GEOWINDS.140
 44    CONTINUE                                                                  GEOWINDS.141
C                                                                                GEOWINDS.142
C****** CORNERS (DOT POINTS) *************                                       GEOWINDS.143
C                                                                                GEOWINDS.144
       UG(1,1,K)=UG(2,2,K)                                                       GEOWINDS.145
       UG(1,JX,K)=UG(2,JX-1,K)                                                   GEOWINDS.146
       UG(IX,1,K)=UG(IX-1,2,K)                                                   GEOWINDS.147
       UG(IX,JX,K)=UG(IX-1,JX-1,K)                                               GEOWINDS.148
       VG(1,1,K)=VG(2,2,K)                                                       GEOWINDS.149
       VG(1,JX,K)=VG(2,JX-1,K)                                                   GEOWINDS.150
       VG(IX,1,K)=VG(IX-1,2,K)                                                   GEOWINDS.151
       VG(IX,JX,K)=VG(IX-1,JX-1,K)                                               GEOWINDS.152
 40   CONTINUE                                                                   GEOWINDS.153
      RETURN                                                                     GEOWINDS.154
      END                                                                        GEOWINDS.155
