C	$ID: GNEWPT.F,V 2.0 1997/01/11 20:31:35 MESOUSER EXP $                         GNEWPT.1
C                                                                                GNEWPT.2
      SUBROUTINE GNEWPT (UX,VY,IMAX,JPTSY)                                       GNEWPT.3
C                                                                                GNEWPT.4
C INTERPOLATION ROUTINE TO CALCULATE THE DISPLACEMANT COMPONENTS                 GNEWPT.5
C .   THE PHILOSPHY HERE IS TO UTILIZE AS MANY POINTS AS POSSIBLE                GNEWPT.6
C .   (WITHIN REASON) IN ORDER TO OBTAIN A PLEASING AND ACCURATE PLOT.           GNEWPT.7
C .   INTERPOLATION SCHEMES DESIRED BY OTHER USERS MAY EASILY BE                 GNEWPT.8
C .   SUBSTITUTED IF DESIRED.                                                    GNEWPT.9
C                                                                                GNEWPT.10
      DIMENSION       UX(IMAX,JPTSY)        ,VY(IMAX,JPTSY)                      GNEWPT.11
      COMMON /STR01/  IS         ,IEND      ,JS        ,JEND                     GNEWPT.12
     1             ,  IEND1      ,JEND1     ,I         ,J                        GNEWPT.13
     2             ,  X          ,Y         ,DELX      ,DELY                     GNEWPT.14
     3             ,  ICYC1      ,IMSG1     ,IGFL1                               GNEWPT.15
      COMMON /STR03/  INITA , INITB , AROWL , ITERP , ITERC , IGFLG              GNEWPT.16
     1             ,  IMSG , UVMSG , ICYC , DISPL , DISPC , CSTOP                GNEWPT.17
C                                                                                GNEWPT.18
      SAVE                                                                       GNEWPT.19
C                                                                                GNEWPT.20
C FDLI - DOUBLE LINEAR INTERPOLATION FORMULA                                     GNEWPT.21
C FBESL - BESSEL 16 PT INTERPOLATION FORMULA ( MOST USED FORMULA )               GNEWPT.22
C FQUAD - QUADRATIC INTERPOLATION FORMULA                                        GNEWPT.23
C                                                                                GNEWPT.24
      FDLI(Z,Z1,Z2,Z3,DX,DY) = (1.-DX)*((1.-DY)*Z +DY*Z1)                        GNEWPT.25
     1                         +     DX *((1.-DY)*Z2+DY*Z3)                      GNEWPT.26
      FBESL(Z,ZP1,ZP2,ZM1,DZ)=Z+DZ*(ZP1-Z+0.25*(DZ-1.)*((ZP2-ZP1-Z+ZM1)          GNEWPT.27
     1                        +0.666667*(DZ-0.5)*(ZP2-3.*ZP1+3.*Z-ZM1)))         GNEWPT.28
      FQUAD(Z,ZP1,ZM1,DZ)=Z+0.5*DZ*(ZP1-ZM1+DZ*(ZP1-2.*Z+ZM1))                   GNEWPT.29
C                                                                                GNEWPT.30
      DX = X-AINT(X)                                                             GNEWPT.31
      DY = Y-AINT(Y)                                                             GNEWPT.32
C                                                                                GNEWPT.33
      IF( IMSG.NE.0.OR.IGFLG.NE.0) GO TO 20                                      GNEWPT.34
C                                                                                GNEWPT.35
      IM1 = I-1                                                                  GNEWPT.36
      IP2 = I+2                                                                  GNEWPT.37
C                                                                                GNEWPT.38
C DETERMINE WHICH INTERPOLATION FORMULA TO USE DEPENDING ON I,J LOCATION         GNEWPT.39
C .   THE FIRST CHECK IS FOR I,J IN THE GRID INTERIOR.                           GNEWPT.40
C                                                                                GNEWPT.41
      IF (J.GT.JS .AND. J.LT.JEND1 .AND. I.GT.IS .AND. I.LT.IEND1)               GNEWPT.42
     1    GO TO 30                                                               GNEWPT.43
      IF (J.EQ.JEND1 .AND. I.GT.IS .AND. I.LT.IEND1) GO TO  40                   GNEWPT.44
      IF (J.EQ.JS) GO TO 20                                                      GNEWPT.45
C                                                                                GNEWPT.46
      IF (ICYC1.EQ.1) GO TO 10                                                   GNEWPT.47
C                                                                                GNEWPT.48
C MUST NOT BE CYCLIC                                                             GNEWPT.49
C                                                                                GNEWPT.50
      IF (I.EQ.IS) GO TO 20                                                      GNEWPT.51
      IF (I.EQ.IEND1) GO TO  50                                                  GNEWPT.52
      GO TO 20                                                                   GNEWPT.53
   10 CONTINUE                                                                   GNEWPT.54
C                                                                                GNEWPT.55
C MUST BE CYCLIC IN THE X DIRECTION                                              GNEWPT.56
C                                                                                GNEWPT.57
      IF (I.EQ.IS .AND. J.LT.JEND1) GO TO 12                                     GNEWPT.58
      IF (I.EQ.IEND1 .AND. J.LT.JEND1) GO TO 14                                  GNEWPT.59
      IF (J.EQ.JEND1 .AND. I.EQ.IS) GO TO 16                                     GNEWPT.60
      IF (J.EQ.JEND1 .AND. I.EQ.IEND1) GO TO 18                                  GNEWPT.61
      GO TO 20                                                                   GNEWPT.62
   12 IM1 = IEND1                                                                GNEWPT.63
      GO TO 30                                                                   GNEWPT.64
   14 IP2 = IS+1                                                                 GNEWPT.65
      GO TO 30                                                                   GNEWPT.66
   16 IM1 = IEND1                                                                GNEWPT.67
      GO TO 40                                                                   GNEWPT.68
   18 IP2 = IS+1                                                                 GNEWPT.69
      GO TO 40                                                                   GNEWPT.70
C                                                                                GNEWPT.71
   20 CONTINUE                                                                   GNEWPT.72
C                                                                                GNEWPT.73
C DOUBLE LINEAR INTERPOLATION FORMULA. THIS SCHEME WORKS AT ALL POINTS           GNEWPT.74
C .   BUT THE RESULTING STREAMLINES ARE NOT AS PLEASING AS THOSE DRAWN           GNEWPT.75
C .   BY FBESL OR FQUAD. CURRENTLY THIS IS USED AT THIS IS UTILIZED              GNEWPT.76
C .   ONLY AT CERTAIN BOUNDARY POINTS OR IF IGFLG IS NOT EQUAL TO ZERO.          GNEWPT.77
C                                                                                GNEWPT.78
      DELX = FDLI (UX(I,J),UX(I,J+1),UX(I+1,J),UX(I+1,J+1),DX,DY)                GNEWPT.79
      DELY = FDLI (VY(I,J),VY(I,J+1),VY(I+1,J),VY(I+1,J+1),DX,DY)                GNEWPT.80
      RETURN                                                                     GNEWPT.81
   30 CONTINUE                                                                   GNEWPT.82
C                                                                                GNEWPT.83
C USE A 16 POINT BESSEL INTERPOLATION SCHEME                                     GNEWPT.84
C                                                                                GNEWPT.85
      UJM1 = FBESL (UX(I,J-1),UX(I+1,J-1),UX(IP2,J-1),UX(IM1,J-1),DX)            GNEWPT.86
      UJ   = FBESL (UX(I,J),UX(I+1,J),UX(IP2,J),UX(IM1,J),DX)                    GNEWPT.87
      UJP1 = FBESL (UX(I,J+1),UX(I+1,J+1),UX(IP2,J+1),UX(IM1,J+1),DX)            GNEWPT.88
      UJP2 = FBESL (UX(I,J+2),UX(I+1,J+2),UX(IP2,J+2),UX(IM1,J+2),DX)            GNEWPT.89
      DELX = FBESL (UJ,UJP1,UJP2,UJM1,DY)                                        GNEWPT.90
      VJM1 = FBESL (VY(I,J-1),VY(I+1,J-1),VY(IP2,J-1),VY(IM1,J-1),DX)            GNEWPT.91
      VJ   = FBESL (VY(I,J),VY(I+1,J),VY(IP2,J),VY(IM1,J),DX)                    GNEWPT.92
      VJP1 = FBESL (VY(I,J+1),VY(I+1,J+1),VY(IP2,J+1),VY(IM1,J+1),DX)            GNEWPT.93
      VJP2 = FBESL (VY(I,J+2),VY(I+1,J+2),VY(IP2,J+2),VY(IM1,J+2),DX)            GNEWPT.94
      DELY = FBESL (VJ,VJP1,VJP2,VJM1,DY)                                        GNEWPT.95
      RETURN                                                                     GNEWPT.96
   40 CONTINUE                                                                   GNEWPT.97
C                                                                                GNEWPT.98
C 12 POINT INTERPOLATION SCHEME APPLICABLE TO ONE ROW FROM TOP BOUNDARY          GNEWPT.99
C                                                                                GNEWPT.100
      UJM1 = FBESL (UX(I,J-1),UX(I+1,J-1),UX(IP2,J-1),UX(IM1,J-1),DX)            GNEWPT.101
      UJ   = FBESL (UX(I,J),UX(I+1,J),UX(IP2,J),UX(IM1,J),DX)                    GNEWPT.102
      UJP1 = FBESL (UX(I,J+1),UX(I+1,J+1),UX(IP2,J+1),UX(IM1,J+1),DX)            GNEWPT.103
      DELX = FQUAD (UJ,UJP1,UJM1,DY)                                             GNEWPT.104
      VJM1 = FBESL (VY(I,J-1),VY(I+1,J-1),VY(IP2,J-1),VY(IM1,J-1),DX)            GNEWPT.105
      VJ   = FBESL (VY(I,J),VY(I+1,J),VY(IP2,J),VY(IM1,J),DX)                    GNEWPT.106
      VJP1 = FBESL (VY(I,J+1),VY(I+1,J+1),VY(IP2,J+1),VY(IM1,J+1),DX)            GNEWPT.107
      DELY = FQUAD (VJ,VJP1,VJM1,DY)                                             GNEWPT.108
      RETURN                                                                     GNEWPT.109
   50 CONTINUE                                                                   GNEWPT.110
C                                                                                GNEWPT.111
C 9 POINT INTERPOLATION SCHEME FOR USE IN THE NON-CYCLIC CASE                    GNEWPT.112
C .   AT I=IEND1 ; JS.LT.J AND J.LE.JEND1                                        GNEWPT.113
C                                                                                GNEWPT.114
      UJP1 = FQUAD (UX(I,J+1),UX(I+1,J+1),UX(IM1,J+1),DX)                        GNEWPT.115
      UJ   = FQUAD (UX(I,J),UX(I+1,J),UX(IM1,J),DX)                              GNEWPT.116
      UJM1 = FQUAD (UX(I,J-1),UX(I+1,J-1),UX(IM1,J-1),DX)                        GNEWPT.117
      DELX = FQUAD (UJ,UJP1,UJM1,DY)                                             GNEWPT.118
      VJP1 = FQUAD (VY(I,J+1),VY(I+1,J+1),VY(IM1,J+1),DX)                        GNEWPT.119
      VJ   = FQUAD (VY(I,J),VY(I+1,J),VY(IM1,J),DX)                              GNEWPT.120
      VJM1 = FQUAD (VY(I,J-1),VY(I+1,J-1),VY(IM1,J-1),DX)                        GNEWPT.121
      DELY = FQUAD (VJ,VJP1,VJM1,DY)                                             GNEWPT.122
      RETURN                                                                     GNEWPT.123
      END                                                                        GNEWPT.124
