      PROGRAM GRAPH                                                              GRAPH.1
C                                                                                GRAPH.2
#     include <data.incl>                                                        GRAPH.3
#     include <scratch.incl>                                                     GRAPH.4
#     include <headerv3.incl>                                                    GRAPH.5
#     include <progname.incl>                                                    GRAPH.6
#     include <modelpar.incl>                                                    GRAPH.7
#     include <vlevel.incl>                                                      GRAPH.8
#     include <dates.incl>                                                       GRAPH.9
C                                                                                GRAPH.10
CC      POINTER (PTRD31,D31(1)),(PTRD32,D32(1)),(PTRD33,D33(1)),                 GRAPH.11
CC     *        (PTRD34,D34(1))                                                  GRAPH.12
CC      POINTER (PTRD21,D21(1)),(PTRD22,D22(1)),(PTRD23,D23(1)),                 GRAPH.13
CC     *        (PTRD24,D24(1))                                                  GRAPH.14
C                                                                                GRAPH.15
      LOGICAL   MLF(10)                                                          GRAPH.16
      DIMENSION JYR(18), JMO(18), JDY(18), JHR(18),                              GRAPH.17
     *          NBOGUS(18), KBOGUS(18)                                           GRAPH.18
      LOGICAL   IPLOT(18), NSELIM(18)                                            GRAPH.19
      COMMON /HEADER/ MDATE,IPROG,ICOORD,                                        GRAPH.20
     *   NLV,IVCOORD(100),VCOORD(100),                                           GRAPH.21
     *   MIF, MRF, MLF,                                                          GRAPH.22
     *   JYR,JMO,JDY,JHR,IPLOT,NSELIM,NBOGUS,KBOGUS,IPROJ                        GRAPH.23
      COMMON /WHEN/ MDATENOW,MDATEBEG                                            GRAPH.24
      COMMON /HDRCHR/  PROG                                                      GRAPH.25
      COMMON /MM5PHY/ NFLAGS,IFLAGS(100)                                         GRAPH.26
      PARAMETER (INFOUNIT=18)    ! TRAILING DATA                                 GRAPH.27
      DIMENSION IERR(2)                                                          GRAPH.28
      COMMON /INCREM/ IFILUNIT,INC                                               GRAPH.29
      COMMON /MAPSTUFF/ XLONC,PHIC,XLAT1,XLON1,XLAT2,XLON2,                      GRAPH.30
     *   ISTART,IEND,JSTART,JEND,                                                GRAPH.31
     *   IMAPMAX,IMAPST,IMAPEND,JMAPMAX,JMAPST,JMAPEND,                          GRAPH.32
     *   XPA,XPB,YPA,YPB,                                                        GRAPH.33
     *   DS,OVERLAY,IFRAME,INSIDE,IFORM,NUMFRAME                                 GRAPH.34
      LOGICAL OVERLAY                                                            GRAPH.35
      NAMELIST /MM4STUF/ MIF,MRF,MIFC,MRFC                                       GRAPH.36
      INTEGER DASH1, DASH2, COLOR1, COLOR2, COLOR3,                              GRAPH.37
     *                      COLOR4, COLOR5, COLOR6                               GRAPH.38
      LOGICAL HDRINFO,ICONDRV(2)                                                 GRAPH.39
      REAL LEVELS(100)                                                           GRAPH.40
      COMMON /DEFAULTS/ TRUELAT1, TRUELAT2, LW1, LW2,                            GRAPH.41
     * DASH1, DASH2, COLOR1, COLOR2, COLOR3,COLOR4,COLOR5,COLOR6,                GRAPH.42
     * HDRINFO,LOGP,XPTOP,ICONDRV,LMETH,LEVELS,UREL,VREL,                        GRAPH.43
     * LABLINE,LABMESG,NOZERO                                                    GRAPH.44
      NAMELIST /JOEDEF/ TRUELAT1,TRUELAT2,ISTART,IEND,JSTART,JEND,               GRAPH.45
     *                  LW1, LW2, VSCALE0,                                       GRAPH.46
     *                  DASH1, DASH2, COLOR1, COLOR2, COLOR3,                    GRAPH.47
     *                  COLOR4,COLOR5,COLOR6,HDRINFO,LOGP,XPTOP,                 GRAPH.48
     *                  ICONDRV,LMETH,LEVELS,UREL,VREL,                          GRAPH.49
     *                  LABLINE,LABMESG,NOZERO,IHIRES                            GRAPH.50
      COMMON /MASK/ IMASK                                                        GRAPH.51
      COMMON /HIRES/ IHIRES                                                      GRAPH.52
      COMMON /XSECTION/ IXCRSB,JXCRSL,IXCRST,JXCRSR,LOCCRS                       GRAPH.53
      LOGICAL LOCCRS                                                             GRAPH.54
      DIMENSION GNLVL(50)                                                        GRAPH.55
      COMMON /SKWDRW/ ISKDRW                                                     GRAPH.56
      DIMENSION I4DDA(8)                                                         GRAPH.57
      REAL ICNS, JCNS                                                            GRAPH.58
      CHARACTER HDNMFILE*13                                                      GRAPH.59
C                                                                                GRAPH.60
C INITIALIZE SCRATCH SPACE                                                       GRAPH.61
C                                                                                GRAPH.62
      NTEMP = 1                                                                  GRAPH.63
C                                                                                GRAPH.64
C     ... INITIALIZE VERTICAL LEVELS TO AN OBVIOUS SNAFU                         GRAPH.65
C                                                                                GRAPH.66
      DO 50 K=1,100                                                              GRAPH.67
         PMAN (K)=-1.                                                            GRAPH.68
         PNON (K)=-1.                                                            GRAPH.69
         P    (K)=-1.                                                            GRAPH.70
         SIGMA(K)=-1.                                                            GRAPH.71
         THETA(K)=-1.                                                            GRAPH.72
         IFLAGS(K)=0                                                             GRAPH.73
50    CONTINUE                                                                   GRAPH.74
      KXP =0                                                                     GRAPH.75
      KXPM=0                                                                     GRAPH.76
      KXPN=0                                                                     GRAPH.77
      KXS =0                                                                     GRAPH.78
      KXT =0                                                                     GRAPH.79
      NFLAGS=1                                                                   GRAPH.80
      PRSPLT=.FALSE.                                                             GRAPH.81
      SIGPLT=.FALSE.                                                             GRAPH.82
      THTPLT=.FALSE.                                                             GRAPH.83
      IDRY=0                                                                     GRAPH.84
      INC=0                                                                      GRAPH.85
      IFILUNIT=20                                                                GRAPH.86
      NUMFRAME=0                                                                 GRAPH.87
C                                                                                GRAPH.88
C     ... READ IN PROGRAM NAME FROM HEADER, THIS IS ENOUGH TO                    GRAPH.89
C         DECIDE THE "IF" TESTS IN THIS PART OF GRAPH                            GRAPH.90
C                                                                                GRAPH.91
      REWIND(IFILUNIT)                                                           GRAPH.92
100   CONTINUE                                                                   GRAPH.93
C                                                                                GRAPH.94
C     ... READ HEADER FLAG                                                       GRAPH.95
C         FLAG = 1: BIG HEADER                                                   GRAPH.96
C                2: SUBHEADER AND FIELDS                                         GRAPH.97
C                3: END OF TIME                                                  GRAPH.98
C                                                                                GRAPH.99
      READ(IFILUNIT) FLAG                                                        GRAPH.100
      IF (FLAG.EQ.0) THEN                                                        GRAPH.101
         READ(IFILUNIT,ERR= 9001,END=9002) BHI,BHR,BHIC,BHRC                     GRAPH.102
         INDEX = BHI(  1,1)                                                      GRAPH.103
         INH=0                                                                   GRAPH.104
         IF (INDEX.GE.5) INH=1                                                   GRAPH.105
         PRINT 9000,PROGNAME(BHI(1,1))                                           GRAPH.106
         PRINT 9010,(BHI(II,INDEX),II=5,8)                                       GRAPH.107
9000     FORMAT(1X,'OUTPUT FILE FROM PROGRAM NAME = ',A6)                        GRAPH.108
9010     FORMAT(1X,'== DATE == ',I4,3I2.2)                                       GRAPH.109
C        MDATEBEG = BHI(2,INDEX)                                                 GRAPH.110
C        IF (INDEX.LT.6) MDATEBEG = MDATE                                        GRAPH.111
         GO TO 100                                                               GRAPH.112
                                                                                 GRAPH.113
      ELSE IF (FLAG.EQ.1) THEN                                                   GRAPH.114
                                                                                 GRAPH.115
         READ(IFILUNIT,IOSTAT=IER) ndim, start_index, end_index, rtime,          GRAPH.116
     -       staggering, ordering, current_date, name, units,                    GRAPH.117
     -       description                                                         GRAPH.118
         if(ier.ne.0) then                                                       GRAPH.119
            write(*,'("Error reading subheader")')                               GRAPH.120
            stop                                                                 GRAPH.121
         endif                                                                   GRAPH.122
         IF (NAME(1:6).EQ.'SIGMAH') THEN                                         GRAPH.123
            KXS = end_index(1)                                                   GRAPH.124
            READ(IFILUNIT) (SIGMA(KK),KK=start_index(1),end_index(1))            GRAPH.125
         ELSE IF (NAME(1:8).EQ.'PRESSURE') THEN                                  GRAPH.126
            KXP = end_index(1)                                                   GRAPH.127
            READ(IFILUNIT) (P(KK),KK=start_index(1),end_index(1))                GRAPH.128
            DO K = start_index(1),end_index(1)                                   GRAPH.129
               P(K) = P(K)/100.                                                  GRAPH.130
            END DO                                                               GRAPH.131
         ELSE                                                                    GRAPH.132
            READ(IFILUNIT) DUMMY                                                 GRAPH.133
         END IF                                                                  GRAPH.134
         CDATE = CURRENT_DATE(1:19)                                              GRAPH.135
         GO TO 100                                                               GRAPH.136
                                                                                 GRAPH.137
      ELSE IF (FLAG.EQ.2) THEN                                                   GRAPH.138
         GO TO 200                                                               GRAPH.139
      ENDIF                                                                      GRAPH.140
C                                                                                GRAPH.141
C     ... END READING FIRST TIME PERIOD                                          GRAPH.142
C                                                                                GRAPH.143
200   CONTINUE                                                                   GRAPH.144
      REWIND(IFILUNIT)                                                           GRAPH.145
C                                                                                GRAPH.146
C     ... REACHING THE END OF FIRST TIME PERIOD                                  GRAPH.147
C     ... LOOK FOR THE PROGRAM TYPE FROM THE RECORD HEADER                       GRAPH.148
C                                                                                GRAPH.149
      IF (BHI(1,1).EQ.1) THEN                                                    GRAPH.150
         PROG(1:6)='TERRN '                                                      GRAPH.151
         PRSPLT=.TRUE.                                                           GRAPH.152
         XTIME=-99.                                                              GRAPH.153
C                                                                                GRAPH.154
C        ... PRESSURE, MANDATORY LEVELS                                          GRAPH.155
C                                                                                GRAPH.156
         KXPM=0                                                                  GRAPH.157
C                                                                                GRAPH.158
C        ... PRESSURE, NON STANDARD LEVELS                                       GRAPH.159
C                                                                                GRAPH.160
         KXPN=1                                                                  GRAPH.161
         PNON(1)=1001.                                                           GRAPH.162
C                                                                                GRAPH.163
C        ... MANDATORY AND NON STANDARD PRESSURE LEVELS                          GRAPH.164
C                                                                                GRAPH.165
         KXP=1                                                                   GRAPH.166
         KM=0                                                                    GRAPH.167
         KN=1                                                                    GRAPH.168
         P(1)=1001.                                                              GRAPH.169
C                                                                                GRAPH.170
      ELSE IF(BHI( 1,1).EQ.2) THEN                                               GRAPH.171
         PROG(1:6)='REGRID'                                                      GRAPH.172
         PRSPLT=.TRUE.                                                           GRAPH.173
         XTIME=-99.                                                              GRAPH.174
C                                                                                GRAPH.175
C        ... GET PRESSURE LEVELS, MANDATORY AND NON-MANDATORY                    GRAPH.176
C                                                                                GRAPH.177
         NLV =KXP                                                                GRAPH.178
         CALL GETPPAR(IFILUNIT, 0)                                               GRAPH.179
         KM=1                                                                    GRAPH.180
         KN=1                                                                    GRAPH.181
C                                                                                GRAPH.182
      ELSE IF (BHI(1,1).EQ.3) THEN                                               GRAPH.183
         PROG(1:6)='RAWINS'                                                      GRAPH.184
C        PROG(1:6)='LITTLR'                                                      GRAPH.185
         PRSPLT=.TRUE.                                                           GRAPH.186
         XTIME=-99.                                                              GRAPH.187
C                                                                                GRAPH.188
C        ... GET PRESSURE LEVELS, MANDATORY AND NON-MANDATORY                    GRAPH.189
C                                                                                GRAPH.190
         NLV =KXP                                                                GRAPH.191
         CALL GETPPAR(IFILUNIT, 0)                                               GRAPH.192
         KM=1                                                                    GRAPH.193
         KN=1                                                                    GRAPH.194
C                                                                                GRAPH.195
      ELSE IF(BHI( 1,1).EQ.4) THEN                                               GRAPH.196
         PROG(1:6)='RAWSFC'                                                      GRAPH.197
         PRSPLT=.TRUE.                                                           GRAPH.198
         XTIME=-99.                                                              GRAPH.199
C                                                                                GRAPH.200
C        ... PRESSURE, MANDATORY LEVELS                                          GRAPH.201
C                                                                                GRAPH.202
         KXPM=0                                                                  GRAPH.203
C                                                                                GRAPH.204
C        ... PRESSURE, NON STANDARD LEVELS                                       GRAPH.205
C                                                                                GRAPH.206
         KXPN=1                                                                  GRAPH.207
         PNON(1)=1001.                                                           GRAPH.208
C                                                                                GRAPH.209
C        ... MANDATORY AND NON STANDARD PRESSURE LEVELS                          GRAPH.210
C                                                                                GRAPH.211
         KXP=1                                                                   GRAPH.212
         KM=0                                                                    GRAPH.213
         KN=1                                                                    GRAPH.214
         P(1)=1001.                                                              05DEC01.89
C                                                                                GRAPH.215
C                                                                                GRAPH.216
      ELSE IF(BHI( 1,1).EQ.8) THEN                                               05DEC01.90
C                                                                                GRAPH.218
         PROG(1:6)='MM5PRS'                                                      GRAPH.219
         CALL GETPPAR(IFILUNIT, 2)                                               GRAPH.220
C                                                                                GRAPH.221
      ELSE IF(BHI( 1,1).EQ.5) THEN                                               GRAPH.222
         PROG(1:6)='MMINP '                                                      GRAPH.223
         CALL GETSPAR(IFILUNIT,0)                                                GRAPH.224
C                                                                                GRAPH.225
      ELSE IF (BHI(1,1).EQ.6) THEN                                               GRAPH.226
         PROG(1:6)='MMINPL'                                                      GRAPH.227
         PRSPLT=.TRUE.                                                           GRAPH.228
         XTIME=-99.                                                              GRAPH.229
C                                                                                GRAPH.230
C        ... PRESSURE, MANDATORY LEVELS                                          GRAPH.231
C                                                                                GRAPH.232
         KXPM=0                                                                  GRAPH.233
C                                                                                GRAPH.234
C        ... PRESSURE, NON STANDARD LEVELS                                       GRAPH.235
C                                                                                GRAPH.236
         KXPN=1                                                                  GRAPH.237
         PNON(1)=1001.                                                           GRAPH.238
C                                                                                GRAPH.239
C        ... MANDATORY AND NON STANDARD PRESSURE LEVELS                          GRAPH.240
C                                                                                GRAPH.241
         KXP=1                                                                   GRAPH.242
         KM=0                                                                    GRAPH.243
         KN=1                                                                    GRAPH.244
         P(1)=1001.                                                              GRAPH.245
                                                                                 GRAPH.246
      ELSE IF(BHI( 1,1).EQ.11) THEN                                              GRAPH.247
         PROG(1:6)='MMOUT '                                                      GRAPH.248
         CALL GETSPAR(IFILUNIT,2)                                                GRAPH.249
C                                                                                GRAPH.250
      ELSE                                                                       GRAPH.251
         PRINT *,'UNKNOWN TYPE OF DATA'                                          GRAPH.252
         PRINT 1356,IPROG                                                        GRAPH.253
1356     FORMAT(' PROGRAM NAME IS ',A6,'.  YOU EVER HEAR OF IT')                 GRAPH.254
         STOP 66666                                                              GRAPH.255
      END IF                                                                     GRAPH.256
C                                                                                GRAPH.257
C     ... HOW MANY TIMES IN THE DATA SET                                         GRAPH.258
C                                                                                GRAPH.259
         IF (INDEX.EQ.1) THEN                                                    GRAPH.260
           IFILES = 1                                                            GRAPH.261
         ELSE IF (INDEX.GE.8) THEN                                               GRAPH.262
           IFILES = 100                                                          GRAPH.263
         ELSE                                                                    GRAPH.264
           IFILES  =100                                                          GRAPH.265
         ENDIF                                                                   GRAPH.266
C                                                                                GRAPH.267
C     ... GET THE HORIZONTAL SIZE OF THE ORIGINAL DATA SET                       GRAPH.268
C                                                                                GRAPH.269
      IF((PROG(1:6).EQ.'REGRID' .OR. PROG(1:6).EQ.'TERRN ')                      GRAPH.270
     *                                  .AND.BHI( 8,1).EQ.1) THEN                GRAPH.271
C                                                                                GRAPH.272
        IF (PROG(1:6).EQ.'TERRN ')                                               GRAPH.273
     *   PRINT *,'DATA FROM TERRAIN, AND COARSE DOMAIN EXPANDED !'               GRAPH.274
        IF (PROG(1:6).EQ.'REGRID')                                               GRAPH.275
     *   PRINT *,'DATA FROM DATAGRID, AND COARSE DOMAIN EXPANDED !'              GRAPH.276
C  EXPANDEDN COARSE DOMAIN:                                                      GRAPH.277
        IMX     =BHI( 9,1)              ! HORIZONTAL GRIDS, X DIRECTION          GRAPH.278
        JMX     =BHI(10,1)              ! HORIZONTAL GRIDS, Y DIRECTION          GRAPH.279
      ELSE                                                                       GRAPH.280
C  UNEXPANDED COARSE DOMAIN:                                                     GRAPH.281
        IMX     =BHI( 5,1)              ! HORIZONTAL GRIDS, Y DIRECTION          GRAPH.282
        JMX     =BHI( 6,1)              ! HORIZONTAL GRIDS, Y DIRECTION          GRAPH.283
      ENDIF                                                                      GRAPH.284
C                                                                                GRAPH.285
C     ... CHECK TO SEE IF THIS IS A NEST, WHICH CHANGES THE SIZE                 GRAPH.286
C                                                                                GRAPH.287
      IF (BHI( 15,1).NE.0) THEN                                                  GRAPH.288
         ITSANEST=1                                                              GRAPH.289
         IMX=BHI( 16,1)                                                          GRAPH.290
         JMX=BHI( 17,1)                                                          GRAPH.291
      ELSE                                                                       GRAPH.292
         ITSANEST=0                                                              GRAPH.293
      END IF                                                                     GRAPH.294
C                                                                                GRAPH.295
C     ... OTHER JAZZ FROM HEADER, MOST NEEDED FOR THE MAP                        GRAPH.296
C                                                                                GRAPH.297
      INTVLY  =5                                                                 GRAPH.298
      INTVLX  =5                                                                 GRAPH.299
      KSIGDIG =5                                                                 GRAPH.300
      DS      =BHR(  9,1)                                                        GRAPH.301
C     IF(DS.LT.1000.) DS=DS*1000.        ! GRID DISTANCE METERS                  GRAPH.302
      PHIC    =BHR(  2,1)                ! CENTER LATITUDE                       GRAPH.303
      XLONC   =BHR(  3,1)                ! CENTER LONGITUDE                      GRAPH.304
      PTOP    =BHR(  2,2)/100.           ! PTOP IN MB                            GRAPH.305
C     IF(PTOP.LT.10.) PTOP=PTOP*10.                                              GRAPH.306
C                                                                                GRAPH.307
C     ... NOW GET THE VERTICAL SIZE OF THE DATA SET                              GRAPH.308
C                                                                                GRAPH.309
      KX1=MAX0(KXP,MAX0(KXPM,KXPN))                                              GRAPH.310
      KXTBIG=1                                                                   GRAPH.311
      KX2=MAX0(KXS,KXTBIG)                                                       GRAPH.312
      KX =MAX0(KX1,KX2)                                                          GRAPH.313
C                                                                                GRAPH.314
C     ... HERE ARE THE HORIZONTAL AND VERTICAL SIZES, CHECK FOR                  GRAPH.315
C         OBVIOUS SNAFUS                                                         GRAPH.316
C                                                                                GRAPH.317
      I1=IMX                                                                     GRAPH.318
      J1=JMX                                                                     GRAPH.319
      K1=KX                                                                      GRAPH.320
C                                                                                GRAPH.321
C     ... DEFAULTS FOR NAMELIST                                                  GRAPH.322
C                                                                                GRAPH.323
      TRUELAT1 = BHR(  5,1)                                                      GRAPH.324
      TRUELAT2 = BHR(  6,1)                                                      GRAPH.325
C     PRINT *,'TRUELAT1=',TRUELAT1,'  TRUELAT2=',TRUELAT2                        GRAPH.326
      ISTART=1                                                                   GRAPH.327
      JSTART=1                                                                   GRAPH.328
      IEND=I1                                                                    GRAPH.329
      JEND=J1                                                                    GRAPH.330
      LW1 = 2000                                                                 GRAPH.331
      LW2 = 2000                                                                 GRAPH.332
      DASH1=0                                                                    GRAPH.333
      DASH2=-682                                                                 GRAPH.334
      COLOR1=16                                                                  GRAPH.335
      COLOR2=7                                                                   GRAPH.336
      COLOR3=9                                                                   GRAPH.337
      COLOR4=COLOR1                                                              GRAPH.338
      COLOR5=COLOR2                                                              GRAPH.339
      COLOR6=COLOR3                                                              GRAPH.340
      HDRINFO=.FALSE.                                                            GRAPH.341
      LOGP=0                                                                     GRAPH.342
      IF(KXP.NE.0) XPTOP=P(KXP)                                                  GRAPH.343
      IF(KXS.NE.0) XPTOP=100.                                                    GRAPH.344
      ICONDRV(1)=.FALSE.                                                         GRAPH.345
      ICONDRV(2)=.FALSE.                                                         GRAPH.346
      UREL=0.                                                                    GRAPH.347
      VREL=0.                                                                    GRAPH.348
      LABLINE=1                                                                  GRAPH.349
      LABMESG=0                                                                  GRAPH.350
      NOZERO=0                                                                   GRAPH.351
      VSCALE0=0.0  ! SCALE FOR VERTICAL VELOCITY TO ENLARGE THE CIRCULAT         GRAPH.352
      IMASK=0                                                                    GRAPH.353
      IHIRES=0                                                                   GRAPH.354
C                                                                                GRAPH.355
C     ... READ IN THE USER DEFINED DEFAULT VALUES                                GRAPH.356
C                                                                                GRAPH.357
      IDEFAULT=19                                                                GRAPH.358
      OPEN (IDEFAULT,FILE='g_defaults.nml',STATUS='OLD',ERR=123)                 GRAPH.359
      READ(IDEFAULT,JOEDEF)                                                      GRAPH.360
123   CONTINUE                                                                   GRAPH.361
      CLOSE(IDEFAULT)                                                            GRAPH.362
C                                                                                GRAPH.363
C     ... PRINT OUT A BIT OF INFO FROM THE DATA SET                              GRAPH.364
C                                                                                GRAPH.365
      IF(HDRINFO) THEN                                                           GRAPH.366
         CALL GETGIST(BHI, BHR, BHIC, BHRC, HDRINFO)                             GRAPH.367
         PRINT *,'REMEMBER TO CHANGE THE G_DEFAULTS.NML FILE!'                   GRAPH.368
         STOP 88888                                                              GRAPH.369
      ENDIF                                                                      GRAPH.370
C                                                                                GRAPH.371
C     ... STOP BEFORE REQUESTING SILLY SPACE                                     GRAPH.372
C                                                                                GRAPH.373
      IF((I1.LT.1).OR.(J1.LT.1).OR.(K1.LT.1)) THEN                               GRAPH.374
         PRINT *,'I1,J1,K1=',I1,J1,K1                                            GRAPH.375
         PRINT *,'HARDLY SEEMS LIKELY THAT THIS IS THE DATA SET SIZE'            GRAPH.376
         STOP 55555                                                              GRAPH.377
      ENDIF                                                                      GRAPH.378
C                                                                                GRAPH.379
C     ... DEFINE MAP/PLOT DOMAIN FROM USER WINDOW INFORMATION                    GRAPH.380
C         AND NEST SUB-GRID LOCATION                                             GRAPH.381
C                                                                                GRAPH.382
      IF(ITSANEST.EQ.1) THEN                                                     GRAPH.383
         ICNS=BHR( 10,1)                                                         GRAPH.384
         JCNS=BHR( 11,1)                                                         GRAPH.385
         IRATIO=BHI( 20,1)                                                       GRAPH.386
         DS=BHR(  1,1)/FLOAT(IRATIO)                                             GRAPH.387
         IMAPMAX=(BHI(  5,1)-1)*IRATIO+1                                         GRAPH.388
         JMAPMAX=(BHI(  6,1)-1)*IRATIO+1                                         GRAPH.389
         IMAPST=NINT((ICNS-1)*IRATIO+ISTART)                                     GRAPH.390
         JMAPST=NINT((JCNS-1)*IRATIO+JSTART)                                     GRAPH.391
         IMAPEND=NINT((ICNS-1)*IRATIO+IEND)                                      GRAPH.392
         JMAPEND=NINT((JCNS-1)*IRATIO+JEND)                                      GRAPH.393
         YPA=FLOAT(ISTART)                                                       GRAPH.394
         XPA=FLOAT(JSTART)                                                       GRAPH.395
         YPB=FLOAT(IEND)                                                         GRAPH.396
         XPB=FLOAT(JEND)                                                         GRAPH.397
      ELSE                                                                       GRAPH.398
         IMAPMAX=IMX                                                             GRAPH.399
         JMAPMAX=JMX                                                             GRAPH.400
         JMAPST  = JSTART                                                        GRAPH.401
         JMAPEND = JEND                                                          GRAPH.402
         IMAPST  = ISTART                                                        GRAPH.403
         IMAPEND = IEND                                                          GRAPH.404
         YPA=FLOAT(ISTART)                                                       GRAPH.405
         XPA=FLOAT(JSTART)                                                       GRAPH.406
         YPB=FLOAT(IEND)                                                         GRAPH.407
         XPB=FLOAT(JEND)                                                         GRAPH.408
      END IF                                                                     GRAPH.409
C                                                                                GRAPH.410
C     ... ALLOCATE HEAP MEMORY FOR DUMMY 3D AND 2D ARRAYS                        GRAPH.411
C                                                                                GRAPH.412
      LEN3D=IMX*JMX*KX  ! 3D ARRAYS                                              GRAPH.413
      LEN2D=IMX*JMX     ! 2D ARRAYS                                              GRAPH.414
      LEN23=LEN2D * 4 + LEN3D * 4                                                GRAPH.415
CC                                                                               GRAPH.416
CC      CALL HPALLOC(PTRD31,LEN23,IER,0)                                         GRAPH.417
CC                                                                               GRAPH.418
      IF(LEN23 .GT. I3DV) THEN                                                   GRAPH.419
        WRITE(6,*) ' NEED MORE DATA SPACE '                                      GRAPH.420
        WRITE(6,*) ' SPACE NEEDED ',LEN23                                        GRAPH.421
        WRITE(6,*) ' SPACE IN SCRATCH I3DV IS ',I3DV                             GRAPH.422
        WRITE(6,*) ' IMX = ',IMX,', JMX = ',JMX,', KX = ',KX                     05DEC01.91
        STOP                                                                     GRAPH.423
      ELSE                                                                       GRAPH.424
        PTRD31 = 1                                                               GRAPH.425
      END IF                                                                     GRAPH.426
C                                                                                GRAPH.427
      PTRD32=PTRD31 + LEN3D                                                      GRAPH.428
      PTRD33=PTRD32 + LEN3D                                                      GRAPH.429
      PTRD34=PTRD33 + LEN3D                                                      GRAPH.430
      PTRD21=PTRD34 + LEN3D                                                      GRAPH.431
      PTRD22=PTRD21 + LEN2D                                                      GRAPH.432
      PTRD23=PTRD22 + LEN2D                                                      GRAPH.433
      PTRD24=PTRD23 + LEN2D                                                      GRAPH.434
C                                                                                GRAPH.435
C     ... OPEN GKS, GET GFLAS READY FOR THE MAP BACKGROUND AND                   GRAPH.436
C         THE SKEW-T BACKGROUND                                                  GRAPH.437
C                                                                                GRAPH.438
      CALL OPNGKS                                                                GRAPH.439
      CALL GSCLIP (0)                                                            GRAPH.440
      CALL GOPWK (2,9,3)                                                         GRAPH.441
      CALL GSFAIS(1)                                                             GRAPH.442
C                                                                                GRAPH.443
C     ... SET UP COLOR TABLE                                                     GRAPH.444
C                                                                                GRAPH.445
      ICOLOR=19                                                                  GRAPH.446
      OPEN (ICOLOR,FILE='g_color.tbl',STATUS='OLD')                              GRAPH.447
      CALL RDCOLT (ICOLOR)                                                       GRAPH.448
      CLOSE (ICOLOR)                                                             GRAPH.449
C                                                                                GRAPH.450
C     ... THE GDRIVER ROUTINE IS CALLED ONE TIME PER GRAPH                       GRAPH.451
C         EXECUTION, EXCEPT FOR THE PRELIMINARY DATA SIZE, ETC,                  GRAPH.452
C         ALL PROCESSING IS DONE FROM GDRIVER                                    GRAPH.453
C                                                                                GRAPH.454
      CALL GDRIVER(IFILES*10)                                                    GRAPH.455
C                                                                                GRAPH.456
C     ... GENERATE A FILE OF INPUT FOR MED, A UNICOS UTILITY TO                  GRAPH.457
C         SPLIT METACODE FILES                                                   GRAPH.458
C                                                                                GRAPH.459
      OPEN (19,FILE='numsplit.tbl',STATUS='OLD')                                 GRAPH.460
      READ (19,'(I2)') NUMSPLIT                                                  GRAPH.461
      CLOSE (19)                                                                 GRAPH.462
      MEDUNIT=19                                                                 GRAPH.463
      CALL MEDOUT(NUMFRAME,NUMSPLIT,MEDUNIT)                                     GRAPH.464
C                                                                                GRAPH.465
C     ... SHUT DOWN GKS GRACEFULLY, CLOSE THE GFLAS FOR THE                      GRAPH.466
C         BACKGROUNDS                                                            GRAPH.467
C                                                                                GRAPH.468
      CALL GCLWK (2)  ! CLOSE GFLASH FOR MAP AND SKEW-T BACKGROUND               GRAPH.469
      CALL CLSGKS                                                                GRAPH.470
C                                                                                GRAPH.471
C     ... CAPPING OFF A FINE PERFORMANCE                                         GRAPH.472
C                                                                                GRAPH.473
      PRINT 1112                                                                 GRAPH.474
1112  FORMAT('1')                                                                GRAPH.475
      PRINT *,'SUCCESSFUL GRAPH COMPLETION'                                      GRAPH.476
      STOP 99999                                                                 GRAPH.477
C                                                                                GRAPH.478
9001  CONTINUE                                                                   GRAPH.479
C                                                                                GRAPH.480
C     ... ERROR IN READING HEADER                                                GRAPH.481
C                                                                                GRAPH.482
      PRINT *,'  '                                                               GRAPH.483
      PRINT *,'ERROR IN READING HEADER'                                          GRAPH.484
      STOP 9001                                                                  GRAPH.485
C                                                                                GRAPH.486
9002  CONTINUE                                                                   GRAPH.487
C                                                                                GRAPH.488
C     ... ERROR IN READING HEADER                                                GRAPH.489
C                                                                                GRAPH.490
      PRINT *,'  '                                                               GRAPH.491
      PRINT *,'EOF DETECTED INITIALLY IN READING HEADER'                         GRAPH.492
      PRINT *,'THIS DATA SET IS EMPTY, OR INCORRECTLY ASSIGNED'                  GRAPH.493
      STOP 9002                                                                  GRAPH.494
      END                                                                        GRAPH.495
