      SUBROUTINE GRNDTMP(TSEASFC,TSFC,XLAND,IMX,JMX,TGD,ISWATER)                 GRNDTMP.1
C                                                                                GRNDTMP.2
C     SECTION  DIAGNOSTIC                                                        GRNDTMP.3
C     PURPOSE  COMPUTES THE GROUND TEMPERATURE.  IF THE LOCATION                 GRNDTMP.4
C              IS OVER THE OCEAN, THE GROUND TEMPERATURE IS SET TO               GRNDTMP.5
C              SEA SURFACE TEMPERATURE.  IF THE LOCATION IS OVER LAND,           GRNDTMP.6
C              THE GROUND TEMP IS SET TO SURFACE TEMP.                           GRNDTMP.7
C                                                                                GRNDTMP.8
C     INPUT       TSEASFC  SEA SURFACE TEMPERATURE    CROSS    2D                GRNDTMP.9
C                 TSFC     SURFACE TEMPERATURE        CROSS    2D                GRNDTMP.10
C                 XLAND    LAND USE CATEGORIES        CROSS    2D                GRNDTMP.11
C                 IMX      DOT POINT DIMENSION N-S                               GRNDTMP.12
C                 JMX      DOT POINT DIMENSION E-W                               GRNDTMP.13
C                                                                                GRNDTMP.14
C     OUTPUT      TGD      GROUND TEMPERATURE         CROSS    2D                GRNDTMP.15
C                                                                                GRNDTMP.16
      DIMENSION TSEASFC(IMX,JMX) ,TSFC(IMX,JMX)  ,XLAND(IMX,JMX)                 GRNDTMP.17
      DIMENSION TGD(IMX,JMX)                                                     GRNDTMP.18
C                                                                                GRNDTMP.19
      WATERMASK = FLOAT(ISWATER)                                                 GRNDTMP.20
      DO 100 J=1,JMX-1                                                           GRNDTMP.21
      DO 100 I=1,IMX-1                                                           GRNDTMP.22
         IF (ABS(XLAND(I,J)-WATERMASK).GT.0.05)THEN                              GRNDTMP.23
            TGD(I,J)=TSFC(I,J)                                                   GRNDTMP.24
         ELSE                                                                    GRNDTMP.25
            TGD(I,J)=TSEASFC(I,J)                                                GRNDTMP.26
         ENDIF                                                                   GRNDTMP.27
100   CONTINUE                                                                   GRNDTMP.28
      RETURN                                                                     GRNDTMP.29
      END                                                                        GRNDTMP.30
