      SUBROUTINE INTEGRAT(FLD3D,PP,PS,IX,JX,KX,SIGMA,PTOP,ICRSDOT,SLAB)          INTEGRAT.1
C                                                                                INTEGRAT.2
C     SECTION  DIAGNOSTIC                                                        INTEGRAT.3
C     PURPOSE  VERTICALLY INTEGRATE THE INCOMING 3D FIELD (FLD3D) INTO           INTEGRAT.4
C     2D FIELD (SLAB) ON SIGMA LEVELS.  DATA IS WEIGHTED                         INTEGRAT.5
C     ACCORDING TO SIGMA LAYER'S PRESSURE DIFFERENCE , ALL LEVELS ARE            INTEGRAT.6
C     SUMMED                                                                     INTEGRAT.7
C                                                                                INTEGRAT.8
C     INPUT   FLD3D    INPUT FIELD               CROSS OR DOT 3D                 INTEGRAT.9
C             PP       =P PERTURB. FOR NON-HYDR., =0. FOR HYDR. AT CROSS PNTS.   INTEGRAT.10
C             PS       PSTAR AT CROSS PNTS.                                      INTEGRAT.11
C             PTOP     PRESSURE AT TOP OF MODEL                                  INTEGRAT.12
C             IX       DOT POINT DIMENSION N-S                                   INTEGRAT.13
C             JX       DOT POINT DIMENSION E-W                                   INTEGRAT.14
C             KX       NUMBER OF VERTICAL LAYERS                                 INTEGRAT.15
C             SIGMA    SIGMA ON HALF LEVELS               1D                     INTEGRAT.16
C             ICRSDOT  0=DOT, 1=CROSS POINT                                      INTEGRAT.17
C                                                                                INTEGRAT.18
C     OUTPUT  SLAB     INTEGRATED FIELD          CR OR DT 2D                     INTEGRAT.19
C             SLAB = SUM(FLD3D*DP)/G  (G/CM**2) OR (CM)                          INTEGRAT.20
C                                                                                INTEGRAT.21
      DIMENSION FLD3D(IX,JX,KX), PP(IX,JX,KX), PS(IX,JX), SIGMA(KX)              INTEGRAT.22
      DIMENSION SLAB(IX,JX)                                                      INTEGRAT.23
C                                                                                INTEGRAT.24
C     ... INITIALIZE INTEGRATED SLAB                                             INTEGRAT.25
C                                                                                INTEGRAT.26
      CALL CLEAR(SLAB,IX,JX,1)                                                   INTEGRAT.27
      IF (ICRSDOT.EQ.0) THEN                                                     INTEGRAT.28
        CALL FILLIT(PP,IX,JX,KX,IX,JX, 1,IX-1, 1,JX-1)                           INTEGRAT.29
        CALL FILLIT(PS,IX,JX, 1,IX,JX, 1,IX-1, 1,JX-1)                           INTEGRAT.30
      END IF                                                                     INTEGRAT.31
C                                                                                INTEGRAT.32
C     ... WEIGHTED SUM OF VERTICAL COLUMN                                        INTEGRAT.33
C                                                                                INTEGRAT.34
      GG  = 10./9.8                                                              INTEGRAT.35
      DO 1000 J=1,JX-ICRSDOT                                                     INTEGRAT.36
      DO 1000 I=1,IX-ICRSDOT                                                     INTEGRAT.37
         SIG1=0.0                                                                INTEGRAT.38
         PR1=PTOP                                                                INTEGRAT.39
         DO 500 K=1,KX                                                           INTEGRAT.40
            SIGH1=SIGMA(K)                                                       INTEGRAT.41
            IF (K.LT.KX) SIGH2=SIGMA(K+1)                                        INTEGRAT.42
            SIG1=2.*(SIGMA(K)-SIG1)+SIG1                                         INTEGRAT.43
            P1 = PS(I,J)*SIGH1+PTOP+PP(I,J,K)                                    INTEGRAT.44
            IF (K.LT.KX) THEN                                                    INTEGRAT.45
               P2 =  PS(I,J)*SIGH2+PTOP+PP(I,J,K+1)                              INTEGRAT.46
               PR2 = P1+(P2-P1)*(SIG1-SIGH1)/(SIGH2-SIGH1)                       INTEGRAT.47
            ELSE                                                                 INTEGRAT.48
               PR2 = PS(I,J)+PTOP+PP(I,J,KX)                                     INTEGRAT.49
            END IF                                                               INTEGRAT.50
            DPR = PR2-PR1                                                        INTEGRAT.51
            SLAB(I,J)=SLAB(I,J)+FLD3D(I,J,K)*DPR*GG                              INTEGRAT.52
            PR1=PR2                                                              INTEGRAT.53
500      CONTINUE                                                                INTEGRAT.54
1000  CONTINUE                                                                   INTEGRAT.55
C                                                                                INTEGRAT.56
      RETURN                                                                     INTEGRAT.57
      END                                                                        INTEGRAT.58
