      SUBROUTINE LI(FIELD,THETAE,T,PSFC,P,I1,J1,K1,THLI)                         LI.1
#     include <scratch.incl>                                                     LI.2
C                                                                                LI.3
      INEED = I1*J1                                                              LI.4
      IN1 = NTEMP                                                                LI.5
      NTEMP = NTEMP+INEED                                                        LI.6
      IF(NTEMP .GT. I_SCRATCH) CALL SPACE_STOP('LI')                             LI.7
      IF(VERBOSE) WRITE(6,*) ' CALLING LI ',INEED,IN1,NTEMP                      LI.8
C     CALL LI_0(THETAE,THETAES,PSFC,P,I1,J1,K1,THLI,SCR(IN1))                    LI.9
      CALL LI_0(FIELD,THETAE,T,PSFC,P,I1,J1,K1,THLI,SCR(IN1))                    LI.10
      NTEMP = NTEMP - INEED                                                      LI.11
      IF(VERBOSE) WRITE(6,*) ' RET FROM LI ',NTEMP                               LI.12
      RETURN                                                                     LI.13
      END                                                                        LI.14
C                                                                                LI.15
      SUBROUTINE LI_0(FIELD,THETAE,T,PSFC,P,I1,J1,K1,THLI,KABOVE)                LI.16
C                                                                                LI.17
C COMPUTE VARIOUS LIFTED INDICES BASED ON LIFTING DIFFERENT PARCELS.             LI.18
C THE LEVELS TO BE USED ARE BASED ON THE NAME CONTAINED IN FIELD.                LI.19
C WE MAKE THE ASSUMPTION THAT P(1) = 1001. IE. LEVEL 1 CONTAINS SFC DATA         LI.20
C                                                                                LI.21
      DIMENSION THETAE(I1,J1,K1),T(I1,J1,K1),                                    LI.22
     *          PSFC(I1,J1),P(K1),THLI(I1,J1)                                    LI.23
      DIMENSION KABOVE(I1,J1)                                                    LI.24
      CHARACTER FIELD*(*)                                                        LI.25
C                                                                                LI.26
      IF (FIELD(3:3) .EQ. 'S') THEN                                              LI.27
C SURFACE LI                                                                     LI.28
        IP = 1                                                                   LI.29
      ELSE IF (FIELD(3:3) .EQ. 'M' ) THEN                                        LI.30
C MINIMUM LI                                                                     LI.31
        IP = 9999                                                                LI.32
      ELSE IF (FIELD(3:3) .EQ. '8' ) THEN                                        LI.33
C 850 LI                                                                         LI.34
        IP = 850                                                                 LI.35
      ELSE                                                                       LI.36
C ORIGINAL METHOD                                                                LI.37
        IP = -1                                                                  LI.38
      ENDIF                                                                      LI.39
C FIND THE INDEX CORRESPONDING TO THE 500 MB LEVEL                               LI.40
      K500=0                                                                     LI.41
      DO 100 K=2,K1                                                              LI.42
         IF( ABS(P(K)-500.).LT.0.01 ) THEN                                       LI.43
            K500=K                                                               LI.44
            GOTO 101                                                             LI.45
         ENDIF                                                                   LI.46
100   CONTINUE                                                                   LI.47
      PRINT *,'COULD NOT FIND P=500 MB LEVEL'                                    LI.48
      CALL ABORT                                                                 LI.49
101   CONTINUE                                                                   LI.50
C                                                                                LI.51
C     ... FIND K LEVEL ABOVE SURFACE FOR EACH I,J                                LI.52
C                                                                                LI.53
      DO 200 J=1,J1-1                                                            LI.54
      DO 200 I=1,I1-1                                                            LI.55
         KABOVE(I,J)=0                                                           LI.56
200   CONTINUE                                                                   LI.57
C                                                                                LI.58
      DO 400 J=1,J1-1                                                            LI.59
      DO 400 I=1,I1-1                                                            LI.60
         DO 300 K=2,K1                                                           LI.61
            IF (P(K) .LE. PSFC(I,J) .AND. IP .EQ. -1) THEN                       LI.62
               KABOVE(I,J) = K                                                   LI.63
               GOTO 301                                                          LI.64
            ELSE IF (IP .EQ. 1) THEN                                             LI.65
               KABOVE(I,J) = 1                                                   LI.66
               GO TO 301                                                         LI.67
            ELSE IF (IP .GT. 500 .AND. IP .LT. 1100 .AND.                        LI.68
     &        ABS(P(K)-IP) .LT. 0.01) THEN                                       LI.69
               KABOVE(I,J) = K                                                   LI.70
               GO TO 301                                                         LI.71
            ENDIF                                                                LI.72
300      CONTINUE                                                                LI.73
301      CONTINUE                                                                LI.74
400   CONTINUE                                                                   LI.75
C                                                                                LI.76
C     ... NOW THE LIFTED INDEX                                                   LI.77
C                                                                                LI.78
      IF (IP .EQ. -1) THEN                                                       LI.79
C ORIGINAL METHOD                                                                LI.80
        DO 500 J=1,J1-1                                                          LI.81
          DO 500 I=1,I1-1                                                        LI.82
            THM = (THETAE(I,J,KABOVE(I,J)) +                                     LI.83
     &                THETAE(I,J,KABOVE(I,J)+1) ) * 0.5                          LI.84
            THLI(I,J)= T(I,J,K500) - PR_TMST(THM,500.,0.)                        LI.85
500     CONTINUE                                                                 LI.86
      ELSE IF (IP .EQ. 9999) THEN                                                LI.87
C MINIMUM LI                                                                     LI.88
        DO 501 J = 1, J1-1                                                       LI.89
          DO 501 I = 1, I1-1                                                     LI.90
            THLI(I,J) = 99999.                                                   LI.91
            DO 502 K = 1, K1                                                     LI.92
              IF (K .GT. 1 .AND. P(K) .GT. PSFC(I,J)) GO TO 502                  LI.93
              IF (P(K) .LT. 700.) GO TO 501                                      LI.94
              THLI(I,J) = AMIN1(THLI(I,J),                                       LI.95
     &              T(I,J,K500) - PR_TMST(THETAE(I,J,K),500.,0.))                LI.96
  502     CONTINUE                                                               LI.97
  501   CONTINUE                                                                 LI.98
      ELSE                                                                       LI.99
C ALL OTHER LEVELS                                                               LI.100
        DO 504 J = 1, J1-1                                                       LI.101
          DO 504 I = 1, I1-1                                                     LI.102
            THLI(I,J) = T(I,J,K500) -                                            LI.103
     &             PR_TMST(THETAE(I,J,KABOVE(I,J)),500.,0.)                      LI.104
  504   CONTINUE                                                                 LI.105
      ENDIF                                                                      LI.106
C                                                                                LI.107
      RETURN                                                                     LI.108
      END                                                                        LI.109
C-------------------------------------------------------------                   LI.110
        FUNCTION PR_TMST  ( THTE, PRES, TGUESS )                                 LI.111
C* THIS FUNCTION COMPUTES TMST FROM THTE, PRES, TGUESS.  TMST IS THE             LI.112
C* PARCEL TEMPERATURE AT LEVEL PRES ON A SPECIFIED MOIST ADIABAT                 LI.113
C* (THTE).  THE COMPUTATION IS AN ITERATIVE NEWTON-RAPHSON TECHNIQUE.            LI.114
C* INPUT PARAMETERS:                                                             LI.115
C*      THTE            REAL            EQUIVALENT POTENTIAL TEMP IN K           LI.116
C*      PRES            REAL            PRESSURE IN MILLIBARS                    LI.117
C*      TGUESS          REAL            FIRST GUESS TEMPERATURE IN K             LI.118
C*                                                                               LI.119
C* OUTPUT PARAMETERS:                                                            LI.120
C*      PR_TMST         REAL            PARCEL TEMPERATURE IN KELVIN             LI.121
C                                                                                LI.122
        PARAMETER (RMISSD = -999)                                                LI.123
        TG = TGUESS                                                              LI.124
        IF  ( TG .EQ. 0. )  TG =                                                 LI.125
     *          (THTE - .5 * ( MAX ( THTE-270., 0. ) ) ** 1.05 )                 LI.126
     *                  * ( PRES / 1000. ) ** .2                                 LI.127
        EPSI = .01                                                               LI.128
        TGNU = TG -273.16                                                        LI.129
        DO  10 I = 1, 100                                                        LI.130
          TGNUP = TGNU + 1.                                                      LI.131
          TENU = PR_THTE ( PRES, TGNU, TGNU )                                    LI.132
          TENUP = PR_THTE ( PRES, TGNUP, TGNUP )                                 LI.133
C                                                                                LI.134
C*        COMPUTE THE CORRECTION, DELTG; RETURN ON CONVERGENCE.                  LI.135
C                                                                                LI.136
          COR  = ( THTE - TENU ) / ( TENUP - TENU )                              LI.137
          TGNU = TGNU + COR                                                      LI.138
          IF  ( ( COR .LT. EPSI ) .AND. ( -COR .LT. EPSI ) )  THEN               LI.139
              PR_TMST = TGNU + 273.16                                            LI.140
              RETURN                                                             LI.141
          END IF                                                                 LI.142
   10   CONTINUE                                                                 LI.143
C                                                                                LI.144
C*      FAILED TO CONVERGE - RETURN MISSING.                                     LI.145
C                                                                                LI.146
        PR_TMST = RMISSD                                                         LI.147
        RETURN                                                                   LI.148
        END                                                                      LI.149
C----------------------------------------------                                  LI.150
        FUNCTION PR_THTE  ( PRES, TMPC, DWPC )                                   LI.151
          PARAMETER (RMISSD = -999)                                              LI.152
C* FIND MIXING RATIO; CHECK FOR BAD VALUES.                                      LI.153
            RMIX = PR_MIXR  ( DWPC, PRES )                                       LI.154
C* CHANGE DEGREES CELSIUS TO KELVIN.                                             LI.155
            TMPK = TMPC + 273.16                                                 LI.156
C*  CALCULATE  THETA-M  (THETA FOR MOIST AIR)                                    LI.157
            E = (2./7.) * (1. - (.28 * .001 * RMIX) )                            LI.158
            THTAM = TMPK * (1000. / PRES) ** E                                   LI.159
C*   FIND THE TEMPERATURE AT THE LCL.                                            LI.160
            TLCL = PR_TLCL ( TMPC, DWPC )                                        LI.161
            E = ((3.376 /TLCL) - .00254) * (RMIX * (1. + .81*.001*RMIX))         LI.162
            PR_THTE = THTAM * EXP (E)                                            LI.163
        RETURN                                                                   LI.164
        END                                                                      LI.165
C--------------------                                                            LI.166
        FUNCTION PR_MIXR  ( DWPC, PRES )                                         LI.167
C*    CALCULATE VAPOR PRESSURE.                                                  LI.168
         VAPR = 6.112 * EXP (( 17.67 * DWPC ) / ( DWPC + 243.5 ))                LI.169
C*    CORR IS A CORRECTION TO THE VAPOR PRESSURE                                 LI.170
C*    SINCE THE ATMOSPHERE IS NOT AN IDEAL GAS.                                  LI.171
         CORR = (1.001 + (( PRES - 100.) / 900.) * .0034)                        LI.172
         E    = CORR * VAPR                                                      LI.173
C*    CALCULATE MIXING RATIO.                                                    LI.174
         PR_MIXR = .62197 * (E / (PRES - E)) * 1000.                             LI.175
        RETURN                                                                   LI.176
        END                                                                      LI.177
C-----------------                                                               LI.178
        FUNCTION PR_TLCL  ( TMPC, DWPC )                                         LI.179
            TMPK = TMPC + 273.16                                                 LI.180
            DWPK = DWPC + 273.16                                                 LI.181
            PR_TLCL = (1. / (1. / (DWPK - 56.) + ALOG (TMPK / DWPK) /            LI.182
     +                                           800.)) + 56.                    LI.183
        RETURN                                                                   LI.184
        END                                                                      LI.185
                                                                                 LI.186
